/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetNetworkSourceRequest
extends BmcRequest<Void> {
    private String networkSourceId;

    public String getNetworkSourceId() {
        return this.networkSourceId;
    }

    public Builder toBuilder() {
        return new Builder().networkSourceId(this.networkSourceId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",networkSourceId=").append(String.valueOf(this.networkSourceId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetNetworkSourceRequest)) {
            return false;
        }
        GetNetworkSourceRequest other = (GetNetworkSourceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.networkSourceId, other.networkSourceId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.networkSourceId == null ? 43 : this.networkSourceId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetNetworkSourceRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String networkSourceId = null;

        public Builder networkSourceId(String networkSourceId) {
            this.networkSourceId = networkSourceId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetNetworkSourceRequest o) {
            this.networkSourceId(o.getNetworkSourceId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetNetworkSourceRequest build() {
            GetNetworkSourceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetNetworkSourceRequest buildWithoutInvocationCallback() {
            GetNetworkSourceRequest request = new GetNetworkSourceRequest();
            request.networkSourceId = this.networkSourceId;
            return request;
        }
    }
}

