/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.debugger.registry;

import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.spi.debugger.ContextAwareSupport;
import org.netbeans.spi.debugger.ContextProvider;

public class ContextAwareServiceHandler
implements InvocationHandler {
    public static final String SERVICE_NAME = "serviceName";
    public static final String SERVICE_CLASSES = "serviceClasses";
    public static final String SERVICE_ACTIONS = "debugger_actions";
    public static final String SERVICE_ENABLED_MIMETYPES = "debugger_activateForMIMETypes";
    private String serviceName;
    private Class[] serviceClasses;
    private Map methodValues;
    private Object delegate;
    private Map<ContextProvider, WeakReference<Object>> contextInstances = new WeakHashMap<ContextProvider, WeakReference<Object>>();
    private WeakReference<Object> noContextInstance = new WeakReference<Object>(null);

    public ContextAwareServiceHandler(String serviceName, Class[] serviceClasses, Map methodValues) {
        this(serviceName, serviceClasses, methodValues, null);
    }

    private ContextAwareServiceHandler(String serviceName, Class[] serviceClasses, Map methodValues, ContextProvider context) {
        this.serviceName = serviceName;
        this.serviceClasses = serviceClasses;
        this.methodValues = methodValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName.equals("forContext")) {
            if (args.length != 1) {
                throw new IllegalArgumentException("Have " + args.length + " arguments, expecting one argument.");
            }
            if (args[0] != null && !(args[0] instanceof ContextProvider)) {
                throw new IllegalArgumentException("Argument " + String.valueOf(args[0]) + " is not an instance of ContextProvider.");
            }
            ContextProvider context = (ContextProvider)args[0];
            ContextAwareServiceHandler contextAwareServiceHandler = this;
            synchronized (contextAwareServiceHandler) {
                Object instance;
                if (context == null) {
                    instance = this.noContextInstance.get();
                } else {
                    WeakReference<Object> ref = this.contextInstances.get(context);
                    instance = ref != null ? ref.get() : null;
                    Object v0 = instance;
                }
                if (instance == null) {
                    instance = ContextAwareSupport.createInstance(this.serviceName, context);
                    if (context == null) {
                        this.noContextInstance = new WeakReference(instance);
                    } else {
                        this.contextInstances.put(context, new WeakReference(instance));
                    }
                }
                return instance;
            }
        }
        if (method.getName().equals("toString")) {
            return ContextAwareServiceHandler.class.getSimpleName() + " for " + this.serviceName;
        }
        throw new UnsupportedOperationException("Method " + method.getName() + " with arguments " + String.valueOf(args == null ? null : Arrays.asList(args)) + " can not be called on this virtual object!");
    }
}

