/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.karma.exec;

import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.karma.exec.KarmaServer;
import org.netbeans.modules.javascript.karma.exec.KarmaServersListener;
import org.openide.util.RequestProcessor;

public final class KarmaServers {
    private static final Logger LOGGER = Logger.getLogger(KarmaServers.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(KarmaServers.class.getName(), 1);
    private static final KarmaServers INSTANCE = new KarmaServers();
    private final ConcurrentMap<Project, KarmaServerInfo> karmaServers = new ConcurrentHashMap<Project, KarmaServerInfo>();
    private final KarmaServersListener.Support listenerSupport = new KarmaServersListener.Support();
    private final ChangeListener serverListener = new ServerListener();

    private KarmaServers() {
    }

    public static KarmaServers getInstance() {
        return INSTANCE;
    }

    public void addKarmaServersListener(KarmaServersListener listener) {
        this.listenerSupport.addKarmaServersListener(listener);
    }

    public void removeKarmaServersListener(KarmaServersListener listener) {
        this.listenerSupport.removeKarmaServersListener(listener);
    }

    public void startServer(final Project project) {
        RP.post(new Runnable(){
            final /* synthetic */ KarmaServers this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.startServerInternal(project);
            }
        });
    }

    void startServerInternal(Project project) {
        assert (RP.isRequestProcessorThread());
        if (this.isServerRunning(project)) {
            return;
        }
        KarmaServerInfo serverInfo = (KarmaServerInfo)this.karmaServers.get(project);
        if (serverInfo == null) {
            serverInfo = new KarmaServerInfo();
            KarmaServerInfo prevServerInfo = this.karmaServers.putIfAbsent(project, serverInfo);
            assert (prevServerInfo == null) : serverInfo;
        }
        assert (serverInfo.getServer() == null) : serverInfo;
        KarmaServer karmaServer = new KarmaServer(serverInfo.getPort(), project);
        serverInfo.setServer(karmaServer);
        karmaServer.addChangeListener(this.serverListener);
        if (!karmaServer.start()) {
            serverInfo.setServer(null);
        }
    }

    public void stopServer(final Project project, final boolean cleanup) {
        RP.post(new Runnable(){
            final /* synthetic */ KarmaServers this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.stopServerInternal(project, cleanup);
            }
        });
    }

    void stopServerInternal(Project project, boolean cleanup) {
        assert (RP.isRequestProcessorThread());
        KarmaServerInfo serverInfo = (KarmaServerInfo)this.karmaServers.get(project);
        if (serverInfo == null) {
            return;
        }
        KarmaServer karmaServer = serverInfo.getServer();
        if (karmaServer != null) {
            karmaServer.stop();
            karmaServer.removeChangeListener(this.serverListener);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                LOGGER.log(Level.INFO, null, ex);
                Thread.currentThread().interrupt();
            }
        }
        if (cleanup) {
            this.karmaServers.remove(project);
        } else {
            serverInfo.setServer(null);
        }
    }

    public synchronized void restartServer(final Project project) {
        RP.post(new Runnable(){
            final /* synthetic */ KarmaServers this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.restartServerInternal(project);
            }
        });
    }

    void restartServerInternal(Project project) {
        assert (RP.isRequestProcessorThread());
        this.stopServerInternal(project, false);
        this.startServerInternal(project);
    }

    public void runTests(final Project project) {
        RP.post(new Runnable(){
            final /* synthetic */ KarmaServers this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.runTestsInternal(project);
            }
        });
    }

    void runTestsInternal(Project project) {
        assert (RP.isRequestProcessorThread());
        this.startServerInternal(project);
        KarmaServerInfo serverInfo = (KarmaServerInfo)this.karmaServers.get(project);
        assert (serverInfo != null);
        KarmaServer karmaServer = serverInfo.getServer();
        if (karmaServer != null) {
            karmaServer.runTests();
        }
    }

    public boolean isServerStarting(Project project) {
        KarmaServer karmaServer = this.getKarmaServer(project);
        if (karmaServer == null) {
            return false;
        }
        return karmaServer.isStarting();
    }

    public boolean isServerStarted(Project project) {
        KarmaServer karmaServer = this.getKarmaServer(project);
        if (karmaServer == null) {
            return false;
        }
        return karmaServer.isStarted();
    }

    public boolean isServerRunning(Project project) {
        KarmaServer karmaServer = this.getKarmaServer(project);
        if (karmaServer == null) {
            return false;
        }
        return karmaServer.isRunning();
    }

    @CheckForNull
    public String getServerUrl(Project project, @NullAllowed String path) {
        KarmaServer karmaServer = this.getKarmaServer(project);
        if (karmaServer == null) {
            return null;
        }
        return karmaServer.getServerUrl(path);
    }

    public boolean servesUrl(Project project, URL url) {
        KarmaServer karmaServer = this.getKarmaServer(project);
        if (karmaServer == null) {
            return false;
        }
        return karmaServer.servesUrl(url);
    }

    public void closeDebugUrl(Project project) {
        KarmaServer karmaServer = this.getKarmaServer(project);
        if (karmaServer == null) {
            return;
        }
        karmaServer.closeDebugUrl();
    }

    @CheckForNull
    private KarmaServer getKarmaServer(Project project) {
        KarmaServerInfo serverInfo = (KarmaServerInfo)this.karmaServers.get(project);
        if (serverInfo == null) {
            return null;
        }
        return serverInfo.getServer();
    }

    void fireServerChange(KarmaServer karmaServer) {
        assert (karmaServer != null);
        this.listenerSupport.fireServerChanged(karmaServer);
    }

    private final class ServerListener
    implements ChangeListener {
        private ServerListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            KarmaServers.this.fireServerChange((KarmaServer)e.getSource());
        }
    }

    private static final class KarmaServerInfo {
        private static final AtomicInteger CURRENT_PORT = new AtomicInteger(9876);
        private final int port = CURRENT_PORT.getAndIncrement();
        private volatile KarmaServer server;

        public int getPort() {
            return this.port;
        }

        @CheckForNull
        public KarmaServer getServer() {
            return this.server;
        }

        public void setServer(KarmaServer karmaServer) {
            this.server = karmaServer;
        }

        public String toString() {
            return "KarmaServerInfo{port=" + this.port + ", server=" + this.server + '}';
        }
    }
}

