/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AllowedPhaseOneParameters
extends ExplicitlySetBmcModel {
    @JsonProperty(value="encryptionAlgorithms")
    private final List<String> encryptionAlgorithms;
    @JsonProperty(value="authenticationAlgorithms")
    private final List<String> authenticationAlgorithms;
    @JsonProperty(value="dhGroups")
    private final List<String> dhGroups;

    @Deprecated
    @ConstructorProperties(value={"encryptionAlgorithms", "authenticationAlgorithms", "dhGroups"})
    public AllowedPhaseOneParameters(List<String> encryptionAlgorithms, List<String> authenticationAlgorithms, List<String> dhGroups) {
        this.encryptionAlgorithms = encryptionAlgorithms;
        this.authenticationAlgorithms = authenticationAlgorithms;
        this.dhGroups = dhGroups;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<String> getEncryptionAlgorithms() {
        return this.encryptionAlgorithms;
    }

    public List<String> getAuthenticationAlgorithms() {
        return this.authenticationAlgorithms;
    }

    public List<String> getDhGroups() {
        return this.dhGroups;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AllowedPhaseOneParameters(");
        sb.append("super=").append(super.toString());
        sb.append("encryptionAlgorithms=").append(String.valueOf(this.encryptionAlgorithms));
        sb.append(", authenticationAlgorithms=").append(String.valueOf(this.authenticationAlgorithms));
        sb.append(", dhGroups=").append(String.valueOf(this.dhGroups));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AllowedPhaseOneParameters)) {
            return false;
        }
        AllowedPhaseOneParameters other = (AllowedPhaseOneParameters)((Object)o);
        return Objects.equals(this.encryptionAlgorithms, other.encryptionAlgorithms) && Objects.equals(this.authenticationAlgorithms, other.authenticationAlgorithms) && Objects.equals(this.dhGroups, other.dhGroups) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.encryptionAlgorithms == null ? 43 : this.encryptionAlgorithms.hashCode());
        result = result * 59 + (this.authenticationAlgorithms == null ? 43 : this.authenticationAlgorithms.hashCode());
        result = result * 59 + (this.dhGroups == null ? 43 : this.dhGroups.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="encryptionAlgorithms")
        private List<String> encryptionAlgorithms;
        @JsonProperty(value="authenticationAlgorithms")
        private List<String> authenticationAlgorithms;
        @JsonProperty(value="dhGroups")
        private List<String> dhGroups;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder encryptionAlgorithms(List<String> encryptionAlgorithms) {
            this.encryptionAlgorithms = encryptionAlgorithms;
            this.__explicitlySet__.add("encryptionAlgorithms");
            return this;
        }

        public Builder authenticationAlgorithms(List<String> authenticationAlgorithms) {
            this.authenticationAlgorithms = authenticationAlgorithms;
            this.__explicitlySet__.add("authenticationAlgorithms");
            return this;
        }

        public Builder dhGroups(List<String> dhGroups) {
            this.dhGroups = dhGroups;
            this.__explicitlySet__.add("dhGroups");
            return this;
        }

        public AllowedPhaseOneParameters build() {
            AllowedPhaseOneParameters model = new AllowedPhaseOneParameters(this.encryptionAlgorithms, this.authenticationAlgorithms, this.dhGroups);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AllowedPhaseOneParameters model) {
            if (model.wasPropertyExplicitlySet("encryptionAlgorithms")) {
                this.encryptionAlgorithms(model.getEncryptionAlgorithms());
            }
            if (model.wasPropertyExplicitlySet("authenticationAlgorithms")) {
                this.authenticationAlgorithms(model.getAuthenticationAlgorithms());
            }
            if (model.wasPropertyExplicitlySet("dhGroups")) {
                this.dhGroups(model.getDhGroups());
            }
            return this;
        }
    }
}

