/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.core.model.UpdateVlanDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateVlanRequest
extends BmcRequest<UpdateVlanDetails> {
    private String vlanId;
    private UpdateVlanDetails updateVlanDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getVlanId() {
        return this.vlanId;
    }

    public UpdateVlanDetails getUpdateVlanDetails() {
        return this.updateVlanDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateVlanDetails getBody$() {
        return this.updateVlanDetails;
    }

    public Builder toBuilder() {
        return new Builder().vlanId(this.vlanId).updateVlanDetails(this.updateVlanDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",vlanId=").append(String.valueOf(this.vlanId));
        sb.append(",updateVlanDetails=").append(String.valueOf((Object)this.updateVlanDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateVlanRequest)) {
            return false;
        }
        UpdateVlanRequest other = (UpdateVlanRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.vlanId, other.vlanId) && Objects.equals((Object)this.updateVlanDetails, (Object)other.updateVlanDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.vlanId == null ? 43 : this.vlanId.hashCode());
        result = result * 59 + (this.updateVlanDetails == null ? 43 : this.updateVlanDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateVlanRequest, UpdateVlanDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String vlanId = null;
        private UpdateVlanDetails updateVlanDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder vlanId(String vlanId) {
            this.vlanId = vlanId;
            return this;
        }

        public Builder updateVlanDetails(UpdateVlanDetails updateVlanDetails) {
            this.updateVlanDetails = updateVlanDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateVlanRequest o) {
            this.vlanId(o.getVlanId());
            this.updateVlanDetails(o.getUpdateVlanDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateVlanRequest build() {
            UpdateVlanRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateVlanDetails body) {
            this.updateVlanDetails(body);
            return this;
        }

        public UpdateVlanRequest buildWithoutInvocationCallback() {
            UpdateVlanRequest request = new UpdateVlanRequest();
            request.vlanId = this.vlanId;
            request.updateVlanDetails = this.updateVlanDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

