/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.profiler.ProfilerTopComponent;
import org.netbeans.modules.profiler.api.ActionsSupport;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.snaptracer.impl.Bundle;
import org.netbeans.modules.profiler.snaptracer.impl.IdeSnapshot;
import org.netbeans.modules.profiler.snaptracer.impl.TracerController;
import org.netbeans.modules.profiler.snaptracer.impl.TracerModel;
import org.netbeans.modules.profiler.snaptracer.impl.TracerSupportImpl;
import org.netbeans.modules.profiler.snaptracer.impl.TracerView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class IdeSnapshotAction
implements ActionListener {
    private File lastDirectory;

    @Override
    public void actionPerformed(ActionEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                File file = IdeSnapshotAction.this.snapshotFile();
                if (file == null) {
                    return;
                }
                IdeSnapshotAction.openSnapshot(FileUtil.toFileObject((File)file));
            }
        });
    }

    static void openSnapshot(final FileObject primary) {
        TracerSupportImpl.getInstance().perform(new Runnable(){

            @Override
            public void run() {
                try {
                    FileObject uigestureFO = primary.getParent().getFileObject(primary.getName(), "log");
                    IdeSnapshot snapshot = new IdeSnapshot(primary, uigestureFO);
                    IdeSnapshotAction.openSnapshotImpl(snapshot);
                }
                catch (Throwable t) {
                    ProfilerDialogs.displayError((String)Bundle.MSG_SnapshotLoadFailedMsg(primary.getNameExt(), t.getLocalizedMessage()));
                }
            }
        });
    }

    private static void openSnapshotImpl(final IdeSnapshot snapshot) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TracerModel model = new TracerModel(snapshot);
                TracerController controller = new TracerController(model);
                TopComponent ui = IdeSnapshotAction.ui(model, controller, snapshot.getNpssFileObject());
                ui.open();
                ui.requestActive();
            }
        });
    }

    private static TopComponent ui(TracerModel model, TracerController controller, FileObject snapshotFo) {
        String npssFileName = snapshotFo.getName();
        IdeSnapshotComponent tc = new IdeSnapshotComponent(npssFileName, FileUtil.toFile((FileObject)snapshotFo));
        final JComponent tracer = new TracerView(model, controller).createComponent();
        tc.add(tracer, "Center");
        InputMap inputMap = tc.getInputMap(1);
        ActionMap actionMap = tc.getActionMap();
        String filterKey = "filter-action-key";
        AbstractAction filterAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Action action = tracer.getActionMap().get("filter-action-key");
                if (action != null && action.isEnabled()) {
                    action.actionPerformed(e);
                }
            }
        };
        ActionsSupport.registerAction((String)"filter-action-key", (Action)filterAction, (ActionMap)actionMap, (InputMap)inputMap);
        String findKey = "find-action-key";
        AbstractAction findAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Action action = tracer.getActionMap().get("find-action-key");
                if (action != null && action.isEnabled()) {
                    action.actionPerformed(e);
                }
            }
        };
        ActionsSupport.registerAction((String)"find-action-key", (Action)findAction, (ActionMap)actionMap, (InputMap)inputMap);
        return tc;
    }

    private File snapshotFile() {
        Frame mainWindow;
        JFileChooser chooser = IdeSnapshotAction.createFileChooser(this.lastDirectory);
        if (chooser.showOpenDialog(mainWindow = WindowManager.getDefault().getMainWindow()) == 0) {
            this.lastDirectory = chooser.getCurrentDirectory();
            return chooser.getSelectedFile();
        }
        return null;
    }

    private static JFileChooser createFileChooser(File directory) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(Bundle.ACTION_IdeSnapshot_dialog());
        chooser.setDialogType(0);
        chooser.setFileSelectionMode(0);
        chooser.setAcceptAllFileFilterUsed(false);
        if (directory != null) {
            chooser.setCurrentDirectory(directory);
        }
        String descr = Bundle.ACTION_IdeSnapshot_filter();
        String ext = ".npss";
        Filter filter = Filter.create(descr, ext);
        chooser.addChoosableFileFilter(filter);
        return chooser;
    }

    private static class IdeSnapshotComponent
    extends ProfilerTopComponent {
        IdeSnapshotComponent(String displayName, File npssFile) {
            this.setDisplayName(displayName);
            if (npssFile != null) {
                this.putClientProperty("nb.recent.file.path", npssFile);
                this.setToolTipText(npssFile.getAbsolutePath());
            }
            this.setLayout(new BorderLayout());
        }

        public int getPersistenceType() {
            return 2;
        }
    }

    private static abstract class Filter
    extends FileFilter {
        abstract String getExt();

        static Filter create(final String descr, final String ext) {
            return new Filter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || Filter.getFileExt(f.getName()).equals(ext);
                }

                @Override
                public String getExt() {
                    return ext;
                }

                @Override
                public String getDescription() {
                    return descr + " (*" + ext + ")";
                }
            };
        }

        private static String getFileExt(String fileName) {
            int extIndex = fileName.lastIndexOf(46);
            if (extIndex == -1) {
                return "";
            }
            return fileName.substring(extIndex);
        }

        private Filter() {
        }
    }
}

