/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.cli.commands;

import java.io.File;
import java.io.IOException;
import org.netbeans.modules.subversion.client.cli.SvnCommand;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class MoveCommand
extends SvnCommand {
    private final MoveType type;
    private final SVNUrl fromUrl;
    private final SVNUrl toUrl;
    private final File fromFile;
    private final File toFile;
    private final String msg;
    private final SVNRevision rev;
    private final boolean force;

    public MoveCommand(SVNUrl fromUrl, SVNUrl toUrl, String msg, SVNRevision rev) {
        this.fromUrl = fromUrl;
        this.toUrl = toUrl;
        this.msg = msg;
        this.rev = rev;
        this.fromFile = null;
        this.toFile = null;
        this.force = false;
        this.type = MoveType.url2url;
    }

    public MoveCommand(File fromFile, File toFile, boolean force) {
        this.fromFile = fromFile;
        this.toFile = toFile;
        this.force = force;
        this.toUrl = null;
        this.fromUrl = null;
        this.msg = null;
        this.rev = null;
        this.type = MoveType.file2file;
    }

    @Override
    protected int getCommand() {
        return 5;
    }

    @Override
    public void prepareCommand(SvnCommand.Arguments arguments) throws IOException {
        arguments.add("move");
        switch (this.type.ordinal()) {
            case 0: {
                arguments.add(this.fromUrl);
                arguments.addNonExistent(this.toUrl);
                arguments.add(this.rev);
                arguments.addMessage(this.msg);
                this.setCommandWorkingDirectory(new File("."));
                break;
            }
            case 1: {
                arguments.add(this.fromFile);
                arguments.add(this.toFile.getAbsolutePath());
                if (this.force) {
                    arguments.add("--force");
                }
                this.setCommandWorkingDirectory(this.fromFile, this.toFile);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal copytype: " + (Object)((Object)this.type));
            }
        }
    }

    private static enum MoveType {
        url2url,
        file2file;

    }
}

