/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.wsit;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.model.wsdl.WSDLModel;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.transport.tcp.client.ServiceChannelTransportPipe;
import com.sun.xml.ws.transport.tcp.client.TCPTransportPipe;
import com.sun.xml.ws.transport.tcp.servicechannel.stubs.ServiceChannelWSImplService;
import com.sun.xml.ws.transport.tcp.wsit.PolicyConnectionManagementSettingsHolder;
import com.sun.xml.ws.transport.tcp.wsit.TCPConstants;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;

public class TCPTransportPipeFactory
extends com.sun.xml.ws.transport.tcp.client.TCPTransportPipeFactory {
    private static final QName serviceChannelServiceName = new ServiceChannelWSImplService().getServiceName();

    @Override
    public Tube doCreate(ClientTubeAssemblerContext context) {
        return TCPTransportPipeFactory.doCreate(context, true);
    }

    public static Tube doCreate(@NotNull ClientTubeAssemblerContext context, boolean checkSchema) {
        if (checkSchema && !"vnd.sun.ws.tcp".equalsIgnoreCase(context.getAddress().getURI().getScheme())) {
            return null;
        }
        TCPTransportPipeFactory.initializeConnectionManagement(context.getWsdlModel());
        if (context.getService().getServiceName().equals(serviceChannelServiceName)) {
            return new ServiceChannelTransportPipe(context);
        }
        return new TCPTransportPipe(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeConnectionManagement(WSDLPort port) {
        PolicyConnectionManagementSettingsHolder instance = PolicyConnectionManagementSettingsHolder.getInstance();
        if (instance.clientSettings == null) {
            PolicyConnectionManagementSettingsHolder policyConnectionManagementSettingsHolder = instance;
            synchronized (policyConnectionManagementSettingsHolder) {
                if (instance.clientSettings == null) {
                    instance.clientSettings = PolicyConnectionManagementSettingsHolder.createSettingsInstance(port);
                }
            }
        }
    }

    private static int retrieveCustomTCPPort(WSDLPort port) {
        try {
            PolicyMapKey endpointKey;
            Policy policy;
            WSDLModel model = port.getBinding().getOwner();
            PolicyMap policyMap = model.getPolicyMap();
            if (policyMap != null && (policy = policyMap.getEndpointEffectivePolicy(endpointKey = PolicyMap.createWsdlEndpointScopeKey(port.getOwner().getName(), port.getName()))) != null && policy.contains(TCPConstants.TCPTRANSPORT_POLICY_ASSERTION)) {
                for (AssertionSet assertionSet : policy) {
                    for (PolicyAssertion assertion : assertionSet) {
                        if (!assertion.getName().equals(TCPConstants.TCPTRANSPORT_POLICY_ASSERTION)) continue;
                        String value = assertion.getAttributeValue(new QName("port"));
                        if (value == null) {
                            return -1;
                        }
                        value = value.trim();
                        try {
                            return Integer.parseInt(value);
                        }
                        catch (NumberFormatException numberFormatException) {
                            return -1;
                        }
                    }
                }
            }
            return -1;
        }
        catch (PolicyException e) {
            throw new WebServiceException(e);
        }
    }
}

