/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.debug;

import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementScanner9;
import javax.tools.JavaFileObject;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.java.debug.OffsetProvider;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;

public class ElementNode
extends AbstractNode
implements OffsetProvider {
    private Element element;
    private CompilationInfo info;

    public static Node getTree(CompilationInfo info, Element element) {
        ArrayList result = new ArrayList();
        new FindChildrenElementVisitor(info).scan(element, result);
        return (Node)result.get(0);
    }

    public ElementNode(CompilationInfo info, Element element, List<Node> nodes) {
        super((Children)(nodes.isEmpty() ? Children.LEAF : new NodeChilren(nodes)));
        this.element = element;
        this.info = info;
        this.setDisplayName(element.getKind().toString() + ":" + element.toString());
        this.setIconBaseWithExtension("org/netbeans/modules/java/debug/resources/element.png");
    }

    @Override
    public int getStart() {
        final int[] result = new int[]{-1};
        try {
            JavaSource.create((ClasspathInfo)this.info.getClasspathInfo(), (FileObject[])new FileObject[0]).runUserActionTask((Task)new Task<CompilationController>(){
                final /* synthetic */ ElementNode this$0;
                {
                    this.this$0 = this$0;
                }

                public void run(CompilationController parameter) throws Exception {
                    Tree tree = this.this$0.info.getTrees().getTree(this.this$0.element);
                    if (tree != null) {
                        result[0] = (int)this.this$0.info.getTrees().getSourcePositions().getStartPosition(this.this$0.info.getCompilationUnit(), tree);
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return result[0];
    }

    @Override
    public int getEnd() {
        final int[] result = new int[]{-1};
        try {
            JavaSource.create((ClasspathInfo)this.info.getClasspathInfo(), (FileObject[])new FileObject[0]).runUserActionTask((Task)new Task<CompilationController>(){
                final /* synthetic */ ElementNode this$0;
                {
                    this.this$0 = this$0;
                }

                public void run(CompilationController parameter) throws Exception {
                    Tree tree = this.this$0.info.getTrees().getTree(this.this$0.element);
                    if (tree != null) {
                        result[0] = (int)this.this$0.info.getTrees().getSourcePositions().getEndPosition(this.this$0.info.getCompilationUnit(), tree);
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return result[0];
    }

    @Override
    public int getPreferredPosition() {
        return -1;
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set ps = new Sheet.Set();
        ps.setName("origins");
        ps.setDisplayName("Origins");
        ps.setShortDescription("Origins");
        ps.put(new Node.Property[]{new PropertySupport.ReadOnly<String>("sourcefile", String.class, "sourcefile", "sourcefile"){

            public String getValue() throws IllegalAccessException, InvocationTargetException {
                if (ElementNode.this.element instanceof Symbol.ClassSymbol) {
                    JavaFileObject file = ((Symbol.ClassSymbol)((ElementNode)ElementNode.this).element).sourcefile;
                    if (file != null) {
                        return file.toUri().toString();
                    }
                    return "No sourcefile set";
                }
                return "Not a ClassSymbol";
            }
        }, new PropertySupport.ReadOnly<String>("classfile", String.class, "classfile", "classfile"){

            public String getValue() throws IllegalAccessException, InvocationTargetException {
                if (ElementNode.this.element instanceof Symbol.ClassSymbol) {
                    JavaFileObject file = ((Symbol.ClassSymbol)((ElementNode)ElementNode.this).element).classfile;
                    if (file != null) {
                        return file.toUri().toString();
                    }
                    return "No classfile set";
                }
                return "Not a ClassSymbol";
            }
        }});
        sheet.put(ps);
        return sheet;
    }

    private static class FindChildrenElementVisitor
    extends ElementScanner9<Void, List<Node>> {
        private CompilationInfo info;

        public FindChildrenElementVisitor(CompilationInfo info) {
            this.info = info;
        }

        @Override
        public Void visitPackage(PackageElement e, List<Node> p) {
            ArrayList<Node> below = new ArrayList<Node>();
            super.visitPackage(e, below);
            p.add((Node)new ElementNode(this.info, e, below));
            return null;
        }

        @Override
        public Void visitType(TypeElement e, List<Node> p) {
            ArrayList<Node> below = new ArrayList<Node>();
            super.visitType(e, below);
            p.add((Node)new ElementNode(this.info, e, below));
            return null;
        }

        @Override
        public Void visitVariable(VariableElement e, List<Node> p) {
            ArrayList<Node> below = new ArrayList<Node>();
            super.visitVariable(e, below);
            p.add((Node)new ElementNode(this.info, e, below));
            return null;
        }

        @Override
        public Void visitExecutable(ExecutableElement e, List<Node> p) {
            ArrayList<Node> below = new ArrayList<Node>();
            super.visitExecutable(e, below);
            p.add((Node)new ElementNode(this.info, e, below));
            return null;
        }

        @Override
        public Void visitTypeParameter(TypeParameterElement e, List<Node> p) {
            ArrayList<Node> below = new ArrayList<Node>();
            super.visitTypeParameter(e, below);
            p.add((Node)new ElementNode(this.info, e, below));
            return null;
        }

        @Override
        public Void visitModule(ModuleElement e, List<Node> p) {
            ArrayList<Node> below = new ArrayList<Node>();
            super.visitModule(e, below);
            p.add((Node)new ElementNode(this.info, e, below));
            return null;
        }

        @Override
        public Void visitUnknown(Element e, List<Node> p) {
            ArrayList<Node> below = new ArrayList<Node>();
            p.add((Node)new ElementNode(this.info, e, below));
            return null;
        }
    }

    private static final class NodeChilren
    extends Children.Keys<Node> {
        public NodeChilren(List<Node> nodes) {
            this.setKeys(nodes);
        }

        protected Node[] createNodes(Node key) {
            return new Node[]{key};
        }
    }
}

