/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.actions;

import java.io.File;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.git.ui.actions.GitAction;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.nodes.Node;

public abstract class SingleRepositoryAction
extends GitAction {
    private static final Logger LOG = Logger.getLogger(SingleRepositoryAction.class.getName());

    protected SingleRepositoryAction() {
        this(null);
    }

    protected SingleRepositoryAction(String iconResource) {
        super(iconResource);
    }

    @Override
    protected final void performContextAction(final Node[] nodes) {
        Utils.postParallel((Runnable)new Runnable(){
            final /* synthetic */ SingleRepositoryAction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                VCSContext context = this.this$0.getCurrentContext(nodes);
                this.this$0.performAction(context);
            }
        }, (int)0);
    }

    public final void performAction(VCSContext context) {
        Map.Entry<File, File[]> actionRoots = SingleRepositoryAction.getActionRoots(context);
        if (actionRoots != null) {
            GitUtils.logRemoteRepositoryAccess(actionRoots.getKey());
            this.performAction(actionRoots.getKey(), actionRoots.getValue(), context);
        }
    }

    protected abstract void performAction(File var1, File[] var2, VCSContext var3);

    protected static Map.Entry<File, File[]> getActionRoots(VCSContext context) {
        Set<File> repositories = GitUtils.getRepositoryRoots(context);
        if (repositories.isEmpty()) {
            LOG.log(Level.FINE, "No repository in the given context: {0}", context.getRootFiles());
            return null;
        }
        AbstractMap.SimpleImmutableEntry<File, File[]> actionRoots = GitUtils.getActionRoots(context);
        if (actionRoots != null) {
            File repository = actionRoots.getKey();
            if (repositories.size() > 1) {
                LOG.log(Level.FINE, "Multiple repositories in the given context: {0}, selected {1}", new Object[]{context.getRootFiles(), repository});
            }
        }
        return actionRoots;
    }
}

