/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.history;

import java.awt.EventQueue;
import java.io.File;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.modules.git.ui.actions.MultipleRepositoryAction;
import org.netbeans.modules.git.ui.history.Bundle;
import org.netbeans.modules.git.ui.history.SearchIncomingTopComponent;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.RequestProcessor;

public abstract class SearchIncoming
extends MultipleRepositoryAction {
    private final boolean searchInContext;

    protected SearchIncoming(boolean searchInContext) {
        this.searchInContext = searchInContext;
    }

    @Override
    protected RequestProcessor.Task performAction(File repository, File[] roots, VCSContext context) {
        this.openSearch(repository, roots, Utils.getContextDisplayName((VCSContext)context));
        return null;
    }

    public void openSearch(File repository, File[] roots, String contextName) {
        String branchName = SearchIncoming.getActiveBranchName(repository);
        if (branchName.equals("(no branch)")) {
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)Bundle.MSG_SearchIncomingTopComponent_err_noBranch(), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            return;
        }
        this.openSearch(repository, roots, branchName, contextName);
    }

    public void openSearch(final File repository, final File[] roots, final String branchName, String contextName) {
        final String title = Bundle.LBL_SearchIncomingTopComponent_title(contextName, branchName);
        final RepositoryInfo info = RepositoryInfo.getInstance(repository);
        EventQueue.invokeLater(new Runnable(){
            final /* synthetic */ SearchIncoming this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                SearchIncomingTopComponent tc = new SearchIncomingTopComponent(repository, info, roots, this.this$0.searchInContext);
                tc.setBranch(branchName);
                tc.setDisplayName(title);
                tc.open();
                tc.requestActive();
                tc.search(true);
            }
        });
    }

    private static String getActiveBranchName(File repository) {
        GitBranch activeBranch = RepositoryInfo.getInstance(repository).getActiveBranch();
        String branchName = "(no branch)";
        if (activeBranch != GitBranch.NO_BRANCH_INSTANCE) {
            branchName = activeBranch.getName();
        }
        return branchName;
    }
}

