/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.context;

import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import org.primefaces.cache.CacheProvider;
import org.primefaces.cache.DefaultCacheProvider;
import org.primefaces.config.ConfigContainer;
import org.primefaces.context.ApplicationContext;

public class DefaultApplicationContext
extends ApplicationContext {
    private ConfigContainer config;
    private ValidatorFactory validatorFactory;
    private CacheProvider cacheProvider;

    public DefaultApplicationContext(FacesContext context) {
        this.config = new ConfigContainer(context);
        if (this.config.isBeanValidationAvailable()) {
            this.validatorFactory = Validation.buildDefaultValidatorFactory();
        }
    }

    public ConfigContainer getConfig() {
        return this.config;
    }

    public ValidatorFactory getValidatorFactory() {
        return this.validatorFactory;
    }

    public CacheProvider getCacheProvider() {
        if (this.cacheProvider == null) {
            this.initCacheProvider();
        }
        return this.cacheProvider;
    }

    protected synchronized void initCacheProvider() {
        if (this.cacheProvider == null) {
            String cacheProviderConfigValue = FacesContext.getCurrentInstance().getExternalContext().getInitParameter("primefaces.CACHE_PROVIDER");
            if (cacheProviderConfigValue == null) {
                this.cacheProvider = new DefaultCacheProvider();
            } else {
                try {
                    this.cacheProvider = (CacheProvider)Class.forName(cacheProviderConfigValue).newInstance();
                }
                catch (ClassNotFoundException ex) {
                    throw new FacesException((Throwable)ex);
                }
                catch (InstantiationException ex) {
                    throw new FacesException((Throwable)ex);
                }
                catch (IllegalAccessException ex) {
                    throw new FacesException((Throwable)ex);
                }
            }
        }
    }
}

