/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.axi.datatype;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.xml.axi.datatype.Datatype;
import org.netbeans.modules.xml.schema.model.Whitespace;

public abstract class TimeBase
extends Datatype {
    static List<Datatype.Facet> applicableFacets;
    private Datatype.Kind kind;
    protected List<String> patterns;
    protected List<String> enumerations;
    protected List<Whitespace.Treatment> whitespaces;
    protected List<String> maxInclusives;
    protected List<String> maxExclusives;
    protected List<String> minInclusives;
    protected List<String> minExclusives;
    private boolean hasFacets;
    private boolean isList;

    public TimeBase(Datatype.Kind kind) {
        this.kind = kind;
    }

    @Override
    public Datatype.Kind getKind() {
        return this.kind;
    }

    @Override
    public synchronized List<Datatype.Facet> getApplicableFacets() {
        if (applicableFacets == null) {
            ArrayList<Datatype.Facet> facets = new ArrayList<Datatype.Facet>();
            facets.add(Datatype.Facet.PATTERN);
            facets.add(Datatype.Facet.ENUMERATION);
            facets.add(Datatype.Facet.WHITESPACE);
            facets.add(Datatype.Facet.MAXINCLUSIVE);
            facets.add(Datatype.Facet.MAXEXCLUSIVE);
            facets.add(Datatype.Facet.MININCLUSIVE);
            facets.add(Datatype.Facet.MINEXCLUSIVE);
            applicableFacets = Collections.unmodifiableList(facets);
        }
        return applicableFacets;
    }

    @Override
    public boolean hasFacets() {
        return this.hasFacets;
    }

    @Override
    public boolean isList() {
        return this.isList;
    }

    @Override
    public void setIsList(boolean isList) {
        this.isList = isList;
    }

    public List<String> getPatterns() {
        return this.patterns;
    }

    public List<String> getEnumerations() {
        return this.enumerations;
    }

    @Override
    public List<Whitespace.Treatment> getWhiteSpaces() {
        return this.whitespaces;
    }

    public List<String> getMaxInclusives() {
        return this.maxInclusives;
    }

    public List<String> getMaxExclusives() {
        return this.maxExclusives;
    }

    public List<String> getMinInclusives() {
        return this.minInclusives;
    }

    public List<String> getMinExclusives() {
        return this.minExclusives;
    }

    @Override
    public void addPattern(String pattern) {
        if (this.patterns == null) {
            this.patterns = new ArrayList<String>(1);
            this.hasFacets = true;
        }
        this.patterns.add(pattern);
    }

    public void addEnumeration(String enumeration) {
        if (this.enumerations == null) {
            this.enumerations = new ArrayList<String>(1);
            this.hasFacets = true;
        }
        this.enumerations.add(enumeration);
    }

    @Override
    public void addWhitespace(Whitespace.Treatment whitespace) {
        if (this.whitespaces == null) {
            this.whitespaces = new ArrayList<Whitespace.Treatment>(1);
            this.hasFacets = true;
        }
        this.whitespaces.add(whitespace);
    }

    public void addMaxInclusive(String maxInclusive) {
        if (this.maxInclusives == null) {
            this.maxInclusives = new ArrayList<String>(1);
            this.hasFacets = true;
        }
        this.maxInclusives.add(maxInclusive);
    }

    public void addMaxExclusive(String maxExclusive) {
        if (this.maxExclusives == null) {
            this.maxExclusives = new ArrayList<String>(1);
            this.hasFacets = true;
        }
        this.maxExclusives.add(maxExclusive);
    }

    public void addMinInclusive(String minInclusive) {
        if (this.minInclusives == null) {
            this.minInclusives = new ArrayList<String>(1);
            this.hasFacets = true;
        }
        this.minInclusives.add(minInclusive);
    }

    public void addMinExclusive(String minExclusive) {
        if (this.minExclusives == null) {
            this.minExclusives = new ArrayList<String>(1);
            this.hasFacets = true;
        }
        this.minExclusives.add(minExclusive);
    }

    @Override
    public void removePattern(String pattern) {
        if (this.patterns != null) {
            this.patterns.remove(pattern);
        }
    }

    public void removeEnumeration(String enumeration) {
        if (this.enumerations != null) {
            this.enumerations.remove(enumeration);
        }
    }

    @Override
    public void removeWhitespace(Whitespace.Treatment whitespace) {
        if (this.whitespaces != null) {
            this.whitespaces.remove(whitespace);
        }
    }

    public void removeMaxInclusive(String maxInclusive) {
        if (this.maxInclusives != null) {
            this.maxInclusives.remove(maxInclusive);
        }
    }

    public void removeMaxExclusive(String maxExclusive) {
        if (this.maxExclusives != null) {
            this.maxExclusives.remove(maxExclusive);
        }
    }

    public void removeMinInclusive(String minInclusive) {
        if (this.minInclusives != null) {
            this.minInclusives.remove(minInclusive);
        }
    }

    public void removeMinExclusive(String minExclusive) {
        if (this.minExclusives != null) {
            this.minExclusives.remove(minExclusive);
        }
    }
}

