/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.project;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.apisupport.project.api.UIUtil;
import org.netbeans.modules.apisupport.project.ui.wizard.common.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.common.CreatedModifiedFiles;
import org.netbeans.modules.apisupport.project.ui.wizard.common.WizardUtils;
import org.netbeans.modules.apisupport.project.ui.wizard.project.NewProjectIterator;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

final class NameAndLocationPanel
extends BasicWizardIterator.Panel {
    private static final String PROJECT_TEMPLATES_DIR = "Templates/Project";
    private static final String DEFAULT_CATEGORY_PATH = "Templates/Project/Other";
    private static final RequestProcessor RP = new RequestProcessor(NameAndLocationPanel.class);
    private NewProjectIterator.DataModel data;
    private JComboBox comCategory;
    private JComboBox comPackageName;
    private JLabel createdFiles;
    private JTextArea createdFilesValue;
    private JLabel filler;
    private JLabel lblCategory;
    private JLabel lblDisplayName;
    private JLabel lblName;
    private JLabel lblPackageName;
    private JLabel lblProjectName;
    private JLabel modifiedFiles;
    private JTextArea modifiedFilesValue;
    private JTextField txtDisplayName;
    private JTextField txtName;
    private JTextField txtProjectName;

    NameAndLocationPanel(WizardDescriptor setting, NewProjectIterator.DataModel data) {
        super(setting);
        JTextField txt;
        this.data = data;
        this.initComponents();
        this.initAccessibility();
        Color lblBgr = UIManager.getColor("Label.background");
        this.putClientProperty("NewFileWizard_Title", NameAndLocationPanel.getMessage("LBL_ProjectWizardTitle"));
        this.modifiedFilesValue.setBackground(lblBgr);
        this.createdFilesValue.setBackground(lblBgr);
        this.modifiedFilesValue.setEditable(false);
        this.createdFilesValue.setEditable(false);
        UIUtil.DocumentAdapter dListener = new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent e) {
                if (NameAndLocationPanel.this.checkValidity()) {
                    NameAndLocationPanel.this.updateData();
                }
            }
        };
        this.txtName.getDocument().addDocumentListener((DocumentListener)dListener);
        this.txtDisplayName.getDocument().addDocumentListener((DocumentListener)dListener);
        if (this.comCategory.getEditor().getEditorComponent() instanceof JTextField) {
            txt = (JTextField)this.comCategory.getEditor().getEditorComponent();
            txt.getDocument().addDocumentListener((DocumentListener)dListener);
        }
        if (this.comPackageName.getEditor().getEditorComponent() instanceof JTextField) {
            txt = (JTextField)this.comPackageName.getEditor().getEditorComponent();
            txt.getDocument().addDocumentListener((DocumentListener)dListener);
        }
    }

    @Override
    protected void storeToDataModel() {
        this.updateData();
    }

    private String getCategoryPath() {
        String path = WizardUtils.getSFSPath(this.comCategory, PROJECT_TEMPLATES_DIR);
        return path == null ? DEFAULT_CATEGORY_PATH : path;
    }

    private void updateData() {
        this.data.setPackageName(this.comPackageName.getEditor().getItem().toString());
        this.data.setName(this.txtName.getText().trim());
        this.data.setDisplayName(this.txtDisplayName.getText().trim());
        this.data.setCategory(this.getCategoryPath());
        NewProjectIterator.generateFileChanges(this.data);
        CreatedModifiedFiles fls = this.data.getCreatedModifiedFiles();
        this.createdFilesValue.setText(NameAndLocationPanel.generateText(fls.getCreatedPaths()));
        this.modifiedFilesValue.setText(NameAndLocationPanel.generateText(fls.getModifiedPaths()));
        String[] invalid = this.data.getCreatedModifiedFiles().getInvalidPaths();
        if (invalid.length > 0) {
            this.setError(NbBundle.getMessage(NameAndLocationPanel.class, (String)"ERR_ToBeCreateFileExists", (Object)invalid[0]));
        }
    }

    @Override
    protected void readFromDataModel() {
        this.loadCombo();
        if (this.data.getPackageName() != null) {
            this.comPackageName.setSelectedItem(this.data.getPackageName());
        }
        this.checkValidity();
    }

    @Override
    protected String getPanelName() {
        return NameAndLocationPanel.getMessage("LBL_NameLocation_Title");
    }

    private boolean checkValidity() {
        if (!this.checkPlatformValidity()) {
            return false;
        }
        if (this.txtName.getText().trim().length() == 0) {
            this.setInfo(NameAndLocationPanel.getMessage("ERR_Name_Prefix_Empty"), false);
            return false;
        }
        if (this.txtDisplayName.getText().trim().length() == 0) {
            this.setInfo(NameAndLocationPanel.getMessage("ERR_Display_Name_Prefix_Empty"), false);
            return false;
        }
        if (!Utilities.isJavaIdentifier((String)this.txtName.getText().trim())) {
            this.setError(NameAndLocationPanel.getMessage("ERR_Name_Prefix_Invalid"));
            return false;
        }
        String packageName = this.comPackageName.getEditor().getItem().toString().trim();
        if (packageName.length() == 0 || !WizardUtils.isValidPackageName(packageName)) {
            this.setError(NameAndLocationPanel.getMessage("ERR_Package_Invalid"));
            return false;
        }
        if (!WizardUtils.isValidSFSPath(this.getCategoryPath())) {
            this.setError(NameAndLocationPanel.getMessage("ERR_Category_Invalid"));
            return false;
        }
        this.markValid();
        return true;
    }

    private boolean checkPlatformValidity() {
        for (String module : NewProjectIterator.MODULES) {
            try {
                if (this.data.getModuleInfo().getDependencyVersion(module) != null) continue;
                this.setError(NameAndLocationPanel.getMessage("ERR_Missing_Modules"));
                return false;
            }
            catch (IOException x) {
                Logger.getLogger(NameAndLocationPanel.class.getName()).log(Level.INFO, null, x);
            }
        }
        return true;
    }

    private void loadCombo() {
        this.comCategory.setModel(UIUtil.createComboWaitModel());
        RP.post(new Runnable(){

            @Override
            public void run() {
                final ComboBoxModel model = WizardUtils.createLayerPresenterComboModel(NameAndLocationPanel.this.data.getProject(), NameAndLocationPanel.PROJECT_TEMPLATES_DIR);
                EventQueue.invokeLater(new Runnable(){
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        this.this$1.NameAndLocationPanel.this.comCategory.setModel(model);
                    }
                });
            }
        });
    }

    @Override
    protected HelpCtx getHelp() {
        return new HelpCtx(NameAndLocationPanel.class);
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(NameAndLocationPanel.class, (String)key);
    }

    private void initComponents() {
        this.lblName = new JLabel();
        this.txtName = new JTextField();
        this.lblDisplayName = new JLabel();
        this.txtDisplayName = new JTextField();
        this.lblCategory = new JLabel();
        this.comCategory = new JComboBox();
        this.lblProjectName = new JLabel();
        this.txtProjectName = new JTextField(ProjectUtils.getInformation((Project)this.data.getProject()).getDisplayName());
        this.lblPackageName = new JLabel();
        this.comPackageName = WizardUtils.createPackageComboBox(this.data.getSourceRootGroup());
        this.createdFiles = new JLabel();
        this.modifiedFiles = new JLabel();
        this.filler = new JLabel();
        this.createdFilesValue = new JTextArea();
        this.modifiedFilesValue = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.lblName.setLabelFor(this.txtName);
        Mnemonics.setLocalizedText((JLabel)this.lblName, (String)NbBundle.getMessage(NameAndLocationPanel.class, (String)"LBL_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add(this.lblName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.add(this.txtName, gridBagConstraints);
        this.lblDisplayName.setLabelFor(this.txtDisplayName);
        Mnemonics.setLocalizedText((JLabel)this.lblDisplayName, (String)NbBundle.getMessage(NameAndLocationPanel.class, (String)"LBL_DisplayName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.add(this.lblDisplayName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add(this.txtDisplayName, gridBagConstraints);
        this.lblCategory.setLabelFor(this.comCategory);
        Mnemonics.setLocalizedText((JLabel)this.lblCategory, (String)NbBundle.getMessage(NameAndLocationPanel.class, (String)"LBL_Category"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.add(this.lblCategory, gridBagConstraints);
        this.comCategory.setEditable(true);
        this.comCategory.setPrototypeDisplayValue("Samples | Whatever");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add(this.comCategory, gridBagConstraints);
        this.lblProjectName.setLabelFor(this.txtProjectName);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/librarydescriptor/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.lblProjectName, (String)bundle.getString("LBL_ProjectName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(18, 0, 6, 12);
        this.add(this.lblProjectName, gridBagConstraints);
        this.txtProjectName.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(18, 0, 6, 0);
        this.add(this.txtProjectName, gridBagConstraints);
        this.lblPackageName.setLabelFor(this.comPackageName);
        Mnemonics.setLocalizedText((JLabel)this.lblPackageName, (String)bundle.getString("LBL_PackageName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add(this.lblPackageName, gridBagConstraints);
        this.comPackageName.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add(this.comPackageName, gridBagConstraints);
        this.createdFiles.setLabelFor(this.createdFilesValue);
        Mnemonics.setLocalizedText((JLabel)this.createdFiles, (String)bundle.getString("LBL_CreatedFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(36, 0, 6, 12);
        this.add(this.createdFiles, gridBagConstraints);
        this.modifiedFiles.setLabelFor(this.modifiedFilesValue);
        Mnemonics.setLocalizedText((JLabel)this.modifiedFiles, (String)bundle.getString("LBL_ModifiedFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add(this.modifiedFiles, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.filler, gridBagConstraints);
        this.createdFilesValue.setColumns(20);
        this.createdFilesValue.setRows(5);
        this.createdFilesValue.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(36, 0, 6, 0);
        this.add(this.createdFilesValue, gridBagConstraints);
        this.modifiedFilesValue.setColumns(20);
        this.modifiedFilesValue.setRows(5);
        this.modifiedFilesValue.setToolTipText("modifiedFilesValue");
        this.modifiedFilesValue.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add(this.modifiedFilesValue, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NameAndLocationPanel.getMessage("ACS_NameAndLocationPanel"));
        this.comPackageName.getAccessibleContext().setAccessibleDescription(NameAndLocationPanel.getMessage("ACS_CTL_PackageName"));
        this.comCategory.getAccessibleContext().setAccessibleDescription(NameAndLocationPanel.getMessage("ACS_CTL_Category"));
        this.txtDisplayName.getAccessibleContext().setAccessibleDescription(NameAndLocationPanel.getMessage("ACS_CTL_DisplayName"));
        this.txtName.getAccessibleContext().setAccessibleDescription(NameAndLocationPanel.getMessage("ACS_CTL_Name"));
        this.txtProjectName.getAccessibleContext().setAccessibleDescription(NameAndLocationPanel.getMessage("ACS_CTL_ProjectName"));
        this.createdFilesValue.getAccessibleContext().setAccessibleDescription(NameAndLocationPanel.getMessage("ACS_CTL_CreatedFilesValue"));
        this.modifiedFilesValue.getAccessibleContext().setAccessibleDescription(NameAndLocationPanel.getMessage("ACS_CTL_ModifiedFilesValue"));
    }

    private static String generateText(String[] relPaths) {
        StringBuffer sb = new StringBuffer();
        if (relPaths.length > 0) {
            for (int i = 0; i < relPaths.length; ++i) {
                if (i > 0) {
                    sb.append('\n');
                }
                sb.append(relPaths[i]);
            }
        }
        return sb.toString();
    }
}

