/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.netbeans.modules.java.source.save.Reformatter;
import org.netbeans.modules.java.ui.FmtOptions;
import org.netbeans.modules.options.editor.spi.PreferencesCustomizer;
import org.netbeans.modules.options.editor.spi.PreviewProvider;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CategorySupport
implements ActionListener,
ChangeListener,
ListDataListener,
TableModelListener,
DocumentListener,
PreviewProvider,
PreferencesCustomizer {
    public static final String OPTION_ID = "org.netbeans.modules.java.ui.FormatingOptions.ID";
    private static final int LOAD = 0;
    private static final int STORE = 1;
    private static final int ADD_LISTENERS = 2;
    private static final ComboItem[] bracePlacement = new ComboItem[]{new ComboItem(CodeStyle.BracePlacement.SAME_LINE.name(), "LBL_bp_SAME_LINE"), new ComboItem(CodeStyle.BracePlacement.NEW_LINE.name(), "LBL_bp_NEW_LINE"), new ComboItem(CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED.name(), "LBL_bp_NEW_LINE_HALF_INDENTED"), new ComboItem(CodeStyle.BracePlacement.NEW_LINE_INDENTED.name(), "LBL_bp_NEW_LINE_INDENTED")};
    private static final ComboItem[] bracesGeneration = new ComboItem[]{new ComboItem(CodeStyle.BracesGenerationStyle.GENERATE.name(), "LBL_bg_GENERATE"), new ComboItem(CodeStyle.BracesGenerationStyle.LEAVE_ALONE.name(), "LBL_bg_LEAVE_ALONE"), new ComboItem(CodeStyle.BracesGenerationStyle.ELIMINATE.name(), "LBL_bg_ELIMINATE")};
    private static final ComboItem[] wrap = new ComboItem[]{new ComboItem(CodeStyle.WrapStyle.WRAP_ALWAYS.name(), "LBL_wrp_WRAP_ALWAYS"), new ComboItem(CodeStyle.WrapStyle.WRAP_IF_LONG.name(), "LBL_wrp_WRAP_IF_LONG"), new ComboItem(CodeStyle.WrapStyle.WRAP_NEVER.name(), "LBL_wrp_WRAP_NEVER")};
    private static final ComboItem[] insertionPoint = new ComboItem[]{new ComboItem(CodeStyle.InsertionPoint.LAST_IN_CATEGORY.name(), "LBL_ip_LAST_IN_CATEGORY"), new ComboItem(CodeStyle.InsertionPoint.FIRST_IN_CATEGORY.name(), "LBL_ip_FIRST_IN_CATEGORY"), new ComboItem(CodeStyle.InsertionPoint.ORDERED_IN_CATEGORY.name(), "LBL_ip_ORDERED_IN_CATEGORY"), new ComboItem(CodeStyle.InsertionPoint.CARET_LOCATION.name(), "LBL_ip_CARET_LOCATION")};
    private static final RequestProcessor REFORMAT_RP = new RequestProcessor("Java Format Previewer");
    protected final String previewText;
    private final String id;
    protected final JPanel panel;
    private final List<JComponent> components = new LinkedList<JComponent>();
    private JEditorPane previewPane;
    protected final Preferences preferences;
    protected final Preferences previewPrefs;
    AtomicBoolean pendingRefresh = new AtomicBoolean(false);

    protected CategorySupport(Preferences preferences, String id, JPanel panel, String previewText, String[] ... forcedOptions) {
        this.preferences = preferences;
        this.id = id;
        this.panel = panel;
        this.previewText = previewText != null ? previewText : NbBundle.getMessage(CategorySupport.class, (String)"SAMPLE_Default");
        this.scan(panel, this.components);
        PreviewPreferences forcedPrefs = new PreviewPreferences();
        for (String[] option : forcedOptions) {
            ((Preferences)forcedPrefs).put(option[0], option[1]);
        }
        this.previewPrefs = new ProxyPreferences(forcedPrefs, preferences);
        this.loadFrom(preferences);
        this.addListeners();
    }

    protected void addListeners() {
        this.scan(2, null);
    }

    protected void loadFrom(Preferences preferences) {
        this.scan(0, preferences);
    }

    protected void storeTo(Preferences p) {
        this.scan(1, p);
    }

    protected void notifyChanged() {
        this.storeTo(this.preferences);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CategorySupport.this.refreshPreview();
            }
        });
    }

    protected void loadListData(JList list, String optionID, Preferences p) {
    }

    protected void storeListData(JList list, String optionID, Preferences node) {
    }

    protected void loadTableData(JTable table, String optionID, Preferences p) {
    }

    protected void storeTableData(JTable table, String optionID, Preferences node) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.notifyChanged();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.notifyChanged();
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.notifyChanged();
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.notifyChanged();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.notifyChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.notifyChanged();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.notifyChanged();
    }

    public JComponent getPreviewComponent() {
        if (this.previewPane == null) {
            this.previewPane = new JEditorPane();
            this.previewPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CategorySupport.class, (String)"AN_Preview"));
            this.previewPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CategorySupport.class, (String)"AD_Preview"));
            this.previewPane.putClientProperty("HighlightsLayerIncludes", "^org\\.netbeans\\.modules\\.editor\\.lib2\\.highlighting\\.SyntaxHighlighting$");
            this.previewPane.setEditorKit(CloneableEditorSupport.getEditorKit((String)"text/x-java"));
            this.previewPane.setEditable(false);
        }
        return this.previewPane;
    }

    public void refreshPreview() {
        if (this.pendingRefresh.getAndSet(true)) {
            return;
        }
        final JEditorPane jep = (JEditorPane)this.getPreviewComponent();
        jep.setIgnoreRepaint(true);
        REFORMAT_RP.post(new Runnable(){
            private String text;
            final /* synthetic */ CategorySupport this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (SwingUtilities.isEventDispatchThread()) {
                    try {
                        int rm = this.this$0.previewPrefs.getInt("text-limit-width", FmtOptions.getDefaultAsInt((String)"text-limit-width"));
                        jep.putClientProperty("TextLimitLine", rm);
                        jep.getDocument().putProperty("text-line-wrap", "");
                        jep.getDocument().putProperty("tab-size", "");
                        jep.getDocument().putProperty("text-limit-width", "");
                    }
                    catch (NumberFormatException rm) {
                        // empty catch block
                    }
                    jep.setIgnoreRepaint(true);
                    jep.setText(this.text);
                    jep.setIgnoreRepaint(false);
                    jep.scrollRectToVisible(new Rectangle(0, 0, 10, 10));
                    jep.repaint(100L);
                    return;
                }
                try {
                    Class.forName(CodeStyle.class.getName(), true, CodeStyle.class.getClassLoader());
                }
                catch (ClassNotFoundException rm) {
                    // empty catch block
                }
                this.this$0.pendingRefresh.getAndSet(false);
                CodeStyle codeStyle = FmtOptions.codeStyleProducer.create(this.this$0.previewPrefs);
                this.text = Reformatter.reformat((String)this.this$0.previewText, (CodeStyle)codeStyle);
                SwingUtilities.invokeLater(this);
            }
        }, 100);
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public String getDisplayName() {
        return this.panel.getName();
    }

    public String getId() {
        return this.id;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    private void performOperation(int operation, JComponent jc, String optionID, Preferences p) {
        switch (operation) {
            case 0: {
                this.loadData(jc, optionID, p);
                break;
            }
            case 1: {
                this.storeData(jc, optionID, p);
                break;
            }
            case 2: {
                this.addListener(jc);
            }
        }
    }

    private void scan(int what, Preferences p) {
        for (JComponent jc : this.components) {
            Object o = jc.getClientProperty(OPTION_ID);
            if (o instanceof String) {
                this.performOperation(what, jc, (String)o, p);
                continue;
            }
            if (!(o instanceof String[])) continue;
            for (String oid : (String[])o) {
                this.performOperation(what, jc, oid, p);
            }
        }
    }

    private void scan(Container container, List<JComponent> components) {
        for (Component c : container.getComponents()) {
            JComponent jc;
            Object o;
            if (c instanceof JComponent && ((o = (jc = (JComponent)c).getClientProperty(OPTION_ID)) instanceof String || o instanceof String[])) {
                components.add(jc);
            }
            if (!(c instanceof Container)) continue;
            this.scan((Container)c, components);
        }
    }

    private void loadData(JComponent jc, String optionID, Preferences node) {
        if (jc instanceof JTextField) {
            JTextField field = (JTextField)jc;
            field.setText(node.get(optionID, FmtOptions.getDefaultAsString((String)optionID)));
        } else if (jc instanceof JSpinner) {
            JSpinner js = (JSpinner)jc;
            js.setValue(node.getInt(optionID, FmtOptions.getDefaultAsInt((String)optionID)));
        } else if (jc instanceof JToggleButton) {
            JToggleButton toggle = (JToggleButton)jc;
            boolean df = FmtOptions.getDefaultAsBoolean((String)optionID);
            toggle.setSelected(node.getBoolean(optionID, df));
        } else if (jc instanceof JComboBox) {
            JComboBox cb = (JComboBox)jc;
            String value = node.get(optionID, FmtOptions.getDefaultAsString((String)optionID));
            ComboBoxModel model = this.createModel(value);
            cb.setModel(model);
            ComboItem item = CategorySupport.whichItem(value, model);
            cb.setSelectedItem(item);
        } else if (jc instanceof JList) {
            this.loadListData((JList)jc, optionID, node);
        } else if (jc instanceof JTable) {
            this.loadTableData((JTable)jc, optionID, node);
        }
    }

    private void storeData(JComponent jc, String optionID, Preferences node) {
        if (jc instanceof JTextField) {
            JTextField field = (JTextField)jc;
            String text = field.getText();
            if (FmtOptions.isInteger((String)optionID)) {
                try {
                    int n = Integer.parseInt(text);
                }
                catch (NumberFormatException e) {
                    return;
                }
            }
            if (!optionID.equals("tab-size") && !optionID.equals("spaces-per-tab") && !optionID.equals("indent-shift-width") && FmtOptions.getDefaultAsString((String)optionID).equals(text)) {
                node.remove(optionID);
            } else {
                node.put(optionID, text);
            }
        } else if (jc instanceof JSpinner) {
            JSpinner js = (JSpinner)jc;
            Object value = js.getValue();
            if (FmtOptions.getDefaultAsInt((String)optionID) == (Integer)value) {
                node.remove(optionID);
            } else {
                node.putInt(optionID, (Integer)value);
            }
        } else if (jc instanceof JToggleButton) {
            JToggleButton toggle = (JToggleButton)jc;
            if (!optionID.equals("expand-tabs") && FmtOptions.getDefaultAsBoolean((String)optionID) == toggle.isSelected()) {
                node.remove(optionID);
            } else {
                node.putBoolean(optionID, toggle.isSelected());
            }
        } else if (jc instanceof JComboBox) {
            JComboBox cb = (JComboBox)jc;
            String value = ((ComboItem)cb.getSelectedItem()).value;
            if (FmtOptions.getDefaultAsString((String)optionID).equals(value)) {
                node.remove(optionID);
            } else {
                node.put(optionID, value);
            }
        } else if (jc instanceof JList) {
            this.storeListData((JList)jc, optionID, node);
        } else if (jc instanceof JTable) {
            this.storeTableData((JTable)jc, optionID, node);
        }
    }

    private void addListener(JComponent jc) {
        if (jc instanceof JTextField) {
            JTextField field = (JTextField)jc;
            field.addActionListener(this);
            field.getDocument().addDocumentListener(this);
        } else if (jc instanceof JSpinner) {
            JSpinner spinner = (JSpinner)jc;
            spinner.addChangeListener(this);
        } else if (jc instanceof JToggleButton) {
            JToggleButton toggle = (JToggleButton)jc;
            toggle.addActionListener(this);
        } else if (jc instanceof JComboBox) {
            JComboBox cb = (JComboBox)jc;
            cb.addActionListener(this);
        } else if (jc instanceof JList) {
            JList jl = (JList)jc;
            jl.getModel().addListDataListener(this);
        } else if (jc instanceof JTable) {
            JTable jt = (JTable)jc;
            jt.getModel().addTableModelListener(this);
        }
    }

    private ComboBoxModel createModel(String value) {
        for (ComboItem comboItem : bracePlacement) {
            if (!value.equals(comboItem.value)) continue;
            return new DefaultComboBoxModel<ComboItem>(bracePlacement);
        }
        for (ComboItem comboItem : bracesGeneration) {
            if (!value.equals(comboItem.value)) continue;
            return new DefaultComboBoxModel<ComboItem>(bracesGeneration);
        }
        for (ComboItem comboItem : wrap) {
            if (!value.equals(comboItem.value)) continue;
            return new DefaultComboBoxModel<ComboItem>(wrap);
        }
        for (ComboItem comboItem : insertionPoint) {
            if (!value.equals(comboItem.value)) continue;
            return new DefaultComboBoxModel<ComboItem>(insertionPoint);
        }
        return null;
    }

    private static ComboItem whichItem(String value, ComboBoxModel model) {
        for (int i = 0; i < model.getSize(); ++i) {
            ComboItem item = (ComboItem)model.getElementAt(i);
            if (!value.equals(item.value)) continue;
            return item;
        }
        return null;
    }

    private static class PreviewPreferences
    extends AbstractPreferences {
        private Map<String, Object> map = new HashMap<String, Object>();

        public PreviewPreferences() {
            super(null, "");
        }

        @Override
        protected void putSpi(String key, String value) {
            this.map.put(key, value);
        }

        @Override
        protected String getSpi(String key) {
            return (String)this.map.get(key);
        }

        @Override
        protected void removeSpi(String key) {
            this.map.remove(key);
        }

        @Override
        protected void removeNodeSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected String[] keysSpi() throws BackingStoreException {
            String[] array = new String[this.map.keySet().size()];
            return this.map.keySet().toArray(array);
        }

        @Override
        protected String[] childrenNamesSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected AbstractPreferences childSpi(String name) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected void syncSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected void flushSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static final class ProxyPreferences
    extends AbstractPreferences {
        private final Preferences[] delegates;

        public ProxyPreferences(Preferences ... delegates) {
            super(null, "");
            this.delegates = delegates;
        }

        @Override
        protected void putSpi(String key, String value) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected String getSpi(String key) {
            for (Preferences p : this.delegates) {
                String value = p.get(key, null);
                if (value == null) continue;
                return value;
            }
            return null;
        }

        @Override
        protected void removeSpi(String key) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected void removeNodeSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected String[] keysSpi() throws BackingStoreException {
            HashSet<String> keys = new HashSet<String>();
            for (Preferences p : this.delegates) {
                keys.addAll(Arrays.asList(p.keys()));
            }
            return keys.toArray(new String[0]);
        }

        @Override
        protected String[] childrenNamesSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected AbstractPreferences childSpi(String name) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected void syncSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected void flushSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static class ComboItem {
        String value;
        String displayName;

        public ComboItem(String value, String key) {
            this.value = value;
            this.displayName = NbBundle.getMessage(CategorySupport.class, (String)key);
        }

        public String toString() {
            return this.displayName;
        }
    }

    static abstract class DocumentCategorySupport
    extends CategorySupport {
        private final Source[] sources = new Source[2];
        private int sourceIndex;

        public DocumentCategorySupport(Preferences preferences, String id, JPanel panel, String previewText, String[] ... forcedOptions) {
            super(preferences, id, panel, previewText, forcedOptions);
        }

        private String getSourceName(int index) {
            if (index == 0) {
                return "org.netbeans.samples.ClassA";
            }
            return "org.netbeans.samples" + (index + 1) + ".ClassA";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Document reformatDocument(int index) {
            assert (REFORMAT_RP.isRequestProcessorThread());
            try {
                Class.forName(CodeStyle.class.getName(), true, CodeStyle.class.getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            CodeStyle codeStyle = FmtOptions.codeStyleProducer.create(this.previewPrefs);
            try {
                Source s;
                Document doc;
                if (this.sources[index] == null) {
                    FileObject fo = FileUtil.createMemoryFileSystem().getRoot().createData(this.getSourceName(index), "java");
                    this.sources[index] = Source.create((FileObject)fo);
                }
                if ((doc = (s = this.sources[index]).getDocument(true)).getLength() > 0) {
                    doc.remove(0, doc.getLength());
                }
                doc.insertString(0, this.previewText, null);
                doc.putProperty(CodeStyle.class, codeStyle);
                this.reformatSource(doc, s);
                final Reformat reformat = Reformat.get((Document)doc);
                reformat.lock();
                try {
                    if (doc instanceof BaseDocument) {
                        ((BaseDocument)doc).runAtomicAsUser(new Runnable(){
                            final /* synthetic */ DocumentCategorySupport this$0;
                            {
                                this.this$0 = this$0;
                            }

                            @Override
                            public void run() {
                                try {
                                    reformat.reformat(0, doc.getLength());
                                }
                                catch (BadLocationException badLocationException) {
                                    // empty catch block
                                }
                            }
                        });
                    } else {
                        reformat.reformat(0, doc.getLength());
                    }
                }
                finally {
                    reformat.unlock();
                }
                DataObject dataObject = DataObject.find((FileObject)s.getFileObject());
                SaveCookie sc = (SaveCookie)dataObject.getLookup().lookup(SaveCookie.class);
                if (sc != null) {
                    sc.save();
                }
                return doc;
            }
            catch (Exception exception) {
                return null;
            }
        }

        protected void doModification(ResultIterator iterator) throws Exception {
        }

        protected void reformatSource(Document d, Source s) throws ParseException, IOException {
            ModificationResult result = ModificationResult.runModificationTask(Collections.singleton(s), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    this.doModification(resultIterator);
                }
            });
            result.commit();
        }

        @Override
        public void refreshPreview() {
            if (this.pendingRefresh.getAndSet(true)) {
                return;
            }
            final JEditorPane jep = (JEditorPane)this.getPreviewComponent();
            int rm = this.previewPrefs.getInt("text-limit-width", FmtOptions.getDefaultAsInt((String)"text-limit-width"));
            jep.putClientProperty("TextLimitLine", rm);
            jep.getDocument().putProperty("text-line-wrap", "");
            jep.getDocument().putProperty("tab-size", "");
            jep.getDocument().putProperty("text-limit-width", "");
            REFORMAT_RP.post(new Runnable(){
                private Document doc;
                final /* synthetic */ DocumentCategorySupport this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    if (SwingUtilities.isEventDispatchThread()) {
                        jep.setIgnoreRepaint(true);
                        if (this.doc != null) {
                            jep.setDocument(this.doc);
                        }
                        jep.scrollRectToVisible(new Rectangle(0, 0, 10, 10));
                        jep.repaint(100L);
                        jep.setIgnoreRepaint(false);
                    } else {
                        this.this$0.pendingRefresh.getAndSet(false);
                        int index = this.this$0.sourceIndex;
                        this.doc = this.this$0.reformatDocument(index);
                        this.this$0.sourceIndex = (this.this$0.sourceIndex + 1) % this.this$0.sources.length;
                        SwingUtilities.invokeLater(this);
                    }
                }
            }, 100);
        }
    }

    public static final class Factory
    implements PreferencesCustomizer.Factory {
        private final String id;
        private final Class<? extends JPanel> panelClass;
        private final String previewText;
        private final String[][] forcedOptions;

        public Factory(String id, Class<? extends JPanel> panelClass, String previewText, String[] ... forcedOptions) {
            this.id = id;
            this.panelClass = panelClass;
            this.previewText = previewText;
            this.forcedOptions = forcedOptions;
        }

        public PreferencesCustomizer create(Preferences preferences) {
            try {
                CategorySupport categorySupport = new CategorySupport(preferences, this.id, this.panelClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), this.previewText, this.forcedOptions);
                if (categorySupport.panel instanceof Runnable) {
                    ((Runnable)((Object)categorySupport.panel)).run();
                }
                return categorySupport;
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

