/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.multiview;

import java.util.StringTokenizer;
import javax.swing.JRadioButton;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.j2ee.dd.api.common.RunAs;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.ejb.AssemblyDescriptor;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.Method;
import org.netbeans.modules.j2ee.dd.api.ejb.MethodPermission;
import org.netbeans.modules.j2ee.dd.api.ejb.SecurityIdentity;
import org.netbeans.modules.j2ee.ddloaders.multiview.EjbJarMultiViewDataObject;
import org.netbeans.modules.j2ee.ddloaders.multiview.TextItemEditorModel;
import org.netbeans.modules.j2ee.ddloaders.multiview.ui.SecurityForm;
import org.netbeans.modules.xml.multiview.ItemEditorHelper;
import org.netbeans.modules.xml.multiview.ItemOptionHelper;
import org.netbeans.modules.xml.multiview.Refreshable;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataSynchronizer;
import org.netbeans.modules.xml.multiview.ui.SectionNodeView;

public class EjbSecurityPanel
extends SecurityForm {
    private static String ALL_METHODS = "*";
    private MethodPermission methodPermission;
    private EjbJar ejbJar;
    private AssemblyDescriptor assemblyDesc;

    public EjbSecurityPanel(SectionNodeView sectionNodeView, final Ejb ejb) {
        super(sectionNodeView);
        EjbJarMultiViewDataObject dataObject = (EjbJarMultiViewDataObject)sectionNodeView.getDataObject();
        this.ejbJar = dataObject.getEjbJar();
        this.assemblyDesc = this.ejbJar.getSingleAssemblyDescriptor();
        XmlMultiViewDataSynchronizer synchronizer = dataObject.getModelSynchronizer();
        this.addRefreshable((Refreshable)new ItemOptionHelper(this, synchronizer, this.getSecurityIDButtonGroup()){
            final /* synthetic */ EjbSecurityPanel this$0;
            {
                this.this$0 = this$0;
                super(synchronizer, group);
            }

            public String getItemValue() {
                SecurityIdentity securityIdentity = ejb.getSecurityIdentity();
                if (securityIdentity != null) {
                    if (securityIdentity.isUseCallerIdentity()) {
                        return "useCallerID";
                    }
                    if (securityIdentity.getRunAs() != null) {
                        return "runAs";
                    }
                }
                return "noSecurityID";
            }

            public void setItemValue(String value) {
                this.this$0.updateSecurityIdentity(ejb);
                this.this$0.updateVisualState();
            }
        });
        this.addRefreshable((Refreshable)new ItemEditorHelper((JTextComponent)this.getRunAsRoleNameTF(), (ItemEditorHelper.ItemEditorModel)new TextItemEditorModel(this, synchronizer, true, true){
            final /* synthetic */ EjbSecurityPanel this$0;
            {
                this.this$0 = this$0;
                super(synchronizer, emptyAllowed, emptyIsNull);
            }

            @Override
            protected String getValue() {
                RunAs runAs = this.this$0.getRunAs(ejb);
                if (runAs != null) {
                    return runAs.getRoleName();
                }
                return this.this$0.getRunAsRoleNameTF().getText();
            }

            @Override
            protected void setValue(String value) {
                RunAs runAs = this.this$0.getRunAs(ejb);
                if (runAs != null) {
                    this.this$0.updateRunAs(runAs);
                }
            }
        }));
        this.addRefreshable((Refreshable)new ItemEditorHelper((JTextComponent)this.getRunAsDescriptionTF(), (ItemEditorHelper.ItemEditorModel)new TextItemEditorModel(this, synchronizer, true, true){
            final /* synthetic */ EjbSecurityPanel this$0;
            {
                this.this$0 = this$0;
                super(synchronizer, emptyAllowed, emptyIsNull);
            }

            @Override
            protected String getValue() {
                RunAs runAs = this.this$0.getRunAs(ejb);
                if (runAs != null) {
                    return runAs.getDefaultDescription();
                }
                return this.this$0.getRunAsDescriptionTF().getText();
            }

            @Override
            protected void setValue(String value) {
                RunAs runAs = this.this$0.getRunAs(ejb);
                if (runAs != null) {
                    this.this$0.updateRunAs(runAs);
                }
            }
        }));
        this.addRefreshable((Refreshable)new ItemOptionHelper(this, synchronizer, this.getGlobalMethodPermissionButtonGroup()){
            final /* synthetic */ EjbSecurityPanel this$0;
            {
                this.this$0 = this$0;
                super(synchronizer, group);
            }

            public String getItemValue() {
                MethodPermission permission = this.this$0.getGlobalMethodPermission(ejb);
                if (permission != null) {
                    try {
                        if (permission.isUnchecked()) {
                            return "allMethodPermission";
                        }
                        return "setRoleMethodPermission";
                    }
                    catch (Exception ex) {
                        return "setRoleMethodPermission";
                    }
                }
                return "noMethodPermission";
            }

            public void setItemValue(String value) {
                this.this$0.updateMethodPermission(this.this$0.assemblyDesc, ejb);
                this.this$0.updateVisualState();
            }
        });
        this.addRefreshable((Refreshable)new ItemEditorHelper((JTextComponent)this.getSetRoleRoleNamesTF(), (ItemEditorHelper.ItemEditorModel)new TextItemEditorModel(this, synchronizer, true, true){
            boolean endsWithComma;
            final /* synthetic */ EjbSecurityPanel this$0;
            {
                this.this$0 = this$0;
                super(synchronizer, emptyAllowed, emptyIsNull);
                this.endsWithComma = false;
            }

            @Override
            protected String getValue() {
                MethodPermission permission = this.this$0.getGlobalMethodPermission(ejb);
                try {
                    if (permission != null && !permission.isUnchecked()) {
                        String roleNames = this.this$0.getCommaSeparatedString(permission.getRoleName());
                        if (this.endsWithComma) {
                            roleNames = roleNames + ",";
                        }
                        return roleNames;
                    }
                    return this.this$0.getSetRoleRoleNamesTF().getText();
                }
                catch (VersionNotSupportedException ex) {
                    return "";
                }
            }

            @Override
            protected void setValue(String value) {
                this.endsWithComma = value != null && value.trim().endsWith(",");
                this.this$0.updateMethodPermission(this.this$0.assemblyDesc, ejb);
            }
        }));
        this.updateVisualState();
    }

    public void dataModelPropertyChange(Object source, String propertyName, Object oldValue, Object newValue) {
        this.scheduleRefreshView();
    }

    private void updateSecurityIdentity(Ejb ejb) {
        JRadioButton noSecurityIDRB = this.getNoSecurityIDRB();
        JRadioButton useCallerIDRB = this.getUseCallerIDRB();
        JRadioButton runAsRB = this.getRunAsRB();
        if (noSecurityIDRB.isSelected()) {
            this.removeSecurityIdentity(ejb);
        } else {
            SecurityIdentity securityID = ejb.getSecurityIdentity();
            if (securityID == null) {
                securityID = ejb.newSecurityIdentity();
                ejb.setSecurityIdentity(securityID);
            }
            if (runAsRB.isSelected()) {
                RunAs runAs = securityID.getRunAs();
                if (runAs == null) {
                    runAs = securityID.newRunAs();
                    securityID.setRunAs(runAs);
                    this.updateRunAs(runAs);
                }
            } else {
                this.removeRunAs(securityID);
            }
            if (useCallerIDRB.isSelected()) {
                securityID.setUseCallerIdentity(true);
            } else {
                securityID.setUseCallerIdentity(false);
            }
        }
    }

    private void removeSecurityIdentity(Ejb ejb) {
        ejb.setSecurityIdentity(null);
    }

    private RunAs getRunAs(Ejb ejb) {
        SecurityIdentity securityIdentity = ejb.getSecurityIdentity();
        if (securityIdentity != null) {
            return securityIdentity.getRunAs();
        }
        return null;
    }

    private void updateRunAs(RunAs runAs) {
        String newRoleName = this.getRunAsRoleNameTF().getText();
        runAs.setRoleName(newRoleName);
        runAs.setDescription(this.getRunAsDescriptionTF().getText());
    }

    private void removeRunAs(SecurityIdentity securityIdentity) {
        RunAs runAs = securityIdentity.getRunAs();
        if (runAs != null) {
            securityIdentity.setRunAs(null);
        }
    }

    private MethodPermission getGlobalMethodPermission(Ejb ejb) {
        if (this.assemblyDesc == null) {
            return null;
        }
        MethodPermission methodPermission = null;
        MethodPermission[] permissions = this.assemblyDesc.getMethodPermission();
        String ejbName = ejb.getEjbName();
        for (int i = 0; i < permissions.length; ++i) {
            MethodPermission permission = permissions[i];
            Method method = permission.getMethod(0);
            if (method == null) continue;
            String methodEjbName = method.getEjbName();
            String methodName = method.getMethodName();
            if (methodEjbName == null || !methodEjbName.equals(ejbName) || methodName == null || !methodName.equals(ALL_METHODS)) continue;
            methodPermission = permission;
            break;
        }
        return methodPermission;
    }

    private MethodPermission createGlobalMethodPermission(Ejb ejb) {
        if (this.assemblyDesc == null) {
            this.assemblyDesc = this.getAssemblyDesc();
        }
        this.methodPermission = this.assemblyDesc.newMethodPermission();
        Method method = this.methodPermission.newMethod();
        method.setEjbName(ejb.getEjbName());
        method.setMethodName(ALL_METHODS);
        this.methodPermission.addMethod(method);
        this.assemblyDesc.addMethodPermission(this.methodPermission);
        return this.methodPermission;
    }

    private void removeGlobalMethodPermission() {
        if (this.methodPermission != null) {
            this.assemblyDesc.removeMethodPermission(this.methodPermission);
            this.methodPermission = null;
        }
    }

    private void updateMethodPermission(AssemblyDescriptor assemblyDesc, Ejb ejb) {
        if (this.getNoPermissionRB().isSelected()) {
            this.removeGlobalMethodPermission();
        } else {
            MethodPermission permission = this.getGlobalMethodPermission(ejb);
            if (permission == null) {
                permission = this.createGlobalMethodPermission(ejb);
            }
            if (this.getAllMethodPermissionRB().isSelected()) {
                permission.setRoleName(null);
                try {
                    permission.setUnchecked(true);
                }
                catch (VersionNotSupportedException ex) {
                    ex.printStackTrace();
                }
            } else if (this.getSetRolePermissionRB().isSelected()) {
                try {
                    permission.setUnchecked(false);
                }
                catch (VersionNotSupportedException ex) {
                    ex.printStackTrace();
                }
                String roleNames = this.getSetRoleRoleNamesTF().getText();
                StringTokenizer tokenizer = new StringTokenizer(roleNames, ",");
                permission.setRoleName(null);
                while (tokenizer.hasMoreTokens()) {
                    String roleName = tokenizer.nextToken().trim();
                    if (roleName.length() <= 0) continue;
                    permission.addRoleName(roleName);
                }
            }
        }
    }

    private String getCommaSeparatedString(String[] values) {
        String result = "";
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                result = result + ", ";
            }
            result = result + values[i];
        }
        return result;
    }

    private AssemblyDescriptor getAssemblyDesc() {
        AssemblyDescriptor assemblyDesc = this.ejbJar.getSingleAssemblyDescriptor();
        if (assemblyDesc == null) {
            assemblyDesc = this.ejbJar.newAssemblyDescriptor();
            this.ejbJar.setAssemblyDescriptor(assemblyDesc);
        }
        return assemblyDesc;
    }
}

