/*! For license information please see deck-reference.js.LICENSE.txt */
(()=>{var e,n,r,a,s={18953:(e,t,n)=>{"use strict";n.d(t,{A:()=>r});const r=function(e,t,n){if(null===t&&null===n)return e;const r=[...e];let a=e[t];return null!==t&&(a=r.splice(t,1)[0]),null!==n&&r.splice(n,0,a),r}},30605:(e,t,n)=>{"use strict";n.d(t,{_:()=>s});var r=n(66802),a=n(63814);class s{url(e){return(0,a.Jv)(`/apps/deck${e}`)}async fetchAttachments(e){return(await(0,r.Ay)({method:"GET",url:this.url(`/cards/${e}/attachments`)})).data}async createAttachment(e){let{cardId:t,formData:n,onUploadProgress:a}=e;return(await(0,r.Ay)({method:"POST",url:this.url(`/cards/${t}/attachment`),data:n,onUploadProgress:a})).data}async updateAttachment(e){let{cardId:t,attachment:n,formData:a}=e;return(await(0,r.Ay)({method:"POST",url:this.url(`/cards/${t}/attachment/${n.type}:${n.id}`),data:a})).data}async deleteAttachment(e){await(0,r.Ay)({method:"DELETE",url:this.url(`/cards/${e.cardId}/attachment/${e.type}:${e.id}`)})}async restoreAttachment(e){return(await(0,r.Ay)({method:"GET",url:this.url(`/cards/${e.cardId}/attachment/${e.type}:${e.id}/restore`)})).data}async displayAttachment(e){return(await(0,r.Ay)({method:"GET",url:this.url(`/cards/${e.cardId}/attachment/${e.type}:${e.id}`)})).data}}},13648:(e,n,r)=>{"use strict";r.d(n,{f:()=>i});var a=r(66802),s=r(63814);class i{url(e){return e=`/apps/deck${e}`,(0,s.Jv)(e)}updateBoard(e){return a.Ay.put(this.url(`/boards/${e.id}`),e).then((e=>Promise.resolve(e.data)),(e=>Promise.reject(e))).catch((e=>Promise.reject(e)))}createBoard(e){return a.Ay.post(this.url("/boards"),e).then((e=>Promise.resolve(e.data)),(e=>Promise.reject(e))).catch((e=>Promise.reject(e)))}deleteBoard(e){return a.Ay.delete(this.url(`/boards/${e.id}`)).then((()=>Promise.resolve()),(e=>Promise.reject(e))).catch((e=>Promise.reject(e)))}unDeleteBoard(e){return a.Ay.post(this.url(`/boards/${e.id}/deleteUndo`)).then((e=>Promise.resolve(e.data)),(e=>Promise.reject(e))).catch((e=>Promise.reject(e)))}leaveBoard(e){return a.Ay.post(this.url(`/boards/${e.id}/leave`)).then((()=>Promise.resolve()),(e=>Promise.reject(e))).catch((e=>Promise.reject(e)))}loadBoards(){return a.Ay.get(this.url("/boards")).then((e=>Promise.resolve(e.data)),(e=>Promise.reject(e))).catch((e=>Promise.reject(e)))}loadById(e){return a.Ay.get(this.url(`/boards/${e}`)).then((e=>Promise.resolve(e.data)),(e=>Promise.reject(e))).catch((e=>Promise.reject(e)))}async cloneBoard(e){let t=arguments.length>1&&void 0!==arguments[1]&&arguments[1],n=arguments.length>2&&void 0!==arguments[2]&&arguments[2],r=arguments.length>3&&void 0!==arguments[3]&&arguments[3],s=arguments.length>4&&void 0!==arguments[4]&&arguments[4],i=arguments.length>5&&void 0!==arguments[5]&&arguments[5],o=arguments.length>6&&void 0!==arguments[6]&&arguments[6];try{return(await a.Ay.post(this.url(`/boards/${e.id}/clone`),{withCards:t,withAssignments:n,withLabels:r,withDueDate:s,moveCardsToLeftStack:i,restoreArchivedCards:o})).data}catch(e){return e}}exportBoard(e,n){return a.Ay.get(this.url(`/boards/${e.id}/export`)).then((e=>{if("json"===n){const t={boards:[e.data]},n={};for(const t of e.data.stacks)n[t.id]=t;t.boards[0].stacks=n;const r=new Blob([JSON.stringify(t,null,2)],{type:"application/json"}),a=URL.createObjectURL(r),s=document.createElement("a");return s.href=a,s.download=e.data.title+".json",s.click(),s.remove(),Promise.resolve()}const r={title:t("deck","Card title"),description:t("deck","Description"),stackId:t("deck","List name"),labels:t("deck","Tags"),assignedUsers:t("deck","Assigned users"),duedate:t("deck","Due date"),createdAt:t("deck","Created"),lastModified:t("deck","Modified")};let a="";Object.keys(r).forEach((e=>{a+='"'+r[e]+'"\t'})),a=a.slice(0,-1);let s=a+"\r\n";e.data.stacks.forEach((e=>{e?.cards?.forEach((t=>{a="",Object.keys(r).forEach((n=>{if("createdAt"===n||"lastModified"===n){const e=new Date(1e3*Number(t[n]));a+='"'+e.toLocaleDateString()+'"\t'}else"stackId"===n?a+='"'+e.title.replaceAll('"','""')+'"\t':"labels"===n?(a+='"',t[n].forEach((e=>{a+=e.title.replaceAll('"','""')+", "})),t[n].length>0&&(a=a.slice(0,-1)),a+='"\t'):"assignedUsers"===n?(a+='"',t[n].forEach((e=>{a+=e.participant.displayname.replaceAll('"','""')+", "})),t[n].length>0&&(a=a.slice(0,-1)),a+='"\t'):a+="description"===n||"title"===n?'"'+t[n].replaceAll('"','""')+'"\t':'"'+t[n]+'"\t'})),a=a.slice(0,-1),s+=a+"\r\n"}))}));let i=[];const o=[];o.push(255,254);for(let e=0;e<s.length;++e)i=s.charCodeAt(e),o.push(255&i),o.push(i/256>>>0);const d=new Blob([new Uint8Array(o)],{type:"text/csv;charset=UTF-16LE;"}),u=URL.createObjectURL(d),l=document.createElement("a");return l.href=u,l.download=e.data.title+".csv",l.click(),l.remove(),Promise.resolve()}),(e=>Promise.reject(e))).catch((e=>Promise.reject(e)))}importBoard(e){const t=new FormData;return t.append("file",e),a.Ay.post(this.url("/boards/import"),t,{headers:{"Content-Type":"multipart/form-data"}}).then((e=>Promise.resolve(e.data)),(e=>Promise.reject(e))).catch((e=>Promise.reject(e)))}deleteLabel(e){return a.Ay.delete(this.url(`/labels/${e}`)).then((e=>Promise.resolve(e.data)),(e=>Promise.reject(e))).catch((e=>Promise.reject(e)))}updateLabel(e){return a.Ay.put(this.url(`/labels/${e.id}`),e).then((e=>Promise.resolve(e.data)),(e=>Promise.reject(e))).catch((e=>Promise.reject(e)))}createLabel(e){return a.Ay.post(this.url("/labels"),e).then((e=>Promise.resolve(e.data)),(e=>Promise.reject(e))).catch((e=>Promise.reject(e)))}addAcl(e){return a.Ay.post(this.url(`/boards/${e.boardId}/acl`),e).then((e=>Promise.resolve(e.data)),(e=>Promise.reject(e))).catch((e=>Promise.reject(e)))}updateAcl(e){return a.Ay.put(this.url(`/boards/${e.boardId}/acl/${e.id}`),e).then((e=>Promise.resolve(e.data)),(e=>Promise.reject(e))).catch((e=>Promise.reject(e)))}deleteAcl(e){return a.Ay.delete(this.url(`/boards/${e.boardId}/acl/${e.id}`)).then((e=>Promise.resolve(e.data)),(e=>Promise.reject(e))).catch((e=>Promise.reject(e)))}}},476:(e,t,n)=>{"use strict";n.d(t,{j:()=>s});var r=n(66802),a=n(63814);class s{url(e){return e=`/apps/deck${e}`,(0,a.Jv)(e)}addCard(e){return r.Ay.post(this.url("/cards"),e).then((e=>Promise.resolve(e.data)),(e=>Promise.reject(e))).catch((e=>Promise.reject(e)))}cloneCard(e,t){return r.Ay.post((0,a.KT)(`apps/deck/api/v1.0/cards/${e}/clone`),{targetStackId:t}).then((e=>Promise.resolve(e.data)),(e=>Promise.reject(e))).catch((e=>Promise.reject(e)))}deleteCard(e){return r.Ay.delete(this.url(`/cards/${e}`)).then((e=>Promise.resolve(e.data)),(e=>Promise.reject(e))).catch((e=>Promise.reject(e)))}deletedCards(e){return r.Ay.get(this.url(`/${e}/cards/deleted`)).then((e=>Promise.resolve(e.data)),(e=>Promise.reject(e))).catch((e=>Promise.reject(e)))}updateCard(e){return r.Ay.put(this.url(`/cards/${e.id}`),e).then((e=>Promise.resolve(e.data)),(e=>Promise.reject(e))).catch((e=>Promise.reject(e)))}reorderCard(e){return r.Ay.put(this.url(`/cards/${e.id}/reorder`),e).then((e=>Promise.resolve(e.data)),(e=>Promise.reject(e))).catch((e=>Promise.reject(e)))}assignUser(e,t,n){return r.Ay.post(this.url(`/cards/${e}/assign`),{userId:t,type:n}).then((e=>Promise.resolve(e.data)),(e=>Promise.reject(e))).catch((e=>Promise.reject(e)))}removeUser(e,t,n){return r.Ay.put(this.url(`/cards/${e}/unassign`),{userId:t,type:n}).then((e=>Promise.resolve(e.data)),(e=>Promise.reject(e))).catch((e=>Promise.reject(e)))}archiveCard(e){return r.Ay.put(this.url(`/cards/${e.id}/archive`)).then((e=>Promise.resolve(e.data)),(e=>Promise.reject(e))).catch((e=>Promise.reject(e)))}unArchiveCard(e){return r.Ay.put(this.url(`/cards/${e.id}/unarchive`)).then((e=>Promise.resolve(e.data)),(e=>Promise.reject(e))).catch((e=>Promise.reject(e)))}markCardAsDone(e){return r.Ay.put(this.url(`/cards/${e.id}/done`)).then((e=>Promise.resolve(e.data)),(e=>Promise.reject(e))).catch((e=>Promise.reject(e)))}markCardAsUndone(e){return r.Ay.put(this.url(`/cards/${e.id}/undone`)).then((e=>Promise.resolve(e.data)),(e=>Promise.reject(e))).catch((e=>Promise.reject(e)))}assignLabelToCard(e){return r.Ay.post(this.url(`/cards/${e.card.id}/label/${e.labelId}`)).then((e=>Promise.resolve(e.data)),(e=>Promise.reject(e))).catch((e=>Promise.reject(e)))}removeLabelFromCard(e){return r.Ay.delete(this.url(`/cards/${e.card.id}/label/${e.labelId}`)).then((e=>Promise.resolve(e.data)),(e=>Promise.reject(e))).catch((e=>Promise.reject(e)))}}},48459:(e,t,n)=>{"use strict";n.d(t,{E:()=>s});var r=n(66802),a=n(63814);class s{url(e){return e=`dav/comments/deckCard/${e}`,(0,a.dC)(e)}async loadComments(e){let{cardId:t,limit:n,offset:s}=e;return(await r.Ay.get((0,a.KT)(`apps/deck/api/v1.0/cards/${t}/comments`),{params:{limit:n,offset:s},headers:{"OCS-APIRequest":"true"}})).data.ocs.data}async createComment(e){let{cardId:t,comment:n,replyTo:s}=e;return(await r.Ay.post((0,a.KT)(`apps/deck/api/v1.0/cards/${t}/comments`),{message:`${n}`,parentId:s?s.id:null})).data.ocs.data}async updateComment(e){let{cardId:t,id:n,comment:s}=e;return(await r.Ay.put((0,a.KT)(`apps/deck/api/v1.0/cards/${t}/comments/${n}`),{message:`${s}`})).data.ocs.data}async deleteComment(e){let{cardId:t,id:n}=e;return(await r.Ay.delete((0,a.KT)(`apps/deck/api/v1.0/cards/${t}/comments/${n}`))).data.ocs.data}async markCommentsAsRead(e){const t=(new Date).toUTCString();return(await(0,r.Ay)({method:"PROPPATCH",url:this.url(`${e}`),data:`<?xml version="1.0"?>\n\t\t\t\t<d:propertyupdate  xmlns:d="DAV:" xmlns:oc="http://owncloud.org/ns">\n\t\t\t\t  <d:set>\n\t\t\t\t   <d:prop>\n\t\t\t\t\t  <oc:readMarker>${t}</oc:readMarker>\n\t\t\t\t\t</d:prop>\n\t\t\t\t  </d:set>\n\t\t\t\t</d:propertyupdate>`})).data}}},74667:(e,t,n)=>{"use strict";n.d(t,{w:()=>s});var r=n(66802),a=n(63814);class s{url(e){return(0,a.KT)(`apps/deck/api/v1.0/${e}`)}get(e){return r.Ay.get(this.url(`overview/${e}`),{headers:{"OCS-APIRequest":"true"}}).then((e=>Promise.resolve(e.data.ocs.data)),(e=>Promise.reject(e))).catch((e=>Promise.reject(e)))}}},52628:(e,t,n)=>{"use strict";n.d(t,{h:()=>s});var r=n(66802),a=n(63814);class s{url(e){return e=`/apps/deck${e}`,(0,a.Jv)(e)}loadStacks(e){return r.Ay.get(this.url(`/stacks/${e}`)).then((e=>Promise.resolve(e.data)),(e=>Promise.reject(e))).catch((e=>Promise.reject(e)))}deletedStacks(e){return r.Ay.get(this.url(`/${e}/stacks/deleted`)).then((e=>Promise.resolve(e.data)),(e=>Promise.reject(e))).catch((e=>Promise.reject(e)))}loadArchivedStacks(e){return r.Ay.get(this.url(`/stacks/${e}/archived`)).then((e=>Promise.resolve(e.data)),(e=>Promise.reject(e))).catch((e=>Promise.reject(e)))}createStack(e){return r.Ay.post(this.url("/stacks"),e).then((e=>Promise.resolve(e.data)),(e=>Promise.reject(e))).catch((e=>Promise.reject(e)))}reorderStack(e,t){return r.Ay.put(this.url(`/stacks/${e}/reorder`),{order:t}).then((e=>Promise.resolve(e.data)),(e=>Promise.reject(e))).catch((e=>Promise.reject(e)))}deleteStack(e){return r.Ay.delete(this.url(`/stacks/${e}`)).then((e=>Promise.resolve(e.data)),(e=>Promise.reject(e))).catch((e=>Promise.reject(e)))}updateStack(e){return r.Ay.put(this.url(`/stacks/${e.id}`),e).then((e=>Promise.resolve(e.data)),(e=>Promise.reject(e))).catch((e=>Promise.reject(e)))}}},71724:(e,t,n)=>{"use strict";n.d(t,{A:()=>r});const r={state:{actions:{card:[]}},getters:{cardActions:e=>e.actions.card},mutations:{ADD_CARD_ACTION(e,t){e.actions.card.push(t)}},actions:{async addCardAction(e,t){let{commit:n}=e;n("ADD_CARD_ACTION",t)}}}},20682:(e,t,n)=>{"use strict";n.d(t,{A:()=>i});var r=n(30605),a=n(85471);const s=new r._,i={state:{attachments:{}},getters:{attachmentsByCard:e=>t=>void 0===e.attachments[t]?[]:e.attachments[t]},mutations:{createAttachment(e,t){let{cardId:n,attachment:r}=t;void 0===e.attachments[n]?a.default.set(e.attachments,n,[r]):e.attachments[n].push(r)},createAttachments(e,t){let{cardId:n,attachments:r}=t;a.default.set(e.attachments,n,r)},updateAttachment(e,t){let{cardId:n,attachment:r}=t;const s=e.attachments[r.cardId].findIndex((e=>e.id===r.id&&e.type===r.type));-1!==s&&a.default.set(e.attachments[n],s,r)},deleteAttachment(e,t){const n=e.attachments[t.cardId].findIndex((e=>e.id===t.id&&e.type===t.type));-1!==n&&(e.attachments[t.cardId][n].deletedAt=Date.now()/1e3|0)},unshareAttachment(e,t){const n=e.attachments[t.cardId].findIndex((e=>e.id===t.id&&e.type===t.type));-1!==n&&(e.attachments[t.cardId][n].deletedAt=-1)},restoreAttachment(e,t){const n=e.attachments[t.cardId].findIndex((e=>e.id===t.id&&e.type===t.type));-1!==n&&(e.attachments[t.cardId][n].deletedAt=0)}},actions:{async fetchAttachments(e,t){let{commit:n}=e;const r=await s.fetchAttachments(t);n("createAttachments",{cardId:t,attachments:r}),n("cardSetAttachmentCount",{cardId:t,count:r.length})},async createAttachment(e,t){let{commit:n}=e,{cardId:r,formData:a,onUploadProgress:i}=t;n("createAttachment",{cardId:r,attachment:await s.createAttachment({cardId:r,formData:a,onUploadProgress:i})}),n("cardIncreaseAttachmentCount",r)},async updateAttachment(e,t){let{commit:n}=e,{cardId:r,attachment:a,formData:i}=t;n("updateAttachment",{cardId:r,attachment:await s.updateAttachment({cardId:r,attachment:a,formData:i})})},async deleteAttachment(e,t){let{commit:n}=e;await s.deleteAttachment(t),n("deleteAttachment",t),n("cardDecreaseAttachmentCount",t.cardId)},async unshareAttachment(e,t){let{commit:n}=e;await s.deleteAttachment(t),n("unshareAttachment",t),n("cardDecreaseAttachmentCount",t.cardId)},async restoreAttachment(e,t){let{commit:n}=e;n("restoreAttachment",await s.restoreAttachment(t)),n("cardIncreaseAttachmentCount",t.cardId)}}}},95477:(e,t,n)=>{"use strict";n.d(t,{A:()=>d});var r=n(476),a=n(95093),s=n.n(a),i=n(85471);const o=new r.j;function d(){return{state:{cards:[]},getters:{cardsByStack:(e,t,n)=>r=>e.cards.filter((e=>{const{tags:t,users:r,due:a,unassigned:s,completed:i}=n.filter;if("open"===i&&null!==e.done)return!1;if("completed"===i&&null==e.done)return!1;let o=!0,d=!0;if(t.length>0&&(t.forEach((t=>{-1===e.labels.findIndex((e=>e.id===t))&&(o=!1)})),!o))return!1;if(r.length>0&&(r.forEach((t=>{e?.assignedUsers&&-1!==e.assignedUsers.findIndex((e=>e.participant.uid===t))||(d=!1)})),!d))return!1;if(s&&e.assignedUsers.length>0)return!1;if(""!==a){const t=(new Date(e.duedate)-new Date)/3600/1e3;switch(a){case"noDue":return null===e.duedate;case"overdue":return 3===e.overdue;case"dueToday":return e.overdue>=2;case"dueWeek":return t<=168&&null!==e.duedate;case"dueMonth":return t<=720&&null!==e.duedate}}return!0})).filter((e=>e.stackId===r)).filter((e=>{if(""===t.getSearchQuery)return!0;let n=!0;const r=t.getSearchQuery.match(/(?:[^\s"]+|"[^"]*")+/g),a=e=>'"'===e[0]&&'"'===e[e.length-1]?e.slice(1,-1):e;for(const i of r){let[r,o]=-1!==i.indexOf(":")?i.split(/:(.*)/):[null,i];const d=void 0===o||""===a(o);if("title"===r){if(d)continue;n=n&&e.title.toLowerCase().includes(a(o).toLowerCase())}else if("description"===r){if(d){n=n&&!!e.description;continue}n=n&&e.description.toLowerCase().includes(a(o).toLowerCase())}else if("list"===r){if(d)continue;const r=t.stackById(e.stackId);if(!r)return!1;n=n&&r.title.toLowerCase().includes(a(o).toLowerCase())}else if("tag"===r){if(d){n=n&&e.labels.length>0;continue}n=n&&-1!==e.labels.findIndex((e=>e.title.toLowerCase().includes(a(o).toLowerCase())))}else if("date"===r){const t=(new Date(e.duedate)-new Date)/3600/1e3;switch(o=a(o),o){case"overdue":n=n&&3===e.overdue;break;case"today":n=n&&t>0&&t<=24&&null!==e.duedate;break;case"week":n=n&&t>0&&t<=168&&null!==e.duedate;break;case"month":n=n&&t>0&&t<=720&&null!==e.duedate;break;case"none":n=n&&null===e.duedate}if(null===e.duedate||!n)return!1;const r=o[0]+("="===o[1]?"=":""),i=-1!==["<","<=",">",">="].indexOf(r),d=s()(e.duedate),u=s()(o.slice(i?r.length:0));switch(r){case"<":n=n&&d.isBefore(u);break;case"<=":n=n&&d.isSameOrBefore(u);break;case">":n=n&&d.isAfter(u);break;case">=":n=n&&d.isSameOrAfter(u);break;default:n=n&&d.isSame(u)}}else if("assigned"===r){if(d){n=n&&e.assignedUsers.length>0;continue}n=n&&-1!==e.assignedUsers.findIndex((e=>e.participant.primaryKey.toLowerCase()===a(o).toLowerCase()||e.participant.displayname.toLowerCase()===a(o).toLowerCase()))}else n=n&&(e.title.toLowerCase().includes(a(i).toLowerCase())||e.description.toLowerCase().includes(a(i).toLowerCase())||e.id===parseInt(a(i)));if(!n)return!1}return!0})).sort(((e,t)=>e.order-t.order||e.createdAt-t.createdAt)),cardById:e=>t=>e.cards.find((e=>e.id===t))},mutations:{addCard(e,t){t.labels=t.labels||[],t.assignedUsers=t.assignedUsers||[];const n=e.cards.findIndex((e=>e.id===t.id));if(-1!==n){const r=e.cards.find((e=>e.id===t.id));i.default.set(e.cards,n,Object.assign({},r,t))}else e.cards.push(t)},deleteCard(e,t){const n=e.cards.findIndex((e=>e.id===t.id));-1!==n&&e.cards.splice(n,1)},updateCard(e,t){const n=e.cards.findIndex((e=>e.id===t.id));-1!==n&&i.default.set(e.cards,n,Object.assign({},e.cards[n],t))},updateCardsReorder(e,t){for(const n of t){const t=e.cards.findIndex((e=>e.id===n.id));-1!==t&&(i.default.set(e.cards[t],"order",n.order),i.default.set(e.cards[t],"stackId",n.stackId))}},assignCardToUser(e,t){const n=e.cards.findIndex((e=>e.id===t.cardId));-1!==n&&e.cards[n].assignedUsers.push(t)},removeUserFromCard(e,t){const n=e.cards.findIndex((e=>e.id===t.cardId));if(-1!==n){const r=e.cards[n].assignedUsers.findIndex((e=>e.id===t.id));-1!==r&&e.cards[n].assignedUsers.splice(r,1)}},updateCardProperty(e,t){let{card:n,property:r}=t;const a=e.cards.findIndex((e=>e.id===n.id));-1!==a&&(i.default.set(e.cards[a],r,n[r]),i.default.set(e.cards[a],"lastModified",Date.now()/1e3))},cardSetAttachmentCount(e,t){let{cardId:n,count:r}=t;const a=e.cards.findIndex((e=>e.id===n));-1!==a&&i.default.set(e.cards[a],"attachmentCount",r)},cardIncreaseAttachmentCount(e,t){const n=e.cards.findIndex((e=>e.id===t));-1!==n&&i.default.set(e.cards[n],"attachmentCount",e.cards[n].attachmentCount+1)},cardDecreaseAttachmentCount(e,t){const n=e.cards.findIndex((e=>e.id===t));-1!==n&&i.default.set(e.cards[n],"attachmentCount",e.cards[n].attachmentCount-1)},addNewCard(e,t){e.cards.push(t)},setCards(e,t){const n=e.cards.filter((e=>-1===t.findIndex((t=>e.id===t.id))));for(const e of n)this.commit("deleteCard",e);for(const e of t)this.commit("addCard",e)}},actions:{async cloneCard(e,t){let{commit:n}=e,{cardId:r,targetStackId:a}=t;const s=await o.cloneCard(r,a);return n("addCard",s),s},async addCard(e,t){let{commit:n}=e;const r=await o.addCard(t);return n("addCard",r),r},async updateCardTitle(e,t){let{commit:n}=e;const r=await o.updateCard(t);n("updateCardProperty",{property:"title",card:r}),n("updateCardProperty",{property:"referenceData",card:r})},async moveCard(e,t){let{commit:n}=e;n("deleteCard",await o.updateCard(t))},async reorderCard(e,t){let{commit:n,getters:r}=e,a=0;const s=[];for(const e of r.cardsByStack(t.stackId))e.id===t.id&&s.push(t),a===t.order&&a++,e.id!==t.id&&s.push({...e,order:a++});s.push(t),await n("updateCardsReorder",s),o.reorderCard(t).then((e=>{n("updateCardsReorder",Object.values(e))}))},async deleteCard(e,t){let{commit:n}=e;await o.deleteCard(t.id),n("deleteCard",t),n("moveCardToTrash",t)},async archiveUnarchiveCard(e,t){let{commit:n}=e,r="archiveCard";!1===t.archived&&(r="unArchiveCard");n("updateCard",await o[r](t))},async changeCardDoneStatus(e,t){let{commit:n}=e,r="markCardAsDone";!1===t.done&&(r="markCardAsUndone");n("updateCardProperty",{property:"done",card:await o[r](t)})},async assignCardToUser(e,t){let{commit:n}=e,{card:r,assignee:a}=t;n("assignCardToUser",await o.assignUser(r.id,a.userId,a.type))},async removeUserFromCard(e,t){let{commit:n}=e,{card:r,assignee:a}=t;n("removeUserFromCard",await o.removeUser(r.id,a.userId,a.type))},async addLabel(e,t){let{commit:n}=e;await o.assignLabelToCard(t),n("updateCardProperty",{property:"labels",card:t.card})},async removeLabel(e,t){let{commit:n}=e;await o.removeLabelFromCard(t),n("updateCardProperty",{property:"labels",card:t.card})},async updateCardDesc(e,t){let{commit:n}=e;n("updateCardProperty",{property:"description",card:await o.updateCard(t)})},async updateCardDue(e,t){let{commit:n}=e;n("updateCardProperty",{property:"duedate",card:await o.updateCard(t)})},addCardData(e,t){let{commit:n}=e;const r={...t};n("addStack",r.relatedStack),n("addBoard",r.relatedBoard),delete r.relatedStack,delete r.relatedBoard,n("addCard",r)}}}}},94322:(e,t,n)=>{"use strict";n.d(t,{A:()=>i});var r=n(48459),a=n(85471);const s=new r.E,i={state:{comments:{},replyTo:null},getters:{getCommentsForCard:e=>t=>e.comments[t]?[...e.comments[t].comments].sort(((e,t)=>t.id-e.id)):[],hasMoreComments:e=>t=>e.comments[t]&&e.comments[t].hasMore},mutations:{endReached(e,t){let{cardId:n}=t;e.comments[n]&&(e.comments[n].hasMore=!1)},addComments(e,t){let{comments:n,cardId:r}=t;if(void 0===e.comments[r])a.default.set(e.comments,r,{hasMore:n.length>0,comments:[...n]});else{const t=n.filter((t=>-1===e.comments[r].comments.findIndex((e=>e.id===t.id))));e.comments[r].comments.push(...t)}},updateComment(e,t){let{cardId:n,comment:r}=t;const a=e.comments[n].comments.findIndex((e=>e.id===r.id));-1!==a&&Object.assign(e.comments[n].comments[a],r)},deleteComment(e,t){const n=e.comments[t.cardId].comments.findIndex((e=>e.id===t.id));-1!==n&&e.comments[t.cardId].comments.splice(n,1)},markCommentsAsRead(e,t){e.comments[t].comments.forEach((e=>{a.default.set(e,"isUnread",!1)}))},setReplyTo(e,t){a.default.set(e,"replyTo",t)}},actions:{async fetchComments(e,t){let{commit:n}=e,{cardId:r,offset:a}=t;const i=await s.loadComments({cardId:r,limit:10,offset:a||0});n("addComments",{cardId:r,comments:i}),i.length<10&&n("endReached",{cardId:r})},async fetchMore(e,t){let{commit:n,dispatch:r,getters:a}=e,{cardId:s}=t;await r("fetchComments",{cardId:s}),await r("fetchComments",{cardId:s,offset:a.getCommentsForCard(s).length})},async createComment(e,t){let{commit:n,dispatch:r,state:a}=e,{cardId:i,comment:o}=t;await s.createComment({cardId:i,comment:o,replyTo:a.replyTo}),await r("fetchComments",{cardId:i})},async deleteComment(e,t){let{commit:n}=e;await s.deleteComment(t),n("deleteComment",t)},async updateComment(e,t){let{commit:n}=e;const r=await s.updateComment(t);await n("updateComment",{cardId:t.cardId,comment:r})},async markCommentsAsRead(e,t){let{commit:n}=e;await s.markCommentsAsRead(t),await n("markCommentsAsRead",t)},setReplyTo(e,t){let{commit:n}=e;n("setReplyTo",t)}}}},21210:(e,t,n)=>{"use strict";n.d(t,{A:()=>g});n(48318);var r=n(32981),a=n(85471),s=n(95353),i=n(66802),o=n(63814),d=n(13648),u=n(71724),l=n(32947),c=n(95477),_=n(94322),m=n(58624),h=n(20682),f=n(92676);a.default.use(s.default);const p=new d.f,y=!1,M={ALL:"",ARCHIVED:"archived",SHARED:"shared"};function g(){return new s.default.Store({modules:{actions:u.A,stack:(0,l.A)(),card:(0,c.A)(),comment:_.A,trashbin:m.A,attachment:h.A,overview:f.A},strict:y,state:{isFullApp:!0,config:(0,r.C)("deck","config",{}),showArchived:!1,navShown:null===localStorage.getItem("deck.navShown")||"true"===localStorage.getItem("deck.navShown"),compactMode:"true"===localStorage.getItem("deck.compactMode"),showCardCover:"true"===localStorage.getItem("deck.showCardCover"),sidebarShown:!1,currentBoard:null,currentCard:null,hasCardSaveError:!1,boards:(0,r.C)("deck","initialBoards",[]),sharees:[],assignableUsers:[],boardFilter:M.ALL,searchQuery:"",activity:[],activityLoadMore:!0,filter:{tags:[],users:[],due:"",unassigned:!1,completed:"both"},shortcutLock:!1},getters:{config:e=>t=>!e.isFullApp&&"cardDetailsInModal"===t||e.config[t],getSearchQuery:e=>e.searchQuery,getFilter:e=>e.filter,boards:e=>e.boards,boardById:e=>t=>e.boards.find((e=>e.id===t)),assignables:e=>[...e.assignableUsers.map((e=>({...e,type:0}))),...e.currentBoard.acl.filter((e=>1===e.type&&"object"==typeof e.participant)).map((e=>({...e.participant,type:1}))),...e.currentBoard.acl.filter((e=>7===e.type&&"object"==typeof e.participant)).map((e=>({...e.participant,type:7})))],noneArchivedBoards:e=>e.boards.filter((e=>!1===e.archived&&!e.deletedAt)),archivedBoards:e=>e.boards.filter((e=>!0===e.archived&&!e.deletedAt)),sharedBoards:e=>e.boards.filter((e=>e.shared&&!e.deletedAt)),filteredBoards:e=>e.boards.filter((t=>e.boardFilter===M.ALL&&!1===t.archived||e.boardFilter===M.ARCHIVED&&!0===t.archived||e.boardFilter===M.SHARED&&1===t.shared)),currentBoardLabels:e=>e.currentBoard?e.currentBoard.labels:[],canEdit:e=>!!e.currentBoard&&e.currentBoard.permissions.PERMISSION_EDIT,canManage:e=>!!e.currentBoard&&e.currentBoard.permissions.PERMISSION_MANAGE,canShare:e=>!!e.currentBoard&&e.currentBoard.permissions.PERMISSION_SHARE,isArchived:e=>e.currentBoard&&e.currentBoard.archived},mutations:{setFullApp(e,t){a.default.set(e,"isFullApp",t)},setHasCardSaveError(e,t){a.default.set(e,"hasCardSaveError",t)},SET_CONFIG(e,t){let{key:n,value:r}=t;const[s,i,o]=n.split(":",3);let d=-1;if("board"===s)d=e.boards.findIndex((e=>i===""+e.id)),d>-1&&a.default.set(e.boards[d].settings,o,r);else a.default.set(e.config,n,r)},setSearchQuery(e,t){e.searchQuery=t},SET_FILTER(e,t){Object.assign(e.filter,t)},TOGGLE_FILTER(e,t){Object.keys(t).forEach((n=>{if("due"===n)a.default.set(e.filter,n,t.due);else t[n].forEach((t=>{-1===e.filter[n].indexOf(t)?e.filter[n].push(t):e.filter[n].splice(e.filter[n].indexOf(t),1)}))}))},toggleShowArchived(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:void 0;e.showArchived=void 0!==t?t:!e.showArchived},addBoard(e,t){const n=e.boards.findIndex((e=>t.id===e.id));n>-1?a.default.set(e.boards,n,t):e.boards.push(t)},cloneBoard(e,t){const n=e.boards.findIndex((e=>t.id===e.id));n>-1?a.default.set(e.boards,n,t):e.boards.push(t)},removeBoard(e,t){e.boards=e.boards.filter((e=>t.id!==e.id))},toggleNav(e,t){e.navShown=t,localStorage.setItem("deck.navShown",t)},toggleSidebar(e){e.sidebarShown=!e.sidebarShown},toggleCompactMode(e){e.compactMode=!e.compactMode,localStorage.setItem("deck.compactMode",e.compactMode)},toggleShowCardCover(e){e.showCardCover=!e.showCardCover,localStorage.setItem("deck.showCardCover",e.showCardCover)},setBoards(e,t){e.boards=t},setSharees(e,t){a.default.set(e,"sharees",t.exact.users),e.sharees.push(...t.exact.groups),e.sharees.push(...t.exact.circles),e.sharees.push(...t.users),e.sharees.push(...t.groups),e.sharees.push(...t.circles)},setAssignableUsers(e,t){e.assignableUsers=t},setBoardFilter(e,t){e.boardFilter=t},setCurrentBoard(e,t){e.currentBoard=t},setCurrentCard(e,t){e.currentCard=t},removeLabelFromCurrentBoard(e,t){const n=e.currentBoard.labels.findIndex((e=>t===e.id));n>-1&&e.currentBoard.labels.splice(n,1)},updateLabelFromCurrentBoard(e,t){const n=e.currentBoard.labels.find((e=>t.id===e.id));n.title=t.title,n.color=t.color},addLabelToCurrentBoard(e,t){e.currentBoard.labels.push(t)},addAclToCurrentBoard(e,t){e.currentBoard.acl.push(t)},updateAclFromCurrentBoard(e,t){for(const n in e.currentBoard.acl)if(e.currentBoard.acl[n].participant.uid===t.participant.uid){a.default.set(e.currentBoard.acl,n,t);break}},deleteAclFromCurrentBoard(e,t){let n=-1;for(const r in e.currentBoard.acl){const a=e.currentBoard.acl[r];if(t.id===a.id){n=r;break}}n>-1&&a.default.delete(e.currentBoard.acl,n)},TOGGLE_SHORTCUT_LOCK(e,t){e.shortcutLock=t}},actions:{setFullApp(e,t){let{commit:n}=e;n("setFullApp",t)},async setConfig(e,t){let{commit:n}=e;for(const e in t)try{await i.Ay.post((0,o.KT)(`apps/deck/api/v1.0/config/${e}`),{value:t[e]}),n("SET_CONFIG",{key:e,value:t[e]})}catch(t){throw console.error(`Error while saving ${e}`,t.response),t}},setFilter(e,t){let{commit:n}=e;n("SET_FILTER",t)},toggleFilter(e,t){let{commit:n}=e;n("TOGGLE_FILTER",t)},async loadBoardById(e,t){let{commit:n,dispatch:r}=e;r("setFilter",{tags:[],users:[],due:"",unassigned:!1,completed:"both"}),n("setCurrentBoard",null);const a=await p.loadById(t);n("setCurrentBoard",a),n("setAssignableUsers",a.users)},async refreshBoard(e,t){let{commit:n,dispatch:r}=e;const a=await p.loadById(t),s=a.ETag!==this.state.currentBoard.ETag;n("setCurrentBoard",a),n("setAssignableUsers",a.users),s&&r("loadStacks",t)},toggleShowArchived(e){let{commit:t}=e;t("toggleShowArchived")},archiveBoard(e,t){let{commit:n}=e;const r=JSON.parse(JSON.stringify(t));r.archived=!0,p.updateBoard(r).then((e=>{n("addBoard",e)}))},unarchiveBoard(e,t){let{commit:n}=e;const r=JSON.parse(JSON.stringify(t));r.archived=!1,p.updateBoard(r).then((e=>{n("addBoard",e)}))},async updateBoard(e,t){let{commit:n}=e;n("addBoard",await p.updateBoard(t))},async createBoard(e,t){let{commit:n}=e;try{n("addBoard",await p.createBoard(t))}catch(e){return e}},async importBoard(e,t){let{commit:n}=e;try{n("addBoard",await p.importBoard(t))}catch(e){return e}},async cloneBoard(e,t){let{commit:n}=e,{boardData:r,settings:a}=t;const{withCards:s,withAssignments:i,withLabels:o,withDueDate:d,moveCardsToLeftStack:u,restoreArchivedCards:l}=a;try{const e=await p.cloneBoard(r,s,i,o,d,u,l);return n("cloneBoard",e),e}catch(e){return e}},removeBoard(e,t){let{commit:n}=e;n("removeBoard",t)},async loadBoards(e){let{commit:t}=e;t("setBoards",await p.loadBoards())},async loadSharees(e,t){let{commit:n}=e;const r=new URLSearchParams;if(void 0===t)return;r.append("search",t),r.append("format","json"),r.append("perPage",20),r.append("itemType",[0,1,4,7]),r.append("lookup",!1);n("setSharees",(await i.Ay.get((0,o.KT)("apps/files_sharing/api/v1/sharees"),{params:r})).data.ocs.data)},setBoardFilter(e,t){let{commmit:n}=e;n("setBoardFilter",t)},toggleNav(e,t){let{commit:n}=e;n("toggleNav",t)},toggleSidebar(e){let{commit:t}=e;t("toggleSidebar")},toggleCompactMode(e){let{commit:t}=e;t("toggleCompactMode")},toggleShowCardCover(e){let{commit:t}=e;t("toggleShowCardCover")},setCurrentBoard(e,t){let{commit:n}=e;n("setCurrentBoard",t)},setAssignableUsers(e,t){let{commit:n}=e;n("setAssignableUsers",t)},setCurrentCard(e,t){let{commit:n}=e;n("setCurrentCard",t)},removeLabelFromCurrentBoard(e,t){let{commit:n}=e;p.deleteLabel(t).then((e=>{n("removeLabelFromCurrentBoard",e.id)}))},updateLabelFromCurrentBoard(e,t){let{commit:n}=e;p.updateLabel(t).then((e=>{n("updateLabelFromCurrentBoard",e)}))},addLabelToCurrentBoard(e,t){let{commit:n}=e;t.boardId=this.state.currentBoard.id,p.createLabel(t).then((e=>{n("addLabelToCurrentBoard",e)}))},async addLabelToCurrentBoardAndCard(e,t){let{dispatch:n,commit:r}=e,{newLabel:a,card:s}=t;a.boardId=this.state.currentBoard.id;const i=await p.createLabel(a);return r("addLabelToCurrentBoard",i),n("addLabel",{card:s,labelId:i.id}),i},async addAclToCurrentBoard(e,t){let{dispatch:n,commit:r}=e;t.boardId=this.state.currentBoard.id;r("addAclToCurrentBoard",await p.addAcl(t)),n("refreshBoard",t.boardId)},updateAclFromCurrentBoard(e,t){let{commit:n}=e;t.boardId=this.state.currentBoard.id,p.updateAcl(t).then((e=>{n("updateAclFromCurrentBoard",e)}))},deleteAclFromCurrentBoard(e,t){let{dispatch:n,commit:r}=e;t.boardId=this.state.currentBoard.id,p.deleteAcl(t).then((e=>{r("deleteAclFromCurrentBoard",e),n("loadBoardById",e.boardId)}))},async transferOwnership(e,t){let{commit:n}=e,{boardId:r,newOwner:a}=t;await i.Ay.put((0,o.Jv)(`apps/deck/boards/${r}/transferOwner`),{newOwner:a})},toggleShortcutLock(e,t){let{commit:n}=e;n("TOGGLE_SHORTCUT_LOCK",t)}}})}},92676:(e,t,n)=>{"use strict";n.d(t,{A:()=>o});var r=n(85471),a=n(95353),s=n(74667);r.default.use(a.default);const i=new s.w,o={state:{assignedCards:[],loading:!1},getters:{assignedCardsDashboard:e=>e.assignedCards},mutations:{setAssignedCards(e,t){e.assignedCards=t},setLoading(e,t){e.loading=t}},actions:{async loadUpcoming(e){let{state:t,commit:n}=e;if(t.loading)return t.loading;const r=(async()=>{n("setCurrentBoard",null);const e=await i.get("upcoming"),t=Object.values(e).flat();for(const e in t)n("addCard",t[e]);n("setAssignedCards",e),n("setLoading",!1)})();return n("setLoading",r),r}}}},32947:(e,t,n)=>{"use strict";n.d(t,{A:()=>o});var r=n(85471),a=n(52628),s=n(18953);const i=new a.h;function o(){return{state:{stacks:[]},getters:{stacksByBoard:e=>t=>e.stacks.filter((e=>e.boardId===t)).sort(((e,t)=>e.order-t.order)),stackById:e=>t=>e.stacks.find((e=>e.id===t))},mutations:{addStack(e,t){const n=e.stacks.findIndex((e=>e.id===t.id));if(-1!==n){const a=e.stacks.find((e=>e.id===t.id));r.default.set(e.stacks,n,Object.assign({},a,t))}else e.stacks.push(t)},orderStack(e,t){let{stack:n,removedIndex:r,addedIndex:a}=t;const i=e.stacks.filter((e=>e.boardId===n.boardId)).sort(((e,t)=>e.order-t.order)),o=(0,s.A)(i,r,a);for(let e=0;e<o.length;e++)o[e].order=parseInt(e)},deleteStack(e,t){const n=e.stacks.findIndex((e=>e.id===t.id));-1!==n&&e.stacks.splice(n,1)},updateStack(e,t){const n=e.stacks.findIndex((e=>e.id===t.id));-1!==n&&(e.stacks[n].title=t.title)}},actions:{orderStack(e,t){let{commit:n}=e,{stack:r,removedIndex:a,addedIndex:s}=t;n("orderStack",{stack:r,removedIndex:a,addedIndex:s}),i.reorderStack(r.id,s).catch((e=>{OC.Notification.showTemporary("Failed to change order"),console.error(e.response.data.message),n("orderStack",{stack:r,addedIndex:s,removedIndex:a})}))},async loadStacks(e,t){let{commit:n}=e,r="loadStacks";!0===this.state.showArchived&&(r="loadArchivedStacks");const a=await i[r](t),s=[];for(const e in a){const t=a[e];for(const e in t.cards)s.push(t.cards[e]);delete t.cards,n("addStack",t)}n("setCards",s)},async loadArchivedStacks(e,t){let{commit:n,getters:r}=e;const a=await i.loadArchivedStacks(t),s=[];for(const e in a){const t=a[e];for(const e in t.cards)s.push(t.cards[e]);delete t.cards,r.stackById(t.id)||n("addStack",t)}n("setCards",s)},createStack(e,t){let{commit:n}=e;t.boardId=this.state.currentBoard.id,i.createStack(t).then((e=>{n("addStack",e)}))},deleteStack(e,t){let{commit:n}=e;i.deleteStack(t.id).then((e=>{n("deleteStack",e),n("moveStackToTrash",e)}))},updateStack(e,t){let{commit:n}=e;i.updateStack(t).then((e=>{n("updateStack",e)}))}}}}},58624:(e,t,n)=>{"use strict";n.d(t,{A:()=>o});var r=n(52628),a=n(476);const s=new r.h,i=new a.j,o={state:{deletedStacks:[],deletedCards:[]},mutations:{setDeletedStacks(e,t){e.deletedStacks=[],t.length>0&&(e.deletedStacks=t)},moveStackToTrash(e,t){t.deletedAt=Math.floor(Date.now()/1e3),e.deletedStacks.push(t)},removeStackFromTrash(e,t){const n=e.deletedStacks.findIndex((e=>e.id===t.id));-1!==n&&e.deletedStacks.splice(n,1)},setDeletedCards(e,t){e.deletedCards=[],e.deletedCards=t},moveCardToTrash(e,t){t.deletedAt=Math.floor(Date.now()/1e3),e.deletedCards.push(t)},removeCardFromTrash(e,t){const n=e.deletedCards.findIndex((e=>e.id===t.id));-1!==n&&e.deletedCards.splice(n,1)}},actions:{fetchDeletedItems(e,t){let{commit:n}=e;s.deletedStacks(t).then((e=>{n("setDeletedStacks",e)})),i.deletedCards(t).then((e=>{n("setDeletedCards",e)}))},stackUndoDelete(e,t){let{commit:n}=e;s.updateStack(t).then((e=>{n("addStack",e),n("removeStackFromTrash",e)}))},cardUndoDelete(e,t){let{commit:n}=e;i.updateCard(t).then((e=>{n("removeCardFromTrash",e),n("addCard",e)}))}}}},67526:(e,t)=>{"use strict";t.byteLength=function(e){var t=o(e),n=t[0],r=t[1];return 3*(n+r)/4-r},t.toByteArray=function(e){var t,n,s=o(e),i=s[0],d=s[1],u=new a(function(e,t,n){return 3*(t+n)/4-n}(0,i,d)),l=0,c=d>0?i-4:i;for(n=0;n<c;n+=4)t=r[e.charCodeAt(n)]<<18|r[e.charCodeAt(n+1)]<<12|r[e.charCodeAt(n+2)]<<6|r[e.charCodeAt(n+3)],u[l++]=t>>16&255,u[l++]=t>>8&255,u[l++]=255&t;2===d&&(t=r[e.charCodeAt(n)]<<2|r[e.charCodeAt(n+1)]>>4,u[l++]=255&t);1===d&&(t=r[e.charCodeAt(n)]<<10|r[e.charCodeAt(n+1)]<<4|r[e.charCodeAt(n+2)]>>2,u[l++]=t>>8&255,u[l++]=255&t);return u},t.fromByteArray=function(e){for(var t,r=e.length,a=r%3,s=[],i=16383,o=0,u=r-a;o<u;o+=i)s.push(d(e,o,o+i>u?u:o+i));1===a?(t=e[r-1],s.push(n[t>>2]+n[t<<4&63]+"==")):2===a&&(t=(e[r-2]<<8)+e[r-1],s.push(n[t>>10]+n[t>>4&63]+n[t<<2&63]+"="));return s.join("")};for(var n=[],r=[],a="undefined"!=typeof Uint8Array?Uint8Array:Array,s="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",i=0;i<64;++i)n[i]=s[i],r[s.charCodeAt(i)]=i;function o(e){var t=e.length;if(t%4>0)throw new Error("Invalid string. Length must be a multiple of 4");var n=e.indexOf("=");return-1===n&&(n=t),[n,n===t?0:4-n%4]}function d(e,t,r){for(var a,s,i=[],o=t;o<r;o+=3)a=(e[o]<<16&16711680)+(e[o+1]<<8&65280)+(255&e[o+2]),i.push(n[(s=a)>>18&63]+n[s>>12&63]+n[s>>6&63]+n[63&s]);return i.join("")}r["-".charCodeAt(0)]=62,r["_".charCodeAt(0)]=63},48287:(e,t,n)=>{"use strict";const r=n(67526),a=n(251),s="function"==typeof Symbol&&"function"==typeof Symbol.for?Symbol.for("nodejs.util.inspect.custom"):null;t.Buffer=d,t.SlowBuffer=function(e){+e!=e&&(e=0);return d.alloc(+e)},t.INSPECT_MAX_BYTES=50;const i=2147483647;function o(e){if(e>i)throw new RangeError('The value "'+e+'" is invalid for option "size"');const t=new Uint8Array(e);return Object.setPrototypeOf(t,d.prototype),t}function d(e,t,n){if("number"==typeof e){if("string"==typeof t)throw new TypeError('The "string" argument must be of type string. Received type number');return c(e)}return u(e,t,n)}function u(e,t,n){if("string"==typeof e)return function(e,t){"string"==typeof t&&""!==t||(t="utf8");if(!d.isEncoding(t))throw new TypeError("Unknown encoding: "+t);const n=0|f(e,t);let r=o(n);const a=r.write(e,t);a!==n&&(r=r.slice(0,a));return r}(e,t);if(ArrayBuffer.isView(e))return function(e){if(q(e,Uint8Array)){const t=new Uint8Array(e);return m(t.buffer,t.byteOffset,t.byteLength)}return _(e)}(e);if(null==e)throw new TypeError("The first argument must be one of type string, Buffer, ArrayBuffer, Array, or Array-like Object. Received type "+typeof e);if(q(e,ArrayBuffer)||e&&q(e.buffer,ArrayBuffer))return m(e,t,n);if("undefined"!=typeof SharedArrayBuffer&&(q(e,SharedArrayBuffer)||e&&q(e.buffer,SharedArrayBuffer)))return m(e,t,n);if("number"==typeof e)throw new TypeError('The "value" argument must not be of type number. Received type number');const r=e.valueOf&&e.valueOf();if(null!=r&&r!==e)return d.from(r,t,n);const a=function(e){if(d.isBuffer(e)){const t=0|h(e.length),n=o(t);return 0===n.length||e.copy(n,0,0,t),n}if(void 0!==e.length)return"number"!=typeof e.length||K(e.length)?o(0):_(e);if("Buffer"===e.type&&Array.isArray(e.data))return _(e.data)}(e);if(a)return a;if("undefined"!=typeof Symbol&&null!=Symbol.toPrimitive&&"function"==typeof e[Symbol.toPrimitive])return d.from(e[Symbol.toPrimitive]("string"),t,n);throw new TypeError("The first argument must be one of type string, Buffer, ArrayBuffer, Array, or Array-like Object. Received type "+typeof e)}function l(e){if("number"!=typeof e)throw new TypeError('"size" argument must be of type number');if(e<0)throw new RangeError('The value "'+e+'" is invalid for option "size"')}function c(e){return l(e),o(e<0?0:0|h(e))}function _(e){const t=e.length<0?0:0|h(e.length),n=o(t);for(let r=0;r<t;r+=1)n[r]=255&e[r];return n}function m(e,t,n){if(t<0||e.byteLength<t)throw new RangeError('"offset" is outside of buffer bounds');if(e.byteLength<t+(n||0))throw new RangeError('"length" is outside of buffer bounds');let r;return r=void 0===t&&void 0===n?new Uint8Array(e):void 0===n?new Uint8Array(e,t):new Uint8Array(e,t,n),Object.setPrototypeOf(r,d.prototype),r}function h(e){if(e>=i)throw new RangeError("Attempt to allocate Buffer larger than maximum size: 0x"+i.toString(16)+" bytes");return 0|e}function f(e,t){if(d.isBuffer(e))return e.length;if(ArrayBuffer.isView(e)||q(e,ArrayBuffer))return e.byteLength;if("string"!=typeof e)throw new TypeError('The "string" argument must be one of type string, Buffer, or ArrayBuffer. Received type '+typeof e);const n=e.length,r=arguments.length>2&&!0===arguments[2];if(!r&&0===n)return 0;let a=!1;for(;;)switch(t){case"ascii":case"latin1":case"binary":return n;case"utf8":case"utf-8":return J(e).length;case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return 2*n;case"hex":return n>>>1;case"base64":return G(e).length;default:if(a)return r?-1:J(e).length;t=(""+t).toLowerCase(),a=!0}}function p(e,t,n){let r=!1;if((void 0===t||t<0)&&(t=0),t>this.length)return"";if((void 0===n||n>this.length)&&(n=this.length),n<=0)return"";if((n>>>=0)<=(t>>>=0))return"";for(e||(e="utf8");;)switch(e){case"hex":return E(this,t,n);case"utf8":case"utf-8":return D(this,t,n);case"ascii":return S(this,t,n);case"latin1":case"binary":return j(this,t,n);case"base64":return b(this,t,n);case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return x(this,t,n);default:if(r)throw new TypeError("Unknown encoding: "+e);e=(e+"").toLowerCase(),r=!0}}function y(e,t,n){const r=e[t];e[t]=e[n],e[n]=r}function M(e,t,n,r,a){if(0===e.length)return-1;if("string"==typeof n?(r=n,n=0):n>2147483647?n=2147483647:n<-2147483648&&(n=-2147483648),K(n=+n)&&(n=a?0:e.length-1),n<0&&(n=e.length+n),n>=e.length){if(a)return-1;n=e.length-1}else if(n<0){if(!a)return-1;n=0}if("string"==typeof t&&(t=d.from(t,r)),d.isBuffer(t))return 0===t.length?-1:g(e,t,n,r,a);if("number"==typeof t)return t&=255,"function"==typeof Uint8Array.prototype.indexOf?a?Uint8Array.prototype.indexOf.call(e,t,n):Uint8Array.prototype.lastIndexOf.call(e,t,n):g(e,[t],n,r,a);throw new TypeError("val must be string, number or Buffer")}function g(e,t,n,r,a){let s,i=1,o=e.length,d=t.length;if(void 0!==r&&("ucs2"===(r=String(r).toLowerCase())||"ucs-2"===r||"utf16le"===r||"utf-16le"===r)){if(e.length<2||t.length<2)return-1;i=2,o/=2,d/=2,n/=2}function u(e,t){return 1===i?e[t]:e.readUInt16BE(t*i)}if(a){let r=-1;for(s=n;s<o;s++)if(u(e,s)===u(t,-1===r?0:s-r)){if(-1===r&&(r=s),s-r+1===d)return r*i}else-1!==r&&(s-=s-r),r=-1}else for(n+d>o&&(n=o-d),s=n;s>=0;s--){let n=!0;for(let r=0;r<d;r++)if(u(e,s+r)!==u(t,r)){n=!1;break}if(n)return s}return-1}function L(e,t,n,r){n=Number(n)||0;const a=e.length-n;r?(r=Number(r))>a&&(r=a):r=a;const s=t.length;let i;for(r>s/2&&(r=s/2),i=0;i<r;++i){const r=parseInt(t.substr(2*i,2),16);if(K(r))return i;e[n+i]=r}return i}function v(e,t,n,r){return V(J(t,e.length-n),e,n,r)}function Y(e,t,n,r){return V(function(e){const t=[];for(let n=0;n<e.length;++n)t.push(255&e.charCodeAt(n));return t}(t),e,n,r)}function w(e,t,n,r){return V(G(t),e,n,r)}function k(e,t,n,r){return V(function(e,t){let n,r,a;const s=[];for(let i=0;i<e.length&&!((t-=2)<0);++i)n=e.charCodeAt(i),r=n>>8,a=n%256,s.push(a),s.push(r);return s}(t,e.length-n),e,n,r)}function b(e,t,n){return 0===t&&n===e.length?r.fromByteArray(e):r.fromByteArray(e.slice(t,n))}function D(e,t,n){n=Math.min(e.length,n);const r=[];let a=t;for(;a<n;){const t=e[a];let s=null,i=t>239?4:t>223?3:t>191?2:1;if(a+i<=n){let n,r,o,d;switch(i){case 1:t<128&&(s=t);break;case 2:n=e[a+1],128==(192&n)&&(d=(31&t)<<6|63&n,d>127&&(s=d));break;case 3:n=e[a+1],r=e[a+2],128==(192&n)&&128==(192&r)&&(d=(15&t)<<12|(63&n)<<6|63&r,d>2047&&(d<55296||d>57343)&&(s=d));break;case 4:n=e[a+1],r=e[a+2],o=e[a+3],128==(192&n)&&128==(192&r)&&128==(192&o)&&(d=(15&t)<<18|(63&n)<<12|(63&r)<<6|63&o,d>65535&&d<1114112&&(s=d))}}null===s?(s=65533,i=1):s>65535&&(s-=65536,r.push(s>>>10&1023|55296),s=56320|1023&s),r.push(s),a+=i}return function(e){const t=e.length;if(t<=T)return String.fromCharCode.apply(String,e);let n="",r=0;for(;r<t;)n+=String.fromCharCode.apply(String,e.slice(r,r+=T));return n}(r)}t.kMaxLength=i,d.TYPED_ARRAY_SUPPORT=function(){try{const e=new Uint8Array(1),t={foo:function(){return 42}};return Object.setPrototypeOf(t,Uint8Array.prototype),Object.setPrototypeOf(e,t),42===e.foo()}catch(e){return!1}}(),d.TYPED_ARRAY_SUPPORT||"undefined"==typeof console||"function"!=typeof console.error||console.error("This browser lacks typed array (Uint8Array) support which is required by `buffer` v5.x. Use `buffer` v4.x if you require old browser support."),Object.defineProperty(d.prototype,"parent",{enumerable:!0,get:function(){if(d.isBuffer(this))return this.buffer}}),Object.defineProperty(d.prototype,"offset",{enumerable:!0,get:function(){if(d.isBuffer(this))return this.byteOffset}}),d.poolSize=8192,d.from=function(e,t,n){return u(e,t,n)},Object.setPrototypeOf(d.prototype,Uint8Array.prototype),Object.setPrototypeOf(d,Uint8Array),d.alloc=function(e,t,n){return function(e,t,n){return l(e),e<=0?o(e):void 0!==t?"string"==typeof n?o(e).fill(t,n):o(e).fill(t):o(e)}(e,t,n)},d.allocUnsafe=function(e){return c(e)},d.allocUnsafeSlow=function(e){return c(e)},d.isBuffer=function(e){return null!=e&&!0===e._isBuffer&&e!==d.prototype},d.compare=function(e,t){if(q(e,Uint8Array)&&(e=d.from(e,e.offset,e.byteLength)),q(t,Uint8Array)&&(t=d.from(t,t.offset,t.byteLength)),!d.isBuffer(e)||!d.isBuffer(t))throw new TypeError('The "buf1", "buf2" arguments must be one of type Buffer or Uint8Array');if(e===t)return 0;let n=e.length,r=t.length;for(let a=0,s=Math.min(n,r);a<s;++a)if(e[a]!==t[a]){n=e[a],r=t[a];break}return n<r?-1:r<n?1:0},d.isEncoding=function(e){switch(String(e).toLowerCase()){case"hex":case"utf8":case"utf-8":case"ascii":case"latin1":case"binary":case"base64":case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return!0;default:return!1}},d.concat=function(e,t){if(!Array.isArray(e))throw new TypeError('"list" argument must be an Array of Buffers');if(0===e.length)return d.alloc(0);let n;if(void 0===t)for(t=0,n=0;n<e.length;++n)t+=e[n].length;const r=d.allocUnsafe(t);let a=0;for(n=0;n<e.length;++n){let t=e[n];if(q(t,Uint8Array))a+t.length>r.length?(d.isBuffer(t)||(t=d.from(t)),t.copy(r,a)):Uint8Array.prototype.set.call(r,t,a);else{if(!d.isBuffer(t))throw new TypeError('"list" argument must be an Array of Buffers');t.copy(r,a)}a+=t.length}return r},d.byteLength=f,d.prototype._isBuffer=!0,d.prototype.swap16=function(){const e=this.length;if(e%2!=0)throw new RangeError("Buffer size must be a multiple of 16-bits");for(let t=0;t<e;t+=2)y(this,t,t+1);return this},d.prototype.swap32=function(){const e=this.length;if(e%4!=0)throw new RangeError("Buffer size must be a multiple of 32-bits");for(let t=0;t<e;t+=4)y(this,t,t+3),y(this,t+1,t+2);return this},d.prototype.swap64=function(){const e=this.length;if(e%8!=0)throw new RangeError("Buffer size must be a multiple of 64-bits");for(let t=0;t<e;t+=8)y(this,t,t+7),y(this,t+1,t+6),y(this,t+2,t+5),y(this,t+3,t+4);return this},d.prototype.toString=function(){const e=this.length;return 0===e?"":0===arguments.length?D(this,0,e):p.apply(this,arguments)},d.prototype.toLocaleString=d.prototype.toString,d.prototype.equals=function(e){if(!d.isBuffer(e))throw new TypeError("Argument must be a Buffer");return this===e||0===d.compare(this,e)},d.prototype.inspect=function(){let e="";const n=t.INSPECT_MAX_BYTES;return e=this.toString("hex",0,n).replace(/(.{2})/g,"$1 ").trim(),this.length>n&&(e+=" ... "),"<Buffer "+e+">"},s&&(d.prototype[s]=d.prototype.inspect),d.prototype.compare=function(e,t,n,r,a){if(q(e,Uint8Array)&&(e=d.from(e,e.offset,e.byteLength)),!d.isBuffer(e))throw new TypeError('The "target" argument must be one of type Buffer or Uint8Array. Received type '+typeof e);if(void 0===t&&(t=0),void 0===n&&(n=e?e.length:0),void 0===r&&(r=0),void 0===a&&(a=this.length),t<0||n>e.length||r<0||a>this.length)throw new RangeError("out of range index");if(r>=a&&t>=n)return 0;if(r>=a)return-1;if(t>=n)return 1;if(this===e)return 0;let s=(a>>>=0)-(r>>>=0),i=(n>>>=0)-(t>>>=0);const o=Math.min(s,i),u=this.slice(r,a),l=e.slice(t,n);for(let e=0;e<o;++e)if(u[e]!==l[e]){s=u[e],i=l[e];break}return s<i?-1:i<s?1:0},d.prototype.includes=function(e,t,n){return-1!==this.indexOf(e,t,n)},d.prototype.indexOf=function(e,t,n){return M(this,e,t,n,!0)},d.prototype.lastIndexOf=function(e,t,n){return M(this,e,t,n,!1)},d.prototype.write=function(e,t,n,r){if(void 0===t)r="utf8",n=this.length,t=0;else if(void 0===n&&"string"==typeof t)r=t,n=this.length,t=0;else{if(!isFinite(t))throw new Error("Buffer.write(string, encoding, offset[, length]) is no longer supported");t>>>=0,isFinite(n)?(n>>>=0,void 0===r&&(r="utf8")):(r=n,n=void 0)}const a=this.length-t;if((void 0===n||n>a)&&(n=a),e.length>0&&(n<0||t<0)||t>this.length)throw new RangeError("Attempt to write outside buffer bounds");r||(r="utf8");let s=!1;for(;;)switch(r){case"hex":return L(this,e,t,n);case"utf8":case"utf-8":return v(this,e,t,n);case"ascii":case"latin1":case"binary":return Y(this,e,t,n);case"base64":return w(this,e,t,n);case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return k(this,e,t,n);default:if(s)throw new TypeError("Unknown encoding: "+r);r=(""+r).toLowerCase(),s=!0}},d.prototype.toJSON=function(){return{type:"Buffer",data:Array.prototype.slice.call(this._arr||this,0)}};const T=4096;function S(e,t,n){let r="";n=Math.min(e.length,n);for(let a=t;a<n;++a)r+=String.fromCharCode(127&e[a]);return r}function j(e,t,n){let r="";n=Math.min(e.length,n);for(let a=t;a<n;++a)r+=String.fromCharCode(e[a]);return r}function E(e,t,n){const r=e.length;(!t||t<0)&&(t=0),(!n||n<0||n>r)&&(n=r);let a="";for(let r=t;r<n;++r)a+=Z[e[r]];return a}function x(e,t,n){const r=e.slice(t,n);let a="";for(let e=0;e<r.length-1;e+=2)a+=String.fromCharCode(r[e]+256*r[e+1]);return a}function O(e,t,n){if(e%1!=0||e<0)throw new RangeError("offset is not uint");if(e+t>n)throw new RangeError("Trying to access beyond buffer length")}function A(e,t,n,r,a,s){if(!d.isBuffer(e))throw new TypeError('"buffer" argument must be a Buffer instance');if(t>a||t<s)throw new RangeError('"value" argument is out of bounds');if(n+r>e.length)throw new RangeError("Index out of range")}function H(e,t,n,r,a){$(t,r,a,e,n,7);let s=Number(t&BigInt(4294967295));e[n++]=s,s>>=8,e[n++]=s,s>>=8,e[n++]=s,s>>=8,e[n++]=s;let i=Number(t>>BigInt(32)&BigInt(4294967295));return e[n++]=i,i>>=8,e[n++]=i,i>>=8,e[n++]=i,i>>=8,e[n++]=i,n}function P(e,t,n,r,a){$(t,r,a,e,n,7);let s=Number(t&BigInt(4294967295));e[n+7]=s,s>>=8,e[n+6]=s,s>>=8,e[n+5]=s,s>>=8,e[n+4]=s;let i=Number(t>>BigInt(32)&BigInt(4294967295));return e[n+3]=i,i>>=8,e[n+2]=i,i>>=8,e[n+1]=i,i>>=8,e[n]=i,n+8}function C(e,t,n,r,a,s){if(n+r>e.length)throw new RangeError("Index out of range");if(n<0)throw new RangeError("Index out of range")}function I(e,t,n,r,s){return t=+t,n>>>=0,s||C(e,0,n,4),a.write(e,t,n,r,23,4),n+4}function R(e,t,n,r,s){return t=+t,n>>>=0,s||C(e,0,n,8),a.write(e,t,n,r,52,8),n+8}d.prototype.slice=function(e,t){const n=this.length;(e=~~e)<0?(e+=n)<0&&(e=0):e>n&&(e=n),(t=void 0===t?n:~~t)<0?(t+=n)<0&&(t=0):t>n&&(t=n),t<e&&(t=e);const r=this.subarray(e,t);return Object.setPrototypeOf(r,d.prototype),r},d.prototype.readUintLE=d.prototype.readUIntLE=function(e,t,n){e>>>=0,t>>>=0,n||O(e,t,this.length);let r=this[e],a=1,s=0;for(;++s<t&&(a*=256);)r+=this[e+s]*a;return r},d.prototype.readUintBE=d.prototype.readUIntBE=function(e,t,n){e>>>=0,t>>>=0,n||O(e,t,this.length);let r=this[e+--t],a=1;for(;t>0&&(a*=256);)r+=this[e+--t]*a;return r},d.prototype.readUint8=d.prototype.readUInt8=function(e,t){return e>>>=0,t||O(e,1,this.length),this[e]},d.prototype.readUint16LE=d.prototype.readUInt16LE=function(e,t){return e>>>=0,t||O(e,2,this.length),this[e]|this[e+1]<<8},d.prototype.readUint16BE=d.prototype.readUInt16BE=function(e,t){return e>>>=0,t||O(e,2,this.length),this[e]<<8|this[e+1]},d.prototype.readUint32LE=d.prototype.readUInt32LE=function(e,t){return e>>>=0,t||O(e,4,this.length),(this[e]|this[e+1]<<8|this[e+2]<<16)+16777216*this[e+3]},d.prototype.readUint32BE=d.prototype.readUInt32BE=function(e,t){return e>>>=0,t||O(e,4,this.length),16777216*this[e]+(this[e+1]<<16|this[e+2]<<8|this[e+3])},d.prototype.readBigUInt64LE=X((function(e){U(e>>>=0,"offset");const t=this[e],n=this[e+7];void 0!==t&&void 0!==n||B(e,this.length-8);const r=t+256*this[++e]+65536*this[++e]+this[++e]*2**24,a=this[++e]+256*this[++e]+65536*this[++e]+n*2**24;return BigInt(r)+(BigInt(a)<<BigInt(32))})),d.prototype.readBigUInt64BE=X((function(e){U(e>>>=0,"offset");const t=this[e],n=this[e+7];void 0!==t&&void 0!==n||B(e,this.length-8);const r=t*2**24+65536*this[++e]+256*this[++e]+this[++e],a=this[++e]*2**24+65536*this[++e]+256*this[++e]+n;return(BigInt(r)<<BigInt(32))+BigInt(a)})),d.prototype.readIntLE=function(e,t,n){e>>>=0,t>>>=0,n||O(e,t,this.length);let r=this[e],a=1,s=0;for(;++s<t&&(a*=256);)r+=this[e+s]*a;return a*=128,r>=a&&(r-=Math.pow(2,8*t)),r},d.prototype.readIntBE=function(e,t,n){e>>>=0,t>>>=0,n||O(e,t,this.length);let r=t,a=1,s=this[e+--r];for(;r>0&&(a*=256);)s+=this[e+--r]*a;return a*=128,s>=a&&(s-=Math.pow(2,8*t)),s},d.prototype.readInt8=function(e,t){return e>>>=0,t||O(e,1,this.length),128&this[e]?-1*(255-this[e]+1):this[e]},d.prototype.readInt16LE=function(e,t){e>>>=0,t||O(e,2,this.length);const n=this[e]|this[e+1]<<8;return 32768&n?4294901760|n:n},d.prototype.readInt16BE=function(e,t){e>>>=0,t||O(e,2,this.length);const n=this[e+1]|this[e]<<8;return 32768&n?4294901760|n:n},d.prototype.readInt32LE=function(e,t){return e>>>=0,t||O(e,4,this.length),this[e]|this[e+1]<<8|this[e+2]<<16|this[e+3]<<24},d.prototype.readInt32BE=function(e,t){return e>>>=0,t||O(e,4,this.length),this[e]<<24|this[e+1]<<16|this[e+2]<<8|this[e+3]},d.prototype.readBigInt64LE=X((function(e){U(e>>>=0,"offset");const t=this[e],n=this[e+7];void 0!==t&&void 0!==n||B(e,this.length-8);const r=this[e+4]+256*this[e+5]+65536*this[e+6]+(n<<24);return(BigInt(r)<<BigInt(32))+BigInt(t+256*this[++e]+65536*this[++e]+this[++e]*2**24)})),d.prototype.readBigInt64BE=X((function(e){U(e>>>=0,"offset");const t=this[e],n=this[e+7];void 0!==t&&void 0!==n||B(e,this.length-8);const r=(t<<24)+65536*this[++e]+256*this[++e]+this[++e];return(BigInt(r)<<BigInt(32))+BigInt(this[++e]*2**24+65536*this[++e]+256*this[++e]+n)})),d.prototype.readFloatLE=function(e,t){return e>>>=0,t||O(e,4,this.length),a.read(this,e,!0,23,4)},d.prototype.readFloatBE=function(e,t){return e>>>=0,t||O(e,4,this.length),a.read(this,e,!1,23,4)},d.prototype.readDoubleLE=function(e,t){return e>>>=0,t||O(e,8,this.length),a.read(this,e,!0,52,8)},d.prototype.readDoubleBE=function(e,t){return e>>>=0,t||O(e,8,this.length),a.read(this,e,!1,52,8)},d.prototype.writeUintLE=d.prototype.writeUIntLE=function(e,t,n,r){if(e=+e,t>>>=0,n>>>=0,!r){A(this,e,t,n,Math.pow(2,8*n)-1,0)}let a=1,s=0;for(this[t]=255&e;++s<n&&(a*=256);)this[t+s]=e/a&255;return t+n},d.prototype.writeUintBE=d.prototype.writeUIntBE=function(e,t,n,r){if(e=+e,t>>>=0,n>>>=0,!r){A(this,e,t,n,Math.pow(2,8*n)-1,0)}let a=n-1,s=1;for(this[t+a]=255&e;--a>=0&&(s*=256);)this[t+a]=e/s&255;return t+n},d.prototype.writeUint8=d.prototype.writeUInt8=function(e,t,n){return e=+e,t>>>=0,n||A(this,e,t,1,255,0),this[t]=255&e,t+1},d.prototype.writeUint16LE=d.prototype.writeUInt16LE=function(e,t,n){return e=+e,t>>>=0,n||A(this,e,t,2,65535,0),this[t]=255&e,this[t+1]=e>>>8,t+2},d.prototype.writeUint16BE=d.prototype.writeUInt16BE=function(e,t,n){return e=+e,t>>>=0,n||A(this,e,t,2,65535,0),this[t]=e>>>8,this[t+1]=255&e,t+2},d.prototype.writeUint32LE=d.prototype.writeUInt32LE=function(e,t,n){return e=+e,t>>>=0,n||A(this,e,t,4,4294967295,0),this[t+3]=e>>>24,this[t+2]=e>>>16,this[t+1]=e>>>8,this[t]=255&e,t+4},d.prototype.writeUint32BE=d.prototype.writeUInt32BE=function(e,t,n){return e=+e,t>>>=0,n||A(this,e,t,4,4294967295,0),this[t]=e>>>24,this[t+1]=e>>>16,this[t+2]=e>>>8,this[t+3]=255&e,t+4},d.prototype.writeBigUInt64LE=X((function(e,t=0){return H(this,e,t,BigInt(0),BigInt("0xffffffffffffffff"))})),d.prototype.writeBigUInt64BE=X((function(e,t=0){return P(this,e,t,BigInt(0),BigInt("0xffffffffffffffff"))})),d.prototype.writeIntLE=function(e,t,n,r){if(e=+e,t>>>=0,!r){const r=Math.pow(2,8*n-1);A(this,e,t,n,r-1,-r)}let a=0,s=1,i=0;for(this[t]=255&e;++a<n&&(s*=256);)e<0&&0===i&&0!==this[t+a-1]&&(i=1),this[t+a]=(e/s|0)-i&255;return t+n},d.prototype.writeIntBE=function(e,t,n,r){if(e=+e,t>>>=0,!r){const r=Math.pow(2,8*n-1);A(this,e,t,n,r-1,-r)}let a=n-1,s=1,i=0;for(this[t+a]=255&e;--a>=0&&(s*=256);)e<0&&0===i&&0!==this[t+a+1]&&(i=1),this[t+a]=(e/s|0)-i&255;return t+n},d.prototype.writeInt8=function(e,t,n){return e=+e,t>>>=0,n||A(this,e,t,1,127,-128),e<0&&(e=255+e+1),this[t]=255&e,t+1},d.prototype.writeInt16LE=function(e,t,n){return e=+e,t>>>=0,n||A(this,e,t,2,32767,-32768),this[t]=255&e,this[t+1]=e>>>8,t+2},d.prototype.writeInt16BE=function(e,t,n){return e=+e,t>>>=0,n||A(this,e,t,2,32767,-32768),this[t]=e>>>8,this[t+1]=255&e,t+2},d.prototype.writeInt32LE=function(e,t,n){return e=+e,t>>>=0,n||A(this,e,t,4,2147483647,-2147483648),this[t]=255&e,this[t+1]=e>>>8,this[t+2]=e>>>16,this[t+3]=e>>>24,t+4},d.prototype.writeInt32BE=function(e,t,n){return e=+e,t>>>=0,n||A(this,e,t,4,2147483647,-2147483648),e<0&&(e=4294967295+e+1),this[t]=e>>>24,this[t+1]=e>>>16,this[t+2]=e>>>8,this[t+3]=255&e,t+4},d.prototype.writeBigInt64LE=X((function(e,t=0){return H(this,e,t,-BigInt("0x8000000000000000"),BigInt("0x7fffffffffffffff"))})),d.prototype.writeBigInt64BE=X((function(e,t=0){return P(this,e,t,-BigInt("0x8000000000000000"),BigInt("0x7fffffffffffffff"))})),d.prototype.writeFloatLE=function(e,t,n){return I(this,e,t,!0,n)},d.prototype.writeFloatBE=function(e,t,n){return I(this,e,t,!1,n)},d.prototype.writeDoubleLE=function(e,t,n){return R(this,e,t,!0,n)},d.prototype.writeDoubleBE=function(e,t,n){return R(this,e,t,!1,n)},d.prototype.copy=function(e,t,n,r){if(!d.isBuffer(e))throw new TypeError("argument should be a Buffer");if(n||(n=0),r||0===r||(r=this.length),t>=e.length&&(t=e.length),t||(t=0),r>0&&r<n&&(r=n),r===n)return 0;if(0===e.length||0===this.length)return 0;if(t<0)throw new RangeError("targetStart out of bounds");if(n<0||n>=this.length)throw new RangeError("Index out of range");if(r<0)throw new RangeError("sourceEnd out of bounds");r>this.length&&(r=this.length),e.length-t<r-n&&(r=e.length-t+n);const a=r-n;return this===e&&"function"==typeof Uint8Array.prototype.copyWithin?this.copyWithin(t,n,r):Uint8Array.prototype.set.call(e,this.subarray(n,r),t),a},d.prototype.fill=function(e,t,n,r){if("string"==typeof e){if("string"==typeof t?(r=t,t=0,n=this.length):"string"==typeof n&&(r=n,n=this.length),void 0!==r&&"string"!=typeof r)throw new TypeError("encoding must be a string");if("string"==typeof r&&!d.isEncoding(r))throw new TypeError("Unknown encoding: "+r);if(1===e.length){const t=e.charCodeAt(0);("utf8"===r&&t<128||"latin1"===r)&&(e=t)}}else"number"==typeof e?e&=255:"boolean"==typeof e&&(e=Number(e));if(t<0||this.length<t||this.length<n)throw new RangeError("Out of range index");if(n<=t)return this;let a;if(t>>>=0,n=void 0===n?this.length:n>>>0,e||(e=0),"number"==typeof e)for(a=t;a<n;++a)this[a]=e;else{const s=d.isBuffer(e)?e:d.from(e,r),i=s.length;if(0===i)throw new TypeError('The value "'+e+'" is invalid for argument "value"');for(a=0;a<n-t;++a)this[a+t]=s[a%i]}return this};const N={};function F(e,t,n){N[e]=class extends n{constructor(){super(),Object.defineProperty(this,"message",{value:t.apply(this,arguments),writable:!0,configurable:!0}),this.name=`${this.name} [${e}]`,this.stack,delete this.name}get code(){return e}set code(e){Object.defineProperty(this,"code",{configurable:!0,enumerable:!0,value:e,writable:!0})}toString(){return`${this.name} [${e}]: ${this.message}`}}}function W(e){let t="",n=e.length;const r="-"===e[0]?1:0;for(;n>=r+4;n-=3)t=`_${e.slice(n-3,n)}${t}`;return`${e.slice(0,n)}${t}`}function $(e,t,n,r,a,s){if(e>n||e<t){const r="bigint"==typeof t?"n":"";let a;throw a=s>3?0===t||t===BigInt(0)?`>= 0${r} and < 2${r} ** ${8*(s+1)}${r}`:`>= -(2${r} ** ${8*(s+1)-1}${r}) and < 2 ** ${8*(s+1)-1}${r}`:`>= ${t}${r} and <= ${n}${r}`,new N.ERR_OUT_OF_RANGE("value",a,e)}!function(e,t,n){U(t,"offset"),void 0!==e[t]&&void 0!==e[t+n]||B(t,e.length-(n+1))}(r,a,s)}function U(e,t){if("number"!=typeof e)throw new N.ERR_INVALID_ARG_TYPE(t,"number",e)}function B(e,t,n){if(Math.floor(e)!==e)throw U(e,n),new N.ERR_OUT_OF_RANGE(n||"offset","an integer",e);if(t<0)throw new N.ERR_BUFFER_OUT_OF_BOUNDS;throw new N.ERR_OUT_OF_RANGE(n||"offset",`>= ${n?1:0} and <= ${t}`,e)}F("ERR_BUFFER_OUT_OF_BOUNDS",(function(e){return e?`${e} is outside of buffer bounds`:"Attempt to access memory outside buffer bounds"}),RangeError),F("ERR_INVALID_ARG_TYPE",(function(e,t){return`The "${e}" argument must be of type number. Received type ${typeof t}`}),TypeError),F("ERR_OUT_OF_RANGE",(function(e,t,n){let r=`The value of "${e}" is out of range.`,a=n;return Number.isInteger(n)&&Math.abs(n)>2**32?a=W(String(n)):"bigint"==typeof n&&(a=String(n),(n>BigInt(2)**BigInt(32)||n<-(BigInt(2)**BigInt(32)))&&(a=W(a)),a+="n"),r+=` It must be ${t}. Received ${a}`,r}),RangeError);const z=/[^+/0-9A-Za-z-_]/g;function J(e,t){let n;t=t||1/0;const r=e.length;let a=null;const s=[];for(let i=0;i<r;++i){if(n=e.charCodeAt(i),n>55295&&n<57344){if(!a){if(n>56319){(t-=3)>-1&&s.push(239,191,189);continue}if(i+1===r){(t-=3)>-1&&s.push(239,191,189);continue}a=n;continue}if(n<56320){(t-=3)>-1&&s.push(239,191,189),a=n;continue}n=65536+(a-55296<<10|n-56320)}else a&&(t-=3)>-1&&s.push(239,191,189);if(a=null,n<128){if((t-=1)<0)break;s.push(n)}else if(n<2048){if((t-=2)<0)break;s.push(n>>6|192,63&n|128)}else if(n<65536){if((t-=3)<0)break;s.push(n>>12|224,n>>6&63|128,63&n|128)}else{if(!(n<1114112))throw new Error("Invalid code point");if((t-=4)<0)break;s.push(n>>18|240,n>>12&63|128,n>>6&63|128,63&n|128)}}return s}function G(e){return r.toByteArray(function(e){if((e=(e=e.split("=")[0]).trim().replace(z,"")).length<2)return"";for(;e.length%4!=0;)e+="=";return e}(e))}function V(e,t,n,r){let a;for(a=0;a<r&&!(a+n>=t.length||a>=e.length);++a)t[a+n]=e[a];return a}function q(e,t){return e instanceof t||null!=e&&null!=e.constructor&&null!=e.constructor.name&&e.constructor.name===t.name}function K(e){return e!=e}const Z=function(){const e="0123456789abcdef",t=new Array(256);for(let n=0;n<16;++n){const r=16*n;for(let a=0;a<16;++a)t[r+a]=e[n]+e[a]}return t}();function X(e){return"undefined"==typeof BigInt?Q:e}function Q(){throw new Error("BigInt not supported")}},70580:e=>{"use strict";var t=/["'&<>]/;e.exports=function(e){var n,r=""+e,a=t.exec(r);if(!a)return r;var s="",i=0,o=0;for(i=a.index;i<r.length;i++){switch(r.charCodeAt(i)){case 34:n="&quot;";break;case 38:n="&amp;";break;case 39:n="&#39;";break;case 60:n="&lt;";break;case 62:n="&gt;";break;default:continue}o!==i&&(s+=r.substring(o,i)),o=i+1,s+=n}return o!==i?s+r.substring(o,i):s}},251:(e,t)=>{t.read=function(e,t,n,r,a){var s,i,o=8*a-r-1,d=(1<<o)-1,u=d>>1,l=-7,c=n?a-1:0,_=n?-1:1,m=e[t+c];for(c+=_,s=m&(1<<-l)-1,m>>=-l,l+=o;l>0;s=256*s+e[t+c],c+=_,l-=8);for(i=s&(1<<-l)-1,s>>=-l,l+=r;l>0;i=256*i+e[t+c],c+=_,l-=8);if(0===s)s=1-u;else{if(s===d)return i?NaN:1/0*(m?-1:1);i+=Math.pow(2,r),s-=u}return(m?-1:1)*i*Math.pow(2,s-r)},t.write=function(e,t,n,r,a,s){var i,o,d,u=8*s-a-1,l=(1<<u)-1,c=l>>1,_=23===a?Math.pow(2,-24)-Math.pow(2,-77):0,m=r?0:s-1,h=r?1:-1,f=t<0||0===t&&1/t<0?1:0;for(t=Math.abs(t),isNaN(t)||t===1/0?(o=isNaN(t)?1:0,i=l):(i=Math.floor(Math.log(t)/Math.LN2),t*(d=Math.pow(2,-i))<1&&(i--,d*=2),(t+=i+c>=1?_/d:_*Math.pow(2,1-c))*d>=2&&(i++,d/=2),i+c>=l?(o=0,i=l):i+c>=1?(o=(t*d-1)*Math.pow(2,a),i+=c):(o=t*Math.pow(2,c-1)*Math.pow(2,a),i=0));a>=8;e[n+m]=255&o,m+=h,o/=256,a-=8);for(i=i<<a|o,u+=a;u>0;e[n+m]=255&i,m+=h,i/=256,u-=8);e[n+m-h]|=128*f}},25177:function(e,t,n){!function(e){"use strict";e.defineLocale("af",{months:"Januarie_Februarie_Maart_April_Mei_Junie_Julie_Augustus_September_Oktober_November_Desember".split("_"),monthsShort:"Jan_Feb_Mrt_Apr_Mei_Jun_Jul_Aug_Sep_Okt_Nov_Des".split("_"),weekdays:"Sondag_Maandag_Dinsdag_Woensdag_Donderdag_Vrydag_Saterdag".split("_"),weekdaysShort:"Son_Maa_Din_Woe_Don_Vry_Sat".split("_"),weekdaysMin:"So_Ma_Di_Wo_Do_Vr_Sa".split("_"),meridiemParse:/vm|nm/i,isPM:function(e){return/^nm$/i.test(e)},meridiem:function(e,t,n){return e<12?n?"vm":"VM":n?"nm":"NM"},longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[Vandag om] LT",nextDay:"[Môre om] LT",nextWeek:"dddd [om] LT",lastDay:"[Gister om] LT",lastWeek:"[Laas] dddd [om] LT",sameElse:"L"},relativeTime:{future:"oor %s",past:"%s gelede",s:"'n paar sekondes",ss:"%d sekondes",m:"'n minuut",mm:"%d minute",h:"'n uur",hh:"%d ure",d:"'n dag",dd:"%d dae",M:"'n maand",MM:"%d maande",y:"'n jaar",yy:"%d jaar"},dayOfMonthOrdinalParse:/\d{1,2}(ste|de)/,ordinal:function(e){return e+(1===e||8===e||e>=20?"ste":"de")},week:{dow:1,doy:4}})}(n(95093))},41488:function(e,t,n){!function(e){"use strict";var t=function(e){return 0===e?0:1===e?1:2===e?2:e%100>=3&&e%100<=10?3:e%100>=11?4:5},n={s:["أقل من ثانية","ثانية واحدة",["ثانيتان","ثانيتين"],"%d ثوان","%d ثانية","%d ثانية"],m:["أقل من دقيقة","دقيقة واحدة",["دقيقتان","دقيقتين"],"%d دقائق","%d دقيقة","%d دقيقة"],h:["أقل من ساعة","ساعة واحدة",["ساعتان","ساعتين"],"%d ساعات","%d ساعة","%d ساعة"],d:["أقل من يوم","يوم واحد",["يومان","يومين"],"%d أيام","%d يومًا","%d يوم"],M:["أقل من شهر","شهر واحد",["شهران","شهرين"],"%d أشهر","%d شهرا","%d شهر"],y:["أقل من عام","عام واحد",["عامان","عامين"],"%d أعوام","%d عامًا","%d عام"]},r=function(e){return function(r,a,s,i){var o=t(r),d=n[e][t(r)];return 2===o&&(d=d[a?0:1]),d.replace(/%d/i,r)}},a=["جانفي","فيفري","مارس","أفريل","ماي","جوان","جويلية","أوت","سبتمبر","أكتوبر","نوفمبر","ديسمبر"];e.defineLocale("ar-dz",{months:a,monthsShort:a,weekdays:"الأحد_الإثنين_الثلاثاء_الأربعاء_الخميس_الجمعة_السبت".split("_"),weekdaysShort:"أحد_إثنين_ثلاثاء_أربعاء_خميس_جمعة_سبت".split("_"),weekdaysMin:"ح_ن_ث_ر_خ_ج_س".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"D/‏M/‏YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},meridiemParse:/ص|م/,isPM:function(e){return"م"===e},meridiem:function(e,t,n){return e<12?"ص":"م"},calendar:{sameDay:"[اليوم عند الساعة] LT",nextDay:"[غدًا عند الساعة] LT",nextWeek:"dddd [عند الساعة] LT",lastDay:"[أمس عند الساعة] LT",lastWeek:"dddd [عند الساعة] LT",sameElse:"L"},relativeTime:{future:"بعد %s",past:"منذ %s",s:r("s"),ss:r("s"),m:r("m"),mm:r("m"),h:r("h"),hh:r("h"),d:r("d"),dd:r("d"),M:r("M"),MM:r("M"),y:r("y"),yy:r("y")},postformat:function(e){return e.replace(/,/g,"،")},week:{dow:0,doy:4}})}(n(95093))},58676:function(e,t,n){!function(e){"use strict";e.defineLocale("ar-kw",{months:"يناير_فبراير_مارس_أبريل_ماي_يونيو_يوليوز_غشت_شتنبر_أكتوبر_نونبر_دجنبر".split("_"),monthsShort:"يناير_فبراير_مارس_أبريل_ماي_يونيو_يوليوز_غشت_شتنبر_أكتوبر_نونبر_دجنبر".split("_"),weekdays:"الأحد_الإتنين_الثلاثاء_الأربعاء_الخميس_الجمعة_السبت".split("_"),weekdaysShort:"احد_اتنين_ثلاثاء_اربعاء_خميس_جمعة_سبت".split("_"),weekdaysMin:"ح_ن_ث_ر_خ_ج_س".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},calendar:{sameDay:"[اليوم على الساعة] LT",nextDay:"[غدا على الساعة] LT",nextWeek:"dddd [على الساعة] LT",lastDay:"[أمس على الساعة] LT",lastWeek:"dddd [على الساعة] LT",sameElse:"L"},relativeTime:{future:"في %s",past:"منذ %s",s:"ثوان",ss:"%d ثانية",m:"دقيقة",mm:"%d دقائق",h:"ساعة",hh:"%d ساعات",d:"يوم",dd:"%d أيام",M:"شهر",MM:"%d أشهر",y:"سنة",yy:"%d سنوات"},week:{dow:0,doy:12}})}(n(95093))},42353:function(e,t,n){!function(e){"use strict";var t={1:"1",2:"2",3:"3",4:"4",5:"5",6:"6",7:"7",8:"8",9:"9",0:"0"},n=function(e){return 0===e?0:1===e?1:2===e?2:e%100>=3&&e%100<=10?3:e%100>=11?4:5},r={s:["أقل من ثانية","ثانية واحدة",["ثانيتان","ثانيتين"],"%d ثوان","%d ثانية","%d ثانية"],m:["أقل من دقيقة","دقيقة واحدة",["دقيقتان","دقيقتين"],"%d دقائق","%d دقيقة","%d دقيقة"],h:["أقل من ساعة","ساعة واحدة",["ساعتان","ساعتين"],"%d ساعات","%d ساعة","%d ساعة"],d:["أقل من يوم","يوم واحد",["يومان","يومين"],"%d أيام","%d يومًا","%d يوم"],M:["أقل من شهر","شهر واحد",["شهران","شهرين"],"%d أشهر","%d شهرا","%d شهر"],y:["أقل من عام","عام واحد",["عامان","عامين"],"%d أعوام","%d عامًا","%d عام"]},a=function(e){return function(t,a,s,i){var o=n(t),d=r[e][n(t)];return 2===o&&(d=d[a?0:1]),d.replace(/%d/i,t)}},s=["يناير","فبراير","مارس","أبريل","مايو","يونيو","يوليو","أغسطس","سبتمبر","أكتوبر","نوفمبر","ديسمبر"];e.defineLocale("ar-ly",{months:s,monthsShort:s,weekdays:"الأحد_الإثنين_الثلاثاء_الأربعاء_الخميس_الجمعة_السبت".split("_"),weekdaysShort:"أحد_إثنين_ثلاثاء_أربعاء_خميس_جمعة_سبت".split("_"),weekdaysMin:"ح_ن_ث_ر_خ_ج_س".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"D/‏M/‏YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},meridiemParse:/ص|م/,isPM:function(e){return"م"===e},meridiem:function(e,t,n){return e<12?"ص":"م"},calendar:{sameDay:"[اليوم عند الساعة] LT",nextDay:"[غدًا عند الساعة] LT",nextWeek:"dddd [عند الساعة] LT",lastDay:"[أمس عند الساعة] LT",lastWeek:"dddd [عند الساعة] LT",sameElse:"L"},relativeTime:{future:"بعد %s",past:"منذ %s",s:a("s"),ss:a("s"),m:a("m"),mm:a("m"),h:a("h"),hh:a("h"),d:a("d"),dd:a("d"),M:a("M"),MM:a("M"),y:a("y"),yy:a("y")},preparse:function(e){return e.replace(/،/g,",")},postformat:function(e){return e.replace(/\d/g,(function(e){return t[e]})).replace(/,/g,"،")},week:{dow:6,doy:12}})}(n(95093))},24496:function(e,t,n){!function(e){"use strict";e.defineLocale("ar-ma",{months:"يناير_فبراير_مارس_أبريل_ماي_يونيو_يوليوز_غشت_شتنبر_أكتوبر_نونبر_دجنبر".split("_"),monthsShort:"يناير_فبراير_مارس_أبريل_ماي_يونيو_يوليوز_غشت_شتنبر_أكتوبر_نونبر_دجنبر".split("_"),weekdays:"الأحد_الإثنين_الثلاثاء_الأربعاء_الخميس_الجمعة_السبت".split("_"),weekdaysShort:"احد_اثنين_ثلاثاء_اربعاء_خميس_جمعة_سبت".split("_"),weekdaysMin:"ح_ن_ث_ر_خ_ج_س".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},calendar:{sameDay:"[اليوم على الساعة] LT",nextDay:"[غدا على الساعة] LT",nextWeek:"dddd [على الساعة] LT",lastDay:"[أمس على الساعة] LT",lastWeek:"dddd [على الساعة] LT",sameElse:"L"},relativeTime:{future:"في %s",past:"منذ %s",s:"ثوان",ss:"%d ثانية",m:"دقيقة",mm:"%d دقائق",h:"ساعة",hh:"%d ساعات",d:"يوم",dd:"%d أيام",M:"شهر",MM:"%d أشهر",y:"سنة",yy:"%d سنوات"},week:{dow:1,doy:4}})}(n(95093))},6947:function(e,t,n){!function(e){"use strict";var t={1:"١",2:"٢",3:"٣",4:"٤",5:"٥",6:"٦",7:"٧",8:"٨",9:"٩",0:"٠"},n={"١":"1","٢":"2","٣":"3","٤":"4","٥":"5","٦":"6","٧":"7","٨":"8","٩":"9","٠":"0"};e.defineLocale("ar-ps",{months:"كانون الثاني_شباط_آذار_نيسان_أيّار_حزيران_تمّوز_آب_أيلول_تشري الأوّل_تشرين الثاني_كانون الأوّل".split("_"),monthsShort:"ك٢_شباط_آذار_نيسان_أيّار_حزيران_تمّوز_آب_أيلول_ت١_ت٢_ك١".split("_"),weekdays:"الأحد_الإثنين_الثلاثاء_الأربعاء_الخميس_الجمعة_السبت".split("_"),weekdaysShort:"أحد_إثنين_ثلاثاء_أربعاء_خميس_جمعة_سبت".split("_"),weekdaysMin:"ح_ن_ث_ر_خ_ج_س".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},meridiemParse:/ص|م/,isPM:function(e){return"م"===e},meridiem:function(e,t,n){return e<12?"ص":"م"},calendar:{sameDay:"[اليوم على الساعة] LT",nextDay:"[غدا على الساعة] LT",nextWeek:"dddd [على الساعة] LT",lastDay:"[أمس على الساعة] LT",lastWeek:"dddd [على الساعة] LT",sameElse:"L"},relativeTime:{future:"في %s",past:"منذ %s",s:"ثوان",ss:"%d ثانية",m:"دقيقة",mm:"%d دقائق",h:"ساعة",hh:"%d ساعات",d:"يوم",dd:"%d أيام",M:"شهر",MM:"%d أشهر",y:"سنة",yy:"%d سنوات"},preparse:function(e){return e.replace(/[٣٤٥٦٧٨٩٠]/g,(function(e){return n[e]})).split("").reverse().join("").replace(/[١٢](?![\u062a\u0643])/g,(function(e){return n[e]})).split("").reverse().join("").replace(/،/g,",")},postformat:function(e){return e.replace(/\d/g,(function(e){return t[e]})).replace(/,/g,"،")},week:{dow:0,doy:6}})}(n(95093))},82682:function(e,t,n){!function(e){"use strict";var t={1:"١",2:"٢",3:"٣",4:"٤",5:"٥",6:"٦",7:"٧",8:"٨",9:"٩",0:"٠"},n={"١":"1","٢":"2","٣":"3","٤":"4","٥":"5","٦":"6","٧":"7","٨":"8","٩":"9","٠":"0"};e.defineLocale("ar-sa",{months:"يناير_فبراير_مارس_أبريل_مايو_يونيو_يوليو_أغسطس_سبتمبر_أكتوبر_نوفمبر_ديسمبر".split("_"),monthsShort:"يناير_فبراير_مارس_أبريل_مايو_يونيو_يوليو_أغسطس_سبتمبر_أكتوبر_نوفمبر_ديسمبر".split("_"),weekdays:"الأحد_الإثنين_الثلاثاء_الأربعاء_الخميس_الجمعة_السبت".split("_"),weekdaysShort:"أحد_إثنين_ثلاثاء_أربعاء_خميس_جمعة_سبت".split("_"),weekdaysMin:"ح_ن_ث_ر_خ_ج_س".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},meridiemParse:/ص|م/,isPM:function(e){return"م"===e},meridiem:function(e,t,n){return e<12?"ص":"م"},calendar:{sameDay:"[اليوم على الساعة] LT",nextDay:"[غدا على الساعة] LT",nextWeek:"dddd [على الساعة] LT",lastDay:"[أمس على الساعة] LT",lastWeek:"dddd [على الساعة] LT",sameElse:"L"},relativeTime:{future:"في %s",past:"منذ %s",s:"ثوان",ss:"%d ثانية",m:"دقيقة",mm:"%d دقائق",h:"ساعة",hh:"%d ساعات",d:"يوم",dd:"%d أيام",M:"شهر",MM:"%d أشهر",y:"سنة",yy:"%d سنوات"},preparse:function(e){return e.replace(/[١٢٣٤٥٦٧٨٩٠]/g,(function(e){return n[e]})).replace(/،/g,",")},postformat:function(e){return e.replace(/\d/g,(function(e){return t[e]})).replace(/,/g,"،")},week:{dow:0,doy:6}})}(n(95093))},89756:function(e,t,n){!function(e){"use strict";e.defineLocale("ar-tn",{months:"جانفي_فيفري_مارس_أفريل_ماي_جوان_جويلية_أوت_سبتمبر_أكتوبر_نوفمبر_ديسمبر".split("_"),monthsShort:"جانفي_فيفري_مارس_أفريل_ماي_جوان_جويلية_أوت_سبتمبر_أكتوبر_نوفمبر_ديسمبر".split("_"),weekdays:"الأحد_الإثنين_الثلاثاء_الأربعاء_الخميس_الجمعة_السبت".split("_"),weekdaysShort:"أحد_إثنين_ثلاثاء_أربعاء_خميس_جمعة_سبت".split("_"),weekdaysMin:"ح_ن_ث_ر_خ_ج_س".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},calendar:{sameDay:"[اليوم على الساعة] LT",nextDay:"[غدا على الساعة] LT",nextWeek:"dddd [على الساعة] LT",lastDay:"[أمس على الساعة] LT",lastWeek:"dddd [على الساعة] LT",sameElse:"L"},relativeTime:{future:"في %s",past:"منذ %s",s:"ثوان",ss:"%d ثانية",m:"دقيقة",mm:"%d دقائق",h:"ساعة",hh:"%d ساعات",d:"يوم",dd:"%d أيام",M:"شهر",MM:"%d أشهر",y:"سنة",yy:"%d سنوات"},week:{dow:1,doy:4}})}(n(95093))},61509:function(e,t,n){!function(e){"use strict";var t={1:"١",2:"٢",3:"٣",4:"٤",5:"٥",6:"٦",7:"٧",8:"٨",9:"٩",0:"٠"},n={"١":"1","٢":"2","٣":"3","٤":"4","٥":"5","٦":"6","٧":"7","٨":"8","٩":"9","٠":"0"},r=function(e){return 0===e?0:1===e?1:2===e?2:e%100>=3&&e%100<=10?3:e%100>=11?4:5},a={s:["أقل من ثانية","ثانية واحدة",["ثانيتان","ثانيتين"],"%d ثوان","%d ثانية","%d ثانية"],m:["أقل من دقيقة","دقيقة واحدة",["دقيقتان","دقيقتين"],"%d دقائق","%d دقيقة","%d دقيقة"],h:["أقل من ساعة","ساعة واحدة",["ساعتان","ساعتين"],"%d ساعات","%d ساعة","%d ساعة"],d:["أقل من يوم","يوم واحد",["يومان","يومين"],"%d أيام","%d يومًا","%d يوم"],M:["أقل من شهر","شهر واحد",["شهران","شهرين"],"%d أشهر","%d شهرا","%d شهر"],y:["أقل من عام","عام واحد",["عامان","عامين"],"%d أعوام","%d عامًا","%d عام"]},s=function(e){return function(t,n,s,i){var o=r(t),d=a[e][r(t)];return 2===o&&(d=d[n?0:1]),d.replace(/%d/i,t)}},i=["يناير","فبراير","مارس","أبريل","مايو","يونيو","يوليو","أغسطس","سبتمبر","أكتوبر","نوفمبر","ديسمبر"];e.defineLocale("ar",{months:i,monthsShort:i,weekdays:"الأحد_الإثنين_الثلاثاء_الأربعاء_الخميس_الجمعة_السبت".split("_"),weekdaysShort:"أحد_إثنين_ثلاثاء_أربعاء_خميس_جمعة_سبت".split("_"),weekdaysMin:"ح_ن_ث_ر_خ_ج_س".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"D/‏M/‏YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},meridiemParse:/ص|م/,isPM:function(e){return"م"===e},meridiem:function(e,t,n){return e<12?"ص":"م"},calendar:{sameDay:"[اليوم عند الساعة] LT",nextDay:"[غدًا عند الساعة] LT",nextWeek:"dddd [عند الساعة] LT",lastDay:"[أمس عند الساعة] LT",lastWeek:"dddd [عند الساعة] LT",sameElse:"L"},relativeTime:{future:"بعد %s",past:"منذ %s",s:s("s"),ss:s("s"),m:s("m"),mm:s("m"),h:s("h"),hh:s("h"),d:s("d"),dd:s("d"),M:s("M"),MM:s("M"),y:s("y"),yy:s("y")},preparse:function(e){return e.replace(/[١٢٣٤٥٦٧٨٩٠]/g,(function(e){return n[e]})).replace(/،/g,",")},postformat:function(e){return e.replace(/\d/g,(function(e){return t[e]})).replace(/,/g,"،")},week:{dow:6,doy:12}})}(n(95093))},95533:function(e,t,n){!function(e){"use strict";var t={1:"-inci",5:"-inci",8:"-inci",70:"-inci",80:"-inci",2:"-nci",7:"-nci",20:"-nci",50:"-nci",3:"-üncü",4:"-üncü",100:"-üncü",6:"-ncı",9:"-uncu",10:"-uncu",30:"-uncu",60:"-ıncı",90:"-ıncı"};e.defineLocale("az",{months:"yanvar_fevral_mart_aprel_may_iyun_iyul_avqust_sentyabr_oktyabr_noyabr_dekabr".split("_"),monthsShort:"yan_fev_mar_apr_may_iyn_iyl_avq_sen_okt_noy_dek".split("_"),weekdays:"Bazar_Bazar ertəsi_Çərşənbə axşamı_Çərşənbə_Cümə axşamı_Cümə_Şənbə".split("_"),weekdaysShort:"Baz_BzE_ÇAx_Çər_CAx_Cüm_Şən".split("_"),weekdaysMin:"Bz_BE_ÇA_Çə_CA_Cü_Şə".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[bugün saat] LT",nextDay:"[sabah saat] LT",nextWeek:"[gələn həftə] dddd [saat] LT",lastDay:"[dünən] LT",lastWeek:"[keçən həftə] dddd [saat] LT",sameElse:"L"},relativeTime:{future:"%s sonra",past:"%s əvvəl",s:"bir neçə saniyə",ss:"%d saniyə",m:"bir dəqiqə",mm:"%d dəqiqə",h:"bir saat",hh:"%d saat",d:"bir gün",dd:"%d gün",M:"bir ay",MM:"%d ay",y:"bir il",yy:"%d il"},meridiemParse:/gecə|səhər|gündüz|axşam/,isPM:function(e){return/^(gündüz|axşam)$/.test(e)},meridiem:function(e,t,n){return e<4?"gecə":e<12?"səhər":e<17?"gündüz":"axşam"},dayOfMonthOrdinalParse:/\d{1,2}-(ıncı|inci|nci|üncü|ncı|uncu)/,ordinal:function(e){if(0===e)return e+"-ıncı";var n=e%10,r=e%100-n,a=e>=100?100:null;return e+(t[n]||t[r]||t[a])},week:{dow:1,doy:7}})}(n(95093))},28959:function(e,t,n){!function(e){"use strict";function t(e,t){var n=e.split("_");return t%10==1&&t%100!=11?n[0]:t%10>=2&&t%10<=4&&(t%100<10||t%100>=20)?n[1]:n[2]}function n(e,n,r){return"m"===r?n?"хвіліна":"хвіліну":"h"===r?n?"гадзіна":"гадзіну":e+" "+t({ss:n?"секунда_секунды_секунд":"секунду_секунды_секунд",mm:n?"хвіліна_хвіліны_хвілін":"хвіліну_хвіліны_хвілін",hh:n?"гадзіна_гадзіны_гадзін":"гадзіну_гадзіны_гадзін",dd:"дзень_дні_дзён",MM:"месяц_месяцы_месяцаў",yy:"год_гады_гадоў"}[r],+e)}e.defineLocale("be",{months:{format:"студзеня_лютага_сакавіка_красавіка_траўня_чэрвеня_ліпеня_жніўня_верасня_кастрычніка_лістапада_снежня".split("_"),standalone:"студзень_люты_сакавік_красавік_травень_чэрвень_ліпень_жнівень_верасень_кастрычнік_лістапад_снежань".split("_")},monthsShort:"студ_лют_сак_крас_трав_чэрв_ліп_жнів_вер_каст_ліст_снеж".split("_"),weekdays:{format:"нядзелю_панядзелак_аўторак_сераду_чацвер_пятніцу_суботу".split("_"),standalone:"нядзеля_панядзелак_аўторак_серада_чацвер_пятніца_субота".split("_"),isFormat:/\[ ?[Ууў] ?(?:мінулую|наступную)? ?\] ?dddd/},weekdaysShort:"нд_пн_ат_ср_чц_пт_сб".split("_"),weekdaysMin:"нд_пн_ат_ср_чц_пт_сб".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY г.",LLL:"D MMMM YYYY г., HH:mm",LLLL:"dddd, D MMMM YYYY г., HH:mm"},calendar:{sameDay:"[Сёння ў] LT",nextDay:"[Заўтра ў] LT",lastDay:"[Учора ў] LT",nextWeek:function(){return"[У] dddd [ў] LT"},lastWeek:function(){switch(this.day()){case 0:case 3:case 5:case 6:return"[У мінулую] dddd [ў] LT";case 1:case 2:case 4:return"[У мінулы] dddd [ў] LT"}},sameElse:"L"},relativeTime:{future:"праз %s",past:"%s таму",s:"некалькі секунд",m:n,mm:n,h:n,hh:n,d:"дзень",dd:n,M:"месяц",MM:n,y:"год",yy:n},meridiemParse:/ночы|раніцы|дня|вечара/,isPM:function(e){return/^(дня|вечара)$/.test(e)},meridiem:function(e,t,n){return e<4?"ночы":e<12?"раніцы":e<17?"дня":"вечара"},dayOfMonthOrdinalParse:/\d{1,2}-(і|ы|га)/,ordinal:function(e,t){switch(t){case"M":case"d":case"DDD":case"w":case"W":return e%10!=2&&e%10!=3||e%100==12||e%100==13?e+"-ы":e+"-і";case"D":return e+"-га";default:return e}},week:{dow:1,doy:7}})}(n(95093))},47777:function(e,t,n){!function(e){"use strict";e.defineLocale("bg",{months:"януари_февруари_март_април_май_юни_юли_август_септември_октомври_ноември_декември".split("_"),monthsShort:"яну_фев_мар_апр_май_юни_юли_авг_сеп_окт_ное_дек".split("_"),weekdays:"неделя_понеделник_вторник_сряда_четвъртък_петък_събота".split("_"),weekdaysShort:"нед_пон_вто_сря_чет_пет_съб".split("_"),weekdaysMin:"нд_пн_вт_ср_чт_пт_сб".split("_"),longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"D.MM.YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY H:mm",LLLL:"dddd, D MMMM YYYY H:mm"},calendar:{sameDay:"[Днес в] LT",nextDay:"[Утре в] LT",nextWeek:"dddd [в] LT",lastDay:"[Вчера в] LT",lastWeek:function(){switch(this.day()){case 0:case 3:case 6:return"[Миналата] dddd [в] LT";case 1:case 2:case 4:case 5:return"[Миналия] dddd [в] LT"}},sameElse:"L"},relativeTime:{future:"след %s",past:"преди %s",s:"няколко секунди",ss:"%d секунди",m:"минута",mm:"%d минути",h:"час",hh:"%d часа",d:"ден",dd:"%d дена",w:"седмица",ww:"%d седмици",M:"месец",MM:"%d месеца",y:"година",yy:"%d години"},dayOfMonthOrdinalParse:/\d{1,2}-(ев|ен|ти|ви|ри|ми)/,ordinal:function(e){var t=e%10,n=e%100;return 0===e?e+"-ев":0===n?e+"-ен":n>10&&n<20?e+"-ти":1===t?e+"-ви":2===t?e+"-ри":7===t||8===t?e+"-ми":e+"-ти"},week:{dow:1,doy:7}})}(n(95093))},54903:function(e,t,n){!function(e){"use strict";e.defineLocale("bm",{months:"Zanwuyekalo_Fewuruyekalo_Marisikalo_Awirilikalo_Mɛkalo_Zuwɛnkalo_Zuluyekalo_Utikalo_Sɛtanburukalo_ɔkutɔburukalo_Nowanburukalo_Desanburukalo".split("_"),monthsShort:"Zan_Few_Mar_Awi_Mɛ_Zuw_Zul_Uti_Sɛt_ɔku_Now_Des".split("_"),weekdays:"Kari_Ntɛnɛn_Tarata_Araba_Alamisa_Juma_Sibiri".split("_"),weekdaysShort:"Kar_Ntɛ_Tar_Ara_Ala_Jum_Sib".split("_"),weekdaysMin:"Ka_Nt_Ta_Ar_Al_Ju_Si".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"MMMM [tile] D [san] YYYY",LLL:"MMMM [tile] D [san] YYYY [lɛrɛ] HH:mm",LLLL:"dddd MMMM [tile] D [san] YYYY [lɛrɛ] HH:mm"},calendar:{sameDay:"[Bi lɛrɛ] LT",nextDay:"[Sini lɛrɛ] LT",nextWeek:"dddd [don lɛrɛ] LT",lastDay:"[Kunu lɛrɛ] LT",lastWeek:"dddd [tɛmɛnen lɛrɛ] LT",sameElse:"L"},relativeTime:{future:"%s kɔnɔ",past:"a bɛ %s bɔ",s:"sanga dama dama",ss:"sekondi %d",m:"miniti kelen",mm:"miniti %d",h:"lɛrɛ kelen",hh:"lɛrɛ %d",d:"tile kelen",dd:"tile %d",M:"kalo kelen",MM:"kalo %d",y:"san kelen",yy:"san %d"},week:{dow:1,doy:4}})}(n(95093))},17357:function(e,t,n){!function(e){"use strict";var t={1:"১",2:"২",3:"৩",4:"৪",5:"৫",6:"৬",7:"৭",8:"৮",9:"৯",0:"০"},n={"১":"1","২":"2","৩":"3","৪":"4","৫":"5","৬":"6","৭":"7","৮":"8","৯":"9","০":"0"};e.defineLocale("bn-bd",{months:"জানুয়ারি_ফেব্রুয়ারি_মার্চ_এপ্রিল_মে_জুন_জুলাই_আগস্ট_সেপ্টেম্বর_অক্টোবর_নভেম্বর_ডিসেম্বর".split("_"),monthsShort:"জানু_ফেব্রু_মার্চ_এপ্রিল_মে_জুন_জুলাই_আগস্ট_সেপ্ট_অক্টো_নভে_ডিসে".split("_"),weekdays:"রবিবার_সোমবার_মঙ্গলবার_বুধবার_বৃহস্পতিবার_শুক্রবার_শনিবার".split("_"),weekdaysShort:"রবি_সোম_মঙ্গল_বুধ_বৃহস্পতি_শুক্র_শনি".split("_"),weekdaysMin:"রবি_সোম_মঙ্গল_বুধ_বৃহ_শুক্র_শনি".split("_"),longDateFormat:{LT:"A h:mm সময়",LTS:"A h:mm:ss সময়",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY, A h:mm সময়",LLLL:"dddd, D MMMM YYYY, A h:mm সময়"},calendar:{sameDay:"[আজ] LT",nextDay:"[আগামীকাল] LT",nextWeek:"dddd, LT",lastDay:"[গতকাল] LT",lastWeek:"[গত] dddd, LT",sameElse:"L"},relativeTime:{future:"%s পরে",past:"%s আগে",s:"কয়েক সেকেন্ড",ss:"%d সেকেন্ড",m:"এক মিনিট",mm:"%d মিনিট",h:"এক ঘন্টা",hh:"%d ঘন্টা",d:"এক দিন",dd:"%d দিন",M:"এক মাস",MM:"%d মাস",y:"এক বছর",yy:"%d বছর"},preparse:function(e){return e.replace(/[১২৩৪৫৬৭৮৯০]/g,(function(e){return n[e]}))},postformat:function(e){return e.replace(/\d/g,(function(e){return t[e]}))},meridiemParse:/রাত|ভোর|সকাল|দুপুর|বিকাল|সন্ধ্যা|রাত/,meridiemHour:function(e,t){return 12===e&&(e=0),"রাত"===t?e<4?e:e+12:"ভোর"===t||"সকাল"===t?e:"দুপুর"===t?e>=3?e:e+12:"বিকাল"===t||"সন্ধ্যা"===t?e+12:void 0},meridiem:function(e,t,n){return e<4?"রাত":e<6?"ভোর":e<12?"সকাল":e<15?"দুপুর":e<18?"বিকাল":e<20?"সন্ধ্যা":"রাত"},week:{dow:0,doy:6}})}(n(95093))},61290:function(e,t,n){!function(e){"use strict";var t={1:"১",2:"২",3:"৩",4:"৪",5:"৫",6:"৬",7:"৭",8:"৮",9:"৯",0:"০"},n={"১":"1","২":"2","৩":"3","৪":"4","৫":"5","৬":"6","৭":"7","৮":"8","৯":"9","০":"0"};e.defineLocale("bn",{months:"জানুয়ারি_ফেব্রুয়ারি_মার্চ_এপ্রিল_মে_জুন_জুলাই_আগস্ট_সেপ্টেম্বর_অক্টোবর_নভেম্বর_ডিসেম্বর".split("_"),monthsShort:"জানু_ফেব্রু_মার্চ_এপ্রিল_মে_জুন_জুলাই_আগস্ট_সেপ্ট_অক্টো_নভে_ডিসে".split("_"),weekdays:"রবিবার_সোমবার_মঙ্গলবার_বুধবার_বৃহস্পতিবার_শুক্রবার_শনিবার".split("_"),weekdaysShort:"রবি_সোম_মঙ্গল_বুধ_বৃহস্পতি_শুক্র_শনি".split("_"),weekdaysMin:"রবি_সোম_মঙ্গল_বুধ_বৃহ_শুক্র_শনি".split("_"),longDateFormat:{LT:"A h:mm সময়",LTS:"A h:mm:ss সময়",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY, A h:mm সময়",LLLL:"dddd, D MMMM YYYY, A h:mm সময়"},calendar:{sameDay:"[আজ] LT",nextDay:"[আগামীকাল] LT",nextWeek:"dddd, LT",lastDay:"[গতকাল] LT",lastWeek:"[গত] dddd, LT",sameElse:"L"},relativeTime:{future:"%s পরে",past:"%s আগে",s:"কয়েক সেকেন্ড",ss:"%d সেকেন্ড",m:"এক মিনিট",mm:"%d মিনিট",h:"এক ঘন্টা",hh:"%d ঘন্টা",d:"এক দিন",dd:"%d দিন",M:"এক মাস",MM:"%d মাস",y:"এক বছর",yy:"%d বছর"},preparse:function(e){return e.replace(/[১২৩৪৫৬৭৮৯০]/g,(function(e){return n[e]}))},postformat:function(e){return e.replace(/\d/g,(function(e){return t[e]}))},meridiemParse:/রাত|সকাল|দুপুর|বিকাল|রাত/,meridiemHour:function(e,t){return 12===e&&(e=0),"রাত"===t&&e>=4||"দুপুর"===t&&e<5||"বিকাল"===t?e+12:e},meridiem:function(e,t,n){return e<4?"রাত":e<10?"সকাল":e<17?"দুপুর":e<20?"বিকাল":"রাত"},week:{dow:0,doy:6}})}(n(95093))},31545:function(e,t,n){!function(e){"use strict";var t={1:"༡",2:"༢",3:"༣",4:"༤",5:"༥",6:"༦",7:"༧",8:"༨",9:"༩",0:"༠"},n={"༡":"1","༢":"2","༣":"3","༤":"4","༥":"5","༦":"6","༧":"7","༨":"8","༩":"9","༠":"0"};e.defineLocale("bo",{months:"ཟླ་བ་དང་པོ_ཟླ་བ་གཉིས་པ_ཟླ་བ་གསུམ་པ_ཟླ་བ་བཞི་པ_ཟླ་བ་ལྔ་པ_ཟླ་བ་དྲུག་པ_ཟླ་བ་བདུན་པ_ཟླ་བ་བརྒྱད་པ_ཟླ་བ་དགུ་པ_ཟླ་བ་བཅུ་པ_ཟླ་བ་བཅུ་གཅིག་པ_ཟླ་བ་བཅུ་གཉིས་པ".split("_"),monthsShort:"ཟླ་1_ཟླ་2_ཟླ་3_ཟླ་4_ཟླ་5_ཟླ་6_ཟླ་7_ཟླ་8_ཟླ་9_ཟླ་10_ཟླ་11_ཟླ་12".split("_"),monthsShortRegex:/^(ཟླ་\d{1,2})/,monthsParseExact:!0,weekdays:"གཟའ་ཉི་མ་_གཟའ་ཟླ་བ་_གཟའ་མིག་དམར་_གཟའ་ལྷག་པ་_གཟའ་ཕུར་བུ_གཟའ་པ་སངས་_གཟའ་སྤེན་པ་".split("_"),weekdaysShort:"ཉི་མ་_ཟླ་བ་_མིག་དམར་_ལྷག་པ་_ཕུར་བུ_པ་སངས་_སྤེན་པ་".split("_"),weekdaysMin:"ཉི_ཟླ_མིག_ལྷག_ཕུར_སངས_སྤེན".split("_"),longDateFormat:{LT:"A h:mm",LTS:"A h:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY, A h:mm",LLLL:"dddd, D MMMM YYYY, A h:mm"},calendar:{sameDay:"[དི་རིང] LT",nextDay:"[སང་ཉིན] LT",nextWeek:"[བདུན་ཕྲག་རྗེས་མ], LT",lastDay:"[ཁ་སང] LT",lastWeek:"[བདུན་ཕྲག་མཐའ་མ] dddd, LT",sameElse:"L"},relativeTime:{future:"%s ལ་",past:"%s སྔན་ལ",s:"ལམ་སང",ss:"%d སྐར་ཆ།",m:"སྐར་མ་གཅིག",mm:"%d སྐར་མ",h:"ཆུ་ཚོད་གཅིག",hh:"%d ཆུ་ཚོད",d:"ཉིན་གཅིག",dd:"%d ཉིན་",M:"ཟླ་བ་གཅིག",MM:"%d ཟླ་བ",y:"ལོ་གཅིག",yy:"%d ལོ"},preparse:function(e){return e.replace(/[༡༢༣༤༥༦༧༨༩༠]/g,(function(e){return n[e]}))},postformat:function(e){return e.replace(/\d/g,(function(e){return t[e]}))},meridiemParse:/མཚན་མོ|ཞོགས་ཀས|ཉིན་གུང|དགོང་དག|མཚན་མོ/,meridiemHour:function(e,t){return 12===e&&(e=0),"མཚན་མོ"===t&&e>=4||"ཉིན་གུང"===t&&e<5||"དགོང་དག"===t?e+12:e},meridiem:function(e,t,n){return e<4?"མཚན་མོ":e<10?"ཞོགས་ཀས":e<17?"ཉིན་གུང":e<20?"དགོང་དག":"མཚན་མོ"},week:{dow:0,doy:6}})}(n(95093))},11470:function(e,t,n){!function(e){"use strict";function t(e,t,n){return e+" "+a({mm:"munutenn",MM:"miz",dd:"devezh"}[n],e)}function n(e){switch(r(e)){case 1:case 3:case 4:case 5:case 9:return e+" bloaz";default:return e+" vloaz"}}function r(e){return e>9?r(e%10):e}function a(e,t){return 2===t?s(e):e}function s(e){var t={m:"v",b:"v",d:"z"};return void 0===t[e.charAt(0)]?e:t[e.charAt(0)]+e.substring(1)}var i=[/^gen/i,/^c[ʼ\']hwe/i,/^meu/i,/^ebr/i,/^mae/i,/^(mez|eve)/i,/^gou/i,/^eos/i,/^gwe/i,/^her/i,/^du/i,/^ker/i],o=/^(genver|c[ʼ\']hwevrer|meurzh|ebrel|mae|mezheven|gouere|eost|gwengolo|here|du|kerzu|gen|c[ʼ\']hwe|meu|ebr|mae|eve|gou|eos|gwe|her|du|ker)/i,d=/^(genver|c[ʼ\']hwevrer|meurzh|ebrel|mae|mezheven|gouere|eost|gwengolo|here|du|kerzu)/i,u=/^(gen|c[ʼ\']hwe|meu|ebr|mae|eve|gou|eos|gwe|her|du|ker)/i,l=[/^sul/i,/^lun/i,/^meurzh/i,/^merc[ʼ\']her/i,/^yaou/i,/^gwener/i,/^sadorn/i],c=[/^Sul/i,/^Lun/i,/^Meu/i,/^Mer/i,/^Yao/i,/^Gwe/i,/^Sad/i],_=[/^Su/i,/^Lu/i,/^Me([^r]|$)/i,/^Mer/i,/^Ya/i,/^Gw/i,/^Sa/i];e.defineLocale("br",{months:"Genver_Cʼhwevrer_Meurzh_Ebrel_Mae_Mezheven_Gouere_Eost_Gwengolo_Here_Du_Kerzu".split("_"),monthsShort:"Gen_Cʼhwe_Meu_Ebr_Mae_Eve_Gou_Eos_Gwe_Her_Du_Ker".split("_"),weekdays:"Sul_Lun_Meurzh_Mercʼher_Yaou_Gwener_Sadorn".split("_"),weekdaysShort:"Sul_Lun_Meu_Mer_Yao_Gwe_Sad".split("_"),weekdaysMin:"Su_Lu_Me_Mer_Ya_Gw_Sa".split("_"),weekdaysParse:_,fullWeekdaysParse:l,shortWeekdaysParse:c,minWeekdaysParse:_,monthsRegex:o,monthsShortRegex:o,monthsStrictRegex:d,monthsShortStrictRegex:u,monthsParse:i,longMonthsParse:i,shortMonthsParse:i,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D [a viz] MMMM YYYY",LLL:"D [a viz] MMMM YYYY HH:mm",LLLL:"dddd, D [a viz] MMMM YYYY HH:mm"},calendar:{sameDay:"[Hiziv da] LT",nextDay:"[Warcʼhoazh da] LT",nextWeek:"dddd [da] LT",lastDay:"[Decʼh da] LT",lastWeek:"dddd [paset da] LT",sameElse:"L"},relativeTime:{future:"a-benn %s",past:"%s ʼzo",s:"un nebeud segondennoù",ss:"%d eilenn",m:"ur vunutenn",mm:t,h:"un eur",hh:"%d eur",d:"un devezh",dd:t,M:"ur miz",MM:t,y:"ur bloaz",yy:n},dayOfMonthOrdinalParse:/\d{1,2}(añ|vet)/,ordinal:function(e){return e+(1===e?"añ":"vet")},week:{dow:1,doy:4},meridiemParse:/a.m.|g.m./,isPM:function(e){return"g.m."===e},meridiem:function(e,t,n){return e<12?"a.m.":"g.m."}})}(n(95093))},44429:function(e,t,n){!function(e){"use strict";function t(e,t,n,r){if("m"===n)return t?"jedna minuta":r?"jednu minutu":"jedne minute"}function n(e,t,n){var r=e+" ";switch(n){case"ss":return r+=1===e?"sekunda":2===e||3===e||4===e?"sekunde":"sekundi";case"mm":return r+=1===e?"minuta":2===e||3===e||4===e?"minute":"minuta";case"h":return"jedan sat";case"hh":return r+=1===e?"sat":2===e||3===e||4===e?"sata":"sati";case"dd":return r+=1===e?"dan":"dana";case"MM":return r+=1===e?"mjesec":2===e||3===e||4===e?"mjeseca":"mjeseci";case"yy":return r+=1===e?"godina":2===e||3===e||4===e?"godine":"godina"}}e.defineLocale("bs",{months:"januar_februar_mart_april_maj_juni_juli_august_septembar_oktobar_novembar_decembar".split("_"),monthsShort:"jan._feb._mar._apr._maj._jun._jul._aug._sep._okt._nov._dec.".split("_"),monthsParseExact:!0,weekdays:"nedjelja_ponedjeljak_utorak_srijeda_četvrtak_petak_subota".split("_"),weekdaysShort:"ned._pon._uto._sri._čet._pet._sub.".split("_"),weekdaysMin:"ne_po_ut_sr_če_pe_su".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD.MM.YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY H:mm",LLLL:"dddd, D. MMMM YYYY H:mm"},calendar:{sameDay:"[danas u] LT",nextDay:"[sutra u] LT",nextWeek:function(){switch(this.day()){case 0:return"[u] [nedjelju] [u] LT";case 3:return"[u] [srijedu] [u] LT";case 6:return"[u] [subotu] [u] LT";case 1:case 2:case 4:case 5:return"[u] dddd [u] LT"}},lastDay:"[jučer u] LT",lastWeek:function(){switch(this.day()){case 0:case 3:return"[prošlu] dddd [u] LT";case 6:return"[prošle] [subote] [u] LT";case 1:case 2:case 4:case 5:return"[prošli] dddd [u] LT"}},sameElse:"L"},relativeTime:{future:"za %s",past:"prije %s",s:"par sekundi",ss:n,m:t,mm:n,h:n,hh:n,d:"dan",dd:n,M:"mjesec",MM:n,y:"godinu",yy:n},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:7}})}(n(95093))},7306:function(e,t,n){!function(e){"use strict";e.defineLocale("ca",{months:{standalone:"gener_febrer_març_abril_maig_juny_juliol_agost_setembre_octubre_novembre_desembre".split("_"),format:"de gener_de febrer_de març_d'abril_de maig_de juny_de juliol_d'agost_de setembre_d'octubre_de novembre_de desembre".split("_"),isFormat:/D[oD]?(\s)+MMMM/},monthsShort:"gen._febr._març_abr._maig_juny_jul._ag._set._oct._nov._des.".split("_"),monthsParseExact:!0,weekdays:"diumenge_dilluns_dimarts_dimecres_dijous_divendres_dissabte".split("_"),weekdaysShort:"dg._dl._dt._dc._dj._dv._ds.".split("_"),weekdaysMin:"dg_dl_dt_dc_dj_dv_ds".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM [de] YYYY",ll:"D MMM YYYY",LLL:"D MMMM [de] YYYY [a les] H:mm",lll:"D MMM YYYY, H:mm",LLLL:"dddd D MMMM [de] YYYY [a les] H:mm",llll:"ddd D MMM YYYY, H:mm"},calendar:{sameDay:function(){return"[avui a "+(1!==this.hours()?"les":"la")+"] LT"},nextDay:function(){return"[demà a "+(1!==this.hours()?"les":"la")+"] LT"},nextWeek:function(){return"dddd [a "+(1!==this.hours()?"les":"la")+"] LT"},lastDay:function(){return"[ahir a "+(1!==this.hours()?"les":"la")+"] LT"},lastWeek:function(){return"[el] dddd [passat a "+(1!==this.hours()?"les":"la")+"] LT"},sameElse:"L"},relativeTime:{future:"d'aquí %s",past:"fa %s",s:"uns segons",ss:"%d segons",m:"un minut",mm:"%d minuts",h:"una hora",hh:"%d hores",d:"un dia",dd:"%d dies",M:"un mes",MM:"%d mesos",y:"un any",yy:"%d anys"},dayOfMonthOrdinalParse:/\d{1,2}(r|n|t|è|a)/,ordinal:function(e,t){var n=1===e?"r":2===e?"n":3===e?"r":4===e?"t":"è";return"w"!==t&&"W"!==t||(n="a"),e+n},week:{dow:1,doy:4}})}(n(95093))},56464:function(e,t,n){!function(e){"use strict";var t={standalone:"leden_únor_březen_duben_květen_červen_červenec_srpen_září_říjen_listopad_prosinec".split("_"),format:"ledna_února_března_dubna_května_června_července_srpna_září_října_listopadu_prosince".split("_"),isFormat:/DD?[o.]?(\[[^\[\]]*\]|\s)+MMMM/},n="led_úno_bře_dub_kvě_čvn_čvc_srp_zář_říj_lis_pro".split("_"),r=[/^led/i,/^úno/i,/^bře/i,/^dub/i,/^kvě/i,/^(čvn|červen$|června)/i,/^(čvc|červenec|července)/i,/^srp/i,/^zář/i,/^říj/i,/^lis/i,/^pro/i],a=/^(leden|únor|březen|duben|květen|červenec|července|červen|června|srpen|září|říjen|listopad|prosinec|led|úno|bře|dub|kvě|čvn|čvc|srp|zář|říj|lis|pro)/i;function s(e){return e>1&&e<5&&1!=~~(e/10)}function i(e,t,n,r){var a=e+" ";switch(n){case"s":return t||r?"pár sekund":"pár sekundami";case"ss":return t||r?a+(s(e)?"sekundy":"sekund"):a+"sekundami";case"m":return t?"minuta":r?"minutu":"minutou";case"mm":return t||r?a+(s(e)?"minuty":"minut"):a+"minutami";case"h":return t?"hodina":r?"hodinu":"hodinou";case"hh":return t||r?a+(s(e)?"hodiny":"hodin"):a+"hodinami";case"d":return t||r?"den":"dnem";case"dd":return t||r?a+(s(e)?"dny":"dní"):a+"dny";case"M":return t||r?"měsíc":"měsícem";case"MM":return t||r?a+(s(e)?"měsíce":"měsíců"):a+"měsíci";case"y":return t||r?"rok":"rokem";case"yy":return t||r?a+(s(e)?"roky":"let"):a+"lety"}}e.defineLocale("cs",{months:t,monthsShort:n,monthsRegex:a,monthsShortRegex:a,monthsStrictRegex:/^(leden|ledna|února|únor|březen|března|duben|dubna|květen|května|červenec|července|červen|června|srpen|srpna|září|říjen|října|listopadu|listopad|prosinec|prosince)/i,monthsShortStrictRegex:/^(led|úno|bře|dub|kvě|čvn|čvc|srp|zář|říj|lis|pro)/i,monthsParse:r,longMonthsParse:r,shortMonthsParse:r,weekdays:"neděle_pondělí_úterý_středa_čtvrtek_pátek_sobota".split("_"),weekdaysShort:"ne_po_út_st_čt_pá_so".split("_"),weekdaysMin:"ne_po_út_st_čt_pá_so".split("_"),longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD.MM.YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY H:mm",LLLL:"dddd D. MMMM YYYY H:mm",l:"D. M. YYYY"},calendar:{sameDay:"[dnes v] LT",nextDay:"[zítra v] LT",nextWeek:function(){switch(this.day()){case 0:return"[v neděli v] LT";case 1:case 2:return"[v] dddd [v] LT";case 3:return"[ve středu v] LT";case 4:return"[ve čtvrtek v] LT";case 5:return"[v pátek v] LT";case 6:return"[v sobotu v] LT"}},lastDay:"[včera v] LT",lastWeek:function(){switch(this.day()){case 0:return"[minulou neděli v] LT";case 1:case 2:return"[minulé] dddd [v] LT";case 3:return"[minulou středu v] LT";case 4:case 5:return"[minulý] dddd [v] LT";case 6:return"[minulou sobotu v] LT"}},sameElse:"L"},relativeTime:{future:"za %s",past:"před %s",s:i,ss:i,m:i,mm:i,h:i,hh:i,d:i,dd:i,M:i,MM:i,y:i,yy:i},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:4}})}(n(95093))},73635:function(e,t,n){!function(e){"use strict";e.defineLocale("cv",{months:"кӑрлач_нарӑс_пуш_ака_май_ҫӗртме_утӑ_ҫурла_авӑн_юпа_чӳк_раштав".split("_"),monthsShort:"кӑр_нар_пуш_ака_май_ҫӗр_утӑ_ҫур_авн_юпа_чӳк_раш".split("_"),weekdays:"вырсарникун_тунтикун_ытларикун_юнкун_кӗҫнерникун_эрнекун_шӑматкун".split("_"),weekdaysShort:"выр_тун_ытл_юн_кӗҫ_эрн_шӑм".split("_"),weekdaysMin:"вр_тн_ыт_юн_кҫ_эр_шм".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD-MM-YYYY",LL:"YYYY [ҫулхи] MMMM [уйӑхӗн] D[-мӗшӗ]",LLL:"YYYY [ҫулхи] MMMM [уйӑхӗн] D[-мӗшӗ], HH:mm",LLLL:"dddd, YYYY [ҫулхи] MMMM [уйӑхӗн] D[-мӗшӗ], HH:mm"},calendar:{sameDay:"[Паян] LT [сехетре]",nextDay:"[Ыран] LT [сехетре]",lastDay:"[Ӗнер] LT [сехетре]",nextWeek:"[Ҫитес] dddd LT [сехетре]",lastWeek:"[Иртнӗ] dddd LT [сехетре]",sameElse:"L"},relativeTime:{future:function(e){return e+(/сехет$/i.exec(e)?"рен":/ҫул$/i.exec(e)?"тан":"ран")},past:"%s каялла",s:"пӗр-ик ҫеккунт",ss:"%d ҫеккунт",m:"пӗр минут",mm:"%d минут",h:"пӗр сехет",hh:"%d сехет",d:"пӗр кун",dd:"%d кун",M:"пӗр уйӑх",MM:"%d уйӑх",y:"пӗр ҫул",yy:"%d ҫул"},dayOfMonthOrdinalParse:/\d{1,2}-мӗш/,ordinal:"%d-мӗш",week:{dow:1,doy:7}})}(n(95093))},64226:function(e,t,n){!function(e){"use strict";e.defineLocale("cy",{months:"Ionawr_Chwefror_Mawrth_Ebrill_Mai_Mehefin_Gorffennaf_Awst_Medi_Hydref_Tachwedd_Rhagfyr".split("_"),monthsShort:"Ion_Chwe_Maw_Ebr_Mai_Meh_Gor_Aws_Med_Hyd_Tach_Rhag".split("_"),weekdays:"Dydd Sul_Dydd Llun_Dydd Mawrth_Dydd Mercher_Dydd Iau_Dydd Gwener_Dydd Sadwrn".split("_"),weekdaysShort:"Sul_Llun_Maw_Mer_Iau_Gwe_Sad".split("_"),weekdaysMin:"Su_Ll_Ma_Me_Ia_Gw_Sa".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[Heddiw am] LT",nextDay:"[Yfory am] LT",nextWeek:"dddd [am] LT",lastDay:"[Ddoe am] LT",lastWeek:"dddd [diwethaf am] LT",sameElse:"L"},relativeTime:{future:"mewn %s",past:"%s yn ôl",s:"ychydig eiliadau",ss:"%d eiliad",m:"munud",mm:"%d munud",h:"awr",hh:"%d awr",d:"diwrnod",dd:"%d diwrnod",M:"mis",MM:"%d mis",y:"blwyddyn",yy:"%d flynedd"},dayOfMonthOrdinalParse:/\d{1,2}(fed|ain|af|il|ydd|ed|eg)/,ordinal:function(e){var t="";return e>20?t=40===e||50===e||60===e||80===e||100===e?"fed":"ain":e>0&&(t=["","af","il","ydd","ydd","ed","ed","ed","fed","fed","fed","eg","fed","eg","eg","fed","eg","eg","fed","eg","fed"][e]),e+t},week:{dow:1,doy:4}})}(n(95093))},93601:function(e,t,n){!function(e){"use strict";e.defineLocale("da",{months:"januar_februar_marts_april_maj_juni_juli_august_september_oktober_november_december".split("_"),monthsShort:"jan_feb_mar_apr_maj_jun_jul_aug_sep_okt_nov_dec".split("_"),weekdays:"søndag_mandag_tirsdag_onsdag_torsdag_fredag_lørdag".split("_"),weekdaysShort:"søn_man_tir_ons_tor_fre_lør".split("_"),weekdaysMin:"sø_ma_ti_on_to_fr_lø".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY HH:mm",LLLL:"dddd [d.] D. MMMM YYYY [kl.] HH:mm"},calendar:{sameDay:"[i dag kl.] LT",nextDay:"[i morgen kl.] LT",nextWeek:"på dddd [kl.] LT",lastDay:"[i går kl.] LT",lastWeek:"[i] dddd[s kl.] LT",sameElse:"L"},relativeTime:{future:"om %s",past:"%s siden",s:"få sekunder",ss:"%d sekunder",m:"et minut",mm:"%d minutter",h:"en time",hh:"%d timer",d:"en dag",dd:"%d dage",M:"en måned",MM:"%d måneder",y:"et år",yy:"%d år"},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:4}})}(n(95093))},26111:function(e,t,n){!function(e){"use strict";function t(e,t,n,r){var a={m:["eine Minute","einer Minute"],h:["eine Stunde","einer Stunde"],d:["ein Tag","einem Tag"],dd:[e+" Tage",e+" Tagen"],w:["eine Woche","einer Woche"],M:["ein Monat","einem Monat"],MM:[e+" Monate",e+" Monaten"],y:["ein Jahr","einem Jahr"],yy:[e+" Jahre",e+" Jahren"]};return t?a[n][0]:a[n][1]}e.defineLocale("de-at",{months:"Jänner_Februar_März_April_Mai_Juni_Juli_August_September_Oktober_November_Dezember".split("_"),monthsShort:"Jän._Feb._März_Apr._Mai_Juni_Juli_Aug._Sep._Okt._Nov._Dez.".split("_"),monthsParseExact:!0,weekdays:"Sonntag_Montag_Dienstag_Mittwoch_Donnerstag_Freitag_Samstag".split("_"),weekdaysShort:"So._Mo._Di._Mi._Do._Fr._Sa.".split("_"),weekdaysMin:"So_Mo_Di_Mi_Do_Fr_Sa".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY HH:mm",LLLL:"dddd, D. MMMM YYYY HH:mm"},calendar:{sameDay:"[heute um] LT [Uhr]",sameElse:"L",nextDay:"[morgen um] LT [Uhr]",nextWeek:"dddd [um] LT [Uhr]",lastDay:"[gestern um] LT [Uhr]",lastWeek:"[letzten] dddd [um] LT [Uhr]"},relativeTime:{future:"in %s",past:"vor %s",s:"ein paar Sekunden",ss:"%d Sekunden",m:t,mm:"%d Minuten",h:t,hh:"%d Stunden",d:t,dd:t,w:t,ww:"%d Wochen",M:t,MM:t,y:t,yy:t},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:4}})}(n(95093))},54697:function(e,t,n){!function(e){"use strict";function t(e,t,n,r){var a={m:["eine Minute","einer Minute"],h:["eine Stunde","einer Stunde"],d:["ein Tag","einem Tag"],dd:[e+" Tage",e+" Tagen"],w:["eine Woche","einer Woche"],M:["ein Monat","einem Monat"],MM:[e+" Monate",e+" Monaten"],y:["ein Jahr","einem Jahr"],yy:[e+" Jahre",e+" Jahren"]};return t?a[n][0]:a[n][1]}e.defineLocale("de-ch",{months:"Januar_Februar_März_April_Mai_Juni_Juli_August_September_Oktober_November_Dezember".split("_"),monthsShort:"Jan._Feb._März_Apr._Mai_Juni_Juli_Aug._Sep._Okt._Nov._Dez.".split("_"),monthsParseExact:!0,weekdays:"Sonntag_Montag_Dienstag_Mittwoch_Donnerstag_Freitag_Samstag".split("_"),weekdaysShort:"So_Mo_Di_Mi_Do_Fr_Sa".split("_"),weekdaysMin:"So_Mo_Di_Mi_Do_Fr_Sa".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY HH:mm",LLLL:"dddd, D. MMMM YYYY HH:mm"},calendar:{sameDay:"[heute um] LT [Uhr]",sameElse:"L",nextDay:"[morgen um] LT [Uhr]",nextWeek:"dddd [um] LT [Uhr]",lastDay:"[gestern um] LT [Uhr]",lastWeek:"[letzten] dddd [um] LT [Uhr]"},relativeTime:{future:"in %s",past:"vor %s",s:"ein paar Sekunden",ss:"%d Sekunden",m:t,mm:"%d Minuten",h:t,hh:"%d Stunden",d:t,dd:t,w:t,ww:"%d Wochen",M:t,MM:t,y:t,yy:t},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:4}})}(n(95093))},77853:function(e,t,n){!function(e){"use strict";function t(e,t,n,r){var a={m:["eine Minute","einer Minute"],h:["eine Stunde","einer Stunde"],d:["ein Tag","einem Tag"],dd:[e+" Tage",e+" Tagen"],w:["eine Woche","einer Woche"],M:["ein Monat","einem Monat"],MM:[e+" Monate",e+" Monaten"],y:["ein Jahr","einem Jahr"],yy:[e+" Jahre",e+" Jahren"]};return t?a[n][0]:a[n][1]}e.defineLocale("de",{months:"Januar_Februar_März_April_Mai_Juni_Juli_August_September_Oktober_November_Dezember".split("_"),monthsShort:"Jan._Feb._März_Apr._Mai_Juni_Juli_Aug._Sep._Okt._Nov._Dez.".split("_"),monthsParseExact:!0,weekdays:"Sonntag_Montag_Dienstag_Mittwoch_Donnerstag_Freitag_Samstag".split("_"),weekdaysShort:"So._Mo._Di._Mi._Do._Fr._Sa.".split("_"),weekdaysMin:"So_Mo_Di_Mi_Do_Fr_Sa".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY HH:mm",LLLL:"dddd, D. MMMM YYYY HH:mm"},calendar:{sameDay:"[heute um] LT [Uhr]",sameElse:"L",nextDay:"[morgen um] LT [Uhr]",nextWeek:"dddd [um] LT [Uhr]",lastDay:"[gestern um] LT [Uhr]",lastWeek:"[letzten] dddd [um] LT [Uhr]"},relativeTime:{future:"in %s",past:"vor %s",s:"ein paar Sekunden",ss:"%d Sekunden",m:t,mm:"%d Minuten",h:t,hh:"%d Stunden",d:t,dd:t,w:t,ww:"%d Wochen",M:t,MM:t,y:t,yy:t},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:4}})}(n(95093))},60708:function(e,t,n){!function(e){"use strict";var t=["ޖެނުއަރީ","ފެބްރުއަރީ","މާރިޗު","އޭޕްރީލު","މޭ","ޖޫން","ޖުލައި","އޯގަސްޓު","ސެޕްޓެމްބަރު","އޮކްޓޯބަރު","ނޮވެމްބަރު","ޑިސެމްބަރު"],n=["އާދިއްތަ","ހޯމަ","އަންގާރަ","ބުދަ","ބުރާސްފަތި","ހުކުރު","ހޮނިހިރު"];e.defineLocale("dv",{months:t,monthsShort:t,weekdays:n,weekdaysShort:n,weekdaysMin:"އާދި_ހޯމަ_އަން_ބުދަ_ބުރާ_ހުކު_ހޮނި".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"D/M/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},meridiemParse:/މކ|މފ/,isPM:function(e){return"މފ"===e},meridiem:function(e,t,n){return e<12?"މކ":"މފ"},calendar:{sameDay:"[މިއަދު] LT",nextDay:"[މާދަމާ] LT",nextWeek:"dddd LT",lastDay:"[އިއްޔެ] LT",lastWeek:"[ފާއިތުވި] dddd LT",sameElse:"L"},relativeTime:{future:"ތެރޭގައި %s",past:"ކުރިން %s",s:"ސިކުންތުކޮޅެއް",ss:"d% ސިކުންތު",m:"މިނިޓެއް",mm:"މިނިޓު %d",h:"ގަޑިއިރެއް",hh:"ގަޑިއިރު %d",d:"ދުވަހެއް",dd:"ދުވަސް %d",M:"މަހެއް",MM:"މަސް %d",y:"އަހަރެއް",yy:"އަހަރު %d"},preparse:function(e){return e.replace(/،/g,",")},postformat:function(e){return e.replace(/,/g,"،")},week:{dow:7,doy:12}})}(n(95093))},54691:function(e,t,n){!function(e){"use strict";function t(e){return"undefined"!=typeof Function&&e instanceof Function||"[object Function]"===Object.prototype.toString.call(e)}e.defineLocale("el",{monthsNominativeEl:"Ιανουάριος_Φεβρουάριος_Μάρτιος_Απρίλιος_Μάιος_Ιούνιος_Ιούλιος_Αύγουστος_Σεπτέμβριος_Οκτώβριος_Νοέμβριος_Δεκέμβριος".split("_"),monthsGenitiveEl:"Ιανουαρίου_Φεβρουαρίου_Μαρτίου_Απριλίου_Μαΐου_Ιουνίου_Ιουλίου_Αυγούστου_Σεπτεμβρίου_Οκτωβρίου_Νοεμβρίου_Δεκεμβρίου".split("_"),months:function(e,t){return e?"string"==typeof t&&/D/.test(t.substring(0,t.indexOf("MMMM")))?this._monthsGenitiveEl[e.month()]:this._monthsNominativeEl[e.month()]:this._monthsNominativeEl},monthsShort:"Ιαν_Φεβ_Μαρ_Απρ_Μαϊ_Ιουν_Ιουλ_Αυγ_Σεπ_Οκτ_Νοε_Δεκ".split("_"),weekdays:"Κυριακή_Δευτέρα_Τρίτη_Τετάρτη_Πέμπτη_Παρασκευή_Σάββατο".split("_"),weekdaysShort:"Κυρ_Δευ_Τρι_Τετ_Πεμ_Παρ_Σαβ".split("_"),weekdaysMin:"Κυ_Δε_Τρ_Τε_Πε_Πα_Σα".split("_"),meridiem:function(e,t,n){return e>11?n?"μμ":"ΜΜ":n?"πμ":"ΠΜ"},isPM:function(e){return"μ"===(e+"").toLowerCase()[0]},meridiemParse:/[ΠΜ]\.?Μ?\.?/i,longDateFormat:{LT:"h:mm A",LTS:"h:mm:ss A",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY h:mm A",LLLL:"dddd, D MMMM YYYY h:mm A"},calendarEl:{sameDay:"[Σήμερα {}] LT",nextDay:"[Αύριο {}] LT",nextWeek:"dddd [{}] LT",lastDay:"[Χθες {}] LT",lastWeek:function(){return 6===this.day()?"[το προηγούμενο] dddd [{}] LT":"[την προηγούμενη] dddd [{}] LT"},sameElse:"L"},calendar:function(e,n){var r=this._calendarEl[e],a=n&&n.hours();return t(r)&&(r=r.apply(n)),r.replace("{}",a%12==1?"στη":"στις")},relativeTime:{future:"σε %s",past:"%s πριν",s:"λίγα δευτερόλεπτα",ss:"%d δευτερόλεπτα",m:"ένα λεπτό",mm:"%d λεπτά",h:"μία ώρα",hh:"%d ώρες",d:"μία μέρα",dd:"%d μέρες",M:"ένας μήνας",MM:"%d μήνες",y:"ένας χρόνος",yy:"%d χρόνια"},dayOfMonthOrdinalParse:/\d{1,2}η/,ordinal:"%dη",week:{dow:1,doy:4}})}(n(95093))},53872:function(e,t,n){!function(e){"use strict";e.defineLocale("en-au",{months:"January_February_March_April_May_June_July_August_September_October_November_December".split("_"),monthsShort:"Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),weekdays:"Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),weekdaysShort:"Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),weekdaysMin:"Su_Mo_Tu_We_Th_Fr_Sa".split("_"),longDateFormat:{LT:"h:mm A",LTS:"h:mm:ss A",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY h:mm A",LLLL:"dddd, D MMMM YYYY h:mm A"},calendar:{sameDay:"[Today at] LT",nextDay:"[Tomorrow at] LT",nextWeek:"dddd [at] LT",lastDay:"[Yesterday at] LT",lastWeek:"[Last] dddd [at] LT",sameElse:"L"},relativeTime:{future:"in %s",past:"%s ago",s:"a few seconds",ss:"%d seconds",m:"a minute",mm:"%d minutes",h:"an hour",hh:"%d hours",d:"a day",dd:"%d days",M:"a month",MM:"%d months",y:"a year",yy:"%d years"},dayOfMonthOrdinalParse:/\d{1,2}(st|nd|rd|th)/,ordinal:function(e){var t=e%10;return e+(1==~~(e%100/10)?"th":1===t?"st":2===t?"nd":3===t?"rd":"th")},week:{dow:0,doy:4}})}(n(95093))},28298:function(e,t,n){!function(e){"use strict";e.defineLocale("en-ca",{months:"January_February_March_April_May_June_July_August_September_October_November_December".split("_"),monthsShort:"Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),weekdays:"Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),weekdaysShort:"Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),weekdaysMin:"Su_Mo_Tu_We_Th_Fr_Sa".split("_"),longDateFormat:{LT:"h:mm A",LTS:"h:mm:ss A",L:"YYYY-MM-DD",LL:"MMMM D, YYYY",LLL:"MMMM D, YYYY h:mm A",LLLL:"dddd, MMMM D, YYYY h:mm A"},calendar:{sameDay:"[Today at] LT",nextDay:"[Tomorrow at] LT",nextWeek:"dddd [at] LT",lastDay:"[Yesterday at] LT",lastWeek:"[Last] dddd [at] LT",sameElse:"L"},relativeTime:{future:"in %s",past:"%s ago",s:"a few seconds",ss:"%d seconds",m:"a minute",mm:"%d minutes",h:"an hour",hh:"%d hours",d:"a day",dd:"%d days",M:"a month",MM:"%d months",y:"a year",yy:"%d years"},dayOfMonthOrdinalParse:/\d{1,2}(st|nd|rd|th)/,ordinal:function(e){var t=e%10;return e+(1==~~(e%100/10)?"th":1===t?"st":2===t?"nd":3===t?"rd":"th")}})}(n(95093))},56195:function(e,t,n){!function(e){"use strict";e.defineLocale("en-gb",{months:"January_February_March_April_May_June_July_August_September_October_November_December".split("_"),monthsShort:"Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),weekdays:"Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),weekdaysShort:"Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),weekdaysMin:"Su_Mo_Tu_We_Th_Fr_Sa".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[Today at] LT",nextDay:"[Tomorrow at] LT",nextWeek:"dddd [at] LT",lastDay:"[Yesterday at] LT",lastWeek:"[Last] dddd [at] LT",sameElse:"L"},relativeTime:{future:"in %s",past:"%s ago",s:"a few seconds",ss:"%d seconds",m:"a minute",mm:"%d minutes",h:"an hour",hh:"%d hours",d:"a day",dd:"%d days",M:"a month",MM:"%d months",y:"a year",yy:"%d years"},dayOfMonthOrdinalParse:/\d{1,2}(st|nd|rd|th)/,ordinal:function(e){var t=e%10;return e+(1==~~(e%100/10)?"th":1===t?"st":2===t?"nd":3===t?"rd":"th")},week:{dow:1,doy:4}})}(n(95093))},66584:function(e,t,n){!function(e){"use strict";e.defineLocale("en-ie",{months:"January_February_March_April_May_June_July_August_September_October_November_December".split("_"),monthsShort:"Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),weekdays:"Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),weekdaysShort:"Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),weekdaysMin:"Su_Mo_Tu_We_Th_Fr_Sa".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},calendar:{sameDay:"[Today at] LT",nextDay:"[Tomorrow at] LT",nextWeek:"dddd [at] LT",lastDay:"[Yesterday at] LT",lastWeek:"[Last] dddd [at] LT",sameElse:"L"},relativeTime:{future:"in %s",past:"%s ago",s:"a few seconds",ss:"%d seconds",m:"a minute",mm:"%d minutes",h:"an hour",hh:"%d hours",d:"a day",dd:"%d days",M:"a month",MM:"%d months",y:"a year",yy:"%d years"},dayOfMonthOrdinalParse:/\d{1,2}(st|nd|rd|th)/,ordinal:function(e){var t=e%10;return e+(1==~~(e%100/10)?"th":1===t?"st":2===t?"nd":3===t?"rd":"th")},week:{dow:1,doy:4}})}(n(95093))},65543:function(e,t,n){!function(e){"use strict";e.defineLocale("en-il",{months:"January_February_March_April_May_June_July_August_September_October_November_December".split("_"),monthsShort:"Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),weekdays:"Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),weekdaysShort:"Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),weekdaysMin:"Su_Mo_Tu_We_Th_Fr_Sa".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[Today at] LT",nextDay:"[Tomorrow at] LT",nextWeek:"dddd [at] LT",lastDay:"[Yesterday at] LT",lastWeek:"[Last] dddd [at] LT",sameElse:"L"},relativeTime:{future:"in %s",past:"%s ago",s:"a few seconds",ss:"%d seconds",m:"a minute",mm:"%d minutes",h:"an hour",hh:"%d hours",d:"a day",dd:"%d days",M:"a month",MM:"%d months",y:"a year",yy:"%d years"},dayOfMonthOrdinalParse:/\d{1,2}(st|nd|rd|th)/,ordinal:function(e){var t=e%10;return e+(1==~~(e%100/10)?"th":1===t?"st":2===t?"nd":3===t?"rd":"th")}})}(n(95093))},9033:function(e,t,n){!function(e){"use strict";e.defineLocale("en-in",{months:"January_February_March_April_May_June_July_August_September_October_November_December".split("_"),monthsShort:"Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),weekdays:"Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),weekdaysShort:"Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),weekdaysMin:"Su_Mo_Tu_We_Th_Fr_Sa".split("_"),longDateFormat:{LT:"h:mm A",LTS:"h:mm:ss A",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY h:mm A",LLLL:"dddd, D MMMM YYYY h:mm A"},calendar:{sameDay:"[Today at] LT",nextDay:"[Tomorrow at] LT",nextWeek:"dddd [at] LT",lastDay:"[Yesterday at] LT",lastWeek:"[Last] dddd [at] LT",sameElse:"L"},relativeTime:{future:"in %s",past:"%s ago",s:"a few seconds",ss:"%d seconds",m:"a minute",mm:"%d minutes",h:"an hour",hh:"%d hours",d:"a day",dd:"%d days",M:"a month",MM:"%d months",y:"a year",yy:"%d years"},dayOfMonthOrdinalParse:/\d{1,2}(st|nd|rd|th)/,ordinal:function(e){var t=e%10;return e+(1==~~(e%100/10)?"th":1===t?"st":2===t?"nd":3===t?"rd":"th")},week:{dow:0,doy:6}})}(n(95093))},79402:function(e,t,n){!function(e){"use strict";e.defineLocale("en-nz",{months:"January_February_March_April_May_June_July_August_September_October_November_December".split("_"),monthsShort:"Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),weekdays:"Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),weekdaysShort:"Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),weekdaysMin:"Su_Mo_Tu_We_Th_Fr_Sa".split("_"),longDateFormat:{LT:"h:mm A",LTS:"h:mm:ss A",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY h:mm A",LLLL:"dddd, D MMMM YYYY h:mm A"},calendar:{sameDay:"[Today at] LT",nextDay:"[Tomorrow at] LT",nextWeek:"dddd [at] LT",lastDay:"[Yesterday at] LT",lastWeek:"[Last] dddd [at] LT",sameElse:"L"},relativeTime:{future:"in %s",past:"%s ago",s:"a few seconds",ss:"%d seconds",m:"a minute",mm:"%d minutes",h:"an hour",hh:"%d hours",d:"a day",dd:"%d days",M:"a month",MM:"%d months",y:"a year",yy:"%d years"},dayOfMonthOrdinalParse:/\d{1,2}(st|nd|rd|th)/,ordinal:function(e){var t=e%10;return e+(1==~~(e%100/10)?"th":1===t?"st":2===t?"nd":3===t?"rd":"th")},week:{dow:1,doy:4}})}(n(95093))},43004:function(e,t,n){!function(e){"use strict";e.defineLocale("en-sg",{months:"January_February_March_April_May_June_July_August_September_October_November_December".split("_"),monthsShort:"Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),weekdays:"Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),weekdaysShort:"Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),weekdaysMin:"Su_Mo_Tu_We_Th_Fr_Sa".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[Today at] LT",nextDay:"[Tomorrow at] LT",nextWeek:"dddd [at] LT",lastDay:"[Yesterday at] LT",lastWeek:"[Last] dddd [at] LT",sameElse:"L"},relativeTime:{future:"in %s",past:"%s ago",s:"a few seconds",ss:"%d seconds",m:"a minute",mm:"%d minutes",h:"an hour",hh:"%d hours",d:"a day",dd:"%d days",M:"a month",MM:"%d months",y:"a year",yy:"%d years"},dayOfMonthOrdinalParse:/\d{1,2}(st|nd|rd|th)/,ordinal:function(e){var t=e%10;return e+(1==~~(e%100/10)?"th":1===t?"st":2===t?"nd":3===t?"rd":"th")},week:{dow:1,doy:4}})}(n(95093))},32934:function(e,t,n){!function(e){"use strict";e.defineLocale("eo",{months:"januaro_februaro_marto_aprilo_majo_junio_julio_aŭgusto_septembro_oktobro_novembro_decembro".split("_"),monthsShort:"jan_feb_mart_apr_maj_jun_jul_aŭg_sept_okt_nov_dec".split("_"),weekdays:"dimanĉo_lundo_mardo_merkredo_ĵaŭdo_vendredo_sabato".split("_"),weekdaysShort:"dim_lun_mard_merk_ĵaŭ_ven_sab".split("_"),weekdaysMin:"di_lu_ma_me_ĵa_ve_sa".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"YYYY-MM-DD",LL:"[la] D[-an de] MMMM, YYYY",LLL:"[la] D[-an de] MMMM, YYYY HH:mm",LLLL:"dddd[n], [la] D[-an de] MMMM, YYYY HH:mm",llll:"ddd, [la] D[-an de] MMM, YYYY HH:mm"},meridiemParse:/[ap]\.t\.m/i,isPM:function(e){return"p"===e.charAt(0).toLowerCase()},meridiem:function(e,t,n){return e>11?n?"p.t.m.":"P.T.M.":n?"a.t.m.":"A.T.M."},calendar:{sameDay:"[Hodiaŭ je] LT",nextDay:"[Morgaŭ je] LT",nextWeek:"dddd[n je] LT",lastDay:"[Hieraŭ je] LT",lastWeek:"[pasintan] dddd[n je] LT",sameElse:"L"},relativeTime:{future:"post %s",past:"antaŭ %s",s:"kelkaj sekundoj",ss:"%d sekundoj",m:"unu minuto",mm:"%d minutoj",h:"unu horo",hh:"%d horoj",d:"unu tago",dd:"%d tagoj",M:"unu monato",MM:"%d monatoj",y:"unu jaro",yy:"%d jaroj"},dayOfMonthOrdinalParse:/\d{1,2}a/,ordinal:"%da",week:{dow:1,doy:7}})}(n(95093))},20838:function(e,t,n){!function(e){"use strict";var t="ene._feb._mar._abr._may._jun._jul._ago._sep._oct._nov._dic.".split("_"),n="ene_feb_mar_abr_may_jun_jul_ago_sep_oct_nov_dic".split("_"),r=[/^ene/i,/^feb/i,/^mar/i,/^abr/i,/^may/i,/^jun/i,/^jul/i,/^ago/i,/^sep/i,/^oct/i,/^nov/i,/^dic/i],a=/^(enero|febrero|marzo|abril|mayo|junio|julio|agosto|septiembre|octubre|noviembre|diciembre|ene\.?|feb\.?|mar\.?|abr\.?|may\.?|jun\.?|jul\.?|ago\.?|sep\.?|oct\.?|nov\.?|dic\.?)/i;e.defineLocale("es-do",{months:"enero_febrero_marzo_abril_mayo_junio_julio_agosto_septiembre_octubre_noviembre_diciembre".split("_"),monthsShort:function(e,r){return e?/-MMM-/.test(r)?n[e.month()]:t[e.month()]:t},monthsRegex:a,monthsShortRegex:a,monthsStrictRegex:/^(enero|febrero|marzo|abril|mayo|junio|julio|agosto|septiembre|octubre|noviembre|diciembre)/i,monthsShortStrictRegex:/^(ene\.?|feb\.?|mar\.?|abr\.?|may\.?|jun\.?|jul\.?|ago\.?|sep\.?|oct\.?|nov\.?|dic\.?)/i,monthsParse:r,longMonthsParse:r,shortMonthsParse:r,weekdays:"domingo_lunes_martes_miércoles_jueves_viernes_sábado".split("_"),weekdaysShort:"dom._lun._mar._mié._jue._vie._sáb.".split("_"),weekdaysMin:"do_lu_ma_mi_ju_vi_sá".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"h:mm A",LTS:"h:mm:ss A",L:"DD/MM/YYYY",LL:"D [de] MMMM [de] YYYY",LLL:"D [de] MMMM [de] YYYY h:mm A",LLLL:"dddd, D [de] MMMM [de] YYYY h:mm A"},calendar:{sameDay:function(){return"[hoy a la"+(1!==this.hours()?"s":"")+"] LT"},nextDay:function(){return"[mañana a la"+(1!==this.hours()?"s":"")+"] LT"},nextWeek:function(){return"dddd [a la"+(1!==this.hours()?"s":"")+"] LT"},lastDay:function(){return"[ayer a la"+(1!==this.hours()?"s":"")+"] LT"},lastWeek:function(){return"[el] dddd [pasado a la"+(1!==this.hours()?"s":"")+"] LT"},sameElse:"L"},relativeTime:{future:"en %s",past:"hace %s",s:"unos segundos",ss:"%d segundos",m:"un minuto",mm:"%d minutos",h:"una hora",hh:"%d horas",d:"un día",dd:"%d días",w:"una semana",ww:"%d semanas",M:"un mes",MM:"%d meses",y:"un año",yy:"%d años"},dayOfMonthOrdinalParse:/\d{1,2}º/,ordinal:"%dº",week:{dow:1,doy:4}})}(n(95093))},17730:function(e,t,n){!function(e){"use strict";var t="ene._feb._mar._abr._may._jun._jul._ago._sep._oct._nov._dic.".split("_"),n="ene_feb_mar_abr_may_jun_jul_ago_sep_oct_nov_dic".split("_"),r=[/^ene/i,/^feb/i,/^mar/i,/^abr/i,/^may/i,/^jun/i,/^jul/i,/^ago/i,/^sep/i,/^oct/i,/^nov/i,/^dic/i],a=/^(enero|febrero|marzo|abril|mayo|junio|julio|agosto|septiembre|octubre|noviembre|diciembre|ene\.?|feb\.?|mar\.?|abr\.?|may\.?|jun\.?|jul\.?|ago\.?|sep\.?|oct\.?|nov\.?|dic\.?)/i;e.defineLocale("es-mx",{months:"enero_febrero_marzo_abril_mayo_junio_julio_agosto_septiembre_octubre_noviembre_diciembre".split("_"),monthsShort:function(e,r){return e?/-MMM-/.test(r)?n[e.month()]:t[e.month()]:t},monthsRegex:a,monthsShortRegex:a,monthsStrictRegex:/^(enero|febrero|marzo|abril|mayo|junio|julio|agosto|septiembre|octubre|noviembre|diciembre)/i,monthsShortStrictRegex:/^(ene\.?|feb\.?|mar\.?|abr\.?|may\.?|jun\.?|jul\.?|ago\.?|sep\.?|oct\.?|nov\.?|dic\.?)/i,monthsParse:r,longMonthsParse:r,shortMonthsParse:r,weekdays:"domingo_lunes_martes_miércoles_jueves_viernes_sábado".split("_"),weekdaysShort:"dom._lun._mar._mié._jue._vie._sáb.".split("_"),weekdaysMin:"do_lu_ma_mi_ju_vi_sá".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD/MM/YYYY",LL:"D [de] MMMM [de] YYYY",LLL:"D [de] MMMM [de] YYYY H:mm",LLLL:"dddd, D [de] MMMM [de] YYYY H:mm"},calendar:{sameDay:function(){return"[hoy a la"+(1!==this.hours()?"s":"")+"] LT"},nextDay:function(){return"[mañana a la"+(1!==this.hours()?"s":"")+"] LT"},nextWeek:function(){return"dddd [a la"+(1!==this.hours()?"s":"")+"] LT"},lastDay:function(){return"[ayer a la"+(1!==this.hours()?"s":"")+"] LT"},lastWeek:function(){return"[el] dddd [pasado a la"+(1!==this.hours()?"s":"")+"] LT"},sameElse:"L"},relativeTime:{future:"en %s",past:"hace %s",s:"unos segundos",ss:"%d segundos",m:"un minuto",mm:"%d minutos",h:"una hora",hh:"%d horas",d:"un día",dd:"%d días",w:"una semana",ww:"%d semanas",M:"un mes",MM:"%d meses",y:"un año",yy:"%d años"},dayOfMonthOrdinalParse:/\d{1,2}º/,ordinal:"%dº",week:{dow:0,doy:4},invalidDate:"Fecha inválida"})}(n(95093))},56575:function(e,t,n){!function(e){"use strict";var t="ene._feb._mar._abr._may._jun._jul._ago._sep._oct._nov._dic.".split("_"),n="ene_feb_mar_abr_may_jun_jul_ago_sep_oct_nov_dic".split("_"),r=[/^ene/i,/^feb/i,/^mar/i,/^abr/i,/^may/i,/^jun/i,/^jul/i,/^ago/i,/^sep/i,/^oct/i,/^nov/i,/^dic/i],a=/^(enero|febrero|marzo|abril|mayo|junio|julio|agosto|septiembre|octubre|noviembre|diciembre|ene\.?|feb\.?|mar\.?|abr\.?|may\.?|jun\.?|jul\.?|ago\.?|sep\.?|oct\.?|nov\.?|dic\.?)/i;e.defineLocale("es-us",{months:"enero_febrero_marzo_abril_mayo_junio_julio_agosto_septiembre_octubre_noviembre_diciembre".split("_"),monthsShort:function(e,r){return e?/-MMM-/.test(r)?n[e.month()]:t[e.month()]:t},monthsRegex:a,monthsShortRegex:a,monthsStrictRegex:/^(enero|febrero|marzo|abril|mayo|junio|julio|agosto|septiembre|octubre|noviembre|diciembre)/i,monthsShortStrictRegex:/^(ene\.?|feb\.?|mar\.?|abr\.?|may\.?|jun\.?|jul\.?|ago\.?|sep\.?|oct\.?|nov\.?|dic\.?)/i,monthsParse:r,longMonthsParse:r,shortMonthsParse:r,weekdays:"domingo_lunes_martes_miércoles_jueves_viernes_sábado".split("_"),weekdaysShort:"dom._lun._mar._mié._jue._vie._sáb.".split("_"),weekdaysMin:"do_lu_ma_mi_ju_vi_sá".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"h:mm A",LTS:"h:mm:ss A",L:"MM/DD/YYYY",LL:"D [de] MMMM [de] YYYY",LLL:"D [de] MMMM [de] YYYY h:mm A",LLLL:"dddd, D [de] MMMM [de] YYYY h:mm A"},calendar:{sameDay:function(){return"[hoy a la"+(1!==this.hours()?"s":"")+"] LT"},nextDay:function(){return"[mañana a la"+(1!==this.hours()?"s":"")+"] LT"},nextWeek:function(){return"dddd [a la"+(1!==this.hours()?"s":"")+"] LT"},lastDay:function(){return"[ayer a la"+(1!==this.hours()?"s":"")+"] LT"},lastWeek:function(){return"[el] dddd [pasado a la"+(1!==this.hours()?"s":"")+"] LT"},sameElse:"L"},relativeTime:{future:"en %s",past:"hace %s",s:"unos segundos",ss:"%d segundos",m:"un minuto",mm:"%d minutos",h:"una hora",hh:"%d horas",d:"un día",dd:"%d días",w:"una semana",ww:"%d semanas",M:"un mes",MM:"%d meses",y:"un año",yy:"%d años"},dayOfMonthOrdinalParse:/\d{1,2}º/,ordinal:"%dº",week:{dow:0,doy:6}})}(n(95093))},97650:function(e,t,n){!function(e){"use strict";var t="ene._feb._mar._abr._may._jun._jul._ago._sep._oct._nov._dic.".split("_"),n="ene_feb_mar_abr_may_jun_jul_ago_sep_oct_nov_dic".split("_"),r=[/^ene/i,/^feb/i,/^mar/i,/^abr/i,/^may/i,/^jun/i,/^jul/i,/^ago/i,/^sep/i,/^oct/i,/^nov/i,/^dic/i],a=/^(enero|febrero|marzo|abril|mayo|junio|julio|agosto|septiembre|octubre|noviembre|diciembre|ene\.?|feb\.?|mar\.?|abr\.?|may\.?|jun\.?|jul\.?|ago\.?|sep\.?|oct\.?|nov\.?|dic\.?)/i;e.defineLocale("es",{months:"enero_febrero_marzo_abril_mayo_junio_julio_agosto_septiembre_octubre_noviembre_diciembre".split("_"),monthsShort:function(e,r){return e?/-MMM-/.test(r)?n[e.month()]:t[e.month()]:t},monthsRegex:a,monthsShortRegex:a,monthsStrictRegex:/^(enero|febrero|marzo|abril|mayo|junio|julio|agosto|septiembre|octubre|noviembre|diciembre)/i,monthsShortStrictRegex:/^(ene\.?|feb\.?|mar\.?|abr\.?|may\.?|jun\.?|jul\.?|ago\.?|sep\.?|oct\.?|nov\.?|dic\.?)/i,monthsParse:r,longMonthsParse:r,shortMonthsParse:r,weekdays:"domingo_lunes_martes_miércoles_jueves_viernes_sábado".split("_"),weekdaysShort:"dom._lun._mar._mié._jue._vie._sáb.".split("_"),weekdaysMin:"do_lu_ma_mi_ju_vi_sá".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD/MM/YYYY",LL:"D [de] MMMM [de] YYYY",LLL:"D [de] MMMM [de] YYYY H:mm",LLLL:"dddd, D [de] MMMM [de] YYYY H:mm"},calendar:{sameDay:function(){return"[hoy a la"+(1!==this.hours()?"s":"")+"] LT"},nextDay:function(){return"[mañana a la"+(1!==this.hours()?"s":"")+"] LT"},nextWeek:function(){return"dddd [a la"+(1!==this.hours()?"s":"")+"] LT"},lastDay:function(){return"[ayer a la"+(1!==this.hours()?"s":"")+"] LT"},lastWeek:function(){return"[el] dddd [pasado a la"+(1!==this.hours()?"s":"")+"] LT"},sameElse:"L"},relativeTime:{future:"en %s",past:"hace %s",s:"unos segundos",ss:"%d segundos",m:"un minuto",mm:"%d minutos",h:"una hora",hh:"%d horas",d:"un día",dd:"%d días",w:"una semana",ww:"%d semanas",M:"un mes",MM:"%d meses",y:"un año",yy:"%d años"},dayOfMonthOrdinalParse:/\d{1,2}º/,ordinal:"%dº",week:{dow:1,doy:4},invalidDate:"Fecha inválida"})}(n(95093))},3035:function(e,t,n){!function(e){"use strict";function t(e,t,n,r){var a={s:["mõne sekundi","mõni sekund","paar sekundit"],ss:[e+"sekundi",e+"sekundit"],m:["ühe minuti","üks minut"],mm:[e+" minuti",e+" minutit"],h:["ühe tunni","tund aega","üks tund"],hh:[e+" tunni",e+" tundi"],d:["ühe päeva","üks päev"],M:["kuu aja","kuu aega","üks kuu"],MM:[e+" kuu",e+" kuud"],y:["ühe aasta","aasta","üks aasta"],yy:[e+" aasta",e+" aastat"]};return t?a[n][2]?a[n][2]:a[n][1]:r?a[n][0]:a[n][1]}e.defineLocale("et",{months:"jaanuar_veebruar_märts_aprill_mai_juuni_juuli_august_september_oktoober_november_detsember".split("_"),monthsShort:"jaan_veebr_märts_apr_mai_juuni_juuli_aug_sept_okt_nov_dets".split("_"),weekdays:"pühapäev_esmaspäev_teisipäev_kolmapäev_neljapäev_reede_laupäev".split("_"),weekdaysShort:"P_E_T_K_N_R_L".split("_"),weekdaysMin:"P_E_T_K_N_R_L".split("_"),longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD.MM.YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY H:mm",LLLL:"dddd, D. MMMM YYYY H:mm"},calendar:{sameDay:"[Täna,] LT",nextDay:"[Homme,] LT",nextWeek:"[Järgmine] dddd LT",lastDay:"[Eile,] LT",lastWeek:"[Eelmine] dddd LT",sameElse:"L"},relativeTime:{future:"%s pärast",past:"%s tagasi",s:t,ss:t,m:t,mm:t,h:t,hh:t,d:t,dd:"%d päeva",M:t,MM:t,y:t,yy:t},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:4}})}(n(95093))},3508:function(e,t,n){!function(e){"use strict";e.defineLocale("eu",{months:"urtarrila_otsaila_martxoa_apirila_maiatza_ekaina_uztaila_abuztua_iraila_urria_azaroa_abendua".split("_"),monthsShort:"urt._ots._mar._api._mai._eka._uzt._abu._ira._urr._aza._abe.".split("_"),monthsParseExact:!0,weekdays:"igandea_astelehena_asteartea_asteazkena_osteguna_ostirala_larunbata".split("_"),weekdaysShort:"ig._al._ar._az._og._ol._lr.".split("_"),weekdaysMin:"ig_al_ar_az_og_ol_lr".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"YYYY-MM-DD",LL:"YYYY[ko] MMMM[ren] D[a]",LLL:"YYYY[ko] MMMM[ren] D[a] HH:mm",LLLL:"dddd, YYYY[ko] MMMM[ren] D[a] HH:mm",l:"YYYY-M-D",ll:"YYYY[ko] MMM D[a]",lll:"YYYY[ko] MMM D[a] HH:mm",llll:"ddd, YYYY[ko] MMM D[a] HH:mm"},calendar:{sameDay:"[gaur] LT[etan]",nextDay:"[bihar] LT[etan]",nextWeek:"dddd LT[etan]",lastDay:"[atzo] LT[etan]",lastWeek:"[aurreko] dddd LT[etan]",sameElse:"L"},relativeTime:{future:"%s barru",past:"duela %s",s:"segundo batzuk",ss:"%d segundo",m:"minutu bat",mm:"%d minutu",h:"ordu bat",hh:"%d ordu",d:"egun bat",dd:"%d egun",M:"hilabete bat",MM:"%d hilabete",y:"urte bat",yy:"%d urte"},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:7}})}(n(95093))},119:function(e,t,n){!function(e){"use strict";var t={1:"۱",2:"۲",3:"۳",4:"۴",5:"۵",6:"۶",7:"۷",8:"۸",9:"۹",0:"۰"},n={"۱":"1","۲":"2","۳":"3","۴":"4","۵":"5","۶":"6","۷":"7","۸":"8","۹":"9","۰":"0"};e.defineLocale("fa",{months:"ژانویه_فوریه_مارس_آوریل_مه_ژوئن_ژوئیه_اوت_سپتامبر_اکتبر_نوامبر_دسامبر".split("_"),monthsShort:"ژانویه_فوریه_مارس_آوریل_مه_ژوئن_ژوئیه_اوت_سپتامبر_اکتبر_نوامبر_دسامبر".split("_"),weekdays:"یک‌شنبه_دوشنبه_سه‌شنبه_چهارشنبه_پنج‌شنبه_جمعه_شنبه".split("_"),weekdaysShort:"یک‌شنبه_دوشنبه_سه‌شنبه_چهارشنبه_پنج‌شنبه_جمعه_شنبه".split("_"),weekdaysMin:"ی_د_س_چ_پ_ج_ش".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},meridiemParse:/قبل از ظهر|بعد از ظهر/,isPM:function(e){return/بعد از ظهر/.test(e)},meridiem:function(e,t,n){return e<12?"قبل از ظهر":"بعد از ظهر"},calendar:{sameDay:"[امروز ساعت] LT",nextDay:"[فردا ساعت] LT",nextWeek:"dddd [ساعت] LT",lastDay:"[دیروز ساعت] LT",lastWeek:"dddd [پیش] [ساعت] LT",sameElse:"L"},relativeTime:{future:"در %s",past:"%s پیش",s:"چند ثانیه",ss:"%d ثانیه",m:"یک دقیقه",mm:"%d دقیقه",h:"یک ساعت",hh:"%d ساعت",d:"یک روز",dd:"%d روز",M:"یک ماه",MM:"%d ماه",y:"یک سال",yy:"%d سال"},preparse:function(e){return e.replace(/[۰-۹]/g,(function(e){return n[e]})).replace(/،/g,",")},postformat:function(e){return e.replace(/\d/g,(function(e){return t[e]})).replace(/,/g,"،")},dayOfMonthOrdinalParse:/\d{1,2}م/,ordinal:"%dم",week:{dow:6,doy:12}})}(n(95093))},90527:function(e,t,n){!function(e){"use strict";var t="nolla yksi kaksi kolme neljä viisi kuusi seitsemän kahdeksan yhdeksän".split(" "),n=["nolla","yhden","kahden","kolmen","neljän","viiden","kuuden",t[7],t[8],t[9]];function r(e,t,n,r){var s="";switch(n){case"s":return r?"muutaman sekunnin":"muutama sekunti";case"ss":s=r?"sekunnin":"sekuntia";break;case"m":return r?"minuutin":"minuutti";case"mm":s=r?"minuutin":"minuuttia";break;case"h":return r?"tunnin":"tunti";case"hh":s=r?"tunnin":"tuntia";break;case"d":return r?"päivän":"päivä";case"dd":s=r?"päivän":"päivää";break;case"M":return r?"kuukauden":"kuukausi";case"MM":s=r?"kuukauden":"kuukautta";break;case"y":return r?"vuoden":"vuosi";case"yy":s=r?"vuoden":"vuotta"}return s=a(e,r)+" "+s}function a(e,r){return e<10?r?n[e]:t[e]:e}e.defineLocale("fi",{months:"tammikuu_helmikuu_maaliskuu_huhtikuu_toukokuu_kesäkuu_heinäkuu_elokuu_syyskuu_lokakuu_marraskuu_joulukuu".split("_"),monthsShort:"tammi_helmi_maalis_huhti_touko_kesä_heinä_elo_syys_loka_marras_joulu".split("_"),weekdays:"sunnuntai_maanantai_tiistai_keskiviikko_torstai_perjantai_lauantai".split("_"),weekdaysShort:"su_ma_ti_ke_to_pe_la".split("_"),weekdaysMin:"su_ma_ti_ke_to_pe_la".split("_"),longDateFormat:{LT:"HH.mm",LTS:"HH.mm.ss",L:"DD.MM.YYYY",LL:"Do MMMM[ta] YYYY",LLL:"Do MMMM[ta] YYYY, [klo] HH.mm",LLLL:"dddd, Do MMMM[ta] YYYY, [klo] HH.mm",l:"D.M.YYYY",ll:"Do MMM YYYY",lll:"Do MMM YYYY, [klo] HH.mm",llll:"ddd, Do MMM YYYY, [klo] HH.mm"},calendar:{sameDay:"[tänään] [klo] LT",nextDay:"[huomenna] [klo] LT",nextWeek:"dddd [klo] LT",lastDay:"[eilen] [klo] LT",lastWeek:"[viime] dddd[na] [klo] LT",sameElse:"L"},relativeTime:{future:"%s päästä",past:"%s sitten",s:r,ss:r,m:r,mm:r,h:r,hh:r,d:r,dd:r,M:r,MM:r,y:r,yy:r},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:4}})}(n(95093))},95995:function(e,t,n){!function(e){"use strict";e.defineLocale("fil",{months:"Enero_Pebrero_Marso_Abril_Mayo_Hunyo_Hulyo_Agosto_Setyembre_Oktubre_Nobyembre_Disyembre".split("_"),monthsShort:"Ene_Peb_Mar_Abr_May_Hun_Hul_Ago_Set_Okt_Nob_Dis".split("_"),weekdays:"Linggo_Lunes_Martes_Miyerkules_Huwebes_Biyernes_Sabado".split("_"),weekdaysShort:"Lin_Lun_Mar_Miy_Huw_Biy_Sab".split("_"),weekdaysMin:"Li_Lu_Ma_Mi_Hu_Bi_Sab".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"MM/D/YYYY",LL:"MMMM D, YYYY",LLL:"MMMM D, YYYY HH:mm",LLLL:"dddd, MMMM DD, YYYY HH:mm"},calendar:{sameDay:"LT [ngayong araw]",nextDay:"[Bukas ng] LT",nextWeek:"LT [sa susunod na] dddd",lastDay:"LT [kahapon]",lastWeek:"LT [noong nakaraang] dddd",sameElse:"L"},relativeTime:{future:"sa loob ng %s",past:"%s ang nakalipas",s:"ilang segundo",ss:"%d segundo",m:"isang minuto",mm:"%d minuto",h:"isang oras",hh:"%d oras",d:"isang araw",dd:"%d araw",M:"isang buwan",MM:"%d buwan",y:"isang taon",yy:"%d taon"},dayOfMonthOrdinalParse:/\d{1,2}/,ordinal:function(e){return e},week:{dow:1,doy:4}})}(n(95093))},52477:function(e,t,n){!function(e){"use strict";e.defineLocale("fo",{months:"januar_februar_mars_apríl_mai_juni_juli_august_september_oktober_november_desember".split("_"),monthsShort:"jan_feb_mar_apr_mai_jun_jul_aug_sep_okt_nov_des".split("_"),weekdays:"sunnudagur_mánadagur_týsdagur_mikudagur_hósdagur_fríggjadagur_leygardagur".split("_"),weekdaysShort:"sun_mán_týs_mik_hós_frí_ley".split("_"),weekdaysMin:"su_má_tý_mi_hó_fr_le".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D. MMMM, YYYY HH:mm"},calendar:{sameDay:"[Í dag kl.] LT",nextDay:"[Í morgin kl.] LT",nextWeek:"dddd [kl.] LT",lastDay:"[Í gjár kl.] LT",lastWeek:"[síðstu] dddd [kl] LT",sameElse:"L"},relativeTime:{future:"um %s",past:"%s síðani",s:"fá sekund",ss:"%d sekundir",m:"ein minuttur",mm:"%d minuttir",h:"ein tími",hh:"%d tímar",d:"ein dagur",dd:"%d dagar",M:"ein mánaður",MM:"%d mánaðir",y:"eitt ár",yy:"%d ár"},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:4}})}(n(95093))},26435:function(e,t,n){!function(e){"use strict";e.defineLocale("fr-ca",{months:"janvier_février_mars_avril_mai_juin_juillet_août_septembre_octobre_novembre_décembre".split("_"),monthsShort:"janv._févr._mars_avr._mai_juin_juil._août_sept._oct._nov._déc.".split("_"),monthsParseExact:!0,weekdays:"dimanche_lundi_mardi_mercredi_jeudi_vendredi_samedi".split("_"),weekdaysShort:"dim._lun._mar._mer._jeu._ven._sam.".split("_"),weekdaysMin:"di_lu_ma_me_je_ve_sa".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"YYYY-MM-DD",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},calendar:{sameDay:"[Aujourd’hui à] LT",nextDay:"[Demain à] LT",nextWeek:"dddd [à] LT",lastDay:"[Hier à] LT",lastWeek:"dddd [dernier à] LT",sameElse:"L"},relativeTime:{future:"dans %s",past:"il y a %s",s:"quelques secondes",ss:"%d secondes",m:"une minute",mm:"%d minutes",h:"une heure",hh:"%d heures",d:"un jour",dd:"%d jours",M:"un mois",MM:"%d mois",y:"un an",yy:"%d ans"},dayOfMonthOrdinalParse:/\d{1,2}(er|e)/,ordinal:function(e,t){switch(t){default:case"M":case"Q":case"D":case"DDD":case"d":return e+(1===e?"er":"e");case"w":case"W":return e+(1===e?"re":"e")}}})}(n(95093))},37892:function(e,t,n){!function(e){"use strict";e.defineLocale("fr-ch",{months:"janvier_février_mars_avril_mai_juin_juillet_août_septembre_octobre_novembre_décembre".split("_"),monthsShort:"janv._févr._mars_avr._mai_juin_juil._août_sept._oct._nov._déc.".split("_"),monthsParseExact:!0,weekdays:"dimanche_lundi_mardi_mercredi_jeudi_vendredi_samedi".split("_"),weekdaysShort:"dim._lun._mar._mer._jeu._ven._sam.".split("_"),weekdaysMin:"di_lu_ma_me_je_ve_sa".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},calendar:{sameDay:"[Aujourd’hui à] LT",nextDay:"[Demain à] LT",nextWeek:"dddd [à] LT",lastDay:"[Hier à] LT",lastWeek:"dddd [dernier à] LT",sameElse:"L"},relativeTime:{future:"dans %s",past:"il y a %s",s:"quelques secondes",ss:"%d secondes",m:"une minute",mm:"%d minutes",h:"une heure",hh:"%d heures",d:"un jour",dd:"%d jours",M:"un mois",MM:"%d mois",y:"un an",yy:"%d ans"},dayOfMonthOrdinalParse:/\d{1,2}(er|e)/,ordinal:function(e,t){switch(t){default:case"M":case"Q":case"D":case"DDD":case"d":return e+(1===e?"er":"e");case"w":case"W":return e+(1===e?"re":"e")}},week:{dow:1,doy:4}})}(n(95093))},85498:function(e,t,n){!function(e){"use strict";var t=/^(janvier|février|mars|avril|mai|juin|juillet|août|septembre|octobre|novembre|décembre)/i,n=/(janv\.?|févr\.?|mars|avr\.?|mai|juin|juil\.?|août|sept\.?|oct\.?|nov\.?|déc\.?)/i,r=/(janv\.?|févr\.?|mars|avr\.?|mai|juin|juil\.?|août|sept\.?|oct\.?|nov\.?|déc\.?|janvier|février|mars|avril|mai|juin|juillet|août|septembre|octobre|novembre|décembre)/i,a=[/^janv/i,/^févr/i,/^mars/i,/^avr/i,/^mai/i,/^juin/i,/^juil/i,/^août/i,/^sept/i,/^oct/i,/^nov/i,/^déc/i];e.defineLocale("fr",{months:"janvier_février_mars_avril_mai_juin_juillet_août_septembre_octobre_novembre_décembre".split("_"),monthsShort:"janv._févr._mars_avr._mai_juin_juil._août_sept._oct._nov._déc.".split("_"),monthsRegex:r,monthsShortRegex:r,monthsStrictRegex:t,monthsShortStrictRegex:n,monthsParse:a,longMonthsParse:a,shortMonthsParse:a,weekdays:"dimanche_lundi_mardi_mercredi_jeudi_vendredi_samedi".split("_"),weekdaysShort:"dim._lun._mar._mer._jeu._ven._sam.".split("_"),weekdaysMin:"di_lu_ma_me_je_ve_sa".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},calendar:{sameDay:"[Aujourd’hui à] LT",nextDay:"[Demain à] LT",nextWeek:"dddd [à] LT",lastDay:"[Hier à] LT",lastWeek:"dddd [dernier à] LT",sameElse:"L"},relativeTime:{future:"dans %s",past:"il y a %s",s:"quelques secondes",ss:"%d secondes",m:"une minute",mm:"%d minutes",h:"une heure",hh:"%d heures",d:"un jour",dd:"%d jours",w:"une semaine",ww:"%d semaines",M:"un mois",MM:"%d mois",y:"un an",yy:"%d ans"},dayOfMonthOrdinalParse:/\d{1,2}(er|)/,ordinal:function(e,t){switch(t){case"D":return e+(1===e?"er":"");default:case"M":case"Q":case"DDD":case"d":return e+(1===e?"er":"e");case"w":case"W":return e+(1===e?"re":"e")}},week:{dow:1,doy:4}})}(n(95093))},37071:function(e,t,n){!function(e){"use strict";var t="jan._feb._mrt._apr._mai_jun._jul._aug._sep._okt._nov._des.".split("_"),n="jan_feb_mrt_apr_mai_jun_jul_aug_sep_okt_nov_des".split("_");e.defineLocale("fy",{months:"jannewaris_febrewaris_maart_april_maaie_juny_july_augustus_septimber_oktober_novimber_desimber".split("_"),monthsShort:function(e,r){return e?/-MMM-/.test(r)?n[e.month()]:t[e.month()]:t},monthsParseExact:!0,weekdays:"snein_moandei_tiisdei_woansdei_tongersdei_freed_sneon".split("_"),weekdaysShort:"si._mo._ti._wo._to._fr._so.".split("_"),weekdaysMin:"Si_Mo_Ti_Wo_To_Fr_So".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD-MM-YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},calendar:{sameDay:"[hjoed om] LT",nextDay:"[moarn om] LT",nextWeek:"dddd [om] LT",lastDay:"[juster om] LT",lastWeek:"[ôfrûne] dddd [om] LT",sameElse:"L"},relativeTime:{future:"oer %s",past:"%s lyn",s:"in pear sekonden",ss:"%d sekonden",m:"ien minút",mm:"%d minuten",h:"ien oere",hh:"%d oeren",d:"ien dei",dd:"%d dagen",M:"ien moanne",MM:"%d moannen",y:"ien jier",yy:"%d jierren"},dayOfMonthOrdinalParse:/\d{1,2}(ste|de)/,ordinal:function(e){return e+(1===e||8===e||e>=20?"ste":"de")},week:{dow:1,doy:4}})}(n(95093))},41734:function(e,t,n){!function(e){"use strict";var t=["Eanáir","Feabhra","Márta","Aibreán","Bealtaine","Meitheamh","Iúil","Lúnasa","Meán Fómhair","Deireadh Fómhair","Samhain","Nollaig"],n=["Ean","Feabh","Márt","Aib","Beal","Meith","Iúil","Lún","M.F.","D.F.","Samh","Noll"],r=["Dé Domhnaigh","Dé Luain","Dé Máirt","Dé Céadaoin","Déardaoin","Dé hAoine","Dé Sathairn"],a=["Domh","Luan","Máirt","Céad","Déar","Aoine","Sath"],s=["Do","Lu","Má","Cé","Dé","A","Sa"];e.defineLocale("ga",{months:t,monthsShort:n,monthsParseExact:!0,weekdays:r,weekdaysShort:a,weekdaysMin:s,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[Inniu ag] LT",nextDay:"[Amárach ag] LT",nextWeek:"dddd [ag] LT",lastDay:"[Inné ag] LT",lastWeek:"dddd [seo caite] [ag] LT",sameElse:"L"},relativeTime:{future:"i %s",past:"%s ó shin",s:"cúpla soicind",ss:"%d soicind",m:"nóiméad",mm:"%d nóiméad",h:"uair an chloig",hh:"%d uair an chloig",d:"lá",dd:"%d lá",M:"mí",MM:"%d míonna",y:"bliain",yy:"%d bliain"},dayOfMonthOrdinalParse:/\d{1,2}(d|na|mh)/,ordinal:function(e){return e+(1===e?"d":e%10==2?"na":"mh")},week:{dow:1,doy:4}})}(n(95093))},70217:function(e,t,n){!function(e){"use strict";var t=["Am Faoilleach","An Gearran","Am Màrt","An Giblean","An Cèitean","An t-Ògmhios","An t-Iuchar","An Lùnastal","An t-Sultain","An Dàmhair","An t-Samhain","An Dùbhlachd"],n=["Faoi","Gear","Màrt","Gibl","Cèit","Ògmh","Iuch","Lùn","Sult","Dàmh","Samh","Dùbh"],r=["Didòmhnaich","Diluain","Dimàirt","Diciadain","Diardaoin","Dihaoine","Disathairne"],a=["Did","Dil","Dim","Dic","Dia","Dih","Dis"],s=["Dò","Lu","Mà","Ci","Ar","Ha","Sa"];e.defineLocale("gd",{months:t,monthsShort:n,monthsParseExact:!0,weekdays:r,weekdaysShort:a,weekdaysMin:s,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[An-diugh aig] LT",nextDay:"[A-màireach aig] LT",nextWeek:"dddd [aig] LT",lastDay:"[An-dè aig] LT",lastWeek:"dddd [seo chaidh] [aig] LT",sameElse:"L"},relativeTime:{future:"ann an %s",past:"bho chionn %s",s:"beagan diogan",ss:"%d diogan",m:"mionaid",mm:"%d mionaidean",h:"uair",hh:"%d uairean",d:"latha",dd:"%d latha",M:"mìos",MM:"%d mìosan",y:"bliadhna",yy:"%d bliadhna"},dayOfMonthOrdinalParse:/\d{1,2}(d|na|mh)/,ordinal:function(e){return e+(1===e?"d":e%10==2?"na":"mh")},week:{dow:1,doy:4}})}(n(95093))},77329:function(e,t,n){!function(e){"use strict";e.defineLocale("gl",{months:"xaneiro_febreiro_marzo_abril_maio_xuño_xullo_agosto_setembro_outubro_novembro_decembro".split("_"),monthsShort:"xan._feb._mar._abr._mai._xuñ._xul._ago._set._out._nov._dec.".split("_"),monthsParseExact:!0,weekdays:"domingo_luns_martes_mércores_xoves_venres_sábado".split("_"),weekdaysShort:"dom._lun._mar._mér._xov._ven._sáb.".split("_"),weekdaysMin:"do_lu_ma_mé_xo_ve_sá".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD/MM/YYYY",LL:"D [de] MMMM [de] YYYY",LLL:"D [de] MMMM [de] YYYY H:mm",LLLL:"dddd, D [de] MMMM [de] YYYY H:mm"},calendar:{sameDay:function(){return"[hoxe "+(1!==this.hours()?"ás":"á")+"] LT"},nextDay:function(){return"[mañá "+(1!==this.hours()?"ás":"á")+"] LT"},nextWeek:function(){return"dddd ["+(1!==this.hours()?"ás":"a")+"] LT"},lastDay:function(){return"[onte "+(1!==this.hours()?"á":"a")+"] LT"},lastWeek:function(){return"[o] dddd [pasado "+(1!==this.hours()?"ás":"a")+"] LT"},sameElse:"L"},relativeTime:{future:function(e){return 0===e.indexOf("un")?"n"+e:"en "+e},past:"hai %s",s:"uns segundos",ss:"%d segundos",m:"un minuto",mm:"%d minutos",h:"unha hora",hh:"%d horas",d:"un día",dd:"%d días",M:"un mes",MM:"%d meses",y:"un ano",yy:"%d anos"},dayOfMonthOrdinalParse:/\d{1,2}º/,ordinal:"%dº",week:{dow:1,doy:4}})}(n(95093))},32124:function(e,t,n){!function(e){"use strict";function t(e,t,n,r){var a={s:["थोडया सॅकंडांनी","थोडे सॅकंड"],ss:[e+" सॅकंडांनी",e+" सॅकंड"],m:["एका मिणटान","एक मिनूट"],mm:[e+" मिणटांनी",e+" मिणटां"],h:["एका वरान","एक वर"],hh:[e+" वरांनी",e+" वरां"],d:["एका दिसान","एक दीस"],dd:[e+" दिसांनी",e+" दीस"],M:["एका म्हयन्यान","एक म्हयनो"],MM:[e+" म्हयन्यानी",e+" म्हयने"],y:["एका वर्सान","एक वर्स"],yy:[e+" वर्सांनी",e+" वर्सां"]};return r?a[n][0]:a[n][1]}e.defineLocale("gom-deva",{months:{standalone:"जानेवारी_फेब्रुवारी_मार्च_एप्रील_मे_जून_जुलय_ऑगस्ट_सप्टेंबर_ऑक्टोबर_नोव्हेंबर_डिसेंबर".split("_"),format:"जानेवारीच्या_फेब्रुवारीच्या_मार्चाच्या_एप्रीलाच्या_मेयाच्या_जूनाच्या_जुलयाच्या_ऑगस्टाच्या_सप्टेंबराच्या_ऑक्टोबराच्या_नोव्हेंबराच्या_डिसेंबराच्या".split("_"),isFormat:/MMMM(\s)+D[oD]?/},monthsShort:"जाने._फेब्रु._मार्च_एप्री._मे_जून_जुल._ऑग._सप्टें._ऑक्टो._नोव्हें._डिसें.".split("_"),monthsParseExact:!0,weekdays:"आयतार_सोमार_मंगळार_बुधवार_बिरेस्तार_सुक्रार_शेनवार".split("_"),weekdaysShort:"आयत._सोम._मंगळ._बुध._ब्रेस्त._सुक्र._शेन.".split("_"),weekdaysMin:"आ_सो_मं_बु_ब्रे_सु_शे".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"A h:mm [वाजतां]",LTS:"A h:mm:ss [वाजतां]",L:"DD-MM-YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY A h:mm [वाजतां]",LLLL:"dddd, MMMM Do, YYYY, A h:mm [वाजतां]",llll:"ddd, D MMM YYYY, A h:mm [वाजतां]"},calendar:{sameDay:"[आयज] LT",nextDay:"[फाल्यां] LT",nextWeek:"[फुडलो] dddd[,] LT",lastDay:"[काल] LT",lastWeek:"[फाटलो] dddd[,] LT",sameElse:"L"},relativeTime:{future:"%s",past:"%s आदीं",s:t,ss:t,m:t,mm:t,h:t,hh:t,d:t,dd:t,M:t,MM:t,y:t,yy:t},dayOfMonthOrdinalParse:/\d{1,2}(वेर)/,ordinal:function(e,t){return"D"===t?e+"वेर":e},week:{dow:0,doy:3},meridiemParse:/राती|सकाळीं|दनपारां|सांजे/,meridiemHour:function(e,t){return 12===e&&(e=0),"राती"===t?e<4?e:e+12:"सकाळीं"===t?e:"दनपारां"===t?e>12?e:e+12:"सांजे"===t?e+12:void 0},meridiem:function(e,t,n){return e<4?"राती":e<12?"सकाळीं":e<16?"दनपारां":e<20?"सांजे":"राती"}})}(n(95093))},93383:function(e,t,n){!function(e){"use strict";function t(e,t,n,r){var a={s:["thoddea sekondamni","thodde sekond"],ss:[e+" sekondamni",e+" sekond"],m:["eka mintan","ek minut"],mm:[e+" mintamni",e+" mintam"],h:["eka voran","ek vor"],hh:[e+" voramni",e+" voram"],d:["eka disan","ek dis"],dd:[e+" disamni",e+" dis"],M:["eka mhoinean","ek mhoino"],MM:[e+" mhoineamni",e+" mhoine"],y:["eka vorsan","ek voros"],yy:[e+" vorsamni",e+" vorsam"]};return r?a[n][0]:a[n][1]}e.defineLocale("gom-latn",{months:{standalone:"Janer_Febrer_Mars_Abril_Mai_Jun_Julai_Agost_Setembr_Otubr_Novembr_Dezembr".split("_"),format:"Janerachea_Febrerachea_Marsachea_Abrilachea_Maiachea_Junachea_Julaiachea_Agostachea_Setembrachea_Otubrachea_Novembrachea_Dezembrachea".split("_"),isFormat:/MMMM(\s)+D[oD]?/},monthsShort:"Jan._Feb._Mars_Abr._Mai_Jun_Jul._Ago._Set._Otu._Nov._Dez.".split("_"),monthsParseExact:!0,weekdays:"Aitar_Somar_Mongllar_Budhvar_Birestar_Sukrar_Son'var".split("_"),weekdaysShort:"Ait._Som._Mon._Bud._Bre._Suk._Son.".split("_"),weekdaysMin:"Ai_Sm_Mo_Bu_Br_Su_Sn".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"A h:mm [vazta]",LTS:"A h:mm:ss [vazta]",L:"DD-MM-YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY A h:mm [vazta]",LLLL:"dddd, MMMM Do, YYYY, A h:mm [vazta]",llll:"ddd, D MMM YYYY, A h:mm [vazta]"},calendar:{sameDay:"[Aiz] LT",nextDay:"[Faleam] LT",nextWeek:"[Fuddlo] dddd[,] LT",lastDay:"[Kal] LT",lastWeek:"[Fattlo] dddd[,] LT",sameElse:"L"},relativeTime:{future:"%s",past:"%s adim",s:t,ss:t,m:t,mm:t,h:t,hh:t,d:t,dd:t,M:t,MM:t,y:t,yy:t},dayOfMonthOrdinalParse:/\d{1,2}(er)/,ordinal:function(e,t){return"D"===t?e+"er":e},week:{dow:0,doy:3},meridiemParse:/rati|sokallim|donparam|sanje/,meridiemHour:function(e,t){return 12===e&&(e=0),"rati"===t?e<4?e:e+12:"sokallim"===t?e:"donparam"===t?e>12?e:e+12:"sanje"===t?e+12:void 0},meridiem:function(e,t,n){return e<4?"rati":e<12?"sokallim":e<16?"donparam":e<20?"sanje":"rati"}})}(n(95093))},95050:function(e,t,n){!function(e){"use strict";var t={1:"૧",2:"૨",3:"૩",4:"૪",5:"૫",6:"૬",7:"૭",8:"૮",9:"૯",0:"૦"},n={"૧":"1","૨":"2","૩":"3","૪":"4","૫":"5","૬":"6","૭":"7","૮":"8","૯":"9","૦":"0"};e.defineLocale("gu",{months:"જાન્યુઆરી_ફેબ્રુઆરી_માર્ચ_એપ્રિલ_મે_જૂન_જુલાઈ_ઑગસ્ટ_સપ્ટેમ્બર_ઑક્ટ્બર_નવેમ્બર_ડિસેમ્બર".split("_"),monthsShort:"જાન્યુ._ફેબ્રુ._માર્ચ_એપ્રિ._મે_જૂન_જુલા._ઑગ._સપ્ટે._ઑક્ટ્._નવે._ડિસે.".split("_"),monthsParseExact:!0,weekdays:"રવિવાર_સોમવાર_મંગળવાર_બુધ્વાર_ગુરુવાર_શુક્રવાર_શનિવાર".split("_"),weekdaysShort:"રવિ_સોમ_મંગળ_બુધ્_ગુરુ_શુક્ર_શનિ".split("_"),weekdaysMin:"ર_સો_મં_બુ_ગુ_શુ_શ".split("_"),longDateFormat:{LT:"A h:mm વાગ્યે",LTS:"A h:mm:ss વાગ્યે",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY, A h:mm વાગ્યે",LLLL:"dddd, D MMMM YYYY, A h:mm વાગ્યે"},calendar:{sameDay:"[આજ] LT",nextDay:"[કાલે] LT",nextWeek:"dddd, LT",lastDay:"[ગઇકાલે] LT",lastWeek:"[પાછલા] dddd, LT",sameElse:"L"},relativeTime:{future:"%s મા",past:"%s પહેલા",s:"અમુક પળો",ss:"%d સેકંડ",m:"એક મિનિટ",mm:"%d મિનિટ",h:"એક કલાક",hh:"%d કલાક",d:"એક દિવસ",dd:"%d દિવસ",M:"એક મહિનો",MM:"%d મહિનો",y:"એક વર્ષ",yy:"%d વર્ષ"},preparse:function(e){return e.replace(/[૧૨૩૪૫૬૭૮૯૦]/g,(function(e){return n[e]}))},postformat:function(e){return e.replace(/\d/g,(function(e){return t[e]}))},meridiemParse:/રાત|બપોર|સવાર|સાંજ/,meridiemHour:function(e,t){return 12===e&&(e=0),"રાત"===t?e<4?e:e+12:"સવાર"===t?e:"બપોર"===t?e>=10?e:e+12:"સાંજ"===t?e+12:void 0},meridiem:function(e,t,n){return e<4?"રાત":e<10?"સવાર":e<17?"બપોર":e<20?"સાંજ":"રાત"},week:{dow:0,doy:6}})}(n(95093))},11713:function(e,t,n){!function(e){"use strict";e.defineLocale("he",{months:"ינואר_פברואר_מרץ_אפריל_מאי_יוני_יולי_אוגוסט_ספטמבר_אוקטובר_נובמבר_דצמבר".split("_"),monthsShort:"ינו׳_פבר׳_מרץ_אפר׳_מאי_יוני_יולי_אוג׳_ספט׳_אוק׳_נוב׳_דצמ׳".split("_"),weekdays:"ראשון_שני_שלישי_רביעי_חמישי_שישי_שבת".split("_"),weekdaysShort:"א׳_ב׳_ג׳_ד׳_ה׳_ו׳_ש׳".split("_"),weekdaysMin:"א_ב_ג_ד_ה_ו_ש".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D [ב]MMMM YYYY",LLL:"D [ב]MMMM YYYY HH:mm",LLLL:"dddd, D [ב]MMMM YYYY HH:mm",l:"D/M/YYYY",ll:"D MMM YYYY",lll:"D MMM YYYY HH:mm",llll:"ddd, D MMM YYYY HH:mm"},calendar:{sameDay:"[היום ב־]LT",nextDay:"[מחר ב־]LT",nextWeek:"dddd [בשעה] LT",lastDay:"[אתמול ב־]LT",lastWeek:"[ביום] dddd [האחרון בשעה] LT",sameElse:"L"},relativeTime:{future:"בעוד %s",past:"לפני %s",s:"מספר שניות",ss:"%d שניות",m:"דקה",mm:"%d דקות",h:"שעה",hh:function(e){return 2===e?"שעתיים":e+" שעות"},d:"יום",dd:function(e){return 2===e?"יומיים":e+" ימים"},M:"חודש",MM:function(e){return 2===e?"חודשיים":e+" חודשים"},y:"שנה",yy:function(e){return 2===e?"שנתיים":e%10==0&&10!==e?e+" שנה":e+" שנים"}},meridiemParse:/אחה"צ|לפנה"צ|אחרי הצהריים|לפני הצהריים|לפנות בוקר|בבוקר|בערב/i,isPM:function(e){return/^(אחה"צ|אחרי הצהריים|בערב)$/.test(e)},meridiem:function(e,t,n){return e<5?"לפנות בוקר":e<10?"בבוקר":e<12?n?'לפנה"צ':"לפני הצהריים":e<18?n?'אחה"צ':"אחרי הצהריים":"בערב"}})}(n(95093))},43861:function(e,t,n){!function(e){"use strict";var t={1:"१",2:"२",3:"३",4:"४",5:"५",6:"६",7:"७",8:"८",9:"९",0:"०"},n={"१":"1","२":"2","३":"3","४":"4","५":"5","६":"6","७":"7","८":"8","९":"9","०":"0"},r=[/^जन/i,/^फ़र|फर/i,/^मार्च/i,/^अप्रै/i,/^मई/i,/^जून/i,/^जुल/i,/^अग/i,/^सितं|सित/i,/^अक्टू/i,/^नव|नवं/i,/^दिसं|दिस/i],a=[/^जन/i,/^फ़र/i,/^मार्च/i,/^अप्रै/i,/^मई/i,/^जून/i,/^जुल/i,/^अग/i,/^सित/i,/^अक्टू/i,/^नव/i,/^दिस/i];e.defineLocale("hi",{months:{format:"जनवरी_फ़रवरी_मार्च_अप्रैल_मई_जून_जुलाई_अगस्त_सितम्बर_अक्टूबर_नवम्बर_दिसम्बर".split("_"),standalone:"जनवरी_फरवरी_मार्च_अप्रैल_मई_जून_जुलाई_अगस्त_सितंबर_अक्टूबर_नवंबर_दिसंबर".split("_")},monthsShort:"जन._फ़र._मार्च_अप्रै._मई_जून_जुल._अग._सित._अक्टू._नव._दिस.".split("_"),weekdays:"रविवार_सोमवार_मंगलवार_बुधवार_गुरूवार_शुक्रवार_शनिवार".split("_"),weekdaysShort:"रवि_सोम_मंगल_बुध_गुरू_शुक्र_शनि".split("_"),weekdaysMin:"र_सो_मं_बु_गु_शु_श".split("_"),longDateFormat:{LT:"A h:mm बजे",LTS:"A h:mm:ss बजे",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY, A h:mm बजे",LLLL:"dddd, D MMMM YYYY, A h:mm बजे"},monthsParse:r,longMonthsParse:r,shortMonthsParse:a,monthsRegex:/^(जनवरी|जन\.?|फ़रवरी|फरवरी|फ़र\.?|मार्च?|अप्रैल|अप्रै\.?|मई?|जून?|जुलाई|जुल\.?|अगस्त|अग\.?|सितम्बर|सितंबर|सित\.?|अक्टूबर|अक्टू\.?|नवम्बर|नवंबर|नव\.?|दिसम्बर|दिसंबर|दिस\.?)/i,monthsShortRegex:/^(जनवरी|जन\.?|फ़रवरी|फरवरी|फ़र\.?|मार्च?|अप्रैल|अप्रै\.?|मई?|जून?|जुलाई|जुल\.?|अगस्त|अग\.?|सितम्बर|सितंबर|सित\.?|अक्टूबर|अक्टू\.?|नवम्बर|नवंबर|नव\.?|दिसम्बर|दिसंबर|दिस\.?)/i,monthsStrictRegex:/^(जनवरी?|फ़रवरी|फरवरी?|मार्च?|अप्रैल?|मई?|जून?|जुलाई?|अगस्त?|सितम्बर|सितंबर|सित?\.?|अक्टूबर|अक्टू\.?|नवम्बर|नवंबर?|दिसम्बर|दिसंबर?)/i,monthsShortStrictRegex:/^(जन\.?|फ़र\.?|मार्च?|अप्रै\.?|मई?|जून?|जुल\.?|अग\.?|सित\.?|अक्टू\.?|नव\.?|दिस\.?)/i,calendar:{sameDay:"[आज] LT",nextDay:"[कल] LT",nextWeek:"dddd, LT",lastDay:"[कल] LT",lastWeek:"[पिछले] dddd, LT",sameElse:"L"},relativeTime:{future:"%s में",past:"%s पहले",s:"कुछ ही क्षण",ss:"%d सेकंड",m:"एक मिनट",mm:"%d मिनट",h:"एक घंटा",hh:"%d घंटे",d:"एक दिन",dd:"%d दिन",M:"एक महीने",MM:"%d महीने",y:"एक वर्ष",yy:"%d वर्ष"},preparse:function(e){return e.replace(/[१२३४५६७८९०]/g,(function(e){return n[e]}))},postformat:function(e){return e.replace(/\d/g,(function(e){return t[e]}))},meridiemParse:/रात|सुबह|दोपहर|शाम/,meridiemHour:function(e,t){return 12===e&&(e=0),"रात"===t?e<4?e:e+12:"सुबह"===t?e:"दोपहर"===t?e>=10?e:e+12:"शाम"===t?e+12:void 0},meridiem:function(e,t,n){return e<4?"रात":e<10?"सुबह":e<17?"दोपहर":e<20?"शाम":"रात"},week:{dow:0,doy:6}})}(n(95093))},26308:function(e,t,n){!function(e){"use strict";function t(e,t,n){var r=e+" ";switch(n){case"ss":return r+=1===e?"sekunda":2===e||3===e||4===e?"sekunde":"sekundi";case"m":return t?"jedna minuta":"jedne minute";case"mm":return r+=1===e?"minuta":2===e||3===e||4===e?"minute":"minuta";case"h":return t?"jedan sat":"jednog sata";case"hh":return r+=1===e?"sat":2===e||3===e||4===e?"sata":"sati";case"dd":return r+=1===e?"dan":"dana";case"MM":return r+=1===e?"mjesec":2===e||3===e||4===e?"mjeseca":"mjeseci";case"yy":return r+=1===e?"godina":2===e||3===e||4===e?"godine":"godina"}}e.defineLocale("hr",{months:{format:"siječnja_veljače_ožujka_travnja_svibnja_lipnja_srpnja_kolovoza_rujna_listopada_studenoga_prosinca".split("_"),standalone:"siječanj_veljača_ožujak_travanj_svibanj_lipanj_srpanj_kolovoz_rujan_listopad_studeni_prosinac".split("_")},monthsShort:"sij._velj._ožu._tra._svi._lip._srp._kol._ruj._lis._stu._pro.".split("_"),monthsParseExact:!0,weekdays:"nedjelja_ponedjeljak_utorak_srijeda_četvrtak_petak_subota".split("_"),weekdaysShort:"ned._pon._uto._sri._čet._pet._sub.".split("_"),weekdaysMin:"ne_po_ut_sr_če_pe_su".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD.MM.YYYY",LL:"Do MMMM YYYY",LLL:"Do MMMM YYYY H:mm",LLLL:"dddd, Do MMMM YYYY H:mm"},calendar:{sameDay:"[danas u] LT",nextDay:"[sutra u] LT",nextWeek:function(){switch(this.day()){case 0:return"[u] [nedjelju] [u] LT";case 3:return"[u] [srijedu] [u] LT";case 6:return"[u] [subotu] [u] LT";case 1:case 2:case 4:case 5:return"[u] dddd [u] LT"}},lastDay:"[jučer u] LT",lastWeek:function(){switch(this.day()){case 0:return"[prošlu] [nedjelju] [u] LT";case 3:return"[prošlu] [srijedu] [u] LT";case 6:return"[prošle] [subote] [u] LT";case 1:case 2:case 4:case 5:return"[prošli] dddd [u] LT"}},sameElse:"L"},relativeTime:{future:"za %s",past:"prije %s",s:"par sekundi",ss:t,m:t,mm:t,h:t,hh:t,d:"dan",dd:t,M:"mjesec",MM:t,y:"godinu",yy:t},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:7}})}(n(95093))},90609:function(e,t,n){!function(e){"use strict";var t="vasárnap hétfőn kedden szerdán csütörtökön pénteken szombaton".split(" ");function n(e,t,n,r){var a=e;switch(n){case"s":return r||t?"néhány másodperc":"néhány másodperce";case"ss":return a+(r||t)?" másodperc":" másodperce";case"m":return"egy"+(r||t?" perc":" perce");case"mm":return a+(r||t?" perc":" perce");case"h":return"egy"+(r||t?" óra":" órája");case"hh":return a+(r||t?" óra":" órája");case"d":return"egy"+(r||t?" nap":" napja");case"dd":return a+(r||t?" nap":" napja");case"M":return"egy"+(r||t?" hónap":" hónapja");case"MM":return a+(r||t?" hónap":" hónapja");case"y":return"egy"+(r||t?" év":" éve");case"yy":return a+(r||t?" év":" éve")}return""}function r(e){return(e?"":"[múlt] ")+"["+t[this.day()]+"] LT[-kor]"}e.defineLocale("hu",{months:"január_február_március_április_május_június_július_augusztus_szeptember_október_november_december".split("_"),monthsShort:"jan._feb._márc._ápr._máj._jún._júl._aug._szept._okt._nov._dec.".split("_"),monthsParseExact:!0,weekdays:"vasárnap_hétfő_kedd_szerda_csütörtök_péntek_szombat".split("_"),weekdaysShort:"vas_hét_kedd_sze_csüt_pén_szo".split("_"),weekdaysMin:"v_h_k_sze_cs_p_szo".split("_"),longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"YYYY.MM.DD.",LL:"YYYY. MMMM D.",LLL:"YYYY. MMMM D. H:mm",LLLL:"YYYY. MMMM D., dddd H:mm"},meridiemParse:/de|du/i,isPM:function(e){return"u"===e.charAt(1).toLowerCase()},meridiem:function(e,t,n){return e<12?!0===n?"de":"DE":!0===n?"du":"DU"},calendar:{sameDay:"[ma] LT[-kor]",nextDay:"[holnap] LT[-kor]",nextWeek:function(){return r.call(this,!0)},lastDay:"[tegnap] LT[-kor]",lastWeek:function(){return r.call(this,!1)},sameElse:"L"},relativeTime:{future:"%s múlva",past:"%s",s:n,ss:n,m:n,mm:n,h:n,hh:n,d:n,dd:n,M:n,MM:n,y:n,yy:n},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:4}})}(n(95093))},17160:function(e,t,n){!function(e){"use strict";e.defineLocale("hy-am",{months:{format:"հունվարի_փետրվարի_մարտի_ապրիլի_մայիսի_հունիսի_հուլիսի_օգոստոսի_սեպտեմբերի_հոկտեմբերի_նոյեմբերի_դեկտեմբերի".split("_"),standalone:"հունվար_փետրվար_մարտ_ապրիլ_մայիս_հունիս_հուլիս_օգոստոս_սեպտեմբեր_հոկտեմբեր_նոյեմբեր_դեկտեմբեր".split("_")},monthsShort:"հնվ_փտր_մրտ_ապր_մյս_հնս_հլս_օգս_սպտ_հկտ_նմբ_դկտ".split("_"),weekdays:"կիրակի_երկուշաբթի_երեքշաբթի_չորեքշաբթի_հինգշաբթի_ուրբաթ_շաբաթ".split("_"),weekdaysShort:"կրկ_երկ_երք_չրք_հնգ_ուրբ_շբթ".split("_"),weekdaysMin:"կրկ_երկ_երք_չրք_հնգ_ուրբ_շբթ".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY թ.",LLL:"D MMMM YYYY թ., HH:mm",LLLL:"dddd, D MMMM YYYY թ., HH:mm"},calendar:{sameDay:"[այսօր] LT",nextDay:"[վաղը] LT",lastDay:"[երեկ] LT",nextWeek:function(){return"dddd [օրը ժամը] LT"},lastWeek:function(){return"[անցած] dddd [օրը ժամը] LT"},sameElse:"L"},relativeTime:{future:"%s հետո",past:"%s առաջ",s:"մի քանի վայրկյան",ss:"%d վայրկյան",m:"րոպե",mm:"%d րոպե",h:"ժամ",hh:"%d ժամ",d:"օր",dd:"%d օր",M:"ամիս",MM:"%d ամիս",y:"տարի",yy:"%d տարի"},meridiemParse:/գիշերվա|առավոտվա|ցերեկվա|երեկոյան/,isPM:function(e){return/^(ցերեկվա|երեկոյան)$/.test(e)},meridiem:function(e){return e<4?"գիշերվա":e<12?"առավոտվա":e<17?"ցերեկվա":"երեկոյան"},dayOfMonthOrdinalParse:/\d{1,2}|\d{1,2}-(ին|րդ)/,ordinal:function(e,t){switch(t){case"DDD":case"w":case"W":case"DDDo":return 1===e?e+"-ին":e+"-րդ";default:return e}},week:{dow:1,doy:7}})}(n(95093))},74063:function(e,t,n){!function(e){"use strict";e.defineLocale("id",{months:"Januari_Februari_Maret_April_Mei_Juni_Juli_Agustus_September_Oktober_November_Desember".split("_"),monthsShort:"Jan_Feb_Mar_Apr_Mei_Jun_Jul_Agt_Sep_Okt_Nov_Des".split("_"),weekdays:"Minggu_Senin_Selasa_Rabu_Kamis_Jumat_Sabtu".split("_"),weekdaysShort:"Min_Sen_Sel_Rab_Kam_Jum_Sab".split("_"),weekdaysMin:"Mg_Sn_Sl_Rb_Km_Jm_Sb".split("_"),longDateFormat:{LT:"HH.mm",LTS:"HH.mm.ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY [pukul] HH.mm",LLLL:"dddd, D MMMM YYYY [pukul] HH.mm"},meridiemParse:/pagi|siang|sore|malam/,meridiemHour:function(e,t){return 12===e&&(e=0),"pagi"===t?e:"siang"===t?e>=11?e:e+12:"sore"===t||"malam"===t?e+12:void 0},meridiem:function(e,t,n){return e<11?"pagi":e<15?"siang":e<19?"sore":"malam"},calendar:{sameDay:"[Hari ini pukul] LT",nextDay:"[Besok pukul] LT",nextWeek:"dddd [pukul] LT",lastDay:"[Kemarin pukul] LT",lastWeek:"dddd [lalu pukul] LT",sameElse:"L"},relativeTime:{future:"dalam %s",past:"%s yang lalu",s:"beberapa detik",ss:"%d detik",m:"semenit",mm:"%d menit",h:"sejam",hh:"%d jam",d:"sehari",dd:"%d hari",M:"sebulan",MM:"%d bulan",y:"setahun",yy:"%d tahun"},week:{dow:0,doy:6}})}(n(95093))},89374:function(e,t,n){!function(e){"use strict";function t(e){return e%100==11||e%10!=1}function n(e,n,r,a){var s=e+" ";switch(r){case"s":return n||a?"nokkrar sekúndur":"nokkrum sekúndum";case"ss":return t(e)?s+(n||a?"sekúndur":"sekúndum"):s+"sekúnda";case"m":return n?"mínúta":"mínútu";case"mm":return t(e)?s+(n||a?"mínútur":"mínútum"):n?s+"mínúta":s+"mínútu";case"hh":return t(e)?s+(n||a?"klukkustundir":"klukkustundum"):s+"klukkustund";case"d":return n?"dagur":a?"dag":"degi";case"dd":return t(e)?n?s+"dagar":s+(a?"daga":"dögum"):n?s+"dagur":s+(a?"dag":"degi");case"M":return n?"mánuður":a?"mánuð":"mánuði";case"MM":return t(e)?n?s+"mánuðir":s+(a?"mánuði":"mánuðum"):n?s+"mánuður":s+(a?"mánuð":"mánuði");case"y":return n||a?"ár":"ári";case"yy":return t(e)?s+(n||a?"ár":"árum"):s+(n||a?"ár":"ári")}}e.defineLocale("is",{months:"janúar_febrúar_mars_apríl_maí_júní_júlí_ágúst_september_október_nóvember_desember".split("_"),monthsShort:"jan_feb_mar_apr_maí_jún_júl_ágú_sep_okt_nóv_des".split("_"),weekdays:"sunnudagur_mánudagur_þriðjudagur_miðvikudagur_fimmtudagur_föstudagur_laugardagur".split("_"),weekdaysShort:"sun_mán_þri_mið_fim_fös_lau".split("_"),weekdaysMin:"Su_Má_Þr_Mi_Fi_Fö_La".split("_"),longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD.MM.YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY [kl.] H:mm",LLLL:"dddd, D. MMMM YYYY [kl.] H:mm"},calendar:{sameDay:"[í dag kl.] LT",nextDay:"[á morgun kl.] LT",nextWeek:"dddd [kl.] LT",lastDay:"[í gær kl.] LT",lastWeek:"[síðasta] dddd [kl.] LT",sameElse:"L"},relativeTime:{future:"eftir %s",past:"fyrir %s síðan",s:n,ss:n,m:n,mm:n,h:"klukkustund",hh:n,d:n,dd:n,M:n,MM:n,y:n,yy:n},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:4}})}(n(95093))},21827:function(e,t,n){!function(e){"use strict";e.defineLocale("it-ch",{months:"gennaio_febbraio_marzo_aprile_maggio_giugno_luglio_agosto_settembre_ottobre_novembre_dicembre".split("_"),monthsShort:"gen_feb_mar_apr_mag_giu_lug_ago_set_ott_nov_dic".split("_"),weekdays:"domenica_lunedì_martedì_mercoledì_giovedì_venerdì_sabato".split("_"),weekdaysShort:"dom_lun_mar_mer_gio_ven_sab".split("_"),weekdaysMin:"do_lu_ma_me_gi_ve_sa".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},calendar:{sameDay:"[Oggi alle] LT",nextDay:"[Domani alle] LT",nextWeek:"dddd [alle] LT",lastDay:"[Ieri alle] LT",lastWeek:function(){return 0===this.day()?"[la scorsa] dddd [alle] LT":"[lo scorso] dddd [alle] LT"},sameElse:"L"},relativeTime:{future:function(e){return(/^[0-9].+$/.test(e)?"tra":"in")+" "+e},past:"%s fa",s:"alcuni secondi",ss:"%d secondi",m:"un minuto",mm:"%d minuti",h:"un'ora",hh:"%d ore",d:"un giorno",dd:"%d giorni",M:"un mese",MM:"%d mesi",y:"un anno",yy:"%d anni"},dayOfMonthOrdinalParse:/\d{1,2}º/,ordinal:"%dº",week:{dow:1,doy:4}})}(n(95093))},88383:function(e,t,n){!function(e){"use strict";e.defineLocale("it",{months:"gennaio_febbraio_marzo_aprile_maggio_giugno_luglio_agosto_settembre_ottobre_novembre_dicembre".split("_"),monthsShort:"gen_feb_mar_apr_mag_giu_lug_ago_set_ott_nov_dic".split("_"),weekdays:"domenica_lunedì_martedì_mercoledì_giovedì_venerdì_sabato".split("_"),weekdaysShort:"dom_lun_mar_mer_gio_ven_sab".split("_"),weekdaysMin:"do_lu_ma_me_gi_ve_sa".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},calendar:{sameDay:function(){return"[Oggi a"+(this.hours()>1?"lle ":0===this.hours()?" ":"ll'")+"]LT"},nextDay:function(){return"[Domani a"+(this.hours()>1?"lle ":0===this.hours()?" ":"ll'")+"]LT"},nextWeek:function(){return"dddd [a"+(this.hours()>1?"lle ":0===this.hours()?" ":"ll'")+"]LT"},lastDay:function(){return"[Ieri a"+(this.hours()>1?"lle ":0===this.hours()?" ":"ll'")+"]LT"},lastWeek:function(){return 0===this.day()?"[La scorsa] dddd [a"+(this.hours()>1?"lle ":0===this.hours()?" ":"ll'")+"]LT":"[Lo scorso] dddd [a"+(this.hours()>1?"lle ":0===this.hours()?" ":"ll'")+"]LT"},sameElse:"L"},relativeTime:{future:"tra %s",past:"%s fa",s:"alcuni secondi",ss:"%d secondi",m:"un minuto",mm:"%d minuti",h:"un'ora",hh:"%d ore",d:"un giorno",dd:"%d giorni",w:"una settimana",ww:"%d settimane",M:"un mese",MM:"%d mesi",y:"un anno",yy:"%d anni"},dayOfMonthOrdinalParse:/\d{1,2}º/,ordinal:"%dº",week:{dow:1,doy:4}})}(n(95093))},23827:function(e,t,n){!function(e){"use strict";e.defineLocale("ja",{eras:[{since:"2019-05-01",offset:1,name:"令和",narrow:"㋿",abbr:"R"},{since:"1989-01-08",until:"2019-04-30",offset:1,name:"平成",narrow:"㍻",abbr:"H"},{since:"1926-12-25",until:"1989-01-07",offset:1,name:"昭和",narrow:"㍼",abbr:"S"},{since:"1912-07-30",until:"1926-12-24",offset:1,name:"大正",narrow:"㍽",abbr:"T"},{since:"1873-01-01",until:"1912-07-29",offset:6,name:"明治",narrow:"㍾",abbr:"M"},{since:"0001-01-01",until:"1873-12-31",offset:1,name:"西暦",narrow:"AD",abbr:"AD"},{since:"0000-12-31",until:-1/0,offset:1,name:"紀元前",narrow:"BC",abbr:"BC"}],eraYearOrdinalRegex:/(元|\d+)年/,eraYearOrdinalParse:function(e,t){return"元"===t[1]?1:parseInt(t[1]||e,10)},months:"1月_2月_3月_4月_5月_6月_7月_8月_9月_10月_11月_12月".split("_"),monthsShort:"1月_2月_3月_4月_5月_6月_7月_8月_9月_10月_11月_12月".split("_"),weekdays:"日曜日_月曜日_火曜日_水曜日_木曜日_金曜日_土曜日".split("_"),weekdaysShort:"日_月_火_水_木_金_土".split("_"),weekdaysMin:"日_月_火_水_木_金_土".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"YYYY/MM/DD",LL:"YYYY年M月D日",LLL:"YYYY年M月D日 HH:mm",LLLL:"YYYY年M月D日 dddd HH:mm",l:"YYYY/MM/DD",ll:"YYYY年M月D日",lll:"YYYY年M月D日 HH:mm",llll:"YYYY年M月D日(ddd) HH:mm"},meridiemParse:/午前|午後/i,isPM:function(e){return"午後"===e},meridiem:function(e,t,n){return e<12?"午前":"午後"},calendar:{sameDay:"[今日] LT",nextDay:"[明日] LT",nextWeek:function(e){return e.week()!==this.week()?"[来週]dddd LT":"dddd LT"},lastDay:"[昨日] LT",lastWeek:function(e){return this.week()!==e.week()?"[先週]dddd LT":"dddd LT"},sameElse:"L"},dayOfMonthOrdinalParse:/\d{1,2}日/,ordinal:function(e,t){switch(t){case"y":return 1===e?"元年":e+"年";case"d":case"D":case"DDD":return e+"日";default:return e}},relativeTime:{future:"%s後",past:"%s前",s:"数秒",ss:"%d秒",m:"1分",mm:"%d分",h:"1時間",hh:"%d時間",d:"1日",dd:"%d日",M:"1ヶ月",MM:"%dヶ月",y:"1年",yy:"%d年"}})}(n(95093))},89722:function(e,t,n){!function(e){"use strict";e.defineLocale("jv",{months:"Januari_Februari_Maret_April_Mei_Juni_Juli_Agustus_September_Oktober_Nopember_Desember".split("_"),monthsShort:"Jan_Feb_Mar_Apr_Mei_Jun_Jul_Ags_Sep_Okt_Nop_Des".split("_"),weekdays:"Minggu_Senen_Seloso_Rebu_Kemis_Jemuwah_Septu".split("_"),weekdaysShort:"Min_Sen_Sel_Reb_Kem_Jem_Sep".split("_"),weekdaysMin:"Mg_Sn_Sl_Rb_Km_Jm_Sp".split("_"),longDateFormat:{LT:"HH.mm",LTS:"HH.mm.ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY [pukul] HH.mm",LLLL:"dddd, D MMMM YYYY [pukul] HH.mm"},meridiemParse:/enjing|siyang|sonten|ndalu/,meridiemHour:function(e,t){return 12===e&&(e=0),"enjing"===t?e:"siyang"===t?e>=11?e:e+12:"sonten"===t||"ndalu"===t?e+12:void 0},meridiem:function(e,t,n){return e<11?"enjing":e<15?"siyang":e<19?"sonten":"ndalu"},calendar:{sameDay:"[Dinten puniko pukul] LT",nextDay:"[Mbenjang pukul] LT",nextWeek:"dddd [pukul] LT",lastDay:"[Kala wingi pukul] LT",lastWeek:"dddd [kepengker pukul] LT",sameElse:"L"},relativeTime:{future:"wonten ing %s",past:"%s ingkang kepengker",s:"sawetawis detik",ss:"%d detik",m:"setunggal menit",mm:"%d menit",h:"setunggal jam",hh:"%d jam",d:"sedinten",dd:"%d dinten",M:"sewulan",MM:"%d wulan",y:"setaun",yy:"%d taun"},week:{dow:1,doy:7}})}(n(95093))},41794:function(e,t,n){!function(e){"use strict";e.defineLocale("ka",{months:"იანვარი_თებერვალი_მარტი_აპრილი_მაისი_ივნისი_ივლისი_აგვისტო_სექტემბერი_ოქტომბერი_ნოემბერი_დეკემბერი".split("_"),monthsShort:"იან_თებ_მარ_აპრ_მაი_ივნ_ივლ_აგვ_სექ_ოქტ_ნოე_დეკ".split("_"),weekdays:{standalone:"კვირა_ორშაბათი_სამშაბათი_ოთხშაბათი_ხუთშაბათი_პარასკევი_შაბათი".split("_"),format:"კვირას_ორშაბათს_სამშაბათს_ოთხშაბათს_ხუთშაბათს_პარასკევს_შაბათს".split("_"),isFormat:/(წინა|შემდეგ)/},weekdaysShort:"კვი_ორშ_სამ_ოთხ_ხუთ_პარ_შაბ".split("_"),weekdaysMin:"კვ_ორ_სა_ოთ_ხუ_პა_შა".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[დღეს] LT[-ზე]",nextDay:"[ხვალ] LT[-ზე]",lastDay:"[გუშინ] LT[-ზე]",nextWeek:"[შემდეგ] dddd LT[-ზე]",lastWeek:"[წინა] dddd LT-ზე",sameElse:"L"},relativeTime:{future:function(e){return e.replace(/(წამ|წუთ|საათ|წელ|დღ|თვ)(ი|ე)/,(function(e,t,n){return"ი"===n?t+"ში":t+n+"ში"}))},past:function(e){return/(წამი|წუთი|საათი|დღე|თვე)/.test(e)?e.replace(/(ი|ე)$/,"ის წინ"):/წელი/.test(e)?e.replace(/წელი$/,"წლის წინ"):e},s:"რამდენიმე წამი",ss:"%d წამი",m:"წუთი",mm:"%d წუთი",h:"საათი",hh:"%d საათი",d:"დღე",dd:"%d დღე",M:"თვე",MM:"%d თვე",y:"წელი",yy:"%d წელი"},dayOfMonthOrdinalParse:/0|1-ლი|მე-\d{1,2}|\d{1,2}-ე/,ordinal:function(e){return 0===e?e:1===e?e+"-ლი":e<20||e<=100&&e%20==0||e%100==0?"მე-"+e:e+"-ე"},week:{dow:1,doy:7}})}(n(95093))},27088:function(e,t,n){!function(e){"use strict";var t={0:"-ші",1:"-ші",2:"-ші",3:"-ші",4:"-ші",5:"-ші",6:"-шы",7:"-ші",8:"-ші",9:"-шы",10:"-шы",20:"-шы",30:"-шы",40:"-шы",50:"-ші",60:"-шы",70:"-ші",80:"-ші",90:"-шы",100:"-ші"};e.defineLocale("kk",{months:"қаңтар_ақпан_наурыз_сәуір_мамыр_маусым_шілде_тамыз_қыркүйек_қазан_қараша_желтоқсан".split("_"),monthsShort:"қаң_ақп_нау_сәу_мам_мау_шіл_там_қыр_қаз_қар_жел".split("_"),weekdays:"жексенбі_дүйсенбі_сейсенбі_сәрсенбі_бейсенбі_жұма_сенбі".split("_"),weekdaysShort:"жек_дүй_сей_сәр_бей_жұм_сен".split("_"),weekdaysMin:"жк_дй_сй_ср_бй_жм_сн".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[Бүгін сағат] LT",nextDay:"[Ертең сағат] LT",nextWeek:"dddd [сағат] LT",lastDay:"[Кеше сағат] LT",lastWeek:"[Өткен аптаның] dddd [сағат] LT",sameElse:"L"},relativeTime:{future:"%s ішінде",past:"%s бұрын",s:"бірнеше секунд",ss:"%d секунд",m:"бір минут",mm:"%d минут",h:"бір сағат",hh:"%d сағат",d:"бір күн",dd:"%d күн",M:"бір ай",MM:"%d ай",y:"бір жыл",yy:"%d жыл"},dayOfMonthOrdinalParse:/\d{1,2}-(ші|шы)/,ordinal:function(e){var n=e%10,r=e>=100?100:null;return e+(t[e]||t[n]||t[r])},week:{dow:1,doy:7}})}(n(95093))},96870:function(e,t,n){!function(e){"use strict";var t={1:"១",2:"២",3:"៣",4:"៤",5:"៥",6:"៦",7:"៧",8:"៨",9:"៩",0:"០"},n={"១":"1","២":"2","៣":"3","៤":"4","៥":"5","៦":"6","៧":"7","៨":"8","៩":"9","០":"0"};e.defineLocale("km",{months:"មករា_កុម្ភៈ_មីនា_មេសា_ឧសភា_មិថុនា_កក្កដា_សីហា_កញ្ញា_តុលា_វិច្ឆិកា_ធ្នូ".split("_"),monthsShort:"មករា_កុម្ភៈ_មីនា_មេសា_ឧសភា_មិថុនា_កក្កដា_សីហា_កញ្ញា_តុលា_វិច្ឆិកា_ធ្នូ".split("_"),weekdays:"អាទិត្យ_ច័ន្ទ_អង្គារ_ពុធ_ព្រហស្បតិ៍_សុក្រ_សៅរ៍".split("_"),weekdaysShort:"អា_ច_អ_ព_ព្រ_សុ_ស".split("_"),weekdaysMin:"អា_ច_អ_ព_ព្រ_សុ_ស".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},meridiemParse:/ព្រឹក|ល្ងាច/,isPM:function(e){return"ល្ងាច"===e},meridiem:function(e,t,n){return e<12?"ព្រឹក":"ល្ងាច"},calendar:{sameDay:"[ថ្ងៃនេះ ម៉ោង] LT",nextDay:"[ស្អែក ម៉ោង] LT",nextWeek:"dddd [ម៉ោង] LT",lastDay:"[ម្សិលមិញ ម៉ោង] LT",lastWeek:"dddd [សប្តាហ៍មុន] [ម៉ោង] LT",sameElse:"L"},relativeTime:{future:"%sទៀត",past:"%sមុន",s:"ប៉ុន្មានវិនាទី",ss:"%d វិនាទី",m:"មួយនាទី",mm:"%d នាទី",h:"មួយម៉ោង",hh:"%d ម៉ោង",d:"មួយថ្ងៃ",dd:"%d ថ្ងៃ",M:"មួយខែ",MM:"%d ខែ",y:"មួយឆ្នាំ",yy:"%d ឆ្នាំ"},dayOfMonthOrdinalParse:/ទី\d{1,2}/,ordinal:"ទី%d",preparse:function(e){return e.replace(/[១២៣៤៥៦៧៨៩០]/g,(function(e){return n[e]}))},postformat:function(e){return e.replace(/\d/g,(function(e){return t[e]}))},week:{dow:1,doy:4}})}(n(95093))},84451:function(e,t,n){!function(e){"use strict";var t={1:"೧",2:"೨",3:"೩",4:"೪",5:"೫",6:"೬",7:"೭",8:"೮",9:"೯",0:"೦"},n={"೧":"1","೨":"2","೩":"3","೪":"4","೫":"5","೬":"6","೭":"7","೮":"8","೯":"9","೦":"0"};e.defineLocale("kn",{months:"ಜನವರಿ_ಫೆಬ್ರವರಿ_ಮಾರ್ಚ್_ಏಪ್ರಿಲ್_ಮೇ_ಜೂನ್_ಜುಲೈ_ಆಗಸ್ಟ್_ಸೆಪ್ಟೆಂಬರ್_ಅಕ್ಟೋಬರ್_ನವೆಂಬರ್_ಡಿಸೆಂಬರ್".split("_"),monthsShort:"ಜನ_ಫೆಬ್ರ_ಮಾರ್ಚ್_ಏಪ್ರಿಲ್_ಮೇ_ಜೂನ್_ಜುಲೈ_ಆಗಸ್ಟ್_ಸೆಪ್ಟೆಂ_ಅಕ್ಟೋ_ನವೆಂ_ಡಿಸೆಂ".split("_"),monthsParseExact:!0,weekdays:"ಭಾನುವಾರ_ಸೋಮವಾರ_ಮಂಗಳವಾರ_ಬುಧವಾರ_ಗುರುವಾರ_ಶುಕ್ರವಾರ_ಶನಿವಾರ".split("_"),weekdaysShort:"ಭಾನು_ಸೋಮ_ಮಂಗಳ_ಬುಧ_ಗುರು_ಶುಕ್ರ_ಶನಿ".split("_"),weekdaysMin:"ಭಾ_ಸೋ_ಮಂ_ಬು_ಗು_ಶು_ಶ".split("_"),longDateFormat:{LT:"A h:mm",LTS:"A h:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY, A h:mm",LLLL:"dddd, D MMMM YYYY, A h:mm"},calendar:{sameDay:"[ಇಂದು] LT",nextDay:"[ನಾಳೆ] LT",nextWeek:"dddd, LT",lastDay:"[ನಿನ್ನೆ] LT",lastWeek:"[ಕೊನೆಯ] dddd, LT",sameElse:"L"},relativeTime:{future:"%s ನಂತರ",past:"%s ಹಿಂದೆ",s:"ಕೆಲವು ಕ್ಷಣಗಳು",ss:"%d ಸೆಕೆಂಡುಗಳು",m:"ಒಂದು ನಿಮಿಷ",mm:"%d ನಿಮಿಷ",h:"ಒಂದು ಗಂಟೆ",hh:"%d ಗಂಟೆ",d:"ಒಂದು ದಿನ",dd:"%d ದಿನ",M:"ಒಂದು ತಿಂಗಳು",MM:"%d ತಿಂಗಳು",y:"ಒಂದು ವರ್ಷ",yy:"%d ವರ್ಷ"},preparse:function(e){return e.replace(/[೧೨೩೪೫೬೭೮೯೦]/g,(function(e){return n[e]}))},postformat:function(e){return e.replace(/\d/g,(function(e){return t[e]}))},meridiemParse:/ರಾತ್ರಿ|ಬೆಳಿಗ್ಗೆ|ಮಧ್ಯಾಹ್ನ|ಸಂಜೆ/,meridiemHour:function(e,t){return 12===e&&(e=0),"ರಾತ್ರಿ"===t?e<4?e:e+12:"ಬೆಳಿಗ್ಗೆ"===t?e:"ಮಧ್ಯಾಹ್ನ"===t?e>=10?e:e+12:"ಸಂಜೆ"===t?e+12:void 0},meridiem:function(e,t,n){return e<4?"ರಾತ್ರಿ":e<10?"ಬೆಳಿಗ್ಗೆ":e<17?"ಮಧ್ಯಾಹ್ನ":e<20?"ಸಂಜೆ":"ರಾತ್ರಿ"},dayOfMonthOrdinalParse:/\d{1,2}(ನೇ)/,ordinal:function(e){return e+"ನೇ"},week:{dow:0,doy:6}})}(n(95093))},63164:function(e,t,n){!function(e){"use strict";e.defineLocale("ko",{months:"1월_2월_3월_4월_5월_6월_7월_8월_9월_10월_11월_12월".split("_"),monthsShort:"1월_2월_3월_4월_5월_6월_7월_8월_9월_10월_11월_12월".split("_"),weekdays:"일요일_월요일_화요일_수요일_목요일_금요일_토요일".split("_"),weekdaysShort:"일_월_화_수_목_금_토".split("_"),weekdaysMin:"일_월_화_수_목_금_토".split("_"),longDateFormat:{LT:"A h:mm",LTS:"A h:mm:ss",L:"YYYY.MM.DD.",LL:"YYYY년 MMMM D일",LLL:"YYYY년 MMMM D일 A h:mm",LLLL:"YYYY년 MMMM D일 dddd A h:mm",l:"YYYY.MM.DD.",ll:"YYYY년 MMMM D일",lll:"YYYY년 MMMM D일 A h:mm",llll:"YYYY년 MMMM D일 dddd A h:mm"},calendar:{sameDay:"오늘 LT",nextDay:"내일 LT",nextWeek:"dddd LT",lastDay:"어제 LT",lastWeek:"지난주 dddd LT",sameElse:"L"},relativeTime:{future:"%s 후",past:"%s 전",s:"몇 초",ss:"%d초",m:"1분",mm:"%d분",h:"한 시간",hh:"%d시간",d:"하루",dd:"%d일",M:"한 달",MM:"%d달",y:"일 년",yy:"%d년"},dayOfMonthOrdinalParse:/\d{1,2}(일|월|주)/,ordinal:function(e,t){switch(t){case"d":case"D":case"DDD":return e+"일";case"M":return e+"월";case"w":case"W":return e+"주";default:return e}},meridiemParse:/오전|오후/,isPM:function(e){return"오후"===e},meridiem:function(e,t,n){return e<12?"오전":"오후"}})}(n(95093))},6181:function(e,t,n){!function(e){"use strict";function t(e,t,n,r){var a={s:["çend sanîye","çend sanîyeyan"],ss:[e+" sanîye",e+" sanîyeyan"],m:["deqîqeyek","deqîqeyekê"],mm:[e+" deqîqe",e+" deqîqeyan"],h:["saetek","saetekê"],hh:[e+" saet",e+" saetan"],d:["rojek","rojekê"],dd:[e+" roj",e+" rojan"],w:["hefteyek","hefteyekê"],ww:[e+" hefte",e+" hefteyan"],M:["mehek","mehekê"],MM:[e+" meh",e+" mehan"],y:["salek","salekê"],yy:[e+" sal",e+" salan"]};return t?a[n][0]:a[n][1]}function n(e){var t=(e=""+e).substring(e.length-1),n=e.length>1?e.substring(e.length-2):"";return 12==n||13==n||"2"!=t&&"3"!=t&&"50"!=n&&"70"!=t&&"80"!=t?"ê":"yê"}e.defineLocale("ku-kmr",{months:"Rêbendan_Sibat_Adar_Nîsan_Gulan_Hezîran_Tîrmeh_Tebax_Îlon_Cotmeh_Mijdar_Berfanbar".split("_"),monthsShort:"Rêb_Sib_Ada_Nîs_Gul_Hez_Tîr_Teb_Îlo_Cot_Mij_Ber".split("_"),monthsParseExact:!0,weekdays:"Yekşem_Duşem_Sêşem_Çarşem_Pêncşem_În_Şemî".split("_"),weekdaysShort:"Yek_Du_Sê_Çar_Pên_În_Şem".split("_"),weekdaysMin:"Ye_Du_Sê_Ça_Pê_În_Şe".split("_"),meridiem:function(e,t,n){return e<12?n?"bn":"BN":n?"pn":"PN"},meridiemParse:/bn|BN|pn|PN/,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"Do MMMM[a] YYYY[an]",LLL:"Do MMMM[a] YYYY[an] HH:mm",LLLL:"dddd, Do MMMM[a] YYYY[an] HH:mm",ll:"Do MMM[.] YYYY[an]",lll:"Do MMM[.] YYYY[an] HH:mm",llll:"ddd[.], Do MMM[.] YYYY[an] HH:mm"},calendar:{sameDay:"[Îro di saet] LT [de]",nextDay:"[Sibê di saet] LT [de]",nextWeek:"dddd [di saet] LT [de]",lastDay:"[Duh di saet] LT [de]",lastWeek:"dddd[a borî di saet] LT [de]",sameElse:"L"},relativeTime:{future:"di %s de",past:"berî %s",s:t,ss:t,m:t,mm:t,h:t,hh:t,d:t,dd:t,w:t,ww:t,M:t,MM:t,y:t,yy:t},dayOfMonthOrdinalParse:/\d{1,2}(?:yê|ê|\.)/,ordinal:function(e,t){var r=t.toLowerCase();return r.includes("w")||r.includes("m")?e+".":e+n(e)},week:{dow:1,doy:4}})}(n(95093))},98174:function(e,t,n){!function(e){"use strict";var t={1:"١",2:"٢",3:"٣",4:"٤",5:"٥",6:"٦",7:"٧",8:"٨",9:"٩",0:"٠"},n={"١":"1","٢":"2","٣":"3","٤":"4","٥":"5","٦":"6","٧":"7","٨":"8","٩":"9","٠":"0"},r=["کانونی دووەم","شوبات","ئازار","نیسان","ئایار","حوزەیران","تەمموز","ئاب","ئەیلوول","تشرینی یەكەم","تشرینی دووەم","كانونی یەکەم"];e.defineLocale("ku",{months:r,monthsShort:r,weekdays:"یه‌كشه‌ممه‌_دووشه‌ممه‌_سێشه‌ممه‌_چوارشه‌ممه‌_پێنجشه‌ممه‌_هه‌ینی_شه‌ممه‌".split("_"),weekdaysShort:"یه‌كشه‌م_دووشه‌م_سێشه‌م_چوارشه‌م_پێنجشه‌م_هه‌ینی_شه‌ممه‌".split("_"),weekdaysMin:"ی_د_س_چ_پ_ه_ش".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},meridiemParse:/ئێواره‌|به‌یانی/,isPM:function(e){return/ئێواره‌/.test(e)},meridiem:function(e,t,n){return e<12?"به‌یانی":"ئێواره‌"},calendar:{sameDay:"[ئه‌مرۆ كاتژمێر] LT",nextDay:"[به‌یانی كاتژمێر] LT",nextWeek:"dddd [كاتژمێر] LT",lastDay:"[دوێنێ كاتژمێر] LT",lastWeek:"dddd [كاتژمێر] LT",sameElse:"L"},relativeTime:{future:"له‌ %s",past:"%s",s:"چه‌ند چركه‌یه‌ك",ss:"چركه‌ %d",m:"یه‌ك خوله‌ك",mm:"%d خوله‌ك",h:"یه‌ك كاتژمێر",hh:"%d كاتژمێر",d:"یه‌ك ڕۆژ",dd:"%d ڕۆژ",M:"یه‌ك مانگ",MM:"%d مانگ",y:"یه‌ك ساڵ",yy:"%d ساڵ"},preparse:function(e){return e.replace(/[١٢٣٤٥٦٧٨٩٠]/g,(function(e){return n[e]})).replace(/،/g,",")},postformat:function(e){return e.replace(/\d/g,(function(e){return t[e]})).replace(/,/g,"،")},week:{dow:6,doy:12}})}(n(95093))},78474:function(e,t,n){!function(e){"use strict";var t={0:"-чү",1:"-чи",2:"-чи",3:"-чү",4:"-чү",5:"-чи",6:"-чы",7:"-чи",8:"-чи",9:"-чу",10:"-чу",20:"-чы",30:"-чу",40:"-чы",50:"-чү",60:"-чы",70:"-чи",80:"-чи",90:"-чу",100:"-чү"};e.defineLocale("ky",{months:"январь_февраль_март_апрель_май_июнь_июль_август_сентябрь_октябрь_ноябрь_декабрь".split("_"),monthsShort:"янв_фев_март_апр_май_июнь_июль_авг_сен_окт_ноя_дек".split("_"),weekdays:"Жекшемби_Дүйшөмбү_Шейшемби_Шаршемби_Бейшемби_Жума_Ишемби".split("_"),weekdaysShort:"Жек_Дүй_Шей_Шар_Бей_Жум_Ише".split("_"),weekdaysMin:"Жк_Дй_Шй_Шр_Бй_Жм_Иш".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[Бүгүн саат] LT",nextDay:"[Эртең саат] LT",nextWeek:"dddd [саат] LT",lastDay:"[Кечээ саат] LT",lastWeek:"[Өткөн аптанын] dddd [күнү] [саат] LT",sameElse:"L"},relativeTime:{future:"%s ичинде",past:"%s мурун",s:"бирнече секунд",ss:"%d секунд",m:"бир мүнөт",mm:"%d мүнөт",h:"бир саат",hh:"%d саат",d:"бир күн",dd:"%d күн",M:"бир ай",MM:"%d ай",y:"бир жыл",yy:"%d жыл"},dayOfMonthOrdinalParse:/\d{1,2}-(чи|чы|чү|чу)/,ordinal:function(e){var n=e%10,r=e>=100?100:null;return e+(t[e]||t[n]||t[r])},week:{dow:1,doy:7}})}(n(95093))},79680:function(e,t,n){!function(e){"use strict";function t(e,t,n,r){var a={m:["eng Minutt","enger Minutt"],h:["eng Stonn","enger Stonn"],d:["een Dag","engem Dag"],M:["ee Mount","engem Mount"],y:["ee Joer","engem Joer"]};return t?a[n][0]:a[n][1]}function n(e){return a(e.substr(0,e.indexOf(" ")))?"a "+e:"an "+e}function r(e){return a(e.substr(0,e.indexOf(" ")))?"viru "+e:"virun "+e}function a(e){if(e=parseInt(e,10),isNaN(e))return!1;if(e<0)return!0;if(e<10)return 4<=e&&e<=7;if(e<100){var t=e%10;return a(0===t?e/10:t)}if(e<1e4){for(;e>=10;)e/=10;return a(e)}return a(e/=1e3)}e.defineLocale("lb",{months:"Januar_Februar_Mäerz_Abrëll_Mee_Juni_Juli_August_September_Oktober_November_Dezember".split("_"),monthsShort:"Jan._Febr._Mrz._Abr._Mee_Jun._Jul._Aug._Sept._Okt._Nov._Dez.".split("_"),monthsParseExact:!0,weekdays:"Sonndeg_Méindeg_Dënschdeg_Mëttwoch_Donneschdeg_Freideg_Samschdeg".split("_"),weekdaysShort:"So._Mé._Dë._Më._Do._Fr._Sa.".split("_"),weekdaysMin:"So_Mé_Dë_Më_Do_Fr_Sa".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"H:mm [Auer]",LTS:"H:mm:ss [Auer]",L:"DD.MM.YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY H:mm [Auer]",LLLL:"dddd, D. MMMM YYYY H:mm [Auer]"},calendar:{sameDay:"[Haut um] LT",sameElse:"L",nextDay:"[Muer um] LT",nextWeek:"dddd [um] LT",lastDay:"[Gëschter um] LT",lastWeek:function(){switch(this.day()){case 2:case 4:return"[Leschten] dddd [um] LT";default:return"[Leschte] dddd [um] LT"}}},relativeTime:{future:n,past:r,s:"e puer Sekonnen",ss:"%d Sekonnen",m:t,mm:"%d Minutten",h:t,hh:"%d Stonnen",d:t,dd:"%d Deeg",M:t,MM:"%d Méint",y:t,yy:"%d Joer"},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:4}})}(n(95093))},15867:function(e,t,n){!function(e){"use strict";e.defineLocale("lo",{months:"ມັງກອນ_ກຸມພາ_ມີນາ_ເມສາ_ພຶດສະພາ_ມິຖຸນາ_ກໍລະກົດ_ສິງຫາ_ກັນຍາ_ຕຸລາ_ພະຈິກ_ທັນວາ".split("_"),monthsShort:"ມັງກອນ_ກຸມພາ_ມີນາ_ເມສາ_ພຶດສະພາ_ມິຖຸນາ_ກໍລະກົດ_ສິງຫາ_ກັນຍາ_ຕຸລາ_ພະຈິກ_ທັນວາ".split("_"),weekdays:"ອາທິດ_ຈັນ_ອັງຄານ_ພຸດ_ພະຫັດ_ສຸກ_ເສົາ".split("_"),weekdaysShort:"ທິດ_ຈັນ_ອັງຄານ_ພຸດ_ພະຫັດ_ສຸກ_ເສົາ".split("_"),weekdaysMin:"ທ_ຈ_ອຄ_ພ_ພຫ_ສກ_ສ".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"ວັນdddd D MMMM YYYY HH:mm"},meridiemParse:/ຕອນເຊົ້າ|ຕອນແລງ/,isPM:function(e){return"ຕອນແລງ"===e},meridiem:function(e,t,n){return e<12?"ຕອນເຊົ້າ":"ຕອນແລງ"},calendar:{sameDay:"[ມື້ນີ້ເວລາ] LT",nextDay:"[ມື້ອື່ນເວລາ] LT",nextWeek:"[ວັນ]dddd[ໜ້າເວລາ] LT",lastDay:"[ມື້ວານນີ້ເວລາ] LT",lastWeek:"[ວັນ]dddd[ແລ້ວນີ້ເວລາ] LT",sameElse:"L"},relativeTime:{future:"ອີກ %s",past:"%sຜ່ານມາ",s:"ບໍ່ເທົ່າໃດວິນາທີ",ss:"%d ວິນາທີ",m:"1 ນາທີ",mm:"%d ນາທີ",h:"1 ຊົ່ວໂມງ",hh:"%d ຊົ່ວໂມງ",d:"1 ມື້",dd:"%d ມື້",M:"1 ເດືອນ",MM:"%d ເດືອນ",y:"1 ປີ",yy:"%d ປີ"},dayOfMonthOrdinalParse:/(ທີ່)\d{1,2}/,ordinal:function(e){return"ທີ່"+e}})}(n(95093))},45766:function(e,t,n){!function(e){"use strict";var t={ss:"sekundė_sekundžių_sekundes",m:"minutė_minutės_minutę",mm:"minutės_minučių_minutes",h:"valanda_valandos_valandą",hh:"valandos_valandų_valandas",d:"diena_dienos_dieną",dd:"dienos_dienų_dienas",M:"mėnuo_mėnesio_mėnesį",MM:"mėnesiai_mėnesių_mėnesius",y:"metai_metų_metus",yy:"metai_metų_metus"};function n(e,t,n,r){return t?"kelios sekundės":r?"kelių sekundžių":"kelias sekundes"}function r(e,t,n,r){return t?s(n)[0]:r?s(n)[1]:s(n)[2]}function a(e){return e%10==0||e>10&&e<20}function s(e){return t[e].split("_")}function i(e,t,n,i){var o=e+" ";return 1===e?o+r(e,t,n[0],i):t?o+(a(e)?s(n)[1]:s(n)[0]):i?o+s(n)[1]:o+(a(e)?s(n)[1]:s(n)[2])}e.defineLocale("lt",{months:{format:"sausio_vasario_kovo_balandžio_gegužės_birželio_liepos_rugpjūčio_rugsėjo_spalio_lapkričio_gruodžio".split("_"),standalone:"sausis_vasaris_kovas_balandis_gegužė_birželis_liepa_rugpjūtis_rugsėjis_spalis_lapkritis_gruodis".split("_"),isFormat:/D[oD]?(\[[^\[\]]*\]|\s)+MMMM?|MMMM?(\[[^\[\]]*\]|\s)+D[oD]?/},monthsShort:"sau_vas_kov_bal_geg_bir_lie_rgp_rgs_spa_lap_grd".split("_"),weekdays:{format:"sekmadienį_pirmadienį_antradienį_trečiadienį_ketvirtadienį_penktadienį_šeštadienį".split("_"),standalone:"sekmadienis_pirmadienis_antradienis_trečiadienis_ketvirtadienis_penktadienis_šeštadienis".split("_"),isFormat:/dddd HH:mm/},weekdaysShort:"Sek_Pir_Ant_Tre_Ket_Pen_Šeš".split("_"),weekdaysMin:"S_P_A_T_K_Pn_Š".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"YYYY-MM-DD",LL:"YYYY [m.] MMMM D [d.]",LLL:"YYYY [m.] MMMM D [d.], HH:mm [val.]",LLLL:"YYYY [m.] MMMM D [d.], dddd, HH:mm [val.]",l:"YYYY-MM-DD",ll:"YYYY [m.] MMMM D [d.]",lll:"YYYY [m.] MMMM D [d.], HH:mm [val.]",llll:"YYYY [m.] MMMM D [d.], ddd, HH:mm [val.]"},calendar:{sameDay:"[Šiandien] LT",nextDay:"[Rytoj] LT",nextWeek:"dddd LT",lastDay:"[Vakar] LT",lastWeek:"[Praėjusį] dddd LT",sameElse:"L"},relativeTime:{future:"po %s",past:"prieš %s",s:n,ss:i,m:r,mm:i,h:r,hh:i,d:r,dd:i,M:r,MM:i,y:r,yy:i},dayOfMonthOrdinalParse:/\d{1,2}-oji/,ordinal:function(e){return e+"-oji"},week:{dow:1,doy:4}})}(n(95093))},69532:function(e,t,n){!function(e){"use strict";var t={ss:"sekundes_sekundēm_sekunde_sekundes".split("_"),m:"minūtes_minūtēm_minūte_minūtes".split("_"),mm:"minūtes_minūtēm_minūte_minūtes".split("_"),h:"stundas_stundām_stunda_stundas".split("_"),hh:"stundas_stundām_stunda_stundas".split("_"),d:"dienas_dienām_diena_dienas".split("_"),dd:"dienas_dienām_diena_dienas".split("_"),M:"mēneša_mēnešiem_mēnesis_mēneši".split("_"),MM:"mēneša_mēnešiem_mēnesis_mēneši".split("_"),y:"gada_gadiem_gads_gadi".split("_"),yy:"gada_gadiem_gads_gadi".split("_")};function n(e,t,n){return n?t%10==1&&t%100!=11?e[2]:e[3]:t%10==1&&t%100!=11?e[0]:e[1]}function r(e,r,a){return e+" "+n(t[a],e,r)}function a(e,r,a){return n(t[a],e,r)}function s(e,t){return t?"dažas sekundes":"dažām sekundēm"}e.defineLocale("lv",{months:"janvāris_februāris_marts_aprīlis_maijs_jūnijs_jūlijs_augusts_septembris_oktobris_novembris_decembris".split("_"),monthsShort:"jan_feb_mar_apr_mai_jūn_jūl_aug_sep_okt_nov_dec".split("_"),weekdays:"svētdiena_pirmdiena_otrdiena_trešdiena_ceturtdiena_piektdiena_sestdiena".split("_"),weekdaysShort:"Sv_P_O_T_C_Pk_S".split("_"),weekdaysMin:"Sv_P_O_T_C_Pk_S".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY.",LL:"YYYY. [gada] D. MMMM",LLL:"YYYY. [gada] D. MMMM, HH:mm",LLLL:"YYYY. [gada] D. MMMM, dddd, HH:mm"},calendar:{sameDay:"[Šodien pulksten] LT",nextDay:"[Rīt pulksten] LT",nextWeek:"dddd [pulksten] LT",lastDay:"[Vakar pulksten] LT",lastWeek:"[Pagājušā] dddd [pulksten] LT",sameElse:"L"},relativeTime:{future:"pēc %s",past:"pirms %s",s,ss:r,m:a,mm:r,h:a,hh:r,d:a,dd:r,M:a,MM:r,y:a,yy:r},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:4}})}(n(95093))},58076:function(e,t,n){!function(e){"use strict";var t={words:{ss:["sekund","sekunda","sekundi"],m:["jedan minut","jednog minuta"],mm:["minut","minuta","minuta"],h:["jedan sat","jednog sata"],hh:["sat","sata","sati"],dd:["dan","dana","dana"],MM:["mjesec","mjeseca","mjeseci"],yy:["godina","godine","godina"]},correctGrammaticalCase:function(e,t){return 1===e?t[0]:e>=2&&e<=4?t[1]:t[2]},translate:function(e,n,r){var a=t.words[r];return 1===r.length?n?a[0]:a[1]:e+" "+t.correctGrammaticalCase(e,a)}};e.defineLocale("me",{months:"januar_februar_mart_april_maj_jun_jul_avgust_septembar_oktobar_novembar_decembar".split("_"),monthsShort:"jan._feb._mar._apr._maj_jun_jul_avg._sep._okt._nov._dec.".split("_"),monthsParseExact:!0,weekdays:"nedjelja_ponedjeljak_utorak_srijeda_četvrtak_petak_subota".split("_"),weekdaysShort:"ned._pon._uto._sri._čet._pet._sub.".split("_"),weekdaysMin:"ne_po_ut_sr_če_pe_su".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD.MM.YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY H:mm",LLLL:"dddd, D. MMMM YYYY H:mm"},calendar:{sameDay:"[danas u] LT",nextDay:"[sjutra u] LT",nextWeek:function(){switch(this.day()){case 0:return"[u] [nedjelju] [u] LT";case 3:return"[u] [srijedu] [u] LT";case 6:return"[u] [subotu] [u] LT";case 1:case 2:case 4:case 5:return"[u] dddd [u] LT"}},lastDay:"[juče u] LT",lastWeek:function(){return["[prošle] [nedjelje] [u] LT","[prošlog] [ponedjeljka] [u] LT","[prošlog] [utorka] [u] LT","[prošle] [srijede] [u] LT","[prošlog] [četvrtka] [u] LT","[prošlog] [petka] [u] LT","[prošle] [subote] [u] LT"][this.day()]},sameElse:"L"},relativeTime:{future:"za %s",past:"prije %s",s:"nekoliko sekundi",ss:t.translate,m:t.translate,mm:t.translate,h:t.translate,hh:t.translate,d:"dan",dd:t.translate,M:"mjesec",MM:t.translate,y:"godinu",yy:t.translate},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:7}})}(n(95093))},41848:function(e,t,n){!function(e){"use strict";e.defineLocale("mi",{months:"Kohi-tāte_Hui-tanguru_Poutū-te-rangi_Paenga-whāwhā_Haratua_Pipiri_Hōngoingoi_Here-turi-kōkā_Mahuru_Whiringa-ā-nuku_Whiringa-ā-rangi_Hakihea".split("_"),monthsShort:"Kohi_Hui_Pou_Pae_Hara_Pipi_Hōngoi_Here_Mahu_Whi-nu_Whi-ra_Haki".split("_"),monthsRegex:/(?:['a-z\u0101\u014D\u016B]+\-?){1,3}/i,monthsStrictRegex:/(?:['a-z\u0101\u014D\u016B]+\-?){1,3}/i,monthsShortRegex:/(?:['a-z\u0101\u014D\u016B]+\-?){1,3}/i,monthsShortStrictRegex:/(?:['a-z\u0101\u014D\u016B]+\-?){1,2}/i,weekdays:"Rātapu_Mane_Tūrei_Wenerei_Tāite_Paraire_Hātarei".split("_"),weekdaysShort:"Ta_Ma_Tū_We_Tāi_Pa_Hā".split("_"),weekdaysMin:"Ta_Ma_Tū_We_Tāi_Pa_Hā".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY [i] HH:mm",LLLL:"dddd, D MMMM YYYY [i] HH:mm"},calendar:{sameDay:"[i teie mahana, i] LT",nextDay:"[apopo i] LT",nextWeek:"dddd [i] LT",lastDay:"[inanahi i] LT",lastWeek:"dddd [whakamutunga i] LT",sameElse:"L"},relativeTime:{future:"i roto i %s",past:"%s i mua",s:"te hēkona ruarua",ss:"%d hēkona",m:"he meneti",mm:"%d meneti",h:"te haora",hh:"%d haora",d:"he ra",dd:"%d ra",M:"he marama",MM:"%d marama",y:"he tau",yy:"%d tau"},dayOfMonthOrdinalParse:/\d{1,2}º/,ordinal:"%dº",week:{dow:1,doy:4}})}(n(95093))},30306:function(e,t,n){!function(e){"use strict";e.defineLocale("mk",{months:"јануари_февруари_март_април_мај_јуни_јули_август_септември_октомври_ноември_декември".split("_"),monthsShort:"јан_фев_мар_апр_мај_јун_јул_авг_сеп_окт_ное_дек".split("_"),weekdays:"недела_понеделник_вторник_среда_четврток_петок_сабота".split("_"),weekdaysShort:"нед_пон_вто_сре_чет_пет_саб".split("_"),weekdaysMin:"нe_пo_вт_ср_че_пе_сa".split("_"),longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"D.MM.YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY H:mm",LLLL:"dddd, D MMMM YYYY H:mm"},calendar:{sameDay:"[Денес во] LT",nextDay:"[Утре во] LT",nextWeek:"[Во] dddd [во] LT",lastDay:"[Вчера во] LT",lastWeek:function(){switch(this.day()){case 0:case 3:case 6:return"[Изминатата] dddd [во] LT";case 1:case 2:case 4:case 5:return"[Изминатиот] dddd [во] LT"}},sameElse:"L"},relativeTime:{future:"за %s",past:"пред %s",s:"неколку секунди",ss:"%d секунди",m:"една минута",mm:"%d минути",h:"еден час",hh:"%d часа",d:"еден ден",dd:"%d дена",M:"еден месец",MM:"%d месеци",y:"една година",yy:"%d години"},dayOfMonthOrdinalParse:/\d{1,2}-(ев|ен|ти|ви|ри|ми)/,ordinal:function(e){var t=e%10,n=e%100;return 0===e?e+"-ев":0===n?e+"-ен":n>10&&n<20?e+"-ти":1===t?e+"-ви":2===t?e+"-ри":7===t||8===t?e+"-ми":e+"-ти"},week:{dow:1,doy:7}})}(n(95093))},73739:function(e,t,n){!function(e){"use strict";e.defineLocale("ml",{months:"ജനുവരി_ഫെബ്രുവരി_മാർച്ച്_ഏപ്രിൽ_മേയ്_ജൂൺ_ജൂലൈ_ഓഗസ്റ്റ്_സെപ്റ്റംബർ_ഒക്ടോബർ_നവംബർ_ഡിസംബർ".split("_"),monthsShort:"ജനു._ഫെബ്രു._മാർ._ഏപ്രി._മേയ്_ജൂൺ_ജൂലൈ._ഓഗ._സെപ്റ്റ._ഒക്ടോ._നവം._ഡിസം.".split("_"),monthsParseExact:!0,weekdays:"ഞായറാഴ്ച_തിങ്കളാഴ്ച_ചൊവ്വാഴ്ച_ബുധനാഴ്ച_വ്യാഴാഴ്ച_വെള്ളിയാഴ്ച_ശനിയാഴ്ച".split("_"),weekdaysShort:"ഞായർ_തിങ്കൾ_ചൊവ്വ_ബുധൻ_വ്യാഴം_വെള്ളി_ശനി".split("_"),weekdaysMin:"ഞാ_തി_ചൊ_ബു_വ്യാ_വെ_ശ".split("_"),longDateFormat:{LT:"A h:mm -നു",LTS:"A h:mm:ss -നു",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY, A h:mm -നു",LLLL:"dddd, D MMMM YYYY, A h:mm -നു"},calendar:{sameDay:"[ഇന്ന്] LT",nextDay:"[നാളെ] LT",nextWeek:"dddd, LT",lastDay:"[ഇന്നലെ] LT",lastWeek:"[കഴിഞ്ഞ] dddd, LT",sameElse:"L"},relativeTime:{future:"%s കഴിഞ്ഞ്",past:"%s മുൻപ്",s:"അൽപ നിമിഷങ്ങൾ",ss:"%d സെക്കൻഡ്",m:"ഒരു മിനിറ്റ്",mm:"%d മിനിറ്റ്",h:"ഒരു മണിക്കൂർ",hh:"%d മണിക്കൂർ",d:"ഒരു ദിവസം",dd:"%d ദിവസം",M:"ഒരു മാസം",MM:"%d മാസം",y:"ഒരു വർഷം",yy:"%d വർഷം"},meridiemParse:/രാത്രി|രാവിലെ|ഉച്ച കഴിഞ്ഞ്|വൈകുന്നേരം|രാത്രി/i,meridiemHour:function(e,t){return 12===e&&(e=0),"രാത്രി"===t&&e>=4||"ഉച്ച കഴിഞ്ഞ്"===t||"വൈകുന്നേരം"===t?e+12:e},meridiem:function(e,t,n){return e<4?"രാത്രി":e<12?"രാവിലെ":e<17?"ഉച്ച കഴിഞ്ഞ്":e<20?"വൈകുന്നേരം":"രാത്രി"}})}(n(95093))},99053:function(e,t,n){!function(e){"use strict";function t(e,t,n,r){switch(n){case"s":return t?"хэдхэн секунд":"хэдхэн секундын";case"ss":return e+(t?" секунд":" секундын");case"m":case"mm":return e+(t?" минут":" минутын");case"h":case"hh":return e+(t?" цаг":" цагийн");case"d":case"dd":return e+(t?" өдөр":" өдрийн");case"M":case"MM":return e+(t?" сар":" сарын");case"y":case"yy":return e+(t?" жил":" жилийн");default:return e}}e.defineLocale("mn",{months:"Нэгдүгээр сар_Хоёрдугаар сар_Гуравдугаар сар_Дөрөвдүгээр сар_Тавдугаар сар_Зургадугаар сар_Долдугаар сар_Наймдугаар сар_Есдүгээр сар_Аравдугаар сар_Арван нэгдүгээр сар_Арван хоёрдугаар сар".split("_"),monthsShort:"1 сар_2 сар_3 сар_4 сар_5 сар_6 сар_7 сар_8 сар_9 сар_10 сар_11 сар_12 сар".split("_"),monthsParseExact:!0,weekdays:"Ням_Даваа_Мягмар_Лхагва_Пүрэв_Баасан_Бямба".split("_"),weekdaysShort:"Ням_Дав_Мяг_Лха_Пүр_Баа_Бям".split("_"),weekdaysMin:"Ня_Да_Мя_Лх_Пү_Ба_Бя".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"YYYY-MM-DD",LL:"YYYY оны MMMMын D",LLL:"YYYY оны MMMMын D HH:mm",LLLL:"dddd, YYYY оны MMMMын D HH:mm"},meridiemParse:/ҮӨ|ҮХ/i,isPM:function(e){return"ҮХ"===e},meridiem:function(e,t,n){return e<12?"ҮӨ":"ҮХ"},calendar:{sameDay:"[Өнөөдөр] LT",nextDay:"[Маргааш] LT",nextWeek:"[Ирэх] dddd LT",lastDay:"[Өчигдөр] LT",lastWeek:"[Өнгөрсөн] dddd LT",sameElse:"L"},relativeTime:{future:"%s дараа",past:"%s өмнө",s:t,ss:t,m:t,mm:t,h:t,hh:t,d:t,dd:t,M:t,MM:t,y:t,yy:t},dayOfMonthOrdinalParse:/\d{1,2} өдөр/,ordinal:function(e,t){switch(t){case"d":case"D":case"DDD":return e+" өдөр";default:return e}}})}(n(95093))},86169:function(e,t,n){!function(e){"use strict";var t={1:"१",2:"२",3:"३",4:"४",5:"५",6:"६",7:"७",8:"८",9:"९",0:"०"},n={"१":"1","२":"2","३":"3","४":"4","५":"5","६":"6","७":"7","८":"8","९":"9","०":"0"};function r(e,t,n,r){var a="";if(t)switch(n){case"s":a="काही सेकंद";break;case"ss":a="%d सेकंद";break;case"m":a="एक मिनिट";break;case"mm":a="%d मिनिटे";break;case"h":a="एक तास";break;case"hh":a="%d तास";break;case"d":a="एक दिवस";break;case"dd":a="%d दिवस";break;case"M":a="एक महिना";break;case"MM":a="%d महिने";break;case"y":a="एक वर्ष";break;case"yy":a="%d वर्षे"}else switch(n){case"s":a="काही सेकंदां";break;case"ss":a="%d सेकंदां";break;case"m":a="एका मिनिटा";break;case"mm":a="%d मिनिटां";break;case"h":a="एका तासा";break;case"hh":a="%d तासां";break;case"d":a="एका दिवसा";break;case"dd":a="%d दिवसां";break;case"M":a="एका महिन्या";break;case"MM":a="%d महिन्यां";break;case"y":a="एका वर्षा";break;case"yy":a="%d वर्षां"}return a.replace(/%d/i,e)}e.defineLocale("mr",{months:"जानेवारी_फेब्रुवारी_मार्च_एप्रिल_मे_जून_जुलै_ऑगस्ट_सप्टेंबर_ऑक्टोबर_नोव्हेंबर_डिसेंबर".split("_"),monthsShort:"जाने._फेब्रु._मार्च._एप्रि._मे._जून._जुलै._ऑग._सप्टें._ऑक्टो._नोव्हें._डिसें.".split("_"),monthsParseExact:!0,weekdays:"रविवार_सोमवार_मंगळवार_बुधवार_गुरूवार_शुक्रवार_शनिवार".split("_"),weekdaysShort:"रवि_सोम_मंगळ_बुध_गुरू_शुक्र_शनि".split("_"),weekdaysMin:"र_सो_मं_बु_गु_शु_श".split("_"),longDateFormat:{LT:"A h:mm वाजता",LTS:"A h:mm:ss वाजता",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY, A h:mm वाजता",LLLL:"dddd, D MMMM YYYY, A h:mm वाजता"},calendar:{sameDay:"[आज] LT",nextDay:"[उद्या] LT",nextWeek:"dddd, LT",lastDay:"[काल] LT",lastWeek:"[मागील] dddd, LT",sameElse:"L"},relativeTime:{future:"%sमध्ये",past:"%sपूर्वी",s:r,ss:r,m:r,mm:r,h:r,hh:r,d:r,dd:r,M:r,MM:r,y:r,yy:r},preparse:function(e){return e.replace(/[१२३४५६७८९०]/g,(function(e){return n[e]}))},postformat:function(e){return e.replace(/\d/g,(function(e){return t[e]}))},meridiemParse:/पहाटे|सकाळी|दुपारी|सायंकाळी|रात्री/,meridiemHour:function(e,t){return 12===e&&(e=0),"पहाटे"===t||"सकाळी"===t?e:"दुपारी"===t||"सायंकाळी"===t||"रात्री"===t?e>=12?e:e+12:void 0},meridiem:function(e,t,n){return e>=0&&e<6?"पहाटे":e<12?"सकाळी":e<17?"दुपारी":e<20?"सायंकाळी":"रात्री"},week:{dow:0,doy:6}})}(n(95093))},92297:function(e,t,n){!function(e){"use strict";e.defineLocale("ms-my",{months:"Januari_Februari_Mac_April_Mei_Jun_Julai_Ogos_September_Oktober_November_Disember".split("_"),monthsShort:"Jan_Feb_Mac_Apr_Mei_Jun_Jul_Ogs_Sep_Okt_Nov_Dis".split("_"),weekdays:"Ahad_Isnin_Selasa_Rabu_Khamis_Jumaat_Sabtu".split("_"),weekdaysShort:"Ahd_Isn_Sel_Rab_Kha_Jum_Sab".split("_"),weekdaysMin:"Ah_Is_Sl_Rb_Km_Jm_Sb".split("_"),longDateFormat:{LT:"HH.mm",LTS:"HH.mm.ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY [pukul] HH.mm",LLLL:"dddd, D MMMM YYYY [pukul] HH.mm"},meridiemParse:/pagi|tengahari|petang|malam/,meridiemHour:function(e,t){return 12===e&&(e=0),"pagi"===t?e:"tengahari"===t?e>=11?e:e+12:"petang"===t||"malam"===t?e+12:void 0},meridiem:function(e,t,n){return e<11?"pagi":e<15?"tengahari":e<19?"petang":"malam"},calendar:{sameDay:"[Hari ini pukul] LT",nextDay:"[Esok pukul] LT",nextWeek:"dddd [pukul] LT",lastDay:"[Kelmarin pukul] LT",lastWeek:"dddd [lepas pukul] LT",sameElse:"L"},relativeTime:{future:"dalam %s",past:"%s yang lepas",s:"beberapa saat",ss:"%d saat",m:"seminit",mm:"%d minit",h:"sejam",hh:"%d jam",d:"sehari",dd:"%d hari",M:"sebulan",MM:"%d bulan",y:"setahun",yy:"%d tahun"},week:{dow:1,doy:7}})}(n(95093))},73386:function(e,t,n){!function(e){"use strict";e.defineLocale("ms",{months:"Januari_Februari_Mac_April_Mei_Jun_Julai_Ogos_September_Oktober_November_Disember".split("_"),monthsShort:"Jan_Feb_Mac_Apr_Mei_Jun_Jul_Ogs_Sep_Okt_Nov_Dis".split("_"),weekdays:"Ahad_Isnin_Selasa_Rabu_Khamis_Jumaat_Sabtu".split("_"),weekdaysShort:"Ahd_Isn_Sel_Rab_Kha_Jum_Sab".split("_"),weekdaysMin:"Ah_Is_Sl_Rb_Km_Jm_Sb".split("_"),longDateFormat:{LT:"HH.mm",LTS:"HH.mm.ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY [pukul] HH.mm",LLLL:"dddd, D MMMM YYYY [pukul] HH.mm"},meridiemParse:/pagi|tengahari|petang|malam/,meridiemHour:function(e,t){return 12===e&&(e=0),"pagi"===t?e:"tengahari"===t?e>=11?e:e+12:"petang"===t||"malam"===t?e+12:void 0},meridiem:function(e,t,n){return e<11?"pagi":e<15?"tengahari":e<19?"petang":"malam"},calendar:{sameDay:"[Hari ini pukul] LT",nextDay:"[Esok pukul] LT",nextWeek:"dddd [pukul] LT",lastDay:"[Kelmarin pukul] LT",lastWeek:"dddd [lepas pukul] LT",sameElse:"L"},relativeTime:{future:"dalam %s",past:"%s yang lepas",s:"beberapa saat",ss:"%d saat",m:"seminit",mm:"%d minit",h:"sejam",hh:"%d jam",d:"sehari",dd:"%d hari",M:"sebulan",MM:"%d bulan",y:"setahun",yy:"%d tahun"},week:{dow:1,doy:7}})}(n(95093))},77075:function(e,t,n){!function(e){"use strict";e.defineLocale("mt",{months:"Jannar_Frar_Marzu_April_Mejju_Ġunju_Lulju_Awwissu_Settembru_Ottubru_Novembru_Diċembru".split("_"),monthsShort:"Jan_Fra_Mar_Apr_Mej_Ġun_Lul_Aww_Set_Ott_Nov_Diċ".split("_"),weekdays:"Il-Ħadd_It-Tnejn_It-Tlieta_L-Erbgħa_Il-Ħamis_Il-Ġimgħa_Is-Sibt".split("_"),weekdaysShort:"Ħad_Tne_Tli_Erb_Ħam_Ġim_Sib".split("_"),weekdaysMin:"Ħa_Tn_Tl_Er_Ħa_Ġi_Si".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[Illum fil-]LT",nextDay:"[Għada fil-]LT",nextWeek:"dddd [fil-]LT",lastDay:"[Il-bieraħ fil-]LT",lastWeek:"dddd [li għadda] [fil-]LT",sameElse:"L"},relativeTime:{future:"f’ %s",past:"%s ilu",s:"ftit sekondi",ss:"%d sekondi",m:"minuta",mm:"%d minuti",h:"siegħa",hh:"%d siegħat",d:"ġurnata",dd:"%d ġranet",M:"xahar",MM:"%d xhur",y:"sena",yy:"%d sni"},dayOfMonthOrdinalParse:/\d{1,2}º/,ordinal:"%dº",week:{dow:1,doy:4}})}(n(95093))},72264:function(e,t,n){!function(e){"use strict";var t={1:"၁",2:"၂",3:"၃",4:"၄",5:"၅",6:"၆",7:"၇",8:"၈",9:"၉",0:"၀"},n={"၁":"1","၂":"2","၃":"3","၄":"4","၅":"5","၆":"6","၇":"7","၈":"8","၉":"9","၀":"0"};e.defineLocale("my",{months:"ဇန်နဝါရီ_ဖေဖော်ဝါရီ_မတ်_ဧပြီ_မေ_ဇွန်_ဇူလိုင်_သြဂုတ်_စက်တင်ဘာ_အောက်တိုဘာ_နိုဝင်ဘာ_ဒီဇင်ဘာ".split("_"),monthsShort:"ဇန်_ဖေ_မတ်_ပြီ_မေ_ဇွန်_လိုင်_သြ_စက်_အောက်_နို_ဒီ".split("_"),weekdays:"တနင်္ဂနွေ_တနင်္လာ_အင်္ဂါ_ဗုဒ္ဓဟူး_ကြာသပတေး_သောကြာ_စနေ".split("_"),weekdaysShort:"နွေ_လာ_ဂါ_ဟူး_ကြာ_သော_နေ".split("_"),weekdaysMin:"နွေ_လာ_ဂါ_ဟူး_ကြာ_သော_နေ".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},calendar:{sameDay:"[ယနေ.] LT [မှာ]",nextDay:"[မနက်ဖြန်] LT [မှာ]",nextWeek:"dddd LT [မှာ]",lastDay:"[မနေ.က] LT [မှာ]",lastWeek:"[ပြီးခဲ့သော] dddd LT [မှာ]",sameElse:"L"},relativeTime:{future:"လာမည့် %s မှာ",past:"လွန်ခဲ့သော %s က",s:"စက္ကန်.အနည်းငယ်",ss:"%d စက္ကန့်",m:"တစ်မိနစ်",mm:"%d မိနစ်",h:"တစ်နာရီ",hh:"%d နာရီ",d:"တစ်ရက်",dd:"%d ရက်",M:"တစ်လ",MM:"%d လ",y:"တစ်နှစ်",yy:"%d နှစ်"},preparse:function(e){return e.replace(/[၁၂၃၄၅၆၇၈၉၀]/g,(function(e){return n[e]}))},postformat:function(e){return e.replace(/\d/g,(function(e){return t[e]}))},week:{dow:1,doy:4}})}(n(95093))},22274:function(e,t,n){!function(e){"use strict";e.defineLocale("nb",{months:"januar_februar_mars_april_mai_juni_juli_august_september_oktober_november_desember".split("_"),monthsShort:"jan._feb._mars_apr._mai_juni_juli_aug._sep._okt._nov._des.".split("_"),monthsParseExact:!0,weekdays:"søndag_mandag_tirsdag_onsdag_torsdag_fredag_lørdag".split("_"),weekdaysShort:"sø._ma._ti._on._to._fr._lø.".split("_"),weekdaysMin:"sø_ma_ti_on_to_fr_lø".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY [kl.] HH:mm",LLLL:"dddd D. MMMM YYYY [kl.] HH:mm"},calendar:{sameDay:"[i dag kl.] LT",nextDay:"[i morgen kl.] LT",nextWeek:"dddd [kl.] LT",lastDay:"[i går kl.] LT",lastWeek:"[forrige] dddd [kl.] LT",sameElse:"L"},relativeTime:{future:"om %s",past:"%s siden",s:"noen sekunder",ss:"%d sekunder",m:"ett minutt",mm:"%d minutter",h:"én time",hh:"%d timer",d:"én dag",dd:"%d dager",w:"én uke",ww:"%d uker",M:"én måned",MM:"%d måneder",y:"ett år",yy:"%d år"},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:4}})}(n(95093))},8235:function(e,t,n){!function(e){"use strict";var t={1:"१",2:"२",3:"३",4:"४",5:"५",6:"६",7:"७",8:"८",9:"९",0:"०"},n={"१":"1","२":"2","३":"3","४":"4","५":"5","६":"6","७":"7","८":"8","९":"9","०":"0"};e.defineLocale("ne",{months:"जनवरी_फेब्रुवरी_मार्च_अप्रिल_मई_जुन_जुलाई_अगष्ट_सेप्टेम्बर_अक्टोबर_नोभेम्बर_डिसेम्बर".split("_"),monthsShort:"जन._फेब्रु._मार्च_अप्रि._मई_जुन_जुलाई._अग._सेप्ट._अक्टो._नोभे._डिसे.".split("_"),monthsParseExact:!0,weekdays:"आइतबार_सोमबार_मङ्गलबार_बुधबार_बिहिबार_शुक्रबार_शनिबार".split("_"),weekdaysShort:"आइत._सोम._मङ्गल._बुध._बिहि._शुक्र._शनि.".split("_"),weekdaysMin:"आ._सो._मं._बु._बि._शु._श.".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"Aको h:mm बजे",LTS:"Aको h:mm:ss बजे",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY, Aको h:mm बजे",LLLL:"dddd, D MMMM YYYY, Aको h:mm बजे"},preparse:function(e){return e.replace(/[१२३४५६७८९०]/g,(function(e){return n[e]}))},postformat:function(e){return e.replace(/\d/g,(function(e){return t[e]}))},meridiemParse:/राति|बिहान|दिउँसो|साँझ/,meridiemHour:function(e,t){return 12===e&&(e=0),"राति"===t?e<4?e:e+12:"बिहान"===t?e:"दिउँसो"===t?e>=10?e:e+12:"साँझ"===t?e+12:void 0},meridiem:function(e,t,n){return e<3?"राति":e<12?"बिहान":e<16?"दिउँसो":e<20?"साँझ":"राति"},calendar:{sameDay:"[आज] LT",nextDay:"[भोलि] LT",nextWeek:"[आउँदो] dddd[,] LT",lastDay:"[हिजो] LT",lastWeek:"[गएको] dddd[,] LT",sameElse:"L"},relativeTime:{future:"%sमा",past:"%s अगाडि",s:"केही क्षण",ss:"%d सेकेण्ड",m:"एक मिनेट",mm:"%d मिनेट",h:"एक घण्टा",hh:"%d घण्टा",d:"एक दिन",dd:"%d दिन",M:"एक महिना",MM:"%d महिना",y:"एक बर्ष",yy:"%d बर्ष"},week:{dow:0,doy:6}})}(n(95093))},43784:function(e,t,n){!function(e){"use strict";var t="jan._feb._mrt._apr._mei_jun._jul._aug._sep._okt._nov._dec.".split("_"),n="jan_feb_mrt_apr_mei_jun_jul_aug_sep_okt_nov_dec".split("_"),r=[/^jan/i,/^feb/i,/^(maart|mrt\.?)$/i,/^apr/i,/^mei$/i,/^jun[i.]?$/i,/^jul[i.]?$/i,/^aug/i,/^sep/i,/^okt/i,/^nov/i,/^dec/i],a=/^(januari|februari|maart|april|mei|ju[nl]i|augustus|september|oktober|november|december|jan\.?|feb\.?|mrt\.?|apr\.?|ju[nl]\.?|aug\.?|sep\.?|okt\.?|nov\.?|dec\.?)/i;e.defineLocale("nl-be",{months:"januari_februari_maart_april_mei_juni_juli_augustus_september_oktober_november_december".split("_"),monthsShort:function(e,r){return e?/-MMM-/.test(r)?n[e.month()]:t[e.month()]:t},monthsRegex:a,monthsShortRegex:a,monthsStrictRegex:/^(januari|februari|maart|april|mei|ju[nl]i|augustus|september|oktober|november|december)/i,monthsShortStrictRegex:/^(jan\.?|feb\.?|mrt\.?|apr\.?|mei|ju[nl]\.?|aug\.?|sep\.?|okt\.?|nov\.?|dec\.?)/i,monthsParse:r,longMonthsParse:r,shortMonthsParse:r,weekdays:"zondag_maandag_dinsdag_woensdag_donderdag_vrijdag_zaterdag".split("_"),weekdaysShort:"zo._ma._di._wo._do._vr._za.".split("_"),weekdaysMin:"zo_ma_di_wo_do_vr_za".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},calendar:{sameDay:"[vandaag om] LT",nextDay:"[morgen om] LT",nextWeek:"dddd [om] LT",lastDay:"[gisteren om] LT",lastWeek:"[afgelopen] dddd [om] LT",sameElse:"L"},relativeTime:{future:"over %s",past:"%s geleden",s:"een paar seconden",ss:"%d seconden",m:"één minuut",mm:"%d minuten",h:"één uur",hh:"%d uur",d:"één dag",dd:"%d dagen",M:"één maand",MM:"%d maanden",y:"één jaar",yy:"%d jaar"},dayOfMonthOrdinalParse:/\d{1,2}(ste|de)/,ordinal:function(e){return e+(1===e||8===e||e>=20?"ste":"de")},week:{dow:1,doy:4}})}(n(95093))},92572:function(e,t,n){!function(e){"use strict";var t="jan._feb._mrt._apr._mei_jun._jul._aug._sep._okt._nov._dec.".split("_"),n="jan_feb_mrt_apr_mei_jun_jul_aug_sep_okt_nov_dec".split("_"),r=[/^jan/i,/^feb/i,/^(maart|mrt\.?)$/i,/^apr/i,/^mei$/i,/^jun[i.]?$/i,/^jul[i.]?$/i,/^aug/i,/^sep/i,/^okt/i,/^nov/i,/^dec/i],a=/^(januari|februari|maart|april|mei|ju[nl]i|augustus|september|oktober|november|december|jan\.?|feb\.?|mrt\.?|apr\.?|ju[nl]\.?|aug\.?|sep\.?|okt\.?|nov\.?|dec\.?)/i;e.defineLocale("nl",{months:"januari_februari_maart_april_mei_juni_juli_augustus_september_oktober_november_december".split("_"),monthsShort:function(e,r){return e?/-MMM-/.test(r)?n[e.month()]:t[e.month()]:t},monthsRegex:a,monthsShortRegex:a,monthsStrictRegex:/^(januari|februari|maart|april|mei|ju[nl]i|augustus|september|oktober|november|december)/i,monthsShortStrictRegex:/^(jan\.?|feb\.?|mrt\.?|apr\.?|mei|ju[nl]\.?|aug\.?|sep\.?|okt\.?|nov\.?|dec\.?)/i,monthsParse:r,longMonthsParse:r,shortMonthsParse:r,weekdays:"zondag_maandag_dinsdag_woensdag_donderdag_vrijdag_zaterdag".split("_"),weekdaysShort:"zo._ma._di._wo._do._vr._za.".split("_"),weekdaysMin:"zo_ma_di_wo_do_vr_za".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD-MM-YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},calendar:{sameDay:"[vandaag om] LT",nextDay:"[morgen om] LT",nextWeek:"dddd [om] LT",lastDay:"[gisteren om] LT",lastWeek:"[afgelopen] dddd [om] LT",sameElse:"L"},relativeTime:{future:"over %s",past:"%s geleden",s:"een paar seconden",ss:"%d seconden",m:"één minuut",mm:"%d minuten",h:"één uur",hh:"%d uur",d:"één dag",dd:"%d dagen",w:"één week",ww:"%d weken",M:"één maand",MM:"%d maanden",y:"één jaar",yy:"%d jaar"},dayOfMonthOrdinalParse:/\d{1,2}(ste|de)/,ordinal:function(e){return e+(1===e||8===e||e>=20?"ste":"de")},week:{dow:1,doy:4}})}(n(95093))},54566:function(e,t,n){!function(e){"use strict";e.defineLocale("nn",{months:"januar_februar_mars_april_mai_juni_juli_august_september_oktober_november_desember".split("_"),monthsShort:"jan._feb._mars_apr._mai_juni_juli_aug._sep._okt._nov._des.".split("_"),monthsParseExact:!0,weekdays:"sundag_måndag_tysdag_onsdag_torsdag_fredag_laurdag".split("_"),weekdaysShort:"su._må._ty._on._to._fr._lau.".split("_"),weekdaysMin:"su_må_ty_on_to_fr_la".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY [kl.] H:mm",LLLL:"dddd D. MMMM YYYY [kl.] HH:mm"},calendar:{sameDay:"[I dag klokka] LT",nextDay:"[I morgon klokka] LT",nextWeek:"dddd [klokka] LT",lastDay:"[I går klokka] LT",lastWeek:"[Føregåande] dddd [klokka] LT",sameElse:"L"},relativeTime:{future:"om %s",past:"%s sidan",s:"nokre sekund",ss:"%d sekund",m:"eit minutt",mm:"%d minutt",h:"ein time",hh:"%d timar",d:"ein dag",dd:"%d dagar",w:"ei veke",ww:"%d veker",M:"ein månad",MM:"%d månader",y:"eit år",yy:"%d år"},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:4}})}(n(95093))},69330:function(e,t,n){!function(e){"use strict";e.defineLocale("oc-lnc",{months:{standalone:"genièr_febrièr_març_abril_mai_junh_julhet_agost_setembre_octòbre_novembre_decembre".split("_"),format:"de genièr_de febrièr_de març_d'abril_de mai_de junh_de julhet_d'agost_de setembre_d'octòbre_de novembre_de decembre".split("_"),isFormat:/D[oD]?(\s)+MMMM/},monthsShort:"gen._febr._març_abr._mai_junh_julh._ago._set._oct._nov._dec.".split("_"),monthsParseExact:!0,weekdays:"dimenge_diluns_dimars_dimècres_dijòus_divendres_dissabte".split("_"),weekdaysShort:"dg._dl._dm._dc._dj._dv._ds.".split("_"),weekdaysMin:"dg_dl_dm_dc_dj_dv_ds".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM [de] YYYY",ll:"D MMM YYYY",LLL:"D MMMM [de] YYYY [a] H:mm",lll:"D MMM YYYY, H:mm",LLLL:"dddd D MMMM [de] YYYY [a] H:mm",llll:"ddd D MMM YYYY, H:mm"},calendar:{sameDay:"[uèi a] LT",nextDay:"[deman a] LT",nextWeek:"dddd [a] LT",lastDay:"[ièr a] LT",lastWeek:"dddd [passat a] LT",sameElse:"L"},relativeTime:{future:"d'aquí %s",past:"fa %s",s:"unas segondas",ss:"%d segondas",m:"una minuta",mm:"%d minutas",h:"una ora",hh:"%d oras",d:"un jorn",dd:"%d jorns",M:"un mes",MM:"%d meses",y:"un an",yy:"%d ans"},dayOfMonthOrdinalParse:/\d{1,2}(r|n|t|è|a)/,ordinal:function(e,t){var n=1===e?"r":2===e?"n":3===e?"r":4===e?"t":"è";return"w"!==t&&"W"!==t||(n="a"),e+n},week:{dow:1,doy:4}})}(n(95093))},29849:function(e,t,n){!function(e){"use strict";var t={1:"੧",2:"੨",3:"੩",4:"੪",5:"੫",6:"੬",7:"੭",8:"੮",9:"੯",0:"੦"},n={"੧":"1","੨":"2","੩":"3","੪":"4","੫":"5","੬":"6","੭":"7","੮":"8","੯":"9","੦":"0"};e.defineLocale("pa-in",{months:"ਜਨਵਰੀ_ਫ਼ਰਵਰੀ_ਮਾਰਚ_ਅਪ੍ਰੈਲ_ਮਈ_ਜੂਨ_ਜੁਲਾਈ_ਅਗਸਤ_ਸਤੰਬਰ_ਅਕਤੂਬਰ_ਨਵੰਬਰ_ਦਸੰਬਰ".split("_"),monthsShort:"ਜਨਵਰੀ_ਫ਼ਰਵਰੀ_ਮਾਰਚ_ਅਪ੍ਰੈਲ_ਮਈ_ਜੂਨ_ਜੁਲਾਈ_ਅਗਸਤ_ਸਤੰਬਰ_ਅਕਤੂਬਰ_ਨਵੰਬਰ_ਦਸੰਬਰ".split("_"),weekdays:"ਐਤਵਾਰ_ਸੋਮਵਾਰ_ਮੰਗਲਵਾਰ_ਬੁਧਵਾਰ_ਵੀਰਵਾਰ_ਸ਼ੁੱਕਰਵਾਰ_ਸ਼ਨੀਚਰਵਾਰ".split("_"),weekdaysShort:"ਐਤ_ਸੋਮ_ਮੰਗਲ_ਬੁਧ_ਵੀਰ_ਸ਼ੁਕਰ_ਸ਼ਨੀ".split("_"),weekdaysMin:"ਐਤ_ਸੋਮ_ਮੰਗਲ_ਬੁਧ_ਵੀਰ_ਸ਼ੁਕਰ_ਸ਼ਨੀ".split("_"),longDateFormat:{LT:"A h:mm ਵਜੇ",LTS:"A h:mm:ss ਵਜੇ",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY, A h:mm ਵਜੇ",LLLL:"dddd, D MMMM YYYY, A h:mm ਵਜੇ"},calendar:{sameDay:"[ਅਜ] LT",nextDay:"[ਕਲ] LT",nextWeek:"[ਅਗਲਾ] dddd, LT",lastDay:"[ਕਲ] LT",lastWeek:"[ਪਿਛਲੇ] dddd, LT",sameElse:"L"},relativeTime:{future:"%s ਵਿੱਚ",past:"%s ਪਿਛਲੇ",s:"ਕੁਝ ਸਕਿੰਟ",ss:"%d ਸਕਿੰਟ",m:"ਇਕ ਮਿੰਟ",mm:"%d ਮਿੰਟ",h:"ਇੱਕ ਘੰਟਾ",hh:"%d ਘੰਟੇ",d:"ਇੱਕ ਦਿਨ",dd:"%d ਦਿਨ",M:"ਇੱਕ ਮਹੀਨਾ",MM:"%d ਮਹੀਨੇ",y:"ਇੱਕ ਸਾਲ",yy:"%d ਸਾਲ"},preparse:function(e){return e.replace(/[੧੨੩੪੫੬੭੮੯੦]/g,(function(e){return n[e]}))},postformat:function(e){return e.replace(/\d/g,(function(e){return t[e]}))},meridiemParse:/ਰਾਤ|ਸਵੇਰ|ਦੁਪਹਿਰ|ਸ਼ਾਮ/,meridiemHour:function(e,t){return 12===e&&(e=0),"ਰਾਤ"===t?e<4?e:e+12:"ਸਵੇਰ"===t?e:"ਦੁਪਹਿਰ"===t?e>=10?e:e+12:"ਸ਼ਾਮ"===t?e+12:void 0},meridiem:function(e,t,n){return e<4?"ਰਾਤ":e<10?"ਸਵੇਰ":e<17?"ਦੁਪਹਿਰ":e<20?"ਸ਼ਾਮ":"ਰਾਤ"},week:{dow:0,doy:6}})}(n(95093))},94418:function(e,t,n){!function(e){"use strict";var t="styczeń_luty_marzec_kwiecień_maj_czerwiec_lipiec_sierpień_wrzesień_październik_listopad_grudzień".split("_"),n="stycznia_lutego_marca_kwietnia_maja_czerwca_lipca_sierpnia_września_października_listopada_grudnia".split("_"),r=[/^sty/i,/^lut/i,/^mar/i,/^kwi/i,/^maj/i,/^cze/i,/^lip/i,/^sie/i,/^wrz/i,/^paź/i,/^lis/i,/^gru/i];function a(e){return e%10<5&&e%10>1&&~~(e/10)%10!=1}function s(e,t,n){var r=e+" ";switch(n){case"ss":return r+(a(e)?"sekundy":"sekund");case"m":return t?"minuta":"minutę";case"mm":return r+(a(e)?"minuty":"minut");case"h":return t?"godzina":"godzinę";case"hh":return r+(a(e)?"godziny":"godzin");case"ww":return r+(a(e)?"tygodnie":"tygodni");case"MM":return r+(a(e)?"miesiące":"miesięcy");case"yy":return r+(a(e)?"lata":"lat")}}e.defineLocale("pl",{months:function(e,r){return e?/D MMMM/.test(r)?n[e.month()]:t[e.month()]:t},monthsShort:"sty_lut_mar_kwi_maj_cze_lip_sie_wrz_paź_lis_gru".split("_"),monthsParse:r,longMonthsParse:r,shortMonthsParse:r,weekdays:"niedziela_poniedziałek_wtorek_środa_czwartek_piątek_sobota".split("_"),weekdaysShort:"ndz_pon_wt_śr_czw_pt_sob".split("_"),weekdaysMin:"Nd_Pn_Wt_Śr_Cz_Pt_So".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[Dziś o] LT",nextDay:"[Jutro o] LT",nextWeek:function(){switch(this.day()){case 0:return"[W niedzielę o] LT";case 2:return"[We wtorek o] LT";case 3:return"[W środę o] LT";case 6:return"[W sobotę o] LT";default:return"[W] dddd [o] LT"}},lastDay:"[Wczoraj o] LT",lastWeek:function(){switch(this.day()){case 0:return"[W zeszłą niedzielę o] LT";case 3:return"[W zeszłą środę o] LT";case 6:return"[W zeszłą sobotę o] LT";default:return"[W zeszły] dddd [o] LT"}},sameElse:"L"},relativeTime:{future:"za %s",past:"%s temu",s:"kilka sekund",ss:s,m:s,mm:s,h:s,hh:s,d:"1 dzień",dd:"%d dni",w:"tydzień",ww:s,M:"miesiąc",MM:s,y:"rok",yy:s},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:4}})}(n(95093))},48303:function(e,t,n){!function(e){"use strict";e.defineLocale("pt-br",{months:"janeiro_fevereiro_março_abril_maio_junho_julho_agosto_setembro_outubro_novembro_dezembro".split("_"),monthsShort:"jan_fev_mar_abr_mai_jun_jul_ago_set_out_nov_dez".split("_"),weekdays:"domingo_segunda-feira_terça-feira_quarta-feira_quinta-feira_sexta-feira_sábado".split("_"),weekdaysShort:"dom_seg_ter_qua_qui_sex_sáb".split("_"),weekdaysMin:"do_2ª_3ª_4ª_5ª_6ª_sá".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D [de] MMMM [de] YYYY",LLL:"D [de] MMMM [de] YYYY [às] HH:mm",LLLL:"dddd, D [de] MMMM [de] YYYY [às] HH:mm"},calendar:{sameDay:"[Hoje às] LT",nextDay:"[Amanhã às] LT",nextWeek:"dddd [às] LT",lastDay:"[Ontem às] LT",lastWeek:function(){return 0===this.day()||6===this.day()?"[Último] dddd [às] LT":"[Última] dddd [às] LT"},sameElse:"L"},relativeTime:{future:"em %s",past:"há %s",s:"poucos segundos",ss:"%d segundos",m:"um minuto",mm:"%d minutos",h:"uma hora",hh:"%d horas",d:"um dia",dd:"%d dias",M:"um mês",MM:"%d meses",y:"um ano",yy:"%d anos"},dayOfMonthOrdinalParse:/\d{1,2}º/,ordinal:"%dº",invalidDate:"Data inválida"})}(n(95093))},79834:function(e,t,n){!function(e){"use strict";e.defineLocale("pt",{months:"janeiro_fevereiro_março_abril_maio_junho_julho_agosto_setembro_outubro_novembro_dezembro".split("_"),monthsShort:"jan_fev_mar_abr_mai_jun_jul_ago_set_out_nov_dez".split("_"),weekdays:"Domingo_Segunda-feira_Terça-feira_Quarta-feira_Quinta-feira_Sexta-feira_Sábado".split("_"),weekdaysShort:"Dom_Seg_Ter_Qua_Qui_Sex_Sáb".split("_"),weekdaysMin:"Do_2ª_3ª_4ª_5ª_6ª_Sá".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D [de] MMMM [de] YYYY",LLL:"D [de] MMMM [de] YYYY HH:mm",LLLL:"dddd, D [de] MMMM [de] YYYY HH:mm"},calendar:{sameDay:"[Hoje às] LT",nextDay:"[Amanhã às] LT",nextWeek:"dddd [às] LT",lastDay:"[Ontem às] LT",lastWeek:function(){return 0===this.day()||6===this.day()?"[Último] dddd [às] LT":"[Última] dddd [às] LT"},sameElse:"L"},relativeTime:{future:"em %s",past:"há %s",s:"segundos",ss:"%d segundos",m:"um minuto",mm:"%d minutos",h:"uma hora",hh:"%d horas",d:"um dia",dd:"%d dias",w:"uma semana",ww:"%d semanas",M:"um mês",MM:"%d meses",y:"um ano",yy:"%d anos"},dayOfMonthOrdinalParse:/\d{1,2}º/,ordinal:"%dº",week:{dow:1,doy:4}})}(n(95093))},24457:function(e,t,n){!function(e){"use strict";function t(e,t,n){var r=" ";return(e%100>=20||e>=100&&e%100==0)&&(r=" de "),e+r+{ss:"secunde",mm:"minute",hh:"ore",dd:"zile",ww:"săptămâni",MM:"luni",yy:"ani"}[n]}e.defineLocale("ro",{months:"ianuarie_februarie_martie_aprilie_mai_iunie_iulie_august_septembrie_octombrie_noiembrie_decembrie".split("_"),monthsShort:"ian._feb._mart._apr._mai_iun._iul._aug._sept._oct._nov._dec.".split("_"),monthsParseExact:!0,weekdays:"duminică_luni_marți_miercuri_joi_vineri_sâmbătă".split("_"),weekdaysShort:"Dum_Lun_Mar_Mie_Joi_Vin_Sâm".split("_"),weekdaysMin:"Du_Lu_Ma_Mi_Jo_Vi_Sâ".split("_"),longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY H:mm",LLLL:"dddd, D MMMM YYYY H:mm"},calendar:{sameDay:"[azi la] LT",nextDay:"[mâine la] LT",nextWeek:"dddd [la] LT",lastDay:"[ieri la] LT",lastWeek:"[fosta] dddd [la] LT",sameElse:"L"},relativeTime:{future:"peste %s",past:"%s în urmă",s:"câteva secunde",ss:t,m:"un minut",mm:t,h:"o oră",hh:t,d:"o zi",dd:t,w:"o săptămână",ww:t,M:"o lună",MM:t,y:"un an",yy:t},week:{dow:1,doy:7}})}(n(95093))},82271:function(e,t,n){!function(e){"use strict";function t(e,t){var n=e.split("_");return t%10==1&&t%100!=11?n[0]:t%10>=2&&t%10<=4&&(t%100<10||t%100>=20)?n[1]:n[2]}function n(e,n,r){return"m"===r?n?"минута":"минуту":e+" "+t({ss:n?"секунда_секунды_секунд":"секунду_секунды_секунд",mm:n?"минута_минуты_минут":"минуту_минуты_минут",hh:"час_часа_часов",dd:"день_дня_дней",ww:"неделя_недели_недель",MM:"месяц_месяца_месяцев",yy:"год_года_лет"}[r],+e)}var r=[/^янв/i,/^фев/i,/^мар/i,/^апр/i,/^ма[йя]/i,/^июн/i,/^июл/i,/^авг/i,/^сен/i,/^окт/i,/^ноя/i,/^дек/i];e.defineLocale("ru",{months:{format:"января_февраля_марта_апреля_мая_июня_июля_августа_сентября_октября_ноября_декабря".split("_"),standalone:"январь_февраль_март_апрель_май_июнь_июль_август_сентябрь_октябрь_ноябрь_декабрь".split("_")},monthsShort:{format:"янв._февр._мар._апр._мая_июня_июля_авг._сент._окт._нояб._дек.".split("_"),standalone:"янв._февр._март_апр._май_июнь_июль_авг._сент._окт._нояб._дек.".split("_")},weekdays:{standalone:"воскресенье_понедельник_вторник_среда_четверг_пятница_суббота".split("_"),format:"воскресенье_понедельник_вторник_среду_четверг_пятницу_субботу".split("_"),isFormat:/\[ ?[Вв] ?(?:прошлую|следующую|эту)? ?] ?dddd/},weekdaysShort:"вс_пн_вт_ср_чт_пт_сб".split("_"),weekdaysMin:"вс_пн_вт_ср_чт_пт_сб".split("_"),monthsParse:r,longMonthsParse:r,shortMonthsParse:r,monthsRegex:/^(январ[ья]|янв\.?|феврал[ья]|февр?\.?|марта?|мар\.?|апрел[ья]|апр\.?|ма[йя]|июн[ья]|июн\.?|июл[ья]|июл\.?|августа?|авг\.?|сентябр[ья]|сент?\.?|октябр[ья]|окт\.?|ноябр[ья]|нояб?\.?|декабр[ья]|дек\.?)/i,monthsShortRegex:/^(январ[ья]|янв\.?|феврал[ья]|февр?\.?|марта?|мар\.?|апрел[ья]|апр\.?|ма[йя]|июн[ья]|июн\.?|июл[ья]|июл\.?|августа?|авг\.?|сентябр[ья]|сент?\.?|октябр[ья]|окт\.?|ноябр[ья]|нояб?\.?|декабр[ья]|дек\.?)/i,monthsStrictRegex:/^(январ[яь]|феврал[яь]|марта?|апрел[яь]|ма[яй]|июн[яь]|июл[яь]|августа?|сентябр[яь]|октябр[яь]|ноябр[яь]|декабр[яь])/i,monthsShortStrictRegex:/^(янв\.|февр?\.|мар[т.]|апр\.|ма[яй]|июн[ья.]|июл[ья.]|авг\.|сент?\.|окт\.|нояб?\.|дек\.)/i,longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY г.",LLL:"D MMMM YYYY г., H:mm",LLLL:"dddd, D MMMM YYYY г., H:mm"},calendar:{sameDay:"[Сегодня, в] LT",nextDay:"[Завтра, в] LT",lastDay:"[Вчера, в] LT",nextWeek:function(e){if(e.week()===this.week())return 2===this.day()?"[Во] dddd, [в] LT":"[В] dddd, [в] LT";switch(this.day()){case 0:return"[В следующее] dddd, [в] LT";case 1:case 2:case 4:return"[В следующий] dddd, [в] LT";case 3:case 5:case 6:return"[В следующую] dddd, [в] LT"}},lastWeek:function(e){if(e.week()===this.week())return 2===this.day()?"[Во] dddd, [в] LT":"[В] dddd, [в] LT";switch(this.day()){case 0:return"[В прошлое] dddd, [в] LT";case 1:case 2:case 4:return"[В прошлый] dddd, [в] LT";case 3:case 5:case 6:return"[В прошлую] dddd, [в] LT"}},sameElse:"L"},relativeTime:{future:"через %s",past:"%s назад",s:"несколько секунд",ss:n,m:n,mm:n,h:"час",hh:n,d:"день",dd:n,w:"неделя",ww:n,M:"месяц",MM:n,y:"год",yy:n},meridiemParse:/ночи|утра|дня|вечера/i,isPM:function(e){return/^(дня|вечера)$/.test(e)},meridiem:function(e,t,n){return e<4?"ночи":e<12?"утра":e<17?"дня":"вечера"},dayOfMonthOrdinalParse:/\d{1,2}-(й|го|я)/,ordinal:function(e,t){switch(t){case"M":case"d":case"DDD":return e+"-й";case"D":return e+"-го";case"w":case"W":return e+"-я";default:return e}},week:{dow:1,doy:4}})}(n(95093))},1221:function(e,t,n){!function(e){"use strict";var t=["جنوري","فيبروري","مارچ","اپريل","مئي","جون","جولاءِ","آگسٽ","سيپٽمبر","آڪٽوبر","نومبر","ڊسمبر"],n=["آچر","سومر","اڱارو","اربع","خميس","جمع","ڇنڇر"];e.defineLocale("sd",{months:t,monthsShort:t,weekdays:n,weekdaysShort:n,weekdaysMin:n,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd، D MMMM YYYY HH:mm"},meridiemParse:/صبح|شام/,isPM:function(e){return"شام"===e},meridiem:function(e,t,n){return e<12?"صبح":"شام"},calendar:{sameDay:"[اڄ] LT",nextDay:"[سڀاڻي] LT",nextWeek:"dddd [اڳين هفتي تي] LT",lastDay:"[ڪالهه] LT",lastWeek:"[گزريل هفتي] dddd [تي] LT",sameElse:"L"},relativeTime:{future:"%s پوء",past:"%s اڳ",s:"چند سيڪنڊ",ss:"%d سيڪنڊ",m:"هڪ منٽ",mm:"%d منٽ",h:"هڪ ڪلاڪ",hh:"%d ڪلاڪ",d:"هڪ ڏينهن",dd:"%d ڏينهن",M:"هڪ مهينو",MM:"%d مهينا",y:"هڪ سال",yy:"%d سال"},preparse:function(e){return e.replace(/،/g,",")},postformat:function(e){return e.replace(/,/g,"،")},week:{dow:1,doy:4}})}(n(95093))},33478:function(e,t,n){!function(e){"use strict";e.defineLocale("se",{months:"ođđajagemánnu_guovvamánnu_njukčamánnu_cuoŋománnu_miessemánnu_geassemánnu_suoidnemánnu_borgemánnu_čakčamánnu_golggotmánnu_skábmamánnu_juovlamánnu".split("_"),monthsShort:"ođđj_guov_njuk_cuo_mies_geas_suoi_borg_čakč_golg_skáb_juov".split("_"),weekdays:"sotnabeaivi_vuossárga_maŋŋebárga_gaskavahkku_duorastat_bearjadat_lávvardat".split("_"),weekdaysShort:"sotn_vuos_maŋ_gask_duor_bear_láv".split("_"),weekdaysMin:"s_v_m_g_d_b_L".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"MMMM D. [b.] YYYY",LLL:"MMMM D. [b.] YYYY [ti.] HH:mm",LLLL:"dddd, MMMM D. [b.] YYYY [ti.] HH:mm"},calendar:{sameDay:"[otne ti] LT",nextDay:"[ihttin ti] LT",nextWeek:"dddd [ti] LT",lastDay:"[ikte ti] LT",lastWeek:"[ovddit] dddd [ti] LT",sameElse:"L"},relativeTime:{future:"%s geažes",past:"maŋit %s",s:"moadde sekunddat",ss:"%d sekunddat",m:"okta minuhta",mm:"%d minuhtat",h:"okta diimmu",hh:"%d diimmut",d:"okta beaivi",dd:"%d beaivvit",M:"okta mánnu",MM:"%d mánut",y:"okta jahki",yy:"%d jagit"},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:4}})}(n(95093))},17538:function(e,t,n){!function(e){"use strict";e.defineLocale("si",{months:"ජනවාරි_පෙබරවාරි_මාර්තු_අප්‍රේල්_මැයි_ජූනි_ජූලි_අගෝස්තු_සැප්තැම්බර්_ඔක්තෝබර්_නොවැම්බර්_දෙසැම්බර්".split("_"),monthsShort:"ජන_පෙබ_මාර්_අප්_මැයි_ජූනි_ජූලි_අගෝ_සැප්_ඔක්_නොවැ_දෙසැ".split("_"),weekdays:"ඉරිදා_සඳුදා_අඟහරුවාදා_බදාදා_බ්‍රහස්පතින්දා_සිකුරාදා_සෙනසුරාදා".split("_"),weekdaysShort:"ඉරි_සඳු_අඟ_බදා_බ්‍රහ_සිකු_සෙන".split("_"),weekdaysMin:"ඉ_ස_අ_බ_බ්‍ර_සි_සෙ".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"a h:mm",LTS:"a h:mm:ss",L:"YYYY/MM/DD",LL:"YYYY MMMM D",LLL:"YYYY MMMM D, a h:mm",LLLL:"YYYY MMMM D [වැනි] dddd, a h:mm:ss"},calendar:{sameDay:"[අද] LT[ට]",nextDay:"[හෙට] LT[ට]",nextWeek:"dddd LT[ට]",lastDay:"[ඊයේ] LT[ට]",lastWeek:"[පසුගිය] dddd LT[ට]",sameElse:"L"},relativeTime:{future:"%sකින්",past:"%sකට පෙර",s:"තත්පර කිහිපය",ss:"තත්පර %d",m:"මිනිත්තුව",mm:"මිනිත්තු %d",h:"පැය",hh:"පැය %d",d:"දිනය",dd:"දින %d",M:"මාසය",MM:"මාස %d",y:"වසර",yy:"වසර %d"},dayOfMonthOrdinalParse:/\d{1,2} වැනි/,ordinal:function(e){return e+" වැනි"},meridiemParse:/පෙර වරු|පස් වරු|පෙ.ව|ප.ව./,isPM:function(e){return"ප.ව."===e||"පස් වරු"===e},meridiem:function(e,t,n){return e>11?n?"ප.ව.":"පස් වරු":n?"පෙ.ව.":"පෙර වරු"}})}(n(95093))},5784:function(e,t,n){!function(e){"use strict";var t="január_február_marec_apríl_máj_jún_júl_august_september_október_november_december".split("_"),n="jan_feb_mar_apr_máj_jún_júl_aug_sep_okt_nov_dec".split("_");function r(e){return e>1&&e<5}function a(e,t,n,a){var s=e+" ";switch(n){case"s":return t||a?"pár sekúnd":"pár sekundami";case"ss":return t||a?s+(r(e)?"sekundy":"sekúnd"):s+"sekundami";case"m":return t?"minúta":a?"minútu":"minútou";case"mm":return t||a?s+(r(e)?"minúty":"minút"):s+"minútami";case"h":return t?"hodina":a?"hodinu":"hodinou";case"hh":return t||a?s+(r(e)?"hodiny":"hodín"):s+"hodinami";case"d":return t||a?"deň":"dňom";case"dd":return t||a?s+(r(e)?"dni":"dní"):s+"dňami";case"M":return t||a?"mesiac":"mesiacom";case"MM":return t||a?s+(r(e)?"mesiace":"mesiacov"):s+"mesiacmi";case"y":return t||a?"rok":"rokom";case"yy":return t||a?s+(r(e)?"roky":"rokov"):s+"rokmi"}}e.defineLocale("sk",{months:t,monthsShort:n,weekdays:"nedeľa_pondelok_utorok_streda_štvrtok_piatok_sobota".split("_"),weekdaysShort:"ne_po_ut_st_št_pi_so".split("_"),weekdaysMin:"ne_po_ut_st_št_pi_so".split("_"),longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD.MM.YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY H:mm",LLLL:"dddd D. MMMM YYYY H:mm"},calendar:{sameDay:"[dnes o] LT",nextDay:"[zajtra o] LT",nextWeek:function(){switch(this.day()){case 0:return"[v nedeľu o] LT";case 1:case 2:return"[v] dddd [o] LT";case 3:return"[v stredu o] LT";case 4:return"[vo štvrtok o] LT";case 5:return"[v piatok o] LT";case 6:return"[v sobotu o] LT"}},lastDay:"[včera o] LT",lastWeek:function(){switch(this.day()){case 0:return"[minulú nedeľu o] LT";case 1:case 2:case 4:case 5:return"[minulý] dddd [o] LT";case 3:return"[minulú stredu o] LT";case 6:return"[minulú sobotu o] LT"}},sameElse:"L"},relativeTime:{future:"za %s",past:"pred %s",s:a,ss:a,m:a,mm:a,h:a,hh:a,d:a,dd:a,M:a,MM:a,y:a,yy:a},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:4}})}(n(95093))},46637:function(e,t,n){!function(e){"use strict";function t(e,t,n,r){var a=e+" ";switch(n){case"s":return t||r?"nekaj sekund":"nekaj sekundami";case"ss":return a+=1===e?t?"sekundo":"sekundi":2===e?t||r?"sekundi":"sekundah":e<5?t||r?"sekunde":"sekundah":"sekund";case"m":return t?"ena minuta":"eno minuto";case"mm":return a+=1===e?t?"minuta":"minuto":2===e?t||r?"minuti":"minutama":e<5?t||r?"minute":"minutami":t||r?"minut":"minutami";case"h":return t?"ena ura":"eno uro";case"hh":return a+=1===e?t?"ura":"uro":2===e?t||r?"uri":"urama":e<5?t||r?"ure":"urami":t||r?"ur":"urami";case"d":return t||r?"en dan":"enim dnem";case"dd":return a+=1===e?t||r?"dan":"dnem":2===e?t||r?"dni":"dnevoma":t||r?"dni":"dnevi";case"M":return t||r?"en mesec":"enim mesecem";case"MM":return a+=1===e?t||r?"mesec":"mesecem":2===e?t||r?"meseca":"mesecema":e<5?t||r?"mesece":"meseci":t||r?"mesecev":"meseci";case"y":return t||r?"eno leto":"enim letom";case"yy":return a+=1===e?t||r?"leto":"letom":2===e?t||r?"leti":"letoma":e<5?t||r?"leta":"leti":t||r?"let":"leti"}}e.defineLocale("sl",{months:"januar_februar_marec_april_maj_junij_julij_avgust_september_oktober_november_december".split("_"),monthsShort:"jan._feb._mar._apr._maj._jun._jul._avg._sep._okt._nov._dec.".split("_"),monthsParseExact:!0,weekdays:"nedelja_ponedeljek_torek_sreda_četrtek_petek_sobota".split("_"),weekdaysShort:"ned._pon._tor._sre._čet._pet._sob.".split("_"),weekdaysMin:"ne_po_to_sr_če_pe_so".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD. MM. YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY H:mm",LLLL:"dddd, D. MMMM YYYY H:mm"},calendar:{sameDay:"[danes ob] LT",nextDay:"[jutri ob] LT",nextWeek:function(){switch(this.day()){case 0:return"[v] [nedeljo] [ob] LT";case 3:return"[v] [sredo] [ob] LT";case 6:return"[v] [soboto] [ob] LT";case 1:case 2:case 4:case 5:return"[v] dddd [ob] LT"}},lastDay:"[včeraj ob] LT",lastWeek:function(){switch(this.day()){case 0:return"[prejšnjo] [nedeljo] [ob] LT";case 3:return"[prejšnjo] [sredo] [ob] LT";case 6:return"[prejšnjo] [soboto] [ob] LT";case 1:case 2:case 4:case 5:return"[prejšnji] dddd [ob] LT"}},sameElse:"L"},relativeTime:{future:"čez %s",past:"pred %s",s:t,ss:t,m:t,mm:t,h:t,hh:t,d:t,dd:t,M:t,MM:t,y:t,yy:t},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:7}})}(n(95093))},86794:function(e,t,n){!function(e){"use strict";e.defineLocale("sq",{months:"Janar_Shkurt_Mars_Prill_Maj_Qershor_Korrik_Gusht_Shtator_Tetor_Nëntor_Dhjetor".split("_"),monthsShort:"Jan_Shk_Mar_Pri_Maj_Qer_Kor_Gus_Sht_Tet_Nën_Dhj".split("_"),weekdays:"E Diel_E Hënë_E Martë_E Mërkurë_E Enjte_E Premte_E Shtunë".split("_"),weekdaysShort:"Die_Hën_Mar_Mër_Enj_Pre_Sht".split("_"),weekdaysMin:"D_H_Ma_Më_E_P_Sh".split("_"),weekdaysParseExact:!0,meridiemParse:/PD|MD/,isPM:function(e){return"M"===e.charAt(0)},meridiem:function(e,t,n){return e<12?"PD":"MD"},longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[Sot në] LT",nextDay:"[Nesër në] LT",nextWeek:"dddd [në] LT",lastDay:"[Dje në] LT",lastWeek:"dddd [e kaluar në] LT",sameElse:"L"},relativeTime:{future:"në %s",past:"%s më parë",s:"disa sekonda",ss:"%d sekonda",m:"një minutë",mm:"%d minuta",h:"një orë",hh:"%d orë",d:"një ditë",dd:"%d ditë",M:"një muaj",MM:"%d muaj",y:"një vit",yy:"%d vite"},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:4}})}(n(95093))},3322:function(e,t,n){!function(e){"use strict";var t={words:{ss:["секунда","секунде","секунди"],m:["један минут","једног минута"],mm:["минут","минута","минута"],h:["један сат","једног сата"],hh:["сат","сата","сати"],d:["један дан","једног дана"],dd:["дан","дана","дана"],M:["један месец","једног месеца"],MM:["месец","месеца","месеци"],y:["једну годину","једне године"],yy:["годину","године","година"]},correctGrammaticalCase:function(e,t){return e%10>=1&&e%10<=4&&(e%100<10||e%100>=20)?e%10==1?t[0]:t[1]:t[2]},translate:function(e,n,r,a){var s,i=t.words[r];return 1===r.length?"y"===r&&n?"једна година":a||n?i[0]:i[1]:(s=t.correctGrammaticalCase(e,i),"yy"===r&&n&&"годину"===s?e+" година":e+" "+s)}};e.defineLocale("sr-cyrl",{months:"јануар_фебруар_март_април_мај_јун_јул_август_септембар_октобар_новембар_децембар".split("_"),monthsShort:"јан._феб._мар._апр._мај_јун_јул_авг._сеп._окт._нов._дец.".split("_"),monthsParseExact:!0,weekdays:"недеља_понедељак_уторак_среда_четвртак_петак_субота".split("_"),weekdaysShort:"нед._пон._уто._сре._чет._пет._суб.".split("_"),weekdaysMin:"не_по_ут_ср_че_пе_су".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"D. M. YYYY.",LL:"D. MMMM YYYY.",LLL:"D. MMMM YYYY. H:mm",LLLL:"dddd, D. MMMM YYYY. H:mm"},calendar:{sameDay:"[данас у] LT",nextDay:"[сутра у] LT",nextWeek:function(){switch(this.day()){case 0:return"[у] [недељу] [у] LT";case 3:return"[у] [среду] [у] LT";case 6:return"[у] [суботу] [у] LT";case 1:case 2:case 4:case 5:return"[у] dddd [у] LT"}},lastDay:"[јуче у] LT",lastWeek:function(){return["[прошле] [недеље] [у] LT","[прошлог] [понедељка] [у] LT","[прошлог] [уторка] [у] LT","[прошле] [среде] [у] LT","[прошлог] [четвртка] [у] LT","[прошлог] [петка] [у] LT","[прошле] [суботе] [у] LT"][this.day()]},sameElse:"L"},relativeTime:{future:"за %s",past:"пре %s",s:"неколико секунди",ss:t.translate,m:t.translate,mm:t.translate,h:t.translate,hh:t.translate,d:t.translate,dd:t.translate,M:t.translate,MM:t.translate,y:t.translate,yy:t.translate},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:7}})}(n(95093))},45719:function(e,t,n){!function(e){"use strict";var t={words:{ss:["sekunda","sekunde","sekundi"],m:["jedan minut","jednog minuta"],mm:["minut","minuta","minuta"],h:["jedan sat","jednog sata"],hh:["sat","sata","sati"],d:["jedan dan","jednog dana"],dd:["dan","dana","dana"],M:["jedan mesec","jednog meseca"],MM:["mesec","meseca","meseci"],y:["jednu godinu","jedne godine"],yy:["godinu","godine","godina"]},correctGrammaticalCase:function(e,t){return e%10>=1&&e%10<=4&&(e%100<10||e%100>=20)?e%10==1?t[0]:t[1]:t[2]},translate:function(e,n,r,a){var s,i=t.words[r];return 1===r.length?"y"===r&&n?"jedna godina":a||n?i[0]:i[1]:(s=t.correctGrammaticalCase(e,i),"yy"===r&&n&&"godinu"===s?e+" godina":e+" "+s)}};e.defineLocale("sr",{months:"januar_februar_mart_april_maj_jun_jul_avgust_septembar_oktobar_novembar_decembar".split("_"),monthsShort:"jan._feb._mar._apr._maj_jun_jul_avg._sep._okt._nov._dec.".split("_"),monthsParseExact:!0,weekdays:"nedelja_ponedeljak_utorak_sreda_četvrtak_petak_subota".split("_"),weekdaysShort:"ned._pon._uto._sre._čet._pet._sub.".split("_"),weekdaysMin:"ne_po_ut_sr_če_pe_su".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"D. M. YYYY.",LL:"D. MMMM YYYY.",LLL:"D. MMMM YYYY. H:mm",LLLL:"dddd, D. MMMM YYYY. H:mm"},calendar:{sameDay:"[danas u] LT",nextDay:"[sutra u] LT",nextWeek:function(){switch(this.day()){case 0:return"[u] [nedelju] [u] LT";case 3:return"[u] [sredu] [u] LT";case 6:return"[u] [subotu] [u] LT";case 1:case 2:case 4:case 5:return"[u] dddd [u] LT"}},lastDay:"[juče u] LT",lastWeek:function(){return["[prošle] [nedelje] [u] LT","[prošlog] [ponedeljka] [u] LT","[prošlog] [utorka] [u] LT","[prošle] [srede] [u] LT","[prošlog] [četvrtka] [u] LT","[prošlog] [petka] [u] LT","[prošle] [subote] [u] LT"][this.day()]},sameElse:"L"},relativeTime:{future:"za %s",past:"pre %s",s:"nekoliko sekundi",ss:t.translate,m:t.translate,mm:t.translate,h:t.translate,hh:t.translate,d:t.translate,dd:t.translate,M:t.translate,MM:t.translate,y:t.translate,yy:t.translate},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:7}})}(n(95093))},56e3:function(e,t,n){!function(e){"use strict";e.defineLocale("ss",{months:"Bhimbidvwane_Indlovana_Indlov'lenkhulu_Mabasa_Inkhwekhweti_Inhlaba_Kholwane_Ingci_Inyoni_Imphala_Lweti_Ingongoni".split("_"),monthsShort:"Bhi_Ina_Inu_Mab_Ink_Inh_Kho_Igc_Iny_Imp_Lwe_Igo".split("_"),weekdays:"Lisontfo_Umsombuluko_Lesibili_Lesitsatfu_Lesine_Lesihlanu_Umgcibelo".split("_"),weekdaysShort:"Lis_Umb_Lsb_Les_Lsi_Lsh_Umg".split("_"),weekdaysMin:"Li_Us_Lb_Lt_Ls_Lh_Ug".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"h:mm A",LTS:"h:mm:ss A",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY h:mm A",LLLL:"dddd, D MMMM YYYY h:mm A"},calendar:{sameDay:"[Namuhla nga] LT",nextDay:"[Kusasa nga] LT",nextWeek:"dddd [nga] LT",lastDay:"[Itolo nga] LT",lastWeek:"dddd [leliphelile] [nga] LT",sameElse:"L"},relativeTime:{future:"nga %s",past:"wenteka nga %s",s:"emizuzwana lomcane",ss:"%d mzuzwana",m:"umzuzu",mm:"%d emizuzu",h:"lihora",hh:"%d emahora",d:"lilanga",dd:"%d emalanga",M:"inyanga",MM:"%d tinyanga",y:"umnyaka",yy:"%d iminyaka"},meridiemParse:/ekuseni|emini|entsambama|ebusuku/,meridiem:function(e,t,n){return e<11?"ekuseni":e<15?"emini":e<19?"entsambama":"ebusuku"},meridiemHour:function(e,t){return 12===e&&(e=0),"ekuseni"===t?e:"emini"===t?e>=11?e:e+12:"entsambama"===t||"ebusuku"===t?0===e?0:e+12:void 0},dayOfMonthOrdinalParse:/\d{1,2}/,ordinal:"%d",week:{dow:1,doy:4}})}(n(95093))},41011:function(e,t,n){!function(e){"use strict";e.defineLocale("sv",{months:"januari_februari_mars_april_maj_juni_juli_augusti_september_oktober_november_december".split("_"),monthsShort:"jan_feb_mar_apr_maj_jun_jul_aug_sep_okt_nov_dec".split("_"),weekdays:"söndag_måndag_tisdag_onsdag_torsdag_fredag_lördag".split("_"),weekdaysShort:"sön_mån_tis_ons_tor_fre_lör".split("_"),weekdaysMin:"sö_må_ti_on_to_fr_lö".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"YYYY-MM-DD",LL:"D MMMM YYYY",LLL:"D MMMM YYYY [kl.] HH:mm",LLLL:"dddd D MMMM YYYY [kl.] HH:mm",lll:"D MMM YYYY HH:mm",llll:"ddd D MMM YYYY HH:mm"},calendar:{sameDay:"[Idag] LT",nextDay:"[Imorgon] LT",lastDay:"[Igår] LT",nextWeek:"[På] dddd LT",lastWeek:"[I] dddd[s] LT",sameElse:"L"},relativeTime:{future:"om %s",past:"för %s sedan",s:"några sekunder",ss:"%d sekunder",m:"en minut",mm:"%d minuter",h:"en timme",hh:"%d timmar",d:"en dag",dd:"%d dagar",M:"en månad",MM:"%d månader",y:"ett år",yy:"%d år"},dayOfMonthOrdinalParse:/\d{1,2}(\:e|\:a)/,ordinal:function(e){var t=e%10;return e+(1==~~(e%100/10)?":e":1===t||2===t?":a":":e")},week:{dow:1,doy:4}})}(n(95093))},40748:function(e,t,n){!function(e){"use strict";e.defineLocale("sw",{months:"Januari_Februari_Machi_Aprili_Mei_Juni_Julai_Agosti_Septemba_Oktoba_Novemba_Desemba".split("_"),monthsShort:"Jan_Feb_Mac_Apr_Mei_Jun_Jul_Ago_Sep_Okt_Nov_Des".split("_"),weekdays:"Jumapili_Jumatatu_Jumanne_Jumatano_Alhamisi_Ijumaa_Jumamosi".split("_"),weekdaysShort:"Jpl_Jtat_Jnne_Jtan_Alh_Ijm_Jmos".split("_"),weekdaysMin:"J2_J3_J4_J5_Al_Ij_J1".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"hh:mm A",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[leo saa] LT",nextDay:"[kesho saa] LT",nextWeek:"[wiki ijayo] dddd [saat] LT",lastDay:"[jana] LT",lastWeek:"[wiki iliyopita] dddd [saat] LT",sameElse:"L"},relativeTime:{future:"%s baadaye",past:"tokea %s",s:"hivi punde",ss:"sekunde %d",m:"dakika moja",mm:"dakika %d",h:"saa limoja",hh:"masaa %d",d:"siku moja",dd:"siku %d",M:"mwezi mmoja",MM:"miezi %d",y:"mwaka mmoja",yy:"miaka %d"},week:{dow:1,doy:7}})}(n(95093))},11025:function(e,t,n){!function(e){"use strict";var t={1:"௧",2:"௨",3:"௩",4:"௪",5:"௫",6:"௬",7:"௭",8:"௮",9:"௯",0:"௦"},n={"௧":"1","௨":"2","௩":"3","௪":"4","௫":"5","௬":"6","௭":"7","௮":"8","௯":"9","௦":"0"};e.defineLocale("ta",{months:"ஜனவரி_பிப்ரவரி_மார்ச்_ஏப்ரல்_மே_ஜூன்_ஜூலை_ஆகஸ்ட்_செப்டெம்பர்_அக்டோபர்_நவம்பர்_டிசம்பர்".split("_"),monthsShort:"ஜனவரி_பிப்ரவரி_மார்ச்_ஏப்ரல்_மே_ஜூன்_ஜூலை_ஆகஸ்ட்_செப்டெம்பர்_அக்டோபர்_நவம்பர்_டிசம்பர்".split("_"),weekdays:"ஞாயிற்றுக்கிழமை_திங்கட்கிழமை_செவ்வாய்கிழமை_புதன்கிழமை_வியாழக்கிழமை_வெள்ளிக்கிழமை_சனிக்கிழமை".split("_"),weekdaysShort:"ஞாயிறு_திங்கள்_செவ்வாய்_புதன்_வியாழன்_வெள்ளி_சனி".split("_"),weekdaysMin:"ஞா_தி_செ_பு_வி_வெ_ச".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY, HH:mm",LLLL:"dddd, D MMMM YYYY, HH:mm"},calendar:{sameDay:"[இன்று] LT",nextDay:"[நாளை] LT",nextWeek:"dddd, LT",lastDay:"[நேற்று] LT",lastWeek:"[கடந்த வாரம்] dddd, LT",sameElse:"L"},relativeTime:{future:"%s இல்",past:"%s முன்",s:"ஒரு சில விநாடிகள்",ss:"%d விநாடிகள்",m:"ஒரு நிமிடம்",mm:"%d நிமிடங்கள்",h:"ஒரு மணி நேரம்",hh:"%d மணி நேரம்",d:"ஒரு நாள்",dd:"%d நாட்கள்",M:"ஒரு மாதம்",MM:"%d மாதங்கள்",y:"ஒரு வருடம்",yy:"%d ஆண்டுகள்"},dayOfMonthOrdinalParse:/\d{1,2}வது/,ordinal:function(e){return e+"வது"},preparse:function(e){return e.replace(/[௧௨௩௪௫௬௭௮௯௦]/g,(function(e){return n[e]}))},postformat:function(e){return e.replace(/\d/g,(function(e){return t[e]}))},meridiemParse:/யாமம்|வைகறை|காலை|நண்பகல்|எற்பாடு|மாலை/,meridiem:function(e,t,n){return e<2?" யாமம்":e<6?" வைகறை":e<10?" காலை":e<14?" நண்பகல்":e<18?" எற்பாடு":e<22?" மாலை":" யாமம்"},meridiemHour:function(e,t){return 12===e&&(e=0),"யாமம்"===t?e<2?e:e+12:"வைகறை"===t||"காலை"===t||"நண்பகல்"===t&&e>=10?e:e+12},week:{dow:0,doy:6}})}(n(95093))},11885:function(e,t,n){!function(e){"use strict";e.defineLocale("te",{months:"జనవరి_ఫిబ్రవరి_మార్చి_ఏప్రిల్_మే_జూన్_జులై_ఆగస్టు_సెప్టెంబర్_అక్టోబర్_నవంబర్_డిసెంబర్".split("_"),monthsShort:"జన._ఫిబ్ర._మార్చి_ఏప్రి._మే_జూన్_జులై_ఆగ._సెప్._అక్టో._నవ._డిసె.".split("_"),monthsParseExact:!0,weekdays:"ఆదివారం_సోమవారం_మంగళవారం_బుధవారం_గురువారం_శుక్రవారం_శనివారం".split("_"),weekdaysShort:"ఆది_సోమ_మంగళ_బుధ_గురు_శుక్ర_శని".split("_"),weekdaysMin:"ఆ_సో_మం_బు_గు_శు_శ".split("_"),longDateFormat:{LT:"A h:mm",LTS:"A h:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY, A h:mm",LLLL:"dddd, D MMMM YYYY, A h:mm"},calendar:{sameDay:"[నేడు] LT",nextDay:"[రేపు] LT",nextWeek:"dddd, LT",lastDay:"[నిన్న] LT",lastWeek:"[గత] dddd, LT",sameElse:"L"},relativeTime:{future:"%s లో",past:"%s క్రితం",s:"కొన్ని క్షణాలు",ss:"%d సెకన్లు",m:"ఒక నిమిషం",mm:"%d నిమిషాలు",h:"ఒక గంట",hh:"%d గంటలు",d:"ఒక రోజు",dd:"%d రోజులు",M:"ఒక నెల",MM:"%d నెలలు",y:"ఒక సంవత్సరం",yy:"%d సంవత్సరాలు"},dayOfMonthOrdinalParse:/\d{1,2}వ/,ordinal:"%dవ",meridiemParse:/రాత్రి|ఉదయం|మధ్యాహ్నం|సాయంత్రం/,meridiemHour:function(e,t){return 12===e&&(e=0),"రాత్రి"===t?e<4?e:e+12:"ఉదయం"===t?e:"మధ్యాహ్నం"===t?e>=10?e:e+12:"సాయంత్రం"===t?e+12:void 0},meridiem:function(e,t,n){return e<4?"రాత్రి":e<10?"ఉదయం":e<17?"మధ్యాహ్నం":e<20?"సాయంత్రం":"రాత్రి"},week:{dow:0,doy:6}})}(n(95093))},28861:function(e,t,n){!function(e){"use strict";e.defineLocale("tet",{months:"Janeiru_Fevereiru_Marsu_Abril_Maiu_Juñu_Jullu_Agustu_Setembru_Outubru_Novembru_Dezembru".split("_"),monthsShort:"Jan_Fev_Mar_Abr_Mai_Jun_Jul_Ago_Set_Out_Nov_Dez".split("_"),weekdays:"Domingu_Segunda_Tersa_Kuarta_Kinta_Sesta_Sabadu".split("_"),weekdaysShort:"Dom_Seg_Ters_Kua_Kint_Sest_Sab".split("_"),weekdaysMin:"Do_Seg_Te_Ku_Ki_Ses_Sa".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[Ohin iha] LT",nextDay:"[Aban iha] LT",nextWeek:"dddd [iha] LT",lastDay:"[Horiseik iha] LT",lastWeek:"dddd [semana kotuk] [iha] LT",sameElse:"L"},relativeTime:{future:"iha %s",past:"%s liuba",s:"segundu balun",ss:"segundu %d",m:"minutu ida",mm:"minutu %d",h:"oras ida",hh:"oras %d",d:"loron ida",dd:"loron %d",M:"fulan ida",MM:"fulan %d",y:"tinan ida",yy:"tinan %d"},dayOfMonthOrdinalParse:/\d{1,2}(st|nd|rd|th)/,ordinal:function(e){var t=e%10;return e+(1==~~(e%100/10)?"th":1===t?"st":2===t?"nd":3===t?"rd":"th")},week:{dow:1,doy:4}})}(n(95093))},86571:function(e,t,n){!function(e){"use strict";var t={0:"-ум",1:"-ум",2:"-юм",3:"-юм",4:"-ум",5:"-ум",6:"-ум",7:"-ум",8:"-ум",9:"-ум",10:"-ум",12:"-ум",13:"-ум",20:"-ум",30:"-юм",40:"-ум",50:"-ум",60:"-ум",70:"-ум",80:"-ум",90:"-ум",100:"-ум"};e.defineLocale("tg",{months:{format:"январи_феврали_марти_апрели_майи_июни_июли_августи_сентябри_октябри_ноябри_декабри".split("_"),standalone:"январ_феврал_март_апрел_май_июн_июл_август_сентябр_октябр_ноябр_декабр".split("_")},monthsShort:"янв_фев_мар_апр_май_июн_июл_авг_сен_окт_ноя_дек".split("_"),weekdays:"якшанбе_душанбе_сешанбе_чоршанбе_панҷшанбе_ҷумъа_шанбе".split("_"),weekdaysShort:"яшб_дшб_сшб_чшб_пшб_ҷум_шнб".split("_"),weekdaysMin:"яш_дш_сш_чш_пш_ҷм_шб".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[Имрӯз соати] LT",nextDay:"[Фардо соати] LT",lastDay:"[Дирӯз соати] LT",nextWeek:"dddd[и] [ҳафтаи оянда соати] LT",lastWeek:"dddd[и] [ҳафтаи гузашта соати] LT",sameElse:"L"},relativeTime:{future:"баъди %s",past:"%s пеш",s:"якчанд сония",m:"як дақиқа",mm:"%d дақиқа",h:"як соат",hh:"%d соат",d:"як рӯз",dd:"%d рӯз",M:"як моҳ",MM:"%d моҳ",y:"як сол",yy:"%d сол"},meridiemParse:/шаб|субҳ|рӯз|бегоҳ/,meridiemHour:function(e,t){return 12===e&&(e=0),"шаб"===t?e<4?e:e+12:"субҳ"===t?e:"рӯз"===t?e>=11?e:e+12:"бегоҳ"===t?e+12:void 0},meridiem:function(e,t,n){return e<4?"шаб":e<11?"субҳ":e<16?"рӯз":e<19?"бегоҳ":"шаб"},dayOfMonthOrdinalParse:/\d{1,2}-(ум|юм)/,ordinal:function(e){var n=e%10,r=e>=100?100:null;return e+(t[e]||t[n]||t[r])},week:{dow:1,doy:7}})}(n(95093))},55802:function(e,t,n){!function(e){"use strict";e.defineLocale("th",{months:"มกราคม_กุมภาพันธ์_มีนาคม_เมษายน_พฤษภาคม_มิถุนายน_กรกฎาคม_สิงหาคม_กันยายน_ตุลาคม_พฤศจิกายน_ธันวาคม".split("_"),monthsShort:"ม.ค._ก.พ._มี.ค._เม.ย._พ.ค._มิ.ย._ก.ค._ส.ค._ก.ย._ต.ค._พ.ย._ธ.ค.".split("_"),monthsParseExact:!0,weekdays:"อาทิตย์_จันทร์_อังคาร_พุธ_พฤหัสบดี_ศุกร์_เสาร์".split("_"),weekdaysShort:"อาทิตย์_จันทร์_อังคาร_พุธ_พฤหัส_ศุกร์_เสาร์".split("_"),weekdaysMin:"อา._จ._อ._พ._พฤ._ศ._ส.".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY เวลา H:mm",LLLL:"วันddddที่ D MMMM YYYY เวลา H:mm"},meridiemParse:/ก่อนเที่ยง|หลังเที่ยง/,isPM:function(e){return"หลังเที่ยง"===e},meridiem:function(e,t,n){return e<12?"ก่อนเที่ยง":"หลังเที่ยง"},calendar:{sameDay:"[วันนี้ เวลา] LT",nextDay:"[พรุ่งนี้ เวลา] LT",nextWeek:"dddd[หน้า เวลา] LT",lastDay:"[เมื่อวานนี้ เวลา] LT",lastWeek:"[วัน]dddd[ที่แล้ว เวลา] LT",sameElse:"L"},relativeTime:{future:"อีก %s",past:"%sที่แล้ว",s:"ไม่กี่วินาที",ss:"%d วินาที",m:"1 นาที",mm:"%d นาที",h:"1 ชั่วโมง",hh:"%d ชั่วโมง",d:"1 วัน",dd:"%d วัน",w:"1 สัปดาห์",ww:"%d สัปดาห์",M:"1 เดือน",MM:"%d เดือน",y:"1 ปี",yy:"%d ปี"}})}(n(95093))},59527:function(e,t,n){!function(e){"use strict";var t={1:"'inji",5:"'inji",8:"'inji",70:"'inji",80:"'inji",2:"'nji",7:"'nji",20:"'nji",50:"'nji",3:"'ünji",4:"'ünji",100:"'ünji",6:"'njy",9:"'unjy",10:"'unjy",30:"'unjy",60:"'ynjy",90:"'ynjy"};e.defineLocale("tk",{months:"Ýanwar_Fewral_Mart_Aprel_Maý_Iýun_Iýul_Awgust_Sentýabr_Oktýabr_Noýabr_Dekabr".split("_"),monthsShort:"Ýan_Few_Mar_Apr_Maý_Iýn_Iýl_Awg_Sen_Okt_Noý_Dek".split("_"),weekdays:"Ýekşenbe_Duşenbe_Sişenbe_Çarşenbe_Penşenbe_Anna_Şenbe".split("_"),weekdaysShort:"Ýek_Duş_Siş_Çar_Pen_Ann_Şen".split("_"),weekdaysMin:"Ýk_Dş_Sş_Çr_Pn_An_Şn".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[bugün sagat] LT",nextDay:"[ertir sagat] LT",nextWeek:"[indiki] dddd [sagat] LT",lastDay:"[düýn] LT",lastWeek:"[geçen] dddd [sagat] LT",sameElse:"L"},relativeTime:{future:"%s soň",past:"%s öň",s:"birnäçe sekunt",m:"bir minut",mm:"%d minut",h:"bir sagat",hh:"%d sagat",d:"bir gün",dd:"%d gün",M:"bir aý",MM:"%d aý",y:"bir ýyl",yy:"%d ýyl"},ordinal:function(e,n){switch(n){case"d":case"D":case"Do":case"DD":return e;default:if(0===e)return e+"'unjy";var r=e%10,a=e%100-r,s=e>=100?100:null;return e+(t[r]||t[a]||t[s])}},week:{dow:1,doy:7}})}(n(95093))},29231:function(e,t,n){!function(e){"use strict";e.defineLocale("tl-ph",{months:"Enero_Pebrero_Marso_Abril_Mayo_Hunyo_Hulyo_Agosto_Setyembre_Oktubre_Nobyembre_Disyembre".split("_"),monthsShort:"Ene_Peb_Mar_Abr_May_Hun_Hul_Ago_Set_Okt_Nob_Dis".split("_"),weekdays:"Linggo_Lunes_Martes_Miyerkules_Huwebes_Biyernes_Sabado".split("_"),weekdaysShort:"Lin_Lun_Mar_Miy_Huw_Biy_Sab".split("_"),weekdaysMin:"Li_Lu_Ma_Mi_Hu_Bi_Sab".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"MM/D/YYYY",LL:"MMMM D, YYYY",LLL:"MMMM D, YYYY HH:mm",LLLL:"dddd, MMMM DD, YYYY HH:mm"},calendar:{sameDay:"LT [ngayong araw]",nextDay:"[Bukas ng] LT",nextWeek:"LT [sa susunod na] dddd",lastDay:"LT [kahapon]",lastWeek:"LT [noong nakaraang] dddd",sameElse:"L"},relativeTime:{future:"sa loob ng %s",past:"%s ang nakalipas",s:"ilang segundo",ss:"%d segundo",m:"isang minuto",mm:"%d minuto",h:"isang oras",hh:"%d oras",d:"isang araw",dd:"%d araw",M:"isang buwan",MM:"%d buwan",y:"isang taon",yy:"%d taon"},dayOfMonthOrdinalParse:/\d{1,2}/,ordinal:function(e){return e},week:{dow:1,doy:4}})}(n(95093))},31052:function(e,t,n){!function(e){"use strict";var t="pagh_wa’_cha’_wej_loS_vagh_jav_Soch_chorgh_Hut".split("_");function n(e){var t=e;return t=-1!==e.indexOf("jaj")?t.slice(0,-3)+"leS":-1!==e.indexOf("jar")?t.slice(0,-3)+"waQ":-1!==e.indexOf("DIS")?t.slice(0,-3)+"nem":t+" pIq"}function r(e){var t=e;return t=-1!==e.indexOf("jaj")?t.slice(0,-3)+"Hu’":-1!==e.indexOf("jar")?t.slice(0,-3)+"wen":-1!==e.indexOf("DIS")?t.slice(0,-3)+"ben":t+" ret"}function a(e,t,n,r){var a=s(e);switch(n){case"ss":return a+" lup";case"mm":return a+" tup";case"hh":return a+" rep";case"dd":return a+" jaj";case"MM":return a+" jar";case"yy":return a+" DIS"}}function s(e){var n=Math.floor(e%1e3/100),r=Math.floor(e%100/10),a=e%10,s="";return n>0&&(s+=t[n]+"vatlh"),r>0&&(s+=(""!==s?" ":"")+t[r]+"maH"),a>0&&(s+=(""!==s?" ":"")+t[a]),""===s?"pagh":s}e.defineLocale("tlh",{months:"tera’ jar wa’_tera’ jar cha’_tera’ jar wej_tera’ jar loS_tera’ jar vagh_tera’ jar jav_tera’ jar Soch_tera’ jar chorgh_tera’ jar Hut_tera’ jar wa’maH_tera’ jar wa’maH wa’_tera’ jar wa’maH cha’".split("_"),monthsShort:"jar wa’_jar cha’_jar wej_jar loS_jar vagh_jar jav_jar Soch_jar chorgh_jar Hut_jar wa’maH_jar wa’maH wa’_jar wa’maH cha’".split("_"),monthsParseExact:!0,weekdays:"lojmItjaj_DaSjaj_povjaj_ghItlhjaj_loghjaj_buqjaj_ghInjaj".split("_"),weekdaysShort:"lojmItjaj_DaSjaj_povjaj_ghItlhjaj_loghjaj_buqjaj_ghInjaj".split("_"),weekdaysMin:"lojmItjaj_DaSjaj_povjaj_ghItlhjaj_loghjaj_buqjaj_ghInjaj".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[DaHjaj] LT",nextDay:"[wa’leS] LT",nextWeek:"LLL",lastDay:"[wa’Hu’] LT",lastWeek:"LLL",sameElse:"L"},relativeTime:{future:n,past:r,s:"puS lup",ss:a,m:"wa’ tup",mm:a,h:"wa’ rep",hh:a,d:"wa’ jaj",dd:a,M:"wa’ jar",MM:a,y:"wa’ DIS",yy:a},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:4}})}(n(95093))},85096:function(e,t,n){!function(e){"use strict";var t={1:"'inci",5:"'inci",8:"'inci",70:"'inci",80:"'inci",2:"'nci",7:"'nci",20:"'nci",50:"'nci",3:"'üncü",4:"'üncü",100:"'üncü",6:"'ncı",9:"'uncu",10:"'uncu",30:"'uncu",60:"'ıncı",90:"'ıncı"};e.defineLocale("tr",{months:"Ocak_Şubat_Mart_Nisan_Mayıs_Haziran_Temmuz_Ağustos_Eylül_Ekim_Kasım_Aralık".split("_"),monthsShort:"Oca_Şub_Mar_Nis_May_Haz_Tem_Ağu_Eyl_Eki_Kas_Ara".split("_"),weekdays:"Pazar_Pazartesi_Salı_Çarşamba_Perşembe_Cuma_Cumartesi".split("_"),weekdaysShort:"Paz_Pzt_Sal_Çar_Per_Cum_Cmt".split("_"),weekdaysMin:"Pz_Pt_Sa_Ça_Pe_Cu_Ct".split("_"),meridiem:function(e,t,n){return e<12?n?"öö":"ÖÖ":n?"ös":"ÖS"},meridiemParse:/öö|ÖÖ|ös|ÖS/,isPM:function(e){return"ös"===e||"ÖS"===e},longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[bugün saat] LT",nextDay:"[yarın saat] LT",nextWeek:"[gelecek] dddd [saat] LT",lastDay:"[dün] LT",lastWeek:"[geçen] dddd [saat] LT",sameElse:"L"},relativeTime:{future:"%s sonra",past:"%s önce",s:"birkaç saniye",ss:"%d saniye",m:"bir dakika",mm:"%d dakika",h:"bir saat",hh:"%d saat",d:"bir gün",dd:"%d gün",w:"bir hafta",ww:"%d hafta",M:"bir ay",MM:"%d ay",y:"bir yıl",yy:"%d yıl"},ordinal:function(e,n){switch(n){case"d":case"D":case"Do":case"DD":return e;default:if(0===e)return e+"'ıncı";var r=e%10,a=e%100-r,s=e>=100?100:null;return e+(t[r]||t[a]||t[s])}},week:{dow:1,doy:7}})}(n(95093))},79846:function(e,t,n){!function(e){"use strict";function t(e,t,n,r){var a={s:["viensas secunds","'iensas secunds"],ss:[e+" secunds",e+" secunds"],m:["'n míut","'iens míut"],mm:[e+" míuts",e+" míuts"],h:["'n þora","'iensa þora"],hh:[e+" þoras",e+" þoras"],d:["'n ziua","'iensa ziua"],dd:[e+" ziuas",e+" ziuas"],M:["'n mes","'iens mes"],MM:[e+" mesen",e+" mesen"],y:["'n ar","'iens ar"],yy:[e+" ars",e+" ars"]};return r||t?a[n][0]:a[n][1]}e.defineLocale("tzl",{months:"Januar_Fevraglh_Març_Avrïu_Mai_Gün_Julia_Guscht_Setemvar_Listopäts_Noemvar_Zecemvar".split("_"),monthsShort:"Jan_Fev_Mar_Avr_Mai_Gün_Jul_Gus_Set_Lis_Noe_Zec".split("_"),weekdays:"Súladi_Lúneçi_Maitzi_Márcuri_Xhúadi_Viénerçi_Sáturi".split("_"),weekdaysShort:"Súl_Lún_Mai_Már_Xhú_Vié_Sát".split("_"),weekdaysMin:"Sú_Lú_Ma_Má_Xh_Vi_Sá".split("_"),longDateFormat:{LT:"HH.mm",LTS:"HH.mm.ss",L:"DD.MM.YYYY",LL:"D. MMMM [dallas] YYYY",LLL:"D. MMMM [dallas] YYYY HH.mm",LLLL:"dddd, [li] D. MMMM [dallas] YYYY HH.mm"},meridiemParse:/d\'o|d\'a/i,isPM:function(e){return"d'o"===e.toLowerCase()},meridiem:function(e,t,n){return e>11?n?"d'o":"D'O":n?"d'a":"D'A"},calendar:{sameDay:"[oxhi à] LT",nextDay:"[demà à] LT",nextWeek:"dddd [à] LT",lastDay:"[ieiri à] LT",lastWeek:"[sür el] dddd [lasteu à] LT",sameElse:"L"},relativeTime:{future:"osprei %s",past:"ja%s",s:t,ss:t,m:t,mm:t,h:t,hh:t,d:t,dd:t,M:t,MM:t,y:t,yy:t},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:4}})}(n(95093))},97711:function(e,t,n){!function(e){"use strict";e.defineLocale("tzm-latn",{months:"innayr_brˤayrˤ_marˤsˤ_ibrir_mayyw_ywnyw_ywlywz_ɣwšt_šwtanbir_ktˤwbrˤ_nwwanbir_dwjnbir".split("_"),monthsShort:"innayr_brˤayrˤ_marˤsˤ_ibrir_mayyw_ywnyw_ywlywz_ɣwšt_šwtanbir_ktˤwbrˤ_nwwanbir_dwjnbir".split("_"),weekdays:"asamas_aynas_asinas_akras_akwas_asimwas_asiḍyas".split("_"),weekdaysShort:"asamas_aynas_asinas_akras_akwas_asimwas_asiḍyas".split("_"),weekdaysMin:"asamas_aynas_asinas_akras_akwas_asimwas_asiḍyas".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},calendar:{sameDay:"[asdkh g] LT",nextDay:"[aska g] LT",nextWeek:"dddd [g] LT",lastDay:"[assant g] LT",lastWeek:"dddd [g] LT",sameElse:"L"},relativeTime:{future:"dadkh s yan %s",past:"yan %s",s:"imik",ss:"%d imik",m:"minuḍ",mm:"%d minuḍ",h:"saɛa",hh:"%d tassaɛin",d:"ass",dd:"%d ossan",M:"ayowr",MM:"%d iyyirn",y:"asgas",yy:"%d isgasn"},week:{dow:6,doy:12}})}(n(95093))},81765:function(e,t,n){!function(e){"use strict";e.defineLocale("tzm",{months:"ⵉⵏⵏⴰⵢⵔ_ⴱⵕⴰⵢⵕ_ⵎⴰⵕⵚ_ⵉⴱⵔⵉⵔ_ⵎⴰⵢⵢⵓ_ⵢⵓⵏⵢⵓ_ⵢⵓⵍⵢⵓⵣ_ⵖⵓⵛⵜ_ⵛⵓⵜⴰⵏⴱⵉⵔ_ⴽⵟⵓⴱⵕ_ⵏⵓⵡⴰⵏⴱⵉⵔ_ⴷⵓⵊⵏⴱⵉⵔ".split("_"),monthsShort:"ⵉⵏⵏⴰⵢⵔ_ⴱⵕⴰⵢⵕ_ⵎⴰⵕⵚ_ⵉⴱⵔⵉⵔ_ⵎⴰⵢⵢⵓ_ⵢⵓⵏⵢⵓ_ⵢⵓⵍⵢⵓⵣ_ⵖⵓⵛⵜ_ⵛⵓⵜⴰⵏⴱⵉⵔ_ⴽⵟⵓⴱⵕ_ⵏⵓⵡⴰⵏⴱⵉⵔ_ⴷⵓⵊⵏⴱⵉⵔ".split("_"),weekdays:"ⴰⵙⴰⵎⴰⵙ_ⴰⵢⵏⴰⵙ_ⴰⵙⵉⵏⴰⵙ_ⴰⴽⵔⴰⵙ_ⴰⴽⵡⴰⵙ_ⴰⵙⵉⵎⵡⴰⵙ_ⴰⵙⵉⴹⵢⴰⵙ".split("_"),weekdaysShort:"ⴰⵙⴰⵎⴰⵙ_ⴰⵢⵏⴰⵙ_ⴰⵙⵉⵏⴰⵙ_ⴰⴽⵔⴰⵙ_ⴰⴽⵡⴰⵙ_ⴰⵙⵉⵎⵡⴰⵙ_ⴰⵙⵉⴹⵢⴰⵙ".split("_"),weekdaysMin:"ⴰⵙⴰⵎⴰⵙ_ⴰⵢⵏⴰⵙ_ⴰⵙⵉⵏⴰⵙ_ⴰⴽⵔⴰⵙ_ⴰⴽⵡⴰⵙ_ⴰⵙⵉⵎⵡⴰⵙ_ⴰⵙⵉⴹⵢⴰⵙ".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},calendar:{sameDay:"[ⴰⵙⴷⵅ ⴴ] LT",nextDay:"[ⴰⵙⴽⴰ ⴴ] LT",nextWeek:"dddd [ⴴ] LT",lastDay:"[ⴰⵚⴰⵏⵜ ⴴ] LT",lastWeek:"dddd [ⴴ] LT",sameElse:"L"},relativeTime:{future:"ⴷⴰⴷⵅ ⵙ ⵢⴰⵏ %s",past:"ⵢⴰⵏ %s",s:"ⵉⵎⵉⴽ",ss:"%d ⵉⵎⵉⴽ",m:"ⵎⵉⵏⵓⴺ",mm:"%d ⵎⵉⵏⵓⴺ",h:"ⵙⴰⵄⴰ",hh:"%d ⵜⴰⵙⵙⴰⵄⵉⵏ",d:"ⴰⵙⵙ",dd:"%d oⵙⵙⴰⵏ",M:"ⴰⵢoⵓⵔ",MM:"%d ⵉⵢⵢⵉⵔⵏ",y:"ⴰⵙⴳⴰⵙ",yy:"%d ⵉⵙⴳⴰⵙⵏ"},week:{dow:6,doy:12}})}(n(95093))},48414:function(e,t,n){!function(e){"use strict";e.defineLocale("ug-cn",{months:"يانۋار_فېۋرال_مارت_ئاپرېل_ماي_ئىيۇن_ئىيۇل_ئاۋغۇست_سېنتەبىر_ئۆكتەبىر_نويابىر_دېكابىر".split("_"),monthsShort:"يانۋار_فېۋرال_مارت_ئاپرېل_ماي_ئىيۇن_ئىيۇل_ئاۋغۇست_سېنتەبىر_ئۆكتەبىر_نويابىر_دېكابىر".split("_"),weekdays:"يەكشەنبە_دۈشەنبە_سەيشەنبە_چارشەنبە_پەيشەنبە_جۈمە_شەنبە".split("_"),weekdaysShort:"يە_دۈ_سە_چا_پە_جۈ_شە".split("_"),weekdaysMin:"يە_دۈ_سە_چا_پە_جۈ_شە".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"YYYY-MM-DD",LL:"YYYY-يىلىM-ئاينىڭD-كۈنى",LLL:"YYYY-يىلىM-ئاينىڭD-كۈنى، HH:mm",LLLL:"dddd، YYYY-يىلىM-ئاينىڭD-كۈنى، HH:mm"},meridiemParse:/يېرىم كېچە|سەھەر|چۈشتىن بۇرۇن|چۈش|چۈشتىن كېيىن|كەچ/,meridiemHour:function(e,t){return 12===e&&(e=0),"يېرىم كېچە"===t||"سەھەر"===t||"چۈشتىن بۇرۇن"===t?e:"چۈشتىن كېيىن"===t||"كەچ"===t?e+12:e>=11?e:e+12},meridiem:function(e,t,n){var r=100*e+t;return r<600?"يېرىم كېچە":r<900?"سەھەر":r<1130?"چۈشتىن بۇرۇن":r<1230?"چۈش":r<1800?"چۈشتىن كېيىن":"كەچ"},calendar:{sameDay:"[بۈگۈن سائەت] LT",nextDay:"[ئەتە سائەت] LT",nextWeek:"[كېلەركى] dddd [سائەت] LT",lastDay:"[تۆنۈگۈن] LT",lastWeek:"[ئالدىنقى] dddd [سائەت] LT",sameElse:"L"},relativeTime:{future:"%s كېيىن",past:"%s بۇرۇن",s:"نەچچە سېكونت",ss:"%d سېكونت",m:"بىر مىنۇت",mm:"%d مىنۇت",h:"بىر سائەت",hh:"%d سائەت",d:"بىر كۈن",dd:"%d كۈن",M:"بىر ئاي",MM:"%d ئاي",y:"بىر يىل",yy:"%d يىل"},dayOfMonthOrdinalParse:/\d{1,2}(-كۈنى|-ئاي|-ھەپتە)/,ordinal:function(e,t){switch(t){case"d":case"D":case"DDD":return e+"-كۈنى";case"w":case"W":return e+"-ھەپتە";default:return e}},preparse:function(e){return e.replace(/،/g,",")},postformat:function(e){return e.replace(/,/g,"،")},week:{dow:1,doy:7}})}(n(95093))},16618:function(e,t,n){!function(e){"use strict";function t(e,t){var n=e.split("_");return t%10==1&&t%100!=11?n[0]:t%10>=2&&t%10<=4&&(t%100<10||t%100>=20)?n[1]:n[2]}function n(e,n,r){return"m"===r?n?"хвилина":"хвилину":"h"===r?n?"година":"годину":e+" "+t({ss:n?"секунда_секунди_секунд":"секунду_секунди_секунд",mm:n?"хвилина_хвилини_хвилин":"хвилину_хвилини_хвилин",hh:n?"година_години_годин":"годину_години_годин",dd:"день_дні_днів",MM:"місяць_місяці_місяців",yy:"рік_роки_років"}[r],+e)}function r(e,t){var n={nominative:"неділя_понеділок_вівторок_середа_четвер_п’ятниця_субота".split("_"),accusative:"неділю_понеділок_вівторок_середу_четвер_п’ятницю_суботу".split("_"),genitive:"неділі_понеділка_вівторка_середи_четверга_п’ятниці_суботи".split("_")};return!0===e?n.nominative.slice(1,7).concat(n.nominative.slice(0,1)):e?n[/(\[[ВвУу]\]) ?dddd/.test(t)?"accusative":/\[?(?:минулої|наступної)? ?\] ?dddd/.test(t)?"genitive":"nominative"][e.day()]:n.nominative}function a(e){return function(){return e+"о"+(11===this.hours()?"б":"")+"] LT"}}e.defineLocale("uk",{months:{format:"січня_лютого_березня_квітня_травня_червня_липня_серпня_вересня_жовтня_листопада_грудня".split("_"),standalone:"січень_лютий_березень_квітень_травень_червень_липень_серпень_вересень_жовтень_листопад_грудень".split("_")},monthsShort:"січ_лют_бер_квіт_трав_черв_лип_серп_вер_жовт_лист_груд".split("_"),weekdays:r,weekdaysShort:"нд_пн_вт_ср_чт_пт_сб".split("_"),weekdaysMin:"нд_пн_вт_ср_чт_пт_сб".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY р.",LLL:"D MMMM YYYY р., HH:mm",LLLL:"dddd, D MMMM YYYY р., HH:mm"},calendar:{sameDay:a("[Сьогодні "),nextDay:a("[Завтра "),lastDay:a("[Вчора "),nextWeek:a("[У] dddd ["),lastWeek:function(){switch(this.day()){case 0:case 3:case 5:case 6:return a("[Минулої] dddd [").call(this);case 1:case 2:case 4:return a("[Минулого] dddd [").call(this)}},sameElse:"L"},relativeTime:{future:"за %s",past:"%s тому",s:"декілька секунд",ss:n,m:n,mm:n,h:"годину",hh:n,d:"день",dd:n,M:"місяць",MM:n,y:"рік",yy:n},meridiemParse:/ночі|ранку|дня|вечора/,isPM:function(e){return/^(дня|вечора)$/.test(e)},meridiem:function(e,t,n){return e<4?"ночі":e<12?"ранку":e<17?"дня":"вечора"},dayOfMonthOrdinalParse:/\d{1,2}-(й|го)/,ordinal:function(e,t){switch(t){case"M":case"d":case"DDD":case"w":case"W":return e+"-й";case"D":return e+"-го";default:return e}},week:{dow:1,doy:7}})}(n(95093))},57777:function(e,t,n){!function(e){"use strict";var t=["جنوری","فروری","مارچ","اپریل","مئی","جون","جولائی","اگست","ستمبر","اکتوبر","نومبر","دسمبر"],n=["اتوار","پیر","منگل","بدھ","جمعرات","جمعہ","ہفتہ"];e.defineLocale("ur",{months:t,monthsShort:t,weekdays:n,weekdaysShort:n,weekdaysMin:n,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd، D MMMM YYYY HH:mm"},meridiemParse:/صبح|شام/,isPM:function(e){return"شام"===e},meridiem:function(e,t,n){return e<12?"صبح":"شام"},calendar:{sameDay:"[آج بوقت] LT",nextDay:"[کل بوقت] LT",nextWeek:"dddd [بوقت] LT",lastDay:"[گذشتہ روز بوقت] LT",lastWeek:"[گذشتہ] dddd [بوقت] LT",sameElse:"L"},relativeTime:{future:"%s بعد",past:"%s قبل",s:"چند سیکنڈ",ss:"%d سیکنڈ",m:"ایک منٹ",mm:"%d منٹ",h:"ایک گھنٹہ",hh:"%d گھنٹے",d:"ایک دن",dd:"%d دن",M:"ایک ماہ",MM:"%d ماہ",y:"ایک سال",yy:"%d سال"},preparse:function(e){return e.replace(/،/g,",")},postformat:function(e){return e.replace(/,/g,"،")},week:{dow:1,doy:4}})}(n(95093))},72475:function(e,t,n){!function(e){"use strict";e.defineLocale("uz-latn",{months:"Yanvar_Fevral_Mart_Aprel_May_Iyun_Iyul_Avgust_Sentabr_Oktabr_Noyabr_Dekabr".split("_"),monthsShort:"Yan_Fev_Mar_Apr_May_Iyun_Iyul_Avg_Sen_Okt_Noy_Dek".split("_"),weekdays:"Yakshanba_Dushanba_Seshanba_Chorshanba_Payshanba_Juma_Shanba".split("_"),weekdaysShort:"Yak_Dush_Sesh_Chor_Pay_Jum_Shan".split("_"),weekdaysMin:"Ya_Du_Se_Cho_Pa_Ju_Sha".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"D MMMM YYYY, dddd HH:mm"},calendar:{sameDay:"[Bugun soat] LT [da]",nextDay:"[Ertaga] LT [da]",nextWeek:"dddd [kuni soat] LT [da]",lastDay:"[Kecha soat] LT [da]",lastWeek:"[O'tgan] dddd [kuni soat] LT [da]",sameElse:"L"},relativeTime:{future:"Yaqin %s ichida",past:"Bir necha %s oldin",s:"soniya",ss:"%d soniya",m:"bir daqiqa",mm:"%d daqiqa",h:"bir soat",hh:"%d soat",d:"bir kun",dd:"%d kun",M:"bir oy",MM:"%d oy",y:"bir yil",yy:"%d yil"},week:{dow:1,doy:7}})}(n(95093))},57609:function(e,t,n){!function(e){"use strict";e.defineLocale("uz",{months:"январ_феврал_март_апрел_май_июн_июл_август_сентябр_октябр_ноябр_декабр".split("_"),monthsShort:"янв_фев_мар_апр_май_июн_июл_авг_сен_окт_ноя_дек".split("_"),weekdays:"Якшанба_Душанба_Сешанба_Чоршанба_Пайшанба_Жума_Шанба".split("_"),weekdaysShort:"Якш_Душ_Сеш_Чор_Пай_Жум_Шан".split("_"),weekdaysMin:"Як_Ду_Се_Чо_Па_Жу_Ша".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"D MMMM YYYY, dddd HH:mm"},calendar:{sameDay:"[Бугун соат] LT [да]",nextDay:"[Эртага] LT [да]",nextWeek:"dddd [куни соат] LT [да]",lastDay:"[Кеча соат] LT [да]",lastWeek:"[Утган] dddd [куни соат] LT [да]",sameElse:"L"},relativeTime:{future:"Якин %s ичида",past:"Бир неча %s олдин",s:"фурсат",ss:"%d фурсат",m:"бир дакика",mm:"%d дакика",h:"бир соат",hh:"%d соат",d:"бир кун",dd:"%d кун",M:"бир ой",MM:"%d ой",y:"бир йил",yy:"%d йил"},week:{dow:1,doy:7}})}(n(95093))},21135:function(e,t,n){!function(e){"use strict";e.defineLocale("vi",{months:"tháng 1_tháng 2_tháng 3_tháng 4_tháng 5_tháng 6_tháng 7_tháng 8_tháng 9_tháng 10_tháng 11_tháng 12".split("_"),monthsShort:"Thg 01_Thg 02_Thg 03_Thg 04_Thg 05_Thg 06_Thg 07_Thg 08_Thg 09_Thg 10_Thg 11_Thg 12".split("_"),monthsParseExact:!0,weekdays:"chủ nhật_thứ hai_thứ ba_thứ tư_thứ năm_thứ sáu_thứ bảy".split("_"),weekdaysShort:"CN_T2_T3_T4_T5_T6_T7".split("_"),weekdaysMin:"CN_T2_T3_T4_T5_T6_T7".split("_"),weekdaysParseExact:!0,meridiemParse:/sa|ch/i,isPM:function(e){return/^ch$/i.test(e)},meridiem:function(e,t,n){return e<12?n?"sa":"SA":n?"ch":"CH"},longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM [năm] YYYY",LLL:"D MMMM [năm] YYYY HH:mm",LLLL:"dddd, D MMMM [năm] YYYY HH:mm",l:"DD/M/YYYY",ll:"D MMM YYYY",lll:"D MMM YYYY HH:mm",llll:"ddd, D MMM YYYY HH:mm"},calendar:{sameDay:"[Hôm nay lúc] LT",nextDay:"[Ngày mai lúc] LT",nextWeek:"dddd [tuần tới lúc] LT",lastDay:"[Hôm qua lúc] LT",lastWeek:"dddd [tuần trước lúc] LT",sameElse:"L"},relativeTime:{future:"%s tới",past:"%s trước",s:"vài giây",ss:"%d giây",m:"một phút",mm:"%d phút",h:"một giờ",hh:"%d giờ",d:"một ngày",dd:"%d ngày",w:"một tuần",ww:"%d tuần",M:"một tháng",MM:"%d tháng",y:"một năm",yy:"%d năm"},dayOfMonthOrdinalParse:/\d{1,2}/,ordinal:function(e){return e},week:{dow:1,doy:4}})}(n(95093))},64051:function(e,t,n){!function(e){"use strict";e.defineLocale("x-pseudo",{months:"J~áñúá~rý_F~ébrú~árý_~Márc~h_Áp~ríl_~Máý_~Júñé~_Júl~ý_Áú~gúst~_Sép~témb~ér_Ó~ctób~ér_Ñ~óvém~bér_~Décé~mbér".split("_"),monthsShort:"J~áñ_~Féb_~Már_~Ápr_~Máý_~Júñ_~Júl_~Áúg_~Sép_~Óct_~Ñóv_~Déc".split("_"),monthsParseExact:!0,weekdays:"S~úñdá~ý_Mó~ñdáý~_Túé~sdáý~_Wéd~ñésd~áý_T~húrs~dáý_~Fríd~áý_S~átúr~dáý".split("_"),weekdaysShort:"S~úñ_~Móñ_~Túé_~Wéd_~Thú_~Frí_~Sát".split("_"),weekdaysMin:"S~ú_Mó~_Tú_~Wé_T~h_Fr~_Sá".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[T~ódá~ý át] LT",nextDay:"[T~ómó~rró~w át] LT",nextWeek:"dddd [át] LT",lastDay:"[Ý~ést~érdá~ý át] LT",lastWeek:"[L~ást] dddd [át] LT",sameElse:"L"},relativeTime:{future:"í~ñ %s",past:"%s á~gó",s:"á ~féw ~sécó~ñds",ss:"%d s~écóñ~ds",m:"á ~míñ~úté",mm:"%d m~íñú~tés",h:"á~ñ hó~úr",hh:"%d h~óúrs",d:"á ~dáý",dd:"%d d~áýs",M:"á ~móñ~th",MM:"%d m~óñt~hs",y:"á ~ýéár",yy:"%d ý~éárs"},dayOfMonthOrdinalParse:/\d{1,2}(th|st|nd|rd)/,ordinal:function(e){var t=e%10;return e+(1==~~(e%100/10)?"th":1===t?"st":2===t?"nd":3===t?"rd":"th")},week:{dow:1,doy:4}})}(n(95093))},82218:function(e,t,n){!function(e){"use strict";e.defineLocale("yo",{months:"Sẹ́rẹ́_Èrèlè_Ẹrẹ̀nà_Ìgbé_Èbibi_Òkùdu_Agẹmo_Ògún_Owewe_Ọ̀wàrà_Bélú_Ọ̀pẹ̀̀".split("_"),monthsShort:"Sẹ́r_Èrl_Ẹrn_Ìgb_Èbi_Òkù_Agẹ_Ògú_Owe_Ọ̀wà_Bél_Ọ̀pẹ̀̀".split("_"),weekdays:"Àìkú_Ajé_Ìsẹ́gun_Ọjọ́rú_Ọjọ́bọ_Ẹtì_Àbámẹ́ta".split("_"),weekdaysShort:"Àìk_Ajé_Ìsẹ́_Ọjr_Ọjb_Ẹtì_Àbá".split("_"),weekdaysMin:"Àì_Aj_Ìs_Ọr_Ọb_Ẹt_Àb".split("_"),longDateFormat:{LT:"h:mm A",LTS:"h:mm:ss A",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY h:mm A",LLLL:"dddd, D MMMM YYYY h:mm A"},calendar:{sameDay:"[Ònì ni] LT",nextDay:"[Ọ̀la ni] LT",nextWeek:"dddd [Ọsẹ̀ tón'bọ] [ni] LT",lastDay:"[Àna ni] LT",lastWeek:"dddd [Ọsẹ̀ tólọ́] [ni] LT",sameElse:"L"},relativeTime:{future:"ní %s",past:"%s kọjá",s:"ìsẹjú aayá die",ss:"aayá %d",m:"ìsẹjú kan",mm:"ìsẹjú %d",h:"wákati kan",hh:"wákati %d",d:"ọjọ́ kan",dd:"ọjọ́ %d",M:"osù kan",MM:"osù %d",y:"ọdún kan",yy:"ọdún %d"},dayOfMonthOrdinalParse:/ọjọ́\s\d{1,2}/,ordinal:"ọjọ́ %d",week:{dow:1,doy:4}})}(n(95093))},52648:function(e,t,n){!function(e){"use strict";e.defineLocale("zh-cn",{months:"一月_二月_三月_四月_五月_六月_七月_八月_九月_十月_十一月_十二月".split("_"),monthsShort:"1月_2月_3月_4月_5月_6月_7月_8月_9月_10月_11月_12月".split("_"),weekdays:"星期日_星期一_星期二_星期三_星期四_星期五_星期六".split("_"),weekdaysShort:"周日_周一_周二_周三_周四_周五_周六".split("_"),weekdaysMin:"日_一_二_三_四_五_六".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"YYYY/MM/DD",LL:"YYYY年M月D日",LLL:"YYYY年M月D日Ah点mm分",LLLL:"YYYY年M月D日ddddAh点mm分",l:"YYYY/M/D",ll:"YYYY年M月D日",lll:"YYYY年M月D日 HH:mm",llll:"YYYY年M月D日dddd HH:mm"},meridiemParse:/凌晨|早上|上午|中午|下午|晚上/,meridiemHour:function(e,t){return 12===e&&(e=0),"凌晨"===t||"早上"===t||"上午"===t?e:"下午"===t||"晚上"===t?e+12:e>=11?e:e+12},meridiem:function(e,t,n){var r=100*e+t;return r<600?"凌晨":r<900?"早上":r<1130?"上午":r<1230?"中午":r<1800?"下午":"晚上"},calendar:{sameDay:"[今天]LT",nextDay:"[明天]LT",nextWeek:function(e){return e.week()!==this.week()?"[下]dddLT":"[本]dddLT"},lastDay:"[昨天]LT",lastWeek:function(e){return this.week()!==e.week()?"[上]dddLT":"[本]dddLT"},sameElse:"L"},dayOfMonthOrdinalParse:/\d{1,2}(日|月|周)/,ordinal:function(e,t){switch(t){case"d":case"D":case"DDD":return e+"日";case"M":return e+"月";case"w":case"W":return e+"周";default:return e}},relativeTime:{future:"%s后",past:"%s前",s:"几秒",ss:"%d 秒",m:"1 分钟",mm:"%d 分钟",h:"1 小时",hh:"%d 小时",d:"1 天",dd:"%d 天",w:"1 周",ww:"%d 周",M:"1 个月",MM:"%d 个月",y:"1 年",yy:"%d 年"},week:{dow:1,doy:4}})}(n(95093))},1632:function(e,t,n){!function(e){"use strict";e.defineLocale("zh-hk",{months:"一月_二月_三月_四月_五月_六月_七月_八月_九月_十月_十一月_十二月".split("_"),monthsShort:"1月_2月_3月_4月_5月_6月_7月_8月_9月_10月_11月_12月".split("_"),weekdays:"星期日_星期一_星期二_星期三_星期四_星期五_星期六".split("_"),weekdaysShort:"週日_週一_週二_週三_週四_週五_週六".split("_"),weekdaysMin:"日_一_二_三_四_五_六".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"YYYY/MM/DD",LL:"YYYY年M月D日",LLL:"YYYY年M月D日 HH:mm",LLLL:"YYYY年M月D日dddd HH:mm",l:"YYYY/M/D",ll:"YYYY年M月D日",lll:"YYYY年M月D日 HH:mm",llll:"YYYY年M月D日dddd HH:mm"},meridiemParse:/凌晨|早上|上午|中午|下午|晚上/,meridiemHour:function(e,t){return 12===e&&(e=0),"凌晨"===t||"早上"===t||"上午"===t?e:"中午"===t?e>=11?e:e+12:"下午"===t||"晚上"===t?e+12:void 0},meridiem:function(e,t,n){var r=100*e+t;return r<600?"凌晨":r<900?"早上":r<1200?"上午":1200===r?"中午":r<1800?"下午":"晚上"},calendar:{sameDay:"[今天]LT",nextDay:"[明天]LT",nextWeek:"[下]ddddLT",lastDay:"[昨天]LT",lastWeek:"[上]ddddLT",sameElse:"L"},dayOfMonthOrdinalParse:/\d{1,2}(日|月|週)/,ordinal:function(e,t){switch(t){case"d":case"D":case"DDD":return e+"日";case"M":return e+"月";case"w":case"W":return e+"週";default:return e}},relativeTime:{future:"%s後",past:"%s前",s:"幾秒",ss:"%d 秒",m:"1 分鐘",mm:"%d 分鐘",h:"1 小時",hh:"%d 小時",d:"1 天",dd:"%d 天",M:"1 個月",MM:"%d 個月",y:"1 年",yy:"%d 年"}})}(n(95093))},31541:function(e,t,n){!function(e){"use strict";e.defineLocale("zh-mo",{months:"一月_二月_三月_四月_五月_六月_七月_八月_九月_十月_十一月_十二月".split("_"),monthsShort:"1月_2月_3月_4月_5月_6月_7月_8月_9月_10月_11月_12月".split("_"),weekdays:"星期日_星期一_星期二_星期三_星期四_星期五_星期六".split("_"),weekdaysShort:"週日_週一_週二_週三_週四_週五_週六".split("_"),weekdaysMin:"日_一_二_三_四_五_六".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"YYYY年M月D日",LLL:"YYYY年M月D日 HH:mm",LLLL:"YYYY年M月D日dddd HH:mm",l:"D/M/YYYY",ll:"YYYY年M月D日",lll:"YYYY年M月D日 HH:mm",llll:"YYYY年M月D日dddd HH:mm"},meridiemParse:/凌晨|早上|上午|中午|下午|晚上/,meridiemHour:function(e,t){return 12===e&&(e=0),"凌晨"===t||"早上"===t||"上午"===t?e:"中午"===t?e>=11?e:e+12:"下午"===t||"晚上"===t?e+12:void 0},meridiem:function(e,t,n){var r=100*e+t;return r<600?"凌晨":r<900?"早上":r<1130?"上午":r<1230?"中午":r<1800?"下午":"晚上"},calendar:{sameDay:"[今天] LT",nextDay:"[明天] LT",nextWeek:"[下]dddd LT",lastDay:"[昨天] LT",lastWeek:"[上]dddd LT",sameElse:"L"},dayOfMonthOrdinalParse:/\d{1,2}(日|月|週)/,ordinal:function(e,t){switch(t){case"d":case"D":case"DDD":return e+"日";case"M":return e+"月";case"w":case"W":return e+"週";default:return e}},relativeTime:{future:"%s內",past:"%s前",s:"幾秒",ss:"%d 秒",m:"1 分鐘",mm:"%d 分鐘",h:"1 小時",hh:"%d 小時",d:"1 天",dd:"%d 天",M:"1 個月",MM:"%d 個月",y:"1 年",yy:"%d 年"}})}(n(95093))},50304:function(e,t,n){!function(e){"use strict";e.defineLocale("zh-tw",{months:"一月_二月_三月_四月_五月_六月_七月_八月_九月_十月_十一月_十二月".split("_"),monthsShort:"1月_2月_3月_4月_5月_6月_7月_8月_9月_10月_11月_12月".split("_"),weekdays:"星期日_星期一_星期二_星期三_星期四_星期五_星期六".split("_"),weekdaysShort:"週日_週一_週二_週三_週四_週五_週六".split("_"),weekdaysMin:"日_一_二_三_四_五_六".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"YYYY/MM/DD",LL:"YYYY年M月D日",LLL:"YYYY年M月D日 HH:mm",LLLL:"YYYY年M月D日dddd HH:mm",l:"YYYY/M/D",ll:"YYYY年M月D日",lll:"YYYY年M月D日 HH:mm",llll:"YYYY年M月D日dddd HH:mm"},meridiemParse:/凌晨|早上|上午|中午|下午|晚上/,meridiemHour:function(e,t){return 12===e&&(e=0),"凌晨"===t||"早上"===t||"上午"===t?e:"中午"===t?e>=11?e:e+12:"下午"===t||"晚上"===t?e+12:void 0},meridiem:function(e,t,n){var r=100*e+t;return r<600?"凌晨":r<900?"早上":r<1130?"上午":r<1230?"中午":r<1800?"下午":"晚上"},calendar:{sameDay:"[今天] LT",nextDay:"[明天] LT",nextWeek:"[下]dddd LT",lastDay:"[昨天] LT",lastWeek:"[上]dddd LT",sameElse:"L"},dayOfMonthOrdinalParse:/\d{1,2}(日|月|週)/,ordinal:function(e,t){switch(t){case"d":case"D":case"DDD":return e+"日";case"M":return e+"月";case"w":case"W":return e+"週";default:return e}},relativeTime:{future:"%s後",past:"%s前",s:"幾秒",ss:"%d 秒",m:"1 分鐘",mm:"%d 分鐘",h:"1 小時",hh:"%d 小時",d:"1 天",dd:"%d 天",M:"1 個月",MM:"%d 個月",y:"1 年",yy:"%d 年"}})}(n(95093))},35358:(e,t,n)=>{var r={"./af":25177,"./af.js":25177,"./ar":61509,"./ar-dz":41488,"./ar-dz.js":41488,"./ar-kw":58676,"./ar-kw.js":58676,"./ar-ly":42353,"./ar-ly.js":42353,"./ar-ma":24496,"./ar-ma.js":24496,"./ar-ps":6947,"./ar-ps.js":6947,"./ar-sa":82682,"./ar-sa.js":82682,"./ar-tn":89756,"./ar-tn.js":89756,"./ar.js":61509,"./az":95533,"./az.js":95533,"./be":28959,"./be.js":28959,"./bg":47777,"./bg.js":47777,"./bm":54903,"./bm.js":54903,"./bn":61290,"./bn-bd":17357,"./bn-bd.js":17357,"./bn.js":61290,"./bo":31545,"./bo.js":31545,"./br":11470,"./br.js":11470,"./bs":44429,"./bs.js":44429,"./ca":7306,"./ca.js":7306,"./cs":56464,"./cs.js":56464,"./cv":73635,"./cv.js":73635,"./cy":64226,"./cy.js":64226,"./da":93601,"./da.js":93601,"./de":77853,"./de-at":26111,"./de-at.js":26111,"./de-ch":54697,"./de-ch.js":54697,"./de.js":77853,"./dv":60708,"./dv.js":60708,"./el":54691,"./el.js":54691,"./en-au":53872,"./en-au.js":53872,"./en-ca":28298,"./en-ca.js":28298,"./en-gb":56195,"./en-gb.js":56195,"./en-ie":66584,"./en-ie.js":66584,"./en-il":65543,"./en-il.js":65543,"./en-in":9033,"./en-in.js":9033,"./en-nz":79402,"./en-nz.js":79402,"./en-sg":43004,"./en-sg.js":43004,"./eo":32934,"./eo.js":32934,"./es":97650,"./es-do":20838,"./es-do.js":20838,"./es-mx":17730,"./es-mx.js":17730,"./es-us":56575,"./es-us.js":56575,"./es.js":97650,"./et":3035,"./et.js":3035,"./eu":3508,"./eu.js":3508,"./fa":119,"./fa.js":119,"./fi":90527,"./fi.js":90527,"./fil":95995,"./fil.js":95995,"./fo":52477,"./fo.js":52477,"./fr":85498,"./fr-ca":26435,"./fr-ca.js":26435,"./fr-ch":37892,"./fr-ch.js":37892,"./fr.js":85498,"./fy":37071,"./fy.js":37071,"./ga":41734,"./ga.js":41734,"./gd":70217,"./gd.js":70217,"./gl":77329,"./gl.js":77329,"./gom-deva":32124,"./gom-deva.js":32124,"./gom-latn":93383,"./gom-latn.js":93383,"./gu":95050,"./gu.js":95050,"./he":11713,"./he.js":11713,"./hi":43861,"./hi.js":43861,"./hr":26308,"./hr.js":26308,"./hu":90609,"./hu.js":90609,"./hy-am":17160,"./hy-am.js":17160,"./id":74063,"./id.js":74063,"./is":89374,"./is.js":89374,"./it":88383,"./it-ch":21827,"./it-ch.js":21827,"./it.js":88383,"./ja":23827,"./ja.js":23827,"./jv":89722,"./jv.js":89722,"./ka":41794,"./ka.js":41794,"./kk":27088,"./kk.js":27088,"./km":96870,"./km.js":96870,"./kn":84451,"./kn.js":84451,"./ko":63164,"./ko.js":63164,"./ku":98174,"./ku-kmr":6181,"./ku-kmr.js":6181,"./ku.js":98174,"./ky":78474,"./ky.js":78474,"./lb":79680,"./lb.js":79680,"./lo":15867,"./lo.js":15867,"./lt":45766,"./lt.js":45766,"./lv":69532,"./lv.js":69532,"./me":58076,"./me.js":58076,"./mi":41848,"./mi.js":41848,"./mk":30306,"./mk.js":30306,"./ml":73739,"./ml.js":73739,"./mn":99053,"./mn.js":99053,"./mr":86169,"./mr.js":86169,"./ms":73386,"./ms-my":92297,"./ms-my.js":92297,"./ms.js":73386,"./mt":77075,"./mt.js":77075,"./my":72264,"./my.js":72264,"./nb":22274,"./nb.js":22274,"./ne":8235,"./ne.js":8235,"./nl":92572,"./nl-be":43784,"./nl-be.js":43784,"./nl.js":92572,"./nn":54566,"./nn.js":54566,"./oc-lnc":69330,"./oc-lnc.js":69330,"./pa-in":29849,"./pa-in.js":29849,"./pl":94418,"./pl.js":94418,"./pt":79834,"./pt-br":48303,"./pt-br.js":48303,"./pt.js":79834,"./ro":24457,"./ro.js":24457,"./ru":82271,"./ru.js":82271,"./sd":1221,"./sd.js":1221,"./se":33478,"./se.js":33478,"./si":17538,"./si.js":17538,"./sk":5784,"./sk.js":5784,"./sl":46637,"./sl.js":46637,"./sq":86794,"./sq.js":86794,"./sr":45719,"./sr-cyrl":3322,"./sr-cyrl.js":3322,"./sr.js":45719,"./ss":56e3,"./ss.js":56e3,"./sv":41011,"./sv.js":41011,"./sw":40748,"./sw.js":40748,"./ta":11025,"./ta.js":11025,"./te":11885,"./te.js":11885,"./tet":28861,"./tet.js":28861,"./tg":86571,"./tg.js":86571,"./th":55802,"./th.js":55802,"./tk":59527,"./tk.js":59527,"./tl-ph":29231,"./tl-ph.js":29231,"./tlh":31052,"./tlh.js":31052,"./tr":85096,"./tr.js":85096,"./tzl":79846,"./tzl.js":79846,"./tzm":81765,"./tzm-latn":97711,"./tzm-latn.js":97711,"./tzm.js":81765,"./ug-cn":48414,"./ug-cn.js":48414,"./uk":16618,"./uk.js":16618,"./ur":57777,"./ur.js":57777,"./uz":57609,"./uz-latn":72475,"./uz-latn.js":72475,"./uz.js":57609,"./vi":21135,"./vi.js":21135,"./x-pseudo":64051,"./x-pseudo.js":64051,"./yo":82218,"./yo.js":82218,"./zh-cn":52648,"./zh-cn.js":52648,"./zh-hk":1632,"./zh-hk.js":1632,"./zh-mo":31541,"./zh-mo.js":31541,"./zh-tw":50304,"./zh-tw.js":50304};function a(e){var t=s(e);return n(t)}function s(e){if(!n.o(r,e)){var t=new Error("Cannot find module '"+e+"'");throw t.code="MODULE_NOT_FOUND",t}return r[e]}a.keys=function(){return Object.keys(r)},a.resolve=s,e.exports=a,a.id=35358},95093:function(e,t,n){(e=n.nmd(e)).exports=function(){"use strict";var t,r;function a(){return t.apply(null,arguments)}function s(e){t=e}function i(e){return e instanceof Array||"[object Array]"===Object.prototype.toString.call(e)}function o(e){return null!=e&&"[object Object]"===Object.prototype.toString.call(e)}function d(e,t){return Object.prototype.hasOwnProperty.call(e,t)}function u(e){if(Object.getOwnPropertyNames)return 0===Object.getOwnPropertyNames(e).length;var t;for(t in e)if(d(e,t))return!1;return!0}function l(e){return void 0===e}function c(e){return"number"==typeof e||"[object Number]"===Object.prototype.toString.call(e)}function _(e){return e instanceof Date||"[object Date]"===Object.prototype.toString.call(e)}function m(e,t){var n,r=[],a=e.length;for(n=0;n<a;++n)r.push(t(e[n],n));return r}function h(e,t){for(var n in t)d(t,n)&&(e[n]=t[n]);return d(t,"toString")&&(e.toString=t.toString),d(t,"valueOf")&&(e.valueOf=t.valueOf),e}function f(e,t,n,r){return qn(e,t,n,r,!0).utc()}function p(){return{empty:!1,unusedTokens:[],unusedInput:[],overflow:-2,charsLeftOver:0,nullInput:!1,invalidEra:null,invalidMonth:null,invalidFormat:!1,userInvalidated:!1,iso:!1,parsedDateParts:[],era:null,meridiem:null,rfc2822:!1,weekdayMismatch:!1}}function y(e){return null==e._pf&&(e._pf=p()),e._pf}function M(e){var t=null,n=!1,a=e._d&&!isNaN(e._d.getTime());return a&&(t=y(e),n=r.call(t.parsedDateParts,(function(e){return null!=e})),a=t.overflow<0&&!t.empty&&!t.invalidEra&&!t.invalidMonth&&!t.invalidWeekday&&!t.weekdayMismatch&&!t.nullInput&&!t.invalidFormat&&!t.userInvalidated&&(!t.meridiem||t.meridiem&&n),e._strict&&(a=a&&0===t.charsLeftOver&&0===t.unusedTokens.length&&void 0===t.bigHour)),null!=Object.isFrozen&&Object.isFrozen(e)?a:(e._isValid=a,e._isValid)}function g(e){var t=f(NaN);return null!=e?h(y(t),e):y(t).userInvalidated=!0,t}r=Array.prototype.some?Array.prototype.some:function(e){var t,n=Object(this),r=n.length>>>0;for(t=0;t<r;t++)if(t in n&&e.call(this,n[t],t,n))return!0;return!1};var L=a.momentProperties=[],v=!1;function Y(e,t){var n,r,a,s=L.length;if(l(t._isAMomentObject)||(e._isAMomentObject=t._isAMomentObject),l(t._i)||(e._i=t._i),l(t._f)||(e._f=t._f),l(t._l)||(e._l=t._l),l(t._strict)||(e._strict=t._strict),l(t._tzm)||(e._tzm=t._tzm),l(t._isUTC)||(e._isUTC=t._isUTC),l(t._offset)||(e._offset=t._offset),l(t._pf)||(e._pf=y(t)),l(t._locale)||(e._locale=t._locale),s>0)for(n=0;n<s;n++)l(a=t[r=L[n]])||(e[r]=a);return e}function w(e){Y(this,e),this._d=new Date(null!=e._d?e._d.getTime():NaN),this.isValid()||(this._d=new Date(NaN)),!1===v&&(v=!0,a.updateOffset(this),v=!1)}function k(e){return e instanceof w||null!=e&&null!=e._isAMomentObject}function b(e){!1===a.suppressDeprecationWarnings&&"undefined"!=typeof console&&console.warn&&console.warn("Deprecation warning: "+e)}function D(e,t){var n=!0;return h((function(){if(null!=a.deprecationHandler&&a.deprecationHandler(null,e),n){var r,s,i,o=[],u=arguments.length;for(s=0;s<u;s++){if(r="","object"==typeof arguments[s]){for(i in r+="\n["+s+"] ",arguments[0])d(arguments[0],i)&&(r+=i+": "+arguments[0][i]+", ");r=r.slice(0,-2)}else r=arguments[s];o.push(r)}b(e+"\nArguments: "+Array.prototype.slice.call(o).join("")+"\n"+(new Error).stack),n=!1}return t.apply(this,arguments)}),t)}var T,S={};function j(e,t){null!=a.deprecationHandler&&a.deprecationHandler(e,t),S[e]||(b(t),S[e]=!0)}function E(e){return"undefined"!=typeof Function&&e instanceof Function||"[object Function]"===Object.prototype.toString.call(e)}function x(e){var t,n;for(n in e)d(e,n)&&(E(t=e[n])?this[n]=t:this["_"+n]=t);this._config=e,this._dayOfMonthOrdinalParseLenient=new RegExp((this._dayOfMonthOrdinalParse.source||this._ordinalParse.source)+"|"+/\d{1,2}/.source)}function O(e,t){var n,r=h({},e);for(n in t)d(t,n)&&(o(e[n])&&o(t[n])?(r[n]={},h(r[n],e[n]),h(r[n],t[n])):null!=t[n]?r[n]=t[n]:delete r[n]);for(n in e)d(e,n)&&!d(t,n)&&o(e[n])&&(r[n]=h({},r[n]));return r}function A(e){null!=e&&this.set(e)}a.suppressDeprecationWarnings=!1,a.deprecationHandler=null,T=Object.keys?Object.keys:function(e){var t,n=[];for(t in e)d(e,t)&&n.push(t);return n};var H={sameDay:"[Today at] LT",nextDay:"[Tomorrow at] LT",nextWeek:"dddd [at] LT",lastDay:"[Yesterday at] LT",lastWeek:"[Last] dddd [at] LT",sameElse:"L"};function P(e,t,n){var r=this._calendar[e]||this._calendar.sameElse;return E(r)?r.call(t,n):r}function C(e,t,n){var r=""+Math.abs(e),a=t-r.length;return(e>=0?n?"+":"":"-")+Math.pow(10,Math.max(0,a)).toString().substr(1)+r}var I=/(\[[^\[]*\])|(\\)?([Hh]mm(ss)?|Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Qo?|N{1,5}|YYYYYY|YYYYY|YYYY|YY|y{2,4}|yo?|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|kk?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?|.)/g,R=/(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g,N={},F={};function W(e,t,n,r){var a=r;"string"==typeof r&&(a=function(){return this[r]()}),e&&(F[e]=a),t&&(F[t[0]]=function(){return C(a.apply(this,arguments),t[1],t[2])}),n&&(F[n]=function(){return this.localeData().ordinal(a.apply(this,arguments),e)})}function $(e){return e.match(/\[[\s\S]/)?e.replace(/^\[|\]$/g,""):e.replace(/\\/g,"")}function U(e){var t,n,r=e.match(I);for(t=0,n=r.length;t<n;t++)F[r[t]]?r[t]=F[r[t]]:r[t]=$(r[t]);return function(t){var a,s="";for(a=0;a<n;a++)s+=E(r[a])?r[a].call(t,e):r[a];return s}}function B(e,t){return e.isValid()?(t=z(t,e.localeData()),N[t]=N[t]||U(t),N[t](e)):e.localeData().invalidDate()}function z(e,t){var n=5;function r(e){return t.longDateFormat(e)||e}for(R.lastIndex=0;n>=0&&R.test(e);)e=e.replace(R,r),R.lastIndex=0,n-=1;return e}var J={LTS:"h:mm:ss A",LT:"h:mm A",L:"MM/DD/YYYY",LL:"MMMM D, YYYY",LLL:"MMMM D, YYYY h:mm A",LLLL:"dddd, MMMM D, YYYY h:mm A"};function G(e){var t=this._longDateFormat[e],n=this._longDateFormat[e.toUpperCase()];return t||!n?t:(this._longDateFormat[e]=n.match(I).map((function(e){return"MMMM"===e||"MM"===e||"DD"===e||"dddd"===e?e.slice(1):e})).join(""),this._longDateFormat[e])}var V="Invalid date";function q(){return this._invalidDate}var K="%d",Z=/\d{1,2}/;function X(e){return this._ordinal.replace("%d",e)}var Q={future:"in %s",past:"%s ago",s:"a few seconds",ss:"%d seconds",m:"a minute",mm:"%d minutes",h:"an hour",hh:"%d hours",d:"a day",dd:"%d days",w:"a week",ww:"%d weeks",M:"a month",MM:"%d months",y:"a year",yy:"%d years"};function ee(e,t,n,r){var a=this._relativeTime[n];return E(a)?a(e,t,n,r):a.replace(/%d/i,e)}function te(e,t){var n=this._relativeTime[e>0?"future":"past"];return E(n)?n(t):n.replace(/%s/i,t)}var ne={D:"date",dates:"date",date:"date",d:"day",days:"day",day:"day",e:"weekday",weekdays:"weekday",weekday:"weekday",E:"isoWeekday",isoweekdays:"isoWeekday",isoweekday:"isoWeekday",DDD:"dayOfYear",dayofyears:"dayOfYear",dayofyear:"dayOfYear",h:"hour",hours:"hour",hour:"hour",ms:"millisecond",milliseconds:"millisecond",millisecond:"millisecond",m:"minute",minutes:"minute",minute:"minute",M:"month",months:"month",month:"month",Q:"quarter",quarters:"quarter",quarter:"quarter",s:"second",seconds:"second",second:"second",gg:"weekYear",weekyears:"weekYear",weekyear:"weekYear",GG:"isoWeekYear",isoweekyears:"isoWeekYear",isoweekyear:"isoWeekYear",w:"week",weeks:"week",week:"week",W:"isoWeek",isoweeks:"isoWeek",isoweek:"isoWeek",y:"year",years:"year",year:"year"};function re(e){return"string"==typeof e?ne[e]||ne[e.toLowerCase()]:void 0}function ae(e){var t,n,r={};for(n in e)d(e,n)&&(t=re(n))&&(r[t]=e[n]);return r}var se={date:9,day:11,weekday:11,isoWeekday:11,dayOfYear:4,hour:13,millisecond:16,minute:14,month:8,quarter:7,second:15,weekYear:1,isoWeekYear:1,week:5,isoWeek:5,year:1};function ie(e){var t,n=[];for(t in e)d(e,t)&&n.push({unit:t,priority:se[t]});return n.sort((function(e,t){return e.priority-t.priority})),n}var oe,de=/\d/,ue=/\d\d/,le=/\d{3}/,ce=/\d{4}/,_e=/[+-]?\d{6}/,me=/\d\d?/,he=/\d\d\d\d?/,fe=/\d\d\d\d\d\d?/,pe=/\d{1,3}/,ye=/\d{1,4}/,Me=/[+-]?\d{1,6}/,ge=/\d+/,Le=/[+-]?\d+/,ve=/Z|[+-]\d\d:?\d\d/gi,Ye=/Z|[+-]\d\d(?::?\d\d)?/gi,we=/[+-]?\d+(\.\d{1,3})?/,ke=/[0-9]{0,256}['a-z\u00A0-\u05FF\u0700-\uD7FF\uF900-\uFDCF\uFDF0-\uFF07\uFF10-\uFFEF]{1,256}|[\u0600-\u06FF\/]{1,256}(\s*?[\u0600-\u06FF]{1,256}){1,2}/i,be=/^[1-9]\d?/,De=/^([1-9]\d|\d)/;function Te(e,t,n){oe[e]=E(t)?t:function(e,r){return e&&n?n:t}}function Se(e,t){return d(oe,e)?oe[e](t._strict,t._locale):new RegExp(je(e))}function je(e){return Ee(e.replace("\\","").replace(/\\(\[)|\\(\])|\[([^\]\[]*)\]|\\(.)/g,(function(e,t,n,r,a){return t||n||r||a})))}function Ee(e){return e.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")}function xe(e){return e<0?Math.ceil(e)||0:Math.floor(e)}function Oe(e){var t=+e,n=0;return 0!==t&&isFinite(t)&&(n=xe(t)),n}oe={};var Ae={};function He(e,t){var n,r,a=t;for("string"==typeof e&&(e=[e]),c(t)&&(a=function(e,n){n[t]=Oe(e)}),r=e.length,n=0;n<r;n++)Ae[e[n]]=a}function Pe(e,t){He(e,(function(e,n,r,a){r._w=r._w||{},t(e,r._w,r,a)}))}function Ce(e,t,n){null!=t&&d(Ae,e)&&Ae[e](t,n._a,n,e)}function Ie(e){return e%4==0&&e%100!=0||e%400==0}var Re=0,Ne=1,Fe=2,We=3,$e=4,Ue=5,Be=6,ze=7,Je=8;function Ge(e){return Ie(e)?366:365}W("Y",0,0,(function(){var e=this.year();return e<=9999?C(e,4):"+"+e})),W(0,["YY",2],0,(function(){return this.year()%100})),W(0,["YYYY",4],0,"year"),W(0,["YYYYY",5],0,"year"),W(0,["YYYYYY",6,!0],0,"year"),Te("Y",Le),Te("YY",me,ue),Te("YYYY",ye,ce),Te("YYYYY",Me,_e),Te("YYYYYY",Me,_e),He(["YYYYY","YYYYYY"],Re),He("YYYY",(function(e,t){t[Re]=2===e.length?a.parseTwoDigitYear(e):Oe(e)})),He("YY",(function(e,t){t[Re]=a.parseTwoDigitYear(e)})),He("Y",(function(e,t){t[Re]=parseInt(e,10)})),a.parseTwoDigitYear=function(e){return Oe(e)+(Oe(e)>68?1900:2e3)};var Ve,qe=Ze("FullYear",!0);function Ke(){return Ie(this.year())}function Ze(e,t){return function(n){return null!=n?(Qe(this,e,n),a.updateOffset(this,t),this):Xe(this,e)}}function Xe(e,t){if(!e.isValid())return NaN;var n=e._d,r=e._isUTC;switch(t){case"Milliseconds":return r?n.getUTCMilliseconds():n.getMilliseconds();case"Seconds":return r?n.getUTCSeconds():n.getSeconds();case"Minutes":return r?n.getUTCMinutes():n.getMinutes();case"Hours":return r?n.getUTCHours():n.getHours();case"Date":return r?n.getUTCDate():n.getDate();case"Day":return r?n.getUTCDay():n.getDay();case"Month":return r?n.getUTCMonth():n.getMonth();case"FullYear":return r?n.getUTCFullYear():n.getFullYear();default:return NaN}}function Qe(e,t,n){var r,a,s,i,o;if(e.isValid()&&!isNaN(n)){switch(r=e._d,a=e._isUTC,t){case"Milliseconds":return void(a?r.setUTCMilliseconds(n):r.setMilliseconds(n));case"Seconds":return void(a?r.setUTCSeconds(n):r.setSeconds(n));case"Minutes":return void(a?r.setUTCMinutes(n):r.setMinutes(n));case"Hours":return void(a?r.setUTCHours(n):r.setHours(n));case"Date":return void(a?r.setUTCDate(n):r.setDate(n));case"FullYear":break;default:return}s=n,i=e.month(),o=29!==(o=e.date())||1!==i||Ie(s)?o:28,a?r.setUTCFullYear(s,i,o):r.setFullYear(s,i,o)}}function et(e){return E(this[e=re(e)])?this[e]():this}function tt(e,t){if("object"==typeof e){var n,r=ie(e=ae(e)),a=r.length;for(n=0;n<a;n++)this[r[n].unit](e[r[n].unit])}else if(E(this[e=re(e)]))return this[e](t);return this}function nt(e,t){return(e%t+t)%t}function rt(e,t){if(isNaN(e)||isNaN(t))return NaN;var n=nt(t,12);return e+=(t-n)/12,1===n?Ie(e)?29:28:31-n%7%2}Ve=Array.prototype.indexOf?Array.prototype.indexOf:function(e){var t;for(t=0;t<this.length;++t)if(this[t]===e)return t;return-1},W("M",["MM",2],"Mo",(function(){return this.month()+1})),W("MMM",0,0,(function(e){return this.localeData().monthsShort(this,e)})),W("MMMM",0,0,(function(e){return this.localeData().months(this,e)})),Te("M",me,be),Te("MM",me,ue),Te("MMM",(function(e,t){return t.monthsShortRegex(e)})),Te("MMMM",(function(e,t){return t.monthsRegex(e)})),He(["M","MM"],(function(e,t){t[Ne]=Oe(e)-1})),He(["MMM","MMMM"],(function(e,t,n,r){var a=n._locale.monthsParse(e,r,n._strict);null!=a?t[Ne]=a:y(n).invalidMonth=e}));var at="January_February_March_April_May_June_July_August_September_October_November_December".split("_"),st="Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),it=/D[oD]?(\[[^\[\]]*\]|\s)+MMMM?/,ot=ke,dt=ke;function ut(e,t){return e?i(this._months)?this._months[e.month()]:this._months[(this._months.isFormat||it).test(t)?"format":"standalone"][e.month()]:i(this._months)?this._months:this._months.standalone}function lt(e,t){return e?i(this._monthsShort)?this._monthsShort[e.month()]:this._monthsShort[it.test(t)?"format":"standalone"][e.month()]:i(this._monthsShort)?this._monthsShort:this._monthsShort.standalone}function ct(e,t,n){var r,a,s,i=e.toLocaleLowerCase();if(!this._monthsParse)for(this._monthsParse=[],this._longMonthsParse=[],this._shortMonthsParse=[],r=0;r<12;++r)s=f([2e3,r]),this._shortMonthsParse[r]=this.monthsShort(s,"").toLocaleLowerCase(),this._longMonthsParse[r]=this.months(s,"").toLocaleLowerCase();return n?"MMM"===t?-1!==(a=Ve.call(this._shortMonthsParse,i))?a:null:-1!==(a=Ve.call(this._longMonthsParse,i))?a:null:"MMM"===t?-1!==(a=Ve.call(this._shortMonthsParse,i))||-1!==(a=Ve.call(this._longMonthsParse,i))?a:null:-1!==(a=Ve.call(this._longMonthsParse,i))||-1!==(a=Ve.call(this._shortMonthsParse,i))?a:null}function _t(e,t,n){var r,a,s;if(this._monthsParseExact)return ct.call(this,e,t,n);for(this._monthsParse||(this._monthsParse=[],this._longMonthsParse=[],this._shortMonthsParse=[]),r=0;r<12;r++){if(a=f([2e3,r]),n&&!this._longMonthsParse[r]&&(this._longMonthsParse[r]=new RegExp("^"+this.months(a,"").replace(".","")+"$","i"),this._shortMonthsParse[r]=new RegExp("^"+this.monthsShort(a,"").replace(".","")+"$","i")),n||this._monthsParse[r]||(s="^"+this.months(a,"")+"|^"+this.monthsShort(a,""),this._monthsParse[r]=new RegExp(s.replace(".",""),"i")),n&&"MMMM"===t&&this._longMonthsParse[r].test(e))return r;if(n&&"MMM"===t&&this._shortMonthsParse[r].test(e))return r;if(!n&&this._monthsParse[r].test(e))return r}}function mt(e,t){if(!e.isValid())return e;if("string"==typeof t)if(/^\d+$/.test(t))t=Oe(t);else if(!c(t=e.localeData().monthsParse(t)))return e;var n=t,r=e.date();return r=r<29?r:Math.min(r,rt(e.year(),n)),e._isUTC?e._d.setUTCMonth(n,r):e._d.setMonth(n,r),e}function ht(e){return null!=e?(mt(this,e),a.updateOffset(this,!0),this):Xe(this,"Month")}function ft(){return rt(this.year(),this.month())}function pt(e){return this._monthsParseExact?(d(this,"_monthsRegex")||Mt.call(this),e?this._monthsShortStrictRegex:this._monthsShortRegex):(d(this,"_monthsShortRegex")||(this._monthsShortRegex=ot),this._monthsShortStrictRegex&&e?this._monthsShortStrictRegex:this._monthsShortRegex)}function yt(e){return this._monthsParseExact?(d(this,"_monthsRegex")||Mt.call(this),e?this._monthsStrictRegex:this._monthsRegex):(d(this,"_monthsRegex")||(this._monthsRegex=dt),this._monthsStrictRegex&&e?this._monthsStrictRegex:this._monthsRegex)}function Mt(){function e(e,t){return t.length-e.length}var t,n,r,a,s=[],i=[],o=[];for(t=0;t<12;t++)n=f([2e3,t]),r=Ee(this.monthsShort(n,"")),a=Ee(this.months(n,"")),s.push(r),i.push(a),o.push(a),o.push(r);s.sort(e),i.sort(e),o.sort(e),this._monthsRegex=new RegExp("^("+o.join("|")+")","i"),this._monthsShortRegex=this._monthsRegex,this._monthsStrictRegex=new RegExp("^("+i.join("|")+")","i"),this._monthsShortStrictRegex=new RegExp("^("+s.join("|")+")","i")}function gt(e,t,n,r,a,s,i){var o;return e<100&&e>=0?(o=new Date(e+400,t,n,r,a,s,i),isFinite(o.getFullYear())&&o.setFullYear(e)):o=new Date(e,t,n,r,a,s,i),o}function Lt(e){var t,n;return e<100&&e>=0?((n=Array.prototype.slice.call(arguments))[0]=e+400,t=new Date(Date.UTC.apply(null,n)),isFinite(t.getUTCFullYear())&&t.setUTCFullYear(e)):t=new Date(Date.UTC.apply(null,arguments)),t}function vt(e,t,n){var r=7+t-n;return-(7+Lt(e,0,r).getUTCDay()-t)%7+r-1}function Yt(e,t,n,r,a){var s,i,o=1+7*(t-1)+(7+n-r)%7+vt(e,r,a);return o<=0?i=Ge(s=e-1)+o:o>Ge(e)?(s=e+1,i=o-Ge(e)):(s=e,i=o),{year:s,dayOfYear:i}}function wt(e,t,n){var r,a,s=vt(e.year(),t,n),i=Math.floor((e.dayOfYear()-s-1)/7)+1;return i<1?r=i+kt(a=e.year()-1,t,n):i>kt(e.year(),t,n)?(r=i-kt(e.year(),t,n),a=e.year()+1):(a=e.year(),r=i),{week:r,year:a}}function kt(e,t,n){var r=vt(e,t,n),a=vt(e+1,t,n);return(Ge(e)-r+a)/7}function bt(e){return wt(e,this._week.dow,this._week.doy).week}W("w",["ww",2],"wo","week"),W("W",["WW",2],"Wo","isoWeek"),Te("w",me,be),Te("ww",me,ue),Te("W",me,be),Te("WW",me,ue),Pe(["w","ww","W","WW"],(function(e,t,n,r){t[r.substr(0,1)]=Oe(e)}));var Dt={dow:0,doy:6};function Tt(){return this._week.dow}function St(){return this._week.doy}function jt(e){var t=this.localeData().week(this);return null==e?t:this.add(7*(e-t),"d")}function Et(e){var t=wt(this,1,4).week;return null==e?t:this.add(7*(e-t),"d")}function xt(e,t){return"string"!=typeof e?e:isNaN(e)?"number"==typeof(e=t.weekdaysParse(e))?e:null:parseInt(e,10)}function Ot(e,t){return"string"==typeof e?t.weekdaysParse(e)%7||7:isNaN(e)?null:e}function At(e,t){return e.slice(t,7).concat(e.slice(0,t))}W("d",0,"do","day"),W("dd",0,0,(function(e){return this.localeData().weekdaysMin(this,e)})),W("ddd",0,0,(function(e){return this.localeData().weekdaysShort(this,e)})),W("dddd",0,0,(function(e){return this.localeData().weekdays(this,e)})),W("e",0,0,"weekday"),W("E",0,0,"isoWeekday"),Te("d",me),Te("e",me),Te("E",me),Te("dd",(function(e,t){return t.weekdaysMinRegex(e)})),Te("ddd",(function(e,t){return t.weekdaysShortRegex(e)})),Te("dddd",(function(e,t){return t.weekdaysRegex(e)})),Pe(["dd","ddd","dddd"],(function(e,t,n,r){var a=n._locale.weekdaysParse(e,r,n._strict);null!=a?t.d=a:y(n).invalidWeekday=e})),Pe(["d","e","E"],(function(e,t,n,r){t[r]=Oe(e)}));var Ht="Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),Pt="Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),Ct="Su_Mo_Tu_We_Th_Fr_Sa".split("_"),It=ke,Rt=ke,Nt=ke;function Ft(e,t){var n=i(this._weekdays)?this._weekdays:this._weekdays[e&&!0!==e&&this._weekdays.isFormat.test(t)?"format":"standalone"];return!0===e?At(n,this._week.dow):e?n[e.day()]:n}function Wt(e){return!0===e?At(this._weekdaysShort,this._week.dow):e?this._weekdaysShort[e.day()]:this._weekdaysShort}function $t(e){return!0===e?At(this._weekdaysMin,this._week.dow):e?this._weekdaysMin[e.day()]:this._weekdaysMin}function Ut(e,t,n){var r,a,s,i=e.toLocaleLowerCase();if(!this._weekdaysParse)for(this._weekdaysParse=[],this._shortWeekdaysParse=[],this._minWeekdaysParse=[],r=0;r<7;++r)s=f([2e3,1]).day(r),this._minWeekdaysParse[r]=this.weekdaysMin(s,"").toLocaleLowerCase(),this._shortWeekdaysParse[r]=this.weekdaysShort(s,"").toLocaleLowerCase(),this._weekdaysParse[r]=this.weekdays(s,"").toLocaleLowerCase();return n?"dddd"===t?-1!==(a=Ve.call(this._weekdaysParse,i))?a:null:"ddd"===t?-1!==(a=Ve.call(this._shortWeekdaysParse,i))?a:null:-1!==(a=Ve.call(this._minWeekdaysParse,i))?a:null:"dddd"===t?-1!==(a=Ve.call(this._weekdaysParse,i))||-1!==(a=Ve.call(this._shortWeekdaysParse,i))||-1!==(a=Ve.call(this._minWeekdaysParse,i))?a:null:"ddd"===t?-1!==(a=Ve.call(this._shortWeekdaysParse,i))||-1!==(a=Ve.call(this._weekdaysParse,i))||-1!==(a=Ve.call(this._minWeekdaysParse,i))?a:null:-1!==(a=Ve.call(this._minWeekdaysParse,i))||-1!==(a=Ve.call(this._weekdaysParse,i))||-1!==(a=Ve.call(this._shortWeekdaysParse,i))?a:null}function Bt(e,t,n){var r,a,s;if(this._weekdaysParseExact)return Ut.call(this,e,t,n);for(this._weekdaysParse||(this._weekdaysParse=[],this._minWeekdaysParse=[],this._shortWeekdaysParse=[],this._fullWeekdaysParse=[]),r=0;r<7;r++){if(a=f([2e3,1]).day(r),n&&!this._fullWeekdaysParse[r]&&(this._fullWeekdaysParse[r]=new RegExp("^"+this.weekdays(a,"").replace(".","\\.?")+"$","i"),this._shortWeekdaysParse[r]=new RegExp("^"+this.weekdaysShort(a,"").replace(".","\\.?")+"$","i"),this._minWeekdaysParse[r]=new RegExp("^"+this.weekdaysMin(a,"").replace(".","\\.?")+"$","i")),this._weekdaysParse[r]||(s="^"+this.weekdays(a,"")+"|^"+this.weekdaysShort(a,"")+"|^"+this.weekdaysMin(a,""),this._weekdaysParse[r]=new RegExp(s.replace(".",""),"i")),n&&"dddd"===t&&this._fullWeekdaysParse[r].test(e))return r;if(n&&"ddd"===t&&this._shortWeekdaysParse[r].test(e))return r;if(n&&"dd"===t&&this._minWeekdaysParse[r].test(e))return r;if(!n&&this._weekdaysParse[r].test(e))return r}}function zt(e){if(!this.isValid())return null!=e?this:NaN;var t=Xe(this,"Day");return null!=e?(e=xt(e,this.localeData()),this.add(e-t,"d")):t}function Jt(e){if(!this.isValid())return null!=e?this:NaN;var t=(this.day()+7-this.localeData()._week.dow)%7;return null==e?t:this.add(e-t,"d")}function Gt(e){if(!this.isValid())return null!=e?this:NaN;if(null!=e){var t=Ot(e,this.localeData());return this.day(this.day()%7?t:t-7)}return this.day()||7}function Vt(e){return this._weekdaysParseExact?(d(this,"_weekdaysRegex")||Zt.call(this),e?this._weekdaysStrictRegex:this._weekdaysRegex):(d(this,"_weekdaysRegex")||(this._weekdaysRegex=It),this._weekdaysStrictRegex&&e?this._weekdaysStrictRegex:this._weekdaysRegex)}function qt(e){return this._weekdaysParseExact?(d(this,"_weekdaysRegex")||Zt.call(this),e?this._weekdaysShortStrictRegex:this._weekdaysShortRegex):(d(this,"_weekdaysShortRegex")||(this._weekdaysShortRegex=Rt),this._weekdaysShortStrictRegex&&e?this._weekdaysShortStrictRegex:this._weekdaysShortRegex)}function Kt(e){return this._weekdaysParseExact?(d(this,"_weekdaysRegex")||Zt.call(this),e?this._weekdaysMinStrictRegex:this._weekdaysMinRegex):(d(this,"_weekdaysMinRegex")||(this._weekdaysMinRegex=Nt),this._weekdaysMinStrictRegex&&e?this._weekdaysMinStrictRegex:this._weekdaysMinRegex)}function Zt(){function e(e,t){return t.length-e.length}var t,n,r,a,s,i=[],o=[],d=[],u=[];for(t=0;t<7;t++)n=f([2e3,1]).day(t),r=Ee(this.weekdaysMin(n,"")),a=Ee(this.weekdaysShort(n,"")),s=Ee(this.weekdays(n,"")),i.push(r),o.push(a),d.push(s),u.push(r),u.push(a),u.push(s);i.sort(e),o.sort(e),d.sort(e),u.sort(e),this._weekdaysRegex=new RegExp("^("+u.join("|")+")","i"),this._weekdaysShortRegex=this._weekdaysRegex,this._weekdaysMinRegex=this._weekdaysRegex,this._weekdaysStrictRegex=new RegExp("^("+d.join("|")+")","i"),this._weekdaysShortStrictRegex=new RegExp("^("+o.join("|")+")","i"),this._weekdaysMinStrictRegex=new RegExp("^("+i.join("|")+")","i")}function Xt(){return this.hours()%12||12}function Qt(){return this.hours()||24}function en(e,t){W(e,0,0,(function(){return this.localeData().meridiem(this.hours(),this.minutes(),t)}))}function tn(e,t){return t._meridiemParse}function nn(e){return"p"===(e+"").toLowerCase().charAt(0)}W("H",["HH",2],0,"hour"),W("h",["hh",2],0,Xt),W("k",["kk",2],0,Qt),W("hmm",0,0,(function(){return""+Xt.apply(this)+C(this.minutes(),2)})),W("hmmss",0,0,(function(){return""+Xt.apply(this)+C(this.minutes(),2)+C(this.seconds(),2)})),W("Hmm",0,0,(function(){return""+this.hours()+C(this.minutes(),2)})),W("Hmmss",0,0,(function(){return""+this.hours()+C(this.minutes(),2)+C(this.seconds(),2)})),en("a",!0),en("A",!1),Te("a",tn),Te("A",tn),Te("H",me,De),Te("h",me,be),Te("k",me,be),Te("HH",me,ue),Te("hh",me,ue),Te("kk",me,ue),Te("hmm",he),Te("hmmss",fe),Te("Hmm",he),Te("Hmmss",fe),He(["H","HH"],We),He(["k","kk"],(function(e,t,n){var r=Oe(e);t[We]=24===r?0:r})),He(["a","A"],(function(e,t,n){n._isPm=n._locale.isPM(e),n._meridiem=e})),He(["h","hh"],(function(e,t,n){t[We]=Oe(e),y(n).bigHour=!0})),He("hmm",(function(e,t,n){var r=e.length-2;t[We]=Oe(e.substr(0,r)),t[$e]=Oe(e.substr(r)),y(n).bigHour=!0})),He("hmmss",(function(e,t,n){var r=e.length-4,a=e.length-2;t[We]=Oe(e.substr(0,r)),t[$e]=Oe(e.substr(r,2)),t[Ue]=Oe(e.substr(a)),y(n).bigHour=!0})),He("Hmm",(function(e,t,n){var r=e.length-2;t[We]=Oe(e.substr(0,r)),t[$e]=Oe(e.substr(r))})),He("Hmmss",(function(e,t,n){var r=e.length-4,a=e.length-2;t[We]=Oe(e.substr(0,r)),t[$e]=Oe(e.substr(r,2)),t[Ue]=Oe(e.substr(a))}));var rn=/[ap]\.?m?\.?/i,an=Ze("Hours",!0);function sn(e,t,n){return e>11?n?"pm":"PM":n?"am":"AM"}var on,dn={calendar:H,longDateFormat:J,invalidDate:V,ordinal:K,dayOfMonthOrdinalParse:Z,relativeTime:Q,months:at,monthsShort:st,week:Dt,weekdays:Ht,weekdaysMin:Ct,weekdaysShort:Pt,meridiemParse:rn},un={},ln={};function cn(e,t){var n,r=Math.min(e.length,t.length);for(n=0;n<r;n+=1)if(e[n]!==t[n])return n;return r}function _n(e){return e?e.toLowerCase().replace("_","-"):e}function mn(e){for(var t,n,r,a,s=0;s<e.length;){for(t=(a=_n(e[s]).split("-")).length,n=(n=_n(e[s+1]))?n.split("-"):null;t>0;){if(r=fn(a.slice(0,t).join("-")))return r;if(n&&n.length>=t&&cn(a,n)>=t-1)break;t--}s++}return on}function hn(e){return!(!e||!e.match("^[^/\\\\]*$"))}function fn(t){var r=null;if(void 0===un[t]&&e&&e.exports&&hn(t))try{r=on._abbr,n(35358)("./"+t),pn(r)}catch(e){un[t]=null}return un[t]}function pn(e,t){var n;return e&&((n=l(t)?gn(e):yn(e,t))?on=n:"undefined"!=typeof console&&console.warn&&console.warn("Locale "+e+" not found. Did you forget to load it?")),on._abbr}function yn(e,t){if(null!==t){var n,r=dn;if(t.abbr=e,null!=un[e])j("defineLocaleOverride","use moment.updateLocale(localeName, config) to change an existing locale. moment.defineLocale(localeName, config) should only be used for creating a new locale See http://momentjs.com/guides/#/warnings/define-locale/ for more info."),r=un[e]._config;else if(null!=t.parentLocale)if(null!=un[t.parentLocale])r=un[t.parentLocale]._config;else{if(null==(n=fn(t.parentLocale)))return ln[t.parentLocale]||(ln[t.parentLocale]=[]),ln[t.parentLocale].push({name:e,config:t}),null;r=n._config}return un[e]=new A(O(r,t)),ln[e]&&ln[e].forEach((function(e){yn(e.name,e.config)})),pn(e),un[e]}return delete un[e],null}function Mn(e,t){if(null!=t){var n,r,a=dn;null!=un[e]&&null!=un[e].parentLocale?un[e].set(O(un[e]._config,t)):(null!=(r=fn(e))&&(a=r._config),t=O(a,t),null==r&&(t.abbr=e),(n=new A(t)).parentLocale=un[e],un[e]=n),pn(e)}else null!=un[e]&&(null!=un[e].parentLocale?(un[e]=un[e].parentLocale,e===pn()&&pn(e)):null!=un[e]&&delete un[e]);return un[e]}function gn(e){var t;if(e&&e._locale&&e._locale._abbr&&(e=e._locale._abbr),!e)return on;if(!i(e)){if(t=fn(e))return t;e=[e]}return mn(e)}function Ln(){return T(un)}function vn(e){var t,n=e._a;return n&&-2===y(e).overflow&&(t=n[Ne]<0||n[Ne]>11?Ne:n[Fe]<1||n[Fe]>rt(n[Re],n[Ne])?Fe:n[We]<0||n[We]>24||24===n[We]&&(0!==n[$e]||0!==n[Ue]||0!==n[Be])?We:n[$e]<0||n[$e]>59?$e:n[Ue]<0||n[Ue]>59?Ue:n[Be]<0||n[Be]>999?Be:-1,y(e)._overflowDayOfYear&&(t<Re||t>Fe)&&(t=Fe),y(e)._overflowWeeks&&-1===t&&(t=ze),y(e)._overflowWeekday&&-1===t&&(t=Je),y(e).overflow=t),e}var Yn=/^\s*((?:[+-]\d{6}|\d{4})-(?:\d\d-\d\d|W\d\d-\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?::\d\d(?::\d\d(?:[.,]\d+)?)?)?)([+-]\d\d(?::?\d\d)?|\s*Z)?)?$/,wn=/^\s*((?:[+-]\d{6}|\d{4})(?:\d\d\d\d|W\d\d\d|W\d\d|\d\d\d|\d\d|))(?:(T| )(\d\d(?:\d\d(?:\d\d(?:[.,]\d+)?)?)?)([+-]\d\d(?::?\d\d)?|\s*Z)?)?$/,kn=/Z|[+-]\d\d(?::?\d\d)?/,bn=[["YYYYYY-MM-DD",/[+-]\d{6}-\d\d-\d\d/],["YYYY-MM-DD",/\d{4}-\d\d-\d\d/],["GGGG-[W]WW-E",/\d{4}-W\d\d-\d/],["GGGG-[W]WW",/\d{4}-W\d\d/,!1],["YYYY-DDD",/\d{4}-\d{3}/],["YYYY-MM",/\d{4}-\d\d/,!1],["YYYYYYMMDD",/[+-]\d{10}/],["YYYYMMDD",/\d{8}/],["GGGG[W]WWE",/\d{4}W\d{3}/],["GGGG[W]WW",/\d{4}W\d{2}/,!1],["YYYYDDD",/\d{7}/],["YYYYMM",/\d{6}/,!1],["YYYY",/\d{4}/,!1]],Dn=[["HH:mm:ss.SSSS",/\d\d:\d\d:\d\d\.\d+/],["HH:mm:ss,SSSS",/\d\d:\d\d:\d\d,\d+/],["HH:mm:ss",/\d\d:\d\d:\d\d/],["HH:mm",/\d\d:\d\d/],["HHmmss.SSSS",/\d\d\d\d\d\d\.\d+/],["HHmmss,SSSS",/\d\d\d\d\d\d,\d+/],["HHmmss",/\d\d\d\d\d\d/],["HHmm",/\d\d\d\d/],["HH",/\d\d/]],Tn=/^\/?Date\((-?\d+)/i,Sn=/^(?:(Mon|Tue|Wed|Thu|Fri|Sat|Sun),?\s)?(\d{1,2})\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\s(\d{2,4})\s(\d\d):(\d\d)(?::(\d\d))?\s(?:(UT|GMT|[ECMP][SD]T)|([Zz])|([+-]\d{4}))$/,jn={UT:0,GMT:0,EDT:-240,EST:-300,CDT:-300,CST:-360,MDT:-360,MST:-420,PDT:-420,PST:-480};function En(e){var t,n,r,a,s,i,o=e._i,d=Yn.exec(o)||wn.exec(o),u=bn.length,l=Dn.length;if(d){for(y(e).iso=!0,t=0,n=u;t<n;t++)if(bn[t][1].exec(d[1])){a=bn[t][0],r=!1!==bn[t][2];break}if(null==a)return void(e._isValid=!1);if(d[3]){for(t=0,n=l;t<n;t++)if(Dn[t][1].exec(d[3])){s=(d[2]||" ")+Dn[t][0];break}if(null==s)return void(e._isValid=!1)}if(!r&&null!=s)return void(e._isValid=!1);if(d[4]){if(!kn.exec(d[4]))return void(e._isValid=!1);i="Z"}e._f=a+(s||"")+(i||""),$n(e)}else e._isValid=!1}function xn(e,t,n,r,a,s){var i=[On(e),st.indexOf(t),parseInt(n,10),parseInt(r,10),parseInt(a,10)];return s&&i.push(parseInt(s,10)),i}function On(e){var t=parseInt(e,10);return t<=49?2e3+t:t<=999?1900+t:t}function An(e){return e.replace(/\([^()]*\)|[\n\t]/g," ").replace(/(\s\s+)/g," ").replace(/^\s\s*/,"").replace(/\s\s*$/,"")}function Hn(e,t,n){return!e||Pt.indexOf(e)===new Date(t[0],t[1],t[2]).getDay()||(y(n).weekdayMismatch=!0,n._isValid=!1,!1)}function Pn(e,t,n){if(e)return jn[e];if(t)return 0;var r=parseInt(n,10),a=r%100;return(r-a)/100*60+a}function Cn(e){var t,n=Sn.exec(An(e._i));if(n){if(t=xn(n[4],n[3],n[2],n[5],n[6],n[7]),!Hn(n[1],t,e))return;e._a=t,e._tzm=Pn(n[8],n[9],n[10]),e._d=Lt.apply(null,e._a),e._d.setUTCMinutes(e._d.getUTCMinutes()-e._tzm),y(e).rfc2822=!0}else e._isValid=!1}function In(e){var t=Tn.exec(e._i);null===t?(En(e),!1===e._isValid&&(delete e._isValid,Cn(e),!1===e._isValid&&(delete e._isValid,e._strict?e._isValid=!1:a.createFromInputFallback(e)))):e._d=new Date(+t[1])}function Rn(e,t,n){return null!=e?e:null!=t?t:n}function Nn(e){var t=new Date(a.now());return e._useUTC?[t.getUTCFullYear(),t.getUTCMonth(),t.getUTCDate()]:[t.getFullYear(),t.getMonth(),t.getDate()]}function Fn(e){var t,n,r,a,s,i=[];if(!e._d){for(r=Nn(e),e._w&&null==e._a[Fe]&&null==e._a[Ne]&&Wn(e),null!=e._dayOfYear&&(s=Rn(e._a[Re],r[Re]),(e._dayOfYear>Ge(s)||0===e._dayOfYear)&&(y(e)._overflowDayOfYear=!0),n=Lt(s,0,e._dayOfYear),e._a[Ne]=n.getUTCMonth(),e._a[Fe]=n.getUTCDate()),t=0;t<3&&null==e._a[t];++t)e._a[t]=i[t]=r[t];for(;t<7;t++)e._a[t]=i[t]=null==e._a[t]?2===t?1:0:e._a[t];24===e._a[We]&&0===e._a[$e]&&0===e._a[Ue]&&0===e._a[Be]&&(e._nextDay=!0,e._a[We]=0),e._d=(e._useUTC?Lt:gt).apply(null,i),a=e._useUTC?e._d.getUTCDay():e._d.getDay(),null!=e._tzm&&e._d.setUTCMinutes(e._d.getUTCMinutes()-e._tzm),e._nextDay&&(e._a[We]=24),e._w&&void 0!==e._w.d&&e._w.d!==a&&(y(e).weekdayMismatch=!0)}}function Wn(e){var t,n,r,a,s,i,o,d,u;null!=(t=e._w).GG||null!=t.W||null!=t.E?(s=1,i=4,n=Rn(t.GG,e._a[Re],wt(Kn(),1,4).year),r=Rn(t.W,1),((a=Rn(t.E,1))<1||a>7)&&(d=!0)):(s=e._locale._week.dow,i=e._locale._week.doy,u=wt(Kn(),s,i),n=Rn(t.gg,e._a[Re],u.year),r=Rn(t.w,u.week),null!=t.d?((a=t.d)<0||a>6)&&(d=!0):null!=t.e?(a=t.e+s,(t.e<0||t.e>6)&&(d=!0)):a=s),r<1||r>kt(n,s,i)?y(e)._overflowWeeks=!0:null!=d?y(e)._overflowWeekday=!0:(o=Yt(n,r,a,s,i),e._a[Re]=o.year,e._dayOfYear=o.dayOfYear)}function $n(e){if(e._f!==a.ISO_8601)if(e._f!==a.RFC_2822){e._a=[],y(e).empty=!0;var t,n,r,s,i,o,d,u=""+e._i,l=u.length,c=0;for(d=(r=z(e._f,e._locale).match(I)||[]).length,t=0;t<d;t++)s=r[t],(n=(u.match(Se(s,e))||[])[0])&&((i=u.substr(0,u.indexOf(n))).length>0&&y(e).unusedInput.push(i),u=u.slice(u.indexOf(n)+n.length),c+=n.length),F[s]?(n?y(e).empty=!1:y(e).unusedTokens.push(s),Ce(s,n,e)):e._strict&&!n&&y(e).unusedTokens.push(s);y(e).charsLeftOver=l-c,u.length>0&&y(e).unusedInput.push(u),e._a[We]<=12&&!0===y(e).bigHour&&e._a[We]>0&&(y(e).bigHour=void 0),y(e).parsedDateParts=e._a.slice(0),y(e).meridiem=e._meridiem,e._a[We]=Un(e._locale,e._a[We],e._meridiem),null!==(o=y(e).era)&&(e._a[Re]=e._locale.erasConvertYear(o,e._a[Re])),Fn(e),vn(e)}else Cn(e);else En(e)}function Un(e,t,n){var r;return null==n?t:null!=e.meridiemHour?e.meridiemHour(t,n):null!=e.isPM?((r=e.isPM(n))&&t<12&&(t+=12),r||12!==t||(t=0),t):t}function Bn(e){var t,n,r,a,s,i,o=!1,d=e._f.length;if(0===d)return y(e).invalidFormat=!0,void(e._d=new Date(NaN));for(a=0;a<d;a++)s=0,i=!1,t=Y({},e),null!=e._useUTC&&(t._useUTC=e._useUTC),t._f=e._f[a],$n(t),M(t)&&(i=!0),s+=y(t).charsLeftOver,s+=10*y(t).unusedTokens.length,y(t).score=s,o?s<r&&(r=s,n=t):(null==r||s<r||i)&&(r=s,n=t,i&&(o=!0));h(e,n||t)}function zn(e){if(!e._d){var t=ae(e._i),n=void 0===t.day?t.date:t.day;e._a=m([t.year,t.month,n,t.hour,t.minute,t.second,t.millisecond],(function(e){return e&&parseInt(e,10)})),Fn(e)}}function Jn(e){var t=new w(vn(Gn(e)));return t._nextDay&&(t.add(1,"d"),t._nextDay=void 0),t}function Gn(e){var t=e._i,n=e._f;return e._locale=e._locale||gn(e._l),null===t||void 0===n&&""===t?g({nullInput:!0}):("string"==typeof t&&(e._i=t=e._locale.preparse(t)),k(t)?new w(vn(t)):(_(t)?e._d=t:i(n)?Bn(e):n?$n(e):Vn(e),M(e)||(e._d=null),e))}function Vn(e){var t=e._i;l(t)?e._d=new Date(a.now()):_(t)?e._d=new Date(t.valueOf()):"string"==typeof t?In(e):i(t)?(e._a=m(t.slice(0),(function(e){return parseInt(e,10)})),Fn(e)):o(t)?zn(e):c(t)?e._d=new Date(t):a.createFromInputFallback(e)}function qn(e,t,n,r,a){var s={};return!0!==t&&!1!==t||(r=t,t=void 0),!0!==n&&!1!==n||(r=n,n=void 0),(o(e)&&u(e)||i(e)&&0===e.length)&&(e=void 0),s._isAMomentObject=!0,s._useUTC=s._isUTC=a,s._l=n,s._i=e,s._f=t,s._strict=r,Jn(s)}function Kn(e,t,n,r){return qn(e,t,n,r,!1)}a.createFromInputFallback=D("value provided is not in a recognized RFC2822 or ISO format. moment construction falls back to js Date(), which is not reliable across all browsers and versions. Non RFC2822/ISO date formats are discouraged. Please refer to http://momentjs.com/guides/#/warnings/js-date/ for more info.",(function(e){e._d=new Date(e._i+(e._useUTC?" UTC":""))})),a.ISO_8601=function(){},a.RFC_2822=function(){};var Zn=D("moment().min is deprecated, use moment.max instead. http://momentjs.com/guides/#/warnings/min-max/",(function(){var e=Kn.apply(null,arguments);return this.isValid()&&e.isValid()?e<this?this:e:g()})),Xn=D("moment().max is deprecated, use moment.min instead. http://momentjs.com/guides/#/warnings/min-max/",(function(){var e=Kn.apply(null,arguments);return this.isValid()&&e.isValid()?e>this?this:e:g()}));function Qn(e,t){var n,r;if(1===t.length&&i(t[0])&&(t=t[0]),!t.length)return Kn();for(n=t[0],r=1;r<t.length;++r)t[r].isValid()&&!t[r][e](n)||(n=t[r]);return n}function er(){return Qn("isBefore",[].slice.call(arguments,0))}function tr(){return Qn("isAfter",[].slice.call(arguments,0))}var nr=function(){return Date.now?Date.now():+new Date},rr=["year","quarter","month","week","day","hour","minute","second","millisecond"];function ar(e){var t,n,r=!1,a=rr.length;for(t in e)if(d(e,t)&&(-1===Ve.call(rr,t)||null!=e[t]&&isNaN(e[t])))return!1;for(n=0;n<a;++n)if(e[rr[n]]){if(r)return!1;parseFloat(e[rr[n]])!==Oe(e[rr[n]])&&(r=!0)}return!0}function sr(){return this._isValid}function ir(){return jr(NaN)}function or(e){var t=ae(e),n=t.year||0,r=t.quarter||0,a=t.month||0,s=t.week||t.isoWeek||0,i=t.day||0,o=t.hour||0,d=t.minute||0,u=t.second||0,l=t.millisecond||0;this._isValid=ar(t),this._milliseconds=+l+1e3*u+6e4*d+1e3*o*60*60,this._days=+i+7*s,this._months=+a+3*r+12*n,this._data={},this._locale=gn(),this._bubble()}function dr(e){return e instanceof or}function ur(e){return e<0?-1*Math.round(-1*e):Math.round(e)}function lr(e,t,n){var r,a=Math.min(e.length,t.length),s=Math.abs(e.length-t.length),i=0;for(r=0;r<a;r++)(n&&e[r]!==t[r]||!n&&Oe(e[r])!==Oe(t[r]))&&i++;return i+s}function cr(e,t){W(e,0,0,(function(){var e=this.utcOffset(),n="+";return e<0&&(e=-e,n="-"),n+C(~~(e/60),2)+t+C(~~e%60,2)}))}cr("Z",":"),cr("ZZ",""),Te("Z",Ye),Te("ZZ",Ye),He(["Z","ZZ"],(function(e,t,n){n._useUTC=!0,n._tzm=mr(Ye,e)}));var _r=/([\+\-]|\d\d)/gi;function mr(e,t){var n,r,a=(t||"").match(e);return null===a?null:0===(r=60*(n=((a[a.length-1]||[])+"").match(_r)||["-",0,0])[1]+Oe(n[2]))?0:"+"===n[0]?r:-r}function hr(e,t){var n,r;return t._isUTC?(n=t.clone(),r=(k(e)||_(e)?e.valueOf():Kn(e).valueOf())-n.valueOf(),n._d.setTime(n._d.valueOf()+r),a.updateOffset(n,!1),n):Kn(e).local()}function fr(e){return-Math.round(e._d.getTimezoneOffset())}function pr(e,t,n){var r,s=this._offset||0;if(!this.isValid())return null!=e?this:NaN;if(null!=e){if("string"==typeof e){if(null===(e=mr(Ye,e)))return this}else Math.abs(e)<16&&!n&&(e*=60);return!this._isUTC&&t&&(r=fr(this)),this._offset=e,this._isUTC=!0,null!=r&&this.add(r,"m"),s!==e&&(!t||this._changeInProgress?Hr(this,jr(e-s,"m"),1,!1):this._changeInProgress||(this._changeInProgress=!0,a.updateOffset(this,!0),this._changeInProgress=null)),this}return this._isUTC?s:fr(this)}function yr(e,t){return null!=e?("string"!=typeof e&&(e=-e),this.utcOffset(e,t),this):-this.utcOffset()}function Mr(e){return this.utcOffset(0,e)}function gr(e){return this._isUTC&&(this.utcOffset(0,e),this._isUTC=!1,e&&this.subtract(fr(this),"m")),this}function Lr(){if(null!=this._tzm)this.utcOffset(this._tzm,!1,!0);else if("string"==typeof this._i){var e=mr(ve,this._i);null!=e?this.utcOffset(e):this.utcOffset(0,!0)}return this}function vr(e){return!!this.isValid()&&(e=e?Kn(e).utcOffset():0,(this.utcOffset()-e)%60==0)}function Yr(){return this.utcOffset()>this.clone().month(0).utcOffset()||this.utcOffset()>this.clone().month(5).utcOffset()}function wr(){if(!l(this._isDSTShifted))return this._isDSTShifted;var e,t={};return Y(t,this),(t=Gn(t))._a?(e=t._isUTC?f(t._a):Kn(t._a),this._isDSTShifted=this.isValid()&&lr(t._a,e.toArray())>0):this._isDSTShifted=!1,this._isDSTShifted}function kr(){return!!this.isValid()&&!this._isUTC}function br(){return!!this.isValid()&&this._isUTC}function Dr(){return!!this.isValid()&&this._isUTC&&0===this._offset}a.updateOffset=function(){};var Tr=/^(-|\+)?(?:(\d*)[. ])?(\d+):(\d+)(?::(\d+)(\.\d*)?)?$/,Sr=/^(-|\+)?P(?:([-+]?[0-9,.]*)Y)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)W)?(?:([-+]?[0-9,.]*)D)?(?:T(?:([-+]?[0-9,.]*)H)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)S)?)?$/;function jr(e,t){var n,r,a,s=e,i=null;return dr(e)?s={ms:e._milliseconds,d:e._days,M:e._months}:c(e)||!isNaN(+e)?(s={},t?s[t]=+e:s.milliseconds=+e):(i=Tr.exec(e))?(n="-"===i[1]?-1:1,s={y:0,d:Oe(i[Fe])*n,h:Oe(i[We])*n,m:Oe(i[$e])*n,s:Oe(i[Ue])*n,ms:Oe(ur(1e3*i[Be]))*n}):(i=Sr.exec(e))?(n="-"===i[1]?-1:1,s={y:Er(i[2],n),M:Er(i[3],n),w:Er(i[4],n),d:Er(i[5],n),h:Er(i[6],n),m:Er(i[7],n),s:Er(i[8],n)}):null==s?s={}:"object"==typeof s&&("from"in s||"to"in s)&&(a=Or(Kn(s.from),Kn(s.to)),(s={}).ms=a.milliseconds,s.M=a.months),r=new or(s),dr(e)&&d(e,"_locale")&&(r._locale=e._locale),dr(e)&&d(e,"_isValid")&&(r._isValid=e._isValid),r}function Er(e,t){var n=e&&parseFloat(e.replace(",","."));return(isNaN(n)?0:n)*t}function xr(e,t){var n={};return n.months=t.month()-e.month()+12*(t.year()-e.year()),e.clone().add(n.months,"M").isAfter(t)&&--n.months,n.milliseconds=+t-+e.clone().add(n.months,"M"),n}function Or(e,t){var n;return e.isValid()&&t.isValid()?(t=hr(t,e),e.isBefore(t)?n=xr(e,t):((n=xr(t,e)).milliseconds=-n.milliseconds,n.months=-n.months),n):{milliseconds:0,months:0}}function Ar(e,t){return function(n,r){var a;return null===r||isNaN(+r)||(j(t,"moment()."+t+"(period, number) is deprecated. Please use moment()."+t+"(number, period). See http://momentjs.com/guides/#/warnings/add-inverted-param/ for more info."),a=n,n=r,r=a),Hr(this,jr(n,r),e),this}}function Hr(e,t,n,r){var s=t._milliseconds,i=ur(t._days),o=ur(t._months);e.isValid()&&(r=null==r||r,o&&mt(e,Xe(e,"Month")+o*n),i&&Qe(e,"Date",Xe(e,"Date")+i*n),s&&e._d.setTime(e._d.valueOf()+s*n),r&&a.updateOffset(e,i||o))}jr.fn=or.prototype,jr.invalid=ir;var Pr=Ar(1,"add"),Cr=Ar(-1,"subtract");function Ir(e){return"string"==typeof e||e instanceof String}function Rr(e){return k(e)||_(e)||Ir(e)||c(e)||Fr(e)||Nr(e)||null==e}function Nr(e){var t,n,r=o(e)&&!u(e),a=!1,s=["years","year","y","months","month","M","days","day","d","dates","date","D","hours","hour","h","minutes","minute","m","seconds","second","s","milliseconds","millisecond","ms"],i=s.length;for(t=0;t<i;t+=1)n=s[t],a=a||d(e,n);return r&&a}function Fr(e){var t=i(e),n=!1;return t&&(n=0===e.filter((function(t){return!c(t)&&Ir(e)})).length),t&&n}function Wr(e){var t,n,r=o(e)&&!u(e),a=!1,s=["sameDay","nextDay","lastDay","nextWeek","lastWeek","sameElse"];for(t=0;t<s.length;t+=1)n=s[t],a=a||d(e,n);return r&&a}function $r(e,t){var n=e.diff(t,"days",!0);return n<-6?"sameElse":n<-1?"lastWeek":n<0?"lastDay":n<1?"sameDay":n<2?"nextDay":n<7?"nextWeek":"sameElse"}function Ur(e,t){1===arguments.length&&(arguments[0]?Rr(arguments[0])?(e=arguments[0],t=void 0):Wr(arguments[0])&&(t=arguments[0],e=void 0):(e=void 0,t=void 0));var n=e||Kn(),r=hr(n,this).startOf("day"),s=a.calendarFormat(this,r)||"sameElse",i=t&&(E(t[s])?t[s].call(this,n):t[s]);return this.format(i||this.localeData().calendar(s,this,Kn(n)))}function Br(){return new w(this)}function zr(e,t){var n=k(e)?e:Kn(e);return!(!this.isValid()||!n.isValid())&&("millisecond"===(t=re(t)||"millisecond")?this.valueOf()>n.valueOf():n.valueOf()<this.clone().startOf(t).valueOf())}function Jr(e,t){var n=k(e)?e:Kn(e);return!(!this.isValid()||!n.isValid())&&("millisecond"===(t=re(t)||"millisecond")?this.valueOf()<n.valueOf():this.clone().endOf(t).valueOf()<n.valueOf())}function Gr(e,t,n,r){var a=k(e)?e:Kn(e),s=k(t)?t:Kn(t);return!!(this.isValid()&&a.isValid()&&s.isValid())&&("("===(r=r||"()")[0]?this.isAfter(a,n):!this.isBefore(a,n))&&(")"===r[1]?this.isBefore(s,n):!this.isAfter(s,n))}function Vr(e,t){var n,r=k(e)?e:Kn(e);return!(!this.isValid()||!r.isValid())&&("millisecond"===(t=re(t)||"millisecond")?this.valueOf()===r.valueOf():(n=r.valueOf(),this.clone().startOf(t).valueOf()<=n&&n<=this.clone().endOf(t).valueOf()))}function qr(e,t){return this.isSame(e,t)||this.isAfter(e,t)}function Kr(e,t){return this.isSame(e,t)||this.isBefore(e,t)}function Zr(e,t,n){var r,a,s;if(!this.isValid())return NaN;if(!(r=hr(e,this)).isValid())return NaN;switch(a=6e4*(r.utcOffset()-this.utcOffset()),t=re(t)){case"year":s=Xr(this,r)/12;break;case"month":s=Xr(this,r);break;case"quarter":s=Xr(this,r)/3;break;case"second":s=(this-r)/1e3;break;case"minute":s=(this-r)/6e4;break;case"hour":s=(this-r)/36e5;break;case"day":s=(this-r-a)/864e5;break;case"week":s=(this-r-a)/6048e5;break;default:s=this-r}return n?s:xe(s)}function Xr(e,t){if(e.date()<t.date())return-Xr(t,e);var n=12*(t.year()-e.year())+(t.month()-e.month()),r=e.clone().add(n,"months");return-(n+(t-r<0?(t-r)/(r-e.clone().add(n-1,"months")):(t-r)/(e.clone().add(n+1,"months")-r)))||0}function Qr(){return this.clone().locale("en").format("ddd MMM DD YYYY HH:mm:ss [GMT]ZZ")}function ea(e){if(!this.isValid())return null;var t=!0!==e,n=t?this.clone().utc():this;return n.year()<0||n.year()>9999?B(n,t?"YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]":"YYYYYY-MM-DD[T]HH:mm:ss.SSSZ"):E(Date.prototype.toISOString)?t?this.toDate().toISOString():new Date(this.valueOf()+60*this.utcOffset()*1e3).toISOString().replace("Z",B(n,"Z")):B(n,t?"YYYY-MM-DD[T]HH:mm:ss.SSS[Z]":"YYYY-MM-DD[T]HH:mm:ss.SSSZ")}function ta(){if(!this.isValid())return"moment.invalid(/* "+this._i+" */)";var e,t,n,r,a="moment",s="";return this.isLocal()||(a=0===this.utcOffset()?"moment.utc":"moment.parseZone",s="Z"),e="["+a+'("]',t=0<=this.year()&&this.year()<=9999?"YYYY":"YYYYYY",n="-MM-DD[T]HH:mm:ss.SSS",r=s+'[")]',this.format(e+t+n+r)}function na(e){e||(e=this.isUtc()?a.defaultFormatUtc:a.defaultFormat);var t=B(this,e);return this.localeData().postformat(t)}function ra(e,t){return this.isValid()&&(k(e)&&e.isValid()||Kn(e).isValid())?jr({to:this,from:e}).locale(this.locale()).humanize(!t):this.localeData().invalidDate()}function aa(e){return this.from(Kn(),e)}function sa(e,t){return this.isValid()&&(k(e)&&e.isValid()||Kn(e).isValid())?jr({from:this,to:e}).locale(this.locale()).humanize(!t):this.localeData().invalidDate()}function ia(e){return this.to(Kn(),e)}function oa(e){var t;return void 0===e?this._locale._abbr:(null!=(t=gn(e))&&(this._locale=t),this)}a.defaultFormat="YYYY-MM-DDTHH:mm:ssZ",a.defaultFormatUtc="YYYY-MM-DDTHH:mm:ss[Z]";var da=D("moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.",(function(e){return void 0===e?this.localeData():this.locale(e)}));function ua(){return this._locale}var la=1e3,ca=60*la,_a=60*ca,ma=3506328*_a;function ha(e,t){return(e%t+t)%t}function fa(e,t,n){return e<100&&e>=0?new Date(e+400,t,n)-ma:new Date(e,t,n).valueOf()}function pa(e,t,n){return e<100&&e>=0?Date.UTC(e+400,t,n)-ma:Date.UTC(e,t,n)}function ya(e){var t,n;if(void 0===(e=re(e))||"millisecond"===e||!this.isValid())return this;switch(n=this._isUTC?pa:fa,e){case"year":t=n(this.year(),0,1);break;case"quarter":t=n(this.year(),this.month()-this.month()%3,1);break;case"month":t=n(this.year(),this.month(),1);break;case"week":t=n(this.year(),this.month(),this.date()-this.weekday());break;case"isoWeek":t=n(this.year(),this.month(),this.date()-(this.isoWeekday()-1));break;case"day":case"date":t=n(this.year(),this.month(),this.date());break;case"hour":t=this._d.valueOf(),t-=ha(t+(this._isUTC?0:this.utcOffset()*ca),_a);break;case"minute":t=this._d.valueOf(),t-=ha(t,ca);break;case"second":t=this._d.valueOf(),t-=ha(t,la)}return this._d.setTime(t),a.updateOffset(this,!0),this}function Ma(e){var t,n;if(void 0===(e=re(e))||"millisecond"===e||!this.isValid())return this;switch(n=this._isUTC?pa:fa,e){case"year":t=n(this.year()+1,0,1)-1;break;case"quarter":t=n(this.year(),this.month()-this.month()%3+3,1)-1;break;case"month":t=n(this.year(),this.month()+1,1)-1;break;case"week":t=n(this.year(),this.month(),this.date()-this.weekday()+7)-1;break;case"isoWeek":t=n(this.year(),this.month(),this.date()-(this.isoWeekday()-1)+7)-1;break;case"day":case"date":t=n(this.year(),this.month(),this.date()+1)-1;break;case"hour":t=this._d.valueOf(),t+=_a-ha(t+(this._isUTC?0:this.utcOffset()*ca),_a)-1;break;case"minute":t=this._d.valueOf(),t+=ca-ha(t,ca)-1;break;case"second":t=this._d.valueOf(),t+=la-ha(t,la)-1}return this._d.setTime(t),a.updateOffset(this,!0),this}function ga(){return this._d.valueOf()-6e4*(this._offset||0)}function La(){return Math.floor(this.valueOf()/1e3)}function va(){return new Date(this.valueOf())}function Ya(){var e=this;return[e.year(),e.month(),e.date(),e.hour(),e.minute(),e.second(),e.millisecond()]}function wa(){var e=this;return{years:e.year(),months:e.month(),date:e.date(),hours:e.hours(),minutes:e.minutes(),seconds:e.seconds(),milliseconds:e.milliseconds()}}function ka(){return this.isValid()?this.toISOString():null}function ba(){return M(this)}function Da(){return h({},y(this))}function Ta(){return y(this).overflow}function Sa(){return{input:this._i,format:this._f,locale:this._locale,isUTC:this._isUTC,strict:this._strict}}function ja(e,t){var n,r,s,i=this._eras||gn("en")._eras;for(n=0,r=i.length;n<r;++n)switch("string"==typeof i[n].since&&(s=a(i[n].since).startOf("day"),i[n].since=s.valueOf()),typeof i[n].until){case"undefined":i[n].until=1/0;break;case"string":s=a(i[n].until).startOf("day").valueOf(),i[n].until=s.valueOf()}return i}function Ea(e,t,n){var r,a,s,i,o,d=this.eras();for(e=e.toUpperCase(),r=0,a=d.length;r<a;++r)if(s=d[r].name.toUpperCase(),i=d[r].abbr.toUpperCase(),o=d[r].narrow.toUpperCase(),n)switch(t){case"N":case"NN":case"NNN":if(i===e)return d[r];break;case"NNNN":if(s===e)return d[r];break;case"NNNNN":if(o===e)return d[r]}else if([s,i,o].indexOf(e)>=0)return d[r]}function xa(e,t){var n=e.since<=e.until?1:-1;return void 0===t?a(e.since).year():a(e.since).year()+(t-e.offset)*n}function Oa(){var e,t,n,r=this.localeData().eras();for(e=0,t=r.length;e<t;++e){if(n=this.clone().startOf("day").valueOf(),r[e].since<=n&&n<=r[e].until)return r[e].name;if(r[e].until<=n&&n<=r[e].since)return r[e].name}return""}function Aa(){var e,t,n,r=this.localeData().eras();for(e=0,t=r.length;e<t;++e){if(n=this.clone().startOf("day").valueOf(),r[e].since<=n&&n<=r[e].until)return r[e].narrow;if(r[e].until<=n&&n<=r[e].since)return r[e].narrow}return""}function Ha(){var e,t,n,r=this.localeData().eras();for(e=0,t=r.length;e<t;++e){if(n=this.clone().startOf("day").valueOf(),r[e].since<=n&&n<=r[e].until)return r[e].abbr;if(r[e].until<=n&&n<=r[e].since)return r[e].abbr}return""}function Pa(){var e,t,n,r,s=this.localeData().eras();for(e=0,t=s.length;e<t;++e)if(n=s[e].since<=s[e].until?1:-1,r=this.clone().startOf("day").valueOf(),s[e].since<=r&&r<=s[e].until||s[e].until<=r&&r<=s[e].since)return(this.year()-a(s[e].since).year())*n+s[e].offset;return this.year()}function Ca(e){return d(this,"_erasNameRegex")||Ua.call(this),e?this._erasNameRegex:this._erasRegex}function Ia(e){return d(this,"_erasAbbrRegex")||Ua.call(this),e?this._erasAbbrRegex:this._erasRegex}function Ra(e){return d(this,"_erasNarrowRegex")||Ua.call(this),e?this._erasNarrowRegex:this._erasRegex}function Na(e,t){return t.erasAbbrRegex(e)}function Fa(e,t){return t.erasNameRegex(e)}function Wa(e,t){return t.erasNarrowRegex(e)}function $a(e,t){return t._eraYearOrdinalRegex||ge}function Ua(){var e,t,n,r,a,s=[],i=[],o=[],d=[],u=this.eras();for(e=0,t=u.length;e<t;++e)n=Ee(u[e].name),r=Ee(u[e].abbr),a=Ee(u[e].narrow),i.push(n),s.push(r),o.push(a),d.push(n),d.push(r),d.push(a);this._erasRegex=new RegExp("^("+d.join("|")+")","i"),this._erasNameRegex=new RegExp("^("+i.join("|")+")","i"),this._erasAbbrRegex=new RegExp("^("+s.join("|")+")","i"),this._erasNarrowRegex=new RegExp("^("+o.join("|")+")","i")}function Ba(e,t){W(0,[e,e.length],0,t)}function za(e){return Za.call(this,e,this.week(),this.weekday()+this.localeData()._week.dow,this.localeData()._week.dow,this.localeData()._week.doy)}function Ja(e){return Za.call(this,e,this.isoWeek(),this.isoWeekday(),1,4)}function Ga(){return kt(this.year(),1,4)}function Va(){return kt(this.isoWeekYear(),1,4)}function qa(){var e=this.localeData()._week;return kt(this.year(),e.dow,e.doy)}function Ka(){var e=this.localeData()._week;return kt(this.weekYear(),e.dow,e.doy)}function Za(e,t,n,r,a){var s;return null==e?wt(this,r,a).year:(t>(s=kt(e,r,a))&&(t=s),Xa.call(this,e,t,n,r,a))}function Xa(e,t,n,r,a){var s=Yt(e,t,n,r,a),i=Lt(s.year,0,s.dayOfYear);return this.year(i.getUTCFullYear()),this.month(i.getUTCMonth()),this.date(i.getUTCDate()),this}function Qa(e){return null==e?Math.ceil((this.month()+1)/3):this.month(3*(e-1)+this.month()%3)}W("N",0,0,"eraAbbr"),W("NN",0,0,"eraAbbr"),W("NNN",0,0,"eraAbbr"),W("NNNN",0,0,"eraName"),W("NNNNN",0,0,"eraNarrow"),W("y",["y",1],"yo","eraYear"),W("y",["yy",2],0,"eraYear"),W("y",["yyy",3],0,"eraYear"),W("y",["yyyy",4],0,"eraYear"),Te("N",Na),Te("NN",Na),Te("NNN",Na),Te("NNNN",Fa),Te("NNNNN",Wa),He(["N","NN","NNN","NNNN","NNNNN"],(function(e,t,n,r){var a=n._locale.erasParse(e,r,n._strict);a?y(n).era=a:y(n).invalidEra=e})),Te("y",ge),Te("yy",ge),Te("yyy",ge),Te("yyyy",ge),Te("yo",$a),He(["y","yy","yyy","yyyy"],Re),He(["yo"],(function(e,t,n,r){var a;n._locale._eraYearOrdinalRegex&&(a=e.match(n._locale._eraYearOrdinalRegex)),n._locale.eraYearOrdinalParse?t[Re]=n._locale.eraYearOrdinalParse(e,a):t[Re]=parseInt(e,10)})),W(0,["gg",2],0,(function(){return this.weekYear()%100})),W(0,["GG",2],0,(function(){return this.isoWeekYear()%100})),Ba("gggg","weekYear"),Ba("ggggg","weekYear"),Ba("GGGG","isoWeekYear"),Ba("GGGGG","isoWeekYear"),Te("G",Le),Te("g",Le),Te("GG",me,ue),Te("gg",me,ue),Te("GGGG",ye,ce),Te("gggg",ye,ce),Te("GGGGG",Me,_e),Te("ggggg",Me,_e),Pe(["gggg","ggggg","GGGG","GGGGG"],(function(e,t,n,r){t[r.substr(0,2)]=Oe(e)})),Pe(["gg","GG"],(function(e,t,n,r){t[r]=a.parseTwoDigitYear(e)})),W("Q",0,"Qo","quarter"),Te("Q",de),He("Q",(function(e,t){t[Ne]=3*(Oe(e)-1)})),W("D",["DD",2],"Do","date"),Te("D",me,be),Te("DD",me,ue),Te("Do",(function(e,t){return e?t._dayOfMonthOrdinalParse||t._ordinalParse:t._dayOfMonthOrdinalParseLenient})),He(["D","DD"],Fe),He("Do",(function(e,t){t[Fe]=Oe(e.match(me)[0])}));var es=Ze("Date",!0);function ts(e){var t=Math.round((this.clone().startOf("day")-this.clone().startOf("year"))/864e5)+1;return null==e?t:this.add(e-t,"d")}W("DDD",["DDDD",3],"DDDo","dayOfYear"),Te("DDD",pe),Te("DDDD",le),He(["DDD","DDDD"],(function(e,t,n){n._dayOfYear=Oe(e)})),W("m",["mm",2],0,"minute"),Te("m",me,De),Te("mm",me,ue),He(["m","mm"],$e);var ns=Ze("Minutes",!1);W("s",["ss",2],0,"second"),Te("s",me,De),Te("ss",me,ue),He(["s","ss"],Ue);var rs,as,ss=Ze("Seconds",!1);for(W("S",0,0,(function(){return~~(this.millisecond()/100)})),W(0,["SS",2],0,(function(){return~~(this.millisecond()/10)})),W(0,["SSS",3],0,"millisecond"),W(0,["SSSS",4],0,(function(){return 10*this.millisecond()})),W(0,["SSSSS",5],0,(function(){return 100*this.millisecond()})),W(0,["SSSSSS",6],0,(function(){return 1e3*this.millisecond()})),W(0,["SSSSSSS",7],0,(function(){return 1e4*this.millisecond()})),W(0,["SSSSSSSS",8],0,(function(){return 1e5*this.millisecond()})),W(0,["SSSSSSSSS",9],0,(function(){return 1e6*this.millisecond()})),Te("S",pe,de),Te("SS",pe,ue),Te("SSS",pe,le),rs="SSSS";rs.length<=9;rs+="S")Te(rs,ge);function is(e,t){t[Be]=Oe(1e3*("0."+e))}for(rs="S";rs.length<=9;rs+="S")He(rs,is);function os(){return this._isUTC?"UTC":""}function ds(){return this._isUTC?"Coordinated Universal Time":""}as=Ze("Milliseconds",!1),W("z",0,0,"zoneAbbr"),W("zz",0,0,"zoneName");var us=w.prototype;function ls(e){return Kn(1e3*e)}function cs(){return Kn.apply(null,arguments).parseZone()}function _s(e){return e}us.add=Pr,us.calendar=Ur,us.clone=Br,us.diff=Zr,us.endOf=Ma,us.format=na,us.from=ra,us.fromNow=aa,us.to=sa,us.toNow=ia,us.get=et,us.invalidAt=Ta,us.isAfter=zr,us.isBefore=Jr,us.isBetween=Gr,us.isSame=Vr,us.isSameOrAfter=qr,us.isSameOrBefore=Kr,us.isValid=ba,us.lang=da,us.locale=oa,us.localeData=ua,us.max=Xn,us.min=Zn,us.parsingFlags=Da,us.set=tt,us.startOf=ya,us.subtract=Cr,us.toArray=Ya,us.toObject=wa,us.toDate=va,us.toISOString=ea,us.inspect=ta,"undefined"!=typeof Symbol&&null!=Symbol.for&&(us[Symbol.for("nodejs.util.inspect.custom")]=function(){return"Moment<"+this.format()+">"}),us.toJSON=ka,us.toString=Qr,us.unix=La,us.valueOf=ga,us.creationData=Sa,us.eraName=Oa,us.eraNarrow=Aa,us.eraAbbr=Ha,us.eraYear=Pa,us.year=qe,us.isLeapYear=Ke,us.weekYear=za,us.isoWeekYear=Ja,us.quarter=us.quarters=Qa,us.month=ht,us.daysInMonth=ft,us.week=us.weeks=jt,us.isoWeek=us.isoWeeks=Et,us.weeksInYear=qa,us.weeksInWeekYear=Ka,us.isoWeeksInYear=Ga,us.isoWeeksInISOWeekYear=Va,us.date=es,us.day=us.days=zt,us.weekday=Jt,us.isoWeekday=Gt,us.dayOfYear=ts,us.hour=us.hours=an,us.minute=us.minutes=ns,us.second=us.seconds=ss,us.millisecond=us.milliseconds=as,us.utcOffset=pr,us.utc=Mr,us.local=gr,us.parseZone=Lr,us.hasAlignedHourOffset=vr,us.isDST=Yr,us.isLocal=kr,us.isUtcOffset=br,us.isUtc=Dr,us.isUTC=Dr,us.zoneAbbr=os,us.zoneName=ds,us.dates=D("dates accessor is deprecated. Use date instead.",es),us.months=D("months accessor is deprecated. Use month instead",ht),us.years=D("years accessor is deprecated. Use year instead",qe),us.zone=D("moment().zone is deprecated, use moment().utcOffset instead. http://momentjs.com/guides/#/warnings/zone/",yr),us.isDSTShifted=D("isDSTShifted is deprecated. See http://momentjs.com/guides/#/warnings/dst-shifted/ for more information",wr);var ms=A.prototype;function hs(e,t,n,r){var a=gn(),s=f().set(r,t);return a[n](s,e)}function fs(e,t,n){if(c(e)&&(t=e,e=void 0),e=e||"",null!=t)return hs(e,t,n,"month");var r,a=[];for(r=0;r<12;r++)a[r]=hs(e,r,n,"month");return a}function ps(e,t,n,r){"boolean"==typeof e?(c(t)&&(n=t,t=void 0),t=t||""):(n=t=e,e=!1,c(t)&&(n=t,t=void 0),t=t||"");var a,s=gn(),i=e?s._week.dow:0,o=[];if(null!=n)return hs(t,(n+i)%7,r,"day");for(a=0;a<7;a++)o[a]=hs(t,(a+i)%7,r,"day");return o}function ys(e,t){return fs(e,t,"months")}function Ms(e,t){return fs(e,t,"monthsShort")}function gs(e,t,n){return ps(e,t,n,"weekdays")}function Ls(e,t,n){return ps(e,t,n,"weekdaysShort")}function vs(e,t,n){return ps(e,t,n,"weekdaysMin")}ms.calendar=P,ms.longDateFormat=G,ms.invalidDate=q,ms.ordinal=X,ms.preparse=_s,ms.postformat=_s,ms.relativeTime=ee,ms.pastFuture=te,ms.set=x,ms.eras=ja,ms.erasParse=Ea,ms.erasConvertYear=xa,ms.erasAbbrRegex=Ia,ms.erasNameRegex=Ca,ms.erasNarrowRegex=Ra,ms.months=ut,ms.monthsShort=lt,ms.monthsParse=_t,ms.monthsRegex=yt,ms.monthsShortRegex=pt,ms.week=bt,ms.firstDayOfYear=St,ms.firstDayOfWeek=Tt,ms.weekdays=Ft,ms.weekdaysMin=$t,ms.weekdaysShort=Wt,ms.weekdaysParse=Bt,ms.weekdaysRegex=Vt,ms.weekdaysShortRegex=qt,ms.weekdaysMinRegex=Kt,ms.isPM=nn,ms.meridiem=sn,pn("en",{eras:[{since:"0001-01-01",until:1/0,offset:1,name:"Anno Domini",narrow:"AD",abbr:"AD"},{since:"0000-12-31",until:-1/0,offset:1,name:"Before Christ",narrow:"BC",abbr:"BC"}],dayOfMonthOrdinalParse:/\d{1,2}(th|st|nd|rd)/,ordinal:function(e){var t=e%10;return e+(1===Oe(e%100/10)?"th":1===t?"st":2===t?"nd":3===t?"rd":"th")}}),a.lang=D("moment.lang is deprecated. Use moment.locale instead.",pn),a.langData=D("moment.langData is deprecated. Use moment.localeData instead.",gn);var Ys=Math.abs;function ws(){var e=this._data;return this._milliseconds=Ys(this._milliseconds),this._days=Ys(this._days),this._months=Ys(this._months),e.milliseconds=Ys(e.milliseconds),e.seconds=Ys(e.seconds),e.minutes=Ys(e.minutes),e.hours=Ys(e.hours),e.months=Ys(e.months),e.years=Ys(e.years),this}function ks(e,t,n,r){var a=jr(t,n);return e._milliseconds+=r*a._milliseconds,e._days+=r*a._days,e._months+=r*a._months,e._bubble()}function bs(e,t){return ks(this,e,t,1)}function Ds(e,t){return ks(this,e,t,-1)}function Ts(e){return e<0?Math.floor(e):Math.ceil(e)}function Ss(){var e,t,n,r,a,s=this._milliseconds,i=this._days,o=this._months,d=this._data;return s>=0&&i>=0&&o>=0||s<=0&&i<=0&&o<=0||(s+=864e5*Ts(Es(o)+i),i=0,o=0),d.milliseconds=s%1e3,e=xe(s/1e3),d.seconds=e%60,t=xe(e/60),d.minutes=t%60,n=xe(t/60),d.hours=n%24,i+=xe(n/24),o+=a=xe(js(i)),i-=Ts(Es(a)),r=xe(o/12),o%=12,d.days=i,d.months=o,d.years=r,this}function js(e){return 4800*e/146097}function Es(e){return 146097*e/4800}function xs(e){if(!this.isValid())return NaN;var t,n,r=this._milliseconds;if("month"===(e=re(e))||"quarter"===e||"year"===e)switch(t=this._days+r/864e5,n=this._months+js(t),e){case"month":return n;case"quarter":return n/3;case"year":return n/12}else switch(t=this._days+Math.round(Es(this._months)),e){case"week":return t/7+r/6048e5;case"day":return t+r/864e5;case"hour":return 24*t+r/36e5;case"minute":return 1440*t+r/6e4;case"second":return 86400*t+r/1e3;case"millisecond":return Math.floor(864e5*t)+r;default:throw new Error("Unknown unit "+e)}}function Os(e){return function(){return this.as(e)}}var As=Os("ms"),Hs=Os("s"),Ps=Os("m"),Cs=Os("h"),Is=Os("d"),Rs=Os("w"),Ns=Os("M"),Fs=Os("Q"),Ws=Os("y"),$s=As;function Us(){return jr(this)}function Bs(e){return e=re(e),this.isValid()?this[e+"s"]():NaN}function zs(e){return function(){return this.isValid()?this._data[e]:NaN}}var Js=zs("milliseconds"),Gs=zs("seconds"),Vs=zs("minutes"),qs=zs("hours"),Ks=zs("days"),Zs=zs("months"),Xs=zs("years");function Qs(){return xe(this.days()/7)}var ei=Math.round,ti={ss:44,s:45,m:45,h:22,d:26,w:null,M:11};function ni(e,t,n,r,a){return a.relativeTime(t||1,!!n,e,r)}function ri(e,t,n,r){var a=jr(e).abs(),s=ei(a.as("s")),i=ei(a.as("m")),o=ei(a.as("h")),d=ei(a.as("d")),u=ei(a.as("M")),l=ei(a.as("w")),c=ei(a.as("y")),_=s<=n.ss&&["s",s]||s<n.s&&["ss",s]||i<=1&&["m"]||i<n.m&&["mm",i]||o<=1&&["h"]||o<n.h&&["hh",o]||d<=1&&["d"]||d<n.d&&["dd",d];return null!=n.w&&(_=_||l<=1&&["w"]||l<n.w&&["ww",l]),(_=_||u<=1&&["M"]||u<n.M&&["MM",u]||c<=1&&["y"]||["yy",c])[2]=t,_[3]=+e>0,_[4]=r,ni.apply(null,_)}function ai(e){return void 0===e?ei:"function"==typeof e&&(ei=e,!0)}function si(e,t){return void 0!==ti[e]&&(void 0===t?ti[e]:(ti[e]=t,"s"===e&&(ti.ss=t-1),!0))}function ii(e,t){if(!this.isValid())return this.localeData().invalidDate();var n,r,a=!1,s=ti;return"object"==typeof e&&(t=e,e=!1),"boolean"==typeof e&&(a=e),"object"==typeof t&&(s=Object.assign({},ti,t),null!=t.s&&null==t.ss&&(s.ss=t.s-1)),r=ri(this,!a,s,n=this.localeData()),a&&(r=n.pastFuture(+this,r)),n.postformat(r)}var oi=Math.abs;function di(e){return(e>0)-(e<0)||+e}function ui(){if(!this.isValid())return this.localeData().invalidDate();var e,t,n,r,a,s,i,o,d=oi(this._milliseconds)/1e3,u=oi(this._days),l=oi(this._months),c=this.asSeconds();return c?(e=xe(d/60),t=xe(e/60),d%=60,e%=60,n=xe(l/12),l%=12,r=d?d.toFixed(3).replace(/\.?0+$/,""):"",a=c<0?"-":"",s=di(this._months)!==di(c)?"-":"",i=di(this._days)!==di(c)?"-":"",o=di(this._milliseconds)!==di(c)?"-":"",a+"P"+(n?s+n+"Y":"")+(l?s+l+"M":"")+(u?i+u+"D":"")+(t||e||d?"T":"")+(t?o+t+"H":"")+(e?o+e+"M":"")+(d?o+r+"S":"")):"P0D"}var li=or.prototype;return li.isValid=sr,li.abs=ws,li.add=bs,li.subtract=Ds,li.as=xs,li.asMilliseconds=As,li.asSeconds=Hs,li.asMinutes=Ps,li.asHours=Cs,li.asDays=Is,li.asWeeks=Rs,li.asMonths=Ns,li.asQuarters=Fs,li.asYears=Ws,li.valueOf=$s,li._bubble=Ss,li.clone=Us,li.get=Bs,li.milliseconds=Js,li.seconds=Gs,li.minutes=Vs,li.hours=qs,li.days=Ks,li.weeks=Qs,li.months=Zs,li.years=Xs,li.humanize=ii,li.toISOString=ui,li.toString=ui,li.toJSON=ui,li.locale=oa,li.localeData=ua,li.toIsoString=D("toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)",ui),li.lang=da,W("X",0,0,"unix"),W("x",0,0,"valueOf"),Te("x",Le),Te("X",we),He("X",(function(e,t,n){n._d=new Date(1e3*parseFloat(e))})),He("x",(function(e,t,n){n._d=new Date(Oe(e))})),a.version="2.30.1",s(Kn),a.fn=us,a.min=er,a.max=tr,a.now=nr,a.utc=f,a.unix=ls,a.months=ys,a.isDate=_,a.locale=pn,a.invalid=g,a.duration=jr,a.isMoment=k,a.weekdays=gs,a.parseZone=cs,a.localeData=gn,a.isDuration=dr,a.monthsShort=Ms,a.weekdaysMin=vs,a.defineLocale=yn,a.updateLocale=Mn,a.locales=Ln,a.weekdaysShort=Ls,a.normalizeUnits=re,a.relativeTimeRounding=ai,a.relativeTimeThreshold=si,a.calendarFormat=$r,a.prototype=us,a.HTML5_FMT={DATETIME_LOCAL:"YYYY-MM-DDTHH:mm",DATETIME_LOCAL_SECONDS:"YYYY-MM-DDTHH:mm:ss",DATETIME_LOCAL_MS:"YYYY-MM-DDTHH:mm:ss.SSS",DATE:"YYYY-MM-DD",TIME:"HH:mm",TIME_SECONDS:"HH:mm:ss",TIME_MS:"HH:mm:ss.SSS",WEEK:"GGGG-[W]WW",MONTH:"YYYY-MM"},a}()},65606:e=>{var t,n,r=e.exports={};function a(){throw new Error("setTimeout has not been defined")}function s(){throw new Error("clearTimeout has not been defined")}function i(e){if(t===setTimeout)return setTimeout(e,0);if((t===a||!t)&&setTimeout)return t=setTimeout,setTimeout(e,0);try{return t(e,0)}catch(n){try{return t.call(null,e,0)}catch(n){return t.call(this,e,0)}}}!function(){try{t="function"==typeof setTimeout?setTimeout:a}catch(e){t=a}try{n="function"==typeof clearTimeout?clearTimeout:s}catch(e){n=s}}();var o,d=[],u=!1,l=-1;function c(){u&&o&&(u=!1,o.length?d=o.concat(d):l=-1,d.length&&_())}function _(){if(!u){var e=i(c);u=!0;for(var t=d.length;t;){for(o=d,d=[];++l<t;)o&&o[l].run();l=-1,t=d.length}o=null,u=!1,function(e){if(n===clearTimeout)return clearTimeout(e);if((n===s||!n)&&clearTimeout)return n=clearTimeout,clearTimeout(e);try{return n(e)}catch(t){try{return n.call(null,e)}catch(t){return n.call(this,e)}}}(e)}}function m(e,t){this.fun=e,this.array=t}function h(){}r.nextTick=function(e){var t=new Array(arguments.length-1);if(arguments.length>1)for(var n=1;n<arguments.length;n++)t[n-1]=arguments[n];d.push(new m(e,t)),1!==d.length||u||i(_)},m.prototype.run=function(){this.fun.apply(null,this.array)},r.title="browser",r.browser=!0,r.env={},r.argv=[],r.version="",r.versions={},r.on=h,r.addListener=h,r.once=h,r.off=h,r.removeListener=h,r.removeAllListeners=h,r.emit=h,r.prependListener=h,r.prependOnceListener=h,r.listeners=function(e){return[]},r.binding=function(e){throw new Error("process.binding is not supported")},r.cwd=function(){return"/"},r.chdir=function(e){throw new Error("process.chdir is not supported")},r.umask=function(){return 0}},53908:(e,t,n)=>{const r=n(57272),{MAX_LENGTH:a,MAX_SAFE_INTEGER:s}=n(16874),{safeRe:i,safeSrc:o,t:d}=n(99718),u=n(98587),{compareIdentifiers:l}=n(61123);class c{constructor(e,t){if(t=u(t),e instanceof c){if(e.loose===!!t.loose&&e.includePrerelease===!!t.includePrerelease)return e;e=e.version}else if("string"!=typeof e)throw new TypeError(`Invalid version. Must be a string. Got type "${typeof e}".`);if(e.length>a)throw new TypeError(`version is longer than ${a} characters`);r("SemVer",e,t),this.options=t,this.loose=!!t.loose,this.includePrerelease=!!t.includePrerelease;const n=e.trim().match(t.loose?i[d.LOOSE]:i[d.FULL]);if(!n)throw new TypeError(`Invalid Version: ${e}`);if(this.raw=e,this.major=+n[1],this.minor=+n[2],this.patch=+n[3],this.major>s||this.major<0)throw new TypeError("Invalid major version");if(this.minor>s||this.minor<0)throw new TypeError("Invalid minor version");if(this.patch>s||this.patch<0)throw new TypeError("Invalid patch version");n[4]?this.prerelease=n[4].split(".").map((e=>{if(/^[0-9]+$/.test(e)){const t=+e;if(t>=0&&t<s)return t}return e})):this.prerelease=[],this.build=n[5]?n[5].split("."):[],this.format()}format(){return this.version=`${this.major}.${this.minor}.${this.patch}`,this.prerelease.length&&(this.version+=`-${this.prerelease.join(".")}`),this.version}toString(){return this.version}compare(e){if(r("SemVer.compare",this.version,this.options,e),!(e instanceof c)){if("string"==typeof e&&e===this.version)return 0;e=new c(e,this.options)}return e.version===this.version?0:this.compareMain(e)||this.comparePre(e)}compareMain(e){return e instanceof c||(e=new c(e,this.options)),l(this.major,e.major)||l(this.minor,e.minor)||l(this.patch,e.patch)}comparePre(e){if(e instanceof c||(e=new c(e,this.options)),this.prerelease.length&&!e.prerelease.length)return-1;if(!this.prerelease.length&&e.prerelease.length)return 1;if(!this.prerelease.length&&!e.prerelease.length)return 0;let t=0;do{const n=this.prerelease[t],a=e.prerelease[t];if(r("prerelease compare",t,n,a),void 0===n&&void 0===a)return 0;if(void 0===a)return 1;if(void 0===n)return-1;if(n!==a)return l(n,a)}while(++t)}compareBuild(e){e instanceof c||(e=new c(e,this.options));let t=0;do{const n=this.build[t],a=e.build[t];if(r("build compare",t,n,a),void 0===n&&void 0===a)return 0;if(void 0===a)return 1;if(void 0===n)return-1;if(n!==a)return l(n,a)}while(++t)}inc(e,t,n){if(e.startsWith("pre")){if(!t&&!1===n)throw new Error("invalid increment argument: identifier is empty");if(t){const e=new RegExp(`^${this.options.loose?o[d.PRERELEASELOOSE]:o[d.PRERELEASE]}$`),n=`-${t}`.match(e);if(!n||n[1]!==t)throw new Error(`invalid identifier: ${t}`)}}switch(e){case"premajor":this.prerelease.length=0,this.patch=0,this.minor=0,this.major++,this.inc("pre",t,n);break;case"preminor":this.prerelease.length=0,this.patch=0,this.minor++,this.inc("pre",t,n);break;case"prepatch":this.prerelease.length=0,this.inc("patch",t,n),this.inc("pre",t,n);break;case"prerelease":0===this.prerelease.length&&this.inc("patch",t,n),this.inc("pre",t,n);break;case"release":if(0===this.prerelease.length)throw new Error(`version ${this.raw} is not a prerelease`);this.prerelease.length=0;break;case"major":0===this.minor&&0===this.patch&&0!==this.prerelease.length||this.major++,this.minor=0,this.patch=0,this.prerelease=[];break;case"minor":0===this.patch&&0!==this.prerelease.length||this.minor++,this.patch=0,this.prerelease=[];break;case"patch":0===this.prerelease.length&&this.patch++,this.prerelease=[];break;case"pre":{const e=Number(n)?1:0;if(0===this.prerelease.length)this.prerelease=[e];else{let r=this.prerelease.length;for(;--r>=0;)"number"==typeof this.prerelease[r]&&(this.prerelease[r]++,r=-2);if(-1===r){if(t===this.prerelease.join(".")&&!1===n)throw new Error("invalid increment argument: identifier already exists");this.prerelease.push(e)}}if(t){let r=[t,e];!1===n&&(r=[t]),0===l(this.prerelease[0],t)?isNaN(this.prerelease[1])&&(this.prerelease=r):this.prerelease=r}break}default:throw new Error(`invalid increment argument: ${e}`)}return this.raw=this.format(),this.build.length&&(this.raw+=`+${this.build.join(".")}`),this}}e.exports=c},32938:(e,t,n)=>{const r=n(53908);e.exports=(e,t)=>new r(e,t).major},30144:(e,t,n)=>{const r=n(53908);e.exports=(e,t,n=!1)=>{if(e instanceof r)return e;try{return new r(e,t)}catch(e){if(!n)return null;throw e}}},56953:(e,t,n)=>{const r=n(30144);e.exports=(e,t)=>{const n=r(e,t);return n?n.version:null}},16874:e=>{const t=Number.MAX_SAFE_INTEGER||9007199254740991;e.exports={MAX_LENGTH:256,MAX_SAFE_COMPONENT_LENGTH:16,MAX_SAFE_BUILD_LENGTH:250,MAX_SAFE_INTEGER:t,RELEASE_TYPES:["major","premajor","minor","preminor","patch","prepatch","prerelease"],SEMVER_SPEC_VERSION:"2.0.0",FLAG_INCLUDE_PRERELEASE:1,FLAG_LOOSE:2}},57272:(e,t,n)=>{var r=n(65606);const a="object"==typeof r&&r.env&&r.env.NODE_DEBUG&&/\bsemver\b/i.test(r.env.NODE_DEBUG)?(...e)=>console.error("SEMVER",...e):()=>{};e.exports=a},61123:e=>{const t=/^[0-9]+$/,n=(e,n)=>{const r=t.test(e),a=t.test(n);return r&&a&&(e=+e,n=+n),e===n?0:r&&!a?-1:a&&!r?1:e<n?-1:1};e.exports={compareIdentifiers:n,rcompareIdentifiers:(e,t)=>n(t,e)}},98587:e=>{const t=Object.freeze({loose:!0}),n=Object.freeze({});e.exports=e=>e?"object"!=typeof e?t:e:n},99718:(e,t,n)=>{const{MAX_SAFE_COMPONENT_LENGTH:r,MAX_SAFE_BUILD_LENGTH:a,MAX_LENGTH:s}=n(16874),i=n(57272),o=(t=e.exports={}).re=[],d=t.safeRe=[],u=t.src=[],l=t.safeSrc=[],c=t.t={};let _=0;const m="[a-zA-Z0-9-]",h=[["\\s",1],["\\d",s],[m,a]],f=(e,t,n)=>{const r=(e=>{for(const[t,n]of h)e=e.split(`${t}*`).join(`${t}{0,${n}}`).split(`${t}+`).join(`${t}{1,${n}}`);return e})(t),a=_++;i(e,a,t),c[e]=a,u[a]=t,l[a]=r,o[a]=new RegExp(t,n?"g":void 0),d[a]=new RegExp(r,n?"g":void 0)};f("NUMERICIDENTIFIER","0|[1-9]\\d*"),f("NUMERICIDENTIFIERLOOSE","\\d+"),f("NONNUMERICIDENTIFIER",`\\d*[a-zA-Z-]${m}*`),f("MAINVERSION",`(${u[c.NUMERICIDENTIFIER]})\\.(${u[c.NUMERICIDENTIFIER]})\\.(${u[c.NUMERICIDENTIFIER]})`),f("MAINVERSIONLOOSE",`(${u[c.NUMERICIDENTIFIERLOOSE]})\\.(${u[c.NUMERICIDENTIFIERLOOSE]})\\.(${u[c.NUMERICIDENTIFIERLOOSE]})`),f("PRERELEASEIDENTIFIER",`(?:${u[c.NUMERICIDENTIFIER]}|${u[c.NONNUMERICIDENTIFIER]})`),f("PRERELEASEIDENTIFIERLOOSE",`(?:${u[c.NUMERICIDENTIFIERLOOSE]}|${u[c.NONNUMERICIDENTIFIER]})`),f("PRERELEASE",`(?:-(${u[c.PRERELEASEIDENTIFIER]}(?:\\.${u[c.PRERELEASEIDENTIFIER]})*))`),f("PRERELEASELOOSE",`(?:-?(${u[c.PRERELEASEIDENTIFIERLOOSE]}(?:\\.${u[c.PRERELEASEIDENTIFIERLOOSE]})*))`),f("BUILDIDENTIFIER",`${m}+`),f("BUILD",`(?:\\+(${u[c.BUILDIDENTIFIER]}(?:\\.${u[c.BUILDIDENTIFIER]})*))`),f("FULLPLAIN",`v?${u[c.MAINVERSION]}${u[c.PRERELEASE]}?${u[c.BUILD]}?`),f("FULL",`^${u[c.FULLPLAIN]}$`),f("LOOSEPLAIN",`[v=\\s]*${u[c.MAINVERSIONLOOSE]}${u[c.PRERELEASELOOSE]}?${u[c.BUILD]}?`),f("LOOSE",`^${u[c.LOOSEPLAIN]}$`),f("GTLT","((?:<|>)?=?)"),f("XRANGEIDENTIFIERLOOSE",`${u[c.NUMERICIDENTIFIERLOOSE]}|x|X|\\*`),f("XRANGEIDENTIFIER",`${u[c.NUMERICIDENTIFIER]}|x|X|\\*`),f("XRANGEPLAIN",`[v=\\s]*(${u[c.XRANGEIDENTIFIER]})(?:\\.(${u[c.XRANGEIDENTIFIER]})(?:\\.(${u[c.XRANGEIDENTIFIER]})(?:${u[c.PRERELEASE]})?${u[c.BUILD]}?)?)?`),f("XRANGEPLAINLOOSE",`[v=\\s]*(${u[c.XRANGEIDENTIFIERLOOSE]})(?:\\.(${u[c.XRANGEIDENTIFIERLOOSE]})(?:\\.(${u[c.XRANGEIDENTIFIERLOOSE]})(?:${u[c.PRERELEASELOOSE]})?${u[c.BUILD]}?)?)?`),f("XRANGE",`^${u[c.GTLT]}\\s*${u[c.XRANGEPLAIN]}$`),f("XRANGELOOSE",`^${u[c.GTLT]}\\s*${u[c.XRANGEPLAINLOOSE]}$`),f("COERCEPLAIN",`(^|[^\\d])(\\d{1,${r}})(?:\\.(\\d{1,${r}}))?(?:\\.(\\d{1,${r}}))?`),f("COERCE",`${u[c.COERCEPLAIN]}(?:$|[^\\d])`),f("COERCEFULL",u[c.COERCEPLAIN]+`(?:${u[c.PRERELEASE]})?`+`(?:${u[c.BUILD]})?(?:$|[^\\d])`),f("COERCERTL",u[c.COERCE],!0),f("COERCERTLFULL",u[c.COERCEFULL],!0),f("LONETILDE","(?:~>?)"),f("TILDETRIM",`(\\s*)${u[c.LONETILDE]}\\s+`,!0),t.tildeTrimReplace="$1~",f("TILDE",`^${u[c.LONETILDE]}${u[c.XRANGEPLAIN]}$`),f("TILDELOOSE",`^${u[c.LONETILDE]}${u[c.XRANGEPLAINLOOSE]}$`),f("LONECARET","(?:\\^)"),f("CARETTRIM",`(\\s*)${u[c.LONECARET]}\\s+`,!0),t.caretTrimReplace="$1^",f("CARET",`^${u[c.LONECARET]}${u[c.XRANGEPLAIN]}$`),f("CARETLOOSE",`^${u[c.LONECARET]}${u[c.XRANGEPLAINLOOSE]}$`),f("COMPARATORLOOSE",`^${u[c.GTLT]}\\s*(${u[c.LOOSEPLAIN]})$|^$`),f("COMPARATOR",`^${u[c.GTLT]}\\s*(${u[c.FULLPLAIN]})$|^$`),f("COMPARATORTRIM",`(\\s*)${u[c.GTLT]}\\s*(${u[c.LOOSEPLAIN]}|${u[c.XRANGEPLAIN]})`,!0),t.comparatorTrimReplace="$1$2$3",f("HYPHENRANGE",`^\\s*(${u[c.XRANGEPLAIN]})\\s+-\\s+(${u[c.XRANGEPLAIN]})\\s*$`),f("HYPHENRANGELOOSE",`^\\s*(${u[c.XRANGEPLAINLOOSE]})\\s+-\\s+(${u[c.XRANGEPLAINLOOSE]})\\s*$`),f("STAR","(<|>)?=?\\s*\\*"),f("GTE0","^\\s*>=\\s*0\\.0\\.0\\s*$"),f("GTE0PRE","^\\s*>=\\s*0\\.0\\.0-0\\s*$")},48318:function(e,t,n){!function(e){"use strict";var t,n=function(){try{if(e.URLSearchParams&&"bar"===new e.URLSearchParams("foo=bar").get("foo"))return e.URLSearchParams}catch(e){}return null}(),r=n&&"a=1"===new n({a:1}).toString(),a=n&&"+"===new n("s=%2B").get("s"),s=n&&"size"in n.prototype,i="__URLSearchParams__",o=!n||((t=new n).append("s"," &"),"s=+%26"===t.toString()),d=m.prototype,u=!(!e.Symbol||!e.Symbol.iterator);if(!(n&&r&&a&&o&&s)){d.append=function(e,t){M(this[i],e,t)},d.delete=function(e){delete this[i][e]},d.get=function(e){var t=this[i];return this.has(e)?t[e][0]:null},d.getAll=function(e){var t=this[i];return this.has(e)?t[e].slice(0):[]},d.has=function(e){return L(this[i],e)},d.set=function(e,t){this[i][e]=[""+t]},d.toString=function(){var e,t,n,r,a=this[i],s=[];for(t in a)for(n=h(t),e=0,r=a[t];e<r.length;e++)s.push(n+"="+h(r[e]));return s.join("&")};var l,c=e.Proxy&&n&&(!a||!o||!r||!s);c?(l=new Proxy(n,{construct:function(e,t){return new e(new m(t[0]).toString())}})).toString=Function.prototype.toString.bind(m):l=m,Object.defineProperty(e,"URLSearchParams",{value:l});var _=e.URLSearchParams.prototype;_.polyfill=!0,!c&&e.Symbol&&(_[e.Symbol.toStringTag]="URLSearchParams"),"forEach"in _||(_.forEach=function(e,t){var n=y(this.toString());Object.getOwnPropertyNames(n).forEach((function(r){n[r].forEach((function(n){e.call(t,n,r,this)}),this)}),this)}),"sort"in _||(_.sort=function(){var e,t,n,r=y(this.toString()),a=[];for(e in r)a.push(e);for(a.sort(),t=0;t<a.length;t++)this.delete(a[t]);for(t=0;t<a.length;t++){var s=a[t],i=r[s];for(n=0;n<i.length;n++)this.append(s,i[n])}}),"keys"in _||(_.keys=function(){var e=[];return this.forEach((function(t,n){e.push(n)})),p(e)}),"values"in _||(_.values=function(){var e=[];return this.forEach((function(t){e.push(t)})),p(e)}),"entries"in _||(_.entries=function(){var e=[];return this.forEach((function(t,n){e.push([n,t])})),p(e)}),u&&(_[e.Symbol.iterator]=_[e.Symbol.iterator]||_.entries),"size"in _||Object.defineProperty(_,"size",{get:function(){var e=y(this.toString());if(_===this)throw new TypeError("Illegal invocation at URLSearchParams.invokeGetter");return Object.keys(e).reduce((function(t,n){return t+e[n].length}),0)}})}function m(e){((e=e||"")instanceof URLSearchParams||e instanceof m)&&(e=e.toString()),this[i]=y(e)}function h(e){var t={"!":"%21","'":"%27","(":"%28",")":"%29","~":"%7E","%20":"+","%00":"\0"};return encodeURIComponent(e).replace(/[!'\(\)~]|%20|%00/g,(function(e){return t[e]}))}function f(e){return e.replace(/[ +]/g,"%20").replace(/(%[a-f0-9]{2})+/gi,(function(e){return decodeURIComponent(e)}))}function p(t){var n={next:function(){var e=t.shift();return{done:void 0===e,value:e}}};return u&&(n[e.Symbol.iterator]=function(){return n}),n}function y(e){var t={};if("object"==typeof e)if(g(e))for(var n=0;n<e.length;n++){var r=e[n];if(!g(r)||2!==r.length)throw new TypeError("Failed to construct 'URLSearchParams': Sequence initializer must only contain pair elements");M(t,r[0],r[1])}else for(var a in e)e.hasOwnProperty(a)&&M(t,a,e[a]);else{0===e.indexOf("?")&&(e=e.slice(1));for(var s=e.split("&"),i=0;i<s.length;i++){var o=s[i],d=o.indexOf("=");-1<d?M(t,f(o.slice(0,d)),f(o.slice(d+1))):o&&M(t,f(o),"")}}return t}function M(e,t,n){var r="string"==typeof n?n:null!=n&&"function"==typeof n.toString?n.toString():JSON.stringify(n);L(e,t)?e[t].push(r):e[t]=[r]}function g(e){return!!e&&"[object Array]"===Object.prototype.toString.call(e)}function L(e,t){return Object.prototype.hasOwnProperty.call(e,t)}}(void 0!==n.g?n.g:"undefined"!=typeof window?window:this)},85471:(e,t,n)=>{"use strict";n.d(t,{$9:()=>jn,$V:()=>En,D:()=>Sn,EW:()=>ot,Gt:()=>vt,Ht:()=>rn,IJ:()=>qe,KR:()=>Ve,Kh:()=>Ne,QW:()=>et,R1:()=>Ze,Tm:()=>Be,WQ:()=>wt,dY:()=>Tn,default:()=>Ur,h:()=>mn,hZ:()=>Ce,hi:()=>Hn,i9:()=>Ge,jr:()=>Lt,lW:()=>tt,nI:()=>me,nT:()=>_t,o5:()=>gt,pM:()=>Pn,rY:()=>Qe,sV:()=>On,tB:()=>at,uY:()=>Mt,ux:()=>ze,wB:()=>ft,xo:()=>An});var r=Object.freeze({}),a=Array.isArray;function s(e){return null==e}function i(e){return null!=e}function o(e){return!0===e}function d(e){return"string"==typeof e||"number"==typeof e||"symbol"==typeof e||"boolean"==typeof e}function u(e){return"function"==typeof e}function l(e){return null!==e&&"object"==typeof e}var c=Object.prototype.toString;function _(e){return"[object Object]"===c.call(e)}function m(e){return"[object RegExp]"===c.call(e)}function h(e){var t=parseFloat(String(e));return t>=0&&Math.floor(t)===t&&isFinite(e)}function f(e){return i(e)&&"function"==typeof e.then&&"function"==typeof e.catch}function p(e){return null==e?"":Array.isArray(e)||_(e)&&e.toString===c?JSON.stringify(e,y,2):String(e)}function y(e,t){return t&&t.__v_isRef?t.value:t}function M(e){var t=parseFloat(e);return isNaN(t)?e:t}function g(e,t){for(var n=Object.create(null),r=e.split(","),a=0;a<r.length;a++)n[r[a]]=!0;return t?function(e){return n[e.toLowerCase()]}:function(e){return n[e]}}g("slot,component",!0);var L=g("key,ref,slot,slot-scope,is");function v(e,t){var n=e.length;if(n){if(t===e[n-1])return void(e.length=n-1);var r=e.indexOf(t);if(r>-1)return e.splice(r,1)}}var Y=Object.prototype.hasOwnProperty;function w(e,t){return Y.call(e,t)}function k(e){var t=Object.create(null);return function(n){return t[n]||(t[n]=e(n))}}var b=/-(\w)/g,D=k((function(e){return e.replace(b,(function(e,t){return t?t.toUpperCase():""}))})),T=k((function(e){return e.charAt(0).toUpperCase()+e.slice(1)})),S=/\B([A-Z])/g,j=k((function(e){return e.replace(S,"-$1").toLowerCase()}));var E=Function.prototype.bind?function(e,t){return e.bind(t)}:function(e,t){function n(n){var r=arguments.length;return r?r>1?e.apply(t,arguments):e.call(t,n):e.call(t)}return n._length=e.length,n};function x(e,t){t=t||0;for(var n=e.length-t,r=new Array(n);n--;)r[n]=e[n+t];return r}function O(e,t){for(var n in t)e[n]=t[n];return e}function A(e){for(var t={},n=0;n<e.length;n++)e[n]&&O(t,e[n]);return t}function H(e,t,n){}var P=function(e,t,n){return!1},C=function(e){return e};function I(e,t){if(e===t)return!0;var n=l(e),r=l(t);if(!n||!r)return!n&&!r&&String(e)===String(t);try{var a=Array.isArray(e),s=Array.isArray(t);if(a&&s)return e.length===t.length&&e.every((function(e,n){return I(e,t[n])}));if(e instanceof Date&&t instanceof Date)return e.getTime()===t.getTime();if(a||s)return!1;var i=Object.keys(e),o=Object.keys(t);return i.length===o.length&&i.every((function(n){return I(e[n],t[n])}))}catch(e){return!1}}function R(e,t){for(var n=0;n<e.length;n++)if(I(e[n],t))return n;return-1}function N(e){var t=!1;return function(){t||(t=!0,e.apply(this,arguments))}}function F(e,t){return e===t?0===e&&1/e!=1/t:e==e||t==t}var W="data-server-rendered",$=["component","directive","filter"],U=["beforeCreate","created","beforeMount","mounted","beforeUpdate","updated","beforeDestroy","destroyed","activated","deactivated","errorCaptured","serverPrefetch","renderTracked","renderTriggered"],B={optionMergeStrategies:Object.create(null),silent:!1,productionTip:!1,devtools:!1,performance:!1,errorHandler:null,warnHandler:null,ignoredElements:[],keyCodes:Object.create(null),isReservedTag:P,isReservedAttr:P,isUnknownElement:P,getTagNamespace:H,parsePlatformTagName:C,mustUseProp:P,async:!0,_lifecycleHooks:U},z=/a-zA-Z\u00B7\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u037D\u037F-\u1FFF\u200C-\u200D\u203F-\u2040\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD/;function J(e){var t=(e+"").charCodeAt(0);return 36===t||95===t}function G(e,t,n,r){Object.defineProperty(e,t,{value:n,enumerable:!!r,writable:!0,configurable:!0})}var V=new RegExp("[^".concat(z.source,".$_\\d]"));var q="__proto__"in{},K="undefined"!=typeof window,Z=K&&window.navigator.userAgent.toLowerCase(),X=Z&&/msie|trident/.test(Z),Q=Z&&Z.indexOf("msie 9.0")>0,ee=Z&&Z.indexOf("edge/")>0;Z&&Z.indexOf("android");var te=Z&&/iphone|ipad|ipod|ios/.test(Z);Z&&/chrome\/\d+/.test(Z),Z&&/phantomjs/.test(Z);var ne,re=Z&&Z.match(/firefox\/(\d+)/),ae={}.watch,se=!1;if(K)try{var ie={};Object.defineProperty(ie,"passive",{get:function(){se=!0}}),window.addEventListener("test-passive",null,ie)}catch(e){}var oe=function(){return void 0===ne&&(ne=!K&&void 0!==n.g&&(n.g.process&&"server"===n.g.process.env.VUE_ENV)),ne},de=K&&window.__VUE_DEVTOOLS_GLOBAL_HOOK__;function ue(e){return"function"==typeof e&&/native code/.test(e.toString())}var le,ce="undefined"!=typeof Symbol&&ue(Symbol)&&"undefined"!=typeof Reflect&&ue(Reflect.ownKeys);le="undefined"!=typeof Set&&ue(Set)?Set:function(){function e(){this.set=Object.create(null)}return e.prototype.has=function(e){return!0===this.set[e]},e.prototype.add=function(e){this.set[e]=!0},e.prototype.clear=function(){this.set=Object.create(null)},e}();var _e=null;function me(){return _e&&{proxy:_e}}function he(e){void 0===e&&(e=null),e||_e&&_e._scope.off(),_e=e,e&&e._scope.on()}var fe=function(){function e(e,t,n,r,a,s,i,o){this.tag=e,this.data=t,this.children=n,this.text=r,this.elm=a,this.ns=void 0,this.context=s,this.fnContext=void 0,this.fnOptions=void 0,this.fnScopeId=void 0,this.key=t&&t.key,this.componentOptions=i,this.componentInstance=void 0,this.parent=void 0,this.raw=!1,this.isStatic=!1,this.isRootInsert=!0,this.isComment=!1,this.isCloned=!1,this.isOnce=!1,this.asyncFactory=o,this.asyncMeta=void 0,this.isAsyncPlaceholder=!1}return Object.defineProperty(e.prototype,"child",{get:function(){return this.componentInstance},enumerable:!1,configurable:!0}),e}(),pe=function(e){void 0===e&&(e="");var t=new fe;return t.text=e,t.isComment=!0,t};function ye(e){return new fe(void 0,void 0,void 0,String(e))}function Me(e){var t=new fe(e.tag,e.data,e.children&&e.children.slice(),e.text,e.elm,e.context,e.componentOptions,e.asyncFactory);return t.ns=e.ns,t.isStatic=e.isStatic,t.key=e.key,t.isComment=e.isComment,t.fnContext=e.fnContext,t.fnOptions=e.fnOptions,t.fnScopeId=e.fnScopeId,t.asyncMeta=e.asyncMeta,t.isCloned=!0,t}"function"==typeof SuppressedError&&SuppressedError;var ge=0,Le=[],ve=function(){for(var e=0;e<Le.length;e++){var t=Le[e];t.subs=t.subs.filter((function(e){return e})),t._pending=!1}Le.length=0},Ye=function(){function e(){this._pending=!1,this.id=ge++,this.subs=[]}return e.prototype.addSub=function(e){this.subs.push(e)},e.prototype.removeSub=function(e){this.subs[this.subs.indexOf(e)]=null,this._pending||(this._pending=!0,Le.push(this))},e.prototype.depend=function(t){e.target&&e.target.addDep(this)},e.prototype.notify=function(e){var t=this.subs.filter((function(e){return e}));for(var n=0,r=t.length;n<r;n++){0,t[n].update()}},e}();Ye.target=null;var we=[];function ke(e){we.push(e),Ye.target=e}function be(){we.pop(),Ye.target=we[we.length-1]}var De=Array.prototype,Te=Object.create(De);["push","pop","shift","unshift","splice","sort","reverse"].forEach((function(e){var t=De[e];G(Te,e,(function(){for(var n=[],r=0;r<arguments.length;r++)n[r]=arguments[r];var a,s=t.apply(this,n),i=this.__ob__;switch(e){case"push":case"unshift":a=n;break;case"splice":a=n.slice(2)}return a&&i.observeArray(a),i.dep.notify(),s}))}));var Se=Object.getOwnPropertyNames(Te),je={},Ee=!0;function xe(e){Ee=e}var Oe={notify:H,depend:H,addSub:H,removeSub:H},Ae=function(){function e(e,t,n){if(void 0===t&&(t=!1),void 0===n&&(n=!1),this.value=e,this.shallow=t,this.mock=n,this.dep=n?Oe:new Ye,this.vmCount=0,G(e,"__ob__",this),a(e)){if(!n)if(q)e.__proto__=Te;else for(var r=0,s=Se.length;r<s;r++){G(e,o=Se[r],Te[o])}t||this.observeArray(e)}else{var i=Object.keys(e);for(r=0;r<i.length;r++){var o;Pe(e,o=i[r],je,void 0,t,n)}}}return e.prototype.observeArray=function(e){for(var t=0,n=e.length;t<n;t++)He(e[t],!1,this.mock)},e}();function He(e,t,n){return e&&w(e,"__ob__")&&e.__ob__ instanceof Ae?e.__ob__:!Ee||!n&&oe()||!a(e)&&!_(e)||!Object.isExtensible(e)||e.__v_skip||Ge(e)||e instanceof fe?void 0:new Ae(e,t,n)}function Pe(e,t,n,r,s,i,o){void 0===o&&(o=!1);var d=new Ye,u=Object.getOwnPropertyDescriptor(e,t);if(!u||!1!==u.configurable){var l=u&&u.get,c=u&&u.set;l&&!c||n!==je&&2!==arguments.length||(n=e[t]);var _=s?n&&n.__ob__:He(n,!1,i);return Object.defineProperty(e,t,{enumerable:!0,configurable:!0,get:function(){var t=l?l.call(e):n;return Ye.target&&(d.depend(),_&&(_.dep.depend(),a(t)&&Re(t))),Ge(t)&&!s?t.value:t},set:function(t){var r=l?l.call(e):n;if(F(r,t)){if(c)c.call(e,t);else{if(l)return;if(!s&&Ge(r)&&!Ge(t))return void(r.value=t);n=t}_=s?t&&t.__ob__:He(t,!1,i),d.notify()}}}),d}}function Ce(e,t,n){if(!Be(e)){var r=e.__ob__;return a(e)&&h(t)?(e.length=Math.max(e.length,t),e.splice(t,1,n),r&&!r.shallow&&r.mock&&He(n,!1,!0),n):t in e&&!(t in Object.prototype)?(e[t]=n,n):e._isVue||r&&r.vmCount?n:r?(Pe(r.value,t,n,void 0,r.shallow,r.mock),r.dep.notify(),n):(e[t]=n,n)}}function Ie(e,t){if(a(e)&&h(t))e.splice(t,1);else{var n=e.__ob__;e._isVue||n&&n.vmCount||Be(e)||w(e,t)&&(delete e[t],n&&n.dep.notify())}}function Re(e){for(var t=void 0,n=0,r=e.length;n<r;n++)(t=e[n])&&t.__ob__&&t.__ob__.dep.depend(),a(t)&&Re(t)}function Ne(e){return We(e,!1),e}function Fe(e){return We(e,!0),G(e,"__v_isShallow",!0),e}function We(e,t){if(!Be(e)){He(e,t,oe());0}}function $e(e){return Be(e)?$e(e.__v_raw):!(!e||!e.__ob__)}function Ue(e){return!(!e||!e.__v_isShallow)}function Be(e){return!(!e||!e.__v_isReadonly)}function ze(e){var t=e&&e.__v_raw;return t?ze(t):e}var Je="__v_isRef";function Ge(e){return!(!e||!0!==e.__v_isRef)}function Ve(e){return Ke(e,!1)}function qe(e){return Ke(e,!0)}function Ke(e,t){if(Ge(e))return e;var n={};return G(n,Je,!0),G(n,"__v_isShallow",t),G(n,"dep",Pe(n,"value",e,null,t,oe())),n}function Ze(e){return Ge(e)?e.value:e}function Xe(e,t,n){Object.defineProperty(e,n,{enumerable:!0,configurable:!0,get:function(){var e=t[n];if(Ge(e))return e.value;var r=e&&e.__ob__;return r&&r.dep.depend(),e},set:function(e){var r=t[n];Ge(r)&&!Ge(e)?r.value=e:t[n]=e}})}function Qe(e){var t=new Ye,n=e((function(){t.depend()}),(function(){t.notify()})),r=n.get,a=n.set,s={get value(){return r()},set value(e){a(e)}};return G(s,Je,!0),s}function et(e){var t=a(e)?new Array(e.length):{};for(var n in e)t[n]=tt(e,n);return t}function tt(e,t,n){var r=e[t];if(Ge(r))return r;var a={get value(){var r=e[t];return void 0===r?n:r},set value(n){e[t]=n}};return G(a,Je,!0),a}var nt="__v_rawToReadonly",rt="__v_rawToShallowReadonly";function at(e){return st(e,!1)}function st(e,t){if(!_(e))return e;if(Be(e))return e;var n=t?rt:nt,r=e[n];if(r)return r;var a=Object.create(Object.getPrototypeOf(e));G(e,n,a),G(a,"__v_isReadonly",!0),G(a,"__v_raw",e),Ge(e)&&G(a,Je,!0),(t||Ue(e))&&G(a,"__v_isShallow",!0);for(var s=Object.keys(e),i=0;i<s.length;i++)it(a,e,s[i],t);return a}function it(e,t,n,r){Object.defineProperty(e,n,{enumerable:!0,configurable:!0,get:function(){var e=t[n];return r||!_(e)?e:at(e)},set:function(){}})}function ot(e,t){var n,r,a=u(e);a?(n=e,r=H):(n=e.get,r=e.set);var s=oe()?null:new Wn(_e,n,H,{lazy:!0});var i={effect:s,get value(){return s?(s.dirty&&s.evaluate(),Ye.target&&s.depend(),s.value):n()},set value(e){r(e)}};return G(i,Je,!0),G(i,"__v_isReadonly",a),i}var dt="watcher",ut="".concat(dt," callback"),lt="".concat(dt," getter"),ct="".concat(dt," cleanup");function _t(e,t){return pt(e,null,t)}var mt,ht={};function ft(e,t,n){return pt(e,t,n)}function pt(e,t,n){var s=void 0===n?r:n,i=s.immediate,o=s.deep,d=s.flush,l=void 0===d?"pre":d;s.onTrack,s.onTrigger;var c,_,m=_e,h=function(e,t,n){void 0===n&&(n=null);var r=fn(e,null,n,m,t);return o&&r&&r.__ob__&&r.__ob__.dep.depend(),r},f=!1,p=!1;if(Ge(e)?(c=function(){return e.value},f=Ue(e)):$e(e)?(c=function(){return e.__ob__.dep.depend(),e},o=!0):a(e)?(p=!0,f=e.some((function(e){return $e(e)||Ue(e)})),c=function(){return e.map((function(e){return Ge(e)?e.value:$e(e)?(e.__ob__.dep.depend(),In(e)):u(e)?h(e,lt):void 0}))}):c=u(e)?t?function(){return h(e,lt)}:function(){if(!m||!m._isDestroyed)return _&&_(),h(e,dt,[M])}:H,t&&o){var y=c;c=function(){return In(y())}}var M=function(e){_=g.onStop=function(){h(e,ct)}};if(oe())return M=H,t?i&&h(t,ut,[c(),p?[]:void 0,M]):c(),H;var g=new Wn(_e,c,H,{lazy:!0});g.noRecurse=!t;var L=p?[]:ht;return g.run=function(){if(g.active)if(t){var e=g.get();(o||f||(p?e.some((function(e,t){return F(e,L[t])})):F(e,L)))&&(_&&_(),h(t,ut,[e,L===ht?void 0:L,M]),L=e)}else g.get()},"sync"===l?g.update=g.run:"post"===l?(g.post=!0,g.update=function(){return ur(g)}):g.update=function(){if(m&&m===_e&&!m._isMounted){var e=m._preWatchers||(m._preWatchers=[]);e.indexOf(g)<0&&e.push(g)}else ur(g)},t?i?g.run():L=g.get():"post"===l&&m?m.$once("hook:mounted",(function(){return g.get()})):g.get(),function(){g.teardown()}}var yt=function(){function e(e){void 0===e&&(e=!1),this.detached=e,this.active=!0,this.effects=[],this.cleanups=[],this.parent=mt,!e&&mt&&(this.index=(mt.scopes||(mt.scopes=[])).push(this)-1)}return e.prototype.run=function(e){if(this.active){var t=mt;try{return mt=this,e()}finally{mt=t}}else 0},e.prototype.on=function(){mt=this},e.prototype.off=function(){mt=this.parent},e.prototype.stop=function(e){if(this.active){var t=void 0,n=void 0;for(t=0,n=this.effects.length;t<n;t++)this.effects[t].teardown();for(t=0,n=this.cleanups.length;t<n;t++)this.cleanups[t]();if(this.scopes)for(t=0,n=this.scopes.length;t<n;t++)this.scopes[t].stop(!0);if(!this.detached&&this.parent&&!e){var r=this.parent.scopes.pop();r&&r!==this&&(this.parent.scopes[this.index]=r,r.index=this.index)}this.parent=void 0,this.active=!1}},e}();function Mt(e){return new yt(e)}function gt(){return mt}function Lt(e){mt&&mt.cleanups.push(e)}function vt(e,t){_e&&(Yt(_e)[e]=t)}function Yt(e){var t=e._provided,n=e.$parent&&e.$parent._provided;return n===t?e._provided=Object.create(n):t}function wt(e,t,n){void 0===n&&(n=!1);var r=_e;if(r){var a=r.$parent&&r.$parent._provided;if(a&&e in a)return a[e];if(arguments.length>1)return n&&u(t)?t.call(r):t}else 0}var kt=k((function(e){var t="&"===e.charAt(0),n="~"===(e=t?e.slice(1):e).charAt(0),r="!"===(e=n?e.slice(1):e).charAt(0);return{name:e=r?e.slice(1):e,once:n,capture:r,passive:t}}));function bt(e,t){function n(){var e=n.fns;if(!a(e))return fn(e,null,arguments,t,"v-on handler");for(var r=e.slice(),s=0;s<r.length;s++)fn(r[s],null,arguments,t,"v-on handler")}return n.fns=e,n}function Dt(e,t,n,r,a,i){var d,u,l,c;for(d in e)u=e[d],l=t[d],c=kt(d),s(u)||(s(l)?(s(u.fns)&&(u=e[d]=bt(u,i)),o(c.once)&&(u=e[d]=a(c.name,u,c.capture)),n(c.name,u,c.capture,c.passive,c.params)):u!==l&&(l.fns=u,e[d]=l));for(d in t)s(e[d])&&r((c=kt(d)).name,t[d],c.capture)}function Tt(e,t,n){var r;e instanceof fe&&(e=e.data.hook||(e.data.hook={}));var a=e[t];function d(){n.apply(this,arguments),v(r.fns,d)}s(a)?r=bt([d]):i(a.fns)&&o(a.merged)?(r=a).fns.push(d):r=bt([a,d]),r.merged=!0,e[t]=r}function St(e,t,n,r,a){if(i(t)){if(w(t,n))return e[n]=t[n],a||delete t[n],!0;if(w(t,r))return e[n]=t[r],a||delete t[r],!0}return!1}function jt(e){return d(e)?[ye(e)]:a(e)?xt(e):void 0}function Et(e){return i(e)&&i(e.text)&&!1===e.isComment}function xt(e,t){var n,r,u,l,c=[];for(n=0;n<e.length;n++)s(r=e[n])||"boolean"==typeof r||(l=c[u=c.length-1],a(r)?r.length>0&&(Et((r=xt(r,"".concat(t||"","_").concat(n)))[0])&&Et(l)&&(c[u]=ye(l.text+r[0].text),r.shift()),c.push.apply(c,r)):d(r)?Et(l)?c[u]=ye(l.text+r):""!==r&&c.push(ye(r)):Et(r)&&Et(l)?c[u]=ye(l.text+r.text):(o(e._isVList)&&i(r.tag)&&s(r.key)&&i(t)&&(r.key="__vlist".concat(t,"_").concat(n,"__")),c.push(r)));return c}function Ot(e,t){var n,r,s,o,d=null;if(a(e)||"string"==typeof e)for(d=new Array(e.length),n=0,r=e.length;n<r;n++)d[n]=t(e[n],n);else if("number"==typeof e)for(d=new Array(e),n=0;n<e;n++)d[n]=t(n+1,n);else if(l(e))if(ce&&e[Symbol.iterator]){d=[];for(var u=e[Symbol.iterator](),c=u.next();!c.done;)d.push(t(c.value,d.length)),c=u.next()}else for(s=Object.keys(e),d=new Array(s.length),n=0,r=s.length;n<r;n++)o=s[n],d[n]=t(e[o],o,n);return i(d)||(d=[]),d._isVList=!0,d}function At(e,t,n,r){var a,s=this.$scopedSlots[e];s?(n=n||{},r&&(n=O(O({},r),n)),a=s(n)||(u(t)?t():t)):a=this.$slots[e]||(u(t)?t():t);var i=n&&n.slot;return i?this.$createElement("template",{slot:i},a):a}function Ht(e){return Tr(this.$options,"filters",e,!0)||C}function Pt(e,t){return a(e)?-1===e.indexOf(t):e!==t}function Ct(e,t,n,r,a){var s=B.keyCodes[t]||n;return a&&r&&!B.keyCodes[t]?Pt(a,r):s?Pt(s,e):r?j(r)!==t:void 0===e}function It(e,t,n,r,s){if(n)if(l(n)){a(n)&&(n=A(n));var i=void 0,o=function(a){if("class"===a||"style"===a||L(a))i=e;else{var o=e.attrs&&e.attrs.type;i=r||B.mustUseProp(t,o,a)?e.domProps||(e.domProps={}):e.attrs||(e.attrs={})}var d=D(a),u=j(a);d in i||u in i||(i[a]=n[a],s&&((e.on||(e.on={}))["update:".concat(a)]=function(e){n[a]=e}))};for(var d in n)o(d)}else;return e}function Rt(e,t){var n=this._staticTrees||(this._staticTrees=[]),r=n[e];return r&&!t||Ft(r=n[e]=this.$options.staticRenderFns[e].call(this._renderProxy,this._c,this),"__static__".concat(e),!1),r}function Nt(e,t,n){return Ft(e,"__once__".concat(t).concat(n?"_".concat(n):""),!0),e}function Ft(e,t,n){if(a(e))for(var r=0;r<e.length;r++)e[r]&&"string"!=typeof e[r]&&Wt(e[r],"".concat(t,"_").concat(r),n);else Wt(e,t,n)}function Wt(e,t,n){e.isStatic=!0,e.key=t,e.isOnce=n}function $t(e,t){if(t)if(_(t)){var n=e.on=e.on?O({},e.on):{};for(var r in t){var a=n[r],s=t[r];n[r]=a?[].concat(a,s):s}}else;return e}function Ut(e,t,n,r){t=t||{$stable:!n};for(var s=0;s<e.length;s++){var i=e[s];a(i)?Ut(i,t,n):i&&(i.proxy&&(i.fn.proxy=!0),t[i.key]=i.fn)}return r&&(t.$key=r),t}function Bt(e,t){for(var n=0;n<t.length;n+=2){var r=t[n];"string"==typeof r&&r&&(e[t[n]]=t[n+1])}return e}function zt(e,t){return"string"==typeof e?t+e:e}function Jt(e){e._o=Nt,e._n=M,e._s=p,e._l=Ot,e._t=At,e._q=I,e._i=R,e._m=Rt,e._f=Ht,e._k=Ct,e._b=It,e._v=ye,e._e=pe,e._u=Ut,e._g=$t,e._d=Bt,e._p=zt}function Gt(e,t){if(!e||!e.length)return{};for(var n={},r=0,a=e.length;r<a;r++){var s=e[r],i=s.data;if(i&&i.attrs&&i.attrs.slot&&delete i.attrs.slot,s.context!==t&&s.fnContext!==t||!i||null==i.slot)(n.default||(n.default=[])).push(s);else{var o=i.slot,d=n[o]||(n[o]=[]);"template"===s.tag?d.push.apply(d,s.children||[]):d.push(s)}}for(var u in n)n[u].every(Vt)&&delete n[u];return n}function Vt(e){return e.isComment&&!e.asyncFactory||" "===e.text}function qt(e){return e.isComment&&e.asyncFactory}function Kt(e,t,n,a){var s,i=Object.keys(n).length>0,o=t?!!t.$stable:!i,d=t&&t.$key;if(t){if(t._normalized)return t._normalized;if(o&&a&&a!==r&&d===a.$key&&!i&&!a.$hasNormal)return a;for(var u in s={},t)t[u]&&"$"!==u[0]&&(s[u]=Zt(e,n,u,t[u]))}else s={};for(var l in n)l in s||(s[l]=Xt(n,l));return t&&Object.isExtensible(t)&&(t._normalized=s),G(s,"$stable",o),G(s,"$key",d),G(s,"$hasNormal",i),s}function Zt(e,t,n,r){var s=function(){var t=_e;he(e);var n=arguments.length?r.apply(null,arguments):r({}),s=(n=n&&"object"==typeof n&&!a(n)?[n]:jt(n))&&n[0];return he(t),n&&(!s||1===n.length&&s.isComment&&!qt(s))?void 0:n};return r.proxy&&Object.defineProperty(t,n,{get:s,enumerable:!0,configurable:!0}),s}function Xt(e,t){return function(){return e[t]}}function Qt(e){return{get attrs(){if(!e._attrsProxy){var t=e._attrsProxy={};G(t,"_v_attr_proxy",!0),en(t,e.$attrs,r,e,"$attrs")}return e._attrsProxy},get listeners(){e._listenersProxy||en(e._listenersProxy={},e.$listeners,r,e,"$listeners");return e._listenersProxy},get slots(){return function(e){e._slotsProxy||nn(e._slotsProxy={},e.$scopedSlots);return e._slotsProxy}(e)},emit:E(e.$emit,e),expose:function(t){t&&Object.keys(t).forEach((function(n){return Xe(e,t,n)}))}}}function en(e,t,n,r,a){var s=!1;for(var i in t)i in e?t[i]!==n[i]&&(s=!0):(s=!0,tn(e,i,r,a));for(var i in e)i in t||(s=!0,delete e[i]);return s}function tn(e,t,n,r){Object.defineProperty(e,t,{enumerable:!0,configurable:!0,get:function(){return n[r][t]}})}function nn(e,t){for(var n in t)e[n]=t[n];for(var n in e)n in t||delete e[n]}function rn(){return an().slots}function an(){var e=_e;return e._setupContext||(e._setupContext=Qt(e))}var sn=null;function on(e,t){return(e.__esModule||ce&&"Module"===e[Symbol.toStringTag])&&(e=e.default),l(e)?t.extend(e):e}function dn(e){if(a(e))for(var t=0;t<e.length;t++){var n=e[t];if(i(n)&&(i(n.componentOptions)||qt(n)))return n}}var un=1,ln=2;function cn(e,t,n,r,s,c){return(a(n)||d(n))&&(s=r,r=n,n=void 0),o(c)&&(s=ln),function(e,t,n,r,s){if(i(n)&&i(n.__ob__))return pe();i(n)&&i(n.is)&&(t=n.is);if(!t)return pe();0;a(r)&&u(r[0])&&((n=n||{}).scopedSlots={default:r[0]},r.length=0);s===ln?r=jt(r):s===un&&(r=function(e){for(var t=0;t<e.length;t++)if(a(e[t]))return Array.prototype.concat.apply([],e);return e}(r));var o,d;if("string"==typeof t){var c=void 0;d=e.$vnode&&e.$vnode.ns||B.getTagNamespace(t),o=B.isReservedTag(t)?new fe(B.parsePlatformTagName(t),n,r,void 0,void 0,e):n&&n.pre||!i(c=Tr(e.$options,"components",t))?new fe(t,n,r,void 0,void 0,e):yr(c,n,e,r,t)}else o=yr(t,n,e,r);return a(o)?o:i(o)?(i(d)&&_n(o,d),i(n)&&function(e){l(e.style)&&In(e.style);l(e.class)&&In(e.class)}(n),o):pe()}(e,t,n,r,s)}function _n(e,t,n){if(e.ns=t,"foreignObject"===e.tag&&(t=void 0,n=!0),i(e.children))for(var r=0,a=e.children.length;r<a;r++){var d=e.children[r];i(d.tag)&&(s(d.ns)||o(n)&&"svg"!==d.tag)&&_n(d,t,n)}}function mn(e,t,n){return cn(_e,e,t,n,2,!0)}function hn(e,t,n){ke();try{if(t)for(var r=t;r=r.$parent;){var a=r.$options.errorCaptured;if(a)for(var s=0;s<a.length;s++)try{if(!1===a[s].call(r,e,t,n))return}catch(e){pn(e,r,"errorCaptured hook")}}pn(e,t,n)}finally{be()}}function fn(e,t,n,r,a){var s;try{(s=n?e.apply(t,n):e.call(t))&&!s._isVue&&f(s)&&!s._handled&&(s.catch((function(e){return hn(e,r,a+" (Promise/async)")})),s._handled=!0)}catch(e){hn(e,r,a)}return s}function pn(e,t,n){if(B.errorHandler)try{return B.errorHandler.call(null,e,t,n)}catch(t){t!==e&&yn(t,null,"config.errorHandler")}yn(e,t,n)}function yn(e,t,n){if(!K||"undefined"==typeof console)throw e;console.error(e)}var Mn,gn=!1,Ln=[],vn=!1;function Yn(){vn=!1;var e=Ln.slice(0);Ln.length=0;for(var t=0;t<e.length;t++)e[t]()}if("undefined"!=typeof Promise&&ue(Promise)){var wn=Promise.resolve();Mn=function(){wn.then(Yn),te&&setTimeout(H)},gn=!0}else if(X||"undefined"==typeof MutationObserver||!ue(MutationObserver)&&"[object MutationObserverConstructor]"!==MutationObserver.toString())Mn="undefined"!=typeof setImmediate&&ue(setImmediate)?function(){setImmediate(Yn)}:function(){setTimeout(Yn,0)};else{var kn=1,bn=new MutationObserver(Yn),Dn=document.createTextNode(String(kn));bn.observe(Dn,{characterData:!0}),Mn=function(){kn=(kn+1)%2,Dn.data=String(kn)},gn=!0}function Tn(e,t){var n;if(Ln.push((function(){if(e)try{e.call(t)}catch(e){hn(e,t,"nextTick")}else n&&n(t)})),vn||(vn=!0,Mn()),!e&&"undefined"!=typeof Promise)return new Promise((function(e){n=e}))}function Sn(e){if(void 0===e&&(e="$style"),!_e)return r;var t=_e[e];return t||r}function jn(e){if(K){var t,n=_e;if(n)t=function(){var t=n.$el,r=e(n,n._setupProxy);if(t&&1===t.nodeType){var a=t.style;for(var s in r)a.setProperty("--".concat(s),r[s])}},pt(t,null,{flush:"post"})}}function En(e){u(e)&&(e={loader:e});var t=e.loader,n=e.loadingComponent,r=e.errorComponent,a=e.delay,s=void 0===a?200:a,i=e.timeout,o=(e.suspensible,e.onError);var d=null,l=0,c=function(){var e;return d||(e=d=t().catch((function(e){if(e=e instanceof Error?e:new Error(String(e)),o)return new Promise((function(t,n){o(e,(function(){return t((l++,d=null,c()))}),(function(){return n(e)}),l+1)}));throw e})).then((function(t){return e!==d&&d?d:(t&&(t.__esModule||"Module"===t[Symbol.toStringTag])&&(t=t.default),t)})))};return function(){return{component:c(),delay:s,timeout:i,error:r,loading:n}}}function xn(e){return function(t,n){if(void 0===n&&(n=_e),n)return function(e,t,n){var r=e.$options;r[t]=wr(r[t],n)}(n,e,t)}}xn("beforeMount");var On=xn("mounted"),An=(xn("beforeUpdate"),xn("updated"),xn("beforeDestroy")),Hn=xn("destroyed");xn("activated"),xn("deactivated"),xn("serverPrefetch"),xn("renderTracked"),xn("renderTriggered"),xn("errorCaptured");function Pn(e){return e}var Cn=new le;function In(e){return Rn(e,Cn),Cn.clear(),e}function Rn(e,t){var n,r,s=a(e);if(!(!s&&!l(e)||e.__v_skip||Object.isFrozen(e)||e instanceof fe)){if(e.__ob__){var i=e.__ob__.dep.id;if(t.has(i))return;t.add(i)}if(s)for(n=e.length;n--;)Rn(e[n],t);else if(Ge(e))Rn(e.value,t);else for(n=(r=Object.keys(e)).length;n--;)Rn(e[r[n]],t)}}var Nn,Fn=0,Wn=function(){function e(e,t,n,r,a){var s,i;s=this,void 0===(i=mt&&!mt._vm?mt:e?e._scope:void 0)&&(i=mt),i&&i.active&&i.effects.push(s),(this.vm=e)&&a&&(e._watcher=this),r?(this.deep=!!r.deep,this.user=!!r.user,this.lazy=!!r.lazy,this.sync=!!r.sync,this.before=r.before):this.deep=this.user=this.lazy=this.sync=!1,this.cb=n,this.id=++Fn,this.active=!0,this.post=!1,this.dirty=this.lazy,this.deps=[],this.newDeps=[],this.depIds=new le,this.newDepIds=new le,this.expression="",u(t)?this.getter=t:(this.getter=function(e){if(!V.test(e)){var t=e.split(".");return function(e){for(var n=0;n<t.length;n++){if(!e)return;e=e[t[n]]}return e}}}(t),this.getter||(this.getter=H)),this.value=this.lazy?void 0:this.get()}return e.prototype.get=function(){var e;ke(this);var t=this.vm;try{e=this.getter.call(t,t)}catch(e){if(!this.user)throw e;hn(e,t,'getter for watcher "'.concat(this.expression,'"'))}finally{this.deep&&In(e),be(),this.cleanupDeps()}return e},e.prototype.addDep=function(e){var t=e.id;this.newDepIds.has(t)||(this.newDepIds.add(t),this.newDeps.push(e),this.depIds.has(t)||e.addSub(this))},e.prototype.cleanupDeps=function(){for(var e=this.deps.length;e--;){var t=this.deps[e];this.newDepIds.has(t.id)||t.removeSub(this)}var n=this.depIds;this.depIds=this.newDepIds,this.newDepIds=n,this.newDepIds.clear(),n=this.deps,this.deps=this.newDeps,this.newDeps=n,this.newDeps.length=0},e.prototype.update=function(){this.lazy?this.dirty=!0:this.sync?this.run():ur(this)},e.prototype.run=function(){if(this.active){var e=this.get();if(e!==this.value||l(e)||this.deep){var t=this.value;if(this.value=e,this.user){var n='callback for watcher "'.concat(this.expression,'"');fn(this.cb,this.vm,[e,t],this.vm,n)}else this.cb.call(this.vm,e,t)}}},e.prototype.evaluate=function(){this.value=this.get(),this.dirty=!1},e.prototype.depend=function(){for(var e=this.deps.length;e--;)this.deps[e].depend()},e.prototype.teardown=function(){if(this.vm&&!this.vm._isBeingDestroyed&&v(this.vm._scope.effects,this),this.active){for(var e=this.deps.length;e--;)this.deps[e].removeSub(this);this.active=!1,this.onStop&&this.onStop()}},e}();function $n(e,t){Nn.$on(e,t)}function Un(e,t){Nn.$off(e,t)}function Bn(e,t){var n=Nn;return function r(){null!==t.apply(null,arguments)&&n.$off(e,r)}}function zn(e,t,n){Nn=e,Dt(t,n||{},$n,Un,Bn,e),Nn=void 0}var Jn=null;function Gn(e){var t=Jn;return Jn=e,function(){Jn=t}}function Vn(e){for(;e&&(e=e.$parent);)if(e._inactive)return!0;return!1}function qn(e,t){if(t){if(e._directInactive=!1,Vn(e))return}else if(e._directInactive)return;if(e._inactive||null===e._inactive){e._inactive=!1;for(var n=0;n<e.$children.length;n++)qn(e.$children[n]);Zn(e,"activated")}}function Kn(e,t){if(!(t&&(e._directInactive=!0,Vn(e))||e._inactive)){e._inactive=!0;for(var n=0;n<e.$children.length;n++)Kn(e.$children[n]);Zn(e,"deactivated")}}function Zn(e,t,n,r){void 0===r&&(r=!0),ke();var a=_e,s=gt();r&&he(e);var i=e.$options[t],o="".concat(t," hook");if(i)for(var d=0,u=i.length;d<u;d++)fn(i[d],e,n||null,e,o);e._hasHookEvent&&e.$emit("hook:"+t),r&&(he(a),s&&s.on()),be()}var Xn=[],Qn=[],er={},tr=!1,nr=!1,rr=0;var ar=0,sr=Date.now;if(K&&!X){var ir=window.performance;ir&&"function"==typeof ir.now&&sr()>document.createEvent("Event").timeStamp&&(sr=function(){return ir.now()})}var or=function(e,t){if(e.post){if(!t.post)return 1}else if(t.post)return-1;return e.id-t.id};function dr(){var e,t;for(ar=sr(),nr=!0,Xn.sort(or),rr=0;rr<Xn.length;rr++)(e=Xn[rr]).before&&e.before(),t=e.id,er[t]=null,e.run();var n=Qn.slice(),r=Xn.slice();rr=Xn.length=Qn.length=0,er={},tr=nr=!1,function(e){for(var t=0;t<e.length;t++)e[t]._inactive=!0,qn(e[t],!0)}(n),function(e){var t=e.length;for(;t--;){var n=e[t],r=n.vm;r&&r._watcher===n&&r._isMounted&&!r._isDestroyed&&Zn(r,"updated")}}(r),ve(),de&&B.devtools&&de.emit("flush")}function ur(e){var t=e.id;if(null==er[t]&&(e!==Ye.target||!e.noRecurse)){if(er[t]=!0,nr){for(var n=Xn.length-1;n>rr&&Xn[n].id>e.id;)n--;Xn.splice(n+1,0,e)}else Xn.push(e);tr||(tr=!0,Tn(dr))}}function lr(e,t){if(e){for(var n=Object.create(null),r=ce?Reflect.ownKeys(e):Object.keys(e),a=0;a<r.length;a++){var s=r[a];if("__ob__"!==s){var i=e[s].from;if(i in t._provided)n[s]=t._provided[i];else if("default"in e[s]){var o=e[s].default;n[s]=u(o)?o.call(t):o}else 0}}return n}}function cr(e,t,n,s,i){var d,u=this,l=i.options;w(s,"_uid")?(d=Object.create(s))._original=s:(d=s,s=s._original);var c=o(l._compiled),_=!c;this.data=e,this.props=t,this.children=n,this.parent=s,this.listeners=e.on||r,this.injections=lr(l.inject,s),this.slots=function(){return u.$slots||Kt(s,e.scopedSlots,u.$slots=Gt(n,s)),u.$slots},Object.defineProperty(this,"scopedSlots",{enumerable:!0,get:function(){return Kt(s,e.scopedSlots,this.slots())}}),c&&(this.$options=l,this.$slots=this.slots(),this.$scopedSlots=Kt(s,e.scopedSlots,this.$slots)),l._scopeId?this._c=function(e,t,n,r){var i=cn(d,e,t,n,r,_);return i&&!a(i)&&(i.fnScopeId=l._scopeId,i.fnContext=s),i}:this._c=function(e,t,n,r){return cn(d,e,t,n,r,_)}}function _r(e,t,n,r,a){var s=Me(e);return s.fnContext=n,s.fnOptions=r,t.slot&&((s.data||(s.data={})).slot=t.slot),s}function mr(e,t){for(var n in t)e[D(n)]=t[n]}function hr(e){return e.name||e.__name||e._componentTag}Jt(cr.prototype);var fr={init:function(e,t){if(e.componentInstance&&!e.componentInstance._isDestroyed&&e.data.keepAlive){var n=e;fr.prepatch(n,n)}else{(e.componentInstance=function(e,t){var n={_isComponent:!0,_parentVnode:e,parent:t},r=e.data.inlineTemplate;i(r)&&(n.render=r.render,n.staticRenderFns=r.staticRenderFns);return new e.componentOptions.Ctor(n)}(e,Jn)).$mount(t?e.elm:void 0,t)}},prepatch:function(e,t){var n=t.componentOptions;!function(e,t,n,a,s){var i=a.data.scopedSlots,o=e.$scopedSlots,d=!!(i&&!i.$stable||o!==r&&!o.$stable||i&&e.$scopedSlots.$key!==i.$key||!i&&e.$scopedSlots.$key),u=!!(s||e.$options._renderChildren||d),l=e.$vnode;e.$options._parentVnode=a,e.$vnode=a,e._vnode&&(e._vnode.parent=a),e.$options._renderChildren=s;var c=a.data.attrs||r;e._attrsProxy&&en(e._attrsProxy,c,l.data&&l.data.attrs||r,e,"$attrs")&&(u=!0),e.$attrs=c,n=n||r;var _=e.$options._parentListeners;if(e._listenersProxy&&en(e._listenersProxy,n,_||r,e,"$listeners"),e.$listeners=e.$options._parentListeners=n,zn(e,n,_),t&&e.$options.props){xe(!1);for(var m=e._props,h=e.$options._propKeys||[],f=0;f<h.length;f++){var p=h[f],y=e.$options.props;m[p]=Sr(p,y,t,e)}xe(!0),e.$options.propsData=t}u&&(e.$slots=Gt(s,a.context),e.$forceUpdate())}(t.componentInstance=e.componentInstance,n.propsData,n.listeners,t,n.children)},insert:function(e){var t,n=e.context,r=e.componentInstance;r._isMounted||(r._isMounted=!0,Zn(r,"mounted")),e.data.keepAlive&&(n._isMounted?((t=r)._inactive=!1,Qn.push(t)):qn(r,!0))},destroy:function(e){var t=e.componentInstance;t._isDestroyed||(e.data.keepAlive?Kn(t,!0):t.$destroy())}},pr=Object.keys(fr);function yr(e,t,n,d,u){if(!s(e)){var c=n.$options._base;if(l(e)&&(e=c.extend(e)),"function"==typeof e){var _;if(s(e.cid)&&(e=function(e,t){if(o(e.error)&&i(e.errorComp))return e.errorComp;if(i(e.resolved))return e.resolved;var n=sn;if(n&&i(e.owners)&&-1===e.owners.indexOf(n)&&e.owners.push(n),o(e.loading)&&i(e.loadingComp))return e.loadingComp;if(n&&!i(e.owners)){var r=e.owners=[n],a=!0,d=null,u=null;n.$on("hook:destroyed",(function(){return v(r,n)}));var c=function(e){for(var t=0,n=r.length;t<n;t++)r[t].$forceUpdate();e&&(r.length=0,null!==d&&(clearTimeout(d),d=null),null!==u&&(clearTimeout(u),u=null))},_=N((function(n){e.resolved=on(n,t),a?r.length=0:c(!0)})),m=N((function(t){i(e.errorComp)&&(e.error=!0,c(!0))})),h=e(_,m);return l(h)&&(f(h)?s(e.resolved)&&h.then(_,m):f(h.component)&&(h.component.then(_,m),i(h.error)&&(e.errorComp=on(h.error,t)),i(h.loading)&&(e.loadingComp=on(h.loading,t),0===h.delay?e.loading=!0:d=setTimeout((function(){d=null,s(e.resolved)&&s(e.error)&&(e.loading=!0,c(!1))}),h.delay||200)),i(h.timeout)&&(u=setTimeout((function(){u=null,s(e.resolved)&&m(null)}),h.timeout)))),a=!1,e.loading?e.loadingComp:e.resolved}}(_=e,c),void 0===e))return function(e,t,n,r,a){var s=pe();return s.asyncFactory=e,s.asyncMeta={data:t,context:n,children:r,tag:a},s}(_,t,n,d,u);t=t||{},$r(e),i(t.model)&&function(e,t){var n=e.model&&e.model.prop||"value",r=e.model&&e.model.event||"input";(t.attrs||(t.attrs={}))[n]=t.model.value;var s=t.on||(t.on={}),o=s[r],d=t.model.callback;i(o)?(a(o)?-1===o.indexOf(d):o!==d)&&(s[r]=[d].concat(o)):s[r]=d}(e.options,t);var m=function(e,t){var n=t.options.props;if(!s(n)){var r={},a=e.attrs,o=e.props;if(i(a)||i(o))for(var d in n){var u=j(d);St(r,o,d,u,!0)||St(r,a,d,u,!1)}return r}}(t,e);if(o(e.options.functional))return function(e,t,n,s,o){var d=e.options,u={},l=d.props;if(i(l))for(var c in l)u[c]=Sr(c,l,t||r);else i(n.attrs)&&mr(u,n.attrs),i(n.props)&&mr(u,n.props);var _=new cr(n,u,o,s,e),m=d.render.call(null,_._c,_);if(m instanceof fe)return _r(m,n,_.parent,d);if(a(m)){for(var h=jt(m)||[],f=new Array(h.length),p=0;p<h.length;p++)f[p]=_r(h[p],n,_.parent,d);return f}}(e,m,t,n,d);var h=t.on;if(t.on=t.nativeOn,o(e.options.abstract)){var p=t.slot;t={},p&&(t.slot=p)}!function(e){for(var t=e.hook||(e.hook={}),n=0;n<pr.length;n++){var r=pr[n],a=t[r],s=fr[r];a===s||a&&a._merged||(t[r]=a?Mr(s,a):s)}}(t);var y=hr(e.options)||u;return new fe("vue-component-".concat(e.cid).concat(y?"-".concat(y):""),t,void 0,void 0,void 0,n,{Ctor:e,propsData:m,listeners:h,tag:u,children:d},_)}}}function Mr(e,t){var n=function(n,r){e(n,r),t(n,r)};return n._merged=!0,n}var gr=H,Lr=B.optionMergeStrategies;function vr(e,t,n){if(void 0===n&&(n=!0),!t)return e;for(var r,a,s,i=ce?Reflect.ownKeys(t):Object.keys(t),o=0;o<i.length;o++)"__ob__"!==(r=i[o])&&(a=e[r],s=t[r],n&&w(e,r)?a!==s&&_(a)&&_(s)&&vr(a,s):Ce(e,r,s));return e}function Yr(e,t,n){return n?function(){var r=u(t)?t.call(n,n):t,a=u(e)?e.call(n,n):e;return r?vr(r,a):a}:t?e?function(){return vr(u(t)?t.call(this,this):t,u(e)?e.call(this,this):e)}:t:e}function wr(e,t){var n=t?e?e.concat(t):a(t)?t:[t]:e;return n?function(e){for(var t=[],n=0;n<e.length;n++)-1===t.indexOf(e[n])&&t.push(e[n]);return t}(n):n}function kr(e,t,n,r){var a=Object.create(e||null);return t?O(a,t):a}Lr.data=function(e,t,n){return n?Yr(e,t,n):t&&"function"!=typeof t?e:Yr(e,t)},U.forEach((function(e){Lr[e]=wr})),$.forEach((function(e){Lr[e+"s"]=kr})),Lr.watch=function(e,t,n,r){if(e===ae&&(e=void 0),t===ae&&(t=void 0),!t)return Object.create(e||null);if(!e)return t;var s={};for(var i in O(s,e),t){var o=s[i],d=t[i];o&&!a(o)&&(o=[o]),s[i]=o?o.concat(d):a(d)?d:[d]}return s},Lr.props=Lr.methods=Lr.inject=Lr.computed=function(e,t,n,r){if(!e)return t;var a=Object.create(null);return O(a,e),t&&O(a,t),a},Lr.provide=function(e,t){return e?function(){var n=Object.create(null);return vr(n,u(e)?e.call(this):e),t&&vr(n,u(t)?t.call(this):t,!1),n}:t};var br=function(e,t){return void 0===t?e:t};function Dr(e,t,n){if(u(t)&&(t=t.options),function(e){var t=e.props;if(t){var n,r,s={};if(a(t))for(n=t.length;n--;)"string"==typeof(r=t[n])&&(s[D(r)]={type:null});else if(_(t))for(var i in t)r=t[i],s[D(i)]=_(r)?r:{type:r};e.props=s}}(t),function(e){var t=e.inject;if(t){var n=e.inject={};if(a(t))for(var r=0;r<t.length;r++)n[t[r]]={from:t[r]};else if(_(t))for(var s in t){var i=t[s];n[s]=_(i)?O({from:s},i):{from:i}}}}(t),function(e){var t=e.directives;if(t)for(var n in t){var r=t[n];u(r)&&(t[n]={bind:r,update:r})}}(t),!t._base&&(t.extends&&(e=Dr(e,t.extends,n)),t.mixins))for(var r=0,s=t.mixins.length;r<s;r++)e=Dr(e,t.mixins[r],n);var i,o={};for(i in e)d(i);for(i in t)w(e,i)||d(i);function d(r){var a=Lr[r]||br;o[r]=a(e[r],t[r],n,r)}return o}function Tr(e,t,n,r){if("string"==typeof n){var a=e[t];if(w(a,n))return a[n];var s=D(n);if(w(a,s))return a[s];var i=T(s);return w(a,i)?a[i]:a[n]||a[s]||a[i]}}function Sr(e,t,n,r){var a=t[e],s=!w(n,e),i=n[e],o=Or(Boolean,a.type);if(o>-1)if(s&&!w(a,"default"))i=!1;else if(""===i||i===j(e)){var d=Or(String,a.type);(d<0||o<d)&&(i=!0)}if(void 0===i){i=function(e,t,n){if(!w(t,"default"))return;var r=t.default;0;if(e&&e.$options.propsData&&void 0===e.$options.propsData[n]&&void 0!==e._props[n])return e._props[n];return u(r)&&"Function"!==Er(t.type)?r.call(e):r}(r,a,e);var l=Ee;xe(!0),He(i),xe(l)}return i}var jr=/^\s*function (\w+)/;function Er(e){var t=e&&e.toString().match(jr);return t?t[1]:""}function xr(e,t){return Er(e)===Er(t)}function Or(e,t){if(!a(t))return xr(t,e)?0:-1;for(var n=0,r=t.length;n<r;n++)if(xr(t[n],e))return n;return-1}var Ar={enumerable:!0,configurable:!0,get:H,set:H};function Hr(e,t,n){Ar.get=function(){return this[t][n]},Ar.set=function(e){this[t][n]=e},Object.defineProperty(e,n,Ar)}function Pr(e){var t=e.$options;if(t.props&&function(e,t){var n=e.$options.propsData||{},r=e._props=Fe({}),a=e.$options._propKeys=[],s=!e.$parent;s||xe(!1);var i=function(s){a.push(s);var i=Sr(s,t,n,e);Pe(r,s,i,void 0,!0),s in e||Hr(e,"_props",s)};for(var o in t)i(o);xe(!0)}(e,t.props),function(e){var t=e.$options,n=t.setup;if(n){var r=e._setupContext=Qt(e);he(e),ke();var a=fn(n,null,[e._props||Fe({}),r],e,"setup");if(be(),he(),u(a))t.render=a;else if(l(a))if(e._setupState=a,a.__sfc){var s=e._setupProxy={};for(var i in a)"__sfc"!==i&&Xe(s,a,i)}else for(var i in a)J(i)||Xe(e,a,i)}}(e),t.methods&&function(e,t){e.$options.props;for(var n in t)e[n]="function"!=typeof t[n]?H:E(t[n],e)}(e,t.methods),t.data)!function(e){var t=e.$options.data;t=e._data=u(t)?function(e,t){ke();try{return e.call(t,t)}catch(e){return hn(e,t,"data()"),{}}finally{be()}}(t,e):t||{},_(t)||(t={});var n=Object.keys(t),r=e.$options.props,a=(e.$options.methods,n.length);for(;a--;){var s=n[a];0,r&&w(r,s)||J(s)||Hr(e,"_data",s)}var i=He(t);i&&i.vmCount++}(e);else{var n=He(e._data={});n&&n.vmCount++}t.computed&&function(e,t){var n=e._computedWatchers=Object.create(null),r=oe();for(var a in t){var s=t[a],i=u(s)?s:s.get;0,r||(n[a]=new Wn(e,i||H,H,Cr)),a in e||Ir(e,a,s)}}(e,t.computed),t.watch&&t.watch!==ae&&function(e,t){for(var n in t){var r=t[n];if(a(r))for(var s=0;s<r.length;s++)Fr(e,n,r[s]);else Fr(e,n,r)}}(e,t.watch)}var Cr={lazy:!0};function Ir(e,t,n){var r=!oe();u(n)?(Ar.get=r?Rr(t):Nr(n),Ar.set=H):(Ar.get=n.get?r&&!1!==n.cache?Rr(t):Nr(n.get):H,Ar.set=n.set||H),Object.defineProperty(e,t,Ar)}function Rr(e){return function(){var t=this._computedWatchers&&this._computedWatchers[e];if(t)return t.dirty&&t.evaluate(),Ye.target&&t.depend(),t.value}}function Nr(e){return function(){return e.call(this,this)}}function Fr(e,t,n,r){return _(n)&&(r=n,n=n.handler),"string"==typeof n&&(n=e[n]),e.$watch(t,n,r)}var Wr=0;function $r(e){var t=e.options;if(e.super){var n=$r(e.super);if(n!==e.superOptions){e.superOptions=n;var r=function(e){var t,n=e.options,r=e.sealedOptions;for(var a in n)n[a]!==r[a]&&(t||(t={}),t[a]=n[a]);return t}(e);r&&O(e.extendOptions,r),(t=e.options=Dr(n,e.extendOptions)).name&&(t.components[t.name]=e)}}return t}function Ur(e){this._init(e)}function Br(e){e.cid=0;var t=1;e.extend=function(e){e=e||{};var n=this,r=n.cid,a=e._Ctor||(e._Ctor={});if(a[r])return a[r];var s=hr(e)||hr(n.options);var i=function(e){this._init(e)};return(i.prototype=Object.create(n.prototype)).constructor=i,i.cid=t++,i.options=Dr(n.options,e),i.super=n,i.options.props&&function(e){var t=e.options.props;for(var n in t)Hr(e.prototype,"_props",n)}(i),i.options.computed&&function(e){var t=e.options.computed;for(var n in t)Ir(e.prototype,n,t[n])}(i),i.extend=n.extend,i.mixin=n.mixin,i.use=n.use,$.forEach((function(e){i[e]=n[e]})),s&&(i.options.components[s]=i),i.superOptions=n.options,i.extendOptions=e,i.sealedOptions=O({},i.options),a[r]=i,i}}function zr(e){return e&&(hr(e.Ctor.options)||e.tag)}function Jr(e,t){return a(e)?e.indexOf(t)>-1:"string"==typeof e?e.split(",").indexOf(t)>-1:!!m(e)&&e.test(t)}function Gr(e,t){var n=e.cache,r=e.keys,a=e._vnode,s=e.$vnode;for(var i in n){var o=n[i];if(o){var d=o.name;d&&!t(d)&&Vr(n,i,r,a)}}s.componentOptions.children=void 0}function Vr(e,t,n,r){var a=e[t];!a||r&&a.tag===r.tag||a.componentInstance.$destroy(),e[t]=null,v(n,t)}!function(e){e.prototype._init=function(e){var t=this;t._uid=Wr++,t._isVue=!0,t.__v_skip=!0,t._scope=new yt(!0),t._scope.parent=void 0,t._scope._vm=!0,e&&e._isComponent?function(e,t){var n=e.$options=Object.create(e.constructor.options),r=t._parentVnode;n.parent=t.parent,n._parentVnode=r;var a=r.componentOptions;n.propsData=a.propsData,n._parentListeners=a.listeners,n._renderChildren=a.children,n._componentTag=a.tag,t.render&&(n.render=t.render,n.staticRenderFns=t.staticRenderFns)}(t,e):t.$options=Dr($r(t.constructor),e||{},t),t._renderProxy=t,t._self=t,function(e){var t=e.$options,n=t.parent;if(n&&!t.abstract){for(;n.$options.abstract&&n.$parent;)n=n.$parent;n.$children.push(e)}e.$parent=n,e.$root=n?n.$root:e,e.$children=[],e.$refs={},e._provided=n?n._provided:Object.create(null),e._watcher=null,e._inactive=null,e._directInactive=!1,e._isMounted=!1,e._isDestroyed=!1,e._isBeingDestroyed=!1}(t),function(e){e._events=Object.create(null),e._hasHookEvent=!1;var t=e.$options._parentListeners;t&&zn(e,t)}(t),function(e){e._vnode=null,e._staticTrees=null;var t=e.$options,n=e.$vnode=t._parentVnode,a=n&&n.context;e.$slots=Gt(t._renderChildren,a),e.$scopedSlots=n?Kt(e.$parent,n.data.scopedSlots,e.$slots):r,e._c=function(t,n,r,a){return cn(e,t,n,r,a,!1)},e.$createElement=function(t,n,r,a){return cn(e,t,n,r,a,!0)};var s=n&&n.data;Pe(e,"$attrs",s&&s.attrs||r,null,!0),Pe(e,"$listeners",t._parentListeners||r,null,!0)}(t),Zn(t,"beforeCreate",void 0,!1),function(e){var t=lr(e.$options.inject,e);t&&(xe(!1),Object.keys(t).forEach((function(n){Pe(e,n,t[n])})),xe(!0))}(t),Pr(t),function(e){var t=e.$options.provide;if(t){var n=u(t)?t.call(e):t;if(!l(n))return;for(var r=Yt(e),a=ce?Reflect.ownKeys(n):Object.keys(n),s=0;s<a.length;s++){var i=a[s];Object.defineProperty(r,i,Object.getOwnPropertyDescriptor(n,i))}}}(t),Zn(t,"created"),t.$options.el&&t.$mount(t.$options.el)}}(Ur),function(e){var t={get:function(){return this._data}},n={get:function(){return this._props}};Object.defineProperty(e.prototype,"$data",t),Object.defineProperty(e.prototype,"$props",n),e.prototype.$set=Ce,e.prototype.$delete=Ie,e.prototype.$watch=function(e,t,n){var r=this;if(_(t))return Fr(r,e,t,n);(n=n||{}).user=!0;var a=new Wn(r,e,t,n);if(n.immediate){var s='callback for immediate watcher "'.concat(a.expression,'"');ke(),fn(t,r,[a.value],r,s),be()}return function(){a.teardown()}}}(Ur),function(e){var t=/^hook:/;e.prototype.$on=function(e,n){var r=this;if(a(e))for(var s=0,i=e.length;s<i;s++)r.$on(e[s],n);else(r._events[e]||(r._events[e]=[])).push(n),t.test(e)&&(r._hasHookEvent=!0);return r},e.prototype.$once=function(e,t){var n=this;function r(){n.$off(e,r),t.apply(n,arguments)}return r.fn=t,n.$on(e,r),n},e.prototype.$off=function(e,t){var n=this;if(!arguments.length)return n._events=Object.create(null),n;if(a(e)){for(var r=0,s=e.length;r<s;r++)n.$off(e[r],t);return n}var i,o=n._events[e];if(!o)return n;if(!t)return n._events[e]=null,n;for(var d=o.length;d--;)if((i=o[d])===t||i.fn===t){o.splice(d,1);break}return n},e.prototype.$emit=function(e){var t=this,n=t._events[e];if(n){n=n.length>1?x(n):n;for(var r=x(arguments,1),a='event handler for "'.concat(e,'"'),s=0,i=n.length;s<i;s++)fn(n[s],t,r,t,a)}return t}}(Ur),function(e){e.prototype._update=function(e,t){var n=this,r=n.$el,a=n._vnode,s=Gn(n);n._vnode=e,n.$el=a?n.__patch__(a,e):n.__patch__(n.$el,e,t,!1),s(),r&&(r.__vue__=null),n.$el&&(n.$el.__vue__=n);for(var i=n;i&&i.$vnode&&i.$parent&&i.$vnode===i.$parent._vnode;)i.$parent.$el=i.$el,i=i.$parent},e.prototype.$forceUpdate=function(){this._watcher&&this._watcher.update()},e.prototype.$destroy=function(){var e=this;if(!e._isBeingDestroyed){Zn(e,"beforeDestroy"),e._isBeingDestroyed=!0;var t=e.$parent;!t||t._isBeingDestroyed||e.$options.abstract||v(t.$children,e),e._scope.stop(),e._data.__ob__&&e._data.__ob__.vmCount--,e._isDestroyed=!0,e.__patch__(e._vnode,null),Zn(e,"destroyed"),e.$off(),e.$el&&(e.$el.__vue__=null),e.$vnode&&(e.$vnode.parent=null)}}}(Ur),function(e){Jt(e.prototype),e.prototype.$nextTick=function(e){return Tn(e,this)},e.prototype._render=function(){var e=this,t=e.$options,n=t.render,r=t._parentVnode;r&&e._isMounted&&(e.$scopedSlots=Kt(e.$parent,r.data.scopedSlots,e.$slots,e.$scopedSlots),e._slotsProxy&&nn(e._slotsProxy,e.$scopedSlots)),e.$vnode=r;var s,i=_e,o=sn;try{he(e),sn=e,s=n.call(e._renderProxy,e.$createElement)}catch(t){hn(t,e,"render"),s=e._vnode}finally{sn=o,he(i)}return a(s)&&1===s.length&&(s=s[0]),s instanceof fe||(s=pe()),s.parent=r,s}}(Ur);var qr=[String,RegExp,Array],Kr={KeepAlive:{name:"keep-alive",abstract:!0,props:{include:qr,exclude:qr,max:[String,Number]},methods:{cacheVNode:function(){var e=this,t=e.cache,n=e.keys,r=e.vnodeToCache,a=e.keyToCache;if(r){var s=r.tag,i=r.componentInstance,o=r.componentOptions;t[a]={name:zr(o),tag:s,componentInstance:i},n.push(a),this.max&&n.length>parseInt(this.max)&&Vr(t,n[0],n,this._vnode),this.vnodeToCache=null}}},created:function(){this.cache=Object.create(null),this.keys=[]},destroyed:function(){for(var e in this.cache)Vr(this.cache,e,this.keys)},mounted:function(){var e=this;this.cacheVNode(),this.$watch("include",(function(t){Gr(e,(function(e){return Jr(t,e)}))})),this.$watch("exclude",(function(t){Gr(e,(function(e){return!Jr(t,e)}))}))},updated:function(){this.cacheVNode()},render:function(){var e=this.$slots.default,t=dn(e),n=t&&t.componentOptions;if(n){var r=zr(n),a=this.include,s=this.exclude;if(a&&(!r||!Jr(a,r))||s&&r&&Jr(s,r))return t;var i=this.cache,o=this.keys,d=null==t.key?n.Ctor.cid+(n.tag?"::".concat(n.tag):""):t.key;i[d]?(t.componentInstance=i[d].componentInstance,v(o,d),o.push(d)):(this.vnodeToCache=t,this.keyToCache=d),t.data.keepAlive=!0}return t||e&&e[0]}}};!function(e){var t={get:function(){return B}};Object.defineProperty(e,"config",t),e.util={warn:gr,extend:O,mergeOptions:Dr,defineReactive:Pe},e.set=Ce,e.delete=Ie,e.nextTick=Tn,e.observable=function(e){return He(e),e},e.options=Object.create(null),$.forEach((function(t){e.options[t+"s"]=Object.create(null)})),e.options._base=e,O(e.options.components,Kr),function(e){e.use=function(e){var t=this._installedPlugins||(this._installedPlugins=[]);if(t.indexOf(e)>-1)return this;var n=x(arguments,1);return n.unshift(this),u(e.install)?e.install.apply(e,n):u(e)&&e.apply(null,n),t.push(e),this}}(e),function(e){e.mixin=function(e){return this.options=Dr(this.options,e),this}}(e),Br(e),function(e){$.forEach((function(t){e[t]=function(e,n){return n?("component"===t&&_(n)&&(n.name=n.name||e,n=this.options._base.extend(n)),"directive"===t&&u(n)&&(n={bind:n,update:n}),this.options[t+"s"][e]=n,n):this.options[t+"s"][e]}}))}(e)}(Ur),Object.defineProperty(Ur.prototype,"$isServer",{get:oe}),Object.defineProperty(Ur.prototype,"$ssrContext",{get:function(){return this.$vnode&&this.$vnode.ssrContext}}),Object.defineProperty(Ur,"FunctionalRenderContext",{value:cr}),Ur.version="2.7.16";var Zr=g("style,class"),Xr=g("input,textarea,option,select,progress"),Qr=g("contenteditable,draggable,spellcheck"),ea=g("events,caret,typing,plaintext-only"),ta=function(e,t){return ia(t)||"false"===t?"false":"contenteditable"===e&&ea(t)?t:"true"},na=g("allowfullscreen,async,autofocus,autoplay,checked,compact,controls,declare,default,defaultchecked,defaultmuted,defaultselected,defer,disabled,enabled,formnovalidate,hidden,indeterminate,inert,ismap,itemscope,loop,multiple,muted,nohref,noresize,noshade,novalidate,nowrap,open,pauseonexit,readonly,required,reversed,scoped,seamless,selected,sortable,truespeed,typemustmatch,visible"),ra="http://www.w3.org/1999/xlink",aa=function(e){return":"===e.charAt(5)&&"xlink"===e.slice(0,5)},sa=function(e){return aa(e)?e.slice(6,e.length):""},ia=function(e){return null==e||!1===e};function oa(e){for(var t=e.data,n=e,r=e;i(r.componentInstance);)(r=r.componentInstance._vnode)&&r.data&&(t=da(r.data,t));for(;i(n=n.parent);)n&&n.data&&(t=da(t,n.data));return function(e,t){if(i(e)||i(t))return ua(e,la(t));return""}(t.staticClass,t.class)}function da(e,t){return{staticClass:ua(e.staticClass,t.staticClass),class:i(e.class)?[e.class,t.class]:t.class}}function ua(e,t){return e?t?e+" "+t:e:t||""}function la(e){return Array.isArray(e)?function(e){for(var t,n="",r=0,a=e.length;r<a;r++)i(t=la(e[r]))&&""!==t&&(n&&(n+=" "),n+=t);return n}(e):l(e)?function(e){var t="";for(var n in e)e[n]&&(t&&(t+=" "),t+=n);return t}(e):"string"==typeof e?e:""}var ca={svg:"http://www.w3.org/2000/svg",math:"http://www.w3.org/1998/Math/MathML"},_a=g("html,body,base,head,link,meta,style,title,address,article,aside,footer,header,h1,h2,h3,h4,h5,h6,hgroup,nav,section,div,dd,dl,dt,figcaption,figure,picture,hr,img,li,main,ol,p,pre,ul,a,b,abbr,bdi,bdo,br,cite,code,data,dfn,em,i,kbd,mark,q,rp,rt,rtc,ruby,s,samp,small,span,strong,sub,sup,time,u,var,wbr,area,audio,map,track,video,embed,object,param,source,canvas,script,noscript,del,ins,caption,col,colgroup,table,thead,tbody,td,th,tr,button,datalist,fieldset,form,input,label,legend,meter,optgroup,option,output,progress,select,textarea,details,dialog,menu,menuitem,summary,content,element,shadow,template,blockquote,iframe,tfoot"),ma=g("svg,animate,circle,clippath,cursor,defs,desc,ellipse,filter,font-face,foreignobject,g,glyph,image,line,marker,mask,missing-glyph,path,pattern,polygon,polyline,rect,switch,symbol,text,textpath,tspan,use,view",!0),ha=function(e){return _a(e)||ma(e)};var fa=Object.create(null);var pa=g("text,number,password,search,email,tel,url");var ya=Object.freeze({__proto__:null,createElement:function(e,t){var n=document.createElement(e);return"select"!==e||t.data&&t.data.attrs&&void 0!==t.data.attrs.multiple&&n.setAttribute("multiple","multiple"),n},createElementNS:function(e,t){return document.createElementNS(ca[e],t)},createTextNode:function(e){return document.createTextNode(e)},createComment:function(e){return document.createComment(e)},insertBefore:function(e,t,n){e.insertBefore(t,n)},removeChild:function(e,t){e.removeChild(t)},appendChild:function(e,t){e.appendChild(t)},parentNode:function(e){return e.parentNode},nextSibling:function(e){return e.nextSibling},tagName:function(e){return e.tagName},setTextContent:function(e,t){e.textContent=t},setStyleScope:function(e,t){e.setAttribute(t,"")}}),Ma={create:function(e,t){ga(t)},update:function(e,t){e.data.ref!==t.data.ref&&(ga(e,!0),ga(t))},destroy:function(e){ga(e,!0)}};function ga(e,t){var n=e.data.ref;if(i(n)){var r=e.context,s=e.componentInstance||e.elm,o=t?null:s,d=t?void 0:s;if(u(n))fn(n,r,[o],r,"template ref function");else{var l=e.data.refInFor,c="string"==typeof n||"number"==typeof n,_=Ge(n),m=r.$refs;if(c||_)if(l){var h=c?m[n]:n.value;t?a(h)&&v(h,s):a(h)?h.includes(s)||h.push(s):c?(m[n]=[s],La(r,n,m[n])):n.value=[s]}else if(c){if(t&&m[n]!==s)return;m[n]=d,La(r,n,o)}else if(_){if(t&&n.value!==s)return;n.value=o}else 0}}}function La(e,t,n){var r=e._setupState;r&&w(r,t)&&(Ge(r[t])?r[t].value=n:r[t]=n)}var va=new fe("",{},[]),Ya=["create","activate","update","remove","destroy"];function wa(e,t){return e.key===t.key&&e.asyncFactory===t.asyncFactory&&(e.tag===t.tag&&e.isComment===t.isComment&&i(e.data)===i(t.data)&&function(e,t){if("input"!==e.tag)return!0;var n,r=i(n=e.data)&&i(n=n.attrs)&&n.type,a=i(n=t.data)&&i(n=n.attrs)&&n.type;return r===a||pa(r)&&pa(a)}(e,t)||o(e.isAsyncPlaceholder)&&s(t.asyncFactory.error))}function ka(e,t,n){var r,a,s={};for(r=t;r<=n;++r)i(a=e[r].key)&&(s[a]=r);return s}var ba={create:Da,update:Da,destroy:function(e){Da(e,va)}};function Da(e,t){(e.data.directives||t.data.directives)&&function(e,t){var n,r,a,s=e===va,i=t===va,o=Sa(e.data.directives,e.context),d=Sa(t.data.directives,t.context),u=[],l=[];for(n in d)r=o[n],a=d[n],r?(a.oldValue=r.value,a.oldArg=r.arg,Ea(a,"update",t,e),a.def&&a.def.componentUpdated&&l.push(a)):(Ea(a,"bind",t,e),a.def&&a.def.inserted&&u.push(a));if(u.length){var c=function(){for(var n=0;n<u.length;n++)Ea(u[n],"inserted",t,e)};s?Tt(t,"insert",c):c()}l.length&&Tt(t,"postpatch",(function(){for(var n=0;n<l.length;n++)Ea(l[n],"componentUpdated",t,e)}));if(!s)for(n in o)d[n]||Ea(o[n],"unbind",e,e,i)}(e,t)}var Ta=Object.create(null);function Sa(e,t){var n,r,a=Object.create(null);if(!e)return a;for(n=0;n<e.length;n++){if((r=e[n]).modifiers||(r.modifiers=Ta),a[ja(r)]=r,t._setupState&&t._setupState.__sfc){var s=r.def||Tr(t,"_setupState","v-"+r.name);r.def="function"==typeof s?{bind:s,update:s}:s}r.def=r.def||Tr(t.$options,"directives",r.name)}return a}function ja(e){return e.rawName||"".concat(e.name,".").concat(Object.keys(e.modifiers||{}).join("."))}function Ea(e,t,n,r,a){var s=e.def&&e.def[t];if(s)try{s(n.elm,e,n,r,a)}catch(r){hn(r,n.context,"directive ".concat(e.name," ").concat(t," hook"))}}var xa=[Ma,ba];function Oa(e,t){var n=t.componentOptions;if(!(i(n)&&!1===n.Ctor.options.inheritAttrs||s(e.data.attrs)&&s(t.data.attrs))){var r,a,d=t.elm,u=e.data.attrs||{},l=t.data.attrs||{};for(r in(i(l.__ob__)||o(l._v_attr_proxy))&&(l=t.data.attrs=O({},l)),l)a=l[r],u[r]!==a&&Aa(d,r,a,t.data.pre);for(r in(X||ee)&&l.value!==u.value&&Aa(d,"value",l.value),u)s(l[r])&&(aa(r)?d.removeAttributeNS(ra,sa(r)):Qr(r)||d.removeAttribute(r))}}function Aa(e,t,n,r){r||e.tagName.indexOf("-")>-1?Ha(e,t,n):na(t)?ia(n)?e.removeAttribute(t):(n="allowfullscreen"===t&&"EMBED"===e.tagName?"true":t,e.setAttribute(t,n)):Qr(t)?e.setAttribute(t,ta(t,n)):aa(t)?ia(n)?e.removeAttributeNS(ra,sa(t)):e.setAttributeNS(ra,t,n):Ha(e,t,n)}function Ha(e,t,n){if(ia(n))e.removeAttribute(t);else{if(X&&!Q&&"TEXTAREA"===e.tagName&&"placeholder"===t&&""!==n&&!e.__ieph){var r=function(t){t.stopImmediatePropagation(),e.removeEventListener("input",r)};e.addEventListener("input",r),e.__ieph=!0}e.setAttribute(t,n)}}var Pa={create:Oa,update:Oa};function Ca(e,t){var n=t.elm,r=t.data,a=e.data;if(!(s(r.staticClass)&&s(r.class)&&(s(a)||s(a.staticClass)&&s(a.class)))){var o=oa(t),d=n._transitionClasses;i(d)&&(o=ua(o,la(d))),o!==n._prevClass&&(n.setAttribute("class",o),n._prevClass=o)}}var Ia,Ra={create:Ca,update:Ca},Na="__r",Fa="__c";function Wa(e,t,n){var r=Ia;return function a(){null!==t.apply(null,arguments)&&Ba(e,a,n,r)}}var $a=gn&&!(re&&Number(re[1])<=53);function Ua(e,t,n,r){if($a){var a=ar,s=t;t=s._wrapper=function(e){if(e.target===e.currentTarget||e.timeStamp>=a||e.timeStamp<=0||e.target.ownerDocument!==document)return s.apply(this,arguments)}}Ia.addEventListener(e,t,se?{capture:n,passive:r}:n)}function Ba(e,t,n,r){(r||Ia).removeEventListener(e,t._wrapper||t,n)}function za(e,t){if(!s(e.data.on)||!s(t.data.on)){var n=t.data.on||{},r=e.data.on||{};Ia=t.elm||e.elm,function(e){if(i(e[Na])){var t=X?"change":"input";e[t]=[].concat(e[Na],e[t]||[]),delete e[Na]}i(e[Fa])&&(e.change=[].concat(e[Fa],e.change||[]),delete e[Fa])}(n),Dt(n,r,Ua,Ba,Wa,t.context),Ia=void 0}}var Ja,Ga={create:za,update:za,destroy:function(e){return za(e,va)}};function Va(e,t){if(!s(e.data.domProps)||!s(t.data.domProps)){var n,r,a=t.elm,d=e.data.domProps||{},u=t.data.domProps||{};for(n in(i(u.__ob__)||o(u._v_attr_proxy))&&(u=t.data.domProps=O({},u)),d)n in u||(a[n]="");for(n in u){if(r=u[n],"textContent"===n||"innerHTML"===n){if(t.children&&(t.children.length=0),r===d[n])continue;1===a.childNodes.length&&a.removeChild(a.childNodes[0])}if("value"===n&&"PROGRESS"!==a.tagName){a._value=r;var l=s(r)?"":String(r);qa(a,l)&&(a.value=l)}else if("innerHTML"===n&&ma(a.tagName)&&s(a.innerHTML)){(Ja=Ja||document.createElement("div")).innerHTML="<svg>".concat(r,"</svg>");for(var c=Ja.firstChild;a.firstChild;)a.removeChild(a.firstChild);for(;c.firstChild;)a.appendChild(c.firstChild)}else if(r!==d[n])try{a[n]=r}catch(e){}}}}function qa(e,t){return!e.composing&&("OPTION"===e.tagName||function(e,t){var n=!0;try{n=document.activeElement!==e}catch(e){}return n&&e.value!==t}(e,t)||function(e,t){var n=e.value,r=e._vModifiers;if(i(r)){if(r.number)return M(n)!==M(t);if(r.trim)return n.trim()!==t.trim()}return n!==t}(e,t))}var Ka={create:Va,update:Va},Za=k((function(e){var t={},n=/:(.+)/;return e.split(/;(?![^(]*\))/g).forEach((function(e){if(e){var r=e.split(n);r.length>1&&(t[r[0].trim()]=r[1].trim())}})),t}));function Xa(e){var t=Qa(e.style);return e.staticStyle?O(e.staticStyle,t):t}function Qa(e){return Array.isArray(e)?A(e):"string"==typeof e?Za(e):e}var es,ts=/^--/,ns=/\s*!important$/,rs=function(e,t,n){if(ts.test(t))e.style.setProperty(t,n);else if(ns.test(n))e.style.setProperty(j(t),n.replace(ns,""),"important");else{var r=ss(t);if(Array.isArray(n))for(var a=0,s=n.length;a<s;a++)e.style[r]=n[a];else e.style[r]=n}},as=["Webkit","Moz","ms"],ss=k((function(e){if(es=es||document.createElement("div").style,"filter"!==(e=D(e))&&e in es)return e;for(var t=e.charAt(0).toUpperCase()+e.slice(1),n=0;n<as.length;n++){var r=as[n]+t;if(r in es)return r}}));function is(e,t){var n=t.data,r=e.data;if(!(s(n.staticStyle)&&s(n.style)&&s(r.staticStyle)&&s(r.style))){var a,o,d=t.elm,u=r.staticStyle,l=r.normalizedStyle||r.style||{},c=u||l,_=Qa(t.data.style)||{};t.data.normalizedStyle=i(_.__ob__)?O({},_):_;var m=function(e,t){var n,r={};if(t)for(var a=e;a.componentInstance;)(a=a.componentInstance._vnode)&&a.data&&(n=Xa(a.data))&&O(r,n);(n=Xa(e.data))&&O(r,n);for(var s=e;s=s.parent;)s.data&&(n=Xa(s.data))&&O(r,n);return r}(t,!0);for(o in c)s(m[o])&&rs(d,o,"");for(o in m)a=m[o],rs(d,o,null==a?"":a)}}var os={create:is,update:is},ds=/\s+/;function us(e,t){if(t&&(t=t.trim()))if(e.classList)t.indexOf(" ")>-1?t.split(ds).forEach((function(t){return e.classList.add(t)})):e.classList.add(t);else{var n=" ".concat(e.getAttribute("class")||""," ");n.indexOf(" "+t+" ")<0&&e.setAttribute("class",(n+t).trim())}}function ls(e,t){if(t&&(t=t.trim()))if(e.classList)t.indexOf(" ")>-1?t.split(ds).forEach((function(t){return e.classList.remove(t)})):e.classList.remove(t),e.classList.length||e.removeAttribute("class");else{for(var n=" ".concat(e.getAttribute("class")||""," "),r=" "+t+" ";n.indexOf(r)>=0;)n=n.replace(r," ");(n=n.trim())?e.setAttribute("class",n):e.removeAttribute("class")}}function cs(e){if(e){if("object"==typeof e){var t={};return!1!==e.css&&O(t,_s(e.name||"v")),O(t,e),t}return"string"==typeof e?_s(e):void 0}}var _s=k((function(e){return{enterClass:"".concat(e,"-enter"),enterToClass:"".concat(e,"-enter-to"),enterActiveClass:"".concat(e,"-enter-active"),leaveClass:"".concat(e,"-leave"),leaveToClass:"".concat(e,"-leave-to"),leaveActiveClass:"".concat(e,"-leave-active")}})),ms=K&&!Q,hs="transition",fs="animation",ps="transition",ys="transitionend",Ms="animation",gs="animationend";ms&&(void 0===window.ontransitionend&&void 0!==window.onwebkittransitionend&&(ps="WebkitTransition",ys="webkitTransitionEnd"),void 0===window.onanimationend&&void 0!==window.onwebkitanimationend&&(Ms="WebkitAnimation",gs="webkitAnimationEnd"));var Ls=K?window.requestAnimationFrame?window.requestAnimationFrame.bind(window):setTimeout:function(e){return e()};function vs(e){Ls((function(){Ls(e)}))}function Ys(e,t){var n=e._transitionClasses||(e._transitionClasses=[]);n.indexOf(t)<0&&(n.push(t),us(e,t))}function ws(e,t){e._transitionClasses&&v(e._transitionClasses,t),ls(e,t)}function ks(e,t,n){var r=Ds(e,t),a=r.type,s=r.timeout,i=r.propCount;if(!a)return n();var o=a===hs?ys:gs,d=0,u=function(){e.removeEventListener(o,l),n()},l=function(t){t.target===e&&++d>=i&&u()};setTimeout((function(){d<i&&u()}),s+1),e.addEventListener(o,l)}var bs=/\b(transform|all)(,|$)/;function Ds(e,t){var n,r=window.getComputedStyle(e),a=(r[ps+"Delay"]||"").split(", "),s=(r[ps+"Duration"]||"").split(", "),i=Ts(a,s),o=(r[Ms+"Delay"]||"").split(", "),d=(r[Ms+"Duration"]||"").split(", "),u=Ts(o,d),l=0,c=0;return t===hs?i>0&&(n=hs,l=i,c=s.length):t===fs?u>0&&(n=fs,l=u,c=d.length):c=(n=(l=Math.max(i,u))>0?i>u?hs:fs:null)?n===hs?s.length:d.length:0,{type:n,timeout:l,propCount:c,hasTransform:n===hs&&bs.test(r[ps+"Property"])}}function Ts(e,t){for(;e.length<t.length;)e=e.concat(e);return Math.max.apply(null,t.map((function(t,n){return Ss(t)+Ss(e[n])})))}function Ss(e){return 1e3*Number(e.slice(0,-1).replace(",","."))}function js(e,t){var n=e.elm;i(n._leaveCb)&&(n._leaveCb.cancelled=!0,n._leaveCb());var r=cs(e.data.transition);if(!s(r)&&!i(n._enterCb)&&1===n.nodeType){for(var a=r.css,o=r.type,d=r.enterClass,c=r.enterToClass,_=r.enterActiveClass,m=r.appearClass,h=r.appearToClass,f=r.appearActiveClass,p=r.beforeEnter,y=r.enter,g=r.afterEnter,L=r.enterCancelled,v=r.beforeAppear,Y=r.appear,w=r.afterAppear,k=r.appearCancelled,b=r.duration,D=Jn,T=Jn.$vnode;T&&T.parent;)D=T.context,T=T.parent;var S=!D._isMounted||!e.isRootInsert;if(!S||Y||""===Y){var j=S&&m?m:d,E=S&&f?f:_,x=S&&h?h:c,O=S&&v||p,A=S&&u(Y)?Y:y,H=S&&w||g,P=S&&k||L,C=M(l(b)?b.enter:b);0;var I=!1!==a&&!Q,R=Os(A),F=n._enterCb=N((function(){I&&(ws(n,x),ws(n,E)),F.cancelled?(I&&ws(n,j),P&&P(n)):H&&H(n),n._enterCb=null}));e.data.show||Tt(e,"insert",(function(){var t=n.parentNode,r=t&&t._pending&&t._pending[e.key];r&&r.tag===e.tag&&r.elm._leaveCb&&r.elm._leaveCb(),A&&A(n,F)})),O&&O(n),I&&(Ys(n,j),Ys(n,E),vs((function(){ws(n,j),F.cancelled||(Ys(n,x),R||(xs(C)?setTimeout(F,C):ks(n,o,F)))}))),e.data.show&&(t&&t(),A&&A(n,F)),I||R||F()}}}function Es(e,t){var n=e.elm;i(n._enterCb)&&(n._enterCb.cancelled=!0,n._enterCb());var r=cs(e.data.transition);if(s(r)||1!==n.nodeType)return t();if(!i(n._leaveCb)){var a=r.css,o=r.type,d=r.leaveClass,u=r.leaveToClass,c=r.leaveActiveClass,_=r.beforeLeave,m=r.leave,h=r.afterLeave,f=r.leaveCancelled,p=r.delayLeave,y=r.duration,g=!1!==a&&!Q,L=Os(m),v=M(l(y)?y.leave:y);0;var Y=n._leaveCb=N((function(){n.parentNode&&n.parentNode._pending&&(n.parentNode._pending[e.key]=null),g&&(ws(n,u),ws(n,c)),Y.cancelled?(g&&ws(n,d),f&&f(n)):(t(),h&&h(n)),n._leaveCb=null}));p?p(w):w()}function w(){Y.cancelled||(!e.data.show&&n.parentNode&&((n.parentNode._pending||(n.parentNode._pending={}))[e.key]=e),_&&_(n),g&&(Ys(n,d),Ys(n,c),vs((function(){ws(n,d),Y.cancelled||(Ys(n,u),L||(xs(v)?setTimeout(Y,v):ks(n,o,Y)))}))),m&&m(n,Y),g||L||Y())}}function xs(e){return"number"==typeof e&&!isNaN(e)}function Os(e){if(s(e))return!1;var t=e.fns;return i(t)?Os(Array.isArray(t)?t[0]:t):(e._length||e.length)>1}function As(e,t){!0!==t.data.show&&js(t)}var Hs=function(e){var t,n,r={},u=e.modules,l=e.nodeOps;for(t=0;t<Ya.length;++t)for(r[Ya[t]]=[],n=0;n<u.length;++n)i(u[n][Ya[t]])&&r[Ya[t]].push(u[n][Ya[t]]);function c(e){var t=l.parentNode(e);i(t)&&l.removeChild(t,e)}function _(e,t,n,a,s,d,u){if(i(e.elm)&&i(d)&&(e=d[u]=Me(e)),e.isRootInsert=!s,!function(e,t,n,a){var s=e.data;if(i(s)){var d=i(e.componentInstance)&&s.keepAlive;if(i(s=s.hook)&&i(s=s.init)&&s(e,!1),i(e.componentInstance))return m(e,t),h(n,e.elm,a),o(d)&&function(e,t,n,a){var s,o=e;for(;o.componentInstance;)if(i(s=(o=o.componentInstance._vnode).data)&&i(s=s.transition)){for(s=0;s<r.activate.length;++s)r.activate[s](va,o);t.push(o);break}h(n,e.elm,a)}(e,t,n,a),!0}}(e,t,n,a)){var c=e.data,_=e.children,p=e.tag;i(p)?(e.elm=e.ns?l.createElementNS(e.ns,p):l.createElement(p,e),M(e),f(e,_,t),i(c)&&y(e,t),h(n,e.elm,a)):o(e.isComment)?(e.elm=l.createComment(e.text),h(n,e.elm,a)):(e.elm=l.createTextNode(e.text),h(n,e.elm,a))}}function m(e,t){i(e.data.pendingInsert)&&(t.push.apply(t,e.data.pendingInsert),e.data.pendingInsert=null),e.elm=e.componentInstance.$el,p(e)?(y(e,t),M(e)):(ga(e),t.push(e))}function h(e,t,n){i(e)&&(i(n)?l.parentNode(n)===e&&l.insertBefore(e,t,n):l.appendChild(e,t))}function f(e,t,n){if(a(t)){0;for(var r=0;r<t.length;++r)_(t[r],n,e.elm,null,!0,t,r)}else d(e.text)&&l.appendChild(e.elm,l.createTextNode(String(e.text)))}function p(e){for(;e.componentInstance;)e=e.componentInstance._vnode;return i(e.tag)}function y(e,n){for(var a=0;a<r.create.length;++a)r.create[a](va,e);i(t=e.data.hook)&&(i(t.create)&&t.create(va,e),i(t.insert)&&n.push(e))}function M(e){var t;if(i(t=e.fnScopeId))l.setStyleScope(e.elm,t);else for(var n=e;n;)i(t=n.context)&&i(t=t.$options._scopeId)&&l.setStyleScope(e.elm,t),n=n.parent;i(t=Jn)&&t!==e.context&&t!==e.fnContext&&i(t=t.$options._scopeId)&&l.setStyleScope(e.elm,t)}function L(e,t,n,r,a,s){for(;r<=a;++r)_(n[r],s,e,t,!1,n,r)}function v(e){var t,n,a=e.data;if(i(a))for(i(t=a.hook)&&i(t=t.destroy)&&t(e),t=0;t<r.destroy.length;++t)r.destroy[t](e);if(i(t=e.children))for(n=0;n<e.children.length;++n)v(e.children[n])}function Y(e,t,n){for(;t<=n;++t){var r=e[t];i(r)&&(i(r.tag)?(w(r),v(r)):c(r.elm))}}function w(e,t){if(i(t)||i(e.data)){var n,a=r.remove.length+1;for(i(t)?t.listeners+=a:t=function(e,t){function n(){0==--n.listeners&&c(e)}return n.listeners=t,n}(e.elm,a),i(n=e.componentInstance)&&i(n=n._vnode)&&i(n.data)&&w(n,t),n=0;n<r.remove.length;++n)r.remove[n](e,t);i(n=e.data.hook)&&i(n=n.remove)?n(e,t):t()}else c(e.elm)}function k(e,t,n,r){for(var a=n;a<r;a++){var s=t[a];if(i(s)&&wa(e,s))return a}}function b(e,t,n,a,d,u){if(e!==t){i(t.elm)&&i(a)&&(t=a[d]=Me(t));var c=t.elm=e.elm;if(o(e.isAsyncPlaceholder))i(t.asyncFactory.resolved)?S(e.elm,t,n):t.isAsyncPlaceholder=!0;else if(o(t.isStatic)&&o(e.isStatic)&&t.key===e.key&&(o(t.isCloned)||o(t.isOnce)))t.componentInstance=e.componentInstance;else{var m,h=t.data;i(h)&&i(m=h.hook)&&i(m=m.prepatch)&&m(e,t);var f=e.children,y=t.children;if(i(h)&&p(t)){for(m=0;m<r.update.length;++m)r.update[m](e,t);i(m=h.hook)&&i(m=m.update)&&m(e,t)}s(t.text)?i(f)&&i(y)?f!==y&&function(e,t,n,r,a){var o,d,u,c=0,m=0,h=t.length-1,f=t[0],p=t[h],y=n.length-1,M=n[0],g=n[y],v=!a;for(;c<=h&&m<=y;)s(f)?f=t[++c]:s(p)?p=t[--h]:wa(f,M)?(b(f,M,r,n,m),f=t[++c],M=n[++m]):wa(p,g)?(b(p,g,r,n,y),p=t[--h],g=n[--y]):wa(f,g)?(b(f,g,r,n,y),v&&l.insertBefore(e,f.elm,l.nextSibling(p.elm)),f=t[++c],g=n[--y]):wa(p,M)?(b(p,M,r,n,m),v&&l.insertBefore(e,p.elm,f.elm),p=t[--h],M=n[++m]):(s(o)&&(o=ka(t,c,h)),s(d=i(M.key)?o[M.key]:k(M,t,c,h))?_(M,r,e,f.elm,!1,n,m):wa(u=t[d],M)?(b(u,M,r,n,m),t[d]=void 0,v&&l.insertBefore(e,u.elm,f.elm)):_(M,r,e,f.elm,!1,n,m),M=n[++m]);c>h?L(e,s(n[y+1])?null:n[y+1].elm,n,m,y,r):m>y&&Y(t,c,h)}(c,f,y,n,u):i(y)?(i(e.text)&&l.setTextContent(c,""),L(c,null,y,0,y.length-1,n)):i(f)?Y(f,0,f.length-1):i(e.text)&&l.setTextContent(c,""):e.text!==t.text&&l.setTextContent(c,t.text),i(h)&&i(m=h.hook)&&i(m=m.postpatch)&&m(e,t)}}}function D(e,t,n){if(o(n)&&i(e.parent))e.parent.data.pendingInsert=t;else for(var r=0;r<t.length;++r)t[r].data.hook.insert(t[r])}var T=g("attrs,class,staticClass,staticStyle,key");function S(e,t,n,r){var a,s=t.tag,d=t.data,u=t.children;if(r=r||d&&d.pre,t.elm=e,o(t.isComment)&&i(t.asyncFactory))return t.isAsyncPlaceholder=!0,!0;if(i(d)&&(i(a=d.hook)&&i(a=a.init)&&a(t,!0),i(a=t.componentInstance)))return m(t,n),!0;if(i(s)){if(i(u))if(e.hasChildNodes())if(i(a=d)&&i(a=a.domProps)&&i(a=a.innerHTML)){if(a!==e.innerHTML)return!1}else{for(var l=!0,c=e.firstChild,_=0;_<u.length;_++){if(!c||!S(c,u[_],n,r)){l=!1;break}c=c.nextSibling}if(!l||c)return!1}else f(t,u,n);if(i(d)){var h=!1;for(var p in d)if(!T(p)){h=!0,y(t,n);break}!h&&d.class&&In(d.class)}}else e.data!==t.text&&(e.data=t.text);return!0}return function(e,t,n,a){if(!s(t)){var d,u=!1,c=[];if(s(e))u=!0,_(t,c);else{var m=i(e.nodeType);if(!m&&wa(e,t))b(e,t,c,null,null,a);else{if(m){if(1===e.nodeType&&e.hasAttribute(W)&&(e.removeAttribute(W),n=!0),o(n)&&S(e,t,c))return D(t,c,!0),e;d=e,e=new fe(l.tagName(d).toLowerCase(),{},[],void 0,d)}var h=e.elm,f=l.parentNode(h);if(_(t,c,h._leaveCb?null:f,l.nextSibling(h)),i(t.parent))for(var y=t.parent,M=p(t);y;){for(var g=0;g<r.destroy.length;++g)r.destroy[g](y);if(y.elm=t.elm,M){for(var L=0;L<r.create.length;++L)r.create[L](va,y);var w=y.data.hook.insert;if(w.merged)for(var k=w.fns.slice(1),T=0;T<k.length;T++)k[T]()}else ga(y);y=y.parent}i(f)?Y([e],0,0):i(e.tag)&&v(e)}}return D(t,c,u),t.elm}i(e)&&v(e)}}({nodeOps:ya,modules:[Pa,Ra,Ga,Ka,os,K?{create:As,activate:As,remove:function(e,t){!0!==e.data.show?Es(e,t):t()}}:{}].concat(xa)});Q&&document.addEventListener("selectionchange",(function(){var e=document.activeElement;e&&e.vmodel&&$s(e,"input")}));var Ps={inserted:function(e,t,n,r){"select"===n.tag?(r.elm&&!r.elm._vOptions?Tt(n,"postpatch",(function(){Ps.componentUpdated(e,t,n)})):Cs(e,t,n.context),e._vOptions=[].map.call(e.options,Ns)):("textarea"===n.tag||pa(e.type))&&(e._vModifiers=t.modifiers,t.modifiers.lazy||(e.addEventListener("compositionstart",Fs),e.addEventListener("compositionend",Ws),e.addEventListener("change",Ws),Q&&(e.vmodel=!0)))},componentUpdated:function(e,t,n){if("select"===n.tag){Cs(e,t,n.context);var r=e._vOptions,a=e._vOptions=[].map.call(e.options,Ns);if(a.some((function(e,t){return!I(e,r[t])})))(e.multiple?t.value.some((function(e){return Rs(e,a)})):t.value!==t.oldValue&&Rs(t.value,a))&&$s(e,"change")}}};function Cs(e,t,n){Is(e,t,n),(X||ee)&&setTimeout((function(){Is(e,t,n)}),0)}function Is(e,t,n){var r=t.value,a=e.multiple;if(!a||Array.isArray(r)){for(var s,i,o=0,d=e.options.length;o<d;o++)if(i=e.options[o],a)s=R(r,Ns(i))>-1,i.selected!==s&&(i.selected=s);else if(I(Ns(i),r))return void(e.selectedIndex!==o&&(e.selectedIndex=o));a||(e.selectedIndex=-1)}}function Rs(e,t){return t.every((function(t){return!I(t,e)}))}function Ns(e){return"_value"in e?e._value:e.value}function Fs(e){e.target.composing=!0}function Ws(e){e.target.composing&&(e.target.composing=!1,$s(e.target,"input"))}function $s(e,t){var n=document.createEvent("HTMLEvents");n.initEvent(t,!0,!0),e.dispatchEvent(n)}function Us(e){return!e.componentInstance||e.data&&e.data.transition?e:Us(e.componentInstance._vnode)}var Bs={bind:function(e,t,n){var r=t.value,a=(n=Us(n)).data&&n.data.transition,s=e.__vOriginalDisplay="none"===e.style.display?"":e.style.display;r&&a?(n.data.show=!0,js(n,(function(){e.style.display=s}))):e.style.display=r?s:"none"},update:function(e,t,n){var r=t.value;!r!=!t.oldValue&&((n=Us(n)).data&&n.data.transition?(n.data.show=!0,r?js(n,(function(){e.style.display=e.__vOriginalDisplay})):Es(n,(function(){e.style.display="none"}))):e.style.display=r?e.__vOriginalDisplay:"none")},unbind:function(e,t,n,r,a){a||(e.style.display=e.__vOriginalDisplay)}},zs={model:Ps,show:Bs},Js={name:String,appear:Boolean,css:Boolean,mode:String,type:String,enterClass:String,leaveClass:String,enterToClass:String,leaveToClass:String,enterActiveClass:String,leaveActiveClass:String,appearClass:String,appearActiveClass:String,appearToClass:String,duration:[Number,String,Object]};function Gs(e){var t=e&&e.componentOptions;return t&&t.Ctor.options.abstract?Gs(dn(t.children)):e}function Vs(e){var t={},n=e.$options;for(var r in n.propsData)t[r]=e[r];var a=n._parentListeners;for(var r in a)t[D(r)]=a[r];return t}function qs(e,t){if(/\d-keep-alive$/.test(t.tag))return e("keep-alive",{props:t.componentOptions.propsData})}var Ks=function(e){return e.tag||qt(e)},Zs=function(e){return"show"===e.name},Xs={name:"transition",props:Js,abstract:!0,render:function(e){var t=this,n=this.$slots.default;if(n&&(n=n.filter(Ks)).length){0;var r=this.mode;0;var a=n[0];if(function(e){for(;e=e.parent;)if(e.data.transition)return!0}(this.$vnode))return a;var s=Gs(a);if(!s)return a;if(this._leaving)return qs(e,a);var i="__transition-".concat(this._uid,"-");s.key=null==s.key?s.isComment?i+"comment":i+s.tag:d(s.key)?0===String(s.key).indexOf(i)?s.key:i+s.key:s.key;var o=(s.data||(s.data={})).transition=Vs(this),u=this._vnode,l=Gs(u);if(s.data.directives&&s.data.directives.some(Zs)&&(s.data.show=!0),l&&l.data&&!function(e,t){return t.key===e.key&&t.tag===e.tag}(s,l)&&!qt(l)&&(!l.componentInstance||!l.componentInstance._vnode.isComment)){var c=l.data.transition=O({},o);if("out-in"===r)return this._leaving=!0,Tt(c,"afterLeave",(function(){t._leaving=!1,t.$forceUpdate()})),qs(e,a);if("in-out"===r){if(qt(s))return u;var _,m=function(){_()};Tt(o,"afterEnter",m),Tt(o,"enterCancelled",m),Tt(c,"delayLeave",(function(e){_=e}))}}return a}}},Qs=O({tag:String,moveClass:String},Js);delete Qs.mode;var ei={props:Qs,beforeMount:function(){var e=this,t=this._update;this._update=function(n,r){var a=Gn(e);e.__patch__(e._vnode,e.kept,!1,!0),e._vnode=e.kept,a(),t.call(e,n,r)}},render:function(e){for(var t=this.tag||this.$vnode.data.tag||"span",n=Object.create(null),r=this.prevChildren=this.children,a=this.$slots.default||[],s=this.children=[],i=Vs(this),o=0;o<a.length;o++){if((l=a[o]).tag)if(null!=l.key&&0!==String(l.key).indexOf("__vlist"))s.push(l),n[l.key]=l,(l.data||(l.data={})).transition=i;else;}if(r){var d=[],u=[];for(o=0;o<r.length;o++){var l;(l=r[o]).data.transition=i,l.data.pos=l.elm.getBoundingClientRect(),n[l.key]?d.push(l):u.push(l)}this.kept=e(t,null,d),this.removed=u}return e(t,null,s)},updated:function(){var e=this.prevChildren,t=this.moveClass||(this.name||"v")+"-move";e.length&&this.hasMove(e[0].elm,t)&&(e.forEach(ti),e.forEach(ni),e.forEach(ri),this._reflow=document.body.offsetHeight,e.forEach((function(e){if(e.data.moved){var n=e.elm,r=n.style;Ys(n,t),r.transform=r.WebkitTransform=r.transitionDuration="",n.addEventListener(ys,n._moveCb=function e(r){r&&r.target!==n||r&&!/transform$/.test(r.propertyName)||(n.removeEventListener(ys,e),n._moveCb=null,ws(n,t))})}})))},methods:{hasMove:function(e,t){if(!ms)return!1;if(this._hasMove)return this._hasMove;var n=e.cloneNode();e._transitionClasses&&e._transitionClasses.forEach((function(e){ls(n,e)})),us(n,t),n.style.display="none",this.$el.appendChild(n);var r=Ds(n);return this.$el.removeChild(n),this._hasMove=r.hasTransform}}};function ti(e){e.elm._moveCb&&e.elm._moveCb(),e.elm._enterCb&&e.elm._enterCb()}function ni(e){e.data.newPos=e.elm.getBoundingClientRect()}function ri(e){var t=e.data.pos,n=e.data.newPos,r=t.left-n.left,a=t.top-n.top;if(r||a){e.data.moved=!0;var s=e.elm.style;s.transform=s.WebkitTransform="translate(".concat(r,"px,").concat(a,"px)"),s.transitionDuration="0s"}}var ai={Transition:Xs,TransitionGroup:ei};Ur.config.mustUseProp=function(e,t,n){return"value"===n&&Xr(e)&&"button"!==t||"selected"===n&&"option"===e||"checked"===n&&"input"===e||"muted"===n&&"video"===e},Ur.config.isReservedTag=ha,Ur.config.isReservedAttr=Zr,Ur.config.getTagNamespace=function(e){return ma(e)?"svg":"math"===e?"math":void 0},Ur.config.isUnknownElement=function(e){if(!K)return!0;if(ha(e))return!1;if(e=e.toLowerCase(),null!=fa[e])return fa[e];var t=document.createElement(e);return e.indexOf("-")>-1?fa[e]=t.constructor===window.HTMLUnknownElement||t.constructor===window.HTMLElement:fa[e]=/HTMLUnknownElement/.test(t.toString())},O(Ur.options.directives,zs),O(Ur.options.components,ai),Ur.prototype.__patch__=K?Hs:H,Ur.prototype.$mount=function(e,t){return function(e,t,n){var r;e.$el=t,e.$options.render||(e.$options.render=pe),Zn(e,"beforeMount"),r=function(){e._update(e._render(),n)},new Wn(e,r,H,{before:function(){e._isMounted&&!e._isDestroyed&&Zn(e,"beforeUpdate")}},!0),n=!1;var a=e._preWatchers;if(a)for(var s=0;s<a.length;s++)a[s].run();return null==e.$vnode&&(e._isMounted=!0,Zn(e,"mounted")),e}(this,e=e&&K?function(e){if("string"==typeof e){return document.querySelector(e)||document.createElement("div")}return e}(e):void 0,t)},K&&setTimeout((function(){B.devtools&&de&&de.emit("init",Ur)}),0)},95353:(e,t,n)=>{"use strict";n.d(t,{L8:()=>w,aH:()=>v,default:()=>O,i0:()=>k});var r=("undefined"!=typeof window?window:void 0!==n.g?n.g:{}).__VUE_DEVTOOLS_GLOBAL_HOOK__;function a(e,t){if(void 0===t&&(t=[]),null===e||"object"!=typeof e)return e;var n,r=(n=function(t){return t.original===e},t.filter(n)[0]);if(r)return r.copy;var s=Array.isArray(e)?[]:{};return t.push({original:e,copy:s}),Object.keys(e).forEach((function(n){s[n]=a(e[n],t)})),s}function s(e,t){Object.keys(e).forEach((function(n){return t(e[n],n)}))}function i(e){return null!==e&&"object"==typeof e}var o=function(e,t){this.runtime=t,this._children=Object.create(null),this._rawModule=e;var n=e.state;this.state=("function"==typeof n?n():n)||{}},d={namespaced:{configurable:!0}};d.namespaced.get=function(){return!!this._rawModule.namespaced},o.prototype.addChild=function(e,t){this._children[e]=t},o.prototype.removeChild=function(e){delete this._children[e]},o.prototype.getChild=function(e){return this._children[e]},o.prototype.hasChild=function(e){return e in this._children},o.prototype.update=function(e){this._rawModule.namespaced=e.namespaced,e.actions&&(this._rawModule.actions=e.actions),e.mutations&&(this._rawModule.mutations=e.mutations),e.getters&&(this._rawModule.getters=e.getters)},o.prototype.forEachChild=function(e){s(this._children,e)},o.prototype.forEachGetter=function(e){this._rawModule.getters&&s(this._rawModule.getters,e)},o.prototype.forEachAction=function(e){this._rawModule.actions&&s(this._rawModule.actions,e)},o.prototype.forEachMutation=function(e){this._rawModule.mutations&&s(this._rawModule.mutations,e)},Object.defineProperties(o.prototype,d);var u=function(e){this.register([],e,!1)};function l(e,t,n){if(t.update(n),n.modules)for(var r in n.modules){if(!t.getChild(r))return void 0;l(e.concat(r),t.getChild(r),n.modules[r])}}u.prototype.get=function(e){return e.reduce((function(e,t){return e.getChild(t)}),this.root)},u.prototype.getNamespace=function(e){var t=this.root;return e.reduce((function(e,n){return e+((t=t.getChild(n)).namespaced?n+"/":"")}),"")},u.prototype.update=function(e){l([],this.root,e)},u.prototype.register=function(e,t,n){var r=this;void 0===n&&(n=!0);var a=new o(t,n);0===e.length?this.root=a:this.get(e.slice(0,-1)).addChild(e[e.length-1],a);t.modules&&s(t.modules,(function(t,a){r.register(e.concat(a),t,n)}))},u.prototype.unregister=function(e){var t=this.get(e.slice(0,-1)),n=e[e.length-1],r=t.getChild(n);r&&r.runtime&&t.removeChild(n)},u.prototype.isRegistered=function(e){var t=this.get(e.slice(0,-1)),n=e[e.length-1];return!!t&&t.hasChild(n)};var c;var _=function(e){var t=this;void 0===e&&(e={}),!c&&"undefined"!=typeof window&&window.Vue&&L(window.Vue);var n=e.plugins;void 0===n&&(n=[]);var a=e.strict;void 0===a&&(a=!1),this._committing=!1,this._actions=Object.create(null),this._actionSubscribers=[],this._mutations=Object.create(null),this._wrappedGetters=Object.create(null),this._modules=new u(e),this._modulesNamespaceMap=Object.create(null),this._subscribers=[],this._watcherVM=new c,this._makeLocalGettersCache=Object.create(null);var s=this,i=this.dispatch,o=this.commit;this.dispatch=function(e,t){return i.call(s,e,t)},this.commit=function(e,t,n){return o.call(s,e,t,n)},this.strict=a;var d=this._modules.root.state;y(this,d,[],this._modules.root),p(this,d),n.forEach((function(e){return e(t)})),(void 0!==e.devtools?e.devtools:c.config.devtools)&&function(e){r&&(e._devtoolHook=r,r.emit("vuex:init",e),r.on("vuex:travel-to-state",(function(t){e.replaceState(t)})),e.subscribe((function(e,t){r.emit("vuex:mutation",e,t)}),{prepend:!0}),e.subscribeAction((function(e,t){r.emit("vuex:action",e,t)}),{prepend:!0}))}(this)},m={state:{configurable:!0}};function h(e,t,n){return t.indexOf(e)<0&&(n&&n.prepend?t.unshift(e):t.push(e)),function(){var n=t.indexOf(e);n>-1&&t.splice(n,1)}}function f(e,t){e._actions=Object.create(null),e._mutations=Object.create(null),e._wrappedGetters=Object.create(null),e._modulesNamespaceMap=Object.create(null);var n=e.state;y(e,n,[],e._modules.root,!0),p(e,n,t)}function p(e,t,n){var r=e._vm;e.getters={},e._makeLocalGettersCache=Object.create(null);var a=e._wrappedGetters,i={};s(a,(function(t,n){i[n]=function(e,t){return function(){return e(t)}}(t,e),Object.defineProperty(e.getters,n,{get:function(){return e._vm[n]},enumerable:!0})}));var o=c.config.silent;c.config.silent=!0,e._vm=new c({data:{$$state:t},computed:i}),c.config.silent=o,e.strict&&function(e){e._vm.$watch((function(){return this._data.$$state}),(function(){0}),{deep:!0,sync:!0})}(e),r&&(n&&e._withCommit((function(){r._data.$$state=null})),c.nextTick((function(){return r.$destroy()})))}function y(e,t,n,r,a){var s=!n.length,i=e._modules.getNamespace(n);if(r.namespaced&&(e._modulesNamespaceMap[i],e._modulesNamespaceMap[i]=r),!s&&!a){var o=M(t,n.slice(0,-1)),d=n[n.length-1];e._withCommit((function(){c.set(o,d,r.state)}))}var u=r.context=function(e,t,n){var r=""===t,a={dispatch:r?e.dispatch:function(n,r,a){var s=g(n,r,a),i=s.payload,o=s.options,d=s.type;return o&&o.root||(d=t+d),e.dispatch(d,i)},commit:r?e.commit:function(n,r,a){var s=g(n,r,a),i=s.payload,o=s.options,d=s.type;o&&o.root||(d=t+d),e.commit(d,i,o)}};return Object.defineProperties(a,{getters:{get:r?function(){return e.getters}:function(){return function(e,t){if(!e._makeLocalGettersCache[t]){var n={},r=t.length;Object.keys(e.getters).forEach((function(a){if(a.slice(0,r)===t){var s=a.slice(r);Object.defineProperty(n,s,{get:function(){return e.getters[a]},enumerable:!0})}})),e._makeLocalGettersCache[t]=n}return e._makeLocalGettersCache[t]}(e,t)}},state:{get:function(){return M(e.state,n)}}}),a}(e,i,n);r.forEachMutation((function(t,n){!function(e,t,n,r){var a=e._mutations[t]||(e._mutations[t]=[]);a.push((function(t){n.call(e,r.state,t)}))}(e,i+n,t,u)})),r.forEachAction((function(t,n){var r=t.root?n:i+n,a=t.handler||t;!function(e,t,n,r){var a=e._actions[t]||(e._actions[t]=[]);a.push((function(t){var a,s=n.call(e,{dispatch:r.dispatch,commit:r.commit,getters:r.getters,state:r.state,rootGetters:e.getters,rootState:e.state},t);return(a=s)&&"function"==typeof a.then||(s=Promise.resolve(s)),e._devtoolHook?s.catch((function(t){throw e._devtoolHook.emit("vuex:error",t),t})):s}))}(e,r,a,u)})),r.forEachGetter((function(t,n){!function(e,t,n,r){if(e._wrappedGetters[t])return void 0;e._wrappedGetters[t]=function(e){return n(r.state,r.getters,e.state,e.getters)}}(e,i+n,t,u)})),r.forEachChild((function(r,s){y(e,t,n.concat(s),r,a)}))}function M(e,t){return t.reduce((function(e,t){return e[t]}),e)}function g(e,t,n){return i(e)&&e.type&&(n=t,t=e,e=e.type),{type:e,payload:t,options:n}}function L(e){c&&e===c||function(e){if(Number(e.version.split(".")[0])>=2)e.mixin({beforeCreate:n});else{var t=e.prototype._init;e.prototype._init=function(e){void 0===e&&(e={}),e.init=e.init?[n].concat(e.init):n,t.call(this,e)}}function n(){var e=this.$options;e.store?this.$store="function"==typeof e.store?e.store():e.store:e.parent&&e.parent.$store&&(this.$store=e.parent.$store)}}(c=e)}m.state.get=function(){return this._vm._data.$$state},m.state.set=function(e){0},_.prototype.commit=function(e,t,n){var r=this,a=g(e,t,n),s=a.type,i=a.payload,o=(a.options,{type:s,payload:i}),d=this._mutations[s];d&&(this._withCommit((function(){d.forEach((function(e){e(i)}))})),this._subscribers.slice().forEach((function(e){return e(o,r.state)})))},_.prototype.dispatch=function(e,t){var n=this,r=g(e,t),a=r.type,s=r.payload,i={type:a,payload:s},o=this._actions[a];if(o){try{this._actionSubscribers.slice().filter((function(e){return e.before})).forEach((function(e){return e.before(i,n.state)}))}catch(e){0}var d=o.length>1?Promise.all(o.map((function(e){return e(s)}))):o[0](s);return new Promise((function(e,t){d.then((function(t){try{n._actionSubscribers.filter((function(e){return e.after})).forEach((function(e){return e.after(i,n.state)}))}catch(e){0}e(t)}),(function(e){try{n._actionSubscribers.filter((function(e){return e.error})).forEach((function(t){return t.error(i,n.state,e)}))}catch(e){0}t(e)}))}))}},_.prototype.subscribe=function(e,t){return h(e,this._subscribers,t)},_.prototype.subscribeAction=function(e,t){return h("function"==typeof e?{before:e}:e,this._actionSubscribers,t)},_.prototype.watch=function(e,t,n){var r=this;return this._watcherVM.$watch((function(){return e(r.state,r.getters)}),t,n)},_.prototype.replaceState=function(e){var t=this;this._withCommit((function(){t._vm._data.$$state=e}))},_.prototype.registerModule=function(e,t,n){void 0===n&&(n={}),"string"==typeof e&&(e=[e]),this._modules.register(e,t),y(this,this.state,e,this._modules.get(e),n.preserveState),p(this,this.state)},_.prototype.unregisterModule=function(e){var t=this;"string"==typeof e&&(e=[e]),this._modules.unregister(e),this._withCommit((function(){var n=M(t.state,e.slice(0,-1));c.delete(n,e[e.length-1])})),f(this)},_.prototype.hasModule=function(e){return"string"==typeof e&&(e=[e]),this._modules.isRegistered(e)},_.prototype.hotUpdate=function(e){this._modules.update(e),f(this,!0)},_.prototype._withCommit=function(e){var t=this._committing;this._committing=!0,e(),this._committing=t},Object.defineProperties(_.prototype,m);var v=D((function(e,t){var n={};return b(t).forEach((function(t){var r=t.key,a=t.val;n[r]=function(){var t=this.$store.state,n=this.$store.getters;if(e){var r=T(this.$store,"mapState",e);if(!r)return;t=r.context.state,n=r.context.getters}return"function"==typeof a?a.call(this,t,n):t[a]},n[r].vuex=!0})),n})),Y=D((function(e,t){var n={};return b(t).forEach((function(t){var r=t.key,a=t.val;n[r]=function(){for(var t=[],n=arguments.length;n--;)t[n]=arguments[n];var r=this.$store.commit;if(e){var s=T(this.$store,"mapMutations",e);if(!s)return;r=s.context.commit}return"function"==typeof a?a.apply(this,[r].concat(t)):r.apply(this.$store,[a].concat(t))}})),n})),w=D((function(e,t){var n={};return b(t).forEach((function(t){var r=t.key,a=t.val;a=e+a,n[r]=function(){if(!e||T(this.$store,"mapGetters",e))return this.$store.getters[a]},n[r].vuex=!0})),n})),k=D((function(e,t){var n={};return b(t).forEach((function(t){var r=t.key,a=t.val;n[r]=function(){for(var t=[],n=arguments.length;n--;)t[n]=arguments[n];var r=this.$store.dispatch;if(e){var s=T(this.$store,"mapActions",e);if(!s)return;r=s.context.dispatch}return"function"==typeof a?a.apply(this,[r].concat(t)):r.apply(this.$store,[a].concat(t))}})),n}));function b(e){return function(e){return Array.isArray(e)||i(e)}(e)?Array.isArray(e)?e.map((function(e){return{key:e,val:e}})):Object.keys(e).map((function(t){return{key:t,val:e[t]}})):[]}function D(e){return function(t,n){return"string"!=typeof t?(n=t,t=""):"/"!==t.charAt(t.length-1)&&(t+="/"),e(t,n)}}function T(e,t,n){return e._modulesNamespaceMap[n]}function S(e,t,n){var r=n?e.groupCollapsed:e.group;try{r.call(e,t)}catch(n){e.log(t)}}function j(e){try{e.groupEnd()}catch(t){e.log("—— log end ——")}}function E(){var e=new Date;return" @ "+x(e.getHours(),2)+":"+x(e.getMinutes(),2)+":"+x(e.getSeconds(),2)+"."+x(e.getMilliseconds(),3)}function x(e,t){return n="0",r=t-e.toString().length,new Array(r+1).join(n)+e;var n,r}const O={Store:_,install:L,version:"3.6.2",mapState:v,mapMutations:Y,mapGetters:w,mapActions:k,createNamespacedHelpers:function(e){return{mapState:v.bind(null,e),mapGetters:w.bind(null,e),mapMutations:Y.bind(null,e),mapActions:k.bind(null,e)}},createLogger:function(e){void 0===e&&(e={});var t=e.collapsed;void 0===t&&(t=!0);var n=e.filter;void 0===n&&(n=function(e,t,n){return!0});var r=e.transformer;void 0===r&&(r=function(e){return e});var s=e.mutationTransformer;void 0===s&&(s=function(e){return e});var i=e.actionFilter;void 0===i&&(i=function(e,t){return!0});var o=e.actionTransformer;void 0===o&&(o=function(e){return e});var d=e.logMutations;void 0===d&&(d=!0);var u=e.logActions;void 0===u&&(u=!0);var l=e.logger;return void 0===l&&(l=console),function(e){var c=a(e.state);void 0!==l&&(d&&e.subscribe((function(e,i){var o=a(i);if(n(e,c,o)){var d=E(),u=s(e),_="mutation "+e.type+d;S(l,_,t),l.log("%c prev state","color: #9E9E9E; font-weight: bold",r(c)),l.log("%c mutation","color: #03A9F4; font-weight: bold",u),l.log("%c next state","color: #4CAF50; font-weight: bold",r(o)),j(l)}c=o})),u&&e.subscribeAction((function(e,n){if(i(e,n)){var r=E(),a=o(e),s="action "+e.type+r;S(l,s,t),l.log("%c action","color: #03A9F4; font-weight: bold",a),j(l)}})))}}}},21777:(e,t,n)=>{"use strict";n.d(t,{HW:()=>y,L$:()=>h,do:()=>o,zo:()=>d});var r=n(61338),a=n(42458);let s;const i=[];function o(){return void 0===s&&(s=document.head.dataset.requesttoken??null),s}function d(e){i.push(e)}(0,r.B1)("csrf-token-update",(e=>{s=e.token,i.forEach((e=>{try{e(s)}catch(e){console.error("Error updating CSRF token observer",e)}}))}));const u=(0,a.getBuilder)("public").persist().build();class l{_displayName;uid;isAdmin;constructor(){u.getItem("guestUid")||u.setItem("guestUid",f()),this._displayName=u.getItem("guestNickname")||"",this.uid=u.getItem("guestUid")||f(),this.isAdmin=!1,(0,r.B1)("user:info:changed",(e=>{this._displayName=e.displayName,u.setItem("guestNickname",e.displayName||"")}))}get displayName(){return this._displayName}set displayName(e){this._displayName=e,u.setItem("guestNickname",e),(0,r.Ic)("user:info:changed",this)}}let c,_;function m(){return c||(c=new l),c}function h(e){if(!e||0===e.trim().length)throw new Error("Nickname cannot be empty");m().displayName=e}function f(){return globalThis.crypto?.randomUUID?globalThis.crypto.randomUUID():"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,(e=>{const t=16*Math.random()|0;return("x"===e?t:3&t|8).toString(16)}))}function p(e,t){return e?e.getAttribute(t):null}function y(){if(void 0!==_)return _;const e=document?.getElementsByTagName("head")[0];if(!e)return null;const t=p(e,"data-user");return null===t?(_=null,_):(_={uid:t,displayName:p(e,"data-user-displayname"),isAdmin:!!window._oc_isadmin},_)}},66802:(e,t,n)=>{"use strict";n.d(t,{Ay:()=>Bt});var r={};n.r(r),n.d(r,{hasBrowserEnv:()=>pe,hasStandardBrowserEnv:()=>Me,hasStandardBrowserWebWorkerEnv:()=>ge,navigator:()=>ye,origin:()=>Le});var a=n(21777);function s(e,t){return function(){return e.apply(t,arguments)}}var i=n(65606);const{toString:o}=Object.prototype,{getPrototypeOf:d}=Object,{iterator:u,toStringTag:l}=Symbol,c=(_=Object.create(null),e=>{const t=o.call(e);return _[t]||(_[t]=t.slice(8,-1).toLowerCase())});var _;const m=e=>(e=e.toLowerCase(),t=>c(t)===e),h=e=>t=>typeof t===e,{isArray:f}=Array,p=h("undefined");function y(e){return null!==e&&!p(e)&&null!==e.constructor&&!p(e.constructor)&&L(e.constructor.isBuffer)&&e.constructor.isBuffer(e)}const M=m("ArrayBuffer");const g=h("string"),L=h("function"),v=h("number"),Y=e=>null!==e&&"object"==typeof e,w=e=>{if("object"!==c(e))return!1;const t=d(e);return!(null!==t&&t!==Object.prototype&&null!==Object.getPrototypeOf(t)||l in e||u in e)},k=m("Date"),b=m("File"),D=m("Blob"),T=m("FileList"),S=m("URLSearchParams"),[j,E,x,O]=["ReadableStream","Request","Response","Headers"].map(m);function A(e,t,{allOwnKeys:n=!1}={}){if(null==e)return;let r,a;if("object"!=typeof e&&(e=[e]),f(e))for(r=0,a=e.length;r<a;r++)t.call(null,e[r],r,e);else{if(y(e))return;const a=n?Object.getOwnPropertyNames(e):Object.keys(e),s=a.length;let i;for(r=0;r<s;r++)i=a[r],t.call(null,e[i],i,e)}}function H(e,t){if(y(e))return null;t=t.toLowerCase();const n=Object.keys(e);let r,a=n.length;for(;a-- >0;)if(r=n[a],t===r.toLowerCase())return r;return null}const P="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self?self:"undefined"!=typeof window?window:global,C=e=>!p(e)&&e!==P;const I=(R="undefined"!=typeof Uint8Array&&d(Uint8Array),e=>R&&e instanceof R);var R;const N=m("HTMLFormElement"),F=(({hasOwnProperty:e})=>(t,n)=>e.call(t,n))(Object.prototype),W=m("RegExp"),$=(e,t)=>{const n=Object.getOwnPropertyDescriptors(e),r={};A(n,((n,a)=>{let s;!1!==(s=t(n,a,e))&&(r[a]=s||n)})),Object.defineProperties(e,r)};const U=m("AsyncFunction"),B=(z="function"==typeof setImmediate,J=L(P.postMessage),z?setImmediate:J?(G=`axios@${Math.random()}`,V=[],P.addEventListener("message",(({source:e,data:t})=>{e===P&&t===G&&V.length&&V.shift()()}),!1),e=>{V.push(e),P.postMessage(G,"*")}):e=>setTimeout(e));var z,J,G,V;const q="undefined"!=typeof queueMicrotask?queueMicrotask.bind(P):void 0!==i&&i.nextTick||B,K={isArray:f,isArrayBuffer:M,isBuffer:y,isFormData:e=>{let t;return e&&("function"==typeof FormData&&e instanceof FormData||L(e.append)&&("formdata"===(t=c(e))||"object"===t&&L(e.toString)&&"[object FormData]"===e.toString()))},isArrayBufferView:function(e){let t;return t="undefined"!=typeof ArrayBuffer&&ArrayBuffer.isView?ArrayBuffer.isView(e):e&&e.buffer&&M(e.buffer),t},isString:g,isNumber:v,isBoolean:e=>!0===e||!1===e,isObject:Y,isPlainObject:w,isEmptyObject:e=>{if(!Y(e)||y(e))return!1;try{return 0===Object.keys(e).length&&Object.getPrototypeOf(e)===Object.prototype}catch(e){return!1}},isReadableStream:j,isRequest:E,isResponse:x,isHeaders:O,isUndefined:p,isDate:k,isFile:b,isBlob:D,isRegExp:W,isFunction:L,isStream:e=>Y(e)&&L(e.pipe),isURLSearchParams:S,isTypedArray:I,isFileList:T,forEach:A,merge:function e(){const{caseless:t,skipUndefined:n}=C(this)&&this||{},r={},a=(a,s)=>{const i=t&&H(r,s)||s;w(r[i])&&w(a)?r[i]=e(r[i],a):w(a)?r[i]=e({},a):f(a)?r[i]=a.slice():n&&p(a)||(r[i]=a)};for(let e=0,t=arguments.length;e<t;e++)arguments[e]&&A(arguments[e],a);return r},extend:(e,t,n,{allOwnKeys:r}={})=>(A(t,((t,r)=>{n&&L(t)?e[r]=s(t,n):e[r]=t}),{allOwnKeys:r}),e),trim:e=>e.trim?e.trim():e.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,""),stripBOM:e=>(65279===e.charCodeAt(0)&&(e=e.slice(1)),e),inherits:(e,t,n,r)=>{e.prototype=Object.create(t.prototype,r),e.prototype.constructor=e,Object.defineProperty(e,"super",{value:t.prototype}),n&&Object.assign(e.prototype,n)},toFlatObject:(e,t,n,r)=>{let a,s,i;const o={};if(t=t||{},null==e)return t;do{for(a=Object.getOwnPropertyNames(e),s=a.length;s-- >0;)i=a[s],r&&!r(i,e,t)||o[i]||(t[i]=e[i],o[i]=!0);e=!1!==n&&d(e)}while(e&&(!n||n(e,t))&&e!==Object.prototype);return t},kindOf:c,kindOfTest:m,endsWith:(e,t,n)=>{e=String(e),(void 0===n||n>e.length)&&(n=e.length),n-=t.length;const r=e.indexOf(t,n);return-1!==r&&r===n},toArray:e=>{if(!e)return null;if(f(e))return e;let t=e.length;if(!v(t))return null;const n=new Array(t);for(;t-- >0;)n[t]=e[t];return n},forEachEntry:(e,t)=>{const n=(e&&e[u]).call(e);let r;for(;(r=n.next())&&!r.done;){const n=r.value;t.call(e,n[0],n[1])}},matchAll:(e,t)=>{let n;const r=[];for(;null!==(n=e.exec(t));)r.push(n);return r},isHTMLForm:N,hasOwnProperty:F,hasOwnProp:F,reduceDescriptors:$,freezeMethods:e=>{$(e,((t,n)=>{if(L(e)&&-1!==["arguments","caller","callee"].indexOf(n))return!1;const r=e[n];L(r)&&(t.enumerable=!1,"writable"in t?t.writable=!1:t.set||(t.set=()=>{throw Error("Can not rewrite read-only method '"+n+"'")}))}))},toObjectSet:(e,t)=>{const n={},r=e=>{e.forEach((e=>{n[e]=!0}))};return f(e)?r(e):r(String(e).split(t)),n},toCamelCase:e=>e.toLowerCase().replace(/[-_\s]([a-z\d])(\w*)/g,(function(e,t,n){return t.toUpperCase()+n})),noop:()=>{},toFiniteNumber:(e,t)=>null!=e&&Number.isFinite(e=+e)?e:t,findKey:H,global:P,isContextDefined:C,isSpecCompliantForm:function(e){return!!(e&&L(e.append)&&"FormData"===e[l]&&e[u])},toJSONObject:e=>{const t=new Array(10),n=(e,r)=>{if(Y(e)){if(t.indexOf(e)>=0)return;if(y(e))return e;if(!("toJSON"in e)){t[r]=e;const a=f(e)?[]:{};return A(e,((e,t)=>{const s=n(e,r+1);!p(s)&&(a[t]=s)})),t[r]=void 0,a}}return e};return n(e,0)},isAsyncFn:U,isThenable:e=>e&&(Y(e)||L(e))&&L(e.then)&&L(e.catch),setImmediate:B,asap:q,isIterable:e=>null!=e&&L(e[u])};function Z(e,t,n,r,a){Error.call(this),Error.captureStackTrace?Error.captureStackTrace(this,this.constructor):this.stack=(new Error).stack,this.message=e,this.name="AxiosError",t&&(this.code=t),n&&(this.config=n),r&&(this.request=r),a&&(this.response=a,this.status=a.status?a.status:null)}K.inherits(Z,Error,{toJSON:function(){return{message:this.message,name:this.name,description:this.description,number:this.number,fileName:this.fileName,lineNumber:this.lineNumber,columnNumber:this.columnNumber,stack:this.stack,config:K.toJSONObject(this.config),code:this.code,status:this.status}}});const X=Z.prototype,Q={};["ERR_BAD_OPTION_VALUE","ERR_BAD_OPTION","ECONNABORTED","ETIMEDOUT","ERR_NETWORK","ERR_FR_TOO_MANY_REDIRECTS","ERR_DEPRECATED","ERR_BAD_RESPONSE","ERR_BAD_REQUEST","ERR_CANCELED","ERR_NOT_SUPPORT","ERR_INVALID_URL"].forEach((e=>{Q[e]={value:e}})),Object.defineProperties(Z,Q),Object.defineProperty(X,"isAxiosError",{value:!0}),Z.from=(e,t,n,r,a,s)=>{const i=Object.create(X);K.toFlatObject(e,i,(function(e){return e!==Error.prototype}),(e=>"isAxiosError"!==e));const o=e&&e.message?e.message:"Error",d=null==t&&e?e.code:t;return Z.call(i,o,d,n,r,a),e&&null==i.cause&&Object.defineProperty(i,"cause",{value:e,configurable:!0}),i.name=e&&e.name||"Error",s&&Object.assign(i,s),i};const ee=Z;var te=n(48287).Buffer;function ne(e){return K.isPlainObject(e)||K.isArray(e)}function re(e){return K.endsWith(e,"[]")?e.slice(0,-2):e}function ae(e,t,n){return e?e.concat(t).map((function(e,t){return e=re(e),!n&&t?"["+e+"]":e})).join(n?".":""):t}const se=K.toFlatObject(K,{},null,(function(e){return/^is[A-Z]/.test(e)}));const ie=function(e,t,n){if(!K.isObject(e))throw new TypeError("target must be an object");t=t||new FormData;const r=(n=K.toFlatObject(n,{metaTokens:!0,dots:!1,indexes:!1},!1,(function(e,t){return!K.isUndefined(t[e])}))).metaTokens,a=n.visitor||u,s=n.dots,i=n.indexes,o=(n.Blob||"undefined"!=typeof Blob&&Blob)&&K.isSpecCompliantForm(t);if(!K.isFunction(a))throw new TypeError("visitor must be a function");function d(e){if(null===e)return"";if(K.isDate(e))return e.toISOString();if(K.isBoolean(e))return e.toString();if(!o&&K.isBlob(e))throw new ee("Blob is not supported. Use a Buffer instead.");return K.isArrayBuffer(e)||K.isTypedArray(e)?o&&"function"==typeof Blob?new Blob([e]):te.from(e):e}function u(e,n,a){let o=e;if(e&&!a&&"object"==typeof e)if(K.endsWith(n,"{}"))n=r?n:n.slice(0,-2),e=JSON.stringify(e);else if(K.isArray(e)&&function(e){return K.isArray(e)&&!e.some(ne)}(e)||(K.isFileList(e)||K.endsWith(n,"[]"))&&(o=K.toArray(e)))return n=re(n),o.forEach((function(e,r){!K.isUndefined(e)&&null!==e&&t.append(!0===i?ae([n],r,s):null===i?n:n+"[]",d(e))})),!1;return!!ne(e)||(t.append(ae(a,n,s),d(e)),!1)}const l=[],c=Object.assign(se,{defaultVisitor:u,convertValue:d,isVisitable:ne});if(!K.isObject(e))throw new TypeError("data must be an object");return function e(n,r){if(!K.isUndefined(n)){if(-1!==l.indexOf(n))throw Error("Circular reference detected in "+r.join("."));l.push(n),K.forEach(n,(function(n,s){!0===(!(K.isUndefined(n)||null===n)&&a.call(t,n,K.isString(s)?s.trim():s,r,c))&&e(n,r?r.concat(s):[s])})),l.pop()}}(e),t};function oe(e){const t={"!":"%21","'":"%27","(":"%28",")":"%29","~":"%7E","%20":"+","%00":"\0"};return encodeURIComponent(e).replace(/[!'()~]|%20|%00/g,(function(e){return t[e]}))}function de(e,t){this._pairs=[],e&&ie(e,this,t)}const ue=de.prototype;ue.append=function(e,t){this._pairs.push([e,t])},ue.toString=function(e){const t=e?function(t){return e.call(this,t,oe)}:oe;return this._pairs.map((function(e){return t(e[0])+"="+t(e[1])}),"").join("&")};const le=de;function ce(e){return encodeURIComponent(e).replace(/%3A/gi,":").replace(/%24/g,"$").replace(/%2C/gi,",").replace(/%20/g,"+")}function _e(e,t,n){if(!t)return e;const r=n&&n.encode||ce;K.isFunction(n)&&(n={serialize:n});const a=n&&n.serialize;let s;if(s=a?a(t,n):K.isURLSearchParams(t)?t.toString():new le(t,n).toString(r),s){const t=e.indexOf("#");-1!==t&&(e=e.slice(0,t)),e+=(-1===e.indexOf("?")?"?":"&")+s}return e}const me=class{constructor(){this.handlers=[]}use(e,t,n){return this.handlers.push({fulfilled:e,rejected:t,synchronous:!!n&&n.synchronous,runWhen:n?n.runWhen:null}),this.handlers.length-1}eject(e){this.handlers[e]&&(this.handlers[e]=null)}clear(){this.handlers&&(this.handlers=[])}forEach(e){K.forEach(this.handlers,(function(t){null!==t&&e(t)}))}},he={silentJSONParsing:!0,forcedJSONParsing:!0,clarifyTimeoutError:!1},fe={isBrowser:!0,classes:{URLSearchParams:"undefined"!=typeof URLSearchParams?URLSearchParams:le,FormData:"undefined"!=typeof FormData?FormData:null,Blob:"undefined"!=typeof Blob?Blob:null},protocols:["http","https","file","blob","url","data"]},pe="undefined"!=typeof window&&"undefined"!=typeof document,ye="object"==typeof navigator&&navigator||void 0,Me=pe&&(!ye||["ReactNative","NativeScript","NS"].indexOf(ye.product)<0),ge="undefined"!=typeof WorkerGlobalScope&&self instanceof WorkerGlobalScope&&"function"==typeof self.importScripts,Le=pe&&window.location.href||"http://localhost",ve={...r,...fe};const Ye=function(e){function t(e,n,r,a){let s=e[a++];if("__proto__"===s)return!0;const i=Number.isFinite(+s),o=a>=e.length;if(s=!s&&K.isArray(r)?r.length:s,o)return K.hasOwnProp(r,s)?r[s]=[r[s],n]:r[s]=n,!i;r[s]&&K.isObject(r[s])||(r[s]=[]);return t(e,n,r[s],a)&&K.isArray(r[s])&&(r[s]=function(e){const t={},n=Object.keys(e);let r;const a=n.length;let s;for(r=0;r<a;r++)s=n[r],t[s]=e[s];return t}(r[s])),!i}if(K.isFormData(e)&&K.isFunction(e.entries)){const n={};return K.forEachEntry(e,((e,r)=>{t(function(e){return K.matchAll(/\w+|\[(\w*)]/g,e).map((e=>"[]"===e[0]?"":e[1]||e[0]))}(e),r,n,0)})),n}return null};const we={transitional:he,adapter:["xhr","http","fetch"],transformRequest:[function(e,t){const n=t.getContentType()||"",r=n.indexOf("application/json")>-1,a=K.isObject(e);a&&K.isHTMLForm(e)&&(e=new FormData(e));if(K.isFormData(e))return r?JSON.stringify(Ye(e)):e;if(K.isArrayBuffer(e)||K.isBuffer(e)||K.isStream(e)||K.isFile(e)||K.isBlob(e)||K.isReadableStream(e))return e;if(K.isArrayBufferView(e))return e.buffer;if(K.isURLSearchParams(e))return t.setContentType("application/x-www-form-urlencoded;charset=utf-8",!1),e.toString();let s;if(a){if(n.indexOf("application/x-www-form-urlencoded")>-1)return function(e,t){return ie(e,new ve.classes.URLSearchParams,{visitor:function(e,t,n,r){return ve.isNode&&K.isBuffer(e)?(this.append(t,e.toString("base64")),!1):r.defaultVisitor.apply(this,arguments)},...t})}(e,this.formSerializer).toString();if((s=K.isFileList(e))||n.indexOf("multipart/form-data")>-1){const t=this.env&&this.env.FormData;return ie(s?{"files[]":e}:e,t&&new t,this.formSerializer)}}return a||r?(t.setContentType("application/json",!1),function(e,t,n){if(K.isString(e))try{return(t||JSON.parse)(e),K.trim(e)}catch(e){if("SyntaxError"!==e.name)throw e}return(n||JSON.stringify)(e)}(e)):e}],transformResponse:[function(e){const t=this.transitional||we.transitional,n=t&&t.forcedJSONParsing,r="json"===this.responseType;if(K.isResponse(e)||K.isReadableStream(e))return e;if(e&&K.isString(e)&&(n&&!this.responseType||r)){const n=!(t&&t.silentJSONParsing)&&r;try{return JSON.parse(e,this.parseReviver)}catch(e){if(n){if("SyntaxError"===e.name)throw ee.from(e,ee.ERR_BAD_RESPONSE,this,null,this.response);throw e}}}return e}],timeout:0,xsrfCookieName:"XSRF-TOKEN",xsrfHeaderName:"X-XSRF-TOKEN",maxContentLength:-1,maxBodyLength:-1,env:{FormData:ve.classes.FormData,Blob:ve.classes.Blob},validateStatus:function(e){return e>=200&&e<300},headers:{common:{Accept:"application/json, text/plain, */*","Content-Type":void 0}}};K.forEach(["delete","get","head","post","put","patch"],(e=>{we.headers[e]={}}));const ke=we,be=K.toObjectSet(["age","authorization","content-length","content-type","etag","expires","from","host","if-modified-since","if-unmodified-since","last-modified","location","max-forwards","proxy-authorization","referer","retry-after","user-agent"]),De=Symbol("internals");function Te(e){return e&&String(e).trim().toLowerCase()}function Se(e){return!1===e||null==e?e:K.isArray(e)?e.map(Se):String(e)}function je(e,t,n,r,a){return K.isFunction(r)?r.call(this,t,n):(a&&(t=n),K.isString(t)?K.isString(r)?-1!==t.indexOf(r):K.isRegExp(r)?r.test(t):void 0:void 0)}class Ee{constructor(e){e&&this.set(e)}set(e,t,n){const r=this;function a(e,t,n){const a=Te(t);if(!a)throw new Error("header name must be a non-empty string");const s=K.findKey(r,a);(!s||void 0===r[s]||!0===n||void 0===n&&!1!==r[s])&&(r[s||t]=Se(e))}const s=(e,t)=>K.forEach(e,((e,n)=>a(e,n,t)));if(K.isPlainObject(e)||e instanceof this.constructor)s(e,t);else if(K.isString(e)&&(e=e.trim())&&!/^[-_a-zA-Z0-9^`|~,!#$%&'*+.]+$/.test(e.trim()))s((e=>{const t={};let n,r,a;return e&&e.split("\n").forEach((function(e){a=e.indexOf(":"),n=e.substring(0,a).trim().toLowerCase(),r=e.substring(a+1).trim(),!n||t[n]&&be[n]||("set-cookie"===n?t[n]?t[n].push(r):t[n]=[r]:t[n]=t[n]?t[n]+", "+r:r)})),t})(e),t);else if(K.isObject(e)&&K.isIterable(e)){let n,r,a={};for(const t of e){if(!K.isArray(t))throw TypeError("Object iterator must return a key-value pair");a[r=t[0]]=(n=a[r])?K.isArray(n)?[...n,t[1]]:[n,t[1]]:t[1]}s(a,t)}else null!=e&&a(t,e,n);return this}get(e,t){if(e=Te(e)){const n=K.findKey(this,e);if(n){const e=this[n];if(!t)return e;if(!0===t)return function(e){const t=Object.create(null),n=/([^\s,;=]+)\s*(?:=\s*([^,;]+))?/g;let r;for(;r=n.exec(e);)t[r[1]]=r[2];return t}(e);if(K.isFunction(t))return t.call(this,e,n);if(K.isRegExp(t))return t.exec(e);throw new TypeError("parser must be boolean|regexp|function")}}}has(e,t){if(e=Te(e)){const n=K.findKey(this,e);return!(!n||void 0===this[n]||t&&!je(0,this[n],n,t))}return!1}delete(e,t){const n=this;let r=!1;function a(e){if(e=Te(e)){const a=K.findKey(n,e);!a||t&&!je(0,n[a],a,t)||(delete n[a],r=!0)}}return K.isArray(e)?e.forEach(a):a(e),r}clear(e){const t=Object.keys(this);let n=t.length,r=!1;for(;n--;){const a=t[n];e&&!je(0,this[a],a,e,!0)||(delete this[a],r=!0)}return r}normalize(e){const t=this,n={};return K.forEach(this,((r,a)=>{const s=K.findKey(n,a);if(s)return t[s]=Se(r),void delete t[a];const i=e?function(e){return e.trim().toLowerCase().replace(/([a-z\d])(\w*)/g,((e,t,n)=>t.toUpperCase()+n))}(a):String(a).trim();i!==a&&delete t[a],t[i]=Se(r),n[i]=!0})),this}concat(...e){return this.constructor.concat(this,...e)}toJSON(e){const t=Object.create(null);return K.forEach(this,((n,r)=>{null!=n&&!1!==n&&(t[r]=e&&K.isArray(n)?n.join(", "):n)})),t}[Symbol.iterator](){return Object.entries(this.toJSON())[Symbol.iterator]()}toString(){return Object.entries(this.toJSON()).map((([e,t])=>e+": "+t)).join("\n")}getSetCookie(){return this.get("set-cookie")||[]}get[Symbol.toStringTag](){return"AxiosHeaders"}static from(e){return e instanceof this?e:new this(e)}static concat(e,...t){const n=new this(e);return t.forEach((e=>n.set(e))),n}static accessor(e){const t=(this[De]=this[De]={accessors:{}}).accessors,n=this.prototype;function r(e){const r=Te(e);t[r]||(!function(e,t){const n=K.toCamelCase(" "+t);["get","set","has"].forEach((r=>{Object.defineProperty(e,r+n,{value:function(e,n,a){return this[r].call(this,t,e,n,a)},configurable:!0})}))}(n,e),t[r]=!0)}return K.isArray(e)?e.forEach(r):r(e),this}}Ee.accessor(["Content-Type","Content-Length","Accept","Accept-Encoding","User-Agent","Authorization"]),K.reduceDescriptors(Ee.prototype,(({value:e},t)=>{let n=t[0].toUpperCase()+t.slice(1);return{get:()=>e,set(e){this[n]=e}}})),K.freezeMethods(Ee);const xe=Ee;function Oe(e,t){const n=this||ke,r=t||n,a=xe.from(r.headers);let s=r.data;return K.forEach(e,(function(e){s=e.call(n,s,a.normalize(),t?t.status:void 0)})),a.normalize(),s}function Ae(e){return!(!e||!e.__CANCEL__)}function He(e,t,n){ee.call(this,null==e?"canceled":e,ee.ERR_CANCELED,t,n),this.name="CanceledError"}K.inherits(He,ee,{__CANCEL__:!0});const Pe=He;function Ce(e,t,n){const r=n.config.validateStatus;n.status&&r&&!r(n.status)?t(new ee("Request failed with status code "+n.status,[ee.ERR_BAD_REQUEST,ee.ERR_BAD_RESPONSE][Math.floor(n.status/100)-4],n.config,n.request,n)):e(n)}const Ie=function(e,t){e=e||10;const n=new Array(e),r=new Array(e);let a,s=0,i=0;return t=void 0!==t?t:1e3,function(o){const d=Date.now(),u=r[i];a||(a=d),n[s]=o,r[s]=d;let l=i,c=0;for(;l!==s;)c+=n[l++],l%=e;if(s=(s+1)%e,s===i&&(i=(i+1)%e),d-a<t)return;const _=u&&d-u;return _?Math.round(1e3*c/_):void 0}};const Re=function(e,t){let n,r,a=0,s=1e3/t;const i=(t,s=Date.now())=>{a=s,n=null,r&&(clearTimeout(r),r=null),e(...t)};return[(...e)=>{const t=Date.now(),o=t-a;o>=s?i(e,t):(n=e,r||(r=setTimeout((()=>{r=null,i(n)}),s-o)))},()=>n&&i(n)]},Ne=(e,t,n=3)=>{let r=0;const a=Ie(50,250);return Re((n=>{const s=n.loaded,i=n.lengthComputable?n.total:void 0,o=s-r,d=a(o);r=s;e({loaded:s,total:i,progress:i?s/i:void 0,bytes:o,rate:d||void 0,estimated:d&&i&&s<=i?(i-s)/d:void 0,event:n,lengthComputable:null!=i,[t?"download":"upload"]:!0})}),n)},Fe=(e,t)=>{const n=null!=e;return[r=>t[0]({lengthComputable:n,total:e,loaded:r}),t[1]]},We=e=>(...t)=>K.asap((()=>e(...t))),$e=ve.hasStandardBrowserEnv?((e,t)=>n=>(n=new URL(n,ve.origin),e.protocol===n.protocol&&e.host===n.host&&(t||e.port===n.port)))(new URL(ve.origin),ve.navigator&&/(msie|trident)/i.test(ve.navigator.userAgent)):()=>!0,Ue=ve.hasStandardBrowserEnv?{write(e,t,n,r,a,s){const i=[e+"="+encodeURIComponent(t)];K.isNumber(n)&&i.push("expires="+new Date(n).toGMTString()),K.isString(r)&&i.push("path="+r),K.isString(a)&&i.push("domain="+a),!0===s&&i.push("secure"),document.cookie=i.join("; ")},read(e){const t=document.cookie.match(new RegExp("(^|;\\s*)("+e+")=([^;]*)"));return t?decodeURIComponent(t[3]):null},remove(e){this.write(e,"",Date.now()-864e5)}}:{write(){},read:()=>null,remove(){}};function Be(e,t,n){let r=!/^([a-z][a-z\d+\-.]*:)?\/\//i.test(t);return e&&(r||0==n)?function(e,t){return t?e.replace(/\/?\/$/,"")+"/"+t.replace(/^\/+/,""):e}(e,t):t}const ze=e=>e instanceof xe?{...e}:e;function Je(e,t){t=t||{};const n={};function r(e,t,n,r){return K.isPlainObject(e)&&K.isPlainObject(t)?K.merge.call({caseless:r},e,t):K.isPlainObject(t)?K.merge({},t):K.isArray(t)?t.slice():t}function a(e,t,n,a){return K.isUndefined(t)?K.isUndefined(e)?void 0:r(void 0,e,0,a):r(e,t,0,a)}function s(e,t){if(!K.isUndefined(t))return r(void 0,t)}function i(e,t){return K.isUndefined(t)?K.isUndefined(e)?void 0:r(void 0,e):r(void 0,t)}function o(n,a,s){return s in t?r(n,a):s in e?r(void 0,n):void 0}const d={url:s,method:s,data:s,baseURL:i,transformRequest:i,transformResponse:i,paramsSerializer:i,timeout:i,timeoutMessage:i,withCredentials:i,withXSRFToken:i,adapter:i,responseType:i,xsrfCookieName:i,xsrfHeaderName:i,onUploadProgress:i,onDownloadProgress:i,decompress:i,maxContentLength:i,maxBodyLength:i,beforeRedirect:i,transport:i,httpAgent:i,httpsAgent:i,cancelToken:i,socketPath:i,responseEncoding:i,validateStatus:o,headers:(e,t,n)=>a(ze(e),ze(t),0,!0)};return K.forEach(Object.keys({...e,...t}),(function(r){const s=d[r]||a,i=s(e[r],t[r],r);K.isUndefined(i)&&s!==o||(n[r]=i)})),n}const Ge=e=>{const t=Je({},e);let{data:n,withXSRFToken:r,xsrfHeaderName:a,xsrfCookieName:s,headers:i,auth:o}=t;if(t.headers=i=xe.from(i),t.url=_e(Be(t.baseURL,t.url,t.allowAbsoluteUrls),e.params,e.paramsSerializer),o&&i.set("Authorization","Basic "+btoa((o.username||"")+":"+(o.password?unescape(encodeURIComponent(o.password)):""))),K.isFormData(n))if(ve.hasStandardBrowserEnv||ve.hasStandardBrowserWebWorkerEnv)i.setContentType(void 0);else if(K.isFunction(n.getHeaders)){const e=n.getHeaders(),t=["content-type","content-length"];Object.entries(e).forEach((([e,n])=>{t.includes(e.toLowerCase())&&i.set(e,n)}))}if(ve.hasStandardBrowserEnv&&(r&&K.isFunction(r)&&(r=r(t)),r||!1!==r&&$e(t.url))){const e=a&&s&&Ue.read(s);e&&i.set(a,e)}return t},Ve="undefined"!=typeof XMLHttpRequest&&function(e){return new Promise((function(t,n){const r=Ge(e);let a=r.data;const s=xe.from(r.headers).normalize();let i,o,d,u,l,{responseType:c,onUploadProgress:_,onDownloadProgress:m}=r;function h(){u&&u(),l&&l(),r.cancelToken&&r.cancelToken.unsubscribe(i),r.signal&&r.signal.removeEventListener("abort",i)}let f=new XMLHttpRequest;function p(){if(!f)return;const r=xe.from("getAllResponseHeaders"in f&&f.getAllResponseHeaders());Ce((function(e){t(e),h()}),(function(e){n(e),h()}),{data:c&&"text"!==c&&"json"!==c?f.response:f.responseText,status:f.status,statusText:f.statusText,headers:r,config:e,request:f}),f=null}f.open(r.method.toUpperCase(),r.url,!0),f.timeout=r.timeout,"onloadend"in f?f.onloadend=p:f.onreadystatechange=function(){f&&4===f.readyState&&(0!==f.status||f.responseURL&&0===f.responseURL.indexOf("file:"))&&setTimeout(p)},f.onabort=function(){f&&(n(new ee("Request aborted",ee.ECONNABORTED,e,f)),f=null)},f.onerror=function(t){const r=t&&t.message?t.message:"Network Error",a=new ee(r,ee.ERR_NETWORK,e,f);a.event=t||null,n(a),f=null},f.ontimeout=function(){let t=r.timeout?"timeout of "+r.timeout+"ms exceeded":"timeout exceeded";const a=r.transitional||he;r.timeoutErrorMessage&&(t=r.timeoutErrorMessage),n(new ee(t,a.clarifyTimeoutError?ee.ETIMEDOUT:ee.ECONNABORTED,e,f)),f=null},void 0===a&&s.setContentType(null),"setRequestHeader"in f&&K.forEach(s.toJSON(),(function(e,t){f.setRequestHeader(t,e)})),K.isUndefined(r.withCredentials)||(f.withCredentials=!!r.withCredentials),c&&"json"!==c&&(f.responseType=r.responseType),m&&([d,l]=Ne(m,!0),f.addEventListener("progress",d)),_&&f.upload&&([o,u]=Ne(_),f.upload.addEventListener("progress",o),f.upload.addEventListener("loadend",u)),(r.cancelToken||r.signal)&&(i=t=>{f&&(n(!t||t.type?new Pe(null,e,f):t),f.abort(),f=null)},r.cancelToken&&r.cancelToken.subscribe(i),r.signal&&(r.signal.aborted?i():r.signal.addEventListener("abort",i)));const y=function(e){const t=/^([-+\w]{1,25})(:?\/\/|:)/.exec(e);return t&&t[1]||""}(r.url);y&&-1===ve.protocols.indexOf(y)?n(new ee("Unsupported protocol "+y+":",ee.ERR_BAD_REQUEST,e)):f.send(a||null)}))},qe=(e,t)=>{const{length:n}=e=e?e.filter(Boolean):[];if(t||n){let n,r=new AbortController;const a=function(e){if(!n){n=!0,i();const t=e instanceof Error?e:this.reason;r.abort(t instanceof ee?t:new Pe(t instanceof Error?t.message:t))}};let s=t&&setTimeout((()=>{s=null,a(new ee(`timeout ${t} of ms exceeded`,ee.ETIMEDOUT))}),t);const i=()=>{e&&(s&&clearTimeout(s),s=null,e.forEach((e=>{e.unsubscribe?e.unsubscribe(a):e.removeEventListener("abort",a)})),e=null)};e.forEach((e=>e.addEventListener("abort",a)));const{signal:o}=r;return o.unsubscribe=()=>K.asap(i),o}},Ke=function*(e,t){let n=e.byteLength;if(!t||n<t)return void(yield e);let r,a=0;for(;a<n;)r=a+t,yield e.slice(a,r),a=r},Ze=async function*(e){if(e[Symbol.asyncIterator])return void(yield*e);const t=e.getReader();try{for(;;){const{done:e,value:n}=await t.read();if(e)break;yield n}}finally{await t.cancel()}},Xe=(e,t,n,r)=>{const a=async function*(e,t){for await(const n of Ze(e))yield*Ke(n,t)}(e,t);let s,i=0,o=e=>{s||(s=!0,r&&r(e))};return new ReadableStream({async pull(e){try{const{done:t,value:r}=await a.next();if(t)return o(),void e.close();let s=r.byteLength;if(n){let e=i+=s;n(e)}e.enqueue(new Uint8Array(r))}catch(e){throw o(e),e}},cancel:e=>(o(e),a.return())},{highWaterMark:2})},{isFunction:Qe}=K,et=(({Request:e,Response:t})=>({Request:e,Response:t}))(K.global),{ReadableStream:tt,TextEncoder:nt}=K.global,rt=(e,...t)=>{try{return!!e(...t)}catch(e){return!1}},at=e=>{e=K.merge.call({skipUndefined:!0},et,e);const{fetch:t,Request:n,Response:r}=e,a=t?Qe(t):"function"==typeof fetch,s=Qe(n),i=Qe(r);if(!a)return!1;const o=a&&Qe(tt),d=a&&("function"==typeof nt?(u=new nt,e=>u.encode(e)):async e=>new Uint8Array(await new n(e).arrayBuffer()));var u;const l=s&&o&&rt((()=>{let e=!1;const t=new n(ve.origin,{body:new tt,method:"POST",get duplex(){return e=!0,"half"}}).headers.has("Content-Type");return e&&!t})),c=i&&o&&rt((()=>K.isReadableStream(new r("").body))),_={stream:c&&(e=>e.body)};a&&["text","arrayBuffer","blob","formData","stream"].forEach((e=>{!_[e]&&(_[e]=(t,n)=>{let r=t&&t[e];if(r)return r.call(t);throw new ee(`Response type '${e}' is not supported`,ee.ERR_NOT_SUPPORT,n)})}));const m=async(e,t)=>{const r=K.toFiniteNumber(e.getContentLength());return null==r?(async e=>{if(null==e)return 0;if(K.isBlob(e))return e.size;if(K.isSpecCompliantForm(e)){const t=new n(ve.origin,{method:"POST",body:e});return(await t.arrayBuffer()).byteLength}return K.isArrayBufferView(e)||K.isArrayBuffer(e)?e.byteLength:(K.isURLSearchParams(e)&&(e+=""),K.isString(e)?(await d(e)).byteLength:void 0)})(t):r};return async e=>{let{url:a,method:i,data:o,signal:d,cancelToken:u,timeout:h,onDownloadProgress:f,onUploadProgress:p,responseType:y,headers:M,withCredentials:g="same-origin",fetchOptions:L}=Ge(e),v=t||fetch;y=y?(y+"").toLowerCase():"text";let Y=qe([d,u&&u.toAbortSignal()],h),w=null;const k=Y&&Y.unsubscribe&&(()=>{Y.unsubscribe()});let b;try{if(p&&l&&"get"!==i&&"head"!==i&&0!==(b=await m(M,o))){let e,t=new n(a,{method:"POST",body:o,duplex:"half"});if(K.isFormData(o)&&(e=t.headers.get("content-type"))&&M.setContentType(e),t.body){const[e,n]=Fe(b,Ne(We(p)));o=Xe(t.body,65536,e,n)}}K.isString(g)||(g=g?"include":"omit");const t=s&&"credentials"in n.prototype,d={...L,signal:Y,method:i.toUpperCase(),headers:M.normalize().toJSON(),body:o,duplex:"half",credentials:t?g:void 0};w=s&&new n(a,d);let u=await(s?v(w,L):v(a,d));const h=c&&("stream"===y||"response"===y);if(c&&(f||h&&k)){const e={};["status","statusText","headers"].forEach((t=>{e[t]=u[t]}));const t=K.toFiniteNumber(u.headers.get("content-length")),[n,a]=f&&Fe(t,Ne(We(f),!0))||[];u=new r(Xe(u.body,65536,n,(()=>{a&&a(),k&&k()})),e)}y=y||"text";let D=await _[K.findKey(_,y)||"text"](u,e);return!h&&k&&k(),await new Promise(((t,n)=>{Ce(t,n,{data:D,headers:xe.from(u.headers),status:u.status,statusText:u.statusText,config:e,request:w})}))}catch(t){if(k&&k(),t&&"TypeError"===t.name&&/Load failed|fetch/i.test(t.message))throw Object.assign(new ee("Network Error",ee.ERR_NETWORK,e,w),{cause:t.cause||t});throw ee.from(t,t&&t.code,e,w)}}},st=new Map,it=e=>{let t=e?e.env:{};const{fetch:n,Request:r,Response:a}=t,s=[r,a,n];let i,o,d=s.length,u=st;for(;d--;)i=s[d],o=u.get(i),void 0===o&&u.set(i,o=d?new Map:at(t)),u=o;return o},ot=(it(),{http:null,xhr:Ve,fetch:{get:it}});K.forEach(ot,((e,t)=>{if(e){try{Object.defineProperty(e,"name",{value:t})}catch(e){}Object.defineProperty(e,"adapterName",{value:t})}}));const dt=e=>`- ${e}`,ut=e=>K.isFunction(e)||null===e||!1===e,lt=(e,t)=>{e=K.isArray(e)?e:[e];const{length:n}=e;let r,a;const s={};for(let i=0;i<n;i++){let n;if(r=e[i],a=r,!ut(r)&&(a=ot[(n=String(r)).toLowerCase()],void 0===a))throw new ee(`Unknown adapter '${n}'`);if(a&&(K.isFunction(a)||(a=a.get(t))))break;s[n||"#"+i]=a}if(!a){const e=Object.entries(s).map((([e,t])=>`adapter ${e} `+(!1===t?"is not supported by the environment":"is not available in the build")));let t=n?e.length>1?"since :\n"+e.map(dt).join("\n"):" "+dt(e[0]):"as no adapter specified";throw new ee("There is no suitable adapter to dispatch the request "+t,"ERR_NOT_SUPPORT")}return a};function ct(e){if(e.cancelToken&&e.cancelToken.throwIfRequested(),e.signal&&e.signal.aborted)throw new Pe(null,e)}function _t(e){ct(e),e.headers=xe.from(e.headers),e.data=Oe.call(e,e.transformRequest),-1!==["post","put","patch"].indexOf(e.method)&&e.headers.setContentType("application/x-www-form-urlencoded",!1);return lt(e.adapter||ke.adapter,e)(e).then((function(t){return ct(e),t.data=Oe.call(e,e.transformResponse,t),t.headers=xe.from(t.headers),t}),(function(t){return Ae(t)||(ct(e),t&&t.response&&(t.response.data=Oe.call(e,e.transformResponse,t.response),t.response.headers=xe.from(t.response.headers))),Promise.reject(t)}))}const mt="1.12.2",ht={};["object","boolean","number","function","string","symbol"].forEach(((e,t)=>{ht[e]=function(n){return typeof n===e||"a"+(t<1?"n ":" ")+e}}));const ft={};ht.transitional=function(e,t,n){function r(e,t){return"[Axios v"+mt+"] Transitional option '"+e+"'"+t+(n?". "+n:"")}return(n,a,s)=>{if(!1===e)throw new ee(r(a," has been removed"+(t?" in "+t:"")),ee.ERR_DEPRECATED);return t&&!ft[a]&&(ft[a]=!0,console.warn(r(a," has been deprecated since v"+t+" and will be removed in the near future"))),!e||e(n,a,s)}},ht.spelling=function(e){return(t,n)=>(console.warn(`${n} is likely a misspelling of ${e}`),!0)};const pt={assertOptions:function(e,t,n){if("object"!=typeof e)throw new ee("options must be an object",ee.ERR_BAD_OPTION_VALUE);const r=Object.keys(e);let a=r.length;for(;a-- >0;){const s=r[a],i=t[s];if(i){const t=e[s],n=void 0===t||i(t,s,e);if(!0!==n)throw new ee("option "+s+" must be "+n,ee.ERR_BAD_OPTION_VALUE)}else if(!0!==n)throw new ee("Unknown option "+s,ee.ERR_BAD_OPTION)}},validators:ht},yt=pt.validators;class Mt{constructor(e){this.defaults=e||{},this.interceptors={request:new me,response:new me}}async request(e,t){try{return await this._request(e,t)}catch(e){if(e instanceof Error){let t={};Error.captureStackTrace?Error.captureStackTrace(t):t=new Error;const n=t.stack?t.stack.replace(/^.+\n/,""):"";try{e.stack?n&&!String(e.stack).endsWith(n.replace(/^.+\n.+\n/,""))&&(e.stack+="\n"+n):e.stack=n}catch(e){}}throw e}}_request(e,t){"string"==typeof e?(t=t||{}).url=e:t=e||{},t=Je(this.defaults,t);const{transitional:n,paramsSerializer:r,headers:a}=t;void 0!==n&&pt.assertOptions(n,{silentJSONParsing:yt.transitional(yt.boolean),forcedJSONParsing:yt.transitional(yt.boolean),clarifyTimeoutError:yt.transitional(yt.boolean)},!1),null!=r&&(K.isFunction(r)?t.paramsSerializer={serialize:r}:pt.assertOptions(r,{encode:yt.function,serialize:yt.function},!0)),void 0!==t.allowAbsoluteUrls||(void 0!==this.defaults.allowAbsoluteUrls?t.allowAbsoluteUrls=this.defaults.allowAbsoluteUrls:t.allowAbsoluteUrls=!0),pt.assertOptions(t,{baseUrl:yt.spelling("baseURL"),withXsrfToken:yt.spelling("withXSRFToken")},!0),t.method=(t.method||this.defaults.method||"get").toLowerCase();let s=a&&K.merge(a.common,a[t.method]);a&&K.forEach(["delete","get","head","post","put","patch","common"],(e=>{delete a[e]})),t.headers=xe.concat(s,a);const i=[];let o=!0;this.interceptors.request.forEach((function(e){"function"==typeof e.runWhen&&!1===e.runWhen(t)||(o=o&&e.synchronous,i.unshift(e.fulfilled,e.rejected))}));const d=[];let u;this.interceptors.response.forEach((function(e){d.push(e.fulfilled,e.rejected)}));let l,c=0;if(!o){const e=[_t.bind(this),void 0];for(e.unshift(...i),e.push(...d),l=e.length,u=Promise.resolve(t);c<l;)u=u.then(e[c++],e[c++]);return u}l=i.length;let _=t;for(;c<l;){const e=i[c++],t=i[c++];try{_=e(_)}catch(e){t.call(this,e);break}}try{u=_t.call(this,_)}catch(e){return Promise.reject(e)}for(c=0,l=d.length;c<l;)u=u.then(d[c++],d[c++]);return u}getUri(e){return _e(Be((e=Je(this.defaults,e)).baseURL,e.url,e.allowAbsoluteUrls),e.params,e.paramsSerializer)}}K.forEach(["delete","get","head","options"],(function(e){Mt.prototype[e]=function(t,n){return this.request(Je(n||{},{method:e,url:t,data:(n||{}).data}))}})),K.forEach(["post","put","patch"],(function(e){function t(t){return function(n,r,a){return this.request(Je(a||{},{method:e,headers:t?{"Content-Type":"multipart/form-data"}:{},url:n,data:r}))}}Mt.prototype[e]=t(),Mt.prototype[e+"Form"]=t(!0)}));const gt=Mt;class Lt{constructor(e){if("function"!=typeof e)throw new TypeError("executor must be a function.");let t;this.promise=new Promise((function(e){t=e}));const n=this;this.promise.then((e=>{if(!n._listeners)return;let t=n._listeners.length;for(;t-- >0;)n._listeners[t](e);n._listeners=null})),this.promise.then=e=>{let t;const r=new Promise((e=>{n.subscribe(e),t=e})).then(e);return r.cancel=function(){n.unsubscribe(t)},r},e((function(e,r,a){n.reason||(n.reason=new Pe(e,r,a),t(n.reason))}))}throwIfRequested(){if(this.reason)throw this.reason}subscribe(e){this.reason?e(this.reason):this._listeners?this._listeners.push(e):this._listeners=[e]}unsubscribe(e){if(!this._listeners)return;const t=this._listeners.indexOf(e);-1!==t&&this._listeners.splice(t,1)}toAbortSignal(){const e=new AbortController,t=t=>{e.abort(t)};return this.subscribe(t),e.signal.unsubscribe=()=>this.unsubscribe(t),e.signal}static source(){let e;return{token:new Lt((function(t){e=t})),cancel:e}}}const vt=Lt;const Yt={Continue:100,SwitchingProtocols:101,Processing:102,EarlyHints:103,Ok:200,Created:201,Accepted:202,NonAuthoritativeInformation:203,NoContent:204,ResetContent:205,PartialContent:206,MultiStatus:207,AlreadyReported:208,ImUsed:226,MultipleChoices:300,MovedPermanently:301,Found:302,SeeOther:303,NotModified:304,UseProxy:305,Unused:306,TemporaryRedirect:307,PermanentRedirect:308,BadRequest:400,Unauthorized:401,PaymentRequired:402,Forbidden:403,NotFound:404,MethodNotAllowed:405,NotAcceptable:406,ProxyAuthenticationRequired:407,RequestTimeout:408,Conflict:409,Gone:410,LengthRequired:411,PreconditionFailed:412,PayloadTooLarge:413,UriTooLong:414,UnsupportedMediaType:415,RangeNotSatisfiable:416,ExpectationFailed:417,ImATeapot:418,MisdirectedRequest:421,UnprocessableEntity:422,Locked:423,FailedDependency:424,TooEarly:425,UpgradeRequired:426,PreconditionRequired:428,TooManyRequests:429,RequestHeaderFieldsTooLarge:431,UnavailableForLegalReasons:451,InternalServerError:500,NotImplemented:501,BadGateway:502,ServiceUnavailable:503,GatewayTimeout:504,HttpVersionNotSupported:505,VariantAlsoNegotiates:506,InsufficientStorage:507,LoopDetected:508,NotExtended:510,NetworkAuthenticationRequired:511};Object.entries(Yt).forEach((([e,t])=>{Yt[t]=e}));const wt=Yt;const kt=function e(t){const n=new gt(t),r=s(gt.prototype.request,n);return K.extend(r,gt.prototype,n,{allOwnKeys:!0}),K.extend(r,n,null,{allOwnKeys:!0}),r.create=function(n){return e(Je(t,n))},r}(ke);kt.Axios=gt,kt.CanceledError=Pe,kt.CancelToken=vt,kt.isCancel=Ae,kt.VERSION=mt,kt.toFormData=ie,kt.AxiosError=ee,kt.Cancel=kt.CanceledError,kt.all=function(e){return Promise.all(e)},kt.spread=function(e){return function(t){return e.apply(null,t)}},kt.isAxiosError=function(e){return K.isObject(e)&&!0===e.isAxiosError},kt.mergeConfig=Je,kt.AxiosHeaders=xe,kt.formToJSON=e=>Ye(K.isHTMLForm(e)?new FormData(e):e),kt.getAdapter=lt,kt.HttpStatusCode=wt,kt.default=kt;const bt=kt,{Axios:Dt,AxiosError:Tt,CanceledError:St,isCancel:jt,CancelToken:Et,VERSION:xt,all:Ot,Cancel:At,isAxiosError:Ht,spread:Pt,toFormData:Ct,AxiosHeaders:It,HttpStatusCode:Rt,formToJSON:Nt,getAdapter:Ft,mergeConfig:Wt}=bt;var $t=n(63814);const Ut=bt.create({headers:{requesttoken:(0,a.do)()??"","X-Requested-With":"XMLHttpRequest"}});(0,a.zo)((e=>{Ut.defaults.headers.requesttoken=e}));const Bt=Object.assign(Ut,{CancelToken:bt.CancelToken,isCancel:bt.isCancel}),zt=Symbol("csrf-retry");const Jt=Symbol("retryDelay");Bt.interceptors.response.use((e=>e),function(e){return async t=>{if(!Ht(t))throw t;const{config:n,response:r,request:a}=t,s=a?.responseURL;if(n&&!n[zt]&&412===r?.status&&"CSRF check failed"===r?.data?.message){console.warn(`Request to ${s} failed because of a CSRF mismatch. Fetching a new token`);const{data:{token:t}}=await e.get((0,$t.Jv)("/csrftoken"));return console.debug(`New request token ${t} fetched`),e.defaults.headers.requesttoken=t,e({...n,headers:{...n.headers,requesttoken:t},[zt]:!0})}throw t}}(Bt)),Bt.interceptors.response.use((e=>e),function(e){return async t=>{if(!Ht(t))throw t;const{config:n,response:r,request:a}=t,s=a?.responseURL,i=r?.status,o=r?.headers;let d="number"==typeof n?.[Jt]?n?.[Jt]:1;if(503===i&&"1"===o?.["x-nextcloud-maintenance-mode"]&&n?.retryIfMaintenanceMode){if(d*=2,d>32)throw console.error("Retry delay exceeded one minute, giving up.",{responseURL:s}),t;return console.warn(`Request to ${s} failed because of maintenance mode. Retrying in ${d}s`),await new Promise((e=>{setTimeout(e,1e3*d)})),e({...n,[Jt]:d})}throw t}}(Bt)),Bt.interceptors.response.use((e=>e),(async function(e){if(Ht(e)){const{config:t,response:n,request:r}=e,a=r?.responseURL,s=n?.status;401===s&&"Current user is not logged in"===n?.data?.message&&t?.reloadExpiredSession&&window?.location&&(console.error(`Request to ${a} failed because the user session expired. Reloading the page …`),window.location.reload())}throw e}))},50619:(e,t,n)=>{"use strict";n.d(t,{A:()=>r});class r{static GLOBAL_SCOPE_VOLATILE="nextcloud_vol";static GLOBAL_SCOPE_PERSISTENT="nextcloud_per";scope;wrapped;constructor(e,t,n){this.scope=`${n?r.GLOBAL_SCOPE_PERSISTENT:r.GLOBAL_SCOPE_VOLATILE}_${btoa(e)}_`,this.wrapped=t}scopeKey(e){return`${this.scope}${e}`}setItem(e,t){this.wrapped.setItem(this.scopeKey(e),t)}getItem(e){return this.wrapped.getItem(this.scopeKey(e))}removeItem(e){this.wrapped.removeItem(this.scopeKey(e))}clear(){Object.keys(this.wrapped).filter((e=>e.startsWith(this.scope))).map(this.wrapped.removeItem.bind(this.wrapped))}}},42458:(e,t,n)=>{"use strict";n.r(t),n.d(t,{clearAll:()=>o,clearNonPersistent:()=>d,getBuilder:()=>s});var r=n(50619);class a{appId;persisted=!1;clearedOnLogout=!1;constructor(e){this.appId=e}persist(e=!0){return this.persisted=e,this}clearOnLogout(e=!0){return this.clearedOnLogout=e,this}build(){return new r.A(this.appId,this.persisted?window.localStorage:window.sessionStorage,!this.clearedOnLogout)}}function s(e){return new a(e)}function i(e,t){Object.keys(e).filter((e=>!t||t(e))).map(e.removeItem.bind(e))}function o(){[window.sessionStorage,window.localStorage].map((e=>i(e)))}function d(){[window.sessionStorage,window.localStorage].map((e=>i(e,(e=>!e.startsWith(r.A.GLOBAL_SCOPE_PERSISTENT)))))}},61338:(e,t,n)=>{"use strict";n.d(t,{B1:()=>u,Ic:()=>c,al:()=>l});var r=n(56953),a=n(32938);class s{bus;constructor(e){"function"==typeof e.getVersion&&r(e.getVersion())?a(e.getVersion())!==a(this.getVersion())&&console.warn("Proxying an event bus of version "+e.getVersion()+" with "+this.getVersion()):console.warn("Proxying an event bus with an unknown or invalid version"),this.bus=e}getVersion(){return"3.3.2"}subscribe(e,t){this.bus.subscribe(e,t)}unsubscribe(e,t){this.bus.unsubscribe(e,t)}emit(e,...t){this.bus.emit(e,...t)}}class i{handlers=new Map;getVersion(){return"3.3.2"}subscribe(e,t){this.handlers.set(e,(this.handlers.get(e)||[]).concat(t))}unsubscribe(e,t){this.handlers.set(e,(this.handlers.get(e)||[]).filter((e=>e!==t)))}emit(e,...t){(this.handlers.get(e)||[]).forEach((e=>{try{e(t[0])}catch(e){console.error("could not invoke event listener",e)}}))}}let o=null;function d(){return null!==o?o:"undefined"==typeof window?new Proxy({},{get:()=>()=>console.error("Window not available, EventBus can not be established!")}):(window.OC?._eventBus&&void 0===window._nc_event_bus&&(console.warn("found old event bus instance at OC._eventBus. Update your version!"),window._nc_event_bus=window.OC._eventBus),o=void 0!==window?._nc_event_bus?new s(window._nc_event_bus):window._nc_event_bus=new i,o)}function u(e,t){d().subscribe(e,t)}function l(e,t){d().unsubscribe(e,t)}function c(e,...t){d().emit(e,...t)}},32981:(e,t,n)=>{"use strict";function r(e,t,n){const r=document.querySelector(`#initial-state-${e}-${t}`);if(null===r){if(void 0!==n)return n;throw new Error(`Could not find initial state ${t} of ${e}`)}try{return JSON.parse(atob(r.value))}catch(n){throw new Error(`Could not parse initial state ${t} of ${e}`)}}n.d(t,{C:()=>r})},93839:(e,t,n)=>{"use strict";n.d(t,{a:()=>o,b:()=>s,d:()=>c,e:()=>_,g:()=>i,i:()=>d,t:()=>l});var r=n(99418),a=n(70580);function s(){return globalThis._nc_l10n_locale}function i(){return s().replaceAll(/_/g,"-")}function o(){return globalThis._nc_l10n_language}function d(e){const t=e||o();return["ae","ar","arc","arz","bcc","bqi","ckb","dv","fa","glk","ha","he","khw","ks","ku","mzn","nqo","pnb","ps","sd","ug","ur","ur-PK","uz-AF","yi"].includes(t)}function u(e){return{translations:globalThis._oc_l10n_registry_translations[e]??{},pluralFunction:globalThis._oc_l10n_registry_plural_functions[e]??(e=>e)}}function l(e,t,n,s,i){const o="object"==typeof n?n:void 0,d="number"==typeof s?s:"number"==typeof n?n:void 0,l={escape:!0,sanitize:!0,..."object"==typeof i?i:"object"==typeof s?s:{}},c=e=>e,_=(l.sanitize?r.A.sanitize:c)||c,m=l.escape?a:c,h=e=>"string"==typeof e||"number"==typeof e;let f=(i?.bundle??u(e)).translations[t]||t;return f=Array.isArray(f)?f[0]:f,_("object"==typeof o||void 0!==d?(p=o,y=d,f.replace(/%n/g,""+y).replace(/{([^{}]*)}/g,((e,t)=>{if(void 0===p||!(t in p))return m(e);const n=p[t];return h(n)?m(`${n}`):"object"==typeof n&&h(n.value)?(!1!==n.escape?a:c)(`${n.value}`):m(e)}))):f);var p,y}function c(e,t,n,r,a,s){const i="_"+t+"_::_"+n+"_",o=s?.bundle??u(e),d=o.translations[i];if(void 0!==d){const t=d;if(Array.isArray(t)){return l(e,t[o.pluralFunction(r)],a,r,s)}}return l(e,1===r?t:n,a,r,s)}function _(e,t=o()){switch("pt-BR"===t&&(t="xbr"),t.length>3&&(t=t.substring(0,t.lastIndexOf("-"))),t){case"az":case"bo":case"dz":case"id":case"ja":case"jv":case"ka":case"km":case"kn":case"ko":case"ms":case"th":case"tr":case"vi":case"zh":default:return 0;case"af":case"bn":case"bg":case"ca":case"da":case"de":case"el":case"en":case"eo":case"es":case"et":case"eu":case"fa":case"fi":case"fo":case"fur":case"fy":case"gl":case"gu":case"ha":case"he":case"hu":case"is":case"it":case"ku":case"lb":case"ml":case"mn":case"mr":case"nah":case"nb":case"ne":case"nl":case"nn":case"no":case"oc":case"om":case"or":case"pa":case"pap":case"ps":case"pt":case"so":case"sq":case"sv":case"sw":case"ta":case"te":case"tk":case"ur":case"zu":return 1===e?0:1;case"am":case"bh":case"fil":case"fr":case"gun":case"hi":case"hy":case"ln":case"mg":case"nso":case"xbr":case"ti":case"wa":return 0===e||1===e?0:1;case"be":case"bs":case"hr":case"ru":case"sh":case"sr":case"uk":return e%10==1&&e%100!=11?0:e%10>=2&&e%10<=4&&(e%100<10||e%100>=20)?1:2;case"cs":case"sk":return 1===e?0:e>=2&&e<=4?1:2;case"ga":return 1===e?0:2===e?1:2;case"lt":return e%10==1&&e%100!=11?0:e%10>=2&&(e%100<10||e%100>=20)?1:2;case"sl":return e%100==1?0:e%100==2?1:e%100==3||e%100==4?2:3;case"mk":return e%10==1?0:1;case"mt":return 1===e?0:0===e||e%100>1&&e%100<11?1:e%100>10&&e%100<20?2:3;case"lv":return 0===e?0:e%10==1&&e%100!=11?1:2;case"pl":return 1===e?0:e%10>=2&&e%10<=4&&(e%100<12||e%100>14)?1:2;case"cy":return 1===e?0:2===e?1:8===e||11===e?2:3;case"ro":return 1===e?0:0===e||e%100>0&&e%100<20?1:2;case"ar":return 0===e?0:1===e?1:2===e?2:e%100>=3&&e%100<=10?3:e%100>=11&&e%100<=99?4:5}}globalThis._nc_l10n_locale??="undefined"!=typeof document&&document.documentElement.dataset.locale||Intl.DateTimeFormat().resolvedOptions().locale.replaceAll(/-/g,"_"),globalThis._nc_l10n_language??="undefined"!=typeof document&&document.documentElement.lang||(globalThis.navigator?.language??"en"),globalThis._oc_l10n_registry_translations??={},globalThis._oc_l10n_registry_plural_functions??={}},53334:(e,t,n)=>{"use strict";n.d(t,{$X:()=>i,JK:()=>r.b,JN:()=>a,Pe:()=>o,Tl:()=>r.t,V8:()=>r.i,Z0:()=>r.a,fL:()=>d,fw:()=>l,hY:()=>s,lG:()=>u,lO:()=>r.g,zw:()=>r.d});var r=n(93839);function a(){if(void 0!==globalThis.firstDay)return globalThis.firstDay;const e=new Intl.Locale((0,r.g)()),t=e.getWeekInfo?.()??e.weekInfo;return t?t.firstDay%7:1}function s(){if(void 0!==globalThis.dayNames)return globalThis.dayNames;const e=(0,r.g)();return[new Date("1970-01-04T00:00:00.000Z").toLocaleDateString(e,{weekday:"long"}),new Date("1970-01-05T00:00:00.000Z").toLocaleDateString(e,{weekday:"long"}),new Date("1970-01-06T00:00:00.000Z").toLocaleDateString(e,{weekday:"long"}),new Date("1970-01-07T00:00:00.000Z").toLocaleDateString(e,{weekday:"long"}),new Date("1970-01-08T00:00:00.000Z").toLocaleDateString(e,{weekday:"long"}),new Date("1970-01-09T00:00:00.000Z").toLocaleDateString(e,{weekday:"long"}),new Date("1970-01-10T00:00:00.000Z").toLocaleDateString(e,{weekday:"long"})]}function i(){if(void 0!==globalThis.dayNamesShort)return globalThis.dayNamesShort;const e=(0,r.g)();return[new Date("1970-01-04T00:00:00.000Z").toLocaleDateString(e,{weekday:"short"}),new Date("1970-01-05T00:00:00.000Z").toLocaleDateString(e,{weekday:"short"}),new Date("1970-01-06T00:00:00.000Z").toLocaleDateString(e,{weekday:"short"}),new Date("1970-01-07T00:00:00.000Z").toLocaleDateString(e,{weekday:"short"}),new Date("1970-01-08T00:00:00.000Z").toLocaleDateString(e,{weekday:"short"}),new Date("1970-01-09T00:00:00.000Z").toLocaleDateString(e,{weekday:"short"}),new Date("1970-01-10T00:00:00.000Z").toLocaleDateString(e,{weekday:"short"})]}function o(){if(void 0!==globalThis.dayNamesMin)return globalThis.dayNamesMin;const e=(0,r.g)();return[new Date("1970-01-04T00:00:00.000Z").toLocaleDateString(e,{weekday:"narrow"}),new Date("1970-01-05T00:00:00.000Z").toLocaleDateString(e,{weekday:"narrow"}),new Date("1970-01-06T00:00:00.000Z").toLocaleDateString(e,{weekday:"narrow"}),new Date("1970-01-07T00:00:00.000Z").toLocaleDateString(e,{weekday:"narrow"}),new Date("1970-01-08T00:00:00.000Z").toLocaleDateString(e,{weekday:"narrow"}),new Date("1970-01-09T00:00:00.000Z").toLocaleDateString(e,{weekday:"narrow"}),new Date("1970-01-10T00:00:00.000Z").toLocaleDateString(e,{weekday:"narrow"})]}function d(){if(void 0!==globalThis.monthNames)return globalThis.monthNames;const e=(0,r.g)();return[new Date("1970-01-01T00:00:00.000Z").toLocaleDateString(e,{month:"long"}),new Date("1970-02-01T00:00:00.000Z").toLocaleDateString(e,{month:"long"}),new Date("1970-03-01T00:00:00.000Z").toLocaleDateString(e,{month:"long"}),new Date("1970-04-01T00:00:00.000Z").toLocaleDateString(e,{month:"long"}),new Date("1970-05-01T00:00:00.000Z").toLocaleDateString(e,{month:"long"}),new Date("1970-06-01T00:00:00.000Z").toLocaleDateString(e,{month:"long"}),new Date("1970-07-01T00:00:00.000Z").toLocaleDateString(e,{month:"long"}),new Date("1970-08-01T00:00:00.000Z").toLocaleDateString(e,{month:"long"}),new Date("1970-09-01T00:00:00.000Z").toLocaleDateString(e,{month:"long"}),new Date("1970-10-01T00:00:00.000Z").toLocaleDateString(e,{month:"long"}),new Date("1970-11-01T00:00:00.000Z").toLocaleDateString(e,{month:"long"}),new Date("1970-12-01T00:00:00.000Z").toLocaleDateString(e,{month:"long"})]}function u(){if(void 0!==globalThis.monthNamesShort)return globalThis.monthNamesShort;const e=(0,r.g)();return[new Date("1970-01-01T00:00:00.000Z").toLocaleDateString(e,{month:"short"}),new Date("1970-02-01T00:00:00.000Z").toLocaleDateString(e,{month:"short"}),new Date("1970-03-01T00:00:00.000Z").toLocaleDateString(e,{month:"short"}),new Date("1970-04-01T00:00:00.000Z").toLocaleDateString(e,{month:"short"}),new Date("1970-05-01T00:00:00.000Z").toLocaleDateString(e,{month:"short"}),new Date("1970-06-01T00:00:00.000Z").toLocaleDateString(e,{month:"short"}),new Date("1970-07-01T00:00:00.000Z").toLocaleDateString(e,{month:"short"}),new Date("1970-08-01T00:00:00.000Z").toLocaleDateString(e,{month:"short"}),new Date("1970-09-01T00:00:00.000Z").toLocaleDateString(e,{month:"short"}),new Date("1970-10-01T00:00:00.000Z").toLocaleDateString(e,{month:"short"}),new Date("1970-11-01T00:00:00.000Z").toLocaleDateString(e,{month:"short"}),new Date("1970-12-01T00:00:00.000Z").toLocaleDateString(e,{month:"short"})]}function l(e=Date.now(),t={}){const n={ignoreSeconds:!1,language:(0,r.a)(),relativeTime:"long",...t},a=new Date(e),s=new Intl.RelativeTimeFormat([n.language,(0,r.a)()],{numeric:"auto",style:n.relativeTime}),i=(a.getTime()-Date.now())/1e3;if(Math.abs(i)<59.5)return n.ignoreSeconds||s.format(Math.round(i),"second");const o=i/60;if(Math.abs(o)<=59)return s.format(Math.round(o),"minute");const d=o/60;if(Math.abs(d)<23.5)return s.format(Math.round(d),"hour");const u=d/24;if(Math.abs(u)<6.5)return s.format(Math.round(u),"day");if(Math.abs(u)<27.5){const e=u/7;return s.format(Math.round(e),"week")}const l=u/30,c=Math.abs(l)<11?{month:n.relativeTime,day:"numeric"}:{year:"narrow"===n.relativeTime?"2-digit":"numeric",month:n.relativeTime};return new Intl.DateTimeFormat([n.language,(0,r.a)()],c).format(a)}},35947:(e,t,n)=>{"use strict";n.d(t,{YK:()=>_});var r=n(21777),a=(e=>(e[e.Debug=0]="Debug",e[e.Info=1]="Info",e[e.Warn=2]="Warn",e[e.Error=3]="Error",e[e.Fatal=4]="Fatal",e))(a||{}),s=Object.defineProperty,i=(e,t,n)=>(((e,t,n)=>{t in e?s(e,t,{enumerable:!0,configurable:!0,writable:!0,value:n}):e[t]=n})(e,"symbol"!=typeof t?t+"":t,n),n);class o{constructor(e){i(this,"context"),this.context=e||{}}formatMessage(e,t,n){let r="["+a[t].toUpperCase()+"] ";return n&&n.app&&(r+=n.app+": "),"string"==typeof e?r+e:(r+="Unexpected ".concat(e.name),e.message&&(r+=' "'.concat(e.message,'"')),t===a.Debug&&e.stack&&(r+="\n\nStack trace:\n".concat(e.stack)),r)}log(e,t,n){var r,s;if(!("number"==typeof(null==(r=this.context)?void 0:r.level)&&e<(null==(s=this.context)?void 0:s.level)))switch("object"==typeof t&&void 0===(null==n?void 0:n.error)&&(n.error=t),e){case a.Debug:console.debug(this.formatMessage(t,a.Debug,n),n);break;case a.Info:console.info(this.formatMessage(t,a.Info,n),n);break;case a.Warn:console.warn(this.formatMessage(t,a.Warn,n),n);break;case a.Error:console.error(this.formatMessage(t,a.Error,n),n);break;case a.Fatal:default:console.error(this.formatMessage(t,a.Fatal,n),n)}}debug(e,t){this.log(a.Debug,e,Object.assign({},this.context,t))}info(e,t){this.log(a.Info,e,Object.assign({},this.context,t))}warn(e,t){this.log(a.Warn,e,Object.assign({},this.context,t))}error(e,t){this.log(a.Error,e,Object.assign({},this.context,t))}fatal(e,t){this.log(a.Fatal,e,Object.assign({},this.context,t))}}function d(e){return new o(e)}var u=Object.defineProperty,l=(e,t,n)=>(((e,t,n)=>{t in e?u(e,t,{enumerable:!0,configurable:!0,writable:!0,value:n}):e[t]=n})(e,"symbol"!=typeof t?t+"":t,n),n);class c{constructor(e){l(this,"context"),l(this,"factory"),this.context={},this.factory=e}setApp(e){return this.context.app=e,this}setLogLevel(e){return this.context.level=e,this}setUid(e){return this.context.uid=e,this}detectUser(){const e=(0,r.HW)();return null!==e&&(this.context.uid=e.uid),this}detectLogLevel(){const e=this,t=()=>{var n,r;"complete"===document.readyState||"interactive"===document.readyState?(e.context.level=null!=(r=null==(n=window._oc_config)?void 0:n.loglevel)?r:a.Warn,window._oc_debug&&(e.context.level=a.Debug),document.removeEventListener("readystatechange",t)):document.addEventListener("readystatechange",t)};return t(),this}build(){return void 0===this.context.level&&this.detectLogLevel(),this.factory(this.context)}}function _(){return new c(d)}},63814:(e,t,n)=>{"use strict";n.d(t,{$_:()=>u,Jv:()=>i,KT:()=>a,aU:()=>l,d0:()=>o,dC:()=>r,fg:()=>d});const r=(e,t)=>{var n;return(null!=(n=null==t?void 0:t.baseURL)?n:u())+(e=>"/remote.php/"+e)(e)},a=(e,t,n)=>{var r;const a=1===Object.assign({ocsVersion:2},n||{}).ocsVersion?1:2;return(null!=(r=null==n?void 0:n.baseURL)?r:u())+"/ocs/v"+a+".php"+s(e,t,n)},s=(e,t,n)=>{const r=Object.assign({escape:!0},n||{});return"/"!==e.charAt(0)&&(e="/"+e),a=(a=t||{})||{},e.replace(/{([^{}]*)}/g,(function(e,t){const n=a[t];return r.escape?encodeURIComponent("string"==typeof n||"number"==typeof n?n.toString():e):"string"==typeof n||"number"==typeof n?n.toString():e}));var a},i=(e,t,n)=>{var r,a,i;const o=Object.assign({noRewrite:!1},n||{}),d=null!=(r=null==n?void 0:n.baseURL)?r:l();return!0!==(null==(i=null==(a=null==window?void 0:window.OC)?void 0:a.config)?void 0:i.modRewriteWorking)||o.noRewrite?d+"/index.php"+s(e,t,n):d+s(e,t,n)},o=(e,t)=>t.includes(".")?d(e,"img",t):d(e,"img","".concat(t,".svg")),d=(e,t,n)=>{var r,a,s;const i=null!=(s=null==(a=null==(r=null==window?void 0:window.OC)?void 0:r.coreApps)?void 0:a.includes(e))&&s,o="php"===n.slice(-3);let d=l();return o&&!i?(d+="/index.php/apps/".concat(e),t&&(d+="/".concat(encodeURI(t))),"index.php"!==n&&(d+="/".concat(n))):o||i?(("settings"===e||"core"===e||"search"===e)&&"ajax"===t&&(d+="/index.php"),e&&(d+="/".concat(e)),t&&(d+="/".concat(t)),d+="/".concat(n)):(d=function(e){var t,n;return null!=(n=(null!=(t=window._oc_appswebroots)?t:{})[e])?n:""}(e),t&&(d+="/".concat(t,"/")),"/"!==d.at(-1)&&(d+="/"),d+=n),d},u=()=>window.location.protocol+"//"+window.location.host+l();function l(){let e=window._oc_webroot;if(typeof e>"u"){e=location.pathname;const t=e.indexOf("/index.php/");if(-1!==t)e=e.slice(0,t);else{const t=e.indexOf("/",1);e=e.slice(0,t>0?t:void 0)}}return e}},52781:(e,t,n)=>{"use strict";n.d(t,{N:()=>l,a:()=>s,b:()=>f,c:()=>c,d:()=>i,e:()=>m,f:()=>h,g:()=>_,h:()=>d,i:()=>o,j:()=>u,r:()=>a});var r=n(3168);function a(e,t,n=()=>{},a){const s={hasInteractiveView:!0,fullWidth:!1,...a};window._vue_richtext_widgets[e]?r.l.error(`[ReferencePicker]: Widget for id ${e} already registered`):window._vue_richtext_widgets[e]={id:e,callback:t,onDestroy:n,...s}}function s(e,t){const{richObjectType:n,richObject:a,accessible:s,interactive:i}=t;"open-graph"!==n&&(window._vue_richtext_widgets[n]?window._vue_richtext_widgets[n].callback(e,{richObjectType:n,richObject:a,accessible:s,interactive:i}):r.l.error("Widget for rich object type "+n+" not registered"))}function i(e,t){"open-graph"!==e&&window._vue_richtext_widgets[e]&&window._vue_richtext_widgets[e].onDestroy(t)}function o(e){return!!window._vue_richtext_widgets[e]}function d(e){return!!window._vue_richtext_widgets[e]?.hasInteractiveView}function u(e){return!!window._vue_richtext_widgets[e]?.fullWidth}window._vue_richtext_widgets??={},window._registerWidget??=(e,t,n,r)=>{a(e,t,n,r)},window._vue_richtext_custom_picker_elements??={},window._registerCustomPickerElement??=m;class l{element;object;constructor(e,t){this.element=e,this.object=t}}function c(e){return!!window._vue_richtext_custom_picker_elements[e]}function _(e){const t=window._vue_richtext_custom_picker_elements[e]?.size;return["small","normal","large","full"].includes(t)?t:null}function m(e,t,n=()=>{},a="large"){window._vue_richtext_custom_picker_elements[e]?r.l.error(`Custom reference picker element for id ${e} already registered`):window._vue_richtext_custom_picker_elements[e]={id:e,callback:t,onDestroy:n,size:a}}function h(e,t){const{providerId:n,accessible:a}=t;if(window._vue_richtext_custom_picker_elements[n])return window._vue_richtext_custom_picker_elements[n].callback(e,{providerId:n,accessible:a});r.l.error(`Custom reference picker element for reference provider ID ${n} not registered`)}function f(e,t,n){window._vue_richtext_custom_picker_elements[e]&&window._vue_richtext_custom_picker_elements[e].onDestroy(t,n)}},3168:(e,t,n)=>{"use strict";n.d(t,{l:()=>r});const r=(0,n(35947).YK)().detectUser().setApp("@nextcloud/vue").build()},99418:(e,t,n)=>{"use strict";n.d(t,{A:()=>oe});const{entries:r,setPrototypeOf:a,isFrozen:s,getPrototypeOf:i,getOwnPropertyDescriptor:o}=Object;let{freeze:d,seal:u,create:l}=Object,{apply:c,construct:_}="undefined"!=typeof Reflect&&Reflect;d||(d=function(e){return e}),u||(u=function(e){return e}),c||(c=function(e,t){for(var n=arguments.length,r=new Array(n>2?n-2:0),a=2;a<n;a++)r[a-2]=arguments[a];return e.apply(t,r)}),_||(_=function(e){for(var t=arguments.length,n=new Array(t>1?t-1:0),r=1;r<t;r++)n[r-1]=arguments[r];return new e(...n)});const m=S(Array.prototype.forEach),h=S(Array.prototype.lastIndexOf),f=S(Array.prototype.pop),p=S(Array.prototype.push),y=S(Array.prototype.splice),M=S(String.prototype.toLowerCase),g=S(String.prototype.toString),L=S(String.prototype.match),v=S(String.prototype.replace),Y=S(String.prototype.indexOf),w=S(String.prototype.trim),k=S(Object.prototype.hasOwnProperty),b=S(RegExp.prototype.test),D=(T=TypeError,function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return _(T,t)});var T;function S(e){return function(t){t instanceof RegExp&&(t.lastIndex=0);for(var n=arguments.length,r=new Array(n>1?n-1:0),a=1;a<n;a++)r[a-1]=arguments[a];return c(e,t,r)}}function j(e,t){let n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:M;a&&a(e,null);let r=t.length;for(;r--;){let a=t[r];if("string"==typeof a){const e=n(a);e!==a&&(s(t)||(t[r]=e),a=e)}e[a]=!0}return e}function E(e){for(let t=0;t<e.length;t++){k(e,t)||(e[t]=null)}return e}function x(e){const t=l(null);for(const[n,a]of r(e)){k(e,n)&&(Array.isArray(a)?t[n]=E(a):a&&"object"==typeof a&&a.constructor===Object?t[n]=x(a):t[n]=a)}return t}function O(e,t){for(;null!==e;){const n=o(e,t);if(n){if(n.get)return S(n.get);if("function"==typeof n.value)return S(n.value)}e=i(e)}return function(){return null}}const A=d(["a","abbr","acronym","address","area","article","aside","audio","b","bdi","bdo","big","blink","blockquote","body","br","button","canvas","caption","center","cite","code","col","colgroup","content","data","datalist","dd","decorator","del","details","dfn","dialog","dir","div","dl","dt","element","em","fieldset","figcaption","figure","font","footer","form","h1","h2","h3","h4","h5","h6","head","header","hgroup","hr","html","i","img","input","ins","kbd","label","legend","li","main","map","mark","marquee","menu","menuitem","meter","nav","nobr","ol","optgroup","option","output","p","picture","pre","progress","q","rp","rt","ruby","s","samp","search","section","select","shadow","slot","small","source","spacer","span","strike","strong","style","sub","summary","sup","table","tbody","td","template","textarea","tfoot","th","thead","time","tr","track","tt","u","ul","var","video","wbr"]),H=d(["svg","a","altglyph","altglyphdef","altglyphitem","animatecolor","animatemotion","animatetransform","circle","clippath","defs","desc","ellipse","enterkeyhint","exportparts","filter","font","g","glyph","glyphref","hkern","image","inputmode","line","lineargradient","marker","mask","metadata","mpath","part","path","pattern","polygon","polyline","radialgradient","rect","stop","style","switch","symbol","text","textpath","title","tref","tspan","view","vkern"]),P=d(["feBlend","feColorMatrix","feComponentTransfer","feComposite","feConvolveMatrix","feDiffuseLighting","feDisplacementMap","feDistantLight","feDropShadow","feFlood","feFuncA","feFuncB","feFuncG","feFuncR","feGaussianBlur","feImage","feMerge","feMergeNode","feMorphology","feOffset","fePointLight","feSpecularLighting","feSpotLight","feTile","feTurbulence"]),C=d(["animate","color-profile","cursor","discard","font-face","font-face-format","font-face-name","font-face-src","font-face-uri","foreignobject","hatch","hatchpath","mesh","meshgradient","meshpatch","meshrow","missing-glyph","script","set","solidcolor","unknown","use"]),I=d(["math","menclose","merror","mfenced","mfrac","mglyph","mi","mlabeledtr","mmultiscripts","mn","mo","mover","mpadded","mphantom","mroot","mrow","ms","mspace","msqrt","mstyle","msub","msup","msubsup","mtable","mtd","mtext","mtr","munder","munderover","mprescripts"]),R=d(["maction","maligngroup","malignmark","mlongdiv","mscarries","mscarry","msgroup","mstack","msline","msrow","semantics","annotation","annotation-xml","mprescripts","none"]),N=d(["#text"]),F=d(["accept","action","align","alt","autocapitalize","autocomplete","autopictureinpicture","autoplay","background","bgcolor","border","capture","cellpadding","cellspacing","checked","cite","class","clear","color","cols","colspan","controls","controlslist","coords","crossorigin","datetime","decoding","default","dir","disabled","disablepictureinpicture","disableremoteplayback","download","draggable","enctype","enterkeyhint","exportparts","face","for","headers","height","hidden","high","href","hreflang","id","inert","inputmode","integrity","ismap","kind","label","lang","list","loading","loop","low","max","maxlength","media","method","min","minlength","multiple","muted","name","nonce","noshade","novalidate","nowrap","open","optimum","part","pattern","placeholder","playsinline","popover","popovertarget","popovertargetaction","poster","preload","pubdate","radiogroup","readonly","rel","required","rev","reversed","role","rows","rowspan","spellcheck","scope","selected","shape","size","sizes","slot","span","srclang","start","src","srcset","step","style","summary","tabindex","title","translate","type","usemap","valign","value","width","wrap","xmlns","slot"]),W=d(["accent-height","accumulate","additive","alignment-baseline","amplitude","ascent","attributename","attributetype","azimuth","basefrequency","baseline-shift","begin","bias","by","class","clip","clippathunits","clip-path","clip-rule","color","color-interpolation","color-interpolation-filters","color-profile","color-rendering","cx","cy","d","dx","dy","diffuseconstant","direction","display","divisor","dur","edgemode","elevation","end","exponent","fill","fill-opacity","fill-rule","filter","filterunits","flood-color","flood-opacity","font-family","font-size","font-size-adjust","font-stretch","font-style","font-variant","font-weight","fx","fy","g1","g2","glyph-name","glyphref","gradientunits","gradienttransform","height","href","id","image-rendering","in","in2","intercept","k","k1","k2","k3","k4","kerning","keypoints","keysplines","keytimes","lang","lengthadjust","letter-spacing","kernelmatrix","kernelunitlength","lighting-color","local","marker-end","marker-mid","marker-start","markerheight","markerunits","markerwidth","maskcontentunits","maskunits","max","mask","mask-type","media","method","mode","min","name","numoctaves","offset","operator","opacity","order","orient","orientation","origin","overflow","paint-order","path","pathlength","patterncontentunits","patterntransform","patternunits","points","preservealpha","preserveaspectratio","primitiveunits","r","rx","ry","radius","refx","refy","repeatcount","repeatdur","restart","result","rotate","scale","seed","shape-rendering","slope","specularconstant","specularexponent","spreadmethod","startoffset","stddeviation","stitchtiles","stop-color","stop-opacity","stroke-dasharray","stroke-dashoffset","stroke-linecap","stroke-linejoin","stroke-miterlimit","stroke-opacity","stroke","stroke-width","style","surfacescale","systemlanguage","tabindex","tablevalues","targetx","targety","transform","transform-origin","text-anchor","text-decoration","text-rendering","textlength","type","u1","u2","unicode","values","viewbox","visibility","version","vert-adv-y","vert-origin-x","vert-origin-y","width","word-spacing","wrap","writing-mode","xchannelselector","ychannelselector","x","x1","x2","xmlns","y","y1","y2","z","zoomandpan"]),$=d(["accent","accentunder","align","bevelled","close","columnsalign","columnlines","columnspan","denomalign","depth","dir","display","displaystyle","encoding","fence","frame","height","href","id","largeop","length","linethickness","lspace","lquote","mathbackground","mathcolor","mathsize","mathvariant","maxsize","minsize","movablelimits","notation","numalign","open","rowalign","rowlines","rowspacing","rowspan","rspace","rquote","scriptlevel","scriptminsize","scriptsizemultiplier","selection","separator","separators","stretchy","subscriptshift","supscriptshift","symmetric","voffset","width","xmlns"]),U=d(["xlink:href","xml:id","xlink:title","xml:space","xmlns:xlink"]),B=u(/\{\{[\w\W]*|[\w\W]*\}\}/gm),z=u(/<%[\w\W]*|[\w\W]*%>/gm),J=u(/\$\{[\w\W]*/gm),G=u(/^data-[\-\w.\u00B7-\uFFFF]+$/),V=u(/^aria-[\-\w]+$/),q=u(/^(?:(?:(?:f|ht)tps?|mailto|tel|callto|sms|cid|xmpp|matrix):|[^a-z]|[a-z+.\-]+(?:[^a-z+.\-:]|$))/i),K=u(/^(?:\w+script|data):/i),Z=u(/[\u0000-\u0020\u00A0\u1680\u180E\u2000-\u2029\u205F\u3000]/g),X=u(/^html$/i),Q=u(/^[a-z][.\w]*(-[.\w]+)+$/i);var ee=Object.freeze({__proto__:null,ARIA_ATTR:V,ATTR_WHITESPACE:Z,CUSTOM_ELEMENT:Q,DATA_ATTR:G,DOCTYPE_NAME:X,ERB_EXPR:z,IS_ALLOWED_URI:q,IS_SCRIPT_OR_DATA:K,MUSTACHE_EXPR:B,TMPLIT_EXPR:J});const te=1,ne=3,re=7,ae=8,se=9,ie=function(){return"undefined"==typeof window?null:window};var oe=function e(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:ie();const n=t=>e(t);if(n.version="3.3.0",n.removed=[],!t||!t.document||t.document.nodeType!==se||!t.Element)return n.isSupported=!1,n;let{document:a}=t;const s=a,i=s.currentScript,{DocumentFragment:o,HTMLTemplateElement:u,Node:c,Element:_,NodeFilter:T,NamedNodeMap:S=t.NamedNodeMap||t.MozNamedAttrMap,HTMLFormElement:E,DOMParser:B,trustedTypes:z}=t,J=_.prototype,G=O(J,"cloneNode"),V=O(J,"remove"),K=O(J,"nextSibling"),Z=O(J,"childNodes"),Q=O(J,"parentNode");if("function"==typeof u){const e=a.createElement("template");e.content&&e.content.ownerDocument&&(a=e.content.ownerDocument)}let oe,de="";const{implementation:ue,createNodeIterator:le,createDocumentFragment:ce,getElementsByTagName:_e}=a,{importNode:me}=s;let he={afterSanitizeAttributes:[],afterSanitizeElements:[],afterSanitizeShadowDOM:[],beforeSanitizeAttributes:[],beforeSanitizeElements:[],beforeSanitizeShadowDOM:[],uponSanitizeAttribute:[],uponSanitizeElement:[],uponSanitizeShadowNode:[]};n.isSupported="function"==typeof r&&"function"==typeof Q&&ue&&void 0!==ue.createHTMLDocument;const{MUSTACHE_EXPR:fe,ERB_EXPR:pe,TMPLIT_EXPR:ye,DATA_ATTR:Me,ARIA_ATTR:ge,IS_SCRIPT_OR_DATA:Le,ATTR_WHITESPACE:ve,CUSTOM_ELEMENT:Ye}=ee;let{IS_ALLOWED_URI:we}=ee,ke=null;const be=j({},[...A,...H,...P,...I,...N]);let De=null;const Te=j({},[...F,...W,...$,...U]);let Se=Object.seal(l(null,{tagNameCheck:{writable:!0,configurable:!1,enumerable:!0,value:null},attributeNameCheck:{writable:!0,configurable:!1,enumerable:!0,value:null},allowCustomizedBuiltInElements:{writable:!0,configurable:!1,enumerable:!0,value:!1}})),je=null,Ee=null;const xe=Object.seal(l(null,{tagCheck:{writable:!0,configurable:!1,enumerable:!0,value:null},attributeCheck:{writable:!0,configurable:!1,enumerable:!0,value:null}}));let Oe=!0,Ae=!0,He=!1,Pe=!0,Ce=!1,Ie=!0,Re=!1,Ne=!1,Fe=!1,We=!1,$e=!1,Ue=!1,Be=!0,ze=!1,Je=!0,Ge=!1,Ve={},qe=null;const Ke=j({},["annotation-xml","audio","colgroup","desc","foreignobject","head","iframe","math","mi","mn","mo","ms","mtext","noembed","noframes","noscript","plaintext","script","style","svg","template","thead","title","video","xmp"]);let Ze=null;const Xe=j({},["audio","video","img","source","image","track"]);let Qe=null;const et=j({},["alt","class","for","id","label","name","pattern","placeholder","role","summary","title","value","style","xmlns"]),tt="http://www.w3.org/1998/Math/MathML",nt="http://www.w3.org/2000/svg",rt="http://www.w3.org/1999/xhtml";let at=rt,st=!1,it=null;const ot=j({},[tt,nt,rt],g);let dt=j({},["mi","mo","mn","ms","mtext"]),ut=j({},["annotation-xml"]);const lt=j({},["title","style","font","a","script"]);let ct=null;const _t=["application/xhtml+xml","text/html"];let mt=null,ht=null;const ft=a.createElement("form"),pt=function(e){return e instanceof RegExp||e instanceof Function},yt=function(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};if(!ht||ht!==e){if(e&&"object"==typeof e||(e={}),e=x(e),ct=-1===_t.indexOf(e.PARSER_MEDIA_TYPE)?"text/html":e.PARSER_MEDIA_TYPE,mt="application/xhtml+xml"===ct?g:M,ke=k(e,"ALLOWED_TAGS")?j({},e.ALLOWED_TAGS,mt):be,De=k(e,"ALLOWED_ATTR")?j({},e.ALLOWED_ATTR,mt):Te,it=k(e,"ALLOWED_NAMESPACES")?j({},e.ALLOWED_NAMESPACES,g):ot,Qe=k(e,"ADD_URI_SAFE_ATTR")?j(x(et),e.ADD_URI_SAFE_ATTR,mt):et,Ze=k(e,"ADD_DATA_URI_TAGS")?j(x(Xe),e.ADD_DATA_URI_TAGS,mt):Xe,qe=k(e,"FORBID_CONTENTS")?j({},e.FORBID_CONTENTS,mt):Ke,je=k(e,"FORBID_TAGS")?j({},e.FORBID_TAGS,mt):x({}),Ee=k(e,"FORBID_ATTR")?j({},e.FORBID_ATTR,mt):x({}),Ve=!!k(e,"USE_PROFILES")&&e.USE_PROFILES,Oe=!1!==e.ALLOW_ARIA_ATTR,Ae=!1!==e.ALLOW_DATA_ATTR,He=e.ALLOW_UNKNOWN_PROTOCOLS||!1,Pe=!1!==e.ALLOW_SELF_CLOSE_IN_ATTR,Ce=e.SAFE_FOR_TEMPLATES||!1,Ie=!1!==e.SAFE_FOR_XML,Re=e.WHOLE_DOCUMENT||!1,We=e.RETURN_DOM||!1,$e=e.RETURN_DOM_FRAGMENT||!1,Ue=e.RETURN_TRUSTED_TYPE||!1,Fe=e.FORCE_BODY||!1,Be=!1!==e.SANITIZE_DOM,ze=e.SANITIZE_NAMED_PROPS||!1,Je=!1!==e.KEEP_CONTENT,Ge=e.IN_PLACE||!1,we=e.ALLOWED_URI_REGEXP||q,at=e.NAMESPACE||rt,dt=e.MATHML_TEXT_INTEGRATION_POINTS||dt,ut=e.HTML_INTEGRATION_POINTS||ut,Se=e.CUSTOM_ELEMENT_HANDLING||{},e.CUSTOM_ELEMENT_HANDLING&&pt(e.CUSTOM_ELEMENT_HANDLING.tagNameCheck)&&(Se.tagNameCheck=e.CUSTOM_ELEMENT_HANDLING.tagNameCheck),e.CUSTOM_ELEMENT_HANDLING&&pt(e.CUSTOM_ELEMENT_HANDLING.attributeNameCheck)&&(Se.attributeNameCheck=e.CUSTOM_ELEMENT_HANDLING.attributeNameCheck),e.CUSTOM_ELEMENT_HANDLING&&"boolean"==typeof e.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements&&(Se.allowCustomizedBuiltInElements=e.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements),Ce&&(Ae=!1),$e&&(We=!0),Ve&&(ke=j({},N),De=[],!0===Ve.html&&(j(ke,A),j(De,F)),!0===Ve.svg&&(j(ke,H),j(De,W),j(De,U)),!0===Ve.svgFilters&&(j(ke,P),j(De,W),j(De,U)),!0===Ve.mathMl&&(j(ke,I),j(De,$),j(De,U))),e.ADD_TAGS&&("function"==typeof e.ADD_TAGS?xe.tagCheck=e.ADD_TAGS:(ke===be&&(ke=x(ke)),j(ke,e.ADD_TAGS,mt))),e.ADD_ATTR&&("function"==typeof e.ADD_ATTR?xe.attributeCheck=e.ADD_ATTR:(De===Te&&(De=x(De)),j(De,e.ADD_ATTR,mt))),e.ADD_URI_SAFE_ATTR&&j(Qe,e.ADD_URI_SAFE_ATTR,mt),e.FORBID_CONTENTS&&(qe===Ke&&(qe=x(qe)),j(qe,e.FORBID_CONTENTS,mt)),Je&&(ke["#text"]=!0),Re&&j(ke,["html","head","body"]),ke.table&&(j(ke,["tbody"]),delete je.tbody),e.TRUSTED_TYPES_POLICY){if("function"!=typeof e.TRUSTED_TYPES_POLICY.createHTML)throw D('TRUSTED_TYPES_POLICY configuration option must provide a "createHTML" hook.');if("function"!=typeof e.TRUSTED_TYPES_POLICY.createScriptURL)throw D('TRUSTED_TYPES_POLICY configuration option must provide a "createScriptURL" hook.');oe=e.TRUSTED_TYPES_POLICY,de=oe.createHTML("")}else void 0===oe&&(oe=function(e,t){if("object"!=typeof e||"function"!=typeof e.createPolicy)return null;let n=null;const r="data-tt-policy-suffix";t&&t.hasAttribute(r)&&(n=t.getAttribute(r));const a="dompurify"+(n?"#"+n:"");try{return e.createPolicy(a,{createHTML:e=>e,createScriptURL:e=>e})}catch(e){return console.warn("TrustedTypes policy "+a+" could not be created."),null}}(z,i)),null!==oe&&"string"==typeof de&&(de=oe.createHTML(""));d&&d(e),ht=e}},Mt=j({},[...H,...P,...C]),gt=j({},[...I,...R]),Lt=function(e){p(n.removed,{element:e});try{Q(e).removeChild(e)}catch(t){V(e)}},vt=function(e,t){try{p(n.removed,{attribute:t.getAttributeNode(e),from:t})}catch(e){p(n.removed,{attribute:null,from:t})}if(t.removeAttribute(e),"is"===e)if(We||$e)try{Lt(t)}catch(e){}else try{t.setAttribute(e,"")}catch(e){}},Yt=function(e){let t=null,n=null;if(Fe)e="<remove></remove>"+e;else{const t=L(e,/^[\r\n\t ]+/);n=t&&t[0]}"application/xhtml+xml"===ct&&at===rt&&(e='<html xmlns="http://www.w3.org/1999/xhtml"><head></head><body>'+e+"</body></html>");const r=oe?oe.createHTML(e):e;if(at===rt)try{t=(new B).parseFromString(r,ct)}catch(e){}if(!t||!t.documentElement){t=ue.createDocument(at,"template",null);try{t.documentElement.innerHTML=st?de:r}catch(e){}}const s=t.body||t.documentElement;return e&&n&&s.insertBefore(a.createTextNode(n),s.childNodes[0]||null),at===rt?_e.call(t,Re?"html":"body")[0]:Re?t.documentElement:s},wt=function(e){return le.call(e.ownerDocument||e,e,T.SHOW_ELEMENT|T.SHOW_COMMENT|T.SHOW_TEXT|T.SHOW_PROCESSING_INSTRUCTION|T.SHOW_CDATA_SECTION,null)},kt=function(e){return e instanceof E&&("string"!=typeof e.nodeName||"string"!=typeof e.textContent||"function"!=typeof e.removeChild||!(e.attributes instanceof S)||"function"!=typeof e.removeAttribute||"function"!=typeof e.setAttribute||"string"!=typeof e.namespaceURI||"function"!=typeof e.insertBefore||"function"!=typeof e.hasChildNodes)},bt=function(e){return"function"==typeof c&&e instanceof c};function Dt(e,t,r){m(e,(e=>{e.call(n,t,r,ht)}))}const Tt=function(e){let t=null;if(Dt(he.beforeSanitizeElements,e,null),kt(e))return Lt(e),!0;const r=mt(e.nodeName);if(Dt(he.uponSanitizeElement,e,{tagName:r,allowedTags:ke}),Ie&&e.hasChildNodes()&&!bt(e.firstElementChild)&&b(/<[/\w!]/g,e.innerHTML)&&b(/<[/\w!]/g,e.textContent))return Lt(e),!0;if(e.nodeType===re)return Lt(e),!0;if(Ie&&e.nodeType===ae&&b(/<[/\w]/g,e.data))return Lt(e),!0;if(!(xe.tagCheck instanceof Function&&xe.tagCheck(r))&&(!ke[r]||je[r])){if(!je[r]&&jt(r)){if(Se.tagNameCheck instanceof RegExp&&b(Se.tagNameCheck,r))return!1;if(Se.tagNameCheck instanceof Function&&Se.tagNameCheck(r))return!1}if(Je&&!qe[r]){const t=Q(e)||e.parentNode,n=Z(e)||e.childNodes;if(n&&t){for(let r=n.length-1;r>=0;--r){const a=G(n[r],!0);a.__removalCount=(e.__removalCount||0)+1,t.insertBefore(a,K(e))}}}return Lt(e),!0}return e instanceof _&&!function(e){let t=Q(e);t&&t.tagName||(t={namespaceURI:at,tagName:"template"});const n=M(e.tagName),r=M(t.tagName);return!!it[e.namespaceURI]&&(e.namespaceURI===nt?t.namespaceURI===rt?"svg"===n:t.namespaceURI===tt?"svg"===n&&("annotation-xml"===r||dt[r]):Boolean(Mt[n]):e.namespaceURI===tt?t.namespaceURI===rt?"math"===n:t.namespaceURI===nt?"math"===n&&ut[r]:Boolean(gt[n]):e.namespaceURI===rt?!(t.namespaceURI===nt&&!ut[r])&&!(t.namespaceURI===tt&&!dt[r])&&!gt[n]&&(lt[n]||!Mt[n]):!("application/xhtml+xml"!==ct||!it[e.namespaceURI]))}(e)?(Lt(e),!0):"noscript"!==r&&"noembed"!==r&&"noframes"!==r||!b(/<\/no(script|embed|frames)/i,e.innerHTML)?(Ce&&e.nodeType===ne&&(t=e.textContent,m([fe,pe,ye],(e=>{t=v(t,e," ")})),e.textContent!==t&&(p(n.removed,{element:e.cloneNode()}),e.textContent=t)),Dt(he.afterSanitizeElements,e,null),!1):(Lt(e),!0)},St=function(e,t,n){if(Be&&("id"===t||"name"===t)&&(n in a||n in ft))return!1;if(Ae&&!Ee[t]&&b(Me,t));else if(Oe&&b(ge,t));else if(xe.attributeCheck instanceof Function&&xe.attributeCheck(t,e));else if(!De[t]||Ee[t]){if(!(jt(e)&&(Se.tagNameCheck instanceof RegExp&&b(Se.tagNameCheck,e)||Se.tagNameCheck instanceof Function&&Se.tagNameCheck(e))&&(Se.attributeNameCheck instanceof RegExp&&b(Se.attributeNameCheck,t)||Se.attributeNameCheck instanceof Function&&Se.attributeNameCheck(t,e))||"is"===t&&Se.allowCustomizedBuiltInElements&&(Se.tagNameCheck instanceof RegExp&&b(Se.tagNameCheck,n)||Se.tagNameCheck instanceof Function&&Se.tagNameCheck(n))))return!1}else if(Qe[t]);else if(b(we,v(n,ve,"")));else if("src"!==t&&"xlink:href"!==t&&"href"!==t||"script"===e||0!==Y(n,"data:")||!Ze[e]){if(He&&!b(Le,v(n,ve,"")));else if(n)return!1}else;return!0},jt=function(e){return"annotation-xml"!==e&&L(e,Ye)},Et=function(e){Dt(he.beforeSanitizeAttributes,e,null);const{attributes:t}=e;if(!t||kt(e))return;const r={attrName:"",attrValue:"",keepAttr:!0,allowedAttributes:De,forceKeepAttr:void 0};let a=t.length;for(;a--;){const s=t[a],{name:i,namespaceURI:o,value:d}=s,u=mt(i),l=d;let c="value"===i?l:w(l);if(r.attrName=u,r.attrValue=c,r.keepAttr=!0,r.forceKeepAttr=void 0,Dt(he.uponSanitizeAttribute,e,r),c=r.attrValue,!ze||"id"!==u&&"name"!==u||(vt(i,e),c="user-content-"+c),Ie&&b(/((--!?|])>)|<\/(style|title|textarea)/i,c)){vt(i,e);continue}if("attributename"===u&&L(c,"href")){vt(i,e);continue}if(r.forceKeepAttr)continue;if(!r.keepAttr){vt(i,e);continue}if(!Pe&&b(/\/>/i,c)){vt(i,e);continue}Ce&&m([fe,pe,ye],(e=>{c=v(c,e," ")}));const _=mt(e.nodeName);if(St(_,u,c)){if(oe&&"object"==typeof z&&"function"==typeof z.getAttributeType)if(o);else switch(z.getAttributeType(_,u)){case"TrustedHTML":c=oe.createHTML(c);break;case"TrustedScriptURL":c=oe.createScriptURL(c)}if(c!==l)try{o?e.setAttributeNS(o,i,c):e.setAttribute(i,c),kt(e)?Lt(e):f(n.removed)}catch(t){vt(i,e)}}else vt(i,e)}Dt(he.afterSanitizeAttributes,e,null)},xt=function e(t){let n=null;const r=wt(t);for(Dt(he.beforeSanitizeShadowDOM,t,null);n=r.nextNode();)Dt(he.uponSanitizeShadowNode,n,null),Tt(n),Et(n),n.content instanceof o&&e(n.content);Dt(he.afterSanitizeShadowDOM,t,null)};return n.sanitize=function(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},r=null,a=null,i=null,d=null;if(st=!e,st&&(e="\x3c!--\x3e"),"string"!=typeof e&&!bt(e)){if("function"!=typeof e.toString)throw D("toString is not a function");if("string"!=typeof(e=e.toString()))throw D("dirty is not a string, aborting")}if(!n.isSupported)return e;if(Ne||yt(t),n.removed=[],"string"==typeof e&&(Ge=!1),Ge){if(e.nodeName){const t=mt(e.nodeName);if(!ke[t]||je[t])throw D("root node is forbidden and cannot be sanitized in-place")}}else if(e instanceof c)r=Yt("\x3c!----\x3e"),a=r.ownerDocument.importNode(e,!0),a.nodeType===te&&"BODY"===a.nodeName||"HTML"===a.nodeName?r=a:r.appendChild(a);else{if(!We&&!Ce&&!Re&&-1===e.indexOf("<"))return oe&&Ue?oe.createHTML(e):e;if(r=Yt(e),!r)return We?null:Ue?de:""}r&&Fe&&Lt(r.firstChild);const u=wt(Ge?e:r);for(;i=u.nextNode();)Tt(i),Et(i),i.content instanceof o&&xt(i.content);if(Ge)return e;if(We){if($e)for(d=ce.call(r.ownerDocument);r.firstChild;)d.appendChild(r.firstChild);else d=r;return(De.shadowroot||De.shadowrootmode)&&(d=me.call(s,d,!0)),d}let l=Re?r.outerHTML:r.innerHTML;return Re&&ke["!doctype"]&&r.ownerDocument&&r.ownerDocument.doctype&&r.ownerDocument.doctype.name&&b(X,r.ownerDocument.doctype.name)&&(l="<!DOCTYPE "+r.ownerDocument.doctype.name+">\n"+l),Ce&&m([fe,pe,ye],(e=>{l=v(l,e," ")})),oe&&Ue?oe.createHTML(l):l},n.setConfig=function(){yt(arguments.length>0&&void 0!==arguments[0]?arguments[0]:{}),Ne=!0},n.clearConfig=function(){ht=null,Ne=!1},n.isValidAttribute=function(e,t,n){ht||yt({});const r=mt(e),a=mt(t);return St(r,a,n)},n.addHook=function(e,t){"function"==typeof t&&p(he[e],t)},n.removeHook=function(e,t){if(void 0!==t){const n=h(he[e],t);return-1===n?void 0:y(he[e],n,1)[0]}return f(he[e])},n.removeHooks=function(e){he[e]=[]},n.removeAllHooks=function(){he={afterSanitizeAttributes:[],afterSanitizeElements:[],afterSanitizeShadowDOM:[],beforeSanitizeAttributes:[],beforeSanitizeElements:[],beforeSanitizeShadowDOM:[],uponSanitizeAttribute:[],uponSanitizeElement:[],uponSanitizeShadowNode:[]}},n}()}},i={};function o(e){var t=i[e];if(void 0!==t)return t.exports;var n=i[e]={id:e,loaded:!1,exports:{}};return s[e].call(n.exports,n,n.exports,o),n.loaded=!0,n.exports}o.m=s,o.n=e=>{var t=e&&e.__esModule?()=>e.default:()=>e;return o.d(t,{a:t}),t},n=Object.getPrototypeOf?e=>Object.getPrototypeOf(e):e=>e.__proto__,o.t=function(t,r){if(1&r&&(t=this(t)),8&r)return t;if("object"==typeof t&&t){if(4&r&&t.__esModule)return t;if(16&r&&"function"==typeof t.then)return t}var a=Object.create(null);o.r(a);var s={};e=e||[null,n({}),n([]),n(n)];for(var i=2&r&&t;"object"==typeof i&&!~e.indexOf(i);i=n(i))Object.getOwnPropertyNames(i).forEach((e=>s[e]=()=>t[e]));return s.default=()=>t,o.d(a,s),a},o.d=(e,t)=>{for(var n in t)o.o(t,n)&&!o.o(e,n)&&Object.defineProperty(e,n,{enumerable:!0,get:t[n]})},o.f={},o.e=e=>Promise.all(Object.keys(o.f).reduce(((t,n)=>(o.f[n](e,t),t)),[])),o.u=e=>"deck-"+e+".js?v="+{"node_modules_vue-click-outside_index_js":"e3e009b3ba7060ddaacf","vendors-node_modules_nextcloud_vue_dist_assets_NcRichText-Cr-HXxVi_css-node_modules_vue-loade-ae72c4":"97cdba100e1f057280a2","vendors-node_modules_nextcloud_moment_dist_index_mjs-node_modules_chroma-js_index_js":"c082937629b8f6cfb125","vendors-node_modules_css-loader_dist_runtime_api_js-node_modules_css-loader_dist_runtime_getU-b420a3":"dcb16b9f44b18f19df03","src_mixins_labelStyle_js-node_modules_vue-material-design-icons_CalendarBlankOutline_vue-node-2b8d19":"b0715f27c1095444ed0f",src_views_CardReferenceWidget_vue:"8675969d99038b56d30a","vendors-node_modules_css-loader_dist_cjs_js_node_modules_easymde_dist_easymde_min_css-node_mo-7dd226":"3df8b528351137d5910f","vendors-node_modules_nextcloud_dialogs_dist_index_mjs":"846a2a50806bdd808343","vendors-node_modules_nextcloud_notify_push_dist_index_js-node_modules_blueimp-md5_js_md5_js-n-8f0523":"f51bae36cd816af1b624","src_views_CreateNewCardCustomPicker_vue-data_image_svg_xml_3c_21--_20-_20SPDX-FileCopyrightTe-252d21":"564c31fd857c1e7fa71d","src_views_BoardReferenceWidget_vue-data_image_svg_xml_3csvg_20viewBox_270_200_2016_2016_27_20-c27986":"3717b9ea5b9e22ab76a2",src_views_CommentReferenceWidget_vue:"b10905786ef829b3d2b5",node_modules_nextcloud_vue_dist_Components_NcColorPicker_mjs:"fdc3a4e79fe0a353b001",node_modules_nextcloud_vue_dist_Components_NcSelect_mjs:"6b8b44212766305d6b2b","vendors-node_modules_rehype-highlight_index_js":"1b9826830aa7bdfe46b9","node_modules_nextcloud_dialogs_dist_chunks_index-hTwX2gcC_mjs":"11ff0d8767c3b432f8d3","node_modules_nextcloud_dialogs_dist_chunks_PublicAuthPrompt-ecDAsnUN_mjs":"cb80d8d3474e8fe4233e","vendors-node_modules_vue-easymde_dist_VueEasyMDE_common_js":"147bc4013b07459ed782",_b2fd:"ff8b57b3ba147126511e","vendors-node_modules_nextcloud_dialogs_dist_chunks_FilePicker-lO8J1a0C_mjs":"287b5551f2d5a86b51c9"}[e],o.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(e){if("object"==typeof window)return window}}(),o.o=(e,t)=>Object.prototype.hasOwnProperty.call(e,t),r={},a="deck:",o.l=(e,t,n,s)=>{if(r[e])r[e].push(t);else{var i,d;if(void 0!==n)for(var u=document.getElementsByTagName("script"),l=0;l<u.length;l++){var c=u[l];if(c.getAttribute("src")==e||c.getAttribute("data-webpack")==a+n){i=c;break}}i||(d=!0,(i=document.createElement("script")).charset="utf-8",i.timeout=120,o.nc&&i.setAttribute("nonce",o.nc),i.setAttribute("data-webpack",a+n),i.src=e),r[e]=[t];var _=(t,n)=>{i.onerror=i.onload=null,clearTimeout(m);var a=r[e];if(delete r[e],i.parentNode&&i.parentNode.removeChild(i),a&&a.forEach((e=>e(n))),t)return t(n)},m=setTimeout(_.bind(null,void 0,{type:"timeout",target:i}),12e4);i.onerror=_.bind(null,i.onerror),i.onload=_.bind(null,i.onload),d&&document.head.appendChild(i)}},o.r=e=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},o.nmd=e=>(e.paths=[],e.children||(e.children=[]),e),o.p="/apps/deck/js/",(()=>{o.b=document.baseURI||self.location.href;var e={reference:0,"vendors-node_modules_vue_dist_vue_runtime_esm_js":0,"vendors-node_modules_vuex_dist_vuex_esm_js":0,"vendors-node_modules_nextcloud_axios_dist_index_mjs":0};o.f.j=(t,n)=>{var r=o.o(e,t)?e[t]:void 0;if(0!==r)if(r)n.push(r[2]);else{var a=new Promise(((n,a)=>r=e[t]=[n,a]));n.push(r[2]=a);var s=o.p+o.u(t),i=new Error;o.l(s,(n=>{if(o.o(e,t)&&(0!==(r=e[t])&&(e[t]=void 0),r)){var a=n&&("load"===n.type?"missing":n.type),s=n&&n.target&&n.target.src;i.message="Loading chunk "+t+" failed.\n("+a+": "+s+")",i.name="ChunkLoadError",i.type=a,i.request=s,r[1](i)}}),"chunk-"+t,t)}};var t=(t,n)=>{var r,a,[s,i,d]=n,u=0;if(s.some((t=>0!==e[t]))){for(r in i)o.o(i,r)&&(o.m[r]=i[r]);if(d)d(o)}for(t&&t(n);u<s.length;u++)a=s[u],o.o(e,a)&&e[a]&&e[a][0](),e[a]=0},n=self.webpackChunkdeck=self.webpackChunkdeck||[];n.forEach(t.bind(null,0)),n.push=t.bind(null,n.push.bind(n))})(),o.nc=void 0,(()=>{"use strict";var e=o(52781),t=o(53334),n=o(21210),r=o(63814),a=o(65606);o.nc=btoa(OC.requestToken),a.env.WEBPACK_SERVE?o.p="http://127.0.0.1:3000/":o.p=(0,r.fg)("deck","","js/");const s=async function(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:null;const{default:n}=await Promise.resolve().then(o.bind(o,85471)),{default:r}=await o.e("node_modules_vue-click-outside_index_js").then(o.t.bind(o,25276,23));return n.prototype.t=t.Tl,n.prototype.n=t.zw,n.prototype.OC=window.OC,n.prototype.OCA=window.OCA,n.directive("click-outside",r),n.directive("focus",{inserted(e){e.focus()}}),e?n.extend(e):n};(0,e.r)("deck-card",(async(e,t)=>{let{richObjectType:n,richObject:r,accessible:a}=t;const{default:i}=await Promise.all([o.e("vendors-node_modules_nextcloud_vue_dist_assets_NcRichText-Cr-HXxVi_css-node_modules_vue-loade-ae72c4"),o.e("vendors-node_modules_nextcloud_moment_dist_index_mjs-node_modules_chroma-js_index_js"),o.e("vendors-node_modules_css-loader_dist_runtime_api_js-node_modules_css-loader_dist_runtime_getU-b420a3"),o.e("src_mixins_labelStyle_js-node_modules_vue-material-design-icons_CalendarBlankOutline_vue-node-2b8d19"),o.e("src_views_CardReferenceWidget_vue")]).then(o.bind(o,64317)),d=await s(i);e.parentNode.style["max-width"]="400px",e.parentNode.style["margin-left"]="0",e.parentNode.style["margin-right"]="0",new d({propsData:{richObjectType:n,richObject:r,accessible:a}}).$mount(e)}));const i={};(0,e.r)("deck-board",(async(e,t)=>{let{richObjectType:r,richObject:a,accessible:d,interactive:u}=t;const{default:l}=await Promise.all([o.e("vendors-node_modules_nextcloud_vue_dist_assets_NcRichText-Cr-HXxVi_css-node_modules_vue-loade-ae72c4"),o.e("vendors-node_modules_nextcloud_moment_dist_index_mjs-node_modules_chroma-js_index_js"),o.e("vendors-node_modules_css-loader_dist_runtime_api_js-node_modules_css-loader_dist_runtime_getU-b420a3"),o.e("vendors-node_modules_css-loader_dist_cjs_js_node_modules_easymde_dist_easymde_min_css-node_mo-7dd226"),o.e("vendors-node_modules_nextcloud_dialogs_dist_index_mjs"),o.e("vendors-node_modules_nextcloud_notify_push_dist_index_js-node_modules_blueimp-md5_js_md5_js-n-8f0523"),o.e("src_views_CreateNewCardCustomPicker_vue-data_image_svg_xml_3c_21--_20-_20SPDX-FileCopyrightTe-252d21"),o.e("src_views_BoardReferenceWidget_vue-data_image_svg_xml_3csvg_20viewBox_270_200_2016_2016_27_20-c27986")]).then(o.bind(o,62392)),c=await s(l);i[e]=new c({store:(0,n.A)(),propsData:{richObjectType:r,richObject:a,accessible:d,interactive:u}}).$mount(e)}),(e=>{i[e].$destroy(),delete i[e]})),(0,e.r)("deck-comment",(async(e,t)=>{let{richObjectType:n,richObject:r,accessible:a}=t;const{default:i}=await Promise.all([o.e("vendors-node_modules_nextcloud_vue_dist_assets_NcRichText-Cr-HXxVi_css-node_modules_vue-loade-ae72c4"),o.e("vendors-node_modules_nextcloud_moment_dist_index_mjs-node_modules_chroma-js_index_js"),o.e("vendors-node_modules_css-loader_dist_runtime_api_js-node_modules_css-loader_dist_runtime_getU-b420a3"),o.e("src_mixins_labelStyle_js-node_modules_vue-material-design-icons_CalendarBlankOutline_vue-node-2b8d19"),o.e("src_views_CommentReferenceWidget_vue")]).then(o.bind(o,4994)),d=await s(i);e.parentNode.style["max-width"]="400px",e.parentNode.style["margin-left"]="0",e.parentNode.style["margin-right"]="0",new d({propsData:{richObjectType:n,richObject:r,accessible:a}}).$mount(e)})),(0,e.e)("create-new-deck-card",(async(t,n)=>{let{providerId:r,accessible:a}=n;const{default:i}=await Promise.all([o.e("vendors-node_modules_nextcloud_vue_dist_assets_NcRichText-Cr-HXxVi_css-node_modules_vue-loade-ae72c4"),o.e("vendors-node_modules_nextcloud_moment_dist_index_mjs-node_modules_chroma-js_index_js"),o.e("vendors-node_modules_css-loader_dist_runtime_api_js-node_modules_css-loader_dist_runtime_getU-b420a3"),o.e("vendors-node_modules_css-loader_dist_cjs_js_node_modules_easymde_dist_easymde_min_css-node_mo-7dd226"),o.e("vendors-node_modules_nextcloud_dialogs_dist_index_mjs"),o.e("src_views_CreateNewCardCustomPicker_vue-data_image_svg_xml_3c_21--_20-_20SPDX-FileCopyrightTe-252d21")]).then(o.bind(o,4587)),d=new(await s(i))({propsData:{providerId:r,accessible:a}}).$mount(t);return new e.N(d.$el,d)}),((e,t)=>{t.object.$destroy()}),"normal")})()})();
//# sourceMappingURL=deck-reference.js.map?v=3b0b1e63ef9d4ad96e88