/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.helper;

import java.io.IOException;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ingest.GetPipelineRequest;
import org.opensearch.action.ingest.PutPipelineRequest;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.memorycontainer.MemoryConfiguration;
import org.opensearch.ml.engine.indices.MLIndicesHandler;
import org.opensearch.transport.client.Client;

public final class MemoryContainerPipelineHelper {
    @Generated
    private static final Logger log = LogManager.getLogger(MemoryContainerPipelineHelper.class);

    public static void createLongTermMemoryIngestPipeline(String indexName, MemoryConfiguration config, MLIndicesHandler indicesHandler, Client client, ActionListener<Boolean> listener) {
        try {
            if (config.getEmbeddingModelType() != null) {
                String pipelineName = indexName + "-embedding";
                MemoryContainerPipelineHelper.createTextEmbeddingPipeline(pipelineName, config, client, (ActionListener<Boolean>)ActionListener.wrap(success -> {
                    log.info("Successfully created text embedding pipeline: {}", (Object)pipelineName);
                    indicesHandler.createLongTermMemoryIndex(pipelineName, indexName, config, listener);
                }, e -> {
                    log.error("Failed to create text embedding pipeline '{}'", (Object)pipelineName, e);
                    listener.onFailure((Exception)new OpenSearchStatusException("Internal server error", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                }));
            } else {
                indicesHandler.createLongTermMemoryIndex(null, indexName, config, listener);
            }
        }
        catch (Exception e2) {
            log.error("Failed to create text embedding pipeline for long term memory index: {}", (Object)indexName, (Object)e2);
            listener.onFailure((Exception)new OpenSearchStatusException("Internal server error", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
        }
    }

    public static void createTextEmbeddingPipeline(String pipelineName, MemoryConfiguration config, Client client, ActionListener<Boolean> listener) {
        client.admin().cluster().getPipeline(new GetPipelineRequest(new String[]{pipelineName}), ActionListener.wrap(response -> {
            if (!response.pipelines().isEmpty()) {
                log.info("Pipeline '{}' already exists (shared index scenario), skipping creation", (Object)pipelineName);
                listener.onResponse((Object)true);
                return;
            }
            try {
                MemoryContainerPipelineHelper.createPipelineInternal(pipelineName, config, client, listener);
            }
            catch (IOException e) {
                log.error("Failed to build pipeline configuration for '{}'", (Object)pipelineName, (Object)e);
                listener.onFailure((Exception)new OpenSearchStatusException("Internal server error", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
            }
        }, error -> {
            try {
                MemoryContainerPipelineHelper.createPipelineInternal(pipelineName, config, client, listener);
            }
            catch (IOException e) {
                log.error("Failed to build pipeline configuration for '{}'", (Object)pipelineName, (Object)e);
                listener.onFailure((Exception)new OpenSearchStatusException("Internal server error", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
            }
        }));
    }

    private static void createPipelineInternal(String pipelineName, MemoryConfiguration config, Client client, ActionListener<Boolean> listener) throws IOException {
        String processorName = config.getEmbeddingModelType() == FunctionName.TEXT_EMBEDDING ? "text_embedding" : "sparse_encoding";
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject().field("description", "Agentic Memory Text embedding pipeline").startArray("processors").startObject().startObject(processorName).field("model_id", config.getEmbeddingModelId()).startObject("field_map").field("memory", "memory_embedding").endObject().endObject().endObject().endArray().endObject();
        PutPipelineRequest putRequest = new PutPipelineRequest(pipelineName, BytesReference.bytes((XContentBuilder)builder), (MediaType)XContentType.JSON);
        client.admin().cluster().putPipeline(putRequest, ActionListener.wrap(response -> {
            if (response.isAcknowledged()) {
                log.info("Successfully created pipeline: {}", (Object)pipelineName);
                listener.onResponse((Object)true);
            } else {
                log.error("Pipeline creation not acknowledged: {}", (Object)pipelineName);
                listener.onFailure((Exception)new OpenSearchStatusException("Internal server error", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
            }
        }, e -> {
            log.error("Failed to create pipeline '{}'", (Object)pipelineName, e);
            listener.onFailure((Exception)new OpenSearchStatusException("Internal server error", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
        }));
    }

    public static void createHistoryIndexIfEnabled(MemoryConfiguration config, String historyIndexName, MLIndicesHandler indicesHandler, ActionListener<Boolean> listener) {
        if (!config.isDisableHistory()) {
            log.debug("Creating history index: {}", (Object)historyIndexName);
            indicesHandler.createLongTermMemoryHistoryIndex(historyIndexName, config, listener);
        } else {
            log.debug("History index disabled, skipping creation");
            listener.onResponse((Object)true);
        }
    }

    @Generated
    private MemoryContainerPipelineHelper() {
    }
}

