/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingest.simulate;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.VersionType;
import org.opensearch.client.opensearch.ingest.simulate.Ingest;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class DocumentSimulation
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, DocumentSimulation> {
    @Nonnull
    private final String id;
    @Nonnull
    private final String index;
    @Nonnull
    private final Ingest ingest;
    @Nullable
    private final String routing;
    @Nonnull
    private final Map<String, JsonData> source;
    @Nullable
    private final Long version;
    @Nullable
    private final VersionType versionType;
    public static final JsonpDeserializer<DocumentSimulation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DocumentSimulation::setupDocumentSimulationDeserializer);

    private DocumentSimulation(Builder builder) {
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.ingest = ApiTypeHelper.requireNonNull(builder.ingest, this, "ingest");
        this.routing = builder.routing;
        this.source = ApiTypeHelper.unmodifiableRequired(builder.source, (Object)this, "source");
        this.version = builder.version;
        this.versionType = builder.versionType;
    }

    public static DocumentSimulation of(Function<Builder, ObjectBuilder<DocumentSimulation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final String id() {
        return this.id;
    }

    @Nonnull
    public final String index() {
        return this.index;
    }

    @Nonnull
    public final Ingest ingest() {
        return this.ingest;
    }

    @Nullable
    public final String routing() {
        return this.routing;
    }

    @Nonnull
    public final Map<String, JsonData> source() {
        return this.source;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    @Nullable
    public final VersionType versionType() {
        return this.versionType;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("_id");
        generator.write(this.id);
        generator.writeKey("_index");
        generator.write(this.index);
        generator.writeKey("_ingest");
        this.ingest.serialize(generator, mapper);
        if (this.routing != null) {
            generator.writeKey("_routing");
            generator.write(this.routing);
        }
        generator.writeKey("_source");
        generator.writeStartObject();
        for (Map.Entry<String, JsonData> item0 : this.source.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
        if (this.version != null) {
            generator.writeKey("_version");
            generator.write(this.version.longValue());
        }
        if (this.versionType != null) {
            generator.writeKey("_version_type");
            this.versionType.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupDocumentSimulationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "_id");
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "_index");
        op.add(Builder::ingest, Ingest._DESERIALIZER, "_ingest");
        op.add(Builder::routing, JsonpDeserializer.stringDeserializer(), "_routing");
        op.add(Builder::source, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "_source");
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "_version");
        op.add(Builder::versionType, VersionType._DESERIALIZER, "_version_type");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.id.hashCode();
        result = 31 * result + this.index.hashCode();
        result = 31 * result + this.ingest.hashCode();
        result = 31 * result + Objects.hashCode(this.routing);
        result = 31 * result + this.source.hashCode();
        result = 31 * result + Objects.hashCode(this.version);
        result = 31 * result + Objects.hashCode(this.versionType);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentSimulation other = (DocumentSimulation)o;
        return this.id.equals(other.id) && this.index.equals(other.index) && this.ingest.equals(other.ingest) && Objects.equals(this.routing, other.routing) && this.source.equals(other.source) && Objects.equals(this.version, other.version) && Objects.equals(this.versionType, other.versionType);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, DocumentSimulation> {
        private String id;
        private String index;
        private Ingest ingest;
        @Nullable
        private String routing;
        private Map<String, JsonData> source;
        @Nullable
        private Long version;
        @Nullable
        private VersionType versionType;

        public Builder() {
        }

        private Builder(DocumentSimulation o) {
            this.id = o.id;
            this.index = o.index;
            this.ingest = o.ingest;
            this.routing = o.routing;
            this.source = Builder._mapCopy(o.source);
            this.version = o.version;
            this.versionType = o.versionType;
        }

        private Builder(Builder o) {
            this.id = o.id;
            this.index = o.index;
            this.ingest = o.ingest;
            this.routing = o.routing;
            this.source = Builder._mapCopy(o.source);
            this.version = o.version;
            this.versionType = o.versionType;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        @Nonnull
        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        @Nonnull
        public final Builder ingest(Ingest value) {
            this.ingest = value;
            return this;
        }

        @Nonnull
        public final Builder ingest(Function<Ingest.Builder, ObjectBuilder<Ingest>> fn) {
            return this.ingest(fn.apply(new Ingest.Builder()).build());
        }

        @Nonnull
        public final Builder routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        @Nonnull
        public final Builder source(Map<String, JsonData> map) {
            this.source = Builder._mapPutAll(this.source, map);
            return this;
        }

        @Nonnull
        public final Builder source(String key, JsonData value) {
            this.source = Builder._mapPut(this.source, key, value);
            return this;
        }

        @Nonnull
        public final Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        @Nonnull
        public final Builder versionType(@Nullable VersionType value) {
            this.versionType = value;
            return this;
        }

        @Override
        @Nonnull
        public DocumentSimulation build() {
            this._checkSingleUse();
            return new DocumentSimulation(this);
        }
    }
}

