/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.support.classic;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.annotation.Experimental;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.function.Callback;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.ClassicHttpRequest;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.ClassicHttpResponse;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.ContentType;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.EntityDetails;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.Header;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.HttpEntity;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.HttpException;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.HttpRequest;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.HttpRequestMapper;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.Method;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.ProtocolException;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.impl.io.support.IncomingHttpEntity;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.io.HttpRequestHandler;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.io.HttpServerRequestHandler;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.io.support.BasicHttpServerRequestHandler;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.AsyncResponseProducer;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.AsyncServerExchangeHandler;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.CapacityChannel;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.DataStreamChannel;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.ResponseChannel;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.support.BasicResponseProducer;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.support.classic.ClassicToAsyncSupport;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.support.classic.ContentInputBuffer;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.support.classic.SharedInputBuffer;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.support.classic.SharedOutputBuffer;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.protocol.HttpContext;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.support.BasicResponseBuilder;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.util.Args;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.util.Asserts;

@Experimental
public class ClassicToAsyncServerExchangeHandler
implements AsyncServerExchangeHandler {
    private final int initialBufferSize;
    private final Executor executor;
    private final HttpServerRequestHandler requestHandler;
    private final Callback<Exception> exceptionCallback;
    private final AtomicBoolean responseCommitted;
    private final AtomicReference<AsyncResponseProducer> responseProducerRef;
    private final AtomicReference<SharedInputBuffer> inputBufferRef;
    private final AtomicReference<SharedOutputBuffer> outputBufferRef;
    private final AtomicReference<Exception> exceptionRef;

    public ClassicToAsyncServerExchangeHandler(int initialBufferSize, Executor executor, HttpServerRequestHandler requestHandler, Callback<Exception> exceptionCallback) {
        this.initialBufferSize = Args.positive(initialBufferSize, "Initial buffer size");
        this.executor = Args.notNull(executor, "Executor");
        this.requestHandler = Args.notNull(requestHandler, "Request handler");
        this.exceptionCallback = exceptionCallback;
        this.responseCommitted = new AtomicBoolean();
        this.responseProducerRef = new AtomicReference();
        this.inputBufferRef = new AtomicReference();
        this.outputBufferRef = new AtomicReference();
        this.exceptionRef = new AtomicReference();
    }

    public ClassicToAsyncServerExchangeHandler(Executor executor, HttpServerRequestHandler requestHandler, Callback<Exception> exceptionCallback) {
        this(2048, executor, requestHandler, exceptionCallback);
    }

    public ClassicToAsyncServerExchangeHandler(Executor executor, HttpRequestMapper<HttpRequestHandler> handlerMapper, Callback<Exception> exceptionCallback) {
        this(2048, executor, new BasicHttpServerRequestHandler(handlerMapper), exceptionCallback);
    }

    public ClassicToAsyncServerExchangeHandler(Executor executor, HttpRequestHandler handler, Callback<Exception> exceptionCallback) {
        this(2048, executor, new BasicHttpServerRequestHandler((request, context) -> handler), exceptionCallback);
    }

    void propagateException() throws IOException {
        Exception ex = this.exceptionRef.getAndSet(null);
        if (ex != null) {
            ClassicToAsyncSupport.rethrow(ex);
        }
    }

    SharedInputBuffer inputBuffer() {
        SharedInputBuffer inputBuffer = this.inputBufferRef.get();
        Asserts.notNull(inputBuffer, "Input buffer");
        return inputBuffer;
    }

    SharedOutputBuffer outputBuffer() {
        SharedOutputBuffer outputBuffer = this.outputBufferRef.get();
        Asserts.notNull(outputBuffer, "Output buffer");
        return outputBuffer;
    }

    void abortInput() {
        SharedInputBuffer inputBuffer = this.inputBufferRef.get();
        if (inputBuffer != null) {
            inputBuffer.abort();
        }
    }

    void abortOutput() {
        SharedOutputBuffer outputBuffer = this.outputBufferRef.get();
        if (outputBuffer != null) {
            outputBuffer.abort();
        }
    }

    @Override
    public final void handleRequest(final HttpRequest request, EntityDetails entityDetails, final ResponseChannel responseChannel, final HttpContext context) throws HttpException, IOException {
        if (entityDetails != null) {
            SharedInputBuffer inputBuffer = new SharedInputBuffer(this.initialBufferSize);
            this.inputBufferRef.set(inputBuffer);
        }
        this.executor.execute(() -> {
            block7: {
                try {
                    ClassicHttpRequest cr = ClassicRequestBuilder.copy(request).build();
                    if (entityDetails != null) {
                        cr.setEntity(new IncomingHttpEntity(new InternalInputStream(this.inputBufferRef.get()), entityDetails.getContentLength(), request));
                    }
                    HttpServerRequestHandler.ResponseTrigger trigger = new HttpServerRequestHandler.ResponseTrigger(){

                        @Override
                        public void sendInformation(ClassicHttpResponse response) throws HttpException, IOException {
                            responseChannel.sendInformation(response, context);
                        }

                        @Override
                        public void submitResponse(ClassicHttpResponse response) throws HttpException, IOException {
                            if (ClassicToAsyncServerExchangeHandler.this.responseCommitted.compareAndSet(false, true)) {
                                boolean contentExpected;
                                HttpEntity responseEntity = response.getEntity();
                                String method = request.getMethod();
                                boolean bl = contentExpected = responseEntity != null && !Method.HEAD.isSame(method);
                                if (contentExpected) {
                                    SharedOutputBuffer outputBuffer = new SharedOutputBuffer(ClassicToAsyncServerExchangeHandler.this.initialBufferSize);
                                    ClassicToAsyncServerExchangeHandler.this.outputBufferRef.set(outputBuffer);
                                }
                                responseChannel.sendResponse(response, responseEntity, null);
                                if (contentExpected) {
                                    responseEntity.writeTo(new InternalOutputStream((SharedOutputBuffer)ClassicToAsyncServerExchangeHandler.this.outputBufferRef.get()));
                                }
                            } else {
                                throw new IllegalStateException("Response has already been committed");
                            }
                        }
                    };
                    try {
                        this.requestHandler.handle(cr, trigger, context);
                    }
                    catch (RuntimeException | HttpException ex) {
                        if (this.responseCommitted.compareAndSet(false, true)) {
                            AsyncResponseProducer responseProducer = this.handleError(ex);
                            this.responseProducerRef.set(responseProducer);
                            responseProducer.sendResponse(responseChannel, context);
                            break block7;
                        }
                        throw ex;
                    }
                }
                catch (Exception ex) {
                    if (this.exceptionCallback != null) {
                        this.exceptionCallback.execute(ex);
                    }
                    responseChannel.terminateExchange();
                }
            }
        });
    }

    protected AsyncResponseProducer handleError(Exception ex) {
        int status = ex instanceof ProtocolException ? 400 : 500;
        return new BasicResponseProducer(BasicResponseBuilder.create(status).build(), ex.getMessage(), ContentType.TEXT_PLAIN);
    }

    @Override
    public final void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        this.inputBuffer().updateCapacity(capacityChannel);
    }

    @Override
    public final void consume(ByteBuffer src) throws IOException {
        this.inputBuffer().fill(src);
    }

    @Override
    public final void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
        this.inputBuffer().markEndStream();
    }

    @Override
    public final int available() {
        AsyncResponseProducer responseProducer = this.responseProducerRef.get();
        if (responseProducer != null) {
            return responseProducer.available();
        }
        return this.outputBuffer().length();
    }

    @Override
    public final void produce(DataStreamChannel channel) throws IOException {
        AsyncResponseProducer responseProducer = this.responseProducerRef.get();
        if (responseProducer != null) {
            responseProducer.produce(channel);
        } else {
            this.outputBuffer().flush(channel);
        }
    }

    @Override
    public final void failed(Exception cause) {
        this.responseCommitted.set(true);
        this.exceptionRef.compareAndSet(null, cause);
        this.abortInput();
        this.abortOutput();
    }

    @Override
    public void releaseResources() {
    }

    class InternalOutputStream
    extends OutputStream {
        private final SharedOutputBuffer buffer;

        public InternalOutputStream(SharedOutputBuffer buffer) {
            Asserts.notNull(buffer, "Shared buffer");
            this.buffer = buffer;
        }

        @Override
        public void close() throws IOException {
            ClassicToAsyncServerExchangeHandler.this.propagateException();
            this.buffer.writeCompleted();
        }

        @Override
        public void flush() throws IOException {
            ClassicToAsyncServerExchangeHandler.this.propagateException();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            ClassicToAsyncServerExchangeHandler.this.propagateException();
            this.buffer.write(b, off, len);
        }

        @Override
        public void write(byte[] b) throws IOException {
            ClassicToAsyncServerExchangeHandler.this.propagateException();
            if (b == null) {
                return;
            }
            this.buffer.write(b, 0, b.length);
        }

        @Override
        public void write(int b) throws IOException {
            ClassicToAsyncServerExchangeHandler.this.propagateException();
            this.buffer.write(b);
        }
    }

    class InternalInputStream
    extends InputStream {
        private final ContentInputBuffer buffer;

        InternalInputStream(ContentInputBuffer buffer) {
            Args.notNull(buffer, "Input buffer");
            this.buffer = buffer;
        }

        @Override
        public int available() throws IOException {
            ClassicToAsyncServerExchangeHandler.this.propagateException();
            return this.buffer.length();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            ClassicToAsyncServerExchangeHandler.this.propagateException();
            if (len == 0) {
                return 0;
            }
            return this.buffer.read(b, off, len);
        }

        @Override
        public int read(byte[] b) throws IOException {
            ClassicToAsyncServerExchangeHandler.this.propagateException();
            if (b == null) {
                return 0;
            }
            return this.buffer.read(b, 0, b.length);
        }

        @Override
        public int read() throws IOException {
            ClassicToAsyncServerExchangeHandler.this.propagateException();
            return this.buffer.read();
        }

        @Override
        public void close() throws IOException {
            ClassicToAsyncServerExchangeHandler.this.propagateException();
            byte[] tmp = new byte[1024];
            while (this.read(tmp) >= 0) {
            }
            super.close();
        }
    }
}

