/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.collect.ImmutableList;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.rules.ImmutableFullToLeftAndRightJoinRule;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.tools.RelBuilder;
import org.immutables.value.Value;

@Value.Enclosing
public class FullToLeftAndRightJoinRule
extends RelRule<Config>
implements TransformationRule {
    protected FullToLeftAndRightJoinRule(Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        final Join join = (Join)call.rel(0);
        RelBuilder relBuilder = call.builder();
        if (!RexUtil.isDeterministic(join.getCondition())) {
            return;
        }
        RexBuilder rexBuilder = relBuilder.getRexBuilder();
        RexNode newCondition = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_TRUE, join.getCondition());
        RexShuttle shuttle = new RexShuttle(){

            @Override
            public RexNode visitInputRef(RexInputRef inputRef) {
                return RexInputRef.of(inputRef.getIndex(), join.getRowType());
            }
        };
        newCondition = shuttle.apply(newCondition);
        RelNode newLeft = relBuilder.push(join.getLeft()).push(join.getRight()).join(JoinRelType.LEFT, join.getCondition()).build();
        RelNode newRight = relBuilder.push(join.getLeft()).push(join.getRight()).join(JoinRelType.RIGHT, join.getCondition()).filter(newCondition).build();
        relBuilder.pushAll((Iterable<? extends RelNode>)ImmutableList.of((Object)newLeft, (Object)newRight)).union(true);
        call.transformTo(relBuilder.build());
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableFullToLeftAndRightJoinRule.Config.of().withOperandFor(Join.class);

        @Override
        default public FullToLeftAndRightJoinRule toRule() {
            return new FullToLeftAndRightJoinRule(this);
        }

        default public Config withOperandFor(Class<? extends Join> joinClass) {
            return this.withOperandSupplier(b -> b.operand(joinClass).predicate(join -> join.getJoinType() == JoinRelType.FULL).anyInputs()).as(Config.class);
        }
    }
}

