/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.oa.poa;

import com.sun.corba.ee.impl.oa.poa.POAFactory;
import com.sun.corba.ee.impl.oa.poa.POAImpl;
import com.sun.corba.ee.spi.logging.POASystemException;
import com.sun.corba.ee.spi.protocol.PIHandler;
import com.sun.corba.ee.spi.trace.Poa;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.gmbal.ManagedOperation;
import org.glassfish.gmbal.NameValue;
import org.glassfish.gmbal.ParameterNames;
import org.glassfish.pfl.basic.contain.MultiSet;
import org.glassfish.pfl.tf.spi.annotation.InfoMethod;
import org.omg.CORBA.LocalObject;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAManagerPackage.State;

@Poa
@ManagedObject
@Description(value="A POAManager which controls invocations of its POAs")
public class POAManagerImpl
extends LocalObject
implements POAManager {
    private static final POASystemException wrapper = POASystemException.self;
    private static final long serialVersionUID = -3308938242684343402L;
    private final POAFactory factory;
    private final PIHandler pihandler;
    private final int myId;
    private final ReentrantReadWriteLock stateLock = new ReentrantReadWriteLock(true);
    private final Condition stateCV = this.stateLock.writeLock().newCondition();
    private State state;
    private Set<POAImpl> poas = new HashSet<POAImpl>(4);
    private AtomicInteger nInvocations = new AtomicInteger(0);
    private AtomicInteger nWaiters = new AtomicInteger(0);
    private volatile boolean explicitStateChange;
    private static ThreadLocal<MultiSet<POAManagerImpl>> activeManagers = new ThreadLocal<MultiSet<POAManagerImpl>>(){

        @Override
        public MultiSet<POAManagerImpl> initialValue() {
            return new MultiSet();
        }
    };

    private String stateToString(State state) {
        switch (state.value()) {
            case 0: {
                return "HOLDING";
            }
            case 1: {
                return "ACTIVE";
            }
            case 2: {
                return "DISCARDING";
            }
            case 3: {
                return "INACTIVE";
            }
        }
        return "State[UNKNOWN]";
    }

    public int hashCode() {
        return this.myId;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof POAManagerImpl)) {
            return false;
        }
        POAManagerImpl other = (POAManagerImpl)((Object)obj);
        return other.myId == this.myId;
    }

    public String toString() {
        this.stateLock.readLock().lock();
        try {
            String string = "POAManagerImpl[" + this.myId + "," + this.stateToString(this.state) + ",nInvocations=" + this.nInvocations + ",nWaiters=" + this.nWaiters + "]";
            return string;
        }
        finally {
            this.stateLock.readLock().unlock();
        }
    }

    @ManagedAttribute
    @Description(value="The set of POAs managed by this POAManager")
    Set<POAImpl> getManagedPOAs() {
        return new HashSet<POAImpl>(this.poas);
    }

    @ManagedAttribute
    @Description(value="Number of active invocations executing in this POAManager")
    public int numberOfInvocations() {
        return this.nInvocations.get();
    }

    @ManagedAttribute
    @Description(value="Number of threads waiting for invocations to complete in this POAManager")
    public int numberOfWaiters() {
        return this.nWaiters.get();
    }

    @ManagedAttribute
    @Description(value="The current state of this POAManager")
    public String displayState() {
        this.stateLock.readLock().lock();
        try {
            String string = this.stateToString(this.state);
            return string;
        }
        finally {
            this.stateLock.readLock().unlock();
        }
    }

    @ManagedAttribute
    @Description(value="The POAFactory that manages this POAManager")
    POAFactory getFactory() {
        return this.factory;
    }

    PIHandler getPIHandler() {
        return this.pihandler;
    }

    @InfoMethod
    private void numWaitersStart(int value) {
    }

    @InfoMethod
    private void numWaitersEnd(int value) {
    }

    @Poa
    private void countedWait() {
        int num;
        try {
            num = this.nWaiters.incrementAndGet();
            this.numWaitersStart(num);
            this.stateCV.await((long)num * 1000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException num2) {
        }
        finally {
            num = this.nWaiters.decrementAndGet();
            this.numWaitersEnd(num);
        }
    }

    @InfoMethod
    private void nWaiters(int value) {
    }

    @Poa
    private void notifyWaiters() {
        int num = this.nWaiters.get();
        this.nWaiters(num);
        if (num > 0) {
            this.stateCV.signalAll();
        }
    }

    @ManagedAttribute
    @NameValue
    @Description(value="The ID of this POAManager")
    public int getManagerId() {
        return this.myId;
    }

    POAManagerImpl(POAFactory factory, PIHandler pih) {
        this.factory = factory;
        factory.addPoaManager(this);
        this.pihandler = pih;
        this.myId = factory.newPOAManagerId();
        this.state = State.HOLDING;
        this.explicitStateChange = false;
    }

    void addPOA(POAImpl poa) {
        this.stateLock.writeLock().lock();
        try {
            if (this.state.value() == 3) {
                throw wrapper.addPoaInactive();
            }
            this.poas.add(poa);
        }
        finally {
            this.stateLock.writeLock().unlock();
        }
    }

    void removePOA(POAImpl poa) {
        this.stateLock.writeLock().lock();
        try {
            this.poas.remove(poa);
            if (this.poas.isEmpty()) {
                this.factory.removePoaManager(this);
            }
        }
        finally {
            this.stateLock.writeLock().unlock();
        }
    }

    @ManagedAttribute
    @Description(value="The ObjectReferenceTemplate state of this POAManager")
    public short getORTState() {
        switch (this.state.value()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 3: {
                return 3;
            }
            case 2: {
                return 2;
            }
        }
        return 4;
    }

    @Poa
    @ManagedOperation
    @Description(value="Make this POAManager active, so it can handle new requests")
    public void activate() throws AdapterInactive {
        this.explicitStateChange = true;
        this.stateLock.writeLock().lock();
        try {
            if (this.state.value() == 3) {
                throw new AdapterInactive();
            }
            this.state = State.ACTIVE;
            this.pihandler.adapterManagerStateChanged(this.myId, this.getORTState());
            this.notifyWaiters();
        }
        finally {
            this.stateLock.writeLock().unlock();
        }
    }

    @Poa
    @ManagedOperation
    @Description(value="Hold all requests to this POAManager")
    public void hold_requests(boolean wait_for_completion) throws AdapterInactive {
        this.explicitStateChange = true;
        this.stateLock.writeLock().lock();
        try {
            if (this.state.value() == 3) {
                throw new AdapterInactive();
            }
            this.state = State.HOLDING;
            this.pihandler.adapterManagerStateChanged(this.myId, this.getORTState());
            this.notifyWaiters();
            if (wait_for_completion) {
                while (this.state.value() == 0 && this.nInvocations.get() > 0) {
                    this.countedWait();
                }
            }
        }
        finally {
            this.stateLock.writeLock().unlock();
        }
    }

    @Poa
    @ManagedOperation
    @ParameterNames(value={"waitForCompletion"})
    @Description(value="Make this POAManager discard all incoming requests")
    public void discard_requests(boolean wait_for_completion) throws AdapterInactive {
        this.explicitStateChange = true;
        this.stateLock.writeLock().lock();
        try {
            if (this.state.value() == 3) {
                throw new AdapterInactive();
            }
            this.state = State.DISCARDING;
            this.pihandler.adapterManagerStateChanged(this.myId, this.getORTState());
            this.notifyWaiters();
            if (wait_for_completion) {
                while (this.state.value() == 2 && this.nInvocations.get() > 0) {
                    this.countedWait();
                }
            }
        }
        finally {
            this.stateLock.writeLock().unlock();
        }
    }

    @Poa
    public void deactivate(boolean etherealize_objects, boolean wait_for_completion) throws AdapterInactive {
        this.stateLock.writeLock().lock();
        try {
            this.explicitStateChange = true;
            if (this.state.value() == 3) {
                throw new AdapterInactive();
            }
            this.state = State.INACTIVE;
            this.pihandler.adapterManagerStateChanged(this.myId, this.getORTState());
            this.notifyWaiters();
        }
        finally {
            this.stateLock.writeLock().unlock();
        }
        POAManagerDeactivator deactivator = new POAManagerDeactivator(this, etherealize_objects);
        if (wait_for_completion) {
            deactivator.run();
        } else {
            Thread thr = new Thread(deactivator);
            thr.start();
        }
    }

    public State get_state() {
        return this.state;
    }

    @InfoMethod
    private void activeManagers(MultiSet<POAManagerImpl> am) {
    }

    @InfoMethod
    private void alreadyActive(POAManagerImpl pm) {
    }

    @InfoMethod
    private void activeInDifferentPoaManager() {
    }

    @Poa
    private void checkState() {
        MultiSet<POAManagerImpl> am = activeManagers.get();
        this.activeManagers(am);
        this.stateLock.readLock().lock();
        try {
            block12: while (this.state.value() != 1) {
                switch (this.state.value()) {
                    case 0: {
                        if (am.contains((Object)this)) {
                            this.alreadyActive(this);
                            return;
                        }
                        if (am.size() == 0) {
                            if (this.state.value() == 0) {
                                this.stateLock.readLock().unlock();
                                this.stateLock.writeLock().lock();
                            }
                            try {
                                while (this.state.value() == 0) {
                                    this.countedWait();
                                }
                                continue block12;
                            }
                            finally {
                                this.stateLock.writeLock().unlock();
                                this.stateLock.readLock().lock();
                                continue block12;
                            }
                        }
                        this.activeInDifferentPoaManager();
                        throw this.factory.getWrapper().poaManagerMightDeadlock();
                    }
                    case 2: {
                        throw this.factory.getWrapper().poaDiscarding();
                    }
                    case 3: {
                        throw this.factory.getWrapper().poaInactive();
                    }
                }
            }
        }
        finally {
            this.stateLock.readLock().unlock();
        }
    }

    @InfoMethod
    private void addingThreadToActiveManagers(POAManagerImpl pmi) {
    }

    @InfoMethod
    private void removingThreadFromActiveManagers(POAManagerImpl pmi) {
    }

    @Poa
    void enter() {
        this.checkState();
        this.nInvocations.getAndIncrement();
        activeManagers.get().add((Object)this);
        this.addingThreadToActiveManagers(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Poa
    void exit() {
        try {
            activeManagers.get().remove((Object)this);
            this.removingThreadFromActiveManagers(this);
        }
        finally {
            if (this.nInvocations.decrementAndGet() == 0) {
                int num = this.nWaiters.get();
                this.nWaiters(num);
                if (num > 0) {
                    this.stateLock.writeLock().lock();
                    try {
                        this.stateCV.signalAll();
                    }
                    finally {
                        this.stateLock.writeLock().unlock();
                    }
                }
            }
        }
    }

    public void implicitActivation() {
        if (!this.explicitStateChange) {
            try {
                this.activate();
            }
            catch (AdapterInactive adapterInactive) {
                // empty catch block
            }
        }
    }

    @Poa
    private static class POAManagerDeactivator
    implements Runnable {
        private boolean etherealize_objects;
        private final POAManagerImpl pmi;

        @InfoMethod
        private void poaManagerDeactivatorCall(boolean etherealizeObjects, POAManagerImpl pmi) {
        }

        @InfoMethod
        private void preparingToEtherealize(POAManagerImpl pmi) {
        }

        @InfoMethod
        private void removeAndClear(POAManagerImpl pmi) {
        }

        POAManagerDeactivator(POAManagerImpl pmi, boolean etherealize_objects) {
            this.etherealize_objects = etherealize_objects;
            this.pmi = pmi;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Poa
        public void run() {
            this.pmi.stateLock.writeLock().lock();
            try {
                this.poaManagerDeactivatorCall(this.etherealize_objects, this.pmi);
                while (this.pmi.nInvocations.get() > 0) {
                    this.pmi.countedWait();
                }
            }
            finally {
                this.pmi.stateLock.writeLock().unlock();
            }
            if (this.etherealize_objects) {
                HashSet copyOfPOAs;
                this.pmi.stateLock.readLock().lock();
                try {
                    this.preparingToEtherealize(this.pmi);
                    copyOfPOAs = new HashSet(this.pmi.poas);
                }
                finally {
                    this.pmi.stateLock.readLock().unlock();
                }
                for (POAImpl poa : copyOfPOAs) {
                    poa.etherealizeAll();
                }
                this.pmi.stateLock.writeLock().lock();
                try {
                    this.removeAndClear(this.pmi);
                    this.pmi.factory.removePoaManager(this.pmi);
                    this.pmi.poas.clear();
                }
                finally {
                    this.pmi.stateLock.writeLock().unlock();
                }
            }
        }
    }
}

