/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import org.protege.editor.core.Disposable;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;
import org.protege.editor.core.ui.preferences.PreferencesPanel;
import org.protege.editor.core.ui.preferences.PreferencesPanelPlugin;
import org.protege.editor.core.ui.preferences.PreferencesPanelPluginLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferencesDialogPanel
extends JPanel
implements Disposable {
    public static final String RESET_PREFERENCES_CONFIRMATION_DIALOG_TITLE = "Reset preferences?";
    public static final String RESET_PREFERENCES_CONFIRMATION_DIALOG_MESSAGE = "Are you sure you want to reset ALL preferences to their default settings?";
    public static final int DIALOG_DEFAULT_WIDTH = 850;
    public static final int DIALOG_DEFAULT_HEIGHT = 600;
    private final Map<String, PreferencesPanel> map = new HashMap<String, PreferencesPanel>();
    private final Map<String, JComponent> componentMap = new HashMap<String, JComponent>();
    private final JTabbedPane tabbedPane = new JTabbedPane();
    private static final String PREFS_HISTORY_PANEL_KEY = "prefs.history.panel";
    private final Logger logger = LoggerFactory.getLogger(PreferencesDialogPanel.class);
    private final EditorKit editorKit;

    public PreferencesDialogPanel(EditorKit editorKit) {
        this.editorKit = editorKit;
        this.setLayout(new BorderLayout());
        this.add(this.tabbedPane);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int margin = 300;
        int prefWidth = Math.min(screenSize.width - margin, 850);
        int prefHeight = Math.min(screenSize.height - margin, 600);
        this.setPreferredSize(new Dimension(prefWidth, prefHeight));
        this.reload();
    }

    private void reload() {
        this.dispose();
        this.tabbedPane.removeAll();
        PreferencesPanelPluginLoader loader = new PreferencesPanelPluginLoader(this.editorKit);
        TreeSet plugins = new TreeSet((o1, o2) -> {
            String s1 = o1.getLabel();
            String s2 = o2.getLabel();
            return s1.compareTo(s2);
        });
        plugins.addAll(loader.getPlugins());
        for (PreferencesPanelPlugin plugin : plugins) {
            try {
                PreferencesPanel panel = (PreferencesPanel)plugin.newInstance();
                panel.initialise();
                String label = plugin.getLabel();
                JScrollPane sp = new JScrollPane(panel);
                sp.setBorder(new EmptyBorder(0, 0, 0, 0));
                this.map.put(label, panel);
                this.componentMap.put(label, sp);
                this.tabbedPane.addTab(label, sp);
            }
            catch (Throwable e) {
                this.logger.warn("An error occurred whilst trying to instantiate the preferences panel plugin '{}': {}", (Object)plugin.getLabel(), (Object)e);
            }
        }
    }

    @Override
    public void dispose() {
        for (PreferencesPanel panel : new ArrayList<PreferencesPanel>(this.map.values())) {
            try {
                panel.dispose();
            }
            catch (Throwable e) {
                this.logger.warn("An error occurred whilst disposing of the preferences panel plugin '{}': {}", (Object)panel.getLabel(), (Object)e);
            }
        }
        this.map.clear();
    }

    public void applyPreferences() {
        for (PreferencesPanel panel : new ArrayList<PreferencesPanel>(this.map.values())) {
            try {
                panel.applyChanges();
            }
            catch (Throwable e) {
                this.logger.warn("An error occurred whilst trying to save the preferences for the preferences panel '{}': {}", (Object)panel.getLabel(), (Object)e);
            }
        }
    }

    protected String getSelectedPanel() {
        Component c = this.tabbedPane.getSelectedComponent();
        if (c instanceof JScrollPane) {
            c = ((JScrollPane)c).getViewport().getView();
        }
        for (String tabName : this.map.keySet()) {
            if (!c.equals(this.map.get(tabName))) continue;
            return tabName;
        }
        return null;
    }

    protected void setSelectedPanel(String tabName) {
        Component c = this.componentMap.get(tabName);
        if (c != null) {
            this.tabbedPane.setSelectedComponent(c);
        }
    }

    public static void showPreferencesDialog(String selectedPanel, EditorKit editorKit) {
        int ret;
        final PreferencesDialogPanel preferencesPanel = new PreferencesDialogPanel(editorKit);
        JPanel holder = new JPanel(new BorderLayout(4, 4));
        holder.add(preferencesPanel);
        if (selectedPanel == null) {
            Preferences prefs = PreferencesManager.getInstance().getApplicationPreferences(PreferencesDialogPanel.class);
            selectedPanel = prefs.getString(PREFS_HISTORY_PANEL_KEY, null);
        }
        preferencesPanel.setSelectedPanel(selectedPanel);
        JPanel resetPanel = new JPanel(new FlowLayout(0));
        JButton resetPreferencesButton = new JButton(new AbstractAction("Reset preferences..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesDialogPanel.handleResetPreferences(preferencesPanel);
            }
        });
        resetPanel.add(resetPreferencesButton);
        holder.add((Component)resetPanel, "South");
        JOptionPane op = new JOptionPane(holder, -1, 2);
        JDialog dlg = op.createDialog(editorKit.getWorkspace(), "Preferences");
        dlg.setResizable(true);
        dlg.setVisible(true);
        Object o = op.getValue();
        if (o != null && (ret = ((Integer)o).intValue()) == 0) {
            preferencesPanel.applyPreferences();
        }
        PreferencesManager.getInstance().getApplicationPreferences(PreferencesDialogPanel.class).putString(PREFS_HISTORY_PANEL_KEY, preferencesPanel.getSelectedPanel());
        preferencesPanel.dispose();
    }

    private static void handleResetPreferences(PreferencesDialogPanel panel) {
        String selectedPanel = panel.getSelectedPanel();
        int ret = JOptionPane.showConfirmDialog(panel, RESET_PREFERENCES_CONFIRMATION_DIALOG_MESSAGE, RESET_PREFERENCES_CONFIRMATION_DIALOG_TITLE, 0, 2);
        if (ret == 0) {
            PreferencesManager.getInstance().resetPreferencesToFactorySettings();
        }
        panel.reload();
        panel.setSelectedPanel(selectedPanel);
    }
}

