/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.testFramework.classic;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import com.jediterm.terminal.Terminal;
import com.jediterm.terminal.model.TerminalLine;
import com.jediterm.terminal.model.TerminalModelListener;
import com.jediterm.terminal.model.TerminalTextBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import org.jetbrains.annotations.NotNull;

class ClassicTerminalTestBufferWatcher {
    private static final Logger LOG = Logger.getInstance(ClassicTerminalTestBufferWatcher.class);
    private final TerminalTextBuffer myBuffer;
    private final Terminal myTerminal;

    ClassicTerminalTestBufferWatcher(@NotNull TerminalTextBuffer buffer, @NotNull Terminal terminal) {
        if (buffer == null) {
            ClassicTerminalTestBufferWatcher.$$$reportNull$$$0(0);
        }
        if (terminal == null) {
            ClassicTerminalTestBufferWatcher.$$$reportNull$$$0(1);
        }
        this.myBuffer = buffer;
        this.myTerminal = terminal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private List<String> getScreenLines(boolean aboveCursorLine) {
        ArrayList<String> screenLines = new ArrayList<String>();
        this.myBuffer.lock();
        try {
            int cursorLineInd = this.myTerminal.getCursorY() - 1;
            for (int row = 0; row < this.myBuffer.getHeight(); ++row) {
                if (aboveCursorLine && row >= cursorLineInd) continue;
                TerminalLine line = this.myBuffer.getLine(row);
                screenLines.add(line.getText());
            }
        }
        finally {
            this.myBuffer.unlock();
        }
        ArrayList<String> arrayList = screenLines;
        if (arrayList == null) {
            ClassicTerminalTestBufferWatcher.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public void awaitScreenLinesAre(@NotNull List<String> expectedScreenLines, long timeoutMillis) {
        boolean ok;
        if (expectedScreenLines == null) {
            ClassicTerminalTestBufferWatcher.$$$reportNull$$$0(3);
        }
        if (!(ok = this.awaitBuffer(() -> expectedScreenLines.equals(this.getScreenLines(true)), timeoutMillis))) {
            this.assertScreenLines(expectedScreenLines);
            throw new AssertionError((Object)"Unexpected failure");
        }
    }

    public void awaitScreenLinesEndWith(@NotNull List<String> expectedScreenLines, long timeoutMillis) {
        boolean ok;
        if (expectedScreenLines == null) {
            ClassicTerminalTestBufferWatcher.$$$reportNull$$$0(4);
        }
        if (!(ok = this.awaitBuffer(() -> this.checkScreenLinesEndWith(expectedScreenLines), timeoutMillis))) {
            this.assertScreenLines(expectedScreenLines);
            throw new AssertionError((Object)"Unexpected failure");
        }
    }

    private void assertScreenLines(@NotNull List<String> expectedScreenLines) {
        List<String> actualScreenLines;
        if (expectedScreenLines == null) {
            ClassicTerminalTestBufferWatcher.$$$reportNull$$$0(5);
        }
        if (!ContainerUtil.equalsIdentity(expectedScreenLines, actualScreenLines = this.getScreenLines(true))) {
            throw new AssertionError((Object)("Expected:\n" + String.valueOf(expectedScreenLines) + "\nActual:\n" + String.valueOf(actualScreenLines)));
        }
    }

    public boolean awaitBuffer(final @NotNull BooleanSupplier awaitCondition, long timeoutMillis) {
        if (awaitCondition == null) {
            ClassicTerminalTestBufferWatcher.$$$reportNull$$$0(6);
        }
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicBoolean ok = new AtomicBoolean(false);
        TerminalModelListener listener2 = new TerminalModelListener(){

            public void modelChanged() {
                if (awaitCondition.getAsBoolean()) {
                    ok.set(true);
                    latch.countDown();
                }
            }
        };
        this.myBuffer.addModelListener(listener2);
        if (awaitCondition.getAsBoolean()) {
            this.myBuffer.removeModelListener(listener2);
            return true;
        }
        try {
            latch.await(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LOG.debug("Could not get response in " + timeoutMillis + "ms. Terminal screen lines are: " + this.getScreenLines());
            throw new AssertionError((Object)e);
        }
        finally {
            this.myBuffer.removeModelListener(listener2);
        }
        return ok.get();
    }

    public boolean checkScreenLinesEndWith(@NotNull List<String> expectedScreenLines) {
        List<String> actualLines;
        if (expectedScreenLines == null) {
            ClassicTerminalTestBufferWatcher.$$$reportNull$$$0(7);
        }
        if ((actualLines = this.getScreenLines(true)).size() < expectedScreenLines.size()) {
            return false;
        }
        List<String> lastActualLines = actualLines.subList(actualLines.size() - expectedScreenLines.size(), actualLines.size());
        return expectedScreenLines.equals(lastActualLines);
    }

    public String getScreenLines() {
        return this.myBuffer.getScreenLines();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminal";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/testFramework/classic/ClassicTerminalTestBufferWatcher";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedScreenLines";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "awaitCondition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/testFramework/classic/ClassicTerminalTestBufferWatcher";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getScreenLines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "awaitScreenLinesAre";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "awaitScreenLinesEndWith";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "assertScreenLines";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "awaitBuffer";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkScreenLinesEndWith";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

