/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.repository.manager;

import com.ibm.db2.cmx.runtime.internal.repository.MetadataException;
import com.ibm.db2.cmx.runtime.internal.repository.api.IncrementalSavedDataInfo;
import com.ibm.db2.cmx.runtime.internal.repository.api.MDOutputStream;
import com.ibm.db2.cmx.runtime.internal.repository.api.exception.MetadataIOException;
import com.ibm.db2.cmx.runtime.internal.repository.manager.IncrementalDataManagerImpl;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class MDOutputStreamImpl
extends MDOutputStream {
    private IncrementalDataManagerImpl idm = null;
    private String groupName = null;
    private String groupVersion = null;
    private Integer metadataKey = null;
    private ZipOutputStream zos = null;
    private ByteArrayOutputStream os = null;
    private int bytesWritten = 0;
    private IncrementalSavedDataInfo savedDataInfo = null;

    public MDOutputStreamImpl(IncrementalDataManagerImpl incrementalDataManagerImpl, String string, String string2, Integer n2) throws MetadataException {
        this.idm = incrementalDataManagerImpl;
        this.groupName = string;
        this.groupVersion = string2;
        this.metadataKey = n2;
        this.os = new ByteArrayOutputStream();
        this.zos = new ZipOutputStream(this.os);
        try {
            this.zos.putNextEntry(new ZipEntry("data"));
        }
        catch (IOException iOException) {
            throw new MetadataException(Messages.getText("ERR_INITIALIZING_COMPRESSION_STREAM", new Object[0]), iOException);
        }
    }

    @Override
    public IncrementalSavedDataInfo getDataInfo() {
        return this.savedDataInfo;
    }

    @Override
    public void write(int n2) throws IOException {
        this.zos.write(n2);
        ++this.bytesWritten;
    }

    @Override
    public void close() throws MetadataIOException, IOException {
        Object object;
        boolean bl2;
        Logger logger = Log.getLogger();
        boolean bl3 = bl2 = logger != null && logger.isLoggable(Level.FINE);
        if (bl2) {
            object = "runtimeGroupId " + this.groupName + " version " + this.groupVersion + " writing to key " + this.metadataKey;
            logger.logp(Level.FINE, "MDOutputStreamImpl", "close", (String)object);
        }
        super.close();
        this.zos.close();
        object = this.os.toByteArray();
        if (bl2) {
            logger.logp(Level.FINE, "MDOutputStreamImpl", "close", "Total bytes to be written : " + ((byte[])object).length + " (uncompressed size " + this.bytesWritten + " )");
        }
        try {
            int n2;
            if (this.metadataKey != null) {
                if (bl2) {
                    logger.logp(Level.FINE, "MDOutputStreamImpl", "close", "Attempting to update content of metadataKey " + this.metadataKey);
                }
                n2 = this.idm.updateContent(this.metadataKey, (byte[])object, this.bytesWritten);
                if (bl2) {
                    logger.logp(Level.FINE, "MDOutputStreamImpl", "close", "Success of updateContent " + (n2 != 0));
                }
                if (n2 == 0) {
                    this.metadataKey = null;
                }
            }
            if (this.metadataKey == null) {
                if (bl2) {
                    logger.logp(Level.FINE, "MDOutputStreamImpl", "close", "Attempting to create new entry in CAPTUREDATA_T table ");
                }
                n2 = this.idm.create(this.groupName, this.groupVersion, (byte[])object, this.bytesWritten);
                this.metadataKey = n2;
                if (bl2) {
                    logger.logp(Level.FINE, "MDOutputStreamImpl", "close", "New entry created.  MetadataSrcKey is  " + n2);
                }
            }
            if (bl2) {
                logger.logp(Level.FINE, "MDOutputStreamImpl", "close", "Getting savedDataInfo for newly written data ");
            }
            this.savedDataInfo = this.idm.getIncrementalSavedDataInfo(this.metadataKey);
            if (bl2) {
                String string = "No incremental saved data info returned";
                if (this.savedDataInfo != null) {
                    Date date = new Date(this.savedDataInfo.getUpdateTime());
                    string = "IncrementalSavedDataInfo for new data:  pdqxml data size " + this.savedDataInfo.getLength() + " bytes.  Updated at " + date.toString() + " with key " + this.savedDataInfo.getKey();
                }
                logger.logp(Level.FINE, "MDOutputStreamImpl", "close", string);
            }
        }
        catch (MetadataException metadataException) {
            if (bl2) {
                logger.log(Level.FINE, "Caught error in close().  Will rethrow.", metadataException);
            }
            String string = Messages.getText("ERR_WRITING_TO_CAPTURE_DATA_TABLE", this.groupName, this.groupVersion, this.metadataKey);
            throw new MetadataIOException(string, metadataException);
        }
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.zos.write(byArray, n2, n3);
        this.bytesWritten += n3;
    }
}

