/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import java.io.IOException;

public class TextualContentCommand
extends ControlSequence
implements Expandable {
    protected String text;
    protected Object data;

    public TextualContentCommand(String string, String string2) {
        this(string, string2, null);
    }

    public TextualContentCommand(String string, String string2, Object object) {
        super(string);
        if (string2 == null) {
            throw new NullPointerException();
        }
        this.text = string2;
        this.data = object;
    }

    @Override
    public Object clone() {
        return new TextualContentCommand(this.getName(), this.getText(), this.getData());
    }

    public TextualContentCommand duplicate(String string) {
        TextualContentCommand textualContentCommand = (TextualContentCommand)this.clone();
        textualContentCommand.name = string;
        return textualContentCommand;
    }

    @Override
    public boolean canExpand() {
        return true;
    }

    @Override
    public boolean isDataObject() {
        return true;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser, teXParser);
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return teXParser.getListener().createString(this.text);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandonce(teXParser, teXObjectList);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        teXParser.getListener().getWriteable().write(this.text);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public void setText(String string, Object object) {
        this.text = string;
        this.data = object;
    }

    public Object getData() {
        return this.data;
    }

    @Override
    public boolean isEmpty() {
        return this.text.isEmpty();
    }

    @Override
    public String toString() {
        return String.format("%s[name=%s,text=%s,data=%s]", this.getClass().getSimpleName(), this.getName(), this.getText(), this.getData());
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof TextualContentCommand) || object == null) {
            return false;
        }
        TextualContentCommand textualContentCommand = (TextualContentCommand)object;
        if (!this.text.equals(textualContentCommand.text)) {
            return false;
        }
        if (this.data == null && textualContentCommand.data == null) {
            return true;
        }
        if (this.data == null || textualContentCommand.data == null) {
            return false;
        }
        return this.data.equals(textualContentCommand.data);
    }
}

