/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.util;

import java.io.IOException;
import java.net.MulticastSocket;
import java.net.StandardSocketOptions;
import org.apache.catalina.tribes.util.JreCompat;
import org.apache.catalina.tribes.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class Jre14Compat
extends JreCompat {
    private static final Log log = LogFactory.getLog(Jre14Compat.class);
    private static final StringManager sm = StringManager.getManager(Jre14Compat.class);
    private static final boolean supported;

    static boolean isSupported() {
        return supported;
    }

    @Override
    public void setSocketoptionIpMulticastLoop(MulticastSocket multicastSocket, boolean bl) throws IOException {
        multicastSocket.setOption(StandardSocketOptions.IP_MULTICAST_LOOP, bl);
    }

    static {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("java.io.Serial");
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.debug((Object)sm.getString("jre14Compat.javaPre14"), (Throwable)classNotFoundException);
        }
        supported = clazz != null;
    }
}

