// Licensed under the Apache License, Version 2.0
// <LICENSE-APACHE or http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your option.
// All files in the project carrying such notice may not be copied, modified, or distributed
// except according to those terms.
use shared::minwindef::DWORD;
use shared::ntdef::{DOUBLE, LONG};
use shared::wtypes::PROPERTYKEY;
DEFINE_PROPERTYKEY!{PKEY_Audio_ChannelCount,
    0x64440490, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 7}
pub const AUDIO_CHANNELCOUNT_MONO: DWORD = 1;
pub const AUDIO_CHANNELCOUNT_STEREO: DWORD = 2;
DEFINE_PROPERTYKEY!{PKEY_Audio_Compression,
    0x64440490, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 10}
DEFINE_PROPERTYKEY!{PKEY_Audio_EncodingBitrate,
    0x64440490, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 4}
DEFINE_PROPERTYKEY!{PKEY_Audio_Format,
    0x64440490, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 2}
DEFINE_PROPERTYKEY!{PKEY_Audio_IsVariableBitRate,
    0xE6822FEE, 0x8C17, 0x4D62, 0x82, 0x3C, 0x8E, 0x9C, 0xFC, 0xBD, 0x1D, 0x5C, 100}
DEFINE_PROPERTYKEY!{PKEY_Audio_PeakValue,
    0x2579E5D0, 0x1116, 0x4084, 0xBD, 0x9A, 0x9B, 0x4F, 0x7C, 0xB4, 0xDF, 0x5E, 100}
DEFINE_PROPERTYKEY!{PKEY_Audio_SampleRate,
    0x64440490, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 5}
DEFINE_PROPERTYKEY!{PKEY_Audio_SampleSize,
    0x64440490, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 6}
DEFINE_PROPERTYKEY!{PKEY_Audio_StreamName,
    0x64440490, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 9}
DEFINE_PROPERTYKEY!{PKEY_Audio_StreamNumber,
    0x64440490, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 8}
DEFINE_PROPERTYKEY!{PKEY_Calendar_Duration,
    0x293CA35A, 0x09AA, 0x4DD2, 0xB1, 0x80, 0x1F, 0xE2, 0x45, 0x72, 0x8A, 0x52, 100}
DEFINE_PROPERTYKEY!{PKEY_Calendar_IsOnline,
    0xBFEE9149, 0xE3E2, 0x49A7, 0xA8, 0x62, 0xC0, 0x59, 0x88, 0x14, 0x5C, 0xEC, 100}
DEFINE_PROPERTYKEY!{PKEY_Calendar_IsRecurring,
    0x315B9C8D, 0x80A9, 0x4EF9, 0xAE, 0x16, 0x8E, 0x74, 0x6D, 0xA5, 0x1D, 0x70, 100}
DEFINE_PROPERTYKEY!{PKEY_Calendar_Location,
    0xF6272D18, 0xCECC, 0x40B1, 0xB2, 0x6A, 0x39, 0x11, 0x71, 0x7A, 0xA7, 0xBD, 100}
DEFINE_PROPERTYKEY!{PKEY_Calendar_OptionalAttendeeAddresses,
    0xD55BAE5A, 0x3892, 0x417A, 0xA6, 0x49, 0xC6, 0xAC, 0x5A, 0xAA, 0xEA, 0xB3, 100}
DEFINE_PROPERTYKEY!{PKEY_Calendar_OptionalAttendeeNames,
    0x09429607, 0x582D, 0x437F, 0x84, 0xC3, 0xDE, 0x93, 0xA2, 0xB2, 0x4C, 0x3C, 100}
DEFINE_PROPERTYKEY!{PKEY_Calendar_OrganizerAddress,
    0x744C8242, 0x4DF5, 0x456C, 0xAB, 0x9E, 0x01, 0x4E, 0xFB, 0x90, 0x21, 0xE3, 100}
DEFINE_PROPERTYKEY!{PKEY_Calendar_OrganizerName,
    0xAAA660F9, 0x9865, 0x458E, 0xB4, 0x84, 0x01, 0xBC, 0x7F, 0xE3, 0x97, 0x3E, 100}
DEFINE_PROPERTYKEY!{PKEY_Calendar_ReminderTime,
    0x72FC5BA4, 0x24F9, 0x4011, 0x9F, 0x3F, 0xAD, 0xD2, 0x7A, 0xFA, 0xD8, 0x18, 100}
DEFINE_PROPERTYKEY!{PKEY_Calendar_RequiredAttendeeAddresses,
    0x0BA7D6C3, 0x568D, 0x4159, 0xAB, 0x91, 0x78, 0x1A, 0x91, 0xFB, 0x71, 0xE5, 100}
DEFINE_PROPERTYKEY!{PKEY_Calendar_RequiredAttendeeNames,
    0xB33AF30B, 0xF552, 0x4584, 0x93, 0x6C, 0xCB, 0x93, 0xE5, 0xCD, 0xA2, 0x9F, 100}
DEFINE_PROPERTYKEY!{PKEY_Calendar_Resources,
    0x00F58A38, 0xC54B, 0x4C40, 0x86, 0x96, 0x97, 0x23, 0x59, 0x80, 0xEA, 0xE1, 100}
DEFINE_PROPERTYKEY!{PKEY_Calendar_ResponseStatus,
    0x188C1F91, 0x3C40, 0x4132, 0x9E, 0xC5, 0xD8, 0xB0, 0x3B, 0x72, 0xA8, 0xA2, 100}
pub const CALENDAR_RESPONSESTATUS_NONE: DWORD = 0;
pub const CALENDAR_RESPONSESTATUS_ORGANIZED: DWORD = 1;
pub const CALENDAR_RESPONSESTATUS_TENTATIVE: DWORD = 2;
pub const CALENDAR_RESPONSESTATUS_ACCEPTED: DWORD = 3;
pub const CALENDAR_RESPONSESTATUS_DECLINED: DWORD = 4;
pub const CALENDAR_RESPONSESTATUS_NOTRESPONDED: DWORD = 5;
DEFINE_PROPERTYKEY!{PKEY_Calendar_ShowTimeAs,
    0x5BF396D4, 0x5EB2, 0x466F, 0xBD, 0xE9, 0x2F, 0xB3, 0xF2, 0x36, 0x1D, 0x6E, 100}
pub const CALENDAR_SHOWTIMEAS_FREE: DWORD = 0;
pub const CALENDAR_SHOWTIMEAS_TENTATIVE: DWORD = 1;
pub const CALENDAR_SHOWTIMEAS_BUSY: DWORD = 2;
pub const CALENDAR_SHOWTIMEAS_OOF: DWORD = 3;
DEFINE_PROPERTYKEY!{PKEY_Calendar_ShowTimeAsText,
    0x53DA57CF, 0x62C0, 0x45C4, 0x81, 0xDE, 0x76, 0x10, 0xBC, 0xEF, 0xD7, 0xF5, 100}
DEFINE_PROPERTYKEY!{PKEY_Communication_AccountName,
    0xE3E0584C, 0xB788, 0x4A5A, 0xBB, 0x20, 0x7F, 0x5A, 0x44, 0xC9, 0xAC, 0xDD, 9}
DEFINE_PROPERTYKEY!{PKEY_Communication_DateItemExpires,
    0x428040AC, 0xA177, 0x4C8A, 0x97, 0x60, 0xF6, 0xF7, 0x61, 0x22, 0x7F, 0x9A, 100}
DEFINE_PROPERTYKEY!{PKEY_Communication_Direction,
    0x8E531030, 0xB960, 0x4346, 0xAE, 0x0D, 0x66, 0xBC, 0x9A, 0x86, 0xFB, 0x94, 100}
pub const COMMUNICATION_DIRECTION_UNKNOWN: DWORD = 0;
pub const COMMUNICATION_DIRECTION_INCOMING: DWORD = 1;
pub const COMMUNICATION_DIRECTION_OUTGOING: DWORD = 2;
DEFINE_PROPERTYKEY!{PKEY_Communication_FollowupIconIndex,
    0x83A6347E, 0x6FE4, 0x4F40, 0xBA, 0x9C, 0xC4, 0x86, 0x52, 0x40, 0xD1, 0xF4, 100}
DEFINE_PROPERTYKEY!{PKEY_Communication_HeaderItem,
    0xC9C34F84, 0x2241, 0x4401, 0xB6, 0x07, 0xBD, 0x20, 0xED, 0x75, 0xAE, 0x7F, 100}
DEFINE_PROPERTYKEY!{PKEY_Communication_PolicyTag,
    0xEC0B4191, 0xAB0B, 0x4C66, 0x90, 0xB6, 0xC6, 0x63, 0x7C, 0xDE, 0xBB, 0xAB, 100}
DEFINE_PROPERTYKEY!{PKEY_Communication_SecurityFlags,
    0x8619A4B6, 0x9F4D, 0x4429, 0x8C, 0x0F, 0xB9, 0x96, 0xCA, 0x59, 0xE3, 0x35, 100}
DEFINE_PROPERTYKEY!{PKEY_Communication_Suffix,
    0x807B653A, 0x9E91, 0x43EF, 0x8F, 0x97, 0x11, 0xCE, 0x04, 0xEE, 0x20, 0xC5, 100}
DEFINE_PROPERTYKEY!{PKEY_Communication_TaskStatus,
    0xBE1A72C6, 0x9A1D, 0x46B7, 0xAF, 0xE7, 0xAF, 0xAF, 0x8C, 0xEF, 0x49, 0x99, 100}
pub const TASKSTATUS_NOTSTARTED: DWORD = 0;
pub const TASKSTATUS_INPROGRESS: DWORD = 1;
pub const TASKSTATUS_COMPLETE: DWORD = 2;
pub const TASKSTATUS_WAITING: DWORD = 3;
pub const TASKSTATUS_DEFERRED: DWORD = 4;
DEFINE_PROPERTYKEY!{PKEY_Communication_TaskStatusText,
    0xA6744477, 0xC237, 0x475B, 0xA0, 0x75, 0x54, 0xF3, 0x44, 0x98, 0x29, 0x2A, 100}
DEFINE_PROPERTYKEY!{PKEY_Computer_DecoratedFreeSpace,
    0x9B174B35, 0x40FF, 0x11D2, 0xA2, 0x7E, 0x00, 0xC0, 0x4F, 0xC3, 0x08, 0x71, 7}
DEFINE_PROPERTYKEY!{PKEY_Contact_AccountPictureDynamicVideo,
    0x0B8BB018, 0x2725, 0x4B44, 0x92, 0xBA, 0x79, 0x33, 0xAE, 0xB2, 0xDD, 0xE7, 2}
DEFINE_PROPERTYKEY!{PKEY_Contact_AccountPictureLarge,
    0x0B8BB018, 0x2725, 0x4B44, 0x92, 0xBA, 0x79, 0x33, 0xAE, 0xB2, 0xDD, 0xE7, 3}
DEFINE_PROPERTYKEY!{PKEY_Contact_AccountPictureSmall,
    0x0B8BB018, 0x2725, 0x4B44, 0x92, 0xBA, 0x79, 0x33, 0xAE, 0xB2, 0xDD, 0xE7, 4}
DEFINE_PROPERTYKEY!{PKEY_Contact_Anniversary,
    0x9AD5BADB, 0xCEA7, 0x4470, 0xA0, 0x3D, 0xB8, 0x4E, 0x51, 0xB9, 0x94, 0x9E, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_AssistantName,
    0xCD102C9C, 0x5540, 0x4A88, 0xA6, 0xF6, 0x64, 0xE4, 0x98, 0x1C, 0x8C, 0xD1, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_AssistantTelephone,
    0x9A93244D, 0xA7AD, 0x4FF8, 0x9B, 0x99, 0x45, 0xEE, 0x4C, 0xC0, 0x9A, 0xF6, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_Birthday,
    0x176DC63C, 0x2688, 0x4E89, 0x81, 0x43, 0xA3, 0x47, 0x80, 0x0F, 0x25, 0xE9, 47}
DEFINE_PROPERTYKEY!{PKEY_Contact_BusinessAddress,
    0x730FB6DD, 0xCF7C, 0x426B, 0xA0, 0x3F, 0xBD, 0x16, 0x6C, 0xC9, 0xEE, 0x24, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_BusinessAddress1Country,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 119}
DEFINE_PROPERTYKEY!{PKEY_Contact_BusinessAddress1Locality,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 117}
DEFINE_PROPERTYKEY!{PKEY_Contact_BusinessAddress1PostalCode,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 120}
DEFINE_PROPERTYKEY!{PKEY_Contact_BusinessAddress1Region,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 118}
DEFINE_PROPERTYKEY!{PKEY_Contact_BusinessAddress1Street,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 116}
DEFINE_PROPERTYKEY!{PKEY_Contact_BusinessAddress2Country,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 124}
DEFINE_PROPERTYKEY!{PKEY_Contact_BusinessAddress2Locality,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 122}
DEFINE_PROPERTYKEY!{PKEY_Contact_BusinessAddress2PostalCode,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 125}
DEFINE_PROPERTYKEY!{PKEY_Contact_BusinessAddress2Region,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 123}
DEFINE_PROPERTYKEY!{PKEY_Contact_BusinessAddress2Street,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 121}
DEFINE_PROPERTYKEY!{PKEY_Contact_BusinessAddress3Country,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 129}
DEFINE_PROPERTYKEY!{PKEY_Contact_BusinessAddress3Locality,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 127}
DEFINE_PROPERTYKEY!{PKEY_Contact_BusinessAddress3PostalCode,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 130}
DEFINE_PROPERTYKEY!{PKEY_Contact_BusinessAddress3Region,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 128}
DEFINE_PROPERTYKEY!{PKEY_Contact_BusinessAddress3Street,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 126}
DEFINE_PROPERTYKEY!{PKEY_Contact_BusinessAddressCity,
    0x402B5934, 0xEC5A, 0x48C3, 0x93, 0xE6, 0x85, 0xE8, 0x6A, 0x2D, 0x93, 0x4E, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_BusinessAddressCountry,
    0xB0B87314, 0xFCF6, 0x4FEB, 0x8D, 0xFF, 0xA5, 0x0D, 0xA6, 0xAF, 0x56, 0x1C, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_BusinessAddressPostalCode,
    0xE1D4A09E, 0xD758, 0x4CD1, 0xB6, 0xEC, 0x34, 0xA8, 0xB5, 0xA7, 0x3F, 0x80, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_BusinessAddressPostOfficeBox,
    0xBC4E71CE, 0x17F9, 0x48D5, 0xBE, 0xE9, 0x02, 0x1D, 0xF0, 0xEA, 0x54, 0x09, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_BusinessAddressState,
    0x446F787F, 0x10C4, 0x41CB, 0xA6, 0xC4, 0x4D, 0x03, 0x43, 0x55, 0x15, 0x97, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_BusinessAddressStreet,
    0xDDD1460F, 0xC0BF, 0x4553, 0x8C, 0xE4, 0x10, 0x43, 0x3C, 0x90, 0x8F, 0xB0, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_BusinessEmailAddresses,
    0xF271C659, 0x7E5E, 0x471F, 0xBA, 0x25, 0x7F, 0x77, 0xB2, 0x86, 0xF8, 0x36, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_BusinessFaxNumber,
    0x91EFF6F3, 0x2E27, 0x42CA, 0x93, 0x3E, 0x7C, 0x99, 0x9F, 0xBE, 0x31, 0x0B, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_BusinessHomePage,
    0x56310920, 0x2491, 0x4919, 0x99, 0xCE, 0xEA, 0xDB, 0x06, 0xFA, 0xFD, 0xB2, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_BusinessTelephone,
    0x6A15E5A0, 0x0A1E, 0x4CD7, 0xBB, 0x8C, 0xD2, 0xF1, 0xB0, 0xC9, 0x29, 0xBC, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_CallbackTelephone,
    0xBF53D1C3, 0x49E0, 0x4F7F, 0x85, 0x67, 0x5A, 0x82, 0x1D, 0x8A, 0xC5, 0x42, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_CarTelephone,
    0x8FDC6DEA, 0xB929, 0x412B, 0xBA, 0x90, 0x39, 0x7A, 0x25, 0x74, 0x65, 0xFE, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_Children,
    0xD4729704, 0x8EF1, 0x43EF, 0x90, 0x24, 0x2B, 0xD3, 0x81, 0x18, 0x7F, 0xD5, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_CompanyMainTelephone,
    0x8589E481, 0x6040, 0x473D, 0xB1, 0x71, 0x7F, 0xA8, 0x9C, 0x27, 0x08, 0xED, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_ConnectedServiceDisplayName,
    0x39B77F4F, 0xA104, 0x4863, 0xB3, 0x95, 0x2D, 0xB2, 0xAD, 0x8F, 0x7B, 0xC1, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_ConnectedServiceIdentities,
    0x80F41EB8, 0xAFC4, 0x4208, 0xAA, 0x5F, 0xCC, 0xE2, 0x1A, 0x62, 0x72, 0x81, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_ConnectedServiceName,
    0xB5C84C9E, 0x5927, 0x46B5, 0xA3, 0xCC, 0x93, 0x3C, 0x21, 0xB7, 0x84, 0x69, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_ConnectedServiceSupportedActions,
    0xA19FB7A9, 0x024B, 0x4371, 0xA8, 0xBF, 0x4D, 0x29, 0xC3, 0xE4, 0xE9, 0xC9, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_DataSuppliers,
    0x9660C283, 0xFC3A, 0x4A08, 0xA0, 0x96, 0xEE, 0xD3, 0xAA, 0xC4, 0x6D, 0xA2, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_Department,
    0xFC9F7306, 0xFF8F, 0x4D49, 0x9F, 0xB6, 0x3F, 0xFE, 0x5C, 0x09, 0x51, 0xEC, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_DisplayBusinessPhoneNumbers,
    0x364028DA, 0xD895, 0x41FE, 0xA5, 0x84, 0x30, 0x2B, 0x1B, 0xB7, 0x0A, 0x76, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_DisplayHomePhoneNumbers,
    0x5068BCDF, 0xD697, 0x4D85, 0x8C, 0x53, 0x1F, 0x1C, 0xDA, 0xB0, 0x17, 0x63, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_DisplayMobilePhoneNumbers,
    0x9CB0C358, 0x9D7A, 0x46B1, 0xB4, 0x66, 0xDC, 0xC6, 0xF1, 0xA3, 0xD9, 0x3D, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_DisplayOtherPhoneNumbers,
    0x03089873, 0x8EE8, 0x4191, 0xBD, 0x60, 0xD3, 0x1F, 0x72, 0xB7, 0x90, 0x0B, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_EmailAddress,
    0xF8FA7FA3, 0xD12B, 0x4785, 0x8A, 0x4E, 0x69, 0x1A, 0x94, 0xF7, 0xA3, 0xE7, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_EmailAddress2,
    0x38965063, 0xEDC8, 0x4268, 0x84, 0x91, 0xB7, 0x72, 0x31, 0x72, 0xCF, 0x29, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_EmailAddress3,
    0x644D37B4, 0xE1B3, 0x4BAD, 0xB0, 0x99, 0x7E, 0x7C, 0x04, 0x96, 0x6A, 0xCA, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_EmailAddresses,
    0x84D8F337, 0x981D, 0x44B3, 0x96, 0x15, 0xC7, 0x59, 0x6D, 0xBA, 0x17, 0xE3, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_EmailName,
    0xCC6F4F24, 0x6083, 0x4BD4, 0x87, 0x54, 0x67, 0x4D, 0x0D, 0xE8, 0x7A, 0xB8, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_FileAsName,
    0xF1A24AA7, 0x9CA7, 0x40F6, 0x89, 0xEC, 0x97, 0xDE, 0xF9, 0xFF, 0xE8, 0xDB, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_FirstName,
    0x14977844, 0x6B49, 0x4AAD, 0xA7, 0x14, 0xA4, 0x51, 0x3B, 0xF6, 0x04, 0x60, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_FullName,
    0x635E9051, 0x50A5, 0x4BA2, 0xB9, 0xDB, 0x4E, 0xD0, 0x56, 0xC7, 0x72, 0x96, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_Gender,
    0x3C8CEE58, 0xD4F0, 0x4CF9, 0xB7, 0x56, 0x4E, 0x5D, 0x24, 0x44, 0x7B, 0xCD, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_GenderValue,
    0x3C8CEE58, 0xD4F0, 0x4CF9, 0xB7, 0x56, 0x4E, 0x5D, 0x24, 0x44, 0x7B, 0xCD, 101}
pub const GENDERVALUE_UNSPECIFIED: DWORD = 0;
pub const GENDERVALUE_FEMALE: DWORD = 1;
pub const GENDERVALUE_MALE: DWORD = 2;
DEFINE_PROPERTYKEY!{PKEY_Contact_Hobbies,
    0x5DC2253F, 0x5E11, 0x4ADF, 0x9C, 0xFE, 0x91, 0x0D, 0xD0, 0x1E, 0x3E, 0x70, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_HomeAddress,
    0x98F98354, 0x617A, 0x46B8, 0x85, 0x60, 0x5B, 0x1B, 0x64, 0xBF, 0x1F, 0x89, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_HomeAddress1Country,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 104}
DEFINE_PROPERTYKEY!{PKEY_Contact_HomeAddress1Locality,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 102}
DEFINE_PROPERTYKEY!{PKEY_Contact_HomeAddress1PostalCode,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 105}
DEFINE_PROPERTYKEY!{PKEY_Contact_HomeAddress1Region,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 103}
DEFINE_PROPERTYKEY!{PKEY_Contact_HomeAddress1Street,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 101}
DEFINE_PROPERTYKEY!{PKEY_Contact_HomeAddress2Country,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 109}
DEFINE_PROPERTYKEY!{PKEY_Contact_HomeAddress2Locality,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 107}
DEFINE_PROPERTYKEY!{PKEY_Contact_HomeAddress2PostalCode,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 110}
DEFINE_PROPERTYKEY!{PKEY_Contact_HomeAddress2Region,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 108}
DEFINE_PROPERTYKEY!{PKEY_Contact_HomeAddress2Street,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 106}
DEFINE_PROPERTYKEY!{PKEY_Contact_HomeAddress3Country,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 114}
DEFINE_PROPERTYKEY!{PKEY_Contact_HomeAddress3Locality,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 112}
DEFINE_PROPERTYKEY!{PKEY_Contact_HomeAddress3PostalCode,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 115}
DEFINE_PROPERTYKEY!{PKEY_Contact_HomeAddress3Region,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 113}
DEFINE_PROPERTYKEY!{PKEY_Contact_HomeAddress3Street,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 111}
DEFINE_PROPERTYKEY!{PKEY_Contact_HomeAddressCity,
    0x176DC63C, 0x2688, 0x4E89, 0x81, 0x43, 0xA3, 0x47, 0x80, 0x0F, 0x25, 0xE9, 65}
DEFINE_PROPERTYKEY!{PKEY_Contact_HomeAddressCountry,
    0x08A65AA1, 0xF4C9, 0x43DD, 0x9D, 0xDF, 0xA3, 0x3D, 0x8E, 0x7E, 0xAD, 0x85, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_HomeAddressPostalCode,
    0x8AFCC170, 0x8A46, 0x4B53, 0x9E, 0xEE, 0x90, 0xBA, 0xE7, 0x15, 0x1E, 0x62, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_HomeAddressPostOfficeBox,
    0x7B9F6399, 0x0A3F, 0x4B12, 0x89, 0xBD, 0x4A, 0xDC, 0x51, 0xC9, 0x18, 0xAF, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_HomeAddressState,
    0xC89A23D0, 0x7D6D, 0x4EB8, 0x87, 0xD4, 0x77, 0x6A, 0x82, 0xD4, 0x93, 0xE5, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_HomeAddressStreet,
    0x0ADEF160, 0xDB3F, 0x4308, 0x9A, 0x21, 0x06, 0x23, 0x7B, 0x16, 0xFA, 0x2A, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_HomeEmailAddresses,
    0x56C90E9D, 0x9D46, 0x4963, 0x88, 0x6F, 0x2E, 0x1C, 0xD9, 0xA6, 0x94, 0xEF, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_HomeFaxNumber,
    0x660E04D6, 0x81AB, 0x4977, 0xA0, 0x9F, 0x82, 0x31, 0x31, 0x13, 0xAB, 0x26, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_HomeTelephone,
    0x176DC63C, 0x2688, 0x4E89, 0x81, 0x43, 0xA3, 0x47, 0x80, 0x0F, 0x25, 0xE9, 20}
DEFINE_PROPERTYKEY!{PKEY_Contact_IMAddress,
    0xD68DBD8A, 0x3374, 0x4B81, 0x99, 0x72, 0x3E, 0xC3, 0x06, 0x82, 0xDB, 0x3D, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_Initials,
    0xF3D8F40D, 0x50CB, 0x44A2, 0x97, 0x18, 0x40, 0xCB, 0x91, 0x19, 0x49, 0x5D, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_JA_CompanyNamePhonetic,
    0x897B3694, 0xFE9E, 0x43E6, 0x80, 0x66, 0x26, 0x0F, 0x59, 0x0C, 0x01, 0x00, 2}
DEFINE_PROPERTYKEY!{PKEY_Contact_JA_FirstNamePhonetic,
    0x897B3694, 0xFE9E, 0x43E6, 0x80, 0x66, 0x26, 0x0F, 0x59, 0x0C, 0x01, 0x00, 3}
DEFINE_PROPERTYKEY!{PKEY_Contact_JA_LastNamePhonetic,
    0x897B3694, 0xFE9E, 0x43E6, 0x80, 0x66, 0x26, 0x0F, 0x59, 0x0C, 0x01, 0x00, 4}
DEFINE_PROPERTYKEY!{PKEY_Contact_JobInfo1CompanyAddress,
    0x00F63DD8, 0x22BD, 0x4A5D, 0xBA, 0x34, 0x5C, 0xB0, 0xB9, 0xBD, 0xCB, 0x03, 120}
DEFINE_PROPERTYKEY!{PKEY_Contact_JobInfo1CompanyName,
    0x00F63DD8, 0x22BD, 0x4A5D, 0xBA, 0x34, 0x5C, 0xB0, 0xB9, 0xBD, 0xCB, 0x03, 102}
DEFINE_PROPERTYKEY!{PKEY_Contact_JobInfo1Department,
    0x00F63DD8, 0x22BD, 0x4A5D, 0xBA, 0x34, 0x5C, 0xB0, 0xB9, 0xBD, 0xCB, 0x03, 106}
DEFINE_PROPERTYKEY!{PKEY_Contact_JobInfo1Manager,
    0x00F63DD8, 0x22BD, 0x4A5D, 0xBA, 0x34, 0x5C, 0xB0, 0xB9, 0xBD, 0xCB, 0x03, 105}
DEFINE_PROPERTYKEY!{PKEY_Contact_JobInfo1OfficeLocation,
    0x00F63DD8, 0x22BD, 0x4A5D, 0xBA, 0x34, 0x5C, 0xB0, 0xB9, 0xBD, 0xCB, 0x03, 104}
DEFINE_PROPERTYKEY!{PKEY_Contact_JobInfo1Title,
    0x00F63DD8, 0x22BD, 0x4A5D, 0xBA, 0x34, 0x5C, 0xB0, 0xB9, 0xBD, 0xCB, 0x03, 103}
DEFINE_PROPERTYKEY!{PKEY_Contact_JobInfo1YomiCompanyName,
    0x00F63DD8, 0x22BD, 0x4A5D, 0xBA, 0x34, 0x5C, 0xB0, 0xB9, 0xBD, 0xCB, 0x03, 101}
DEFINE_PROPERTYKEY!{PKEY_Contact_JobInfo2CompanyAddress,
    0x00F63DD8, 0x22BD, 0x4A5D, 0xBA, 0x34, 0x5C, 0xB0, 0xB9, 0xBD, 0xCB, 0x03, 121}
DEFINE_PROPERTYKEY!{PKEY_Contact_JobInfo2CompanyName,
    0x00F63DD8, 0x22BD, 0x4A5D, 0xBA, 0x34, 0x5C, 0xB0, 0xB9, 0xBD, 0xCB, 0x03, 108}
DEFINE_PROPERTYKEY!{PKEY_Contact_JobInfo2Department,
    0x00F63DD8, 0x22BD, 0x4A5D, 0xBA, 0x34, 0x5C, 0xB0, 0xB9, 0xBD, 0xCB, 0x03, 113}
DEFINE_PROPERTYKEY!{PKEY_Contact_JobInfo2Manager,
    0x00F63DD8, 0x22BD, 0x4A5D, 0xBA, 0x34, 0x5C, 0xB0, 0xB9, 0xBD, 0xCB, 0x03, 112}
DEFINE_PROPERTYKEY!{PKEY_Contact_JobInfo2OfficeLocation,
    0x00F63DD8, 0x22BD, 0x4A5D, 0xBA, 0x34, 0x5C, 0xB0, 0xB9, 0xBD, 0xCB, 0x03, 110}
DEFINE_PROPERTYKEY!{PKEY_Contact_JobInfo2Title,
    0x00F63DD8, 0x22BD, 0x4A5D, 0xBA, 0x34, 0x5C, 0xB0, 0xB9, 0xBD, 0xCB, 0x03, 109}
DEFINE_PROPERTYKEY!{PKEY_Contact_JobInfo2YomiCompanyName,
    0x00F63DD8, 0x22BD, 0x4A5D, 0xBA, 0x34, 0x5C, 0xB0, 0xB9, 0xBD, 0xCB, 0x03, 107}
DEFINE_PROPERTYKEY!{PKEY_Contact_JobInfo3CompanyAddress,
    0x00F63DD8, 0x22BD, 0x4A5D, 0xBA, 0x34, 0x5C, 0xB0, 0xB9, 0xBD, 0xCB, 0x03, 123}
DEFINE_PROPERTYKEY!{PKEY_Contact_JobInfo3CompanyName,
    0x00F63DD8, 0x22BD, 0x4A5D, 0xBA, 0x34, 0x5C, 0xB0, 0xB9, 0xBD, 0xCB, 0x03, 115}
DEFINE_PROPERTYKEY!{PKEY_Contact_JobInfo3Department,
    0x00F63DD8, 0x22BD, 0x4A5D, 0xBA, 0x34, 0x5C, 0xB0, 0xB9, 0xBD, 0xCB, 0x03, 119}
DEFINE_PROPERTYKEY!{PKEY_Contact_JobInfo3Manager,
    0x00F63DD8, 0x22BD, 0x4A5D, 0xBA, 0x34, 0x5C, 0xB0, 0xB9, 0xBD, 0xCB, 0x03, 118}
DEFINE_PROPERTYKEY!{PKEY_Contact_JobInfo3OfficeLocation,
    0x00F63DD8, 0x22BD, 0x4A5D, 0xBA, 0x34, 0x5C, 0xB0, 0xB9, 0xBD, 0xCB, 0x03, 117}
DEFINE_PROPERTYKEY!{PKEY_Contact_JobInfo3Title,
    0x00F63DD8, 0x22BD, 0x4A5D, 0xBA, 0x34, 0x5C, 0xB0, 0xB9, 0xBD, 0xCB, 0x03, 116}
DEFINE_PROPERTYKEY!{PKEY_Contact_JobInfo3YomiCompanyName,
    0x00F63DD8, 0x22BD, 0x4A5D, 0xBA, 0x34, 0x5C, 0xB0, 0xB9, 0xBD, 0xCB, 0x03, 114}
DEFINE_PROPERTYKEY!{PKEY_Contact_JobTitle,
    0x176DC63C, 0x2688, 0x4E89, 0x81, 0x43, 0xA3, 0x47, 0x80, 0x0F, 0x25, 0xE9, 6}
DEFINE_PROPERTYKEY!{PKEY_Contact_Label,
    0x97B0AD89, 0xDF49, 0x49CC, 0x83, 0x4E, 0x66, 0x09, 0x74, 0xFD, 0x75, 0x5B, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_LastName,
    0x8F367200, 0xC270, 0x457C, 0xB1, 0xD4, 0xE0, 0x7C, 0x5B, 0xCD, 0x90, 0xC7, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_MailingAddress,
    0xC0AC206A, 0x827E, 0x4650, 0x95, 0xAE, 0x77, 0xE2, 0xBB, 0x74, 0xFC, 0xC9, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_MiddleName,
    0x176DC63C, 0x2688, 0x4E89, 0x81, 0x43, 0xA3, 0x47, 0x80, 0x0F, 0x25, 0xE9, 71}
DEFINE_PROPERTYKEY!{PKEY_Contact_MobileTelephone,
    0x176DC63C, 0x2688, 0x4E89, 0x81, 0x43, 0xA3, 0x47, 0x80, 0x0F, 0x25, 0xE9, 35}
DEFINE_PROPERTYKEY!{PKEY_Contact_NickName,
    0x176DC63C, 0x2688, 0x4E89, 0x81, 0x43, 0xA3, 0x47, 0x80, 0x0F, 0x25, 0xE9, 74}
DEFINE_PROPERTYKEY!{PKEY_Contact_OfficeLocation,
    0x176DC63C, 0x2688, 0x4E89, 0x81, 0x43, 0xA3, 0x47, 0x80, 0x0F, 0x25, 0xE9, 7}
DEFINE_PROPERTYKEY!{PKEY_Contact_OtherAddress,
    0x508161FA, 0x313B, 0x43D5, 0x83, 0xA1, 0xC1, 0xAC, 0xCF, 0x68, 0x62, 0x2C, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_OtherAddress1Country,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 134}
DEFINE_PROPERTYKEY!{PKEY_Contact_OtherAddress1Locality,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 132}
DEFINE_PROPERTYKEY!{PKEY_Contact_OtherAddress1PostalCode,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 135}
DEFINE_PROPERTYKEY!{PKEY_Contact_OtherAddress1Region,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 133}
DEFINE_PROPERTYKEY!{PKEY_Contact_OtherAddress1Street,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 131}
DEFINE_PROPERTYKEY!{PKEY_Contact_OtherAddress2Country,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 139}
DEFINE_PROPERTYKEY!{PKEY_Contact_OtherAddress2Locality,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 137}
DEFINE_PROPERTYKEY!{PKEY_Contact_OtherAddress2PostalCode,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 140}
DEFINE_PROPERTYKEY!{PKEY_Contact_OtherAddress2Region,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 138}
DEFINE_PROPERTYKEY!{PKEY_Contact_OtherAddress2Street,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 136}
DEFINE_PROPERTYKEY!{PKEY_Contact_OtherAddress3Country,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 144}
DEFINE_PROPERTYKEY!{PKEY_Contact_OtherAddress3Locality,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 142}
DEFINE_PROPERTYKEY!{PKEY_Contact_OtherAddress3PostalCode,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 145}
DEFINE_PROPERTYKEY!{PKEY_Contact_OtherAddress3Region,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 143}
DEFINE_PROPERTYKEY!{PKEY_Contact_OtherAddress3Street,
    0xA7B6F596, 0xD678, 0x4BC1, 0xB0, 0x5F, 0x02, 0x03, 0xD2, 0x7E, 0x8A, 0xA1, 141}
DEFINE_PROPERTYKEY!{PKEY_Contact_OtherAddressCity,
    0x6E682923, 0x7F7B, 0x4F0C, 0xA3, 0x37, 0xCF, 0xCA, 0x29, 0x66, 0x87, 0xBF, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_OtherAddressCountry,
    0x8F167568, 0x0AAE, 0x4322, 0x8E, 0xD9, 0x60, 0x55, 0xB7, 0xB0, 0xE3, 0x98, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_OtherAddressPostalCode,
    0x95C656C1, 0x2ABF, 0x4148, 0x9E, 0xD3, 0x9E, 0xC6, 0x02, 0xE3, 0xB7, 0xCD, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_OtherAddressPostOfficeBox,
    0x8B26EA41, 0x058F, 0x43F6, 0xAE, 0xCC, 0x40, 0x35, 0x68, 0x1C, 0xE9, 0x77, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_OtherAddressState,
    0x71B377D6, 0xE570, 0x425F, 0xA1, 0x70, 0x80, 0x9F, 0xAE, 0x73, 0xE5, 0x4E, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_OtherAddressStreet,
    0xFF962609, 0xB7D6, 0x4999, 0x86, 0x2D, 0x95, 0x18, 0x0D, 0x52, 0x9A, 0xEA, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_OtherEmailAddresses,
    0x11D6336B, 0x38C4, 0x4EC9, 0x84, 0xD6, 0xEB, 0x38, 0xD0, 0xB1, 0x50, 0xAF, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_PagerTelephone,
    0xD6304E01, 0xF8F5, 0x4F45, 0x8B, 0x15, 0xD0, 0x24, 0xA6, 0x29, 0x67, 0x89, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_PersonalTitle,
    0x176DC63C, 0x2688, 0x4E89, 0x81, 0x43, 0xA3, 0x47, 0x80, 0x0F, 0x25, 0xE9, 69}
DEFINE_PROPERTYKEY!{PKEY_Contact_PhoneNumbersCanonical,
    0xD042D2A1, 0x927E, 0x40B5, 0xA5, 0x03, 0x6E, 0xDB, 0xD4, 0x2A, 0x51, 0x7E, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_Prefix,
    0x176DC63C, 0x2688, 0x4E89, 0x81, 0x43, 0xA3, 0x47, 0x80, 0x0F, 0x25, 0xE9, 75}
DEFINE_PROPERTYKEY!{PKEY_Contact_PrimaryAddressCity,
    0xC8EA94F0, 0xA9E3, 0x4969, 0xA9, 0x4B, 0x9C, 0x62, 0xA9, 0x53, 0x24, 0xE0, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_PrimaryAddressCountry,
    0xE53D799D, 0x0F3F, 0x466E, 0xB2, 0xFF, 0x74, 0x63, 0x4A, 0x3C, 0xB7, 0xA4, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_PrimaryAddressPostalCode,
    0x18BBD425, 0xECFD, 0x46EF, 0xB6, 0x12, 0x7B, 0x4A, 0x60, 0x34, 0xED, 0xA0, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_PrimaryAddressPostOfficeBox,
    0xDE5EF3C7, 0x46E1, 0x484E, 0x99, 0x99, 0x62, 0xC5, 0x30, 0x83, 0x94, 0xC1, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_PrimaryAddressState,
    0xF1176DFE, 0x7138, 0x4640, 0x8B, 0x4C, 0xAE, 0x37, 0x5D, 0xC7, 0x0A, 0x6D, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_PrimaryAddressStreet,
    0x63C25B20, 0x96BE, 0x488F, 0x87, 0x88, 0xC0, 0x9C, 0x40, 0x7A, 0xD8, 0x12, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_PrimaryEmailAddress,
    0x176DC63C, 0x2688, 0x4E89, 0x81, 0x43, 0xA3, 0x47, 0x80, 0x0F, 0x25, 0xE9, 48}
DEFINE_PROPERTYKEY!{PKEY_Contact_PrimaryTelephone,
    0x176DC63C, 0x2688, 0x4E89, 0x81, 0x43, 0xA3, 0x47, 0x80, 0x0F, 0x25, 0xE9, 25}
DEFINE_PROPERTYKEY!{PKEY_Contact_Profession,
    0x7268AF55, 0x1CE4, 0x4F6E, 0xA4, 0x1F, 0xB6, 0xE4, 0xEF, 0x10, 0xE4, 0xA9, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_SpouseName,
    0x9D2408B6, 0x3167, 0x422B, 0x82, 0xB0, 0xF5, 0x83, 0xB7, 0xA7, 0xCF, 0xE3, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_Suffix,
    0x176DC63C, 0x2688, 0x4E89, 0x81, 0x43, 0xA3, 0x47, 0x80, 0x0F, 0x25, 0xE9, 73}
DEFINE_PROPERTYKEY!{PKEY_Contact_TelexNumber,
    0xC554493C, 0xC1F7, 0x40C1, 0xA7, 0x6C, 0xEF, 0x8C, 0x06, 0x14, 0x00, 0x3E, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_TTYTDDTelephone,
    0xAAF16BAC, 0x2B55, 0x45E6, 0x9F, 0x6D, 0x41, 0x5E, 0xB9, 0x49, 0x10, 0xDF, 100}
DEFINE_PROPERTYKEY!{PKEY_Contact_WebPage,
    0xE3E0584C, 0xB788, 0x4A5A, 0xBB, 0x20, 0x7F, 0x5A, 0x44, 0xC9, 0xAC, 0xDD, 18}
DEFINE_PROPERTYKEY!{PKEY_Contact_Webpage2,
    0x00F63DD8, 0x22BD, 0x4A5D, 0xBA, 0x34, 0x5C, 0xB0, 0xB9, 0xBD, 0xCB, 0x03, 124}
DEFINE_PROPERTYKEY!{PKEY_Contact_Webpage3,
    0x00F63DD8, 0x22BD, 0x4A5D, 0xBA, 0x34, 0x5C, 0xB0, 0xB9, 0xBD, 0xCB, 0x03, 125}
DEFINE_PROPERTYKEY!{PKEY_AcquisitionID,
    0x65A98875, 0x3C80, 0x40AB, 0xAB, 0xBC, 0xEF, 0xDA, 0xF7, 0x7D, 0xBE, 0xE2, 100}
DEFINE_PROPERTYKEY!{PKEY_ApplicationDefinedProperties,
    0xCDBFC167, 0x337E, 0x41D8, 0xAF, 0x7C, 0x8C, 0x09, 0x20, 0x54, 0x29, 0xC7, 100}
DEFINE_PROPERTYKEY!{PKEY_ApplicationName,
    0xF29F85E0, 0x4FF9, 0x1068, 0xAB, 0x91, 0x08, 0x00, 0x2B, 0x27, 0xB3, 0xD9, 18}
DEFINE_PROPERTYKEY!{PKEY_AppZoneIdentifier,
    0x502CFEAB, 0x47EB, 0x459C, 0xB9, 0x60, 0xE6, 0xD8, 0x72, 0x8F, 0x77, 0x01, 102}
DEFINE_PROPERTYKEY!{PKEY_Author,
    0xF29F85E0, 0x4FF9, 0x1068, 0xAB, 0x91, 0x08, 0x00, 0x2B, 0x27, 0xB3, 0xD9, 4}
DEFINE_PROPERTYKEY!{PKEY_CachedFileUpdaterContentIdForConflictResolution,
    0xFCEFF153, 0xE839, 0x4CF3, 0xA9, 0xE7, 0xEA, 0x22, 0x83, 0x20, 0x94, 0xB8, 114}
DEFINE_PROPERTYKEY!{PKEY_CachedFileUpdaterContentIdForStream,
    0xFCEFF153, 0xE839, 0x4CF3, 0xA9, 0xE7, 0xEA, 0x22, 0x83, 0x20, 0x94, 0xB8, 113}
DEFINE_PROPERTYKEY!{PKEY_Capacity,
    0x9B174B35, 0x40FF, 0x11D2, 0xA2, 0x7E, 0x00, 0xC0, 0x4F, 0xC3, 0x08, 0x71, 3}
DEFINE_PROPERTYKEY!{PKEY_Category,
    0xD5CDD502, 0x2E9C, 0x101B, 0x93, 0x97, 0x08, 0x00, 0x2B, 0x2C, 0xF9, 0xAE, 2}
DEFINE_PROPERTYKEY!{PKEY_Comment,
    0xF29F85E0, 0x4FF9, 0x1068, 0xAB, 0x91, 0x08, 0x00, 0x2B, 0x27, 0xB3, 0xD9, 6}
DEFINE_PROPERTYKEY!{PKEY_Company,
    0xD5CDD502, 0x2E9C, 0x101B, 0x93, 0x97, 0x08, 0x00, 0x2B, 0x2C, 0xF9, 0xAE, 15}
DEFINE_PROPERTYKEY!{PKEY_ComputerName,
    0x28636AA6, 0x953D, 0x11D2, 0xB5, 0xD6, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0xD0, 5}
DEFINE_PROPERTYKEY!{PKEY_ContainedItems,
    0x28636AA6, 0x953D, 0x11D2, 0xB5, 0xD6, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0xD0, 29}
DEFINE_PROPERTYKEY!{PKEY_ContentStatus,
    0xD5CDD502, 0x2E9C, 0x101B, 0x93, 0x97, 0x08, 0x00, 0x2B, 0x2C, 0xF9, 0xAE, 27}
DEFINE_PROPERTYKEY!{PKEY_ContentType,
    0xD5CDD502, 0x2E9C, 0x101B, 0x93, 0x97, 0x08, 0x00, 0x2B, 0x2C, 0xF9, 0xAE, 26}
DEFINE_PROPERTYKEY!{PKEY_Copyright,
    0x64440492, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 11}
DEFINE_PROPERTYKEY!{PKEY_CreatorAppId,
    0xC2EA046E, 0x033C, 0x4E91, 0xBD, 0x5B, 0xD4, 0x94, 0x2F, 0x6B, 0xBE, 0x49, 2}
DEFINE_PROPERTYKEY!{PKEY_CreatorOpenWithUIOptions,
    0xC2EA046E, 0x033C, 0x4E91, 0xBD, 0x5B, 0xD4, 0x94, 0x2F, 0x6B, 0xBE, 0x49, 3}
pub const CREATOROPENWITHUIOPTION_HIDDEN: DWORD = 0;
pub const CREATOROPENWITHUIOPTION_VISIBLE: DWORD = 1;
DEFINE_PROPERTYKEY!{PKEY_DataObjectFormat,
    0x1E81A3F8, 0xA30F, 0x4247, 0xB9, 0xEE, 0x1D, 0x03, 0x68, 0xA9, 0x42, 0x5C, 2}
DEFINE_PROPERTYKEY!{PKEY_DateAccessed,
    0xB725F130, 0x47EF, 0x101A, 0xA5, 0xF1, 0x02, 0x60, 0x8C, 0x9E, 0xEB, 0xAC, 16}
DEFINE_PROPERTYKEY!{PKEY_DateAcquired,
    0x2CBAA8F5, 0xD81F, 0x47CA, 0xB1, 0x7A, 0xF8, 0xD8, 0x22, 0x30, 0x01, 0x31, 100}
DEFINE_PROPERTYKEY!{PKEY_DateArchived,
    0x43F8D7B7, 0xA444, 0x4F87, 0x93, 0x83, 0x52, 0x27, 0x1C, 0x9B, 0x91, 0x5C, 100}
DEFINE_PROPERTYKEY!{PKEY_DateCompleted,
    0x72FAB781, 0xACDA, 0x43E5, 0xB1, 0x55, 0xB2, 0x43, 0x4F, 0x85, 0xE6, 0x78, 100}
DEFINE_PROPERTYKEY!{PKEY_DateCreated,
    0xB725F130, 0x47EF, 0x101A, 0xA5, 0xF1, 0x02, 0x60, 0x8C, 0x9E, 0xEB, 0xAC, 15}
DEFINE_PROPERTYKEY!{PKEY_DateImported,
    0x14B81DA1, 0x0135, 0x4D31, 0x96, 0xD9, 0x6C, 0xBF, 0xC9, 0x67, 0x1A, 0x99, 18258}
DEFINE_PROPERTYKEY!{PKEY_DateModified,
    0xB725F130, 0x47EF, 0x101A, 0xA5, 0xF1, 0x02, 0x60, 0x8C, 0x9E, 0xEB, 0xAC, 14}
DEFINE_PROPERTYKEY!{PKEY_DefaultSaveLocationDisplay,
    0x5D76B67F, 0x9B3D, 0x44BB, 0xB6, 0xAE, 0x25, 0xDA, 0x4F, 0x63, 0x8A, 0x67, 10}
pub const ISDEFAULTSAVE_NONE: DWORD = 0;
pub const ISDEFAULTSAVE_OWNER: DWORD = 1;
pub const ISDEFAULTSAVE_NONOWNER: DWORD = 2;
pub const ISDEFAULTSAVE_BOTH: DWORD = 3;
DEFINE_PROPERTYKEY!{PKEY_DueDate,
    0x3F8472B5, 0xE0AF, 0x4DB2, 0x80, 0x71, 0xC5, 0x3F, 0xE7, 0x6A, 0xE7, 0xCE, 100}
DEFINE_PROPERTYKEY!{PKEY_EndDate,
    0xC75FAA05, 0x96FD, 0x49E7, 0x9C, 0xB4, 0x9F, 0x60, 0x10, 0x82, 0xD5, 0x53, 100}
DEFINE_PROPERTYKEY!{PKEY_ExpandoProperties,
    0x6FA20DE6, 0xD11C, 0x4D9D, 0xA1, 0x54, 0x64, 0x31, 0x76, 0x28, 0xC1, 0x2D, 100}
DEFINE_PROPERTYKEY!{PKEY_FileAllocationSize,
    0xB725F130, 0x47EF, 0x101A, 0xA5, 0xF1, 0x02, 0x60, 0x8C, 0x9E, 0xEB, 0xAC, 18}
DEFINE_PROPERTYKEY!{PKEY_FileAttributes,
    0xB725F130, 0x47EF, 0x101A, 0xA5, 0xF1, 0x02, 0x60, 0x8C, 0x9E, 0xEB, 0xAC, 13}
DEFINE_PROPERTYKEY!{PKEY_FileCount,
    0x28636AA6, 0x953D, 0x11D2, 0xB5, 0xD6, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0xD0, 12}
DEFINE_PROPERTYKEY!{PKEY_FileDescription,
    0x0CEF7D53, 0xFA64, 0x11D1, 0xA2, 0x03, 0x00, 0x00, 0xF8, 0x1F, 0xED, 0xEE, 3}
DEFINE_PROPERTYKEY!{PKEY_FileExtension,
    0xE4F10A3C, 0x49E6, 0x405D, 0x82, 0x88, 0xA2, 0x3B, 0xD4, 0xEE, 0xAA, 0x6C, 100}
DEFINE_PROPERTYKEY!{PKEY_FileFRN,
    0xB725F130, 0x47EF, 0x101A, 0xA5, 0xF1, 0x02, 0x60, 0x8C, 0x9E, 0xEB, 0xAC, 21}
DEFINE_PROPERTYKEY!{PKEY_FileName,
    0x41CF5AE0, 0xF75A, 0x4806, 0xBD, 0x87, 0x59, 0xC7, 0xD9, 0x24, 0x8E, 0xB9, 100}
DEFINE_PROPERTYKEY!{PKEY_FileOfflineAvailabilityStatus,
    0xFCEFF153, 0xE839, 0x4CF3, 0xA9, 0xE7, 0xEA, 0x22, 0x83, 0x20, 0x94, 0xB8, 100}
pub const FILEOFFLINEAVAILABILITYSTATUS_PROP_NOTAVAILABLEOFFLINE: DWORD = 0;
pub const FILEOFFLINEAVAILABILITYSTATUS_PROP_PARTIALLYAVAILABLEOFFLINE: DWORD = 1;
DEFINE_PROPERTYKEY!{PKEY_FileOwner,
    0x9B174B34, 0x40FF, 0x11D2, 0xA2, 0x7E, 0x00, 0xC0, 0x4F, 0xC3, 0x08, 0x71, 4}
DEFINE_PROPERTYKEY!{PKEY_FilePlaceholderStatus,
    0xB2F9B9D6, 0xFEC4, 0x4DD5, 0x94, 0xD7, 0x89, 0x57, 0x48, 0x8C, 0x80, 0x7B, 2}
DEFINE_PROPERTYKEY!{PKEY_FileVersion,
    0x0CEF7D53, 0xFA64, 0x11D1, 0xA2, 0x03, 0x00, 0x00, 0xF8, 0x1F, 0xED, 0xEE, 4}
DEFINE_PROPERTYKEY!{PKEY_FindData,
    0x28636AA6, 0x953D, 0x11D2, 0xB5, 0xD6, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0xD0, 0}
DEFINE_PROPERTYKEY!{PKEY_FlagColor,
    0x67DF94DE, 0x0CA7, 0x4D6F, 0xB7, 0x92, 0x05, 0x3A, 0x3E, 0x4F, 0x03, 0xCF, 100}
pub const FLAGCOLOR_PURPLE: DWORD = 1;
pub const FLAGCOLOR_ORANGE: DWORD = 2;
pub const FLAGCOLOR_GREEN: DWORD = 3;
pub const FLAGCOLOR_YELLOW: DWORD = 4;
pub const FLAGCOLOR_BLUE: DWORD = 5;
pub const FLAGCOLOR_RED: DWORD = 6;
DEFINE_PROPERTYKEY!{PKEY_FlagColorText,
    0x45EAE747, 0x8E2A, 0x40AE, 0x8C, 0xBF, 0xCA, 0x52, 0xAB, 0xA6, 0x15, 0x2A, 100}
DEFINE_PROPERTYKEY!{PKEY_FlagStatus,
    0xE3E0584C, 0xB788, 0x4A5A, 0xBB, 0x20, 0x7F, 0x5A, 0x44, 0xC9, 0xAC, 0xDD, 12}
pub const FLAGSTATUS_NOTFLAGGED: LONG = 0;
pub const FLAGSTATUS_COMPLETED: LONG = 1;
pub const FLAGSTATUS_FOLLOWUP: LONG = 2;
DEFINE_PROPERTYKEY!{PKEY_FlagStatusText,
    0xDC54FD2E, 0x189D, 0x4871, 0xAA, 0x01, 0x08, 0xC2, 0xF5, 0x7A, 0x4A, 0xBC, 100}
DEFINE_PROPERTYKEY!{PKEY_FolderKind,
    0xFCEFF153, 0xE839, 0x4CF3, 0xA9, 0xE7, 0xEA, 0x22, 0x83, 0x20, 0x94, 0xB8, 101}
DEFINE_PROPERTYKEY!{PKEY_FolderNameDisplay,
    0xB725F130, 0x47EF, 0x101A, 0xA5, 0xF1, 0x02, 0x60, 0x8C, 0x9E, 0xEB, 0xAC, 25}
DEFINE_PROPERTYKEY!{PKEY_FreeSpace,
    0x9B174B35, 0x40FF, 0x11D2, 0xA2, 0x7E, 0x00, 0xC0, 0x4F, 0xC3, 0x08, 0x71, 2}
DEFINE_PROPERTYKEY!{PKEY_FullText,
    0x1E3EE840, 0xBC2B, 0x476C, 0x82, 0x37, 0x2A, 0xCD, 0x1A, 0x83, 0x9B, 0x22, 6}
DEFINE_PROPERTYKEY!{PKEY_HighKeywords,
    0xF29F85E0, 0x4FF9, 0x1068, 0xAB, 0x91, 0x08, 0x00, 0x2B, 0x27, 0xB3, 0xD9, 24}
DEFINE_PROPERTYKEY!{PKEY_Identity,
    0xA26F4AFC, 0x7346, 0x4299, 0xBE, 0x47, 0xEB, 0x1A, 0xE6, 0x13, 0x13, 0x9F, 100}
DEFINE_PROPERTYKEY!{PKEY_Identity_Blob,
    0x8C3B93A4, 0xBAED, 0x1A83, 0x9A, 0x32, 0x10, 0x2E, 0xE3, 0x13, 0xF6, 0xEB, 100}
DEFINE_PROPERTYKEY!{PKEY_Identity_DisplayName,
    0x7D683FC9, 0xD155, 0x45A8, 0xBB, 0x1F, 0x89, 0xD1, 0x9B, 0xCB, 0x79, 0x2F, 100}
DEFINE_PROPERTYKEY!{PKEY_Identity_InternetSid,
    0x6D6D5D49, 0x265D, 0x4688, 0x9F, 0x4E, 0x1F, 0xDD, 0x33, 0xE7, 0xCC, 0x83, 100}
DEFINE_PROPERTYKEY!{PKEY_Identity_IsMeIdentity,
    0xA4108708, 0x09DF, 0x4377, 0x9D, 0xFC, 0x6D, 0x99, 0x98, 0x6D, 0x5A, 0x67, 100}
DEFINE_PROPERTYKEY!{PKEY_Identity_KeyProviderContext,
    0xA26F4AFC, 0x7346, 0x4299, 0xBE, 0x47, 0xEB, 0x1A, 0xE6, 0x13, 0x13, 0x9F, 17}
DEFINE_PROPERTYKEY!{PKEY_Identity_KeyProviderName,
    0xA26F4AFC, 0x7346, 0x4299, 0xBE, 0x47, 0xEB, 0x1A, 0xE6, 0x13, 0x13, 0x9F, 16}
DEFINE_PROPERTYKEY!{PKEY_Identity_LogonStatusString,
    0xF18DEDF3, 0x337F, 0x42C0, 0x9E, 0x03, 0xCE, 0xE0, 0x87, 0x08, 0xA8, 0xC3, 100}
DEFINE_PROPERTYKEY!{PKEY_Identity_PrimaryEmailAddress,
    0xFCC16823, 0xBAED, 0x4F24, 0x9B, 0x32, 0xA0, 0x98, 0x21, 0x17, 0xF7, 0xFA, 100}
DEFINE_PROPERTYKEY!{PKEY_Identity_PrimarySid,
    0x2B1B801E, 0xC0C1, 0x4987, 0x9E, 0xC5, 0x72, 0xFA, 0x89, 0x81, 0x47, 0x87, 100}
DEFINE_PROPERTYKEY!{PKEY_Identity_ProviderData,
    0xA8A74B92, 0x361B, 0x4E9A, 0xB7, 0x22, 0x7C, 0x4A, 0x73, 0x30, 0xA3, 0x12, 100}
DEFINE_PROPERTYKEY!{PKEY_Identity_ProviderID,
    0x74A7DE49, 0xFA11, 0x4D3D, 0xA0, 0x06, 0xDB, 0x7E, 0x08, 0x67, 0x59, 0x16, 100}
DEFINE_PROPERTYKEY!{PKEY_Identity_QualifiedUserName,
    0xDA520E51, 0xF4E9, 0x4739, 0xAC, 0x82, 0x02, 0xE0, 0xA9, 0x5C, 0x90, 0x30, 100}
DEFINE_PROPERTYKEY!{PKEY_Identity_UniqueID,
    0xE55FC3B0, 0x2B60, 0x4220, 0x91, 0x8E, 0xB2, 0x1E, 0x8B, 0xF1, 0x60, 0x16, 100}
DEFINE_PROPERTYKEY!{PKEY_Identity_UserName,
    0xC4322503, 0x78CA, 0x49C6, 0x9A, 0xCC, 0xA6, 0x8E, 0x2A, 0xFD, 0x7B, 0x6B, 100}
DEFINE_PROPERTYKEY!{PKEY_IdentityProvider_Name,
    0xB96EFF7B, 0x35CA, 0x4A35, 0x86, 0x07, 0x29, 0xE3, 0xA5, 0x4C, 0x46, 0xEA, 100}
DEFINE_PROPERTYKEY!{PKEY_IdentityProvider_Picture,
    0x2425166F, 0x5642, 0x4864, 0x99, 0x2F, 0x98, 0xFD, 0x98, 0xF2, 0x94, 0xC3, 100}
DEFINE_PROPERTYKEY!{PKEY_ImageParsingName,
    0xD7750EE0, 0xC6A4, 0x48EC, 0xB5, 0x3E, 0xB8, 0x7B, 0x52, 0xE6, 0xD0, 0x73, 100}
DEFINE_PROPERTYKEY!{PKEY_Importance,
    0xE3E0584C, 0xB788, 0x4A5A, 0xBB, 0x20, 0x7F, 0x5A, 0x44, 0xC9, 0xAC, 0xDD, 11}
pub const IMPORTANCE_LOW_MIN: LONG = 0;
pub const IMPORTANCE_LOW_SET: LONG = 1;
pub const IMPORTANCE_LOW_MAX: LONG = 1;
pub const IMPORTANCE_NORMAL_MIN: LONG = 2;
pub const IMPORTANCE_NORMAL_SET: LONG = 3;
pub const IMPORTANCE_NORMAL_MAX: LONG = 4;
pub const IMPORTANCE_HIGH_MIN: LONG = 5;
pub const IMPORTANCE_HIGH_SET: LONG = 5;
pub const IMPORTANCE_HIGH_MAX: LONG = 5;
DEFINE_PROPERTYKEY!{PKEY_ImportanceText,
    0xA3B29791, 0x7713, 0x4E1D, 0xBB, 0x40, 0x17, 0xDB, 0x85, 0xF0, 0x18, 0x31, 100}
DEFINE_PROPERTYKEY!{PKEY_IsAttachment,
    0xF23F425C, 0x71A1, 0x4FA8, 0x92, 0x2F, 0x67, 0x8E, 0xA4, 0xA6, 0x04, 0x08, 100}
DEFINE_PROPERTYKEY!{PKEY_IsDefaultNonOwnerSaveLocation,
    0x5D76B67F, 0x9B3D, 0x44BB, 0xB6, 0xAE, 0x25, 0xDA, 0x4F, 0x63, 0x8A, 0x67, 5}
DEFINE_PROPERTYKEY!{PKEY_IsDefaultSaveLocation,
    0x5D76B67F, 0x9B3D, 0x44BB, 0xB6, 0xAE, 0x25, 0xDA, 0x4F, 0x63, 0x8A, 0x67, 3}
DEFINE_PROPERTYKEY!{PKEY_IsDeleted,
    0x5CDA5FC8, 0x33EE, 0x4FF3, 0x90, 0x94, 0xAE, 0x7B, 0xD8, 0x86, 0x8C, 0x4D, 100}
DEFINE_PROPERTYKEY!{PKEY_IsEncrypted,
    0x90E5E14E, 0x648B, 0x4826, 0xB2, 0xAA, 0xAC, 0xAF, 0x79, 0x0E, 0x35, 0x13, 10}
DEFINE_PROPERTYKEY!{PKEY_IsFlagged,
    0x5DA84765, 0xE3FF, 0x4278, 0x86, 0xB0, 0xA2, 0x79, 0x67, 0xFB, 0xDD, 0x03, 100}
DEFINE_PROPERTYKEY!{PKEY_IsFlaggedComplete,
    0xA6F360D2, 0x55F9, 0x48DE, 0xB9, 0x09, 0x62, 0x0E, 0x09, 0x0A, 0x64, 0x7C, 100}
DEFINE_PROPERTYKEY!{PKEY_IsIncomplete,
    0x346C8BD1, 0x2E6A, 0x4C45, 0x89, 0xA4, 0x61, 0xB7, 0x8E, 0x8E, 0x70, 0x0F, 100}
DEFINE_PROPERTYKEY!{PKEY_IsLocationSupported,
    0x5D76B67F, 0x9B3D, 0x44BB, 0xB6, 0xAE, 0x25, 0xDA, 0x4F, 0x63, 0x8A, 0x67, 8}
DEFINE_PROPERTYKEY!{PKEY_IsPinnedToNameSpaceTree,
    0x5D76B67F, 0x9B3D, 0x44BB, 0xB6, 0xAE, 0x25, 0xDA, 0x4F, 0x63, 0x8A, 0x67, 2}
DEFINE_PROPERTYKEY!{PKEY_IsRead,
    0xE3E0584C, 0xB788, 0x4A5A, 0xBB, 0x20, 0x7F, 0x5A, 0x44, 0xC9, 0xAC, 0xDD, 10}
DEFINE_PROPERTYKEY!{PKEY_IsSearchOnlyItem,
    0x5D76B67F, 0x9B3D, 0x44BB, 0xB6, 0xAE, 0x25, 0xDA, 0x4F, 0x63, 0x8A, 0x67, 4}
DEFINE_PROPERTYKEY!{PKEY_IsSendToTarget,
    0x28636AA6, 0x953D, 0x11D2, 0xB5, 0xD6, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0xD0, 33}
DEFINE_PROPERTYKEY!{PKEY_IsShared,
    0xEF884C5B, 0x2BFE, 0x41BB, 0xAA, 0xE5, 0x76, 0xEE, 0xDF, 0x4F, 0x99, 0x02, 100}
DEFINE_PROPERTYKEY!{PKEY_ItemAuthors,
    0xD0A04F0A, 0x462A, 0x48A4, 0xBB, 0x2F, 0x37, 0x06, 0xE8, 0x8D, 0xBD, 0x7D, 100}
DEFINE_PROPERTYKEY!{PKEY_ItemClassType,
    0x048658AD, 0x2DB8, 0x41A4, 0xBB, 0xB6, 0xAC, 0x1E, 0xF1, 0x20, 0x7E, 0xB1, 100}
DEFINE_PROPERTYKEY!{PKEY_ItemDate,
    0xF7DB74B4, 0x4287, 0x4103, 0xAF, 0xBA, 0xF1, 0xB1, 0x3D, 0xCD, 0x75, 0xCF, 100}
DEFINE_PROPERTYKEY!{PKEY_ItemFolderNameDisplay,
    0xB725F130, 0x47EF, 0x101A, 0xA5, 0xF1, 0x02, 0x60, 0x8C, 0x9E, 0xEB, 0xAC, 2}
DEFINE_PROPERTYKEY!{PKEY_ItemFolderPathDisplay,
    0xE3E0584C, 0xB788, 0x4A5A, 0xBB, 0x20, 0x7F, 0x5A, 0x44, 0xC9, 0xAC, 0xDD, 6}
DEFINE_PROPERTYKEY!{PKEY_ItemFolderPathDisplayNarrow,
    0xDABD30ED, 0x0043, 0x4789, 0xA7, 0xF8, 0xD0, 0x13, 0xA4, 0x73, 0x66, 0x22, 100}
DEFINE_PROPERTYKEY!{PKEY_ItemName,
    0x6B8DA074, 0x3B5C, 0x43BC, 0x88, 0x6F, 0x0A, 0x2C, 0xDC, 0xE0, 0x0B, 0x6F, 100}
DEFINE_PROPERTYKEY!{PKEY_ItemNameDisplay,
    0xB725F130, 0x47EF, 0x101A, 0xA5, 0xF1, 0x02, 0x60, 0x8C, 0x9E, 0xEB, 0xAC, 10}
DEFINE_PROPERTYKEY!{PKEY_ItemNameDisplayWithoutExtension,
    0xB725F130, 0x47EF, 0x101A, 0xA5, 0xF1, 0x02, 0x60, 0x8C, 0x9E, 0xEB, 0xAC, 24}
DEFINE_PROPERTYKEY!{PKEY_ItemNamePrefix,
    0xD7313FF1, 0xA77A, 0x401C, 0x8C, 0x99, 0x3D, 0xBD, 0xD6, 0x8A, 0xDD, 0x36, 100}
DEFINE_PROPERTYKEY!{PKEY_ItemNameSortOverride,
    0xB725F130, 0x47EF, 0x101A, 0xA5, 0xF1, 0x02, 0x60, 0x8C, 0x9E, 0xEB, 0xAC, 23}
DEFINE_PROPERTYKEY!{PKEY_ItemParticipants,
    0xD4D0AA16, 0x9948, 0x41A4, 0xAA, 0x85, 0xD9, 0x7F, 0xF9, 0x64, 0x69, 0x93, 100}
DEFINE_PROPERTYKEY!{PKEY_ItemPathDisplay,
    0xE3E0584C, 0xB788, 0x4A5A, 0xBB, 0x20, 0x7F, 0x5A, 0x44, 0xC9, 0xAC, 0xDD, 7}
DEFINE_PROPERTYKEY!{PKEY_ItemPathDisplayNarrow,
    0x28636AA6, 0x953D, 0x11D2, 0xB5, 0xD6, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0xD0, 8}
DEFINE_PROPERTYKEY!{PKEY_ItemSubType,
    0x28636AA6, 0x953D, 0x11D2, 0xB5, 0xD6, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0xD0, 37}
DEFINE_PROPERTYKEY!{PKEY_ItemType,
    0x28636AA6, 0x953D, 0x11D2, 0xB5, 0xD6, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0xD0, 11}
DEFINE_PROPERTYKEY!{PKEY_ItemTypeText,
    0xB725F130, 0x47EF, 0x101A, 0xA5, 0xF1, 0x02, 0x60, 0x8C, 0x9E, 0xEB, 0xAC, 4}
DEFINE_PROPERTYKEY!{PKEY_ItemUrl,
    0x49691C90, 0x7E17, 0x101A, 0xA9, 0x1C, 0x08, 0x00, 0x2B, 0x2E, 0xCD, 0xA9, 9}
DEFINE_PROPERTYKEY!{PKEY_Keywords,
    0xF29F85E0, 0x4FF9, 0x1068, 0xAB, 0x91, 0x08, 0x00, 0x2B, 0x27, 0xB3, 0xD9, 5}
DEFINE_PROPERTYKEY!{PKEY_Kind,
    0x1E3EE840, 0xBC2B, 0x476C, 0x82, 0x37, 0x2A, 0xCD, 0x1A, 0x83, 0x9B, 0x22, 3}
pub const KIND_CALENDAR: &'static str = "calendar";
pub const KIND_COMMUNICATION: &'static str = "communication";
pub const KIND_CONTACT: &'static str = "contact";
pub const KIND_DOCUMENT: &'static str = "document";
pub const KIND_EMAIL: &'static str = "email";
pub const KIND_FEED: &'static str = "feed";
pub const KIND_FOLDER: &'static str = "folder";
pub const KIND_GAME: &'static str = "game";
pub const KIND_INSTANTMESSAGE: &'static str = "instantmessage";
pub const KIND_JOURNAL: &'static str = "journal";
pub const KIND_LINK: &'static str = "link";
pub const KIND_MOVIE: &'static str = "movie";
pub const KIND_MUSIC: &'static str = "music";
pub const KIND_NOTE: &'static str = "note";
pub const KIND_PICTURE: &'static str = "picture";
pub const KIND_PLAYLIST: &'static str = "playlist";
pub const KIND_PROGRAM: &'static str = "program";
pub const KIND_RECORDEDTV: &'static str = "recordedtv";
pub const KIND_SEARCHFOLDER: &'static str = "searchfolder";
pub const KIND_TASK: &'static str = "task";
pub const KIND_VIDEO: &'static str = "video";
pub const KIND_WEBHISTORY: &'static str = "webhistory";
pub const KIND_UNKNOWN: &'static str = "unknown";
DEFINE_PROPERTYKEY!{PKEY_KindText,
    0xF04BEF95, 0xC585, 0x4197, 0xA2, 0xB7, 0xDF, 0x46, 0xFD, 0xC9, 0xEE, 0x6D, 100}
DEFINE_PROPERTYKEY!{PKEY_Language,
    0xD5CDD502, 0x2E9C, 0x101B, 0x93, 0x97, 0x08, 0x00, 0x2B, 0x2C, 0xF9, 0xAE, 28}
DEFINE_PROPERTYKEY!{PKEY_LastSyncError,
    0xFCEFF153, 0xE839, 0x4CF3, 0xA9, 0xE7, 0xEA, 0x22, 0x83, 0x20, 0x94, 0xB8, 107}
DEFINE_PROPERTYKEY!{PKEY_LastWriterPackageFamilyName,
    0x502CFEAB, 0x47EB, 0x459C, 0xB9, 0x60, 0xE6, 0xD8, 0x72, 0x8F, 0x77, 0x01, 101}
DEFINE_PROPERTYKEY!{PKEY_LowKeywords,
    0xF29F85E0, 0x4FF9, 0x1068, 0xAB, 0x91, 0x08, 0x00, 0x2B, 0x27, 0xB3, 0xD9, 25}
DEFINE_PROPERTYKEY!{PKEY_MediumKeywords,
    0xF29F85E0, 0x4FF9, 0x1068, 0xAB, 0x91, 0x08, 0x00, 0x2B, 0x27, 0xB3, 0xD9, 26}
DEFINE_PROPERTYKEY!{PKEY_MileageInformation,
    0xFDF84370, 0x031A, 0x4ADD, 0x9E, 0x91, 0x0D, 0x77, 0x5F, 0x1C, 0x66, 0x05, 100}
DEFINE_PROPERTYKEY!{PKEY_MIMEType,
    0x0B63E350, 0x9CCC, 0x11D0, 0xBC, 0xDB, 0x00, 0x80, 0x5F, 0xCC, 0xCE, 0x04, 5}
DEFINE_PROPERTYKEY!{PKEY_Null,
    0x00000000, 0x0000, 0x0000, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0}
DEFINE_PROPERTYKEY!{PKEY_OfflineAvailability,
    0xA94688B6, 0x7D9F, 0x4570, 0xA6, 0x48, 0xE3, 0xDF, 0xC0, 0xAB, 0x2B, 0x3F, 100}
pub const OFFLINEAVAILABILITY_NOT_AVAILABLE: DWORD = 0;
pub const OFFLINEAVAILABILITY_AVAILABLE: DWORD = 1;
pub const OFFLINEAVAILABILITY_ALWAYS_AVAILABLE: DWORD = 2;
DEFINE_PROPERTYKEY!{PKEY_OfflineStatus,
    0x6D24888F, 0x4718, 0x4BDA, 0xAF, 0xED, 0xEA, 0x0F, 0xB4, 0x38, 0x6C, 0xD8, 100}
pub const OFFLINESTATUS_ONLINE: DWORD = 0;
pub const OFFLINESTATUS_OFFLINE: DWORD = 1;
pub const OFFLINESTATUS_OFFLINE_FORCED: DWORD = 2;
pub const OFFLINESTATUS_OFFLINE_SLOW: DWORD = 3;
pub const OFFLINESTATUS_OFFLINE_ERROR: DWORD = 4;
pub const OFFLINESTATUS_OFFLINE_ITEM_VERSION_CONFLICT: DWORD = 5;
pub const OFFLINESTATUS_OFFLINE_SUSPENDED: DWORD = 6;
DEFINE_PROPERTYKEY!{PKEY_OriginalFileName,
    0x0CEF7D53, 0xFA64, 0x11D1, 0xA2, 0x03, 0x00, 0x00, 0xF8, 0x1F, 0xED, 0xEE, 6}
DEFINE_PROPERTYKEY!{PKEY_OwnerSID,
    0x5D76B67F, 0x9B3D, 0x44BB, 0xB6, 0xAE, 0x25, 0xDA, 0x4F, 0x63, 0x8A, 0x67, 6}
DEFINE_PROPERTYKEY!{PKEY_ParentalRating,
    0x64440492, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 21}
DEFINE_PROPERTYKEY!{PKEY_ParentalRatingReason,
    0x10984E0A, 0xF9F2, 0x4321, 0xB7, 0xEF, 0xBA, 0xF1, 0x95, 0xAF, 0x43, 0x19, 100}
DEFINE_PROPERTYKEY!{PKEY_ParentalRatingsOrganization,
    0xA7FE0840, 0x1344, 0x46F0, 0x8D, 0x37, 0x52, 0xED, 0x71, 0x2A, 0x4B, 0xF9, 100}
DEFINE_PROPERTYKEY!{PKEY_ParsingBindContext,
    0xDFB9A04D, 0x362F, 0x4CA3, 0xB3, 0x0B, 0x02, 0x54, 0xB1, 0x7B, 0x5B, 0x84, 100}
DEFINE_PROPERTYKEY!{PKEY_ParsingName,
    0x28636AA6, 0x953D, 0x11D2, 0xB5, 0xD6, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0xD0, 24}
DEFINE_PROPERTYKEY!{PKEY_ParsingPath,
    0x28636AA6, 0x953D, 0x11D2, 0xB5, 0xD6, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0xD0, 30}
DEFINE_PROPERTYKEY!{PKEY_PerceivedType,
    0x28636AA6, 0x953D, 0x11D2, 0xB5, 0xD6, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0xD0, 9}
DEFINE_PROPERTYKEY!{PKEY_PercentFull,
    0x9B174B35, 0x40FF, 0x11D2, 0xA2, 0x7E, 0x00, 0xC0, 0x4F, 0xC3, 0x08, 0x71, 5}
DEFINE_PROPERTYKEY!{PKEY_Priority,
    0x9C1FCF74, 0x2D97, 0x41BA, 0xB4, 0xAE, 0xCB, 0x2E, 0x36, 0x61, 0xA6, 0xE4, 5}
pub const PRIORITY_PROP_LOW: DWORD = 0;
pub const PRIORITY_PROP_NORMAL: DWORD = 1;
pub const PRIORITY_PROP_HIGH: DWORD = 2;
DEFINE_PROPERTYKEY!{PKEY_PriorityText,
    0xD98BE98B, 0xB86B, 0x4095, 0xBF, 0x52, 0x9D, 0x23, 0xB2, 0xE0, 0xA7, 0x52, 100}
DEFINE_PROPERTYKEY!{PKEY_Project,
    0x39A7F922, 0x477C, 0x48DE, 0x8B, 0xC8, 0xB2, 0x84, 0x41, 0xE3, 0x42, 0xE3, 100}
DEFINE_PROPERTYKEY!{PKEY_ProviderItemID,
    0xF21D9941, 0x81F0, 0x471A, 0xAD, 0xEE, 0x4E, 0x74, 0xB4, 0x92, 0x17, 0xED, 100}
DEFINE_PROPERTYKEY!{PKEY_Rating,
    0x64440492, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 9}
pub const RATING_ONE_STAR_MIN: DWORD = 1;
pub const RATING_ONE_STAR_SET: DWORD = 1;
pub const RATING_ONE_STAR_MAX: DWORD = 12;
pub const RATING_TWO_STARS_MIN: DWORD = 13;
pub const RATING_TWO_STARS_SET: DWORD = 25;
pub const RATING_TWO_STARS_MAX: DWORD = 37;
pub const RATING_THREE_STARS_MIN: DWORD = 38;
pub const RATING_THREE_STARS_SET: DWORD = 50;
pub const RATING_THREE_STARS_MAX: DWORD = 62;
pub const RATING_FOUR_STARS_MIN: DWORD = 63;
pub const RATING_FOUR_STARS_SET: DWORD = 75;
pub const RATING_FOUR_STARS_MAX: DWORD = 87;
pub const RATING_FIVE_STARS_MIN: DWORD = 88;
pub const RATING_FIVE_STARS_SET: DWORD = 99;
pub const RATING_FIVE_STARS_MAX: DWORD = 99;
DEFINE_PROPERTYKEY!{PKEY_RatingText,
    0x90197CA7, 0xFD8F, 0x4E8C, 0x9D, 0xA3, 0xB5, 0x7E, 0x1E, 0x60, 0x92, 0x95, 100}
DEFINE_PROPERTYKEY!{PKEY_RemoteConflictingFile,
    0xFCEFF153, 0xE839, 0x4CF3, 0xA9, 0xE7, 0xEA, 0x22, 0x83, 0x20, 0x94, 0xB8, 115}
DEFINE_PROPERTYKEY!{PKEY_Security_AllowedEnterpriseDataProtectionIdentities,
    0x38D43380, 0xD418, 0x4830, 0x84, 0xD5, 0x46, 0x93, 0x5A, 0x81, 0xC5, 0xC6, 32}
DEFINE_PROPERTYKEY!{PKEY_Security_EncryptionOwners,
    0x5F5AFF6A, 0x37E5, 0x4780, 0x97, 0xEA, 0x80, 0xC7, 0x56, 0x5C, 0xF5, 0x35, 34}
DEFINE_PROPERTYKEY!{PKEY_Security_EncryptionOwnersDisplay,
    0xDE621B8F, 0xE125, 0x43A3, 0xA3, 0x2D, 0x56, 0x65, 0x44, 0x6D, 0x63, 0x2A, 25}
DEFINE_PROPERTYKEY!{PKEY_Sensitivity,
    0xF8D3F6AC, 0x4874, 0x42CB, 0xBE, 0x59, 0xAB, 0x45, 0x4B, 0x30, 0x71, 0x6A, 100}
pub const SENSITIVITY_PROP_NORMAL: DWORD = 0;
pub const SENSITIVITY_PROP_PERSONAL: DWORD = 1;
pub const SENSITIVITY_PROP_PRIVATE: DWORD = 2;
pub const SENSITIVITY_PROP_CONFIDENTIAL: DWORD = 3;
DEFINE_PROPERTYKEY!{PKEY_SensitivityText,
    0xD0C7F054, 0x3F72, 0x4725, 0x85, 0x27, 0x12, 0x9A, 0x57, 0x7C, 0xB2, 0x69, 100}
DEFINE_PROPERTYKEY!{PKEY_SFGAOFlags,
    0x28636AA6, 0x953D, 0x11D2, 0xB5, 0xD6, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0xD0, 25}
DEFINE_PROPERTYKEY!{PKEY_SharedWith,
    0xEF884C5B, 0x2BFE, 0x41BB, 0xAA, 0xE5, 0x76, 0xEE, 0xDF, 0x4F, 0x99, 0x02, 200}
DEFINE_PROPERTYKEY!{PKEY_ShareUserRating,
    0x64440492, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 12}
DEFINE_PROPERTYKEY!{PKEY_SharingStatus,
    0xEF884C5B, 0x2BFE, 0x41BB, 0xAA, 0xE5, 0x76, 0xEE, 0xDF, 0x4F, 0x99, 0x02, 300}
pub const SHARINGSTATUS_NOTSHARED: DWORD = 0;
pub const SHARINGSTATUS_SHARED: DWORD = 1;
pub const SHARINGSTATUS_PRIVATE: DWORD = 2;
DEFINE_PROPERTYKEY!{PKEY_Shell_OmitFromView,
    0xDE35258C, 0xC695, 0x4CBC, 0xB9, 0x82, 0x38, 0xB0, 0xAD, 0x24, 0xCE, 0xD0, 2}
DEFINE_PROPERTYKEY!{PKEY_SimpleRating,
    0xA09F084E, 0xAD41, 0x489F, 0x80, 0x76, 0xAA, 0x5B, 0xE3, 0x08, 0x2B, 0xCA, 100}
DEFINE_PROPERTYKEY!{PKEY_Size,
    0xB725F130, 0x47EF, 0x101A, 0xA5, 0xF1, 0x02, 0x60, 0x8C, 0x9E, 0xEB, 0xAC, 12}
DEFINE_PROPERTYKEY!{PKEY_SoftwareUsed,
    0x14B81DA1, 0x0135, 0x4D31, 0x96, 0xD9, 0x6C, 0xBF, 0xC9, 0x67, 0x1A, 0x99, 305}
DEFINE_PROPERTYKEY!{PKEY_SourceItem,
    0x668CDFA5, 0x7A1B, 0x4323, 0xAE, 0x4B, 0xE5, 0x27, 0x39, 0x3A, 0x1D, 0x81, 100}
DEFINE_PROPERTYKEY!{PKEY_SourcePackageFamilyName,
    0xFFAE9DB7, 0x1C8D, 0x43FF, 0x81, 0x8C, 0x84, 0x40, 0x3A, 0xA3, 0x73, 0x2D, 100}
DEFINE_PROPERTYKEY!{PKEY_StartDate,
    0x48FD6EC8, 0x8A12, 0x4CDF, 0xA0, 0x3E, 0x4E, 0xC5, 0xA5, 0x11, 0xED, 0xDE, 100}
DEFINE_PROPERTYKEY!{PKEY_Status,
    0x000214A1, 0x0000, 0x0000, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 9}
DEFINE_PROPERTYKEY!{PKEY_StorageProviderCallerVersionInformation,
    0xB2F9B9D6, 0xFEC4, 0x4DD5, 0x94, 0xD7, 0x89, 0x57, 0x48, 0x8C, 0x80, 0x7B, 7}
DEFINE_PROPERTYKEY!{PKEY_StorageProviderError,
    0xFCEFF153, 0xE839, 0x4CF3, 0xA9, 0xE7, 0xEA, 0x22, 0x83, 0x20, 0x94, 0xB8, 109}
DEFINE_PROPERTYKEY!{PKEY_StorageProviderFileChecksum,
    0xB2F9B9D6, 0xFEC4, 0x4DD5, 0x94, 0xD7, 0x89, 0x57, 0x48, 0x8C, 0x80, 0x7B, 5}
DEFINE_PROPERTYKEY!{PKEY_StorageProviderFileIdentifier,
    0xB2F9B9D6, 0xFEC4, 0x4DD5, 0x94, 0xD7, 0x89, 0x57, 0x48, 0x8C, 0x80, 0x7B, 3}
DEFINE_PROPERTYKEY!{PKEY_StorageProviderFileRemoteUri,
    0xFCEFF153, 0xE839, 0x4CF3, 0xA9, 0xE7, 0xEA, 0x22, 0x83, 0x20, 0x94, 0xB8, 112}
DEFINE_PROPERTYKEY!{PKEY_StorageProviderFileVersion,
    0xB2F9B9D6, 0xFEC4, 0x4DD5, 0x94, 0xD7, 0x89, 0x57, 0x48, 0x8C, 0x80, 0x7B, 4}
DEFINE_PROPERTYKEY!{PKEY_StorageProviderFileVersionWaterline,
    0xB2F9B9D6, 0xFEC4, 0x4DD5, 0x94, 0xD7, 0x89, 0x57, 0x48, 0x8C, 0x80, 0x7B, 6}
DEFINE_PROPERTYKEY!{PKEY_StorageProviderId,
    0xFCEFF153, 0xE839, 0x4CF3, 0xA9, 0xE7, 0xEA, 0x22, 0x83, 0x20, 0x94, 0xB8, 108}
DEFINE_PROPERTYKEY!{PKEY_StorageProviderShareStatuses,
    0xFCEFF153, 0xE839, 0x4CF3, 0xA9, 0xE7, 0xEA, 0x22, 0x83, 0x20, 0x94, 0xB8, 111}
pub const STORAGE_PROVIDER_SHARE_STATUS_PRIVATE: &'static str = "Private";
pub const STORAGE_PROVIDER_SHARE_STATUS_SHARED: &'static str = "Shared";
pub const STORAGE_PROVIDER_SHARE_STATUS_PUBLIC: &'static str = "Public";
pub const STORAGE_PROVIDER_SHARE_STATUS_GROUP: &'static str = "Group";
pub const STORAGE_PROVIDER_SHARE_STATUS_OWNER: &'static str = "Owner";
DEFINE_PROPERTYKEY!{PKEY_StorageProviderSharingStatus,
    0xFCEFF153, 0xE839, 0x4CF3, 0xA9, 0xE7, 0xEA, 0x22, 0x83, 0x20, 0x94, 0xB8, 117}
pub const STORAGE_PROVIDER_SHARINGSTATUS_NOTSHARED: DWORD = 0;
pub const STORAGE_PROVIDER_SHARINGSTATUS_SHARED: DWORD = 1;
pub const STORAGE_PROVIDER_SHARINGSTATUS_PRIVATE: DWORD = 2;
pub const STORAGE_PROVIDER_SHARINGSTATUS_PUBLIC: DWORD = 3;
pub const STORAGE_PROVIDER_SHARINGSTATUS_SHARED_OWNED: DWORD = 4;
pub const STORAGE_PROVIDER_SHARINGSTATUS_SHARED_COOWNED: DWORD = 5;
pub const STORAGE_PROVIDER_SHARINGSTATUS_PUBLIC_OWNED: DWORD = 6;
pub const STORAGE_PROVIDER_SHARINGSTATUS_PUBLIC_COOWNED: DWORD = 7;
DEFINE_PROPERTYKEY!{PKEY_StorageProviderStatus,
    0xFCEFF153, 0xE839, 0x4CF3, 0xA9, 0xE7, 0xEA, 0x22, 0x83, 0x20, 0x94, 0xB8, 110}
DEFINE_PROPERTYKEY!{PKEY_Subject,
    0xF29F85E0, 0x4FF9, 0x1068, 0xAB, 0x91, 0x08, 0x00, 0x2B, 0x27, 0xB3, 0xD9, 3}
DEFINE_PROPERTYKEY!{PKEY_SyncTransferStatus,
    0xFCEFF153, 0xE839, 0x4CF3, 0xA9, 0xE7, 0xEA, 0x22, 0x83, 0x20, 0x94, 0xB8, 103}
DEFINE_PROPERTYKEY!{PKEY_Thumbnail,
    0xF29F85E0, 0x4FF9, 0x1068, 0xAB, 0x91, 0x08, 0x00, 0x2B, 0x27, 0xB3, 0xD9, 17}
DEFINE_PROPERTYKEY!{PKEY_ThumbnailCacheId,
    0x446D16B1, 0x8DAD, 0x4870, 0xA7, 0x48, 0x40, 0x2E, 0xA4, 0x3D, 0x78, 0x8C, 100}
DEFINE_PROPERTYKEY!{PKEY_ThumbnailStream,
    0xF29F85E0, 0x4FF9, 0x1068, 0xAB, 0x91, 0x08, 0x00, 0x2B, 0x27, 0xB3, 0xD9, 27}
DEFINE_PROPERTYKEY!{PKEY_Title,
    0xF29F85E0, 0x4FF9, 0x1068, 0xAB, 0x91, 0x08, 0x00, 0x2B, 0x27, 0xB3, 0xD9, 2}
DEFINE_PROPERTYKEY!{PKEY_TitleSortOverride,
    0xF0F7984D, 0x222E, 0x4AD2, 0x82, 0xAB, 0x1D, 0xD8, 0xEA, 0x40, 0xE5, 0x7E, 300}
DEFINE_PROPERTYKEY!{PKEY_TotalFileSize,
    0x28636AA6, 0x953D, 0x11D2, 0xB5, 0xD6, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0xD0, 14}
DEFINE_PROPERTYKEY!{PKEY_Trademarks,
    0x0CEF7D53, 0xFA64, 0x11D1, 0xA2, 0x03, 0x00, 0x00, 0xF8, 0x1F, 0xED, 0xEE, 9}
DEFINE_PROPERTYKEY!{PKEY_TransferOrder,
    0xFCEFF153, 0xE839, 0x4CF3, 0xA9, 0xE7, 0xEA, 0x22, 0x83, 0x20, 0x94, 0xB8, 106}
DEFINE_PROPERTYKEY!{PKEY_TransferPosition,
    0xFCEFF153, 0xE839, 0x4CF3, 0xA9, 0xE7, 0xEA, 0x22, 0x83, 0x20, 0x94, 0xB8, 104}
DEFINE_PROPERTYKEY!{PKEY_TransferSize,
    0xFCEFF153, 0xE839, 0x4CF3, 0xA9, 0xE7, 0xEA, 0x22, 0x83, 0x20, 0x94, 0xB8, 105}
DEFINE_PROPERTYKEY!{PKEY_VolumeId,
    0x446D16B1, 0x8DAD, 0x4870, 0xA7, 0x48, 0x40, 0x2E, 0xA4, 0x3D, 0x78, 0x8C, 104}
DEFINE_PROPERTYKEY!{PKEY_ZoneIdentifier,
    0x502CFEAB, 0x47EB, 0x459C, 0xB9, 0x60, 0xE6, 0xD8, 0x72, 0x8F, 0x77, 0x01, 100}
DEFINE_PROPERTYKEY!{PKEY_Device_PrinterURL,
    0x0B48F35A, 0xBE6E, 0x4F17, 0xB1, 0x08, 0x3C, 0x40, 0x73, 0xD1, 0x66, 0x9A, 15}
DEFINE_PROPERTYKEY!{PKEY_DeviceInterface_Bluetooth_DeviceAddress,
    0x2BD67D8B, 0x8BEB, 0x48D5, 0x87, 0xE0, 0x6C, 0xDA, 0x34, 0x28, 0x04, 0x0A, 1}
DEFINE_PROPERTYKEY!{PKEY_DeviceInterface_Bluetooth_Flags,
    0x2BD67D8B, 0x8BEB, 0x48D5, 0x87, 0xE0, 0x6C, 0xDA, 0x34, 0x28, 0x04, 0x0A, 3}
DEFINE_PROPERTYKEY!{PKEY_DeviceInterface_Bluetooth_LastConnectedTime,
    0x2BD67D8B, 0x8BEB, 0x48D5, 0x87, 0xE0, 0x6C, 0xDA, 0x34, 0x28, 0x04, 0x0A, 11}
DEFINE_PROPERTYKEY!{PKEY_DeviceInterface_Bluetooth_Manufacturer,
    0x2BD67D8B, 0x8BEB, 0x48D5, 0x87, 0xE0, 0x6C, 0xDA, 0x34, 0x28, 0x04, 0x0A, 4}
DEFINE_PROPERTYKEY!{PKEY_DeviceInterface_Bluetooth_ModelNumber,
    0x2BD67D8B, 0x8BEB, 0x48D5, 0x87, 0xE0, 0x6C, 0xDA, 0x34, 0x28, 0x04, 0x0A, 5}
DEFINE_PROPERTYKEY!{PKEY_DeviceInterface_Bluetooth_ProductId,
    0x2BD67D8B, 0x8BEB, 0x48D5, 0x87, 0xE0, 0x6C, 0xDA, 0x34, 0x28, 0x04, 0x0A, 8}
DEFINE_PROPERTYKEY!{PKEY_DeviceInterface_Bluetooth_ProductVersion,
    0x2BD67D8B, 0x8BEB, 0x48D5, 0x87, 0xE0, 0x6C, 0xDA, 0x34, 0x28, 0x04, 0x0A, 9}
DEFINE_PROPERTYKEY!{PKEY_DeviceInterface_Bluetooth_ServiceGuid,
    0x2BD67D8B, 0x8BEB, 0x48D5, 0x87, 0xE0, 0x6C, 0xDA, 0x34, 0x28, 0x04, 0x0A, 2}
DEFINE_PROPERTYKEY!{PKEY_DeviceInterface_Bluetooth_VendorId,
    0x2BD67D8B, 0x8BEB, 0x48D5, 0x87, 0xE0, 0x6C, 0xDA, 0x34, 0x28, 0x04, 0x0A, 7}
DEFINE_PROPERTYKEY!{PKEY_DeviceInterface_Bluetooth_VendorIdSource,
    0x2BD67D8B, 0x8BEB, 0x48D5, 0x87, 0xE0, 0x6C, 0xDA, 0x34, 0x28, 0x04, 0x0A, 6}
DEFINE_PROPERTYKEY!{PKEY_DeviceInterface_Hid_IsReadOnly,
    0xCBF38310, 0x4A17, 0x4310, 0xA1, 0xEB, 0x24, 0x7F, 0x0B, 0x67, 0x59, 0x3B, 4}
DEFINE_PROPERTYKEY!{PKEY_DeviceInterface_Hid_ProductId,
    0xCBF38310, 0x4A17, 0x4310, 0xA1, 0xEB, 0x24, 0x7F, 0x0B, 0x67, 0x59, 0x3B, 6}
DEFINE_PROPERTYKEY!{PKEY_DeviceInterface_Hid_UsageId,
    0xCBF38310, 0x4A17, 0x4310, 0xA1, 0xEB, 0x24, 0x7F, 0x0B, 0x67, 0x59, 0x3B, 3}
DEFINE_PROPERTYKEY!{PKEY_DeviceInterface_Hid_UsagePage,
    0xCBF38310, 0x4A17, 0x4310, 0xA1, 0xEB, 0x24, 0x7F, 0x0B, 0x67, 0x59, 0x3B, 2}
DEFINE_PROPERTYKEY!{PKEY_DeviceInterface_Hid_VendorId,
    0xCBF38310, 0x4A17, 0x4310, 0xA1, 0xEB, 0x24, 0x7F, 0x0B, 0x67, 0x59, 0x3B, 5}
DEFINE_PROPERTYKEY!{PKEY_DeviceInterface_Hid_VersionNumber,
    0xCBF38310, 0x4A17, 0x4310, 0xA1, 0xEB, 0x24, 0x7F, 0x0B, 0x67, 0x59, 0x3B, 7}
DEFINE_PROPERTYKEY!{PKEY_DeviceInterface_PrinterDriverDirectory,
    0x847C66DE, 0xB8D6, 0x4AF9, 0xAB, 0xC3, 0x6F, 0x4F, 0x92, 0x6B, 0xC0, 0x39, 14}
DEFINE_PROPERTYKEY!{PKEY_DeviceInterface_PrinterDriverName,
    0xAFC47170, 0x14F5, 0x498C, 0x8F, 0x30, 0xB0, 0xD1, 0x9B, 0xE4, 0x49, 0xC6, 11}
DEFINE_PROPERTYKEY!{PKEY_DeviceInterface_PrinterEnumerationFlag,
    0xA00742A1, 0xCD8C, 0x4B37, 0x95, 0xAB, 0x70, 0x75, 0x55, 0x87, 0x76, 0x7A, 3}
DEFINE_PROPERTYKEY!{PKEY_DeviceInterface_PrinterName,
    0x0A7B84EF, 0x0C27, 0x463F, 0x84, 0xEF, 0x06, 0xC5, 0x07, 0x00, 0x01, 0xBE, 10}
DEFINE_PROPERTYKEY!{PKEY_DeviceInterface_PrinterPortName,
    0xEEC7B761, 0x6F94, 0x41B1, 0x94, 0x9F, 0xC7, 0x29, 0x72, 0x0D, 0xD1, 0x3C, 12}
DEFINE_PROPERTYKEY!{PKEY_DeviceInterface_Proximity_SupportsNfc,
    0xFB3842CD, 0x9E2A, 0x4F83, 0x8F, 0xCC, 0x4B, 0x07, 0x61, 0x13, 0x9A, 0xE9, 2}
DEFINE_PROPERTYKEY!{PKEY_DeviceInterface_Serial_PortName,
    0x4C6BF15C, 0x4C03, 0x4AAC, 0x91, 0xF5, 0x64, 0xC0, 0xF8, 0x52, 0xBC, 0xF4, 4}
DEFINE_PROPERTYKEY!{PKEY_DeviceInterface_Serial_UsbProductId,
    0x4C6BF15C, 0x4C03, 0x4AAC, 0x91, 0xF5, 0x64, 0xC0, 0xF8, 0x52, 0xBC, 0xF4, 3}
DEFINE_PROPERTYKEY!{PKEY_DeviceInterface_Serial_UsbVendorId,
    0x4C6BF15C, 0x4C03, 0x4AAC, 0x91, 0xF5, 0x64, 0xC0, 0xF8, 0x52, 0xBC, 0xF4, 2}
DEFINE_PROPERTYKEY!{PKEY_DeviceInterface_WinUsb_DeviceInterfaceClasses,
    0x95E127B5, 0x79CC, 0x4E83, 0x9C, 0x9E, 0x84, 0x22, 0x18, 0x7B, 0x3E, 0x0E, 7}
DEFINE_PROPERTYKEY!{PKEY_DeviceInterface_WinUsb_UsbClass,
    0x95E127B5, 0x79CC, 0x4E83, 0x9C, 0x9E, 0x84, 0x22, 0x18, 0x7B, 0x3E, 0x0E, 4}
DEFINE_PROPERTYKEY!{PKEY_DeviceInterface_WinUsb_UsbProductId,
    0x95E127B5, 0x79CC, 0x4E83, 0x9C, 0x9E, 0x84, 0x22, 0x18, 0x7B, 0x3E, 0x0E, 3}
DEFINE_PROPERTYKEY!{PKEY_DeviceInterface_WinUsb_UsbProtocol,
    0x95E127B5, 0x79CC, 0x4E83, 0x9C, 0x9E, 0x84, 0x22, 0x18, 0x7B, 0x3E, 0x0E, 6}
DEFINE_PROPERTYKEY!{PKEY_DeviceInterface_WinUsb_UsbSubClass,
    0x95E127B5, 0x79CC, 0x4E83, 0x9C, 0x9E, 0x84, 0x22, 0x18, 0x7B, 0x3E, 0x0E, 5}
DEFINE_PROPERTYKEY!{PKEY_DeviceInterface_WinUsb_UsbVendorId,
    0x95E127B5, 0x79CC, 0x4E83, 0x9C, 0x9E, 0x84, 0x22, 0x18, 0x7B, 0x3E, 0x0E, 2}
DEFINE_PROPERTYKEY!{PKEY_Devices_Aep_AepId,
    0x3B2CE006, 0x5E61, 0x4FDE, 0xBA, 0xB8, 0x9B, 0x8A, 0xAC, 0x9B, 0x26, 0xDF, 8}
DEFINE_PROPERTYKEY!{PKEY_Devices_Aep_Bluetooth_Cod_Major,
    0x5FBD34CD, 0x561A, 0x412E, 0xBA, 0x98, 0x47, 0x8A, 0x6B, 0x0F, 0xEF, 0x1D, 2}
DEFINE_PROPERTYKEY!{PKEY_Devices_Aep_Bluetooth_Cod_Minor,
    0x5FBD34CD, 0x561A, 0x412E, 0xBA, 0x98, 0x47, 0x8A, 0x6B, 0x0F, 0xEF, 0x1D, 3}
DEFINE_PROPERTYKEY!{PKEY_Devices_Aep_Bluetooth_Cod_Services_Audio,
    0x5FBD34CD, 0x561A, 0x412E, 0xBA, 0x98, 0x47, 0x8A, 0x6B, 0x0F, 0xEF, 0x1D, 10}
DEFINE_PROPERTYKEY!{PKEY_Devices_Aep_Bluetooth_Cod_Services_Capturing,
    0x5FBD34CD, 0x561A, 0x412E, 0xBA, 0x98, 0x47, 0x8A, 0x6B, 0x0F, 0xEF, 0x1D, 8}
DEFINE_PROPERTYKEY!{PKEY_Devices_Aep_Bluetooth_Cod_Services_Information,
    0x5FBD34CD, 0x561A, 0x412E, 0xBA, 0x98, 0x47, 0x8A, 0x6B, 0x0F, 0xEF, 0x1D, 12}
DEFINE_PROPERTYKEY!{PKEY_Devices_Aep_Bluetooth_Cod_Services_LimitedDiscovery,
    0x5FBD34CD, 0x561A, 0x412E, 0xBA, 0x98, 0x47, 0x8A, 0x6B, 0x0F, 0xEF, 0x1D, 4}
DEFINE_PROPERTYKEY!{PKEY_Devices_Aep_Bluetooth_Cod_Services_Networking,
    0x5FBD34CD, 0x561A, 0x412E, 0xBA, 0x98, 0x47, 0x8A, 0x6B, 0x0F, 0xEF, 0x1D, 6}
DEFINE_PROPERTYKEY!{PKEY_Devices_Aep_Bluetooth_Cod_Services_ObjectXfer,
    0x5FBD34CD, 0x561A, 0x412E, 0xBA, 0x98, 0x47, 0x8A, 0x6B, 0x0F, 0xEF, 0x1D, 9}
DEFINE_PROPERTYKEY!{PKEY_Devices_Aep_Bluetooth_Cod_Services_Positioning,
    0x5FBD34CD, 0x561A, 0x412E, 0xBA, 0x98, 0x47, 0x8A, 0x6B, 0x0F, 0xEF, 0x1D, 5}
DEFINE_PROPERTYKEY!{PKEY_Devices_Aep_Bluetooth_Cod_Services_Rendering,
    0x5FBD34CD, 0x561A, 0x412E, 0xBA, 0x98, 0x47, 0x8A, 0x6B, 0x0F, 0xEF, 0x1D, 7}
DEFINE_PROPERTYKEY!{PKEY_Devices_Aep_Bluetooth_Cod_Services_Telephony,
    0x5FBD34CD, 0x561A, 0x412E, 0xBA, 0x98, 0x47, 0x8A, 0x6B, 0x0F, 0xEF, 0x1D, 11}
DEFINE_PROPERTYKEY!{PKEY_Devices_Aep_Bluetooth_Le_AddressType,
    0x995EF0B0, 0x7EB3, 0x4A8B, 0xB9, 0xCE, 0x06, 0x8B, 0xB3, 0xF4, 0xAF, 0x69, 4}
pub const BLUETOOTH_ADDRESS_TYPE_PUBLIC: LONG = 0;
pub const BLUETOOTH_ADDRESS_TYPE_RANDOM: LONG = 1;
DEFINE_PROPERTYKEY!{PKEY_Devices_Aep_Bluetooth_Le_Appearance,
    0x995EF0B0, 0x7EB3, 0x4A8B, 0xB9, 0xCE, 0x06, 0x8B, 0xB3, 0xF4, 0xAF, 0x69, 1}
DEFINE_PROPERTYKEY!{PKEY_Devices_Aep_Bluetooth_Le_Appearance_Category,
    0x995EF0B0, 0x7EB3, 0x4A8B, 0xB9, 0xCE, 0x06, 0x8B, 0xB3, 0xF4, 0xAF, 0x69, 5}
DEFINE_PROPERTYKEY!{PKEY_Devices_Aep_Bluetooth_Le_Appearance_Subcategory,
    0x995EF0B0, 0x7EB3, 0x4A8B, 0xB9, 0xCE, 0x06, 0x8B, 0xB3, 0xF4, 0xAF, 0x69, 6}
DEFINE_PROPERTYKEY!{PKEY_Devices_Aep_Bluetooth_Le_IsConnectable,
    0x995EF0B0, 0x7EB3, 0x4A8B, 0xB9, 0xCE, 0x06, 0x8B, 0xB3, 0xF4, 0xAF, 0x69, 8}
DEFINE_PROPERTYKEY!{PKEY_Devices_Aep_CanPair,
    0xE7C3FB29, 0xCAA7, 0x4F47, 0x8C, 0x8B, 0xBE, 0x59, 0xB3, 0x30, 0xD4, 0xC5, 3}
DEFINE_PROPERTYKEY!{PKEY_Devices_Aep_Category,
    0xA35996AB, 0x11CF, 0x4935, 0x8B, 0x61, 0xA6, 0x76, 0x10, 0x81, 0xEC, 0xDF, 17}
DEFINE_PROPERTYKEY!{PKEY_Devices_Aep_ContainerId,
    0xE7C3FB29, 0xCAA7, 0x4F47, 0x8C, 0x8B, 0xBE, 0x59, 0xB3, 0x30, 0xD4, 0xC5, 2}
DEFINE_PROPERTYKEY!{PKEY_Devices_Aep_DeviceAddress,
    0xA35996AB, 0x11CF, 0x4935, 0x8B, 0x61, 0xA6, 0x76, 0x10, 0x81, 0xEC, 0xDF, 12}
DEFINE_PROPERTYKEY!{PKEY_Devices_Aep_IsConnected,
    0xA35996AB, 0x11CF, 0x4935, 0x8B, 0x61, 0xA6, 0x76, 0x10, 0x81, 0xEC, 0xDF, 7}
DEFINE_PROPERTYKEY!{PKEY_Devices_Aep_IsPaired,
    0xA35996AB, 0x11CF, 0x4935, 0x8B, 0x61, 0xA6, 0x76, 0x10, 0x81, 0xEC, 0xDF, 16}
DEFINE_PROPERTYKEY!{PKEY_Devices_Aep_IsPresent,
    0xA35996AB, 0x11CF, 0x4935, 0x8B, 0x61, 0xA6, 0x76, 0x10, 0x81, 0xEC, 0xDF, 9}
DEFINE_PROPERTYKEY!{PKEY_Devices_Aep_Manufacturer,
    0xA35996AB, 0x11CF, 0x4935, 0x8B, 0x61, 0xA6, 0x76, 0x10, 0x81, 0xEC, 0xDF, 5}
DEFINE_PROPERTYKEY!{PKEY_Devices_Aep_ModelId,
    0xA35996AB, 0x11CF, 0x4935, 0x8B, 0x61, 0xA6, 0x76, 0x10, 0x81, 0xEC, 0xDF, 4}
DEFINE_PROPERTYKEY!{PKEY_Devices_Aep_ModelName,
    0xA35996AB, 0x11CF, 0x4935, 0x8B, 0x61, 0xA6, 0x76, 0x10, 0x81, 0xEC, 0xDF, 3}
DEFINE_PROPERTYKEY!{PKEY_Devices_Aep_PointOfService_ConnectionTypes,
    0xD4BF61B3, 0x442E, 0x4ADA, 0x88, 0x2D, 0xFA, 0x7B, 0x70, 0xC8, 0x32, 0xD9, 6}
DEFINE_PROPERTYKEY!{PKEY_Devices_Aep_ProtocolId,
    0x3B2CE006, 0x5E61, 0x4FDE, 0xBA, 0xB8, 0x9B, 0x8A, 0xAC, 0x9B, 0x26, 0xDF, 5}
DEFINE_PROPERTYKEY!{PKEY_Devices_Aep_SignalStrength,
    0xA35996AB, 0x11CF, 0x4935, 0x8B, 0x61, 0xA6, 0x76, 0x10, 0x81, 0xEC, 0xDF, 6}
DEFINE_PROPERTYKEY!{PKEY_Devices_AepContainer_CanPair,
    0x0BBA1EDE, 0x7566, 0x4F47, 0x90, 0xEC, 0x25, 0xFC, 0x56, 0x7C, 0xED, 0x2A, 3}
DEFINE_PROPERTYKEY!{PKEY_Devices_AepContainer_Categories,
    0x0BBA1EDE, 0x7566, 0x4F47, 0x90, 0xEC, 0x25, 0xFC, 0x56, 0x7C, 0xED, 0x2A, 9}
DEFINE_PROPERTYKEY!{PKEY_Devices_AepContainer_Children,
    0x0BBA1EDE, 0x7566, 0x4F47, 0x90, 0xEC, 0x25, 0xFC, 0x56, 0x7C, 0xED, 0x2A, 2}
DEFINE_PROPERTYKEY!{PKEY_Devices_AepContainer_ContainerId,
    0x0BBA1EDE, 0x7566, 0x4F47, 0x90, 0xEC, 0x25, 0xFC, 0x56, 0x7C, 0xED, 0x2A, 12}
DEFINE_PROPERTYKEY!{PKEY_Devices_AepContainer_DialProtocol_InstalledApplications,
    0x6AF55D45, 0x38DB, 0x4495, 0xAC, 0xB0, 0xD4, 0x72, 0x8A, 0x3B, 0x83, 0x14, 6}
DEFINE_PROPERTYKEY!{PKEY_Devices_AepContainer_IsPaired,
    0x0BBA1EDE, 0x7566, 0x4F47, 0x90, 0xEC, 0x25, 0xFC, 0x56, 0x7C, 0xED, 0x2A, 4}
DEFINE_PROPERTYKEY!{PKEY_Devices_AepContainer_IsPresent,
    0x0BBA1EDE, 0x7566, 0x4F47, 0x90, 0xEC, 0x25, 0xFC, 0x56, 0x7C, 0xED, 0x2A, 11}
DEFINE_PROPERTYKEY!{PKEY_Devices_AepContainer_Manufacturer,
    0x0BBA1EDE, 0x7566, 0x4F47, 0x90, 0xEC, 0x25, 0xFC, 0x56, 0x7C, 0xED, 0x2A, 6}
DEFINE_PROPERTYKEY!{PKEY_Devices_AepContainer_ModelIds,
    0x0BBA1EDE, 0x7566, 0x4F47, 0x90, 0xEC, 0x25, 0xFC, 0x56, 0x7C, 0xED, 0x2A, 8}
DEFINE_PROPERTYKEY!{PKEY_Devices_AepContainer_ModelName,
    0x0BBA1EDE, 0x7566, 0x4F47, 0x90, 0xEC, 0x25, 0xFC, 0x56, 0x7C, 0xED, 0x2A, 7}
DEFINE_PROPERTYKEY!{PKEY_Devices_AepContainer_ProtocolIds,
    0x0BBA1EDE, 0x7566, 0x4F47, 0x90, 0xEC, 0x25, 0xFC, 0x56, 0x7C, 0xED, 0x2A, 13}
DEFINE_PROPERTYKEY!{PKEY_Devices_AepContainer_SupportedUriSchemes,
    0x6AF55D45, 0x38DB, 0x4495, 0xAC, 0xB0, 0xD4, 0x72, 0x8A, 0x3B, 0x83, 0x14, 5}
DEFINE_PROPERTYKEY!{PKEY_Devices_AepContainer_SupportsAudio,
    0x6AF55D45, 0x38DB, 0x4495, 0xAC, 0xB0, 0xD4, 0x72, 0x8A, 0x3B, 0x83, 0x14, 2}
DEFINE_PROPERTYKEY!{PKEY_Devices_AepContainer_SupportsCapturing,
    0x6AF55D45, 0x38DB, 0x4495, 0xAC, 0xB0, 0xD4, 0x72, 0x8A, 0x3B, 0x83, 0x14, 11}
DEFINE_PROPERTYKEY!{PKEY_Devices_AepContainer_SupportsImages,
    0x6AF55D45, 0x38DB, 0x4495, 0xAC, 0xB0, 0xD4, 0x72, 0x8A, 0x3B, 0x83, 0x14, 4}
DEFINE_PROPERTYKEY!{PKEY_Devices_AepContainer_SupportsInformation,
    0x6AF55D45, 0x38DB, 0x4495, 0xAC, 0xB0, 0xD4, 0x72, 0x8A, 0x3B, 0x83, 0x14, 14}
DEFINE_PROPERTYKEY!{PKEY_Devices_AepContainer_SupportsLimitedDiscovery,
    0x6AF55D45, 0x38DB, 0x4495, 0xAC, 0xB0, 0xD4, 0x72, 0x8A, 0x3B, 0x83, 0x14, 7}
DEFINE_PROPERTYKEY!{PKEY_Devices_AepContainer_SupportsNetworking,
    0x6AF55D45, 0x38DB, 0x4495, 0xAC, 0xB0, 0xD4, 0x72, 0x8A, 0x3B, 0x83, 0x14, 9}
DEFINE_PROPERTYKEY!{PKEY_Devices_AepContainer_SupportsObjectTransfer,
    0x6AF55D45, 0x38DB, 0x4495, 0xAC, 0xB0, 0xD4, 0x72, 0x8A, 0x3B, 0x83, 0x14, 12}
DEFINE_PROPERTYKEY!{PKEY_Devices_AepContainer_SupportsPositioning,
    0x6AF55D45, 0x38DB, 0x4495, 0xAC, 0xB0, 0xD4, 0x72, 0x8A, 0x3B, 0x83, 0x14, 8}
DEFINE_PROPERTYKEY!{PKEY_Devices_AepContainer_SupportsRendering,
    0x6AF55D45, 0x38DB, 0x4495, 0xAC, 0xB0, 0xD4, 0x72, 0x8A, 0x3B, 0x83, 0x14, 10}
DEFINE_PROPERTYKEY!{PKEY_Devices_AepContainer_SupportsTelephony,
    0x6AF55D45, 0x38DB, 0x4495, 0xAC, 0xB0, 0xD4, 0x72, 0x8A, 0x3B, 0x83, 0x14, 13}
DEFINE_PROPERTYKEY!{PKEY_Devices_AepContainer_SupportsVideo,
    0x6AF55D45, 0x38DB, 0x4495, 0xAC, 0xB0, 0xD4, 0x72, 0x8A, 0x3B, 0x83, 0x14, 3}
DEFINE_PROPERTYKEY!{PKEY_Devices_AepService_AepId,
    0xC9C141A9, 0x1B4C, 0x4F17, 0xA9, 0xD1, 0xF2, 0x98, 0x53, 0x8C, 0xAD, 0xB8, 6}
DEFINE_PROPERTYKEY!{PKEY_Devices_AepService_Bluetooth_CacheMode,
    0x9744311E, 0x7951, 0x4B2E, 0xB6, 0xF0, 0xEC, 0xB2, 0x93, 0xCA, 0xC1, 0x19, 5}
pub const BLUETOOTH_CACHE_MODE_CACHED: LONG = 0;
pub const BLUETOOTH_CACHED_MODE_UNCACHED: LONG = 1;
DEFINE_PROPERTYKEY!{PKEY_Devices_AepService_Bluetooth_ServiceGuid,
    0xA399AAC7, 0xC265, 0x474E, 0xB0, 0x73, 0xFF, 0xCE, 0x57, 0x72, 0x17, 0x16, 2}
DEFINE_PROPERTYKEY!{PKEY_Devices_AepService_Bluetooth_TargetDevice,
    0x9744311E, 0x7951, 0x4B2E, 0xB6, 0xF0, 0xEC, 0xB2, 0x93, 0xCA, 0xC1, 0x19, 6}
DEFINE_PROPERTYKEY!{PKEY_Devices_AepService_ContainerId,
    0x71724756, 0x3E74, 0x4432, 0x9B, 0x59, 0xE7, 0xB2, 0xF6, 0x68, 0xA5, 0x93, 4}
DEFINE_PROPERTYKEY!{PKEY_Devices_AepService_FriendlyName,
    0x71724756, 0x3E74, 0x4432, 0x9B, 0x59, 0xE7, 0xB2, 0xF6, 0x68, 0xA5, 0x93, 2}
DEFINE_PROPERTYKEY!{PKEY_Devices_AepService_IoT_ServiceInterfaces,
    0x79D94E82, 0x4D79, 0x45AA, 0x82, 0x1A, 0x74, 0x85, 0x8B, 0x4E, 0x4C, 0xA6, 2}
DEFINE_PROPERTYKEY!{PKEY_Devices_AepService_ParentAepIsPaired,
    0xC9C141A9, 0x1B4C, 0x4F17, 0xA9, 0xD1, 0xF2, 0x98, 0x53, 0x8C, 0xAD, 0xB8, 7}
DEFINE_PROPERTYKEY!{PKEY_Devices_AepService_ProtocolId,
    0xC9C141A9, 0x1B4C, 0x4F17, 0xA9, 0xD1, 0xF2, 0x98, 0x53, 0x8C, 0xAD, 0xB8, 5}
DEFINE_PROPERTYKEY!{PKEY_Devices_AepService_ServiceClassId,
    0x71724756, 0x3E74, 0x4432, 0x9B, 0x59, 0xE7, 0xB2, 0xF6, 0x68, 0xA5, 0x93, 3}
DEFINE_PROPERTYKEY!{PKEY_Devices_AepService_ServiceId,
    0xC9C141A9, 0x1B4C, 0x4F17, 0xA9, 0xD1, 0xF2, 0x98, 0x53, 0x8C, 0xAD, 0xB8, 2}
DEFINE_PROPERTYKEY!{PKEY_Devices_AppPackageFamilyName,
    0x51236583, 0x0C4A, 0x4FE8, 0xB8, 0x1F, 0x16, 0x6A, 0xEC, 0x13, 0xF5, 0x10, 100}
DEFINE_PROPERTYKEY!{PKEY_Devices_AudioDevice_Microphone_SensitivityInDbfs,
    0x8943B373, 0x388C, 0x4395, 0xB5, 0x57, 0xBC, 0x6D, 0xBA, 0xFF, 0xAF, 0xDB, 3}
DEFINE_PROPERTYKEY!{PKEY_Devices_AudioDevice_Microphone_SignalToNoiseRatioInDb,
    0x8943B373, 0x388C, 0x4395, 0xB5, 0x57, 0xBC, 0x6D, 0xBA, 0xFF, 0xAF, 0xDB, 4}
DEFINE_PROPERTYKEY!{PKEY_Devices_AudioDevice_RawProcessingSupported,
    0x8943B373, 0x388C, 0x4395, 0xB5, 0x57, 0xBC, 0x6D, 0xBA, 0xFF, 0xAF, 0xDB, 2}
DEFINE_PROPERTYKEY!{PKEY_Devices_AudioDevice_SpeechProcessingSupported,
    0xFB1DE864, 0xE06D, 0x47F4, 0x82, 0xA6, 0x8A, 0x0A, 0xEF, 0x44, 0x49, 0x3C, 2}
DEFINE_PROPERTYKEY!{PKEY_Devices_BatteryLife,
    0x49CD1F76, 0x5626, 0x4B17, 0xA4, 0xE8, 0x18, 0xB4, 0xAA, 0x1A, 0x22, 0x13, 10}
DEFINE_PROPERTYKEY!{PKEY_Devices_BatteryPlusCharging,
    0x49CD1F76, 0x5626, 0x4B17, 0xA4, 0xE8, 0x18, 0xB4, 0xAA, 0x1A, 0x22, 0x13, 22}
DEFINE_PROPERTYKEY!{PKEY_Devices_BatteryPlusChargingText,
    0x49CD1F76, 0x5626, 0x4B17, 0xA4, 0xE8, 0x18, 0xB4, 0xAA, 0x1A, 0x22, 0x13, 23}
DEFINE_PROPERTYKEY!{PKEY_Devices_Category,
    0x78C34FC8, 0x104A, 0x4ACA, 0x9E, 0xA4, 0x52, 0x4D, 0x52, 0x99, 0x6E, 0x57, 91}
DEFINE_PROPERTYKEY!{PKEY_Devices_CategoryGroup,
    0x78C34FC8, 0x104A, 0x4ACA, 0x9E, 0xA4, 0x52, 0x4D, 0x52, 0x99, 0x6E, 0x57, 94}
DEFINE_PROPERTYKEY!{PKEY_Devices_CategoryIds,
    0x78C34FC8, 0x104A, 0x4ACA, 0x9E, 0xA4, 0x52, 0x4D, 0x52, 0x99, 0x6E, 0x57, 90}
DEFINE_PROPERTYKEY!{PKEY_Devices_CategoryPlural,
    0x78C34FC8, 0x104A, 0x4ACA, 0x9E, 0xA4, 0x52, 0x4D, 0x52, 0x99, 0x6E, 0x57, 92}
DEFINE_PROPERTYKEY!{PKEY_Devices_ChargingState,
    0x49CD1F76, 0x5626, 0x4B17, 0xA4, 0xE8, 0x18, 0xB4, 0xAA, 0x1A, 0x22, 0x13, 11}
DEFINE_PROPERTYKEY!{PKEY_Devices_Children,
    0x4340A6C5, 0x93FA, 0x4706, 0x97, 0x2C, 0x7B, 0x64, 0x80, 0x08, 0xA5, 0xA7, 9}
DEFINE_PROPERTYKEY!{PKEY_Devices_ClassGuid,
    0xA45C254E, 0xDF1C, 0x4EFD, 0x80, 0x20, 0x67, 0xD1, 0x46, 0xA8, 0x50, 0xE0, 10}
DEFINE_PROPERTYKEY!{PKEY_Devices_CompatibleIds,
    0xA45C254E, 0xDF1C, 0x4EFD, 0x80, 0x20, 0x67, 0xD1, 0x46, 0xA8, 0x50, 0xE0, 4}
DEFINE_PROPERTYKEY!{PKEY_Devices_Connected,
    0x78C34FC8, 0x104A, 0x4ACA, 0x9E, 0xA4, 0x52, 0x4D, 0x52, 0x99, 0x6E, 0x57, 55}
DEFINE_PROPERTYKEY!{PKEY_Devices_ContainerId,
    0x8C7ED206, 0x3F8A, 0x4827, 0xB3, 0xAB, 0xAE, 0x9E, 0x1F, 0xAE, 0xFC, 0x6C, 2}
DEFINE_PROPERTYKEY!{PKEY_Devices_DefaultTooltip,
    0x880F70A2, 0x6082, 0x47AC, 0x8A, 0xAB, 0xA7, 0x39, 0xD1, 0xA3, 0x00, 0xC3, 153}
DEFINE_PROPERTYKEY!{PKEY_Devices_DeviceCapabilities,
    0xA45C254E, 0xDF1C, 0x4EFD, 0x80, 0x20, 0x67, 0xD1, 0x46, 0xA8, 0x50, 0xE0, 17}
DEFINE_PROPERTYKEY!{PKEY_Devices_DeviceCharacteristics,
    0xA45C254E, 0xDF1C, 0x4EFD, 0x80, 0x20, 0x67, 0xD1, 0x46, 0xA8, 0x50, 0xE0, 29}
DEFINE_PROPERTYKEY!{PKEY_Devices_DeviceDescription1,
    0x78C34FC8, 0x104A, 0x4ACA, 0x9E, 0xA4, 0x52, 0x4D, 0x52, 0x99, 0x6E, 0x57, 81}
DEFINE_PROPERTYKEY!{PKEY_Devices_DeviceDescription2,
    0x78C34FC8, 0x104A, 0x4ACA, 0x9E, 0xA4, 0x52, 0x4D, 0x52, 0x99, 0x6E, 0x57, 82}
DEFINE_PROPERTYKEY!{PKEY_Devices_DeviceHasProblem,
    0x540B947E, 0x8B40, 0x45BC, 0xA8, 0xA2, 0x6A, 0x0B, 0x89, 0x4C, 0xBD, 0xA2, 6}
DEFINE_PROPERTYKEY!{PKEY_Devices_DeviceInstanceId,
    0x78C34FC8, 0x104A, 0x4ACA, 0x9E, 0xA4, 0x52, 0x4D, 0x52, 0x99, 0x6E, 0x57, 256}
DEFINE_PROPERTYKEY!{PKEY_Devices_DeviceManufacturer,
    0xA45C254E, 0xDF1C, 0x4EFD, 0x80, 0x20, 0x67, 0xD1, 0x46, 0xA8, 0x50, 0xE0, 13}
DEFINE_PROPERTYKEY!{PKEY_Devices_DevObjectType,
    0x13673F42, 0xA3D6, 0x49F6, 0xB4, 0xDA, 0xAE, 0x46, 0xE0, 0xC5, 0x23, 0x7C, 2}
DEFINE_PROPERTYKEY!{PKEY_Devices_DialProtocol_InstalledApplications,
    0x6845CC72, 0x1B71, 0x48C3, 0xAF, 0x86, 0xB0, 0x91, 0x71, 0xA1, 0x9B, 0x14, 3}
DEFINE_PROPERTYKEY!{PKEY_Devices_DiscoveryMethod,
    0x78C34FC8, 0x104A, 0x4ACA, 0x9E, 0xA4, 0x52, 0x4D, 0x52, 0x99, 0x6E, 0x57, 52}
DEFINE_PROPERTYKEY!{PKEY_Devices_Dnssd_Domain,
    0xBF79C0AB, 0xBB74, 0x4CEE, 0xB0, 0x70, 0x47, 0x0B, 0x5A, 0xE2, 0x02, 0xEA, 3}
DEFINE_PROPERTYKEY!{PKEY_Devices_Dnssd_FullName,
    0xBF79C0AB, 0xBB74, 0x4CEE, 0xB0, 0x70, 0x47, 0x0B, 0x5A, 0xE2, 0x02, 0xEA, 5}
DEFINE_PROPERTYKEY!{PKEY_Devices_Dnssd_HostName,
    0xBF79C0AB, 0xBB74, 0x4CEE, 0xB0, 0x70, 0x47, 0x0B, 0x5A, 0xE2, 0x02, 0xEA, 7}
DEFINE_PROPERTYKEY!{PKEY_Devices_Dnssd_InstanceName,
    0xBF79C0AB, 0xBB74, 0x4CEE, 0xB0, 0x70, 0x47, 0x0B, 0x5A, 0xE2, 0x02, 0xEA, 4}
DEFINE_PROPERTYKEY!{PKEY_Devices_Dnssd_NetworkAdapterId,
    0xBF79C0AB, 0xBB74, 0x4CEE, 0xB0, 0x70, 0x47, 0x0B, 0x5A, 0xE2, 0x02, 0xEA, 11}
DEFINE_PROPERTYKEY!{PKEY_Devices_Dnssd_PortNumber,
    0xBF79C0AB, 0xBB74, 0x4CEE, 0xB0, 0x70, 0x47, 0x0B, 0x5A, 0xE2, 0x02, 0xEA, 12}
DEFINE_PROPERTYKEY!{PKEY_Devices_Dnssd_Priority,
    0xBF79C0AB, 0xBB74, 0x4CEE, 0xB0, 0x70, 0x47, 0x0B, 0x5A, 0xE2, 0x02, 0xEA, 9}
DEFINE_PROPERTYKEY!{PKEY_Devices_Dnssd_ServiceName,
    0xBF79C0AB, 0xBB74, 0x4CEE, 0xB0, 0x70, 0x47, 0x0B, 0x5A, 0xE2, 0x02, 0xEA, 2}
DEFINE_PROPERTYKEY!{PKEY_Devices_Dnssd_TextAttributes,
    0xBF79C0AB, 0xBB74, 0x4CEE, 0xB0, 0x70, 0x47, 0x0B, 0x5A, 0xE2, 0x02, 0xEA, 6}
DEFINE_PROPERTYKEY!{PKEY_Devices_Dnssd_Ttl,
    0xBF79C0AB, 0xBB74, 0x4CEE, 0xB0, 0x70, 0x47, 0x0B, 0x5A, 0xE2, 0x02, 0xEA, 10}
DEFINE_PROPERTYKEY!{PKEY_Devices_Dnssd_Weight,
    0xBF79C0AB, 0xBB74, 0x4CEE, 0xB0, 0x70, 0x47, 0x0B, 0x5A, 0xE2, 0x02, 0xEA, 8}
DEFINE_PROPERTYKEY!{PKEY_Devices_FriendlyName,
    0x656A3BB3, 0xECC0, 0x43FD, 0x84, 0x77, 0x4A, 0xE0, 0x40, 0x4A, 0x96, 0xCD, 12288}
DEFINE_PROPERTYKEY!{PKEY_Devices_FunctionPaths,
    0xD08DD4C0, 0x3A9E, 0x462E, 0x82, 0x90, 0x7B, 0x63, 0x6B, 0x25, 0x76, 0xB9, 3}
DEFINE_PROPERTYKEY!{PKEY_Devices_GlyphIcon,
    0x51236583, 0x0C4A, 0x4FE8, 0xB8, 0x1F, 0x16, 0x6A, 0xEC, 0x13, 0xF5, 0x10, 123}
DEFINE_PROPERTYKEY!{PKEY_Devices_HardwareIds,
    0xA45C254E, 0xDF1C, 0x4EFD, 0x80, 0x20, 0x67, 0xD1, 0x46, 0xA8, 0x50, 0xE0, 3}
DEFINE_PROPERTYKEY!{PKEY_Devices_Icon,
    0x78C34FC8, 0x104A, 0x4ACA, 0x9E, 0xA4, 0x52, 0x4D, 0x52, 0x99, 0x6E, 0x57, 57}
DEFINE_PROPERTYKEY!{PKEY_Devices_InLocalMachineContainer,
    0x8C7ED206, 0x3F8A, 0x4827, 0xB3, 0xAB, 0xAE, 0x9E, 0x1F, 0xAE, 0xFC, 0x6C, 4}
DEFINE_PROPERTYKEY!{PKEY_Devices_InterfaceClassGuid,
    0x026E516E, 0xB814, 0x414B, 0x83, 0xCD, 0x85, 0x6D, 0x6F, 0xEF, 0x48, 0x22, 4}
DEFINE_PROPERTYKEY!{PKEY_Devices_InterfaceEnabled,
    0x026E516E, 0xB814, 0x414B, 0x83, 0xCD, 0x85, 0x6D, 0x6F, 0xEF, 0x48, 0x22, 3}
DEFINE_PROPERTYKEY!{PKEY_Devices_InterfacePaths,
    0xD08DD4C0, 0x3A9E, 0x462E, 0x82, 0x90, 0x7B, 0x63, 0x6B, 0x25, 0x76, 0xB9, 2}
DEFINE_PROPERTYKEY!{PKEY_Devices_IpAddress,
    0x656A3BB3, 0xECC0, 0x43FD, 0x84, 0x77, 0x4A, 0xE0, 0x40, 0x4A, 0x96, 0xCD, 12297}
DEFINE_PROPERTYKEY!{PKEY_Devices_IsDefault,
    0x78C34FC8, 0x104A, 0x4ACA, 0x9E, 0xA4, 0x52, 0x4D, 0x52, 0x99, 0x6E, 0x57, 86}
DEFINE_PROPERTYKEY!{PKEY_Devices_IsNetworkConnected,
    0x78C34FC8, 0x104A, 0x4ACA, 0x9E, 0xA4, 0x52, 0x4D, 0x52, 0x99, 0x6E, 0x57, 85}
DEFINE_PROPERTYKEY!{PKEY_Devices_IsShared,
    0x78C34FC8, 0x104A, 0x4ACA, 0x9E, 0xA4, 0x52, 0x4D, 0x52, 0x99, 0x6E, 0x57, 84}
DEFINE_PROPERTYKEY!{PKEY_Devices_IsSoftwareInstalling,
    0x83DA6326, 0x97A6, 0x4088, 0x94, 0x53, 0xA1, 0x92, 0x3F, 0x57, 0x3B, 0x29, 9}
DEFINE_PROPERTYKEY!{PKEY_Devices_LaunchDeviceStageFromExplorer,
    0x78C34FC8, 0x104A, 0x4ACA, 0x9E, 0xA4, 0x52, 0x4D, 0x52, 0x99, 0x6E, 0x57, 77}
DEFINE_PROPERTYKEY!{PKEY_Devices_LocalMachine,
    0x78C34FC8, 0x104A, 0x4ACA, 0x9E, 0xA4, 0x52, 0x4D, 0x52, 0x99, 0x6E, 0x57, 70}
DEFINE_PROPERTYKEY!{PKEY_Devices_LocationPaths,
    0xA45C254E, 0xDF1C, 0x4EFD, 0x80, 0x20, 0x67, 0xD1, 0x46, 0xA8, 0x50, 0xE0, 37}
DEFINE_PROPERTYKEY!{PKEY_Devices_Manufacturer,
    0x656A3BB3, 0xECC0, 0x43FD, 0x84, 0x77, 0x4A, 0xE0, 0x40, 0x4A, 0x96, 0xCD, 8192}
DEFINE_PROPERTYKEY!{PKEY_Devices_MetadataPath,
    0x78C34FC8, 0x104A, 0x4ACA, 0x9E, 0xA4, 0x52, 0x4D, 0x52, 0x99, 0x6E, 0x57, 71}
DEFINE_PROPERTYKEY!{PKEY_Devices_MicrophoneArray_Geometry,
    0xA1829EA2, 0x27EB, 0x459E, 0x93, 0x5D, 0xB2, 0xFA, 0xD7, 0xB0, 0x77, 0x62, 2}
DEFINE_PROPERTYKEY!{PKEY_Devices_MissedCalls,
    0x49CD1F76, 0x5626, 0x4B17, 0xA4, 0xE8, 0x18, 0xB4, 0xAA, 0x1A, 0x22, 0x13, 5}
DEFINE_PROPERTYKEY!{PKEY_Devices_ModelId,
    0x80D81EA6, 0x7473, 0x4B0C, 0x82, 0x16, 0xEF, 0xC1, 0x1A, 0x2C, 0x4C, 0x8B, 2}
DEFINE_PROPERTYKEY!{PKEY_Devices_ModelName,
    0x656A3BB3, 0xECC0, 0x43FD, 0x84, 0x77, 0x4A, 0xE0, 0x40, 0x4A, 0x96, 0xCD, 8194}
DEFINE_PROPERTYKEY!{PKEY_Devices_ModelNumber,
    0x656A3BB3, 0xECC0, 0x43FD, 0x84, 0x77, 0x4A, 0xE0, 0x40, 0x4A, 0x96, 0xCD, 8195}
DEFINE_PROPERTYKEY!{PKEY_Devices_NetworkedTooltip,
    0x880F70A2, 0x6082, 0x47AC, 0x8A, 0xAB, 0xA7, 0x39, 0xD1, 0xA3, 0x00, 0xC3, 152}
DEFINE_PROPERTYKEY!{PKEY_Devices_NetworkName,
    0x49CD1F76, 0x5626, 0x4B17, 0xA4, 0xE8, 0x18, 0xB4, 0xAA, 0x1A, 0x22, 0x13, 7}
DEFINE_PROPERTYKEY!{PKEY_Devices_NetworkType,
    0x49CD1F76, 0x5626, 0x4B17, 0xA4, 0xE8, 0x18, 0xB4, 0xAA, 0x1A, 0x22, 0x13, 8}
DEFINE_PROPERTYKEY!{PKEY_Devices_NewPictures,
    0x49CD1F76, 0x5626, 0x4B17, 0xA4, 0xE8, 0x18, 0xB4, 0xAA, 0x1A, 0x22, 0x13, 4}
DEFINE_PROPERTYKEY!{PKEY_Devices_Notification,
    0x06704B0C, 0xE830, 0x4C81, 0x91, 0x78, 0x91, 0xE4, 0xE9, 0x5A, 0x80, 0xA0, 3}
DEFINE_PROPERTYKEY!{PKEY_Devices_Notifications_LowBattery,
    0xC4C07F2B, 0x8524, 0x4E66, 0xAE, 0x3A, 0xA6, 0x23, 0x5F, 0x10, 0x3B, 0xEB, 2}
DEFINE_PROPERTYKEY!{PKEY_Devices_Notifications_MissedCall,
    0x6614EF48, 0x4EFE, 0x4424, 0x9E, 0xDA, 0xC7, 0x9F, 0x40, 0x4E, 0xDF, 0x3E, 2}
DEFINE_PROPERTYKEY!{PKEY_Devices_Notifications_NewMessage,
    0x2BE9260A, 0x2012, 0x4742, 0xA5, 0x55, 0xF4, 0x1B, 0x63, 0x8B, 0x7D, 0xCB, 2}
DEFINE_PROPERTYKEY!{PKEY_Devices_Notifications_NewVoicemail,
    0x59569556, 0x0A08, 0x4212, 0x95, 0xB9, 0xFA, 0xE2, 0xAD, 0x64, 0x13, 0xDB, 2}
DEFINE_PROPERTYKEY!{PKEY_Devices_Notifications_StorageFull,
    0xA0E00EE1, 0xF0C7, 0x4D41, 0xB8, 0xE7, 0x26, 0xA7, 0xBD, 0x8D, 0x38, 0xB0, 2}
DEFINE_PROPERTYKEY!{PKEY_Devices_Notifications_StorageFullLinkText,
    0xA0E00EE1, 0xF0C7, 0x4D41, 0xB8, 0xE7, 0x26, 0xA7, 0xBD, 0x8D, 0x38, 0xB0, 3}
DEFINE_PROPERTYKEY!{PKEY_Devices_NotificationStore,
    0x06704B0C, 0xE830, 0x4C81, 0x91, 0x78, 0x91, 0xE4, 0xE9, 0x5A, 0x80, 0xA0, 2}
DEFINE_PROPERTYKEY!{PKEY_Devices_NotWorkingProperly,
    0x78C34FC8, 0x104A, 0x4ACA, 0x9E, 0xA4, 0x52, 0x4D, 0x52, 0x99, 0x6E, 0x57, 83}
DEFINE_PROPERTYKEY!{PKEY_Devices_Paired,
    0x78C34FC8, 0x104A, 0x4ACA, 0x9E, 0xA4, 0x52, 0x4D, 0x52, 0x99, 0x6E, 0x57, 56}
DEFINE_PROPERTYKEY!{PKEY_Devices_Parent,
    0x4340A6C5, 0x93FA, 0x4706, 0x97, 0x2C, 0x7B, 0x64, 0x80, 0x08, 0xA5, 0xA7, 8}
DEFINE_PROPERTYKEY!{PKEY_Devices_PhysicalDeviceLocation,
    0x540B947E, 0x8B40, 0x45BC, 0xA8, 0xA2, 0x6A, 0x0B, 0x89, 0x4C, 0xBD, 0xA2, 9}
DEFINE_PROPERTYKEY!{PKEY_Devices_PlaybackPositionPercent,
    0x3633DE59, 0x6825, 0x4381, 0xA4, 0x9B, 0x9F, 0x6B, 0xA1, 0x3A, 0x14, 0x71, 5}
DEFINE_PROPERTYKEY!{PKEY_Devices_PlaybackState,
    0x3633DE59, 0x6825, 0x4381, 0xA4, 0x9B, 0x9F, 0x6B, 0xA1, 0x3A, 0x14, 0x71, 2}
pub const PLAYBACKSTATE_UNKNOWN: LONG = 0;
pub const PLAYBACKSTATE_STOPPED: LONG = 1;
pub const PLAYBACKSTATE_PLAYING: LONG = 2;
pub const PLAYBACKSTATE_TRANSITIONING: LONG = 3;
pub const PLAYBACKSTATE_PAUSED: LONG = 4;
pub const PLAYBACKSTATE_RECORDINGPAUSED: LONG = 5;
pub const PLAYBACKSTATE_RECORDING: LONG = 6;
pub const PLAYBACKSTATE_NOMEDIA: LONG = 7;
DEFINE_PROPERTYKEY!{PKEY_Devices_PlaybackTitle,
    0x3633DE59, 0x6825, 0x4381, 0xA4, 0x9B, 0x9F, 0x6B, 0xA1, 0x3A, 0x14, 0x71, 3}
DEFINE_PROPERTYKEY!{PKEY_Devices_Present,
    0x540B947E, 0x8B40, 0x45BC, 0xA8, 0xA2, 0x6A, 0x0B, 0x89, 0x4C, 0xBD, 0xA2, 5}
DEFINE_PROPERTYKEY!{PKEY_Devices_PresentationUrl,
    0x656A3BB3, 0xECC0, 0x43FD, 0x84, 0x77, 0x4A, 0xE0, 0x40, 0x4A, 0x96, 0xCD, 8198}
DEFINE_PROPERTYKEY!{PKEY_Devices_PrimaryCategory,
    0xD08DD4C0, 0x3A9E, 0x462E, 0x82, 0x90, 0x7B, 0x63, 0x6B, 0x25, 0x76, 0xB9, 10}
DEFINE_PROPERTYKEY!{PKEY_Devices_RemainingDuration,
    0x3633DE59, 0x6825, 0x4381, 0xA4, 0x9B, 0x9F, 0x6B, 0xA1, 0x3A, 0x14, 0x71, 4}
DEFINE_PROPERTYKEY!{PKEY_Devices_RestrictedInterface,
    0x026E516E, 0xB814, 0x414B, 0x83, 0xCD, 0x85, 0x6D, 0x6F, 0xEF, 0x48, 0x22, 6}
DEFINE_PROPERTYKEY!{PKEY_Devices_Roaming,
    0x49CD1F76, 0x5626, 0x4B17, 0xA4, 0xE8, 0x18, 0xB4, 0xAA, 0x1A, 0x22, 0x13, 9}
DEFINE_PROPERTYKEY!{PKEY_Devices_SafeRemovalRequired,
    0xAFD97640, 0x86A3, 0x4210, 0xB6, 0x7C, 0x28, 0x9C, 0x41, 0xAA, 0xBE, 0x55, 2}
DEFINE_PROPERTYKEY!{PKEY_Devices_ServiceAddress,
    0x656A3BB3, 0xECC0, 0x43FD, 0x84, 0x77, 0x4A, 0xE0, 0x40, 0x4A, 0x96, 0xCD, 16384}
DEFINE_PROPERTYKEY!{PKEY_Devices_ServiceId,
    0x656A3BB3, 0xECC0, 0x43FD, 0x84, 0x77, 0x4A, 0xE0, 0x40, 0x4A, 0x96, 0xCD, 16385}
DEFINE_PROPERTYKEY!{PKEY_Devices_SharedTooltip,
    0x880F70A2, 0x6082, 0x47AC, 0x8A, 0xAB, 0xA7, 0x39, 0xD1, 0xA3, 0x00, 0xC3, 151}
DEFINE_PROPERTYKEY!{PKEY_Devices_SignalStrength,
    0x49CD1F76, 0x5626, 0x4B17, 0xA4, 0xE8, 0x18, 0xB4, 0xAA, 0x1A, 0x22, 0x13, 2}
DEFINE_PROPERTYKEY!{PKEY_Devices_SmartCards_ReaderKind,
    0xD6B5B883, 0x18BD, 0x4B4D, 0xB2, 0xEC, 0x9E, 0x38, 0xAF, 0xFE, 0xDA, 0x82, 2}
DEFINE_PROPERTYKEY!{PKEY_Devices_Status,
    0xD08DD4C0, 0x3A9E, 0x462E, 0x82, 0x90, 0x7B, 0x63, 0x6B, 0x25, 0x76, 0xB9, 259}
DEFINE_PROPERTYKEY!{PKEY_Devices_Status1,
    0xD08DD4C0, 0x3A9E, 0x462E, 0x82, 0x90, 0x7B, 0x63, 0x6B, 0x25, 0x76, 0xB9, 257}
DEFINE_PROPERTYKEY!{PKEY_Devices_Status2,
    0xD08DD4C0, 0x3A9E, 0x462E, 0x82, 0x90, 0x7B, 0x63, 0x6B, 0x25, 0x76, 0xB9, 258}
DEFINE_PROPERTYKEY!{PKEY_Devices_StorageCapacity,
    0x49CD1F76, 0x5626, 0x4B17, 0xA4, 0xE8, 0x18, 0xB4, 0xAA, 0x1A, 0x22, 0x13, 12}
DEFINE_PROPERTYKEY!{PKEY_Devices_StorageFreeSpace,
    0x49CD1F76, 0x5626, 0x4B17, 0xA4, 0xE8, 0x18, 0xB4, 0xAA, 0x1A, 0x22, 0x13, 13}
DEFINE_PROPERTYKEY!{PKEY_Devices_StorageFreeSpacePercent,
    0x49CD1F76, 0x5626, 0x4B17, 0xA4, 0xE8, 0x18, 0xB4, 0xAA, 0x1A, 0x22, 0x13, 14}
DEFINE_PROPERTYKEY!{PKEY_Devices_TextMessages,
    0x49CD1F76, 0x5626, 0x4B17, 0xA4, 0xE8, 0x18, 0xB4, 0xAA, 0x1A, 0x22, 0x13, 3}
DEFINE_PROPERTYKEY!{PKEY_Devices_Voicemail,
    0x49CD1F76, 0x5626, 0x4B17, 0xA4, 0xE8, 0x18, 0xB4, 0xAA, 0x1A, 0x22, 0x13, 6}
DEFINE_PROPERTYKEY!{PKEY_Devices_WiaDeviceType,
    0x6BDD1FC6, 0x810F, 0x11D0, 0xBE, 0xC7, 0x08, 0x00, 0x2B, 0xE2, 0x09, 0x2F, 2}
DEFINE_PROPERTYKEY!{PKEY_Devices_WiFi_InterfaceGuid,
    0xEF1167EB, 0xCBFC, 0x4341, 0xA5, 0x68, 0xA7, 0xC9, 0x1A, 0x68, 0x98, 0x2C, 2}
DEFINE_PROPERTYKEY!{PKEY_Devices_WiFiDirect_DeviceAddress,
    0x1506935D, 0xE3E7, 0x450F, 0x86, 0x37, 0x82, 0x23, 0x3E, 0xBE, 0x5F, 0x6E, 13}
DEFINE_PROPERTYKEY!{PKEY_Devices_WiFiDirect_GroupId,
    0x1506935D, 0xE3E7, 0x450F, 0x86, 0x37, 0x82, 0x23, 0x3E, 0xBE, 0x5F, 0x6E, 4}
DEFINE_PROPERTYKEY!{PKEY_Devices_WiFiDirect_InformationElements,
    0x1506935D, 0xE3E7, 0x450F, 0x86, 0x37, 0x82, 0x23, 0x3E, 0xBE, 0x5F, 0x6E, 12}
DEFINE_PROPERTYKEY!{PKEY_Devices_WiFiDirect_InterfaceAddress,
    0x1506935D, 0xE3E7, 0x450F, 0x86, 0x37, 0x82, 0x23, 0x3E, 0xBE, 0x5F, 0x6E, 2}
DEFINE_PROPERTYKEY!{PKEY_Devices_WiFiDirect_InterfaceGuid,
    0x1506935D, 0xE3E7, 0x450F, 0x86, 0x37, 0x82, 0x23, 0x3E, 0xBE, 0x5F, 0x6E, 3}
DEFINE_PROPERTYKEY!{PKEY_Devices_WiFiDirect_IsConnected,
    0x1506935D, 0xE3E7, 0x450F, 0x86, 0x37, 0x82, 0x23, 0x3E, 0xBE, 0x5F, 0x6E, 5}
DEFINE_PROPERTYKEY!{PKEY_Devices_WiFiDirect_IsLegacyDevice,
    0x1506935D, 0xE3E7, 0x450F, 0x86, 0x37, 0x82, 0x23, 0x3E, 0xBE, 0x5F, 0x6E, 7}
DEFINE_PROPERTYKEY!{PKEY_Devices_WiFiDirect_IsMiracastLcpSupported,
    0x1506935D, 0xE3E7, 0x450F, 0x86, 0x37, 0x82, 0x23, 0x3E, 0xBE, 0x5F, 0x6E, 9}
DEFINE_PROPERTYKEY!{PKEY_Devices_WiFiDirect_IsVisible,
    0x1506935D, 0xE3E7, 0x450F, 0x86, 0x37, 0x82, 0x23, 0x3E, 0xBE, 0x5F, 0x6E, 6}
DEFINE_PROPERTYKEY!{PKEY_Devices_WiFiDirect_MiracastVersion,
    0x1506935D, 0xE3E7, 0x450F, 0x86, 0x37, 0x82, 0x23, 0x3E, 0xBE, 0x5F, 0x6E, 8}
DEFINE_PROPERTYKEY!{PKEY_Devices_WiFiDirect_Services,
    0x1506935D, 0xE3E7, 0x450F, 0x86, 0x37, 0x82, 0x23, 0x3E, 0xBE, 0x5F, 0x6E, 10}
DEFINE_PROPERTYKEY!{PKEY_Devices_WiFiDirect_SupportedChannelList,
    0x1506935D, 0xE3E7, 0x450F, 0x86, 0x37, 0x82, 0x23, 0x3E, 0xBE, 0x5F, 0x6E, 11}
DEFINE_PROPERTYKEY!{PKEY_Devices_WiFiDirectServices_AdvertisementId,
    0x31B37743, 0x7C5E, 0x4005, 0x93, 0xE6, 0xE9, 0x53, 0xF9, 0x2B, 0x82, 0xE9, 5}
DEFINE_PROPERTYKEY!{PKEY_Devices_WiFiDirectServices_RequestServiceInformation,
    0x31B37743, 0x7C5E, 0x4005, 0x93, 0xE6, 0xE9, 0x53, 0xF9, 0x2B, 0x82, 0xE9, 7}
DEFINE_PROPERTYKEY!{PKEY_Devices_WiFiDirectServices_ServiceAddress,
    0x31B37743, 0x7C5E, 0x4005, 0x93, 0xE6, 0xE9, 0x53, 0xF9, 0x2B, 0x82, 0xE9, 2}
DEFINE_PROPERTYKEY!{PKEY_Devices_WiFiDirectServices_ServiceConfigMethods,
    0x31B37743, 0x7C5E, 0x4005, 0x93, 0xE6, 0xE9, 0x53, 0xF9, 0x2B, 0x82, 0xE9, 6}
DEFINE_PROPERTYKEY!{PKEY_Devices_WiFiDirectServices_ServiceInformation,
    0x31B37743, 0x7C5E, 0x4005, 0x93, 0xE6, 0xE9, 0x53, 0xF9, 0x2B, 0x82, 0xE9, 4}
DEFINE_PROPERTYKEY!{PKEY_Devices_WiFiDirectServices_ServiceName,
    0x31B37743, 0x7C5E, 0x4005, 0x93, 0xE6, 0xE9, 0x53, 0xF9, 0x2B, 0x82, 0xE9, 3}
DEFINE_PROPERTYKEY!{PKEY_Devices_WinPhone8CameraFlags,
    0xB7B4D61C, 0x5A64, 0x4187, 0xA5, 0x2E, 0xB1, 0x53, 0x9F, 0x35, 0x90, 0x99, 2}
DEFINE_PROPERTYKEY!{PKEY_Devices_Wwan_InterfaceGuid,
    0xFF1167EB, 0xCBFC, 0x4341, 0xA5, 0x68, 0xA7, 0xC9, 0x1A, 0x68, 0x98, 0x2C, 2}
DEFINE_PROPERTYKEY!{PKEY_Storage_Portable,
    0x4D1EBEE8, 0x0803, 0x4774, 0x98, 0x42, 0xB7, 0x7D, 0xB5, 0x02, 0x65, 0xE9, 2}
DEFINE_PROPERTYKEY!{PKEY_Storage_RemovableMedia,
    0x4D1EBEE8, 0x0803, 0x4774, 0x98, 0x42, 0xB7, 0x7D, 0xB5, 0x02, 0x65, 0xE9, 3}
DEFINE_PROPERTYKEY!{PKEY_Storage_SystemCritical,
    0x4D1EBEE8, 0x0803, 0x4774, 0x98, 0x42, 0xB7, 0x7D, 0xB5, 0x02, 0x65, 0xE9, 4}
DEFINE_PROPERTYKEY!{PKEY_Document_ByteCount,
    0xD5CDD502, 0x2E9C, 0x101B, 0x93, 0x97, 0x08, 0x00, 0x2B, 0x2C, 0xF9, 0xAE, 4}
DEFINE_PROPERTYKEY!{PKEY_Document_CharacterCount,
    0xF29F85E0, 0x4FF9, 0x1068, 0xAB, 0x91, 0x08, 0x00, 0x2B, 0x27, 0xB3, 0xD9, 16}
DEFINE_PROPERTYKEY!{PKEY_Document_ClientID,
    0x276D7BB0, 0x5B34, 0x4FB0, 0xAA, 0x4B, 0x15, 0x8E, 0xD1, 0x2A, 0x18, 0x09, 100}
DEFINE_PROPERTYKEY!{PKEY_Document_Contributor,
    0xF334115E, 0xDA1B, 0x4509, 0x9B, 0x3D, 0x11, 0x95, 0x04, 0xDC, 0x7A, 0xBB, 100}
DEFINE_PROPERTYKEY!{PKEY_Document_DateCreated,
    0xF29F85E0, 0x4FF9, 0x1068, 0xAB, 0x91, 0x08, 0x00, 0x2B, 0x27, 0xB3, 0xD9, 12}
DEFINE_PROPERTYKEY!{PKEY_Document_DatePrinted,
    0xF29F85E0, 0x4FF9, 0x1068, 0xAB, 0x91, 0x08, 0x00, 0x2B, 0x27, 0xB3, 0xD9, 11}
DEFINE_PROPERTYKEY!{PKEY_Document_DateSaved,
    0xF29F85E0, 0x4FF9, 0x1068, 0xAB, 0x91, 0x08, 0x00, 0x2B, 0x27, 0xB3, 0xD9, 13}
DEFINE_PROPERTYKEY!{PKEY_Document_Division,
    0x1E005EE6, 0xBF27, 0x428B, 0xB0, 0x1C, 0x79, 0x67, 0x6A, 0xCD, 0x28, 0x70, 100}
DEFINE_PROPERTYKEY!{PKEY_Document_DocumentID,
    0xE08805C8, 0xE395, 0x40DF, 0x80, 0xD2, 0x54, 0xF0, 0xD6, 0xC4, 0x31, 0x54, 100}
DEFINE_PROPERTYKEY!{PKEY_Document_HiddenSlideCount,
    0xD5CDD502, 0x2E9C, 0x101B, 0x93, 0x97, 0x08, 0x00, 0x2B, 0x2C, 0xF9, 0xAE, 9}
DEFINE_PROPERTYKEY!{PKEY_Document_LastAuthor,
    0xF29F85E0, 0x4FF9, 0x1068, 0xAB, 0x91, 0x08, 0x00, 0x2B, 0x27, 0xB3, 0xD9, 8}
DEFINE_PROPERTYKEY!{PKEY_Document_LineCount,
    0xD5CDD502, 0x2E9C, 0x101B, 0x93, 0x97, 0x08, 0x00, 0x2B, 0x2C, 0xF9, 0xAE, 5}
DEFINE_PROPERTYKEY!{PKEY_Document_Manager,
    0xD5CDD502, 0x2E9C, 0x101B, 0x93, 0x97, 0x08, 0x00, 0x2B, 0x2C, 0xF9, 0xAE, 14}
DEFINE_PROPERTYKEY!{PKEY_Document_MultimediaClipCount,
    0xD5CDD502, 0x2E9C, 0x101B, 0x93, 0x97, 0x08, 0x00, 0x2B, 0x2C, 0xF9, 0xAE, 10}
DEFINE_PROPERTYKEY!{PKEY_Document_NoteCount,
    0xD5CDD502, 0x2E9C, 0x101B, 0x93, 0x97, 0x08, 0x00, 0x2B, 0x2C, 0xF9, 0xAE, 8}
DEFINE_PROPERTYKEY!{PKEY_Document_PageCount,
    0xF29F85E0, 0x4FF9, 0x1068, 0xAB, 0x91, 0x08, 0x00, 0x2B, 0x27, 0xB3, 0xD9, 14}
DEFINE_PROPERTYKEY!{PKEY_Document_ParagraphCount,
    0xD5CDD502, 0x2E9C, 0x101B, 0x93, 0x97, 0x08, 0x00, 0x2B, 0x2C, 0xF9, 0xAE, 6}
DEFINE_PROPERTYKEY!{PKEY_Document_PresentationFormat,
    0xD5CDD502, 0x2E9C, 0x101B, 0x93, 0x97, 0x08, 0x00, 0x2B, 0x2C, 0xF9, 0xAE, 3}
DEFINE_PROPERTYKEY!{PKEY_Document_RevisionNumber,
    0xF29F85E0, 0x4FF9, 0x1068, 0xAB, 0x91, 0x08, 0x00, 0x2B, 0x27, 0xB3, 0xD9, 9}
DEFINE_PROPERTYKEY!{PKEY_Document_Security,
    0xF29F85E0, 0x4FF9, 0x1068, 0xAB, 0x91, 0x08, 0x00, 0x2B, 0x27, 0xB3, 0xD9, 19}
DEFINE_PROPERTYKEY!{PKEY_Document_SlideCount,
    0xD5CDD502, 0x2E9C, 0x101B, 0x93, 0x97, 0x08, 0x00, 0x2B, 0x2C, 0xF9, 0xAE, 7}
DEFINE_PROPERTYKEY!{PKEY_Document_Template,
    0xF29F85E0, 0x4FF9, 0x1068, 0xAB, 0x91, 0x08, 0x00, 0x2B, 0x27, 0xB3, 0xD9, 7}
DEFINE_PROPERTYKEY!{PKEY_Document_TotalEditingTime,
    0xF29F85E0, 0x4FF9, 0x1068, 0xAB, 0x91, 0x08, 0x00, 0x2B, 0x27, 0xB3, 0xD9, 10}
DEFINE_PROPERTYKEY!{PKEY_Document_Version,
    0xD5CDD502, 0x2E9C, 0x101B, 0x93, 0x97, 0x08, 0x00, 0x2B, 0x2C, 0xF9, 0xAE, 29}
DEFINE_PROPERTYKEY!{PKEY_Document_WordCount,
    0xF29F85E0, 0x4FF9, 0x1068, 0xAB, 0x91, 0x08, 0x00, 0x2B, 0x27, 0xB3, 0xD9, 15}
DEFINE_PROPERTYKEY!{PKEY_DRM_DatePlayExpires,
    0xAEAC19E4, 0x89AE, 0x4508, 0xB9, 0xB7, 0xBB, 0x86, 0x7A, 0xBE, 0xE2, 0xED, 6}
DEFINE_PROPERTYKEY!{PKEY_DRM_DatePlayStarts,
    0xAEAC19E4, 0x89AE, 0x4508, 0xB9, 0xB7, 0xBB, 0x86, 0x7A, 0xBE, 0xE2, 0xED, 5}
DEFINE_PROPERTYKEY!{PKEY_DRM_Description,
    0xAEAC19E4, 0x89AE, 0x4508, 0xB9, 0xB7, 0xBB, 0x86, 0x7A, 0xBE, 0xE2, 0xED, 3}
DEFINE_PROPERTYKEY!{PKEY_DRM_IsDisabled,
    0xAEAC19E4, 0x89AE, 0x4508, 0xB9, 0xB7, 0xBB, 0x86, 0x7A, 0xBE, 0xE2, 0xED, 7}
DEFINE_PROPERTYKEY!{PKEY_DRM_IsProtected,
    0xAEAC19E4, 0x89AE, 0x4508, 0xB9, 0xB7, 0xBB, 0x86, 0x7A, 0xBE, 0xE2, 0xED, 2}
DEFINE_PROPERTYKEY!{PKEY_DRM_PlayCount,
    0xAEAC19E4, 0x89AE, 0x4508, 0xB9, 0xB7, 0xBB, 0x86, 0x7A, 0xBE, 0xE2, 0xED, 4}
DEFINE_PROPERTYKEY!{PKEY_GPS_Altitude,
    0x827EDB4F, 0x5B73, 0x44A7, 0x89, 0x1D, 0xFD, 0xFF, 0xAB, 0xEA, 0x35, 0xCA, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_AltitudeDenominator,
    0x78342DCB, 0xE358, 0x4145, 0xAE, 0x9A, 0x6B, 0xFE, 0x4E, 0x0F, 0x9F, 0x51, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_AltitudeNumerator,
    0x2DAD1EB7, 0x816D, 0x40D3, 0x9E, 0xC3, 0xC9, 0x77, 0x3B, 0xE2, 0xAA, 0xDE, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_AltitudeRef,
    0x46AC629D, 0x75EA, 0x4515, 0x86, 0x7F, 0x6D, 0xC4, 0x32, 0x1C, 0x58, 0x44, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_AreaInformation,
    0x972E333E, 0xAC7E, 0x49F1, 0x8A, 0xDF, 0xA7, 0x0D, 0x07, 0xA9, 0xBC, 0xAB, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_Date,
    0x3602C812, 0x0F3B, 0x45F0, 0x85, 0xAD, 0x60, 0x34, 0x68, 0xD6, 0x94, 0x23, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_DestBearing,
    0xC66D4B3C, 0xE888, 0x47CC, 0xB9, 0x9F, 0x9D, 0xCA, 0x3E, 0xE3, 0x4D, 0xEA, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_DestBearingDenominator,
    0x7ABCF4F8, 0x7C3F, 0x4988, 0xAC, 0x91, 0x8D, 0x2C, 0x2E, 0x97, 0xEC, 0xA5, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_DestBearingNumerator,
    0xBA3B1DA9, 0x86EE, 0x4B5D, 0xA2, 0xA4, 0xA2, 0x71, 0xA4, 0x29, 0xF0, 0xCF, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_DestBearingRef,
    0x9AB84393, 0x2A0F, 0x4B75, 0xBB, 0x22, 0x72, 0x79, 0x78, 0x69, 0x77, 0xCB, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_DestDistance,
    0xA93EAE04, 0x6804, 0x4F24, 0xAC, 0x81, 0x09, 0xB2, 0x66, 0x45, 0x21, 0x18, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_DestDistanceDenominator,
    0x9BC2C99B, 0xAC71, 0x4127, 0x9D, 0x1C, 0x25, 0x96, 0xD0, 0xD7, 0xDC, 0xB7, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_DestDistanceNumerator,
    0x2BDA47DA, 0x08C6, 0x4FE1, 0x80, 0xBC, 0xA7, 0x2F, 0xC5, 0x17, 0xC5, 0xD0, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_DestDistanceRef,
    0xED4DF2D3, 0x8695, 0x450B, 0x85, 0x6F, 0xF5, 0xC1, 0xC5, 0x3A, 0xCB, 0x66, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_DestLatitude,
    0x9D1D7CC5, 0x5C39, 0x451C, 0x86, 0xB3, 0x92, 0x8E, 0x2D, 0x18, 0xCC, 0x47, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_DestLatitudeDenominator,
    0x3A372292, 0x7FCA, 0x49A7, 0x99, 0xD5, 0xE4, 0x7B, 0xB2, 0xD4, 0xE7, 0xAB, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_DestLatitudeNumerator,
    0xECF4B6F6, 0xD5A6, 0x433C, 0xBB, 0x92, 0x40, 0x76, 0x65, 0x0F, 0xC8, 0x90, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_DestLatitudeRef,
    0xCEA820B9, 0xCE61, 0x4885, 0xA1, 0x28, 0x00, 0x5D, 0x90, 0x87, 0xC1, 0x92, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_DestLongitude,
    0x47A96261, 0xCB4C, 0x4807, 0x8A, 0xD3, 0x40, 0xB9, 0xD9, 0xDB, 0xC6, 0xBC, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_DestLongitudeDenominator,
    0x425D69E5, 0x48AD, 0x4900, 0x8D, 0x80, 0x6E, 0xB6, 0xB8, 0xD0, 0xAC, 0x86, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_DestLongitudeNumerator,
    0xA3250282, 0xFB6D, 0x48D5, 0x9A, 0x89, 0xDB, 0xCA, 0xCE, 0x75, 0xCC, 0xCF, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_DestLongitudeRef,
    0x182C1EA6, 0x7C1C, 0x4083, 0xAB, 0x4B, 0xAC, 0x6C, 0x9F, 0x4E, 0xD1, 0x28, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_Differential,
    0xAAF4EE25, 0xBD3B, 0x4DD7, 0xBF, 0xC4, 0x47, 0xF7, 0x7B, 0xB0, 0x0F, 0x6D, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_DOP,
    0x0CF8FB02, 0x1837, 0x42F1, 0xA6, 0x97, 0xA7, 0x01, 0x7A, 0xA2, 0x89, 0xB9, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_DOPDenominator,
    0xA0BE94C5, 0x50BA, 0x487B, 0xBD, 0x35, 0x06, 0x54, 0xBE, 0x88, 0x81, 0xED, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_DOPNumerator,
    0x47166B16, 0x364F, 0x4AA0, 0x9F, 0x31, 0xE2, 0xAB, 0x3D, 0xF4, 0x49, 0xC3, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_ImgDirection,
    0x16473C91, 0xD017, 0x4ED9, 0xBA, 0x4D, 0xB6, 0xBA, 0xA5, 0x5D, 0xBC, 0xF8, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_ImgDirectionDenominator,
    0x10B24595, 0x41A2, 0x4E20, 0x93, 0xC2, 0x57, 0x61, 0xC1, 0x39, 0x5F, 0x32, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_ImgDirectionNumerator,
    0xDC5877C7, 0x225F, 0x45F7, 0xBA, 0xC7, 0xE8, 0x13, 0x34, 0xB6, 0x13, 0x0A, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_ImgDirectionRef,
    0xA4AAA5B7, 0x1AD0, 0x445F, 0x81, 0x1A, 0x0F, 0x8F, 0x6E, 0x67, 0xF6, 0xB5, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_Latitude,
    0x8727CFFF, 0x4868, 0x4EC6, 0xAD, 0x5B, 0x81, 0xB9, 0x85, 0x21, 0xD1, 0xAB, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_LatitudeDecimal,
    0x0F55CDE2, 0x4F49, 0x450D, 0x92, 0xC1, 0xDC, 0xD1, 0x63, 0x01, 0xB1, 0xB7, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_LatitudeDenominator,
    0x16E634EE, 0x2BFF, 0x497B, 0xBD, 0x8A, 0x43, 0x41, 0xAD, 0x39, 0xEE, 0xB9, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_LatitudeNumerator,
    0x7DDAAAD1, 0xCCC8, 0x41AE, 0xB7, 0x50, 0xB2, 0xCB, 0x80, 0x31, 0xAE, 0xA2, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_LatitudeRef,
    0x029C0252, 0x5B86, 0x46C7, 0xAC, 0xA0, 0x27, 0x69, 0xFF, 0xC8, 0xE3, 0xD4, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_Longitude,
    0xC4C4DBB2, 0xB593, 0x466B, 0xBB, 0xDA, 0xD0, 0x3D, 0x27, 0xD5, 0xE4, 0x3A, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_LongitudeDecimal,
    0x4679C1B5, 0x844D, 0x4590, 0xBA, 0xF5, 0xF3, 0x22, 0x23, 0x1F, 0x1B, 0x81, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_LongitudeDenominator,
    0xBE6E176C, 0x4534, 0x4D2C, 0xAC, 0xE5, 0x31, 0xDE, 0xDA, 0xC1, 0x60, 0x6B, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_LongitudeNumerator,
    0x02B0F689, 0xA914, 0x4E45, 0x82, 0x1D, 0x1D, 0xDA, 0x45, 0x2E, 0xD2, 0xC4, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_LongitudeRef,
    0x33DCF22B, 0x28D5, 0x464C, 0x80, 0x35, 0x1E, 0xE9, 0xEF, 0xD2, 0x52, 0x78, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_MapDatum,
    0x2CA2DAE6, 0xEDDC, 0x407D, 0xBE, 0xF1, 0x77, 0x39, 0x42, 0xAB, 0xFA, 0x95, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_MeasureMode,
    0xA015ED5D, 0xAAEA, 0x4D58, 0x8A, 0x86, 0x3C, 0x58, 0x69, 0x20, 0xEA, 0x0B, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_ProcessingMethod,
    0x59D49E61, 0x840F, 0x4AA9, 0xA9, 0x39, 0xE2, 0x09, 0x9B, 0x7F, 0x63, 0x99, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_Satellites,
    0x467EE575, 0x1F25, 0x4557, 0xAD, 0x4E, 0xB8, 0xB5, 0x8B, 0x0D, 0x9C, 0x15, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_Speed,
    0xDA5D0862, 0x6E76, 0x4E1B, 0xBA, 0xBD, 0x70, 0x02, 0x1B, 0xD2, 0x54, 0x94, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_SpeedDenominator,
    0x7D122D5A, 0xAE5E, 0x4335, 0x88, 0x41, 0xD7, 0x1E, 0x7C, 0xE7, 0x2F, 0x53, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_SpeedNumerator,
    0xACC9CE3D, 0xC213, 0x4942, 0x8B, 0x48, 0x6D, 0x08, 0x20, 0xF2, 0x1C, 0x6D, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_SpeedRef,
    0xECF7F4C9, 0x544F, 0x4D6D, 0x9D, 0x98, 0x8A, 0xD7, 0x9A, 0xDA, 0xF4, 0x53, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_Status,
    0x125491F4, 0x818F, 0x46B2, 0x91, 0xB5, 0xD5, 0x37, 0x75, 0x36, 0x17, 0xB2, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_Track,
    0x76C09943, 0x7C33, 0x49E3, 0x9E, 0x7E, 0xCD, 0xBA, 0x87, 0x2C, 0xFA, 0xDA, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_TrackDenominator,
    0xC8D1920C, 0x01F6, 0x40C0, 0xAC, 0x86, 0x2F, 0x3A, 0x4A, 0xD0, 0x07, 0x70, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_TrackNumerator,
    0x702926F4, 0x44A6, 0x43E1, 0xAE, 0x71, 0x45, 0x62, 0x71, 0x16, 0x89, 0x3B, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_TrackRef,
    0x35DBE6FE, 0x44C3, 0x4400, 0xAA, 0xAE, 0xD2, 0xC7, 0x99, 0xC4, 0x07, 0xE8, 100}
DEFINE_PROPERTYKEY!{PKEY_GPS_VersionID,
    0x22704DA4, 0xC6B2, 0x4A99, 0x8E, 0x56, 0xF1, 0x6D, 0xF8, 0xC9, 0x25, 0x99, 100}
DEFINE_PROPERTYKEY!{PKEY_History_VisitCount,
    0x5CBF2787, 0x48CF, 0x4208, 0xB9, 0x0E, 0xEE, 0x5E, 0x5D, 0x42, 0x02, 0x94, 7}
DEFINE_PROPERTYKEY!{PKEY_Image_BitDepth,
    0x6444048F, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 7}
DEFINE_PROPERTYKEY!{PKEY_Image_ColorSpace,
    0x14B81DA1, 0x0135, 0x4D31, 0x96, 0xD9, 0x6C, 0xBF, 0xC9, 0x67, 0x1A, 0x99, 40961}
pub const IMAGE_COLORSPACE_SRGB: DWORD = 1;
pub const IMAGE_COLORSPACE_UNCALIBRATED: DWORD = 0xFFFF;
DEFINE_PROPERTYKEY!{PKEY_Image_CompressedBitsPerPixel,
    0x364B6FA9, 0x37AB, 0x482A, 0xBE, 0x2B, 0xAE, 0x02, 0xF6, 0x0D, 0x43, 0x18, 100}
DEFINE_PROPERTYKEY!{PKEY_Image_CompressedBitsPerPixelDenominator,
    0x1F8844E1, 0x24AD, 0x4508, 0x9D, 0xFD, 0x53, 0x26, 0xA4, 0x15, 0xCE, 0x02, 100}
DEFINE_PROPERTYKEY!{PKEY_Image_CompressedBitsPerPixelNumerator,
    0xD21A7148, 0xD32C, 0x4624, 0x89, 0x00, 0x27, 0x72, 0x10, 0xF7, 0x9C, 0x0F, 100}
DEFINE_PROPERTYKEY!{PKEY_Image_Compression,
    0x14B81DA1, 0x0135, 0x4D31, 0x96, 0xD9, 0x6C, 0xBF, 0xC9, 0x67, 0x1A, 0x99, 259}
pub const IMAGE_COMPRESSION_UNCOMPRESSED: DWORD = 1;
pub const IMAGE_COMPRESSION_CCITT_T3: DWORD = 2;
pub const IMAGE_COMPRESSION_CCITT_T4: DWORD = 3;
pub const IMAGE_COMPRESSION_CCITT_T6: DWORD = 4;
pub const IMAGE_COMPRESSION_LZW: DWORD = 5;
pub const IMAGE_COMPRESSION_JPEG: DWORD = 6;
pub const IMAGE_COMPRESSION_PACKBITS: DWORD = 32773;
DEFINE_PROPERTYKEY!{PKEY_Image_CompressionText,
    0x3F08E66F, 0x2F44, 0x4BB9, 0xA6, 0x82, 0xAC, 0x35, 0xD2, 0x56, 0x23, 0x22, 100}
DEFINE_PROPERTYKEY!{PKEY_Image_Dimensions,
    0x6444048F, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 13}
DEFINE_PROPERTYKEY!{PKEY_Image_HorizontalResolution,
    0x6444048F, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 5}
DEFINE_PROPERTYKEY!{PKEY_Image_HorizontalSize,
    0x6444048F, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 3}
DEFINE_PROPERTYKEY!{PKEY_Image_ImageID,
    0x10DABE05, 0x32AA, 0x4C29, 0xBF, 0x1A, 0x63, 0xE2, 0xD2, 0x20, 0x58, 0x7F, 100}
DEFINE_PROPERTYKEY!{PKEY_Image_ResolutionUnit,
    0x19B51FA6, 0x1F92, 0x4A5C, 0xAB, 0x48, 0x7D, 0xF0, 0xAB, 0xD6, 0x74, 0x44, 100}
DEFINE_PROPERTYKEY!{PKEY_Image_VerticalResolution,
    0x6444048F, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 6}
DEFINE_PROPERTYKEY!{PKEY_Image_VerticalSize,
    0x6444048F, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 4}
DEFINE_PROPERTYKEY!{PKEY_Journal_Contacts,
    0xDEA7C82C, 0x1D89, 0x4A66, 0x94, 0x27, 0xA4, 0xE3, 0xDE, 0xBA, 0xBC, 0xB1, 100}
DEFINE_PROPERTYKEY!{PKEY_Journal_EntryType,
    0x95BEB1FC, 0x326D, 0x4644, 0xB3, 0x96, 0xCD, 0x3E, 0xD9, 0x0E, 0x6D, 0xDF, 100}
DEFINE_PROPERTYKEY!{PKEY_LayoutPattern_ContentViewModeForBrowse,
    0xC9944A21, 0xA406, 0x48FE, 0x82, 0x25, 0xAE, 0xC7, 0xE2, 0x4C, 0x21, 0x1B, 500}
pub const LAYOUTPATTERN_CVMFB_ALPHA: &'static str = "alpha";
pub const LAYOUTPATTERN_CVMFB_BETA: &'static str = "beta";
pub const LAYOUTPATTERN_CVMFB_GAMMA: &'static str = "gamma";
pub const LAYOUTPATTERN_CVMFB_DELTA: &'static str = "delta";
DEFINE_PROPERTYKEY!{PKEY_LayoutPattern_ContentViewModeForSearch,
    0xC9944A21, 0xA406, 0x48FE, 0x82, 0x25, 0xAE, 0xC7, 0xE2, 0x4C, 0x21, 0x1B, 501}
pub const LAYOUTPATTERN_CVMFS_ALPHA: &'static str = "alpha";
pub const LAYOUTPATTERN_CVMFS_BETA: &'static str = "beta";
pub const LAYOUTPATTERN_CVMFS_GAMMA: &'static str = "gamma";
pub const LAYOUTPATTERN_CVMFS_DELTA: &'static str = "delta";
DEFINE_PROPERTYKEY!{PKEY_History_SelectionCount,
    0x1CE0D6BC, 0x536C, 0x4600, 0xB0, 0xDD, 0x7E, 0x0C, 0x66, 0xB3, 0x50, 0xD5, 8}
DEFINE_PROPERTYKEY!{PKEY_History_TargetUrlHostName,
    0x1CE0D6BC, 0x536C, 0x4600, 0xB0, 0xDD, 0x7E, 0x0C, 0x66, 0xB3, 0x50, 0xD5, 9}
DEFINE_PROPERTYKEY!{PKEY_Link_Arguments,
    0x436F2667, 0x14E2, 0x4FEB, 0xB3, 0x0A, 0x14, 0x6C, 0x53, 0xB5, 0xB6, 0x74, 100}
DEFINE_PROPERTYKEY!{PKEY_Link_Comment,
    0xB9B4B3FC, 0x2B51, 0x4A42, 0xB5, 0xD8, 0x32, 0x41, 0x46, 0xAF, 0xCF, 0x25, 5}
DEFINE_PROPERTYKEY!{PKEY_Link_DateVisited,
    0x5CBF2787, 0x48CF, 0x4208, 0xB9, 0x0E, 0xEE, 0x5E, 0x5D, 0x42, 0x02, 0x94, 23}
DEFINE_PROPERTYKEY!{PKEY_Link_Description,
    0x5CBF2787, 0x48CF, 0x4208, 0xB9, 0x0E, 0xEE, 0x5E, 0x5D, 0x42, 0x02, 0x94, 21}
DEFINE_PROPERTYKEY!{PKEY_Link_FeedItemLocalId,
    0x8A2F99F9, 0x3C37, 0x465D, 0xA8, 0xD7, 0x69, 0x77, 0x7A, 0x24, 0x6D, 0x0C, 2}
DEFINE_PROPERTYKEY!{PKEY_Link_Status,
    0xB9B4B3FC, 0x2B51, 0x4A42, 0xB5, 0xD8, 0x32, 0x41, 0x46, 0xAF, 0xCF, 0x25, 3}
pub const LINK_STATUS_RESOLVED: LONG = 1;
pub const LINK_STATUS_BROKEN: LONG = 2;
DEFINE_PROPERTYKEY!{PKEY_Link_TargetExtension,
    0x7A7D76F4, 0xB630, 0x4BD7, 0x95, 0xFF, 0x37, 0xCC, 0x51, 0xA9, 0x75, 0xC9, 2}
DEFINE_PROPERTYKEY!{PKEY_Link_TargetParsingPath,
    0xB9B4B3FC, 0x2B51, 0x4A42, 0xB5, 0xD8, 0x32, 0x41, 0x46, 0xAF, 0xCF, 0x25, 2}
DEFINE_PROPERTYKEY!{PKEY_Link_TargetSFGAOFlags,
    0xB9B4B3FC, 0x2B51, 0x4A42, 0xB5, 0xD8, 0x32, 0x41, 0x46, 0xAF, 0xCF, 0x25, 8}
DEFINE_PROPERTYKEY!{PKEY_Link_TargetUrlHostName,
    0x8A2F99F9, 0x3C37, 0x465D, 0xA8, 0xD7, 0x69, 0x77, 0x7A, 0x24, 0x6D, 0x0C, 5}
DEFINE_PROPERTYKEY!{PKEY_Link_TargetUrlPath,
    0x8A2F99F9, 0x3C37, 0x465D, 0xA8, 0xD7, 0x69, 0x77, 0x7A, 0x24, 0x6D, 0x0C, 6}
DEFINE_PROPERTYKEY!{PKEY_Media_AuthorUrl,
    0x64440492, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 32}
DEFINE_PROPERTYKEY!{PKEY_Media_AverageLevel,
    0x09EDD5B6, 0xB301, 0x43C5, 0x99, 0x90, 0xD0, 0x03, 0x02, 0xEF, 0xFD, 0x46, 100}
DEFINE_PROPERTYKEY!{PKEY_Media_ClassPrimaryID,
    0x64440492, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 13}
DEFINE_PROPERTYKEY!{PKEY_Media_ClassSecondaryID,
    0x64440492, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 14}
DEFINE_PROPERTYKEY!{PKEY_Media_CollectionGroupID,
    0x64440492, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 24}
DEFINE_PROPERTYKEY!{PKEY_Media_CollectionID,
    0x64440492, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 25}
DEFINE_PROPERTYKEY!{PKEY_Media_ContentDistributor,
    0x64440492, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 18}
DEFINE_PROPERTYKEY!{PKEY_Media_ContentID,
    0x64440492, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 26}
DEFINE_PROPERTYKEY!{PKEY_Media_CreatorApplication,
    0x64440492, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 27}
DEFINE_PROPERTYKEY!{PKEY_Media_CreatorApplicationVersion,
    0x64440492, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 28}
DEFINE_PROPERTYKEY!{PKEY_Media_DateEncoded,
    0x2E4B640D, 0x5019, 0x46D8, 0x88, 0x81, 0x55, 0x41, 0x4C, 0xC5, 0xCA, 0xA0, 100}
DEFINE_PROPERTYKEY!{PKEY_Media_DateReleased,
    0xDE41CC29, 0x6971, 0x4290, 0xB4, 0x72, 0xF5, 0x9F, 0x2E, 0x2F, 0x31, 0xE2, 100}
DEFINE_PROPERTYKEY!{PKEY_Media_DlnaProfileID,
    0xCFA31B45, 0x525D, 0x4998, 0xBB, 0x44, 0x3F, 0x7D, 0x81, 0x54, 0x2F, 0xA4, 100}
DEFINE_PROPERTYKEY!{PKEY_Media_Duration,
    0x64440490, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 3}
DEFINE_PROPERTYKEY!{PKEY_Media_DVDID,
    0x64440492, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 15}
DEFINE_PROPERTYKEY!{PKEY_Media_EncodedBy,
    0x64440492, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 36}
DEFINE_PROPERTYKEY!{PKEY_Media_EncodingSettings,
    0x64440492, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 37}
DEFINE_PROPERTYKEY!{PKEY_Media_EpisodeNumber,
    0x64440492, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 100}
DEFINE_PROPERTYKEY!{PKEY_Media_FrameCount,
    0x6444048F, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 12}
DEFINE_PROPERTYKEY!{PKEY_Media_MCDI,
    0x64440492, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 16}
DEFINE_PROPERTYKEY!{PKEY_Media_MetadataContentProvider,
    0x64440492, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 17}
DEFINE_PROPERTYKEY!{PKEY_Media_Producer,
    0x64440492, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 22}
DEFINE_PROPERTYKEY!{PKEY_Media_PromotionUrl,
    0x64440492, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 33}
DEFINE_PROPERTYKEY!{PKEY_Media_ProtectionType,
    0x64440492, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 38}
DEFINE_PROPERTYKEY!{PKEY_Media_ProviderRating,
    0x64440492, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 39}
DEFINE_PROPERTYKEY!{PKEY_Media_ProviderStyle,
    0x64440492, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 40}
DEFINE_PROPERTYKEY!{PKEY_Media_Publisher,
    0x64440492, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 30}
DEFINE_PROPERTYKEY!{PKEY_Media_SeasonNumber,
    0x64440492, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 101}
DEFINE_PROPERTYKEY!{PKEY_Media_SeriesName,
    0x64440492, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 42}
DEFINE_PROPERTYKEY!{PKEY_Media_SubscriptionContentId,
    0x9AEBAE7A, 0x9644, 0x487D, 0xA9, 0x2C, 0x65, 0x75, 0x85, 0xED, 0x75, 0x1A, 100}
DEFINE_PROPERTYKEY!{PKEY_Media_SubTitle,
    0x56A3372E, 0xCE9C, 0x11D2, 0x9F, 0x0E, 0x00, 0x60, 0x97, 0xC6, 0x86, 0xF6, 38}
DEFINE_PROPERTYKEY!{PKEY_Media_ThumbnailLargePath,
    0x64440492, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 47}
DEFINE_PROPERTYKEY!{PKEY_Media_ThumbnailLargeUri,
    0x64440492, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 48}
DEFINE_PROPERTYKEY!{PKEY_Media_ThumbnailSmallPath,
    0x64440492, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 49}
DEFINE_PROPERTYKEY!{PKEY_Media_ThumbnailSmallUri,
    0x64440492, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 50}
DEFINE_PROPERTYKEY!{PKEY_Media_UniqueFileIdentifier,
    0x64440492, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 35}
DEFINE_PROPERTYKEY!{PKEY_Media_UserNoAutoInfo,
    0x64440492, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 41}
DEFINE_PROPERTYKEY!{PKEY_Media_UserWebUrl,
    0x64440492, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 34}
DEFINE_PROPERTYKEY!{PKEY_Media_Writer,
    0x64440492, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 23}
DEFINE_PROPERTYKEY!{PKEY_Media_Year,
    0x56A3372E, 0xCE9C, 0x11D2, 0x9F, 0x0E, 0x00, 0x60, 0x97, 0xC6, 0x86, 0xF6, 5}
DEFINE_PROPERTYKEY!{PKEY_Message_AttachmentContents,
    0x3143BF7C, 0x80A8, 0x4854, 0x88, 0x80, 0xE2, 0xE4, 0x01, 0x89, 0xBD, 0xD0, 100}
DEFINE_PROPERTYKEY!{PKEY_Message_AttachmentNames,
    0xE3E0584C, 0xB788, 0x4A5A, 0xBB, 0x20, 0x7F, 0x5A, 0x44, 0xC9, 0xAC, 0xDD, 21}
DEFINE_PROPERTYKEY!{PKEY_Message_BccAddress,
    0xE3E0584C, 0xB788, 0x4A5A, 0xBB, 0x20, 0x7F, 0x5A, 0x44, 0xC9, 0xAC, 0xDD, 2}
DEFINE_PROPERTYKEY!{PKEY_Message_BccName,
    0xE3E0584C, 0xB788, 0x4A5A, 0xBB, 0x20, 0x7F, 0x5A, 0x44, 0xC9, 0xAC, 0xDD, 3}
DEFINE_PROPERTYKEY!{PKEY_Message_CcAddress,
    0xE3E0584C, 0xB788, 0x4A5A, 0xBB, 0x20, 0x7F, 0x5A, 0x44, 0xC9, 0xAC, 0xDD, 4}
DEFINE_PROPERTYKEY!{PKEY_Message_CcName,
    0xE3E0584C, 0xB788, 0x4A5A, 0xBB, 0x20, 0x7F, 0x5A, 0x44, 0xC9, 0xAC, 0xDD, 5}
DEFINE_PROPERTYKEY!{PKEY_Message_ConversationID,
    0xDC8F80BD, 0xAF1E, 0x4289, 0x85, 0xB6, 0x3D, 0xFC, 0x1B, 0x49, 0x39, 0x92, 100}
DEFINE_PROPERTYKEY!{PKEY_Message_ConversationIndex,
    0xDC8F80BD, 0xAF1E, 0x4289, 0x85, 0xB6, 0x3D, 0xFC, 0x1B, 0x49, 0x39, 0x92, 101}
DEFINE_PROPERTYKEY!{PKEY_Message_DateReceived,
    0xE3E0584C, 0xB788, 0x4A5A, 0xBB, 0x20, 0x7F, 0x5A, 0x44, 0xC9, 0xAC, 0xDD, 20}
DEFINE_PROPERTYKEY!{PKEY_Message_DateSent,
    0xE3E0584C, 0xB788, 0x4A5A, 0xBB, 0x20, 0x7F, 0x5A, 0x44, 0xC9, 0xAC, 0xDD, 19}
DEFINE_PROPERTYKEY!{PKEY_Message_Flags,
    0xA82D9EE7, 0xCA67, 0x4312, 0x96, 0x5E, 0x22, 0x6B, 0xCE, 0xA8, 0x50, 0x23, 100}
DEFINE_PROPERTYKEY!{PKEY_Message_FromAddress,
    0xE3E0584C, 0xB788, 0x4A5A, 0xBB, 0x20, 0x7F, 0x5A, 0x44, 0xC9, 0xAC, 0xDD, 13}
DEFINE_PROPERTYKEY!{PKEY_Message_FromName,
    0xE3E0584C, 0xB788, 0x4A5A, 0xBB, 0x20, 0x7F, 0x5A, 0x44, 0xC9, 0xAC, 0xDD, 14}
DEFINE_PROPERTYKEY!{PKEY_Message_HasAttachments,
    0x9C1FCF74, 0x2D97, 0x41BA, 0xB4, 0xAE, 0xCB, 0x2E, 0x36, 0x61, 0xA6, 0xE4, 8}
DEFINE_PROPERTYKEY!{PKEY_Message_IsFwdOrReply,
    0x9A9BC088, 0x4F6D, 0x469E, 0x99, 0x19, 0xE7, 0x05, 0x41, 0x20, 0x40, 0xF9, 100}
DEFINE_PROPERTYKEY!{PKEY_Message_MessageClass,
    0xCD9ED458, 0x08CE, 0x418F, 0xA7, 0x0E, 0xF9, 0x12, 0xC7, 0xBB, 0x9C, 0x5C, 103}
DEFINE_PROPERTYKEY!{PKEY_Message_Participants,
    0x1A9BA605, 0x8E7C, 0x4D11, 0xAD, 0x7D, 0xA5, 0x0A, 0xDA, 0x18, 0xBA, 0x1B, 2}
DEFINE_PROPERTYKEY!{PKEY_Message_ProofInProgress,
    0x9098F33C, 0x9A7D, 0x48A8, 0x8D, 0xE5, 0x2E, 0x12, 0x27, 0xA6, 0x4E, 0x91, 100}
DEFINE_PROPERTYKEY!{PKEY_Message_SenderAddress,
    0x0BE1C8E7, 0x1981, 0x4676, 0xAE, 0x14, 0xFD, 0xD7, 0x8F, 0x05, 0xA6, 0xE7, 100}
DEFINE_PROPERTYKEY!{PKEY_Message_SenderName,
    0x0DA41CFA, 0xD224, 0x4A18, 0xAE, 0x2F, 0x59, 0x61, 0x58, 0xDB, 0x4B, 0x3A, 100}
DEFINE_PROPERTYKEY!{PKEY_Message_Store,
    0xE3E0584C, 0xB788, 0x4A5A, 0xBB, 0x20, 0x7F, 0x5A, 0x44, 0xC9, 0xAC, 0xDD, 15}
DEFINE_PROPERTYKEY!{PKEY_Message_ToAddress,
    0xE3E0584C, 0xB788, 0x4A5A, 0xBB, 0x20, 0x7F, 0x5A, 0x44, 0xC9, 0xAC, 0xDD, 16}
DEFINE_PROPERTYKEY!{PKEY_Message_ToDoFlags,
    0x1F856A9F, 0x6900, 0x4ABA, 0x95, 0x05, 0x2D, 0x5F, 0x1B, 0x4D, 0x66, 0xCB, 100}
DEFINE_PROPERTYKEY!{PKEY_Message_ToDoTitle,
    0xBCCC8A3C, 0x8CEF, 0x42E5, 0x9B, 0x1C, 0xC6, 0x90, 0x79, 0x39, 0x8B, 0xC7, 100}
DEFINE_PROPERTYKEY!{PKEY_Message_ToName,
    0xE3E0584C, 0xB788, 0x4A5A, 0xBB, 0x20, 0x7F, 0x5A, 0x44, 0xC9, 0xAC, 0xDD, 17}
DEFINE_PROPERTYKEY!{PKEY_Music_AlbumArtist,
    0x56A3372E, 0xCE9C, 0x11D2, 0x9F, 0x0E, 0x00, 0x60, 0x97, 0xC6, 0x86, 0xF6, 13}
DEFINE_PROPERTYKEY!{PKEY_Music_AlbumArtistSortOverride,
    0xF1FDB4AF, 0xF78C, 0x466C, 0xBB, 0x05, 0x56, 0xE9, 0x2D, 0xB0, 0xB8, 0xEC, 103}
DEFINE_PROPERTYKEY!{PKEY_Music_AlbumID,
    0x56A3372E, 0xCE9C, 0x11D2, 0x9F, 0x0E, 0x00, 0x60, 0x97, 0xC6, 0x86, 0xF6, 100}
DEFINE_PROPERTYKEY!{PKEY_Music_AlbumTitle,
    0x56A3372E, 0xCE9C, 0x11D2, 0x9F, 0x0E, 0x00, 0x60, 0x97, 0xC6, 0x86, 0xF6, 4}
DEFINE_PROPERTYKEY!{PKEY_Music_AlbumTitleSortOverride,
    0x13EB7FFC, 0xEC89, 0x4346, 0xB1, 0x9D, 0xCC, 0xC6, 0xF1, 0x78, 0x42, 0x23, 101}
DEFINE_PROPERTYKEY!{PKEY_Music_Artist,
    0x56A3372E, 0xCE9C, 0x11D2, 0x9F, 0x0E, 0x00, 0x60, 0x97, 0xC6, 0x86, 0xF6, 2}
DEFINE_PROPERTYKEY!{PKEY_Music_ArtistSortOverride,
    0xDEEB2DB5, 0x0696, 0x4CE0, 0x94, 0xFE, 0xA0, 0x1F, 0x77, 0xA4, 0x5F, 0xB5, 102}
DEFINE_PROPERTYKEY!{PKEY_Music_BeatsPerMinute,
    0x56A3372E, 0xCE9C, 0x11D2, 0x9F, 0x0E, 0x00, 0x60, 0x97, 0xC6, 0x86, 0xF6, 35}
DEFINE_PROPERTYKEY!{PKEY_Music_Composer,
    0x64440492, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 19}
DEFINE_PROPERTYKEY!{PKEY_Music_ComposerSortOverride,
    0x00BC20A3, 0xBD48, 0x4085, 0x87, 0x2C, 0xA8, 0x8D, 0x77, 0xF5, 0x09, 0x7E, 105}
DEFINE_PROPERTYKEY!{PKEY_Music_Conductor,
    0x56A3372E, 0xCE9C, 0x11D2, 0x9F, 0x0E, 0x00, 0x60, 0x97, 0xC6, 0x86, 0xF6, 36}
DEFINE_PROPERTYKEY!{PKEY_Music_ContentGroupDescription,
    0x56A3372E, 0xCE9C, 0x11D2, 0x9F, 0x0E, 0x00, 0x60, 0x97, 0xC6, 0x86, 0xF6, 33}
DEFINE_PROPERTYKEY!{PKEY_Music_DiscNumber,
    0x6AFE7437, 0x9BCD, 0x49C7, 0x80, 0xFE, 0x4A, 0x5C, 0x65, 0xFA, 0x58, 0x74, 104}
DEFINE_PROPERTYKEY!{PKEY_Music_DisplayArtist,
    0xFD122953, 0xFA93, 0x4EF7, 0x92, 0xC3, 0x04, 0xC9, 0x46, 0xB2, 0xF7, 0xC8, 100}
DEFINE_PROPERTYKEY!{PKEY_Music_Genre,
    0x56A3372E, 0xCE9C, 0x11D2, 0x9F, 0x0E, 0x00, 0x60, 0x97, 0xC6, 0x86, 0xF6, 11}
DEFINE_PROPERTYKEY!{PKEY_Music_InitialKey,
    0x56A3372E, 0xCE9C, 0x11D2, 0x9F, 0x0E, 0x00, 0x60, 0x97, 0xC6, 0x86, 0xF6, 34}
DEFINE_PROPERTYKEY!{PKEY_Music_IsCompilation,
    0xC449D5CB, 0x9EA4, 0x4809, 0x82, 0xE8, 0xAF, 0x9D, 0x59, 0xDE, 0xD6, 0xD1, 100}
DEFINE_PROPERTYKEY!{PKEY_Music_Lyrics,
    0x56A3372E, 0xCE9C, 0x11D2, 0x9F, 0x0E, 0x00, 0x60, 0x97, 0xC6, 0x86, 0xF6, 12}
DEFINE_PROPERTYKEY!{PKEY_Music_Mood,
    0x56A3372E, 0xCE9C, 0x11D2, 0x9F, 0x0E, 0x00, 0x60, 0x97, 0xC6, 0x86, 0xF6, 39}
DEFINE_PROPERTYKEY!{PKEY_Music_PartOfSet,
    0x56A3372E, 0xCE9C, 0x11D2, 0x9F, 0x0E, 0x00, 0x60, 0x97, 0xC6, 0x86, 0xF6, 37}
DEFINE_PROPERTYKEY!{PKEY_Music_Period,
    0x64440492, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 31}
DEFINE_PROPERTYKEY!{PKEY_Music_SynchronizedLyrics,
    0x6B223B6A, 0x162E, 0x4AA9, 0xB3, 0x9F, 0x05, 0xD6, 0x78, 0xFC, 0x6D, 0x77, 100}
DEFINE_PROPERTYKEY!{PKEY_Music_TrackNumber,
    0x56A3372E, 0xCE9C, 0x11D2, 0x9F, 0x0E, 0x00, 0x60, 0x97, 0xC6, 0x86, 0xF6, 7}
DEFINE_PROPERTYKEY!{PKEY_Note_Color,
    0x4776CAFA, 0xBCE4, 0x4CB1, 0xA2, 0x3E, 0x26, 0x5E, 0x76, 0xD8, 0xEB, 0x11, 100}
pub const NOTE_COLOR_BLUE: DWORD = 0;
pub const NOTE_COLOR_GREEN: DWORD = 1;
pub const NOTE_COLOR_PINK: DWORD = 2;
pub const NOTE_COLOR_YELLOW: DWORD = 3;
pub const NOTE_COLOR_WHITE: DWORD = 4;
pub const NOTE_COLOR_LIGHTGREEN: DWORD = 5;
DEFINE_PROPERTYKEY!{PKEY_Note_ColorText,
    0x46B4E8DE, 0xCDB2, 0x440D, 0x88, 0x5C, 0x16, 0x58, 0xEB, 0x65, 0xB9, 0x14, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_Aperture,
    0x14B81DA1, 0x0135, 0x4D31, 0x96, 0xD9, 0x6C, 0xBF, 0xC9, 0x67, 0x1A, 0x99, 37378}
DEFINE_PROPERTYKEY!{PKEY_Photo_ApertureDenominator,
    0xE1A9A38B, 0x6685, 0x46BD, 0x87, 0x5E, 0x57, 0x0D, 0xC7, 0xAD, 0x73, 0x20, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_ApertureNumerator,
    0x0337ECEC, 0x39FB, 0x4581, 0xA0, 0xBD, 0x4C, 0x4C, 0xC5, 0x1E, 0x99, 0x14, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_Brightness,
    0x1A701BF6, 0x478C, 0x4361, 0x83, 0xAB, 0x37, 0x01, 0xBB, 0x05, 0x3C, 0x58, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_BrightnessDenominator,
    0x6EBE6946, 0x2321, 0x440A, 0x90, 0xF0, 0xC0, 0x43, 0xEF, 0xD3, 0x24, 0x76, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_BrightnessNumerator,
    0x9E7D118F, 0xB314, 0x45A0, 0x8C, 0xFB, 0xD6, 0x54, 0xB9, 0x17, 0xC9, 0xE9, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_CameraManufacturer,
    0x14B81DA1, 0x0135, 0x4D31, 0x96, 0xD9, 0x6C, 0xBF, 0xC9, 0x67, 0x1A, 0x99, 271}
DEFINE_PROPERTYKEY!{PKEY_Photo_CameraModel,
    0x14B81DA1, 0x0135, 0x4D31, 0x96, 0xD9, 0x6C, 0xBF, 0xC9, 0x67, 0x1A, 0x99, 272}
DEFINE_PROPERTYKEY!{PKEY_Photo_CameraSerialNumber,
    0x14B81DA1, 0x0135, 0x4D31, 0x96, 0xD9, 0x6C, 0xBF, 0xC9, 0x67, 0x1A, 0x99, 273}
DEFINE_PROPERTYKEY!{PKEY_Photo_Contrast,
    0x2A785BA9, 0x8D23, 0x4DED, 0x82, 0xE6, 0x60, 0xA3, 0x50, 0xC8, 0x6A, 0x10, 100}
pub const PHOTO_CONTRAST_NORMAL: DWORD = 0;
pub const PHOTO_CONTRAST_SOFT: DWORD = 1;
pub const PHOTO_CONTRAST_HARD: DWORD = 2;
DEFINE_PROPERTYKEY!{PKEY_Photo_ContrastText,
    0x59DDE9F2, 0x5253, 0x40EA, 0x9A, 0x8B, 0x47, 0x9E, 0x96, 0xC6, 0x24, 0x9A, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_DateTaken,
    0x14B81DA1, 0x0135, 0x4D31, 0x96, 0xD9, 0x6C, 0xBF, 0xC9, 0x67, 0x1A, 0x99, 36867}
DEFINE_PROPERTYKEY!{PKEY_Photo_DigitalZoom,
    0xF85BF840, 0xA925, 0x4BC2, 0xB0, 0xC4, 0x8E, 0x36, 0xB5, 0x98, 0x67, 0x9E, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_DigitalZoomDenominator,
    0x745BAF0E, 0xE5C1, 0x4CFB, 0x8A, 0x1B, 0xD0, 0x31, 0xA0, 0xA5, 0x23, 0x93, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_DigitalZoomNumerator,
    0x16CBB924, 0x6500, 0x473B, 0xA5, 0xBE, 0xF1, 0x59, 0x9B, 0xCB, 0xE4, 0x13, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_Event,
    0x14B81DA1, 0x0135, 0x4D31, 0x96, 0xD9, 0x6C, 0xBF, 0xC9, 0x67, 0x1A, 0x99, 18248}
DEFINE_PROPERTYKEY!{PKEY_Photo_EXIFVersion,
    0xD35F743A, 0xEB2E, 0x47F2, 0xA2, 0x86, 0x84, 0x41, 0x32, 0xCB, 0x14, 0x27, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_ExposureBias,
    0x14B81DA1, 0x0135, 0x4D31, 0x96, 0xD9, 0x6C, 0xBF, 0xC9, 0x67, 0x1A, 0x99, 37380}
DEFINE_PROPERTYKEY!{PKEY_Photo_ExposureBiasDenominator,
    0xAB205E50, 0x04B7, 0x461C, 0xA1, 0x8C, 0x2F, 0x23, 0x38, 0x36, 0xE6, 0x27, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_ExposureBiasNumerator,
    0x738BF284, 0x1D87, 0x420B, 0x92, 0xCF, 0x58, 0x34, 0xBF, 0x6E, 0xF9, 0xED, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_ExposureIndex,
    0x967B5AF8, 0x995A, 0x46ED, 0x9E, 0x11, 0x35, 0xB3, 0xC5, 0xB9, 0x78, 0x2D, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_ExposureIndexDenominator,
    0x93112F89, 0xC28B, 0x492F, 0x8A, 0x9D, 0x4B, 0xE2, 0x06, 0x2C, 0xEE, 0x8A, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_ExposureIndexNumerator,
    0xCDEDCF30, 0x8919, 0x44DF, 0x8F, 0x4C, 0x4E, 0xB2, 0xFF, 0xDB, 0x8D, 0x89, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_ExposureProgram,
    0x14B81DA1, 0x0135, 0x4D31, 0x96, 0xD9, 0x6C, 0xBF, 0xC9, 0x67, 0x1A, 0x99, 34850}
pub const PHOTO_EXPOSUREPROGRAM_UNKNOWN: DWORD = 0;
pub const PHOTO_EXPOSUREPROGRAM_MANUAL: DWORD = 1;
pub const PHOTO_EXPOSUREPROGRAM_NORMAL: DWORD = 2;
pub const PHOTO_EXPOSUREPROGRAM_APERTURE: DWORD = 3;
pub const PHOTO_EXPOSUREPROGRAM_SHUTTER: DWORD = 4;
pub const PHOTO_EXPOSUREPROGRAM_CREATIVE: DWORD = 5;
pub const PHOTO_EXPOSUREPROGRAM_ACTION: DWORD = 6;
pub const PHOTO_EXPOSUREPROGRAM_PORTRAIT: DWORD = 7;
pub const PHOTO_EXPOSUREPROGRAM_LANDSCAPE: DWORD = 8;
DEFINE_PROPERTYKEY!{PKEY_Photo_ExposureProgramText,
    0xFEC690B7, 0x5F30, 0x4646, 0xAE, 0x47, 0x4C, 0xAA, 0xFB, 0xA8, 0x84, 0xA3, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_ExposureTime,
    0x14B81DA1, 0x0135, 0x4D31, 0x96, 0xD9, 0x6C, 0xBF, 0xC9, 0x67, 0x1A, 0x99, 33434}
DEFINE_PROPERTYKEY!{PKEY_Photo_ExposureTimeDenominator,
    0x55E98597, 0xAD16, 0x42E0, 0xB6, 0x24, 0x21, 0x59, 0x9A, 0x19, 0x98, 0x38, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_ExposureTimeNumerator,
    0x257E44E2, 0x9031, 0x4323, 0xAC, 0x38, 0x85, 0xC5, 0x52, 0x87, 0x1B, 0x2E, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_Flash,
    0x14B81DA1, 0x0135, 0x4D31, 0x96, 0xD9, 0x6C, 0xBF, 0xC9, 0x67, 0x1A, 0x99, 37385}
pub const PHOTO_FLASH_NONE: LONG = 0;
pub const PHOTO_FLASH_FLASH: LONG = 1;
pub const PHOTO_FLASH_WITHOUTSTROBE: LONG = 5;
pub const PHOTO_FLASH_WITHSTROBE: LONG = 7;
pub const PHOTO_FLASH_FLASH_COMPULSORY: LONG = 9;
pub const PHOTO_FLASH_FLASH_COMPULSORY_NORETURNLIGHT: LONG = 13;
pub const PHOTO_FLASH_FLASH_COMPULSORY_RETURNLIGHT: LONG = 15;
pub const PHOTO_FLASH_NONE_COMPULSORY: LONG = 16;
pub const PHOTO_FLASH_NONE_AUTO: LONG = 24;
pub const PHOTO_FLASH_FLASH_AUTO: LONG = 25;
pub const PHOTO_FLASH_FLASH_AUTO_NORETURNLIGHT: LONG = 29;
pub const PHOTO_FLASH_FLASH_AUTO_RETURNLIGHT: LONG = 31;
pub const PHOTO_FLASH_NOFUNCTION: LONG = 32;
pub const PHOTO_FLASH_FLASH_REDEYE: LONG = 65;
pub const PHOTO_FLASH_FLASH_REDEYE_NORETURNLIGHT: LONG = 69;
pub const PHOTO_FLASH_FLASH_REDEYE_RETURNLIGHT: LONG = 71;
pub const PHOTO_FLASH_FLASH_COMPULSORY_REDEYE: LONG = 73;
pub const PHOTO_FLASH_FLASH_COMPULSORY_REDEYE_NORETURNLIGHT: LONG = 77;
pub const PHOTO_FLASH_FLASH_COMPULSORY_REDEYE_RETURNLIGHT: LONG = 79;
pub const PHOTO_FLASH_FLASH_AUTO_REDEYE: LONG = 89;
pub const PHOTO_FLASH_FLASH_AUTO_REDEYE_NORETURNLIGHT: LONG = 93;
pub const PHOTO_FLASH_FLASH_AUTO_REDEYE_RETURNLIGHT: LONG = 95;
DEFINE_PROPERTYKEY!{PKEY_Photo_FlashEnergy,
    0x14B81DA1, 0x0135, 0x4D31, 0x96, 0xD9, 0x6C, 0xBF, 0xC9, 0x67, 0x1A, 0x99, 41483}
DEFINE_PROPERTYKEY!{PKEY_Photo_FlashEnergyDenominator,
    0xD7B61C70, 0x6323, 0x49CD, 0xA5, 0xFC, 0xC8, 0x42, 0x77, 0x16, 0x2C, 0x97, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_FlashEnergyNumerator,
    0xFCAD3D3D, 0x0858, 0x400F, 0xAA, 0xA3, 0x2F, 0x66, 0xCC, 0xE2, 0xA6, 0xBC, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_FlashManufacturer,
    0xAABAF6C9, 0xE0C5, 0x4719, 0x85, 0x85, 0x57, 0xB1, 0x03, 0xE5, 0x84, 0xFE, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_FlashModel,
    0xFE83BB35, 0x4D1A, 0x42E2, 0x91, 0x6B, 0x06, 0xF3, 0xE1, 0xAF, 0x71, 0x9E, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_FlashText,
    0x6B8B68F6, 0x200B, 0x47EA, 0x8D, 0x25, 0xD8, 0x05, 0x0F, 0x57, 0x33, 0x9F, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_FNumber,
    0x14B81DA1, 0x0135, 0x4D31, 0x96, 0xD9, 0x6C, 0xBF, 0xC9, 0x67, 0x1A, 0x99, 33437}
DEFINE_PROPERTYKEY!{PKEY_Photo_FNumberDenominator,
    0xE92A2496, 0x223B, 0x4463, 0xA4, 0xE3, 0x30, 0xEA, 0xBB, 0xA7, 0x9D, 0x80, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_FNumberNumerator,
    0x1B97738A, 0xFDFC, 0x462F, 0x9D, 0x93, 0x19, 0x57, 0xE0, 0x8B, 0xE9, 0x0C, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_FocalLength,
    0x14B81DA1, 0x0135, 0x4D31, 0x96, 0xD9, 0x6C, 0xBF, 0xC9, 0x67, 0x1A, 0x99, 37386}
DEFINE_PROPERTYKEY!{PKEY_Photo_FocalLengthDenominator,
    0x305BC615, 0xDCA1, 0x44A5, 0x9F, 0xD4, 0x10, 0xC0, 0xBA, 0x79, 0x41, 0x2E, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_FocalLengthInFilm,
    0xA0E74609, 0xB84D, 0x4F49, 0xB8, 0x60, 0x46, 0x2B, 0xD9, 0x97, 0x1F, 0x98, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_FocalLengthNumerator,
    0x776B6B3B, 0x1E3D, 0x4B0C, 0x9A, 0x0E, 0x8F, 0xBA, 0xF2, 0xA8, 0x49, 0x2A, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_FocalPlaneXResolution,
    0xCFC08D97, 0xC6F7, 0x4484, 0x89, 0xDD, 0xEB, 0xEF, 0x43, 0x56, 0xFE, 0x76, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_FocalPlaneXResolutionDenominator,
    0x0933F3F5, 0x4786, 0x4F46, 0xA8, 0xE8, 0xD6, 0x4D, 0xD3, 0x7F, 0xA5, 0x21, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_FocalPlaneXResolutionNumerator,
    0xDCCB10AF, 0xB4E2, 0x4B88, 0x95, 0xF9, 0x03, 0x1B, 0x4D, 0x5A, 0xB4, 0x90, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_FocalPlaneYResolution,
    0x4FFFE4D0, 0x914F, 0x4AC4, 0x8D, 0x6F, 0xC9, 0xC6, 0x1D, 0xE1, 0x69, 0xB1, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_FocalPlaneYResolutionDenominator,
    0x1D6179A6, 0xA876, 0x4031, 0xB0, 0x13, 0x33, 0x47, 0xB2, 0xB6, 0x4D, 0xC8, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_FocalPlaneYResolutionNumerator,
    0xA2E541C5, 0x4440, 0x4BA8, 0x86, 0x7E, 0x75, 0xCF, 0xC0, 0x68, 0x28, 0xCD, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_GainControl,
    0xFA304789, 0x00C7, 0x4D80, 0x90, 0x4A, 0x1E, 0x4D, 0xCC, 0x72, 0x65, 0xAA, 100}
pub const PHOTO_GAINCONTROL_NONE: DOUBLE = 0.0;
pub const PHOTO_GAINCONTROL_LOWGAINUP: DOUBLE = 1.0;
pub const PHOTO_GAINCONTROL_HIGHGAINUP: DOUBLE = 2.0;
pub const PHOTO_GAINCONTROL_LOWGAINDOWN: DOUBLE = 3.0;
pub const PHOTO_GAINCONTROL_HIGHGAINDOWN: DOUBLE = 4.0;
DEFINE_PROPERTYKEY!{PKEY_Photo_GainControlDenominator,
    0x42864DFD, 0x9DA4, 0x4F77, 0xBD, 0xED, 0x4A, 0xAD, 0x7B, 0x25, 0x67, 0x35, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_GainControlNumerator,
    0x8E8ECF7C, 0xB7B8, 0x4EB8, 0xA6, 0x3F, 0x0E, 0xE7, 0x15, 0xC9, 0x6F, 0x9E, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_GainControlText,
    0xC06238B2, 0x0BF9, 0x4279, 0xA7, 0x23, 0x25, 0x85, 0x67, 0x15, 0xCB, 0x9D, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_ISOSpeed,
    0x14B81DA1, 0x0135, 0x4D31, 0x96, 0xD9, 0x6C, 0xBF, 0xC9, 0x67, 0x1A, 0x99, 34855}
DEFINE_PROPERTYKEY!{PKEY_Photo_LensManufacturer,
    0xE6DDCAF7, 0x29C5, 0x4F0A, 0x9A, 0x68, 0xD1, 0x94, 0x12, 0xEC, 0x70, 0x90, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_LensModel,
    0xE1277516, 0x2B5F, 0x4869, 0x89, 0xB1, 0x2E, 0x58, 0x5B, 0xD3, 0x8B, 0x7A, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_LightSource,
    0x14B81DA1, 0x0135, 0x4D31, 0x96, 0xD9, 0x6C, 0xBF, 0xC9, 0x67, 0x1A, 0x99, 37384}
pub const PHOTO_LIGHTSOURCE_UNKNOWN: DWORD = 0;
pub const PHOTO_LIGHTSOURCE_DAYLIGHT: DWORD = 1;
pub const PHOTO_LIGHTSOURCE_FLUORESCENT: DWORD = 2;
pub const PHOTO_LIGHTSOURCE_TUNGSTEN: DWORD = 3;
pub const PHOTO_LIGHTSOURCE_STANDARD_A: DWORD = 17;
pub const PHOTO_LIGHTSOURCE_STANDARD_B: DWORD = 18;
pub const PHOTO_LIGHTSOURCE_STANDARD_C: DWORD = 19;
pub const PHOTO_LIGHTSOURCE_D55: DWORD = 20;
pub const PHOTO_LIGHTSOURCE_D65: DWORD = 21;
pub const PHOTO_LIGHTSOURCE_D75: DWORD = 22;
DEFINE_PROPERTYKEY!{PKEY_Photo_MakerNote,
    0xFA303353, 0xB659, 0x4052, 0x85, 0xE9, 0xBC, 0xAC, 0x79, 0x54, 0x9B, 0x84, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_MakerNoteOffset,
    0x813F4124, 0x34E6, 0x4D17, 0xAB, 0x3E, 0x6B, 0x1F, 0x3C, 0x22, 0x47, 0xA1, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_MaxAperture,
    0x08F6D7C2, 0xE3F2, 0x44FC, 0xAF, 0x1E, 0x5A, 0xA5, 0xC8, 0x1A, 0x2D, 0x3E, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_MaxApertureDenominator,
    0xC77724D4, 0x601F, 0x46C5, 0x9B, 0x89, 0xC5, 0x3F, 0x93, 0xBC, 0xEB, 0x77, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_MaxApertureNumerator,
    0xC107E191, 0xA459, 0x44C5, 0x9A, 0xE6, 0xB9, 0x52, 0xAD, 0x4B, 0x90, 0x6D, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_MeteringMode,
    0x14B81DA1, 0x0135, 0x4D31, 0x96, 0xD9, 0x6C, 0xBF, 0xC9, 0x67, 0x1A, 0x99, 37383}
pub const PHOTO_METERINGMODE_UNKNOWN: DWORD = 0;
pub const PHOTO_METERINGMODE_AVERAGE: DWORD = 1;
pub const PHOTO_METERINGMODE_CENTER: DWORD = 2;
pub const PHOTO_METERINGMODE_SPOT: DWORD = 3;
pub const PHOTO_METERINGMODE_MULTISPOT: DWORD = 4;
pub const PHOTO_METERINGMODE_PATTERN: DWORD = 5;
pub const PHOTO_METERINGMODE_PARTIAL: DWORD = 6;
DEFINE_PROPERTYKEY!{PKEY_Photo_MeteringModeText,
    0xF628FD8C, 0x7BA8, 0x465A, 0xA6, 0x5B, 0xC5, 0xAA, 0x79, 0x26, 0x3A, 0x9E, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_Orientation,
    0x14B81DA1, 0x0135, 0x4D31, 0x96, 0xD9, 0x6C, 0xBF, 0xC9, 0x67, 0x1A, 0x99, 274}
pub const PHOTO_ORIENTATION_NORMAL: DWORD = 1;
pub const PHOTO_ORIENTATION_FLIPHORIZONTAL: DWORD = 2;
pub const PHOTO_ORIENTATION_ROTATE180: DWORD = 3;
pub const PHOTO_ORIENTATION_FLIPVERTICAL: DWORD = 4;
pub const PHOTO_ORIENTATION_TRANSPOSE: DWORD = 5;
pub const PHOTO_ORIENTATION_ROTATE270: DWORD = 6;
pub const PHOTO_ORIENTATION_TRANSVERSE: DWORD = 7;
pub const PHOTO_ORIENTATION_ROTATE90: DWORD = 8;
DEFINE_PROPERTYKEY!{PKEY_Photo_OrientationText,
    0xA9EA193C, 0xC511, 0x498A, 0xA0, 0x6B, 0x58, 0xE2, 0x77, 0x6D, 0xCC, 0x28, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_PeopleNames,
    0xE8309B6E, 0x084C, 0x49B4, 0xB1, 0xFC, 0x90, 0xA8, 0x03, 0x31, 0xB6, 0x38, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_PhotometricInterpretation,
    0x341796F1, 0x1DF9, 0x4B1C, 0xA5, 0x64, 0x91, 0xBD, 0xEF, 0xA4, 0x38, 0x77, 100}
pub const PHOTO_PHOTOMETRIC_RGB: DWORD = 2;
pub const PHOTO_PHOTOMETRIC_YCBCR: DWORD = 6;
DEFINE_PROPERTYKEY!{PKEY_Photo_PhotometricInterpretationText,
    0x821437D6, 0x9EAB, 0x4765, 0xA5, 0x89, 0x3B, 0x1C, 0xBB, 0xD2, 0x2A, 0x61, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_ProgramMode,
    0x6D217F6D, 0x3F6A, 0x4825, 0xB4, 0x70, 0x5F, 0x03, 0xCA, 0x2F, 0xBE, 0x9B, 100}
pub const PHOTO_PROGRAMMODE_NOTDEFINED: DWORD = 0;
pub const PHOTO_PROGRAMMODE_MANUAL: DWORD = 1;
pub const PHOTO_PROGRAMMODE_NORMAL: DWORD = 2;
pub const PHOTO_PROGRAMMODE_APERTURE: DWORD = 3;
pub const PHOTO_PROGRAMMODE_SHUTTER: DWORD = 4;
pub const PHOTO_PROGRAMMODE_CREATIVE: DWORD = 5;
pub const PHOTO_PROGRAMMODE_ACTION: DWORD = 6;
pub const PHOTO_PROGRAMMODE_PORTRAIT: DWORD = 7;
pub const PHOTO_PROGRAMMODE_LANDSCAPE: DWORD = 8;
DEFINE_PROPERTYKEY!{PKEY_Photo_ProgramModeText,
    0x7FE3AA27, 0x2648, 0x42F3, 0x89, 0xB0, 0x45, 0x4E, 0x5C, 0xB1, 0x50, 0xC3, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_RelatedSoundFile,
    0x318A6B45, 0x087F, 0x4DC2, 0xB8, 0xCC, 0x05, 0x35, 0x95, 0x51, 0xFC, 0x9E, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_Saturation,
    0x49237325, 0xA95A, 0x4F67, 0xB2, 0x11, 0x81, 0x6B, 0x2D, 0x45, 0xD2, 0xE0, 100}
pub const PHOTO_SATURATION_NORMAL: DWORD = 0;
pub const PHOTO_SATURATION_LOW: DWORD = 1;
pub const PHOTO_SATURATION_HIGH: DWORD = 2;
DEFINE_PROPERTYKEY!{PKEY_Photo_SaturationText,
    0x61478C08, 0xB600, 0x4A84, 0xBB, 0xE4, 0xE9, 0x9C, 0x45, 0xF0, 0xA0, 0x72, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_Sharpness,
    0xFC6976DB, 0x8349, 0x4970, 0xAE, 0x97, 0xB3, 0xC5, 0x31, 0x6A, 0x08, 0xF0, 100}
pub const PHOTO_SHARPNESS_NORMAL: DWORD = 0;
pub const PHOTO_SHARPNESS_SOFT: DWORD = 1;
pub const PHOTO_SHARPNESS_HARD: DWORD = 2;
DEFINE_PROPERTYKEY!{PKEY_Photo_SharpnessText,
    0x51EC3F47, 0xDD50, 0x421D, 0x87, 0x69, 0x33, 0x4F, 0x50, 0x42, 0x4B, 0x1E, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_ShutterSpeed,
    0x14B81DA1, 0x0135, 0x4D31, 0x96, 0xD9, 0x6C, 0xBF, 0xC9, 0x67, 0x1A, 0x99, 37377}
DEFINE_PROPERTYKEY!{PKEY_Photo_ShutterSpeedDenominator,
    0xE13D8975, 0x81C7, 0x4948, 0xAE, 0x3F, 0x37, 0xCA, 0xE1, 0x1E, 0x8F, 0xF7, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_ShutterSpeedNumerator,
    0x16EA4042, 0xD6F4, 0x4BCA, 0x83, 0x49, 0x7C, 0x78, 0xD3, 0x0F, 0xB3, 0x33, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_SubjectDistance,
    0x14B81DA1, 0x0135, 0x4D31, 0x96, 0xD9, 0x6C, 0xBF, 0xC9, 0x67, 0x1A, 0x99, 37382}
DEFINE_PROPERTYKEY!{PKEY_Photo_SubjectDistanceDenominator,
    0x0C840A88, 0xB043, 0x466D, 0x97, 0x66, 0xD4, 0xB2, 0x6D, 0xA3, 0xFA, 0x77, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_SubjectDistanceNumerator,
    0x8AF4961C, 0xF526, 0x43E5, 0xAA, 0x81, 0xDB, 0x76, 0x82, 0x19, 0x17, 0x8D, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_TagViewAggregate,
    0xB812F15D, 0xC2D8, 0x4BBF, 0xBA, 0xCD, 0x79, 0x74, 0x43, 0x46, 0x11, 0x3F, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_TranscodedForSync,
    0x9A8EBB75, 0x6458, 0x4E82, 0xBA, 0xCB, 0x35, 0xC0, 0x09, 0x5B, 0x03, 0xBB, 100}
DEFINE_PROPERTYKEY!{PKEY_Photo_WhiteBalance,
    0xEE3D3D8A, 0x5381, 0x4CFA, 0xB1, 0x3B, 0xAA, 0xF6, 0x6B, 0x5F, 0x4E, 0xC9, 100}
pub const PHOTO_WHITEBALANCE_AUTO: DWORD = 0;
pub const PHOTO_WHITEBALANCE_MANUAL: DWORD = 1;
DEFINE_PROPERTYKEY!{PKEY_Photo_WhiteBalanceText,
    0x6336B95E, 0xC7A7, 0x426D, 0x86, 0xFD, 0x7A, 0xE3, 0xD3, 0x9C, 0x84, 0xB4, 100}
DEFINE_PROPERTYKEY!{PKEY_PropGroup_Advanced,
    0x900A403B, 0x097B, 0x4B95, 0x8A, 0xE2, 0x07, 0x1F, 0xDA, 0xEE, 0xB1, 0x18, 100}
DEFINE_PROPERTYKEY!{PKEY_PropGroup_Audio,
    0x2804D469, 0x788F, 0x48AA, 0x85, 0x70, 0x71, 0xB9, 0xC1, 0x87, 0xE1, 0x38, 100}
DEFINE_PROPERTYKEY!{PKEY_PropGroup_Calendar,
    0x9973D2B5, 0xBFD8, 0x438A, 0xBA, 0x94, 0x53, 0x49, 0xB2, 0x93, 0x18, 0x1A, 100}
DEFINE_PROPERTYKEY!{PKEY_PropGroup_Camera,
    0xDE00DE32, 0x547E, 0x4981, 0xAD, 0x4B, 0x54, 0x2F, 0x2E, 0x90, 0x07, 0xD8, 100}
DEFINE_PROPERTYKEY!{PKEY_PropGroup_Contact,
    0xDF975FD3, 0x250A, 0x4004, 0x85, 0x8F, 0x34, 0xE2, 0x9A, 0x3E, 0x37, 0xAA, 100}
DEFINE_PROPERTYKEY!{PKEY_PropGroup_Content,
    0xD0DAB0BA, 0x368A, 0x4050, 0xA8, 0x82, 0x6C, 0x01, 0x0F, 0xD1, 0x9A, 0x4F, 100}
DEFINE_PROPERTYKEY!{PKEY_PropGroup_Description,
    0x8969B275, 0x9475, 0x4E00, 0xA8, 0x87, 0xFF, 0x93, 0xB8, 0xB4, 0x1E, 0x44, 100}
DEFINE_PROPERTYKEY!{PKEY_PropGroup_FileSystem,
    0xE3A7D2C1, 0x80FC, 0x4B40, 0x8F, 0x34, 0x30, 0xEA, 0x11, 0x1B, 0xDC, 0x2E, 100}
DEFINE_PROPERTYKEY!{PKEY_PropGroup_General,
    0xCC301630, 0xB192, 0x4C22, 0xB3, 0x72, 0x9F, 0x4C, 0x6D, 0x33, 0x8E, 0x07, 100}
DEFINE_PROPERTYKEY!{PKEY_PropGroup_GPS,
    0xF3713ADA, 0x90E3, 0x4E11, 0xAA, 0xE5, 0xFD, 0xC1, 0x76, 0x85, 0xB9, 0xBE, 100}
DEFINE_PROPERTYKEY!{PKEY_PropGroup_Image,
    0xE3690A87, 0x0FA8, 0x4A2A, 0x9A, 0x9F, 0xFC, 0xE8, 0x82, 0x70, 0x55, 0xAC, 100}
DEFINE_PROPERTYKEY!{PKEY_PropGroup_Media,
    0x61872CF7, 0x6B5E, 0x4B4B, 0xAC, 0x2D, 0x59, 0xDA, 0x84, 0x45, 0x92, 0x48, 100}
DEFINE_PROPERTYKEY!{PKEY_PropGroup_MediaAdvanced,
    0x8859A284, 0xDE7E, 0x4642, 0x99, 0xBA, 0xD4, 0x31, 0xD0, 0x44, 0xB1, 0xEC, 100}
DEFINE_PROPERTYKEY!{PKEY_PropGroup_Message,
    0x7FD7259D, 0x16B4, 0x4135, 0x9F, 0x97, 0x7C, 0x96, 0xEC, 0xD2, 0xFA, 0x9E, 100}
DEFINE_PROPERTYKEY!{PKEY_PropGroup_Music,
    0x68DD6094, 0x7216, 0x40F1, 0xA0, 0x29, 0x43, 0xFE, 0x71, 0x27, 0x04, 0x3F, 100}
DEFINE_PROPERTYKEY!{PKEY_PropGroup_Origin,
    0x2598D2FB, 0x5569, 0x4367, 0x95, 0xDF, 0x5C, 0xD3, 0xA1, 0x77, 0xE1, 0xA5, 100}
DEFINE_PROPERTYKEY!{PKEY_PropGroup_PhotoAdvanced,
    0x0CB2BF5A, 0x9EE7, 0x4A86, 0x82, 0x22, 0xF0, 0x1E, 0x07, 0xFD, 0xAD, 0xAF, 100}
DEFINE_PROPERTYKEY!{PKEY_PropGroup_RecordedTV,
    0xE7B33238, 0x6584, 0x4170, 0xA5, 0xC0, 0xAC, 0x25, 0xEF, 0xD9, 0xDA, 0x56, 100}
DEFINE_PROPERTYKEY!{PKEY_PropGroup_Video,
    0xBEBE0920, 0x7671, 0x4C54, 0xA3, 0xEB, 0x49, 0xFD, 0xDF, 0xC1, 0x91, 0xEE, 100}
DEFINE_PROPERTYKEY!{PKEY_InfoTipText,
    0xC9944A21, 0xA406, 0x48FE, 0x82, 0x25, 0xAE, 0xC7, 0xE2, 0x4C, 0x21, 0x1B, 17}
DEFINE_PROPERTYKEY!{PKEY_PropList_ConflictPrompt,
    0xC9944A21, 0xA406, 0x48FE, 0x82, 0x25, 0xAE, 0xC7, 0xE2, 0x4C, 0x21, 0x1B, 11}
DEFINE_PROPERTYKEY!{PKEY_PropList_ContentViewModeForBrowse,
    0xC9944A21, 0xA406, 0x48FE, 0x82, 0x25, 0xAE, 0xC7, 0xE2, 0x4C, 0x21, 0x1B, 13}
DEFINE_PROPERTYKEY!{PKEY_PropList_ContentViewModeForSearch,
    0xC9944A21, 0xA406, 0x48FE, 0x82, 0x25, 0xAE, 0xC7, 0xE2, 0x4C, 0x21, 0x1B, 14}
DEFINE_PROPERTYKEY!{PKEY_PropList_ExtendedTileInfo,
    0xC9944A21, 0xA406, 0x48FE, 0x82, 0x25, 0xAE, 0xC7, 0xE2, 0x4C, 0x21, 0x1B, 9}
DEFINE_PROPERTYKEY!{PKEY_PropList_FileOperationPrompt,
    0xC9944A21, 0xA406, 0x48FE, 0x82, 0x25, 0xAE, 0xC7, 0xE2, 0x4C, 0x21, 0x1B, 10}
DEFINE_PROPERTYKEY!{PKEY_PropList_FullDetails,
    0xC9944A21, 0xA406, 0x48FE, 0x82, 0x25, 0xAE, 0xC7, 0xE2, 0x4C, 0x21, 0x1B, 2}
DEFINE_PROPERTYKEY!{PKEY_PropList_InfoTip,
    0xC9944A21, 0xA406, 0x48FE, 0x82, 0x25, 0xAE, 0xC7, 0xE2, 0x4C, 0x21, 0x1B, 4}
DEFINE_PROPERTYKEY!{PKEY_PropList_NonPersonal,
    0x49D1091F, 0x082E, 0x493F, 0xB2, 0x3F, 0xD2, 0x30, 0x8A, 0xA9, 0x66, 0x8C, 100}
DEFINE_PROPERTYKEY!{PKEY_PropList_PreviewDetails,
    0xC9944A21, 0xA406, 0x48FE, 0x82, 0x25, 0xAE, 0xC7, 0xE2, 0x4C, 0x21, 0x1B, 8}
DEFINE_PROPERTYKEY!{PKEY_PropList_PreviewTitle,
    0xC9944A21, 0xA406, 0x48FE, 0x82, 0x25, 0xAE, 0xC7, 0xE2, 0x4C, 0x21, 0x1B, 6}
DEFINE_PROPERTYKEY!{PKEY_PropList_QuickTip,
    0xC9944A21, 0xA406, 0x48FE, 0x82, 0x25, 0xAE, 0xC7, 0xE2, 0x4C, 0x21, 0x1B, 5}
DEFINE_PROPERTYKEY!{PKEY_PropList_TileInfo,
    0xC9944A21, 0xA406, 0x48FE, 0x82, 0x25, 0xAE, 0xC7, 0xE2, 0x4C, 0x21, 0x1B, 3}
DEFINE_PROPERTYKEY!{PKEY_PropList_XPDetailsPanel,
    0xF2275480, 0xF782, 0x4291, 0xBD, 0x94, 0xF1, 0x36, 0x93, 0x51, 0x3A, 0xEC, 0}
DEFINE_PROPERTYKEY!{PKEY_RecordedTV_ChannelNumber,
    0x6D748DE2, 0x8D38, 0x4CC3, 0xAC, 0x60, 0xF0, 0x09, 0xB0, 0x57, 0xC5, 0x57, 7}
DEFINE_PROPERTYKEY!{PKEY_RecordedTV_Credits,
    0x6D748DE2, 0x8D38, 0x4CC3, 0xAC, 0x60, 0xF0, 0x09, 0xB0, 0x57, 0xC5, 0x57, 4}
DEFINE_PROPERTYKEY!{PKEY_RecordedTV_DateContentExpires,
    0x6D748DE2, 0x8D38, 0x4CC3, 0xAC, 0x60, 0xF0, 0x09, 0xB0, 0x57, 0xC5, 0x57, 15}
DEFINE_PROPERTYKEY!{PKEY_RecordedTV_EpisodeName,
    0x6D748DE2, 0x8D38, 0x4CC3, 0xAC, 0x60, 0xF0, 0x09, 0xB0, 0x57, 0xC5, 0x57, 2}
DEFINE_PROPERTYKEY!{PKEY_RecordedTV_IsATSCContent,
    0x6D748DE2, 0x8D38, 0x4CC3, 0xAC, 0x60, 0xF0, 0x09, 0xB0, 0x57, 0xC5, 0x57, 16}
DEFINE_PROPERTYKEY!{PKEY_RecordedTV_IsClosedCaptioningAvailable,
    0x6D748DE2, 0x8D38, 0x4CC3, 0xAC, 0x60, 0xF0, 0x09, 0xB0, 0x57, 0xC5, 0x57, 12}
DEFINE_PROPERTYKEY!{PKEY_RecordedTV_IsDTVContent,
    0x6D748DE2, 0x8D38, 0x4CC3, 0xAC, 0x60, 0xF0, 0x09, 0xB0, 0x57, 0xC5, 0x57, 17}
DEFINE_PROPERTYKEY!{PKEY_RecordedTV_IsHDContent,
    0x6D748DE2, 0x8D38, 0x4CC3, 0xAC, 0x60, 0xF0, 0x09, 0xB0, 0x57, 0xC5, 0x57, 18}
DEFINE_PROPERTYKEY!{PKEY_RecordedTV_IsRepeatBroadcast,
    0x6D748DE2, 0x8D38, 0x4CC3, 0xAC, 0x60, 0xF0, 0x09, 0xB0, 0x57, 0xC5, 0x57, 13}
DEFINE_PROPERTYKEY!{PKEY_RecordedTV_IsSAP,
    0x6D748DE2, 0x8D38, 0x4CC3, 0xAC, 0x60, 0xF0, 0x09, 0xB0, 0x57, 0xC5, 0x57, 14}
DEFINE_PROPERTYKEY!{PKEY_RecordedTV_NetworkAffiliation,
    0x2C53C813, 0xFB63, 0x4E22, 0xA1, 0xAB, 0x0B, 0x33, 0x1C, 0xA1, 0xE2, 0x73, 100}
DEFINE_PROPERTYKEY!{PKEY_RecordedTV_OriginalBroadcastDate,
    0x4684FE97, 0x8765, 0x4842, 0x9C, 0x13, 0xF0, 0x06, 0x44, 0x7B, 0x17, 0x8C, 100}
DEFINE_PROPERTYKEY!{PKEY_RecordedTV_ProgramDescription,
    0x6D748DE2, 0x8D38, 0x4CC3, 0xAC, 0x60, 0xF0, 0x09, 0xB0, 0x57, 0xC5, 0x57, 3}
DEFINE_PROPERTYKEY!{PKEY_RecordedTV_RecordingTime,
    0xA5477F61, 0x7A82, 0x4ECA, 0x9D, 0xDE, 0x98, 0xB6, 0x9B, 0x24, 0x79, 0xB3, 100}
DEFINE_PROPERTYKEY!{PKEY_RecordedTV_StationCallSign,
    0x6D748DE2, 0x8D38, 0x4CC3, 0xAC, 0x60, 0xF0, 0x09, 0xB0, 0x57, 0xC5, 0x57, 5}
DEFINE_PROPERTYKEY!{PKEY_RecordedTV_StationName,
    0x1B5439E7, 0xEBA1, 0x4AF8, 0xBD, 0xD7, 0x7A, 0xF1, 0xD4, 0x54, 0x94, 0x93, 100}
DEFINE_PROPERTYKEY!{PKEY_Search_AutoSummary,
    0x560C36C0, 0x503A, 0x11CF, 0xBA, 0xA1, 0x00, 0x00, 0x4C, 0x75, 0x2A, 0x9A, 2}
DEFINE_PROPERTYKEY!{PKEY_Search_ContainerHash,
    0xBCEEE283, 0x35DF, 0x4D53, 0x82, 0x6A, 0xF3, 0x6A, 0x3E, 0xEF, 0xC6, 0xBE, 100}
DEFINE_PROPERTYKEY!{PKEY_Search_Contents,
    0xB725F130, 0x47EF, 0x101A, 0xA5, 0xF1, 0x02, 0x60, 0x8C, 0x9E, 0xEB, 0xAC, 19}
DEFINE_PROPERTYKEY!{PKEY_Search_EntryID,
    0x49691C90, 0x7E17, 0x101A, 0xA9, 0x1C, 0x08, 0x00, 0x2B, 0x2E, 0xCD, 0xA9, 5}
DEFINE_PROPERTYKEY!{PKEY_Search_ExtendedProperties,
    0x7B03B546, 0xFA4F, 0x4A52, 0xA2, 0xFE, 0x03, 0xD5, 0x31, 0x1E, 0x58, 0x65, 100}
DEFINE_PROPERTYKEY!{PKEY_Search_GatherTime,
    0x0B63E350, 0x9CCC, 0x11D0, 0xBC, 0xDB, 0x00, 0x80, 0x5F, 0xCC, 0xCE, 0x04, 8}
DEFINE_PROPERTYKEY!{PKEY_Search_HitCount,
    0x49691C90, 0x7E17, 0x101A, 0xA9, 0x1C, 0x08, 0x00, 0x2B, 0x2E, 0xCD, 0xA9, 4}
DEFINE_PROPERTYKEY!{PKEY_Search_IsClosedDirectory,
    0x0B63E343, 0x9CCC, 0x11D0, 0xBC, 0xDB, 0x00, 0x80, 0x5F, 0xCC, 0xCE, 0x04, 23}
DEFINE_PROPERTYKEY!{PKEY_Search_IsFullyContained,
    0x0B63E343, 0x9CCC, 0x11D0, 0xBC, 0xDB, 0x00, 0x80, 0x5F, 0xCC, 0xCE, 0x04, 24}
DEFINE_PROPERTYKEY!{PKEY_Search_QueryFocusedSummary,
    0x560C36C0, 0x503A, 0x11CF, 0xBA, 0xA1, 0x00, 0x00, 0x4C, 0x75, 0x2A, 0x9A, 3}
DEFINE_PROPERTYKEY!{PKEY_Search_QueryFocusedSummaryWithFallback,
    0x560C36C0, 0x503A, 0x11CF, 0xBA, 0xA1, 0x00, 0x00, 0x4C, 0x75, 0x2A, 0x9A, 4}
DEFINE_PROPERTYKEY!{PKEY_Search_QueryPropertyHits,
    0x49691C90, 0x7E17, 0x101A, 0xA9, 0x1C, 0x08, 0x00, 0x2B, 0x2E, 0xCD, 0xA9, 21}
DEFINE_PROPERTYKEY!{PKEY_Search_Rank,
    0x49691C90, 0x7E17, 0x101A, 0xA9, 0x1C, 0x08, 0x00, 0x2B, 0x2E, 0xCD, 0xA9, 3}
DEFINE_PROPERTYKEY!{PKEY_Search_Store,
    0xA06992B3, 0x8CAF, 0x4ED7, 0xA5, 0x47, 0xB2, 0x59, 0xE3, 0x2A, 0xC9, 0xFC, 100}
DEFINE_PROPERTYKEY!{PKEY_Search_UrlToIndex,
    0x0B63E343, 0x9CCC, 0x11D0, 0xBC, 0xDB, 0x00, 0x80, 0x5F, 0xCC, 0xCE, 0x04, 2}
DEFINE_PROPERTYKEY!{PKEY_Search_UrlToIndexWithModificationTime,
    0x0B63E343, 0x9CCC, 0x11D0, 0xBC, 0xDB, 0x00, 0x80, 0x5F, 0xCC, 0xCE, 0x04, 12}
DEFINE_PROPERTYKEY!{PKEY_Supplemental_AlbumID,
    0x0C73B141, 0x39D6, 0x4653, 0xA6, 0x83, 0xCA, 0xB2, 0x91, 0xEA, 0xF9, 0x5B, 2}
DEFINE_PROPERTYKEY!{PKEY_Supplemental_ResourceId,
    0x0C73B141, 0x39D6, 0x4653, 0xA6, 0x83, 0xCA, 0xB2, 0x91, 0xEA, 0xF9, 0x5B, 3}
DEFINE_PROPERTYKEY!{PKEY_DescriptionID,
    0x28636AA6, 0x953D, 0x11D2, 0xB5, 0xD6, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0xD0, 2}
DEFINE_PROPERTYKEY!{PKEY_InternalName,
    0x0CEF7D53, 0xFA64, 0x11D1, 0xA2, 0x03, 0x00, 0x00, 0xF8, 0x1F, 0xED, 0xEE, 5}
DEFINE_PROPERTYKEY!{PKEY_LibraryLocationsCount,
    0x908696C7, 0x8F87, 0x44F2, 0x80, 0xED, 0xA8, 0xC1, 0xC6, 0x89, 0x45, 0x75, 2}
DEFINE_PROPERTYKEY!{PKEY_Link_TargetSFGAOFlagsStrings,
    0xD6942081, 0xD53B, 0x443D, 0xAD, 0x47, 0x5E, 0x05, 0x9D, 0x9C, 0xD2, 0x7A, 3}
DEFINE_PROPERTYKEY!{PKEY_Link_TargetUrl,
    0x5CBF2787, 0x48CF, 0x4208, 0xB9, 0x0E, 0xEE, 0x5E, 0x5D, 0x42, 0x02, 0x94, 2}
DEFINE_PROPERTYKEY!{PKEY_NamespaceCLSID,
    0x28636AA6, 0x953D, 0x11D2, 0xB5, 0xD6, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0xD0, 6}
DEFINE_PROPERTYKEY!{PKEY_Shell_SFGAOFlagsStrings,
    0xD6942081, 0xD53B, 0x443D, 0xAD, 0x47, 0x5E, 0x05, 0x9D, 0x9C, 0xD2, 0x7A, 2}
pub const SFGAOSTR_FILESYS: &'static str = "filesys";
pub const SFGAOSTR_FILEANC: &'static str = "fileanc";
pub const SFGAOSTR_STORAGEANC: &'static str = "storageanc";
pub const SFGAOSTR_STREAM: &'static str = "stream";
pub const SFGAOSTR_LINK: &'static str = "link";
pub const SFGAOSTR_HIDDEN: &'static str = "hidden";
pub const SFGAOSTR_SUPERHIDDEN: &'static str = "superhidden";
pub const SFGAOSTR_FOLDER: &'static str = "folder";
pub const SFGAOSTR_NONENUM: &'static str = "nonenum";
pub const SFGAOSTR_BROWSABLE: &'static str = "browsable";
pub const SFGAOSTR_SYSTEM: &'static str = "system";
DEFINE_PROPERTYKEY!{PKEY_StatusBarSelectedItemCount,
    0x26DC287C, 0x6E3D, 0x4BD3, 0xB2, 0xB0, 0x6A, 0x26, 0xBA, 0x2E, 0x34, 0x6D, 3}
DEFINE_PROPERTYKEY!{PKEY_StatusBarViewItemCount,
    0x26DC287C, 0x6E3D, 0x4BD3, 0xB2, 0xB0, 0x6A, 0x26, 0xBA, 0x2E, 0x34, 0x6D, 2}
DEFINE_PROPERTYKEY!{PKEY_AppUserModel_ExcludeFromShowInNewInstall,
    0x9F4C2855, 0x9F79, 0x4B39, 0xA8, 0xD0, 0xE1, 0xD4, 0x2D, 0xE1, 0xD5, 0xF3, 8}
DEFINE_PROPERTYKEY!{PKEY_AppUserModel_ID,
    0x9F4C2855, 0x9F79, 0x4B39, 0xA8, 0xD0, 0xE1, 0xD4, 0x2D, 0xE1, 0xD5, 0xF3, 5}
DEFINE_PROPERTYKEY!{PKEY_AppUserModel_IsDestListSeparator,
    0x9F4C2855, 0x9F79, 0x4B39, 0xA8, 0xD0, 0xE1, 0xD4, 0x2D, 0xE1, 0xD5, 0xF3, 6}
DEFINE_PROPERTYKEY!{PKEY_AppUserModel_IsDualMode,
    0x9F4C2855, 0x9F79, 0x4B39, 0xA8, 0xD0, 0xE1, 0xD4, 0x2D, 0xE1, 0xD5, 0xF3, 11}
DEFINE_PROPERTYKEY!{PKEY_AppUserModel_PreventPinning,
    0x9F4C2855, 0x9F79, 0x4B39, 0xA8, 0xD0, 0xE1, 0xD4, 0x2D, 0xE1, 0xD5, 0xF3, 9}
DEFINE_PROPERTYKEY!{PKEY_AppUserModel_RelaunchCommand,
    0x9F4C2855, 0x9F79, 0x4B39, 0xA8, 0xD0, 0xE1, 0xD4, 0x2D, 0xE1, 0xD5, 0xF3, 2}
DEFINE_PROPERTYKEY!{PKEY_AppUserModel_RelaunchDisplayNameResource,
    0x9F4C2855, 0x9F79, 0x4B39, 0xA8, 0xD0, 0xE1, 0xD4, 0x2D, 0xE1, 0xD5, 0xF3, 4}
DEFINE_PROPERTYKEY!{PKEY_AppUserModel_RelaunchIconResource,
    0x9F4C2855, 0x9F79, 0x4B39, 0xA8, 0xD0, 0xE1, 0xD4, 0x2D, 0xE1, 0xD5, 0xF3, 3}
DEFINE_PROPERTYKEY!{PKEY_AppUserModel_StartPinOption,
    0x9F4C2855, 0x9F79, 0x4B39, 0xA8, 0xD0, 0xE1, 0xD4, 0x2D, 0xE1, 0xD5, 0xF3, 12}
pub const APPUSERMODEL_STARTPINOPTION_DEFAULT: DWORD = 0;
pub const APPUSERMODEL_STARTPINOPTION_NOPINONINSTALL: DWORD = 1;
pub const APPUSERMODEL_STARTPINOPTION_USERPINNED: DWORD = 2;
DEFINE_PROPERTYKEY!{PKEY_AppUserModel_ToastActivatorCLSID,
    0x9F4C2855, 0x9F79, 0x4B39, 0xA8, 0xD0, 0xE1, 0xD4, 0x2D, 0xE1, 0xD5, 0xF3, 26}
DEFINE_PROPERTYKEY!{PKEY_EdgeGesture_DisableTouchWhenFullscreen,
    0x32CE38B2, 0x2C9A, 0x41B1, 0x9B, 0xC5, 0xB3, 0x78, 0x43, 0x94, 0xAA, 0x44, 2}
DEFINE_PROPERTYKEY!{PKEY_Software_DateLastUsed,
    0x841E4F90, 0xFF59, 0x4D16, 0x89, 0x47, 0xE8, 0x1B, 0xBF, 0xFA, 0xB3, 0x6D, 16}
DEFINE_PROPERTYKEY!{PKEY_Software_ProductName,
    0x0CEF7D53, 0xFA64, 0x11D1, 0xA2, 0x03, 0x00, 0x00, 0xF8, 0x1F, 0xED, 0xEE, 7}
DEFINE_PROPERTYKEY!{PKEY_Sync_Comments,
    0x7BD5533E, 0xAF15, 0x44DB, 0xB8, 0xC8, 0xBD, 0x66, 0x24, 0xE1, 0xD0, 0x32, 13}
DEFINE_PROPERTYKEY!{PKEY_Sync_ConflictDescription,
    0xCE50C159, 0x2FB8, 0x41FD, 0xBE, 0x68, 0xD3, 0xE0, 0x42, 0xE2, 0x74, 0xBC, 4}
DEFINE_PROPERTYKEY!{PKEY_Sync_ConflictFirstLocation,
    0xCE50C159, 0x2FB8, 0x41FD, 0xBE, 0x68, 0xD3, 0xE0, 0x42, 0xE2, 0x74, 0xBC, 6}
DEFINE_PROPERTYKEY!{PKEY_Sync_ConflictSecondLocation,
    0xCE50C159, 0x2FB8, 0x41FD, 0xBE, 0x68, 0xD3, 0xE0, 0x42, 0xE2, 0x74, 0xBC, 7}
DEFINE_PROPERTYKEY!{PKEY_Sync_HandlerCollectionID,
    0x7BD5533E, 0xAF15, 0x44DB, 0xB8, 0xC8, 0xBD, 0x66, 0x24, 0xE1, 0xD0, 0x32, 2}
DEFINE_PROPERTYKEY!{PKEY_Sync_HandlerID,
    0x7BD5533E, 0xAF15, 0x44DB, 0xB8, 0xC8, 0xBD, 0x66, 0x24, 0xE1, 0xD0, 0x32, 3}
DEFINE_PROPERTYKEY!{PKEY_Sync_HandlerName,
    0xCE50C159, 0x2FB8, 0x41FD, 0xBE, 0x68, 0xD3, 0xE0, 0x42, 0xE2, 0x74, 0xBC, 2}
DEFINE_PROPERTYKEY!{PKEY_Sync_HandlerType,
    0x7BD5533E, 0xAF15, 0x44DB, 0xB8, 0xC8, 0xBD, 0x66, 0x24, 0xE1, 0xD0, 0x32, 8}
pub const SYNC_HANDLERTYPE_OTHER: DWORD = 0;
pub const SYNC_HANDLERTYPE_PROGRAMS: DWORD = 1;
pub const SYNC_HANDLERTYPE_DEVICES: DWORD = 2;
pub const SYNC_HANDLERTYPE_FOLDERS: DWORD = 3;
pub const SYNC_HANDLERTYPE_WEBSERVICES: DWORD = 4;
pub const SYNC_HANDLERTYPE_COMPUTERS: DWORD = 5;
DEFINE_PROPERTYKEY!{PKEY_Sync_HandlerTypeLabel,
    0x7BD5533E, 0xAF15, 0x44DB, 0xB8, 0xC8, 0xBD, 0x66, 0x24, 0xE1, 0xD0, 0x32, 9}
DEFINE_PROPERTYKEY!{PKEY_Sync_ItemID,
    0x7BD5533E, 0xAF15, 0x44DB, 0xB8, 0xC8, 0xBD, 0x66, 0x24, 0xE1, 0xD0, 0x32, 6}
DEFINE_PROPERTYKEY!{PKEY_Sync_ItemName,
    0xCE50C159, 0x2FB8, 0x41FD, 0xBE, 0x68, 0xD3, 0xE0, 0x42, 0xE2, 0x74, 0xBC, 3}
DEFINE_PROPERTYKEY!{PKEY_Sync_ProgressPercentage,
    0x7BD5533E, 0xAF15, 0x44DB, 0xB8, 0xC8, 0xBD, 0x66, 0x24, 0xE1, 0xD0, 0x32, 23}
DEFINE_PROPERTYKEY!{PKEY_Sync_State,
    0x7BD5533E, 0xAF15, 0x44DB, 0xB8, 0xC8, 0xBD, 0x66, 0x24, 0xE1, 0xD0, 0x32, 24}
pub const SYNC_STATE_NOTSETUP: DWORD = 0;
pub const SYNC_STATE_SYNCNOTRUN: DWORD = 1;
pub const SYNC_STATE_IDLE: DWORD = 2;
pub const SYNC_STATE_ERROR: DWORD = 3;
pub const SYNC_STATE_PENDING: DWORD = 4;
pub const SYNC_STATE_SYNCING: DWORD = 5;
DEFINE_PROPERTYKEY!{PKEY_Sync_Status,
    0x7BD5533E, 0xAF15, 0x44DB, 0xB8, 0xC8, 0xBD, 0x66, 0x24, 0xE1, 0xD0, 0x32, 10}
DEFINE_PROPERTYKEY!{PKEY_Task_BillingInformation,
    0xD37D52C6, 0x261C, 0x4303, 0x82, 0xB3, 0x08, 0xB9, 0x26, 0xAC, 0x6F, 0x12, 100}
DEFINE_PROPERTYKEY!{PKEY_Task_CompletionStatus,
    0x084D8A0A, 0xE6D5, 0x40DE, 0xBF, 0x1F, 0xC8, 0x82, 0x0E, 0x7C, 0x87, 0x7C, 100}
DEFINE_PROPERTYKEY!{PKEY_Task_Owner,
    0x08C7CC5F, 0x60F2, 0x4494, 0xAD, 0x75, 0x55, 0xE3, 0xE0, 0xB5, 0xAD, 0xD0, 100}
DEFINE_PROPERTYKEY!{PKEY_Video_Compression,
    0x64440491, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 10}
DEFINE_PROPERTYKEY!{PKEY_Video_Director,
    0x64440492, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 20}
DEFINE_PROPERTYKEY!{PKEY_Video_EncodingBitrate,
    0x64440491, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 8}
DEFINE_PROPERTYKEY!{PKEY_Video_FourCC,
    0x64440491, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 44}
DEFINE_PROPERTYKEY!{PKEY_Video_FrameHeight,
    0x64440491, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 4}
DEFINE_PROPERTYKEY!{PKEY_Video_FrameRate,
    0x64440491, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 6}
DEFINE_PROPERTYKEY!{PKEY_Video_FrameWidth,
    0x64440491, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 3}
DEFINE_PROPERTYKEY!{PKEY_Video_HorizontalAspectRatio,
    0x64440491, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 42}
DEFINE_PROPERTYKEY!{PKEY_Video_IsSpherical,
    0x64440491, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 100}
DEFINE_PROPERTYKEY!{PKEY_Video_IsStereo,
    0x64440491, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 98}
DEFINE_PROPERTYKEY!{PKEY_Video_Orientation,
    0x64440491, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 99}
DEFINE_PROPERTYKEY!{PKEY_Video_SampleSize,
    0x64440491, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 9}
DEFINE_PROPERTYKEY!{PKEY_Video_StreamName,
    0x64440491, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 2}
DEFINE_PROPERTYKEY!{PKEY_Video_StreamNumber,
    0x64440491, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 11}
DEFINE_PROPERTYKEY!{PKEY_Video_TotalBitrate,
    0x64440491, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 43}
DEFINE_PROPERTYKEY!{PKEY_Video_TranscodedForSync,
    0x64440491, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 46}
DEFINE_PROPERTYKEY!{PKEY_Video_VerticalAspectRatio,
    0x64440491, 0x4C8B, 0x11D1, 0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03, 45}
DEFINE_PROPERTYKEY!{PKEY_Volume_FileSystem,
    0x9B174B35, 0x40FF, 0x11D2, 0xA2, 0x7E, 0x00, 0xC0, 0x4F, 0xC3, 0x08, 0x71, 4}
DEFINE_PROPERTYKEY!{PKEY_Volume_IsMappedDrive,
    0x149C0B69, 0x2C2D, 0x48FC, 0x80, 0x8F, 0xD3, 0x18, 0xD7, 0x8C, 0x46, 0x36, 2}
DEFINE_PROPERTYKEY!{PKEY_Volume_IsRoot,
    0x9B174B35, 0x40FF, 0x11D2, 0xA2, 0x7E, 0x00, 0xC0, 0x4F, 0xC3, 0x08, 0x71, 10}
