/*
 * Copyright (C) Internet Systems Consortium, Inc. ("ISC")
 *
 * SPDX-License-Identifier: MPL-2.0
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, you can obtain one at https://mozilla.org/MPL/2.0/.
 *
 * See the COPYRIGHT file distributed with this work for additional
 * information regarding copyright ownership.
 */

#pragma once

/*! \file */

#include <isc/log.h>
#include <isc/types.h>

#include <named/globals.h> /* Required for named_g_(categories|modules). */

isc_result_t
named_log_init(bool safe);
/*%
 * Initialize the logging system and set up an initial default
 * logging default configuration that will be used until the
 * config file has been read.
 *
 * If 'safe' is true, use a default configuration that refrains
 * from opening files.  This is to avoid creating log files
 * as root.
 */

void
named_log_setdefaultchannels(isc_logconfig_t *lcfg);
/*%
 * Set up logging channels according to the named defaults, which
 * may differ from the logging library defaults.  Currently,
 * this just means setting up default_debug.
 */

void
named_log_setsafechannels(isc_logconfig_t *lcfg);
/*%
 * Like named_log_setdefaultchannels(), but omits any logging to files.
 */

void
named_log_setdefaultsslkeylogfile(isc_logconfig_t *lcfg);
/*%
 * If the SSLKEYLOGFILE environment variable is set, sets up a default
 * logging channel for writing TLS pre-master secrets to the path stored
 * in that environment variable (for debugging purposes).
 */

isc_result_t
named_log_setdefaultcategory(isc_logconfig_t *lcfg);
/*%
 * Set up "category default" to go to the right places.
 */

isc_result_t
named_log_setunmatchedcategory(isc_logconfig_t *lcfg);
/*%
 * Set up "category unmatched" to go to the right places.
 */
