/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.binpack;

import com.kreative.binpack.BitInputStream;
import com.kreative.binpack.BitOutputStream;
import com.kreative.binpack.DFExpression;
import java.util.Map;

public class DFBinaryExpression
implements DFExpression {
    private Operation op;
    private DFExpression left;
    private DFExpression right;

    public DFBinaryExpression(Operation op, DFExpression left, DFExpression right) {
        this.op = op;
        this.left = left;
        this.right = right;
    }

    @Override
    public int evaluate() {
        switch (this.op) {
            case BOOLEAN_OR: {
                return this.left.evaluate() != 0 || this.right.evaluate() != 0 ? 1 : 0;
            }
            case BOOLEAN_XOR: {
                return this.left.evaluate() != 0 != (this.right.evaluate() != 0) ? 1 : 0;
            }
            case BOOLEAN_AND: {
                return this.left.evaluate() != 0 && this.right.evaluate() != 0 ? 1 : 0;
            }
            case BOOLEAN_EQUAL: {
                return this.left.evaluate() != 0 == (this.right.evaluate() != 0) ? 1 : 0;
            }
            case EQUAL: {
                return this.left.evaluate() == this.right.evaluate() ? 1 : 0;
            }
            case NOT_EQUAL: {
                return this.left.evaluate() != this.right.evaluate() ? 1 : 0;
            }
            case COMPARE: {
                int cl = this.left.evaluate();
                int cr = this.right.evaluate();
                return cl < cr ? -1 : (cl > cr ? 1 : 0);
            }
            case LESS_THAN: {
                return this.left.evaluate() < this.right.evaluate() ? 1 : 0;
            }
            case LESS_OR_EQUAL: {
                return this.left.evaluate() <= this.right.evaluate() ? 1 : 0;
            }
            case GREATER_THAN: {
                return this.left.evaluate() > this.right.evaluate() ? 1 : 0;
            }
            case GREATER_OR_EQUAL: {
                return this.left.evaluate() >= this.right.evaluate() ? 1 : 0;
            }
            case BITWISE_OR: {
                return this.left.evaluate() | this.right.evaluate();
            }
            case BITWISE_XOR: {
                return this.left.evaluate() ^ this.right.evaluate();
            }
            case BITWISE_AND: {
                return this.left.evaluate() & this.right.evaluate();
            }
            case SHIFT_LEFT: {
                return this.left.evaluate() << this.right.evaluate();
            }
            case SHIFT_RIGHT: {
                return this.left.evaluate() >> this.right.evaluate();
            }
            case UNSIGNED_SHIFT_RIGHT: {
                return this.left.evaluate() >>> this.right.evaluate();
            }
            case ADD: {
                return this.left.evaluate() + this.right.evaluate();
            }
            case SUBTRACT: {
                return this.left.evaluate() - this.right.evaluate();
            }
            case MULTIPLY: {
                return this.left.evaluate() * this.right.evaluate();
            }
            case DIVIDE: {
                return this.left.evaluate() / this.right.evaluate();
            }
            case MOD: {
                return this.left.evaluate() % this.right.evaluate();
            }
        }
        return 0;
    }

    @Override
    public int evaluate(Map<?, ?> fieldValues, BitInputStream in, long length) {
        switch (this.op) {
            case BOOLEAN_OR: {
                return this.left.evaluate(fieldValues, in, length) != 0 || this.right.evaluate(fieldValues, in, length) != 0 ? 1 : 0;
            }
            case BOOLEAN_XOR: {
                return this.left.evaluate(fieldValues, in, length) != 0 != (this.right.evaluate(fieldValues, in, length) != 0) ? 1 : 0;
            }
            case BOOLEAN_AND: {
                return this.left.evaluate(fieldValues, in, length) != 0 && this.right.evaluate(fieldValues, in, length) != 0 ? 1 : 0;
            }
            case BOOLEAN_EQUAL: {
                return this.left.evaluate(fieldValues, in, length) != 0 == (this.right.evaluate(fieldValues, in, length) != 0) ? 1 : 0;
            }
            case EQUAL: {
                return this.left.evaluate(fieldValues, in, length) == this.right.evaluate(fieldValues, in, length) ? 1 : 0;
            }
            case NOT_EQUAL: {
                return this.left.evaluate(fieldValues, in, length) != this.right.evaluate(fieldValues, in, length) ? 1 : 0;
            }
            case COMPARE: {
                int cl = this.left.evaluate(fieldValues, in, length);
                int cr = this.right.evaluate(fieldValues, in, length);
                return cl < cr ? -1 : (cl > cr ? 1 : 0);
            }
            case LESS_THAN: {
                return this.left.evaluate(fieldValues, in, length) < this.right.evaluate(fieldValues, in, length) ? 1 : 0;
            }
            case LESS_OR_EQUAL: {
                return this.left.evaluate(fieldValues, in, length) <= this.right.evaluate(fieldValues, in, length) ? 1 : 0;
            }
            case GREATER_THAN: {
                return this.left.evaluate(fieldValues, in, length) > this.right.evaluate(fieldValues, in, length) ? 1 : 0;
            }
            case GREATER_OR_EQUAL: {
                return this.left.evaluate(fieldValues, in, length) >= this.right.evaluate(fieldValues, in, length) ? 1 : 0;
            }
            case BITWISE_OR: {
                return this.left.evaluate(fieldValues, in, length) | this.right.evaluate(fieldValues, in, length);
            }
            case BITWISE_XOR: {
                return this.left.evaluate(fieldValues, in, length) ^ this.right.evaluate(fieldValues, in, length);
            }
            case BITWISE_AND: {
                return this.left.evaluate(fieldValues, in, length) & this.right.evaluate(fieldValues, in, length);
            }
            case SHIFT_LEFT: {
                return this.left.evaluate(fieldValues, in, length) << this.right.evaluate(fieldValues, in, length);
            }
            case SHIFT_RIGHT: {
                return this.left.evaluate(fieldValues, in, length) >> this.right.evaluate(fieldValues, in, length);
            }
            case UNSIGNED_SHIFT_RIGHT: {
                return this.left.evaluate(fieldValues, in, length) >>> this.right.evaluate(fieldValues, in, length);
            }
            case ADD: {
                return this.left.evaluate(fieldValues, in, length) + this.right.evaluate(fieldValues, in, length);
            }
            case SUBTRACT: {
                return this.left.evaluate(fieldValues, in, length) - this.right.evaluate(fieldValues, in, length);
            }
            case MULTIPLY: {
                return this.left.evaluate(fieldValues, in, length) * this.right.evaluate(fieldValues, in, length);
            }
            case DIVIDE: {
                return this.left.evaluate(fieldValues, in, length) / this.right.evaluate(fieldValues, in, length);
            }
            case MOD: {
                return this.left.evaluate(fieldValues, in, length) % this.right.evaluate(fieldValues, in, length);
            }
        }
        return 0;
    }

    @Override
    public int evaluate(Map<?, ?> fieldValues, BitOutputStream out) {
        switch (this.op) {
            case BOOLEAN_OR: {
                return this.left.evaluate(fieldValues, out) != 0 || this.right.evaluate(fieldValues, out) != 0 ? 1 : 0;
            }
            case BOOLEAN_XOR: {
                return this.left.evaluate(fieldValues, out) != 0 != (this.right.evaluate(fieldValues, out) != 0) ? 1 : 0;
            }
            case BOOLEAN_AND: {
                return this.left.evaluate(fieldValues, out) != 0 && this.right.evaluate(fieldValues, out) != 0 ? 1 : 0;
            }
            case BOOLEAN_EQUAL: {
                return this.left.evaluate(fieldValues, out) != 0 == (this.right.evaluate(fieldValues, out) != 0) ? 1 : 0;
            }
            case EQUAL: {
                return this.left.evaluate(fieldValues, out) == this.right.evaluate(fieldValues, out) ? 1 : 0;
            }
            case NOT_EQUAL: {
                return this.left.evaluate(fieldValues, out) != this.right.evaluate(fieldValues, out) ? 1 : 0;
            }
            case COMPARE: {
                int cl = this.left.evaluate(fieldValues, out);
                int cr = this.right.evaluate(fieldValues, out);
                return cl < cr ? -1 : (cl > cr ? 1 : 0);
            }
            case LESS_THAN: {
                return this.left.evaluate(fieldValues, out) < this.right.evaluate(fieldValues, out) ? 1 : 0;
            }
            case LESS_OR_EQUAL: {
                return this.left.evaluate(fieldValues, out) <= this.right.evaluate(fieldValues, out) ? 1 : 0;
            }
            case GREATER_THAN: {
                return this.left.evaluate(fieldValues, out) > this.right.evaluate(fieldValues, out) ? 1 : 0;
            }
            case GREATER_OR_EQUAL: {
                return this.left.evaluate(fieldValues, out) >= this.right.evaluate(fieldValues, out) ? 1 : 0;
            }
            case BITWISE_OR: {
                return this.left.evaluate(fieldValues, out) | this.right.evaluate(fieldValues, out);
            }
            case BITWISE_XOR: {
                return this.left.evaluate(fieldValues, out) ^ this.right.evaluate(fieldValues, out);
            }
            case BITWISE_AND: {
                return this.left.evaluate(fieldValues, out) & this.right.evaluate(fieldValues, out);
            }
            case SHIFT_LEFT: {
                return this.left.evaluate(fieldValues, out) << this.right.evaluate(fieldValues, out);
            }
            case SHIFT_RIGHT: {
                return this.left.evaluate(fieldValues, out) >> this.right.evaluate(fieldValues, out);
            }
            case UNSIGNED_SHIFT_RIGHT: {
                return this.left.evaluate(fieldValues, out) >>> this.right.evaluate(fieldValues, out);
            }
            case ADD: {
                return this.left.evaluate(fieldValues, out) + this.right.evaluate(fieldValues, out);
            }
            case SUBTRACT: {
                return this.left.evaluate(fieldValues, out) - this.right.evaluate(fieldValues, out);
            }
            case MULTIPLY: {
                return this.left.evaluate(fieldValues, out) * this.right.evaluate(fieldValues, out);
            }
            case DIVIDE: {
                return this.left.evaluate(fieldValues, out) / this.right.evaluate(fieldValues, out);
            }
            case MOD: {
                return this.left.evaluate(fieldValues, out) % this.right.evaluate(fieldValues, out);
            }
        }
        return 0;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("(");
        s.append(this.left.toString());
        switch (this.op) {
            case BOOLEAN_OR: {
                s.append("||");
                break;
            }
            case BOOLEAN_XOR: {
                s.append("^^");
                break;
            }
            case BOOLEAN_AND: {
                s.append("&&");
                break;
            }
            case EQUAL: {
                s.append("==");
                break;
            }
            case NOT_EQUAL: {
                s.append("!=");
                break;
            }
            case COMPARE: {
                s.append("<=>");
                break;
            }
            case LESS_THAN: {
                s.append("<");
                break;
            }
            case LESS_OR_EQUAL: {
                s.append("<=");
                break;
            }
            case GREATER_THAN: {
                s.append(">");
                break;
            }
            case GREATER_OR_EQUAL: {
                s.append(">=");
                break;
            }
            case BITWISE_OR: {
                s.append("|");
                break;
            }
            case BITWISE_XOR: {
                s.append("^");
                break;
            }
            case BITWISE_AND: {
                s.append("&");
                break;
            }
            case SHIFT_LEFT: {
                s.append("<<");
                break;
            }
            case SHIFT_RIGHT: {
                s.append(">>");
                break;
            }
            case UNSIGNED_SHIFT_RIGHT: {
                s.append(">>>");
                break;
            }
            case ADD: {
                s.append("+");
                break;
            }
            case SUBTRACT: {
                s.append("-");
                break;
            }
            case MULTIPLY: {
                s.append("*");
                break;
            }
            case DIVIDE: {
                s.append("/");
                break;
            }
            case MOD: {
                s.append("%");
                break;
            }
            default: {
                s.append("<" + this.op.name().toLowerCase() + ">");
            }
        }
        s.append(this.right.toString());
        s.append(")");
        return s.toString();
    }

    public static enum Operation {
        BOOLEAN_OR,
        BOOLEAN_XOR,
        BOOLEAN_AND,
        BOOLEAN_EQUAL,
        EQUAL,
        NOT_EQUAL,
        COMPARE,
        LESS_THAN,
        LESS_OR_EQUAL,
        GREATER_THAN,
        GREATER_OR_EQUAL,
        BITWISE_OR,
        BITWISE_XOR,
        BITWISE_AND,
        SHIFT_LEFT,
        SHIFT_RIGHT,
        UNSIGNED_SHIFT_RIGHT,
        ADD,
        SUBTRACT,
        MULTIPLY,
        DIVIDE,
        MOD;

    }
}

