{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetAxisOfRotation: TVector3;
    procedure SetAxisOfRotation(const Value: TVector3);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdAxisOfRotation: TSFVec3f;
    { Internal wrapper for property @code(AxisOfRotation). This wrapper API may change, we advise to access simpler @code(AxisOfRotation) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdAxisOfRotation: TSFVec3f read FFdAxisOfRotation;
    { Axis around which the billboard rotates to face the camera. Can be zero to rotate freely. }
    property AxisOfRotation: TVector3 read GetAxisOfRotation write SetAxisOfRotation;

{$endif read_interface}

{$ifdef read_implementation}

{ TBillboardNode ----------------------------------------------- }

function TBillboardNode.GetAxisOfRotation: TVector3;
begin
  Result := FdAxisOfRotation.Value;
end;

procedure TBillboardNode.SetAxisOfRotation(const Value: TVector3);
begin
  FdAxisOfRotation.Send(Value);
end;

class function TBillboardNode.ClassX3DType: String;
begin
  Result := 'Billboard';
end;

procedure TBillboardNode.CreateNode;
begin
  inherited;

  FFdAxisOfRotation := TSFVec3f.Create(Self, True, 'axisOfRotation', Vector3(0, 1, 0));
   FdAxisOfRotation.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdAxisOfRotation);
end;

{$endif read_implementation}
