{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdImage: TMFInt32;
    { Internal wrapper for property @code(Image). This wrapper API may change, we advise to access simpler @code(Image) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdImage: TMFInt32 read FFdImage;
    {  }
    procedure SetImage(const Value: array of Int32); overload;
    {  }
    procedure SetImage(const Value: TInt32List); overload;

{$endif read_interface}

{$ifdef read_implementation}

{ TPixelTexture3DNode ----------------------------------------------- }

procedure TPixelTexture3DNode.SetImage(const Value: array of Int32);
begin
  FdImage.Send(Value);
end;

procedure TPixelTexture3DNode.SetImage(const Value: TInt32List);
begin
  FdImage.Send(Value);
end;

class function TPixelTexture3DNode.ClassX3DType: String;
begin
  Result := 'PixelTexture3D';
end;

procedure TPixelTexture3DNode.CreateNode;
begin
  inherited;

  FFdImage := TMFInt32.Create(Self, True, 'image', [0, 0, 0, 0]);
   FdImage.ChangeAlways := chTextureImage;
  AddField(FFdImage);
end;

{$endif read_implementation}
