static const boost::array<boost::array<T, 3>, 198> factorials = {
   SC_(1), SC_(1), SC_(0),
   SC_(2), SC_(1), SC_(0),
   SC_(3), SC_(2), SC_(0.69314718055994530941723212145817656807550013436025525412068000949339362196969471560586332699641868754200148102),
   SC_(4), SC_(6), SC_(1.7917594692280550008124773583807022727229906921830047058553743431308879151883036824794790818101507763299715101),
   SC_(5), SC_(24), SC_(3.1780538303479456196469416012970554088739909609035152140967343621176751591276931136912057358029881514139744721),
   SC_(6), SC_(120), SC_(4.7874917427820459942477009345232430483995923151720329360093822535918541468353508783213396138961677622139407751),
   SC_(7), SC_(720), SC_(6.5792512120101009950601782929039453211225830073550376418647565967227420620236545608008186957063185385439122852),
   SC_(8), SC_(5040), SC_(8.5251613610654143001655310363471250507596677369368988303241467466603219247757238285884771942941900655369739794),
   SC_(9), SC_(40320), SC_(10.604602902745250228417227400721654754986168140017664592686186775140502790684807975406067175283446128162978423),
   SC_(10), SC_(362880), SC_(12.801827480081469611207717874566706164281149255663163496155575442415491377122025909153298684910910305738918481),
   SC_(11), SC_(3628800), SC_(15.104412573075515295225709329251070371882250744291936472188903343383063986799378389389295890000508604080886265),
   SC_(12), SC_(39916800), SC_(17.502307845873885839287652907216199671703957598229353647407471052513637610712615102464350598003143395495601991),
   SC_(13), SC_(479001600), SC_(19.987214495661886149517362387055078512502448424772613607383525405137919147870613500549693006809712859367574982),
   SC_(14), SC_(6227020800), SC_(22.552163853123422885570849828620397117307716369532820723802570915801383815195023679949267670250202348136833174),
   SC_(15), SC_(87178291200), SC_(25.191221182738681500093434693521753415020301233474937166382641075232357299916787663342789495834492562671896349),
   SC_(16), SC_(1307674368000), SC_(27.899271383840891566089439263670466759193393145566204340029983300344030580843054394846539128741404262259832681),
   SC_(17), SC_(20922789888000), SC_(30.671860106080672803758367749503173031495393683007225356512703338317605068721833257269992436727079012427838605),
   SC_(18), SC_(355687428096000), SC_(33.505073450136888884007902367376299567083596695592970143809941076199897644522764538182087304764581959946186867),
   SC_(19), SC_(6402373705728000), SC_(36.395445208033053576215624962679527544454077945598724301400009752968279852929677187535182141388464825064128406),
   SC_(20), SC_(121645100408832000), SC_(39.33988418719949403622465239456738108169145720689785311993796998937757255499387447624934052520420472086116904),
   SC_(21), SC_(2432902008176640000), SC_(42.335616460753485029659875970709921857368058829886881350091977899838538786640921672091201057290221706745138305),
   SC_(22), SC_(51090942171709440000), SC_(45.380138898476908026160473951075627291652634117291491990286062383413612942611599906752475310691825322526170028),
   SC_(23), SC_(1124000727777607680000), SC_(48.471181351835223879639649650498933159549841105589164419625310102037580188494531335433393345690878801482887235),
   SC_(24), SC_(25852016738884976640000), SC_(51.606675567764373570446402482309129277992221420429600161623945479520573434479329633631794437843873615837084448),
   SC_(25), SC_(620448401733239439360000), SC_(54.784729398112319190093344083606184686866212381333115375720679841638248593607022747323000173646861767251058921),
   SC_(26), SC_(15511210043330985984000000), SC_(58.003605222980519939294862750058559965917415089870150819545975624586606569022338276583267929833220988850991527),
   SC_(27), SC_(403291461126605635584000000), SC_(61.2617017610020019847655823130820551387981831689906131900857011447434648583164431715887059202701291651622512),
   SC_(28), SC_(10888869450418352160768000000), SC_(64.557538627006331058951318023849632252740654842458861545289784145655947737972270072209553184711325431526161287),
   SC_(29), SC_(304888344611713860501504000000), SC_(67.889743137181534982891135010209165118528739840761233241990534314580314844663728771208938337292034333603225943),
   SC_(30), SC_(8841761993739701954543616000000), SC_(71.257038967168009010074407042571076724023252754683977320912204666223095625801581104502305452109890756249225528),
   SC_(31), SC_(265252859812191058636308480000000), SC_(74.658236348830164385487643734177966636271844801135499748680226900828162528697542551611918412013221143379163341),
   SC_(32), SC_(8222838654177922817725562880000000), SC_(78.092223553315310631416808058720323846721783731616091720436944973303143945295093783825783243349307773952140278),
   SC_(33), SC_(263130836933693530167218012160000000), SC_(81.557959456115037178502968666011206687099284403417367991040345020770112055143567361855099878331401211662147683),
   SC_(34), SC_(8683317618811886495518194401280000000), SC_(85.054467017581517413960157480898861691568481815177534617993607063538179972275413041803770341147768091864833438),
   SC_(35), SC_(295232799039604140847618609643520000000), SC_(88.580827542197678803626924220230164795232184962123534659411524810913866170046039038321728536181689726925183181),
   SC_(36), SC_(10333147966386144929666651337523200000000), SC_(92.136175603687092483333036296899532164394871045973913569783562852325625020505766070739520912862740864718211178),
   SC_(37), SC_(371993326789901217467999448150835200000000), SC_(95.719694542143202484957991013660936709840852430339922981494311538587400850882373435698479076483042417378154198),
   SC_(38), SC_(13763753091226345046315979581580902400000000), SC_(99.330612454787426929326086684692383873740930017507559145139224219780390597872734501097500610155211078159963151),
   SC_(39), SC_(523022617466601111760007224100074291200000000), SC_(102.96819861451381269875234623803841397905380941316694321779786446568307692190662650541752232096736966149900526),
   SC_(40), SC_(20397882081197443358640281739902897356800000000), SC_(106.63176026064345912620107891652625828850656791574989978595160430998403588244964565169071273922159123905623349),
   SC_(41), SC_(815915283247897734345611269596115894272000000000), SC_(110.32063971475739542905353461412697563225866967309918327022629222993839573606638756313843659830402691248220423),
   SC_(42), SC_(33452526613163807108170062053440751665152000000000), SC_(114.03421178146170323292029798716438322063508014249848490384555514019837435247204506910075373967601372352019472),
   SC_(43), SC_(1405006117752879898543142606244511569936384000000000), SC_(117.77188139974507153883812808898826522299515556426335079816031963326684213041241801936789132007403602684322793),
   SC_(44), SC_(60415263063373835637355132068513997507264512000000000), SC_(121.53308151543863396231097060233411225855429174914490621335200489818970130428540445790548331815803331374073361),
   SC_(45), SC_(2658271574788448768043625811014615890319638528000000000), SC_(125.31727114935689512520737842321559469452699887180283389681193262630706217213803060219226468015350548023945229),
   SC_(46), SC_(119622220865480194561963161495657715064383733760000000000), SC_(129.12393363912721488259862823028683374334758134171685052219396918505622974628290630056963006787414926861535866),
   SC_(47), SC_(5502622159812088949850305428800254892961651752960000000000), SC_(132.95257503561630988282261318355520642986546179091754151831328457203261661423739931437389448702356277051155735),
   SC_(48), SC_(258623241511168180642964355153611979969197632389120000000000), SC_(136.80272263732636846964356385332738013876151229293776555151379291883943482774320038698458424045830875146800892),
   SC_(49), SC_(12413915592536072670862289047373375038521486354677760000000000), SC_(140.67392364823425939870773757608261211571100338820153601973120729045050360884058821628165330325771559042398488),
   SC_(50), SC_(608281864034267560872252163321295376887552831379210240000000000), SC_(144.56574394634488600891844306296897157498517284736525839664998759032566333434472675185697030043345864441010827),
   SC_(51), SC_(30414093201713378043612608166064768844377641568960512000000000000), SC_(148.47776695177303206753719385087952342211187569026254909459596338276741493172973699672310138361623655355204235),
   SC_(52), SC_(1551118753287382280224243016469303211063259720016986112000000000000), SC_(152.40959258449735783918197370567517566234756926067104333362789545428720180074927724450881200646747158985836064),
   SC_(53), SC_(80658175170943878571660636856403766975289505440883277824000000000000), SC_(156.3608363030787851940699253901568474033038374741517609582883009839374537120130768551201133239007984537116218),
   SC_(54), SC_(4274883284060025564298013753389399649690343788366813724672000000000000), SC_(160.33112821663090702821439452918590517366381522706297856133643045395545834595656671365477326838671968355373562),
   SC_(55), SC_(230843697339241380472092742683027581083278564571807941132288000000000000), SC_(164.32011226319518141181736236141165885568178703489148217066119346436133484758208832988148385982433463745964719),
   SC_(56), SC_(12696403353658275925965100847566516959580321051449436762275840000000000000), SC_(168.32744544842765233048006527260297579502909524309741706779240906496608745920298280758667244592014903967432922),
   SC_(57), SC_(710998587804863451854045647463724949736497978881168458687447040000000000000), SC_(172.35279713916280156383711438042068522889268037576004401861383924338384818786413622219192092549727662929339535),
   SC_(58), SC_(40526919504877216755680601905432322134980384796226602145184481280000000000000), SC_(176.39584840699735171524138704923106447077755019488192228888649381343063518314694247777969506412674861387840601),
   SC_(59), SC_(2350561331282878571829474910515074683828862318181142924420699914240000000000000), SC_(180.45629141754377105184189120305115264434756324316492162192884417456680958625448952667892550594102372406640708),
   SC_(60), SC_(138683118545689835737939019720389406345902876772687432540821294940160000000000000), SC_(184.53382886144949050245794157677085026841091003249537615144088087162600970051991700403826546574365749307685096),
   SC_(61), SC_(8320987112741390144276341183223364380754172606361245952449277696409600000000000000), SC_(188.62817342367159118728841038983591674873500221330715383332958311572447022538557316675374175264340656774879025),
   SC_(62), SC_(507580213877224798800856812176625227226004528988036003099405939480985600000000000000), SC_(192.73904728784490243603979949326153149505068395638841489626696676214391003223052189793917095874351034077226315),
   SC_(63), SC_(31469973260387937525653122354950764088012280797258232192163168247821107200000000000000), SC_(196.86618167288999399138619593926206527357612302122926212214436484411228507079776784575889911707601565888724156),
   SC_(64), SC_(1982608315404440064116146708361898137544773690227268628106279599612729753600000000000000), SC_(201.00931639928152667928203915655029641250818886645662221407314366132485351998705504729378912529135136345624332),
   SC_(65), SC_(126886932185884164103433389335161480802865516174545192198801894375214704230400000000000000), SC_(205.1681994826411985357854318852993558209611896726181537387972237182852152518052233409289690872698634887082522),
   SC_(66), SC_(8247650592082470666723170306785496252186258551345437492922123134388955774976000000000000000), SC_(209.3425867525368356464396786600908620652920589716468785771289171204228589068372912849586776288035325882774767),
   SC_(67), SC_(544344939077443064003729240247842752644293064388798874532860126869671081148416000000000000000), SC_(213.53224149456326119131409959643669363783675651776730045820285917268432044593883168051321141861631815602216393),
   SC_(68), SC_(36471110918188685288249859096605464427167635314049524593701628500267962436943872000000000000000), SC_(217.73693411395422725098417159280041638840368942098919579534064330345958895146691857715212560643734364055612613),
   SC_(69), SC_(2480035542436830599600990418569171581047399201355367672371710738018221445712183296000000000000000), SC_(221.95644181913033395006817045358989606014289270229545109087924106032866877120723928927594712846768396315847735),
   SC_(70), SC_(171122452428141311372468338881272839092270544893520369393648040923257279754140647424000000000000000), SC_(226.19054832372759333227016852232261788323276357495863628461257077144915631041064655434796397543441086630064459),
   SC_(71), SC_(11978571669969891796072783721689098736458938142546425857555362864628009582789845319680000000000000000), SC_(230.43904356577695232139351272045016182047094979316927044910528882235430878284006830237161967911188069163567407),
   SC_(72), SC_(850478588567862317521167644239926010288584608120796235886430763388588680378079017697280000000000000000), SC_(234.70172344281826774272296725296319591723052631987983655722671462438166028966429866833786300338451582517662042),
   SC_(73), SC_(61234458376886086861524070385274672740778091784697328983823014963978384987221689274204160000000000000000), SC_(238.97838956183432305376515409118277703075200783860610122305814332013682974201060074890268449400123606537856492),
   SC_(74), SC_(4470115461512684340891257138125051110076800700282905015819080092370422104067183317016903680000000000000000), SC_(243.26884900298271418285726294862131960165676068347769888765384217729861971793119804217901381683609495963259635),
   SC_(75), SC_(330788544151938641225953028221253782145683251820934971170611926835411235700971565459250872320000000000000000), SC_(247.57291409618688393664259074111094333363233840500559030541943486798500308689125382318389867750468230795640678),
   SC_(76), SC_(24809140811395398091946477116594033660926243886570122837795894512655842677572867409443815424000000000000000000), SC_(251.89040220972319437723935464448584431733103167136537520097942498457085535552517831931778218850477361834430941),
   SC_(77), SC_(1.885494701666050254987932260861146558230394535379329335672487982961844043495537923117729972224e+111), SC_(256.22113555000952545608284631929005099071941120138501452775874523996693530152876503924366722631335088922535301),
   SC_(78), SC_(1.45183092028285869634070784086308284983740379224208358846781574688061991349156420080065207861248e+113), SC_(260.56494097186320930525014264069836002017820278490429289143670309903508878819407102010638043290385720763313043),
   SC_(79), SC_(1.1324281178206297831457521158732046228731749579488251990048962825668835325234200766245086213177344e+115), SC_(264.92164979855280104211610744064438089770646142184750471371112295282944137070678488198543417815449747273236013),
   SC_(80), SC_(8.94618213078297528685144171539831652069808216779571907213868063227837990693501860533361810841010176e+116), SC_(269.29109765101982253628905298212579181988000264627011433912329407038924743183121716013137454392857707937066295),
   SC_(81), SC_(7.156945704626380229481153372318653216558465734236575257710944505822703925548014884266894486728081408e+118), SC_(273.67312428569370414855874080118468573170760453797965307751866199983700090741765378718496173000743144033863518),
   SC_(82), SC_(5.79712602074736798587973423157810910541235724473162595874586504971639017969389205625618453424974594048e+120), SC_(278.06757344036614291413972174887478855029756676927065088445743933438697808029208965467942474926235979549051529),
   SC_(83), SC_(4.7536433370128417484213820698940494664381329406799332861716093407674399473489914861300713180847916711936e+122), SC_(282.47429268763039602742371724337037270674947737303020777219738225414035031866744187624760521763076529407050726),
   SC_(84), SC_(3.945523969720658651189747118012061057143650340764344627522435752836975156299662933487959194010377087090688e+124), SC_(286.89313329542699395089918946666174315977879042969344414238532571707892930855643248208603251460133872829846),
   SC_(85), SC_(3.31424013456535326699938757913013128800066628624204948711884603238305913129171686412988572296871675315617792e+126), SC_(291.32395009427030756623425168994380173021436598581856529082077021964079070846650014795903342199577971916349469),
   SC_(86), SC_(2.817104114380550276949479442260611594800566343305742064051019127525600261597959334510402864523409240182751232e+128), SC_(295.76660135076062402108454564104311590532817035267282780003065584899726227197508919350126216812646227748180925),
   SC_(87), SC_(2.4227095383672732381765523203441259715284870552429381750838764496720162249742450276789464634901319465571660595e+130), SC_(300.22094864701413175397462027584713950896280667191463846934302112341351506781777034764471749320687825192131641),
   SC_(88), SC_(2.1077572983795277172136005186993895952297837380613562123229725112146541157275931740806834232364147935047344718e+132), SC_(304.68685676566871547255313754513157681910481014366013199999938580869379014217423164781170036283846676335528603),
   SC_(89), SC_(1.8548264225739843911479684564554628438022096894939934668442158098688956218402819931910014124480450182841663352e+134), SC_(309.1641935801469219448667774874712358231530174006783149375799935463045446319965525077043450518303576173960062),
   SC_(90), SC_(1.6507955160908461081216919262453619309839666236496541854913520707833171034378509739399912570787600662729080383e+136), SC_(313.65282994987906178318459302814108504255767778781127430168669112359249852477600875415140860377983336041329436),
   SC_(91), SC_(1.4857159644817614973095227336208257378855699612846887669422168637049853930940658765459921313708840596456172345e+138), SC_(318.1526396202093268499930749566705006594537603920855461811894076918350597208905791681346373184968958363312022),
   SC_(92), SC_(1.3520015276784029625516656875949514214758686647690667779174173459715367077155999476568528395475044942775116834e+140), SC_(322.66349912672617689115191514167899899389611306642761448606784335243610425096705861532187048052525685209352209),
   SC_(93), SC_(1.2438414054641307255475324325873553077577991715875414356840239582938137710983519518443046123837041347353107487e+142), SC_(327.18528770377521720079313221640554824848949364998856073630783874890588474089124634473199822667108904153172227),
   SC_(94), SC_(1.1567725070816415747592051623062404362147532295764135351861422812132468071214673152152032895168448453038389963e+144), SC_(331.71788719692847313811754177787043116358692313829190215979925115501836045070740654381947881282090776089266923),
   SC_(95), SC_(1.0873661566567430802736528525678660100418680358018287230749737443404519986941792763022910921458341545856086565e+146), SC_(336.26118197919847703435572456910078144055847377467238144712043951131857228618290233203603189325207242939112229),
   SC_(96), SC_(1.0329978488239059262599702099394727095397746340117372869212250571234293987594703124871765375385424468563282237e+148), SC_(340.81505887079901786896551133421482261732145439024002798757104763920204397595475738538032415516099193598812922),
   SC_(97), SC_(9.9167793487094968920957140154189380115818364865126779544437605483849222280909149998768947603700074898207509474e+149), SC_(345.37940706226685410744691717842823116234644561986405370990914202030650637902183993028325654495681746248610666),
   SC_(98), SC_(9.619275968248211985332842594956369871234381391917297615810447731933374561248187549880587917558907265126128419e+151), SC_(349.95411804077023692956363880013219287615536052252283506588537638906668367080002705562553928999109201241305734),
   SC_(99), SC_(9.4268904488832477456261857430572424738096937640789516634942387772947070700232237988829761592077291198236058506e+153), SC_(354.53908551944080884919157640847672890350503011604681269692483669843523701827386030680671961416325375394118221),
   SC_(1.5), SC_(0.88622692545275801364908374167057259139877472806119356410690389492645564229551609068747532836927233270811341181), SC_(-0.12078223763524522234551844578164721225185272790259946836386847375732473702728167571405169185867383369099657491),
   SC_(2.5), SC_(1.3293403881791370204736256125058588870981620920917903461603558423896834634432741360312129925539084990621701177), SC_(0.28468287047291915963249466968270192432013769555989472925014585038677593422163257555370073595863956755497197314),
   SC_(3.5), SC_(3.3233509704478425511840640312646472177454052302294758654008896059742086586081853400780324813847712476554252943), SC_(1.2009736023470742248160218814507129957702389154681571970421137323675612999595956245779712870554004908129367951),
   SC_(4.5), SC_(11.63172839656744892914422410942626526210891830580316552890311362090973030512864869027311368484669936679398853), SC_(2.4537365708424422205041425034357161573318235106897631313808238728117475407419701767597664586468533302639970083),
   SC_(5.5), SC_(52.342777784553520181149008492418193679490132376114244880064011294093786373078919106229011581810147150572948385), SC_(3.9578139676187162938774008558225909985513044919750067807295325305933425052094933949011346412778988202979355854),
   SC_(6.5), SC_(287.88527781504436099631954670830006523719572806862834684035206211751582505193405508425956369995580932815121612), SC_(5.6625620598571415285221123123295437302975112115521687018274202302305225071530353923703260222841149241706498303),
   SC_(7.5), SC_(1871.2543057977883464760770536039504240417722324460842544622884037638528628375713580476871640497127606329829048), SC_(7.5343642367587329551583676324366857670272790219521205641257857314005935525077508561640373587281857253979065414),
   SC_(8.5), SC_(14034.407293483412598570577902029628180313291743345631908467163028228896471281785185357653730372845704747371786), SC_(9.5492672573009977117371400811272225431248707996831324836524479470188732114643228720619236646386787374438413924),
   SC_(9.5), SC_(119292.46199460900708784991216725183953266297981843787122197088573994562000589517407554005670816918849035266018), SC_(11.689333420797268482569442577542172510637573677908622016829005675407772165295559437368155205679762997420188173),
   SC_(10.5), SC_(1133278.3889487855673345741655888924755602983082751597766087234145294833900560041537176305387276072906583502717), SC_(13.940625219403763633161237887971849479799452804847495581246285902323671245390062010476450262499084205675227326),
   SC_(11.5), SC_(11899423.083962248457013028738683370993383132236889177654391595852559575595588043614035120656639876551912677853), SC_(16.292000476567241320244603746879378346008527957891850967319690376405351779391045529531861188904269133914257568),
   SC_(12.5), SC_(136843365.46556585725564983049485876642390602072422554302550335230443511934926250156140388755135858034699579531), SC_(18.7343475119364457016341244572313978963754081383720314551976457443949514034061491121243989540608452607264533),
   SC_(13.5), SC_(1710542068.3195732156956228811857345802988252590528192878187919038054389918657812695175485943919822543374474413), SC_(21.260076156244701141418411002225596607351110712548811644902261517849915756851769925778803383250785794784384425),
   SC_(14.5), SC_(23092317922.314238411890908896007416834034140997213060385553690701373426390188047138486906024291760433555540458), SC_(23.862765841689084906186914591534997153218082251656804745985664509269005014537902110793787320695563373606293032),
   SC_(15.5), SC_(334838609873.55645697241817899210754409349504445958937559052851516991468265772668350806013735223052628655533664), SC_(26.536914491115613623952954502438732190637095031219293570786654851418392173706059728481291108517001108710291135),
   SC_(16.5), SC_(5189998453040.125083072481774377666933449173189123635321653191985133677581194763594374932128959573157441607718), SC_(29.277754515040814560464886705522912833011533827339630288422692914399979968333916245089292612856669051741266591),
   SC_(17.5), SC_(85634974475162.063870695949277231504401911357620539982807277667754705680089713599307186380127832957097786527347), SC_(32.081114895947349486504843398952391269405231104739541661255274947674654263496067209432099748676617244401950865),
   SC_(18.5), SC_(1498612053315336.1177371791123515513270334487583594496991273591857073494015699879878757616522370767492112642286), SC_(34.943315776876817856793723354163582070492417054229665317506632979593019491986099526244028798361249694652977381),
   SC_(19.5), SC_(27724322986333718.178137813578503699550118802029649819433856144935585963929044777775701590566385919860408388228), SC_(37.861086508961096991744586903736852666316994507037046227030865651292615617006765876037187005036999667892784853),
   SC_(20.5), SC_(540624298233507504.47368736478082214122731663957817147896019482624392629661637316662618101604452543727796357046), SC_(40.831500974530798109776087460766520407694252875259747541063925486100180955580090306704514096294802557908011593),
   SC_(21.5), SC_(11082798113786903841.710590978006853895159991111352515318683993938000489080635649915836710828912771464198253194), SC_(43.851925860675160604225618712345751427995163210298793920562508386866765950016053097060967910670370681404000601),
   SC_(22.5), SC_(238280159446418432596.77770602714735874593980889407907935170586966701051523366647319048928282162458648026244368), SC_(46.919978795808777718281229104233421895478799260820094081633513642296231501919344819992696581757949280759504801),
   SC_(23.5), SC_(5361303587544414733427.4983856108155717836457001167792854133820675077365927574956467860088634865531958059049828), SC_(50.033494105019152166255246789846484376223881596373855452894870191552005454094525802764198642482174381593409681),
   SC_(24.5), SC_(125990634307293746235546.21206185416593691567395274431320721447858643180992980114769947120829193400010143876709), SC_(53.190494526169265443658965338160481517044431964033824231974698528865430045630632159769025068920501675007859774),
   SC_(25.5), SC_(3086770540528696782770882.1955154270654544340118422356735767547253675793432801281186370446031523830024852497938), SC_(56.389167643719946744452438703588664408243101288837291354772798819247196149165075979738478739099826041451981681),
   SC_(26.5), SC_(78712648783481767960657495.985643390169088067301977009676207245496873273253643267025244637380385766563373869743), SC_(59.627846095884327206679986436926140080403294724885530339684050881273589396214921511918326034954642390216298491),
   SC_(27.5), SC_(2085885192762266850957423643.6195498394808337835023907564194920056671417412215465761689828905802228139294075482), SC_(62.90499082887650373140722345449702128268777234343649268861150034179820040818871665484712265244414493251641083),
   SC_(28.5), SC_(57361842800962338401329150199.537620585722929046315745801536030155846397883592530844647029490956127383058707575), SC_(66.219176833549029340652694244230161653959580417282172331622035932909559397839916416946447911543540647189091378),
   SC_(29.5), SC_(1634812519827426644437880780686.8221866931034778199987553437768594416223396823871290724403404922496304171731659), SC_(69.56908092082363418263973479158236432776895010204379534777401049346295277115302795692835872317659394423210056),
   SC_(30.5), SC_(48226969334909086010917483030261.254507446552595689963282641417353527859020630420307636990044521364097306608394), SC_(72.953471184169408323838553043843885383756796757013994623165367181028759263448760718681835355982809025700542958),
   SC_(31.5), SC_(1470922564714727123332983232422968.262477119854168543880120563229282599700129227819382928196357901604967851556), SC_(76.371197867782774263172710025811323561996978365735000431982070817954805448324014734261401235086494111182014369),
   SC_(32.5), SC_(46334060788513904384988971821323500.268029275406309132223797741722401890554070676310562238185273900556487324014), SC_(79.821185413614361641651321121641378132853544076602105269790169625673980275543607220190427916305411128209014641),
   SC_(33.5), SC_(1505856975626701892512141584193013758.7109514507050467972734266059780614430072969800932727410214017680858380305), SC_(83.302425502950053442888335774974707809108913241270574854001183018318230308605980448614273130842661540236237655),
   SC_(34.5), SC_(50446208683494513399156743070465960916.81687359861906770865979130026505834074444883312463682421695923087557402), SC_(86.813970941781074193141175649880253991600346010132214937018287139600105192164372629647323991667268337228198365),
   SC_(35.5), SC_(1740394199580560712270907635931075651630.1821391523578359487627998591445127556834847427999704354850934652073037), SC_(90.354930265818388265925941597154799246614716748435144876630936841227199109398085179113477511637576552828364127),
   SC_(36.5), SC_(61783994085109905285617221075553185632871.465939908703176181079394999630202826763708369398950459720818014859281), SC_(93.924462962299758377838164008209656775298793140785455730631682633761156994252620829473857508913792998827308996),
   SC_(37.5), SC_(2255115784106511542925028569257691275599808.5068066676659306093979174865024031768753554830616917798098575423638), SC_(97.521775222888204197513040744190022778128045851296798141106701481429553348203523407144323504752233205539338939),
   SC_(38.5), SC_(84566841903994182859688571347163422834992819.005250037472397852421905743840119132825830614813441742869657838642), SC_(101.14611615586456932869257252610674719375123898329632778254601158852201199486775318767234368875590582838524009),
   SC_(39.5), SC_(3255823413303776040098009996865791779147223531.7021264426873173182433711378445866137944786703175071004818267877), SC_(104.79677439715830786844263672605687965513453043245535089210328943809677185956336445292919356834999345925101603),
   SC_(40.5), SC_(128605024825499153583871394876198775276315329502.23399448614903407061315994486117124488190747754153046903215811), SC_(108.47307506906538405319835014608011400923257152251770526339478054616318429871810201546927060712765437834731737),
   SC_(41.5), SC_(5208503505432715720146791492486050398690770844840.4767766890358798598329777668774354177172528404319839958024036), SC_(112.174377043177877509362098972312040259747033619448447816212877871219767849622843167357870299386164045957196),
   SC_(42.5), SC_(216152895475457702386091846938171091545666990060879.78623259498901418306857732541356983526599287792733582579975), SC_(115.90007047041453012342033907414523414470084654175142893228014132466495321754213905759043426936031879264314726),
   SC_(43.5), SC_(9186498057706952351408903494872271390690847077587390.9148852870331027804145363300767179988046973119117725964894), SC_(119.64957454634490126885340090378637175173915077424543618736934694452803115908103338752679968849458266341946035),
   SC_(44.5), SC_(399612665510252427286287302026943805495051847875051504.79750998593997094803233035833723294800433306816210794729), SC_(123.42233548443953967801468605161263249380565411163067446390503162031491261146779997208791923112975248731142848),
   SC_(45.5), SC_(17782763615206233014239784940198999344529807230439791963.489194374328707187438700946006866186192821533213803654), SC_(127.21782467361173420691526947082430514513481436440337857389104918810947288227756150292911945608280954278671516),
   SC_(46.5), SC_(809115744491883602147910214779054470176106228985010534338.75834403195617702846089304331241147177337976122806627), SC_(131.03553699956863893865687753437462691150166690438519162464880483921712379038434623451048929111475187100703357),
   SC_(47.5), SC_(37623882118872587499877824987226032863188939647802989846752.262997485962231823431526514027133437462158897105082), SC_(134.87498931216194956656405497438133325852359625832827779401953723583620587823081171799210655026815190282597905),
   SC_(48.5), SC_(1787134400646447906244196686893236561001474633270642017720732.4923805832060116129975094162888382794525476124914), SC_(138.73571902320254509175660961803719786721107673953566908034946535422628394603297205573053548518065272188098451),
   SC_(49.5), SC_(86676018431352723452843539314321973208571519713626137859455525.880458285491563230379206690008656553448559205832), SC_(142.61728282114598260445609911828298301294449150783419518220501971349306761584146446546695490321850858426593371),
   SC_(50.5), SC_(4290462912351959810915755196058937673824290225824493824043048531.0826851318323799037707311554284993957036806887), SC_(146.51925549072062722189130104863498715398567934305685600677229608040523620422222439668337779385218886571458801),
   SC_(51.5), SC_(216668377073773970451245637400976352528126656404136938114173950819.67559915753518514042192334913921948303587478), SC_(150.4412288270019413633582671940897997428010617958942055025828814326138544658548735525821945735977269360210477),
   SC_(52.5), SC_(11158421419299359478239150326150282155198522804813052312879958467213.293356613062034731729052480669803376347551), SC_(154.38281063467163182470963738768506399535382276990475341107343238215099204833297310656807722165341715406317983),
   SC_(53.5), SC_(585817124513216372607555392122889813147922447252685246426197819528697.90122218575682341577525523516467725824643), SC_(158.34362380426920988639376257981878050108849927721762651905948474770685157004161439025362202615178169310217637),
   SC_(54.5), SC_(31341216161457075934504213478574605003413850928018660683801583344785337.715386937990052743976155081310233316184), SC_(162.32330545817117075028092927538388093457614541898877881849892145746017531760191233120507740265697365547119116),
   SC_(55.5), SC_(1708096280799410638430479634582315972686054875577017007267186292290800905.488588120457874546700451931407715732), SC_(166.32150615984036914124101360613490601756099416813175471745311500264768497982738059734322034762200774042718254),
   SC_(56.5), SC_(94799343584367290432891619719318536484076045594524443903328839222139450254.616640685412037341875082193128223128), SC_(170.33788918059275796758712239263070231803306217876188507871204200798477539806665591400999430911148980245496004),
   SC_(57.5), SC_(5356162912516751909458376514141497311350296576090631080538079416050878939385.8401987257801098159421439117446067), SC_(174.37212981874515322675202176478854742198689243310462361933171003383495568165601126924032108461494319287562168),
   SC_(58.5), SC_(307979367469713234793856649563136095402642053125211287130939566422925539014685.81142673235631441667327492531489), SC_(178.42391476654845798274230180836675461187937396785332182912231329329873429337877261646299272786469893048778372),
   SC_(59.5), SC_(18016792996978224235440613999443461581054560107824860297159964635741144032359119.968463842844393375386583130921), SC_(182.49294152078626879216904760231894805790412289389877259489006746174379392517070601400393557393623390929098049),
   SC_(60.5), SC_(1071999183320204342008716532966885964072746326415579187681017895826598069925367638.1235986492414058355016962898), SC_(186.57891783333785286810670284217707775505391050170612331652601534007027274175401184709782561356518969626038896),
   SC_(61.5), SC_(64855950590872362691527350244496600826401152748142540854701582697509183230484742106.477718279105053047852625532), SC_(190.68156119837464864681335787664915978662182407522070241284247074883802636761079055764207170257404059154781894),
   SC_(62.5), SC_(3988640961338650305528932040036540950823670894010766262564147335896814768674811639548.3796741649607624429364702), SC_(194.80059837318712083265813436515091651157022496808249824407574798324210565526536231487214127176334080383177797),
   SC_(63.5), SC_(249290060083665644095558252502283809426479430875672891410259208493550923042175727471773.72963531004765268352939), SC_(198.9357649299294766470431802433713028620715288965277961556930116481712489964186408931566795790464609486896754),
   SC_(64.5), SC_(15829918815312768400067949033895021898581443860605228604551459739340483613178158694457631.831842188025945404116), SC_(203.08680483582812261067338892962941868886993788609362666447959684653504063618552155529671137165254559527012397),
   SC_(65.5), SC_(1021029763587673561804382712686228912458503129009037244993569153187461193049991235792517253.1538211276734785655), SC_(207.2534700596298494161242445584396148610010644944376762772852964356020004813074222451020557975538562834135982),
   SC_(66.5), SC_(66877449514992618298187067680947993766031954950091939547078779533778708144774425944409880081.57528386261284604), SC_(211.43552020227105565085643644815096418603347436471800199512161188121614319947433697344350573132141276354024193),
   SC_(67.5), SC_(4447350392747009116829440000783041585441125004181113979880738838996284091627499325303257025424.7563768637542617), SC_(215.63272214993286410655358450202382088483243822123873674799828225806962214232090881433945928672860549878834278),
   SC_(68.5), SC_(300196151510423115385987200052855307017275937782225193641949871632249176184856204457969849216171.05543830341266), SC_(219.84484974781134824592284742455940907022501111461524757099433314096289038771469876398457710226656268841021769),
   SC_(69.5), SC_(20563436378463983403940123203620588530683401738082425764473566206809068568662650005370934671307717.297523783767), SC_(224.07168349307952785182080543108109789271264615429955763192392717249964214460788839512371322000656690972870255),
   SC_(70.5), SC_(1429158828303246846573838562651630902882496420796728590630912851373230265522054175373279959655886352.1779029718), SC_(228.31301024565027429959235822849846510707974268029445629347732566784950338815827880054483195431835852093151265),
   SC_(71.5), SC_(100755697395378902683455618666939978653215997666169365639479356021812733719304819363816237155739987828.54215951), SC_(232.56862295546849726839132201373498795254778360577717452429184833880042227291299412442327413557041790313393277),
   SC_(72.5), SC_(7204032363769591541867076734686208473704943833131109643222773955559610460930294584512860956635409129740.7644053), SC_(236.83832040516845923908952091180725928909925827011454356180878154910106694218094630129204018001712349577590521),
   SC_(73.5), SC_(522292346373295386785363063264750114343608427902005449133651111778071758417446357377182419356067161906205.41938), SC_(241.12190696702908833145632015593718196604387240394555010852241978272463308905676168360967784593174084167986961),
   SC_(74.5), SC_(38388487458437210928724185149959133404255219450797400511323356715688274243682307267222907822670936400106098.325), SC_(245.41919237324787932364503875828789056189003228657176668305521440674389348580981447045274727092479729691196155),
   SC_(75.5), SC_(2859942315653572214189951793671955438617013849084406338093590075318776431154331891408106632788984761807904325.2), SC_(249.72999149863339315522023491193383448167061692340447857672407449375747169812791781111275143962959290222039703),
   SC_(76.5), SC_(2.1592564483184470217134136042223263561558454560587267852606605068656762055215205780131205077556834951649677655e+110), SC_(254.05412415488837217459923908996013420385285318162401319788608852473651793897154945257028320795873840597621994),
   SC_(77.5), SC_(1.6518311829636119716107614072300796624592217738849259907244052877522422972239632421800371884330978738012003406e+112), SC_(258.39141489572086232822203206022013558066053717549500163453203492040040547924000395162374625862728684352850678),
   SC_(78.5), SC_(1.280169166796799277998340090603311738405896874760817642811414098007987780348571512689528821035650852195930264e+114), SC_(262.74169283208016363933472359653050386256057732588385607408072087485617226157551823286188164106013439735944854),
   SC_(79.5), SC_(1.0049327959354874332286969711235997146486290466872418496069600669362704075736286374612801245129859189738052572e+116), SC_(267.10479145686852638734193671147580254322732082238725117588822686309450418800594513507752807659094400582867122),
   SC_(80.5), SC_(7.9892157276871250941681409204326177314566009211635727043753325321433497402103476678171769898782380558417517949e+117), SC_(271.48054847852881260346441896596920945015928899876096297655037065725660949319834924487994044889417863691675359),
   SC_(81.5), SC_(6.4313186607881357008053534409482572738225637415366760270221426883753965408693298725928274768519816349526101949e+119), SC_(275.86880566295333028995929241976440873016325390882300465288771617518378897996552209526013671263862629072201102),
   SC_(82.5), SC_(5.2415247085423305961563630543728296781653894493523909620230462910259481808085038461631543936343650324863773089e+121), SC_(280.26940868320014731460699266442698203871964079719296793469286173499967111079349880691287016537937361497556242),
   SC_(83.5), SC_(4.3242578845474227418289995198575844844864462957157225436690131900964072491670156730846023747483511518012612798e+123), SC_(284.682206976540782615247708691082648114638939428861397029438091659748524393663307535885811179292501418436213),
   SC_(84.5), SC_(3.6107553335970979894272145990810830445461826569226283239636260137305000530544580870256429829148732117540531686e+125), SC_(289.10705360839759241309022734636925091236076189711213337517709639704948836617314376848780201510190498881332539),
   SC_(85.5), SC_(3.0510882568895478010659963362235151726415243450996209337492639816022725448310170835366683205630678639321749275e+127), SC_(293.5438051427607205757799701080417115538957976522722923538945074088830240788522694116810880149864652788098403),
   SC_(86.5), SC_(2.608680459640563369911426867471105472608503315060175898355620704269943025830519606423851414081423023662009563e+129), SC_(297.99232151870343510916225589231643993235265789485666482178117630307391174538398991853661458143325066464081951),
   SC_(87.5), SC_(2.256508597589087314973384240362506233806355367527052152077611909193500717343399459556631473180430915467638272e+131), SC_(302.45246593264126874667852415929925483346301066821048385407743103970638435351361815495531586043755604177405005),
   SC_(88.5), SC_(1.974445022890451400601711210317192954580560946586170633067910420544313127675474527112052539032877051034183488e+133), SC_(306.92410472600483749156816344773663327407579797196912523224143696309892856971130823639737878821536810282504286),
   SC_(89.5), SC_(1.7473838452580494895325144211307157648037964377287610102651007221817171179927949564941664970440961901652523869e+135), SC_(311.40710727801872132416222693692068003471113518476207395936748798430222935522564996502447117583531527308145529),
   SC_(90.5), SC_(1.5639085415059542931316004069119906094993978117672411041872651463526368206035514860622790148544660901979008863e+137), SC_(315.90134590329953101092279924548390564223856846858296625777328597413442813460285776012923528619664640063105954),
   SC_(91.5), SC_(1.4153372300628886352840983682553515015969550196493531992894749574491363226462140948863625084432918116291003021e+139), SC_(320.40669575400541144834465416265873800140340077572518981723533406865135034989138112174804319537395034840295962),
   SC_(92.5), SC_(1.2950335655075431012849500069536466239612138429791581773498695860659597352212858968210216952256120076406267764e+141), SC_(324.92303472628688707907405638154870188429107294226894507778673203921489082798524410420122482929136752267240106),
   SC_(93.5), SC_(1.1979060480944773686885787564321231271641228047557213140486293671110127550796894545594450680836911070675797682e+143), SC_(329.45024337080526658862567926434816011964125174934484370922361260238866594071356821862451691406029710671217484),
   SC_(94.5), SC_(1.1200421549683363397238211372640351238984548224465994286354684582487969259995096400130811386582511851081870832e+145), SC_(333.98820480709990790351992533872823938697566148150775041761873803990813851845804149700580316310401615810323734),
   SC_(95.5), SC_(1.0584398364450778410390109747145131920840398072120364600605176930451130950695366098123616760320473699272367937e+147), SC_(338.53680464159960497339378167148081966247971775019760470716153118126480763889624294980844559913666526391820764),
   SC_(96.5), SC_(1.0108100438050493381922554808523600984402580158874948193577943968580830057914074623708054006106052382805111379e+149), SC_(343.095930889086289536826499502225010241012659092304896484521563059300107456132654601958350377038769758750347),
   SC_(97.5), SC_(9.7543169227187261135552653902252749499484898533143250068027159296805010058870820118782721158923405494069324811e+150), SC_(347.66547389743122977926419843414989243712722645052362680457030358912339124368115189455827461325062570433884005),
   SC_(98.5), SC_(9.5104589996507579607163837554696430761997776069814668816326480314384884807399049615813153129950320356717591691e+152), SC_(352.24532627543503127189645832440574781803008617301484584051601131540513556996213408985573558260160820515403309),
   SC_(99.5), SC_(9.3678021146559965913056379991375984300567809428767448784081583109669111535288063871575955833001065551366827815e+154), SC_(356.83538282361307446925902353211040222496323010101263029219393567782724332404128833098562961026080141679994657),
};

static const boost::array<boost::array<T, 3>, 41> near_1 = {
   SC_(0.5), SC_(1.7724538509055160272981674833411451827975494561223871282138077898529112845910321813749506567385446654162268236), SC_(0.57236494292470008707171367567652935582364740645765578575681153573606888494241303989181163513774485385100490611),
   SC_(0.625), SC_(1.4345188480905567756360197394564231366322077722066673307706798580950941973020969146309569665256322935994654338), SC_(0.36082949548894018118495768582277948785736912020625817171534369271076040488490050699002363027633270505424458064),
   SC_(0.75), SC_(1.2254167024651776451290983033628905268512392481080706112301189382898228884267983572371723762149150665821733802), SC_(0.20328095143129537148143297186242969975966731498257864807397605368487331819397460137048111735608518528622179233),
   SC_(0.875), SC_(1.0896523574228969512523767551028929711478700677675651205137040432536264174658795033595896748361842446382310482), SC_(0.08585870722533432350236558376948770226971912568187111234881601023955661926262775458261489495159171414683063444),
   SC_(0.875), SC_(1.0896523574228969512523767551028929711478700677675651205137040432536264174658795033595896748361842446382310482), SC_(0.08585870722533432350236558376948770226971912568187111234881601023955661926262775458261489495159171414683063444),
   SC_(0.9375), SC_(1.0401770111867671714597628173619211286137015344920691109446597166008250518768858003488288550069774030008385474), SC_(0.039390901734582300658227546340953844503363526873275555924583248691684407795252299141939653430330091269382318677),
   SC_(0.96875), SC_(1.0190325250566739505647300479281360248823250932111783847890502796409452098998953044939908318632260351379776713), SC_(0.018853672334412890535592065704800808901737541753307604147921982817646261473204084765390919252667197071285862424),
   SC_(0.984375), SC_(1.0092639847156863031513642279872649395665289471965001383071292900827245419873658382338104686447297569473205469), SC_(0.00922133719757878104504544602785480541183714372596115164380073895348968088364637878818475160823616428061231308),
   SC_(0.9921875), SC_(1.0045703009750313695418190819857497756177949566342185206412658643551771616307782112692210230847197631441840257), SC_(0.0045598888618045588650965994550424584438465646671569627037023442718896355703968374172722045521035725542428421793),
   SC_(0.99609375), SC_(1.0022698948072663380705186466834088228749332164565353765602844596483728158852340436652910312111169316609714696), SC_(0.002267322487909119869224853055660925945502946111127310832108839278441229781909271272292321713240086669666673579),
   SC_(0.998046875), SC_(1.0011311540702717194751486537016329361748548795865540183758175786053609255723291288804230660209514957067544756), SC_(0.0011305147975382617314468555514931106445911149072169391421772950013850819314728201357323200246446508198616715076),
   SC_(0.9990234375), SC_(1.0005646312561051341795833347970072224691414951011585192257183425112236459173288788007843000527615619796876423), SC_(0.00056447191185512338425745752778379540322733814671115601515739643336237598766933267729753552357635796698514596983),
   SC_(0.99951171875), SC_(1.0002820795014030603122660092346161054092748105743475941025912629061994674154769263987059870282205452011790797), SC_(0.00028203972446050202164990932586792182277028625000579467899259058286790920813945981070397067889871367271780753512),
   SC_(0.999755859375), SC_(1.0001409807587291625276642931842015920091929545333196812761907195683656908667498991146653620951380087741337049), SC_(0.00014097082187592237051371524368529004109710102132559573440397063444509291284211693505849383520344943672815952199),
   SC_(0.9998779296875), SC_(1.0000704756363281543589529190831324108350522109231500912943205227968503621121547410111499321275965652178864083), SC_(7.0473153037170086154990456617429606491291306351792371038014266565023997915969279947648648462158546701919903081e-05),
   SC_(0.99993896484375), SC_(1.0000352341330242672078622365190637840639477682700164032264654052973959618643727802512909912536172530362395266), SC_(3.5233512316782239237891894216581425213234468976061384095946082343932672612109116593768365443514987235802189247e-05),
   SC_(0.999969482421875), SC_(1.0000176161453045753153818203998783392498353944168731950825723484510408117073964447044091192763939536504419548), SC_(1.761599014210985977615986870219441253152302650866741955007594785183512559840534060419786772025834904844368172e-05),
   SC_(0.9999847412109375), SC_(1.0000088078423600712432306459072726327005468658815965923272360897211863953044660937258887228363756570934413742), SC_(8.8078035712554869804636737104615719706676701895738198043786296563843343116436624246517174019991164055073256752e-06),
   SC_(0.99999237060546875), SC_(1.0000044038636081905928511858888125298767090169025230723302909504779910697224206944418494971066153925981249059), SC_(4.4038539112117225162418369217896025239570399579722287850444858130021481865621717750113878487355145402430600115e-06),
   SC_(0.999996185302734375), SC_(1.0000022019174112851692250057380852275017766147260950955247390757507613697962418975625931771397155345075852518), SC_(2.2019149870685847804328915717680872509667301348628950203352825315866810742426434243009968987918506631520331535e-06),
   SC_(1), SC_(1), SC_(0),
   SC_(1.000003814697265625), SC_(0.99999779811137403283143208760327600675756902143756596759838698221325215539409430568396858379750535139420226287), SC_(-2.2018910501274876377141818311089755229311746446021640254293045758059176229682918834288238505534445292777340924e-06),
   SC_(1.00000762939453125), SC_(0.99999559625153308141476652368576165846163213500202659668397521943996956814485005524714716726321435556951990071), SC_(-4.4037581634473325702218400982291070742088066919117076633155854060759992379786313395823905915149428408829547678e-06),
   SC_(1.0000152587890625), SC_(0.99999119261820501686706957175471991293910990979611602622805038287033968066042427663218511800321072127022156621), SC_(-8.8074205801979051940611576319016798990780755527146458978906571204868908384222945024215475751136282541034767583e-06),
   SC_(1.000030517578125), SC_(0.99998238569695577840308912119540189506999309885932228281903127593682897986879129264261414709811177673988286746), SC_(-1.7614458177879180593389151228747594238394118848425722604531270820619091802647966796813580302792743080800024461e-05),
   SC_(1.00006103515625), SC_(0.9999647732360171681023427372223702590453913910199390605542249806417221689763739196579994699370896803042256543), SC_(-3.5227384459853889912226246727720809494104943993200852437494031875415481631698870730758441698569691729723713575e-05),
   SC_(1.0001220703125), SC_(0.99992955383983791386301091466222734539118060355467854238385118863460180336591770779111045679237945045786873776), SC_(-7.0448641609366567338214494075777693865307332448868837181756428608376087273339198390868816550906450304788582582e-05),
   SC_(1.000244140625), SC_(0.99985913714594034205878980722394270651070266886680721525579148722985946512786872299585878169952950155084026009), SC_(-0.00014087277616326635097030584178411951846640279051937897896521676513490342036437475141116837467757236371463821202),
   SC_(1.00048828125), SC_(0.99971839211735866523005832066420299515608817676196471144193889051244066546497815377121028399780635540938064397), SC_(-0.00028164754158680683182392054639170724065894038359476068703975750485180064764636731267884353254046569566588895557),
   SC_(1.0009765625), SC_(0.99943725522028108434521359203118190516500797436636326722510244581259842767599446851324731597976259518948982942), SC_(-0.00056290317999120463170214992168514502772879541390257627479851327242521375496316078955498047974490391404458478547),
   SC_(1.001953125), SC_(0.99887639185670229384018166594439725095095947312101240404656716276062253854369107023559370003430011705769110439), SC_(-0.0011242398641763655930882350026740454995347120448051246807766325452465319026604793370057190525283304374866233861),
   SC_(1.00390625), SC_(0.99776028924350090452551500508904405795133755282195340238940486963282177163716541194432652172131971470978813773), SC_(-0.0022422226599611501447654819092305299298079260417770143567963238377892856797491379587790257042671743196875073852),
   SC_(1.0078125), SC_(0.99555044071429420946514324392976594135804811283276950233333294520174555163201058126609151736557274229008810138), SC_(-0.0044594880379522990866700789223521091987576375799193257939241836415369699743362378844236187907877816282112942101),
   SC_(1.015625), SC_(0.99121906984205173417648186621914503971475375794490339430947476500778081798552753056206174599314583780671923895), SC_(-0.0088197097057330692048892296986270663800008130918961793125380525215482778706344040845486366868779812028188116857),
   SC_(1.03125), SC_(0.98290109928362691478263486825456935046998823743496277043928362292034206769975910596393892249337556712953037341), SC_(-0.017246775001768067402891262022246231797366446505106380535078130887485701437593237496879558493144914283530453506),
   SC_(1.0625), SC_(0.96758006759952488475997629871543175166460210218111998646615104815739441126428563127884962077687042597437275844), SC_(-0.032957100293577819083198835750474183157056130167483637604037935415773601610870065861297777718490000655850137079),
   SC_(1.125), SC_(0.94174269984970148808740373015189170307630244851863449262289098722208295714986330160419107835129460670740615211), SC_(-0.060023184126039582931405843207430114278219450946316157230075155800865906698601740995330664462916031985954246411),
   SC_(1.125), SC_(0.94174269984970148808740373015189170307630244851863449262289098722208295714986330160419107835129460670740615211), SC_(-0.060023184126039582931405843207430114278219450946316157230075155800865906698601740995330664462916031985954246411),
   SC_(1.25), SC_(0.90640247705547707798267128896691800074879192072001636685834449989247981088468228040459003418084607509036793785), SC_(-0.098271836421813161463853802696635840225622703607649957741372996452825981263690594995652837575223508897214201633),
   SC_(1.375), SC_(0.88891356915622534074242756406624469120777530125959687041567260050243557425925067192449287563913055244069020048), SC_(-0.11775527074107877445136203331798850424653921590958917561520411328795258332429161436283053688418097696213797973),
   SC_(1.5), SC_(0.88622692545275801364908374167057259139877472806119356410690389492645564229551609068747532836927233270811341181), SC_(-0.12078223763524522234551844578164721225185272790259946836386847375732473702728167571405169185867383369099657491),
};

static const boost::array<boost::array<T, 3>, 41> near_2 = {
   SC_(1.5), SC_(0.88622692545275801364908374167057259139877472806119356410690389492645564229551609068747532836927233270811341181), SC_(-0.12078223763524522234551844578164721225185272790259946836386847375732473702728167571405169185867383369099657491),
   SC_(1.625), SC_(0.89657428005659798477251233716026446039512985762916708173167491130943387331381057164434810407852018349966589612), SC_(-0.1091741337567953724659793453255625768435299286059898687340484442952414733165258751974324726197437467717935594),
   SC_(1.75), SC_(0.91906252684888323384682372752216789513842943608105295842258920371736716632009876792787928216118629993663003518), SC_(-0.084401121020485555957786034131397731743842395915182408432689631664419632526805862967629781823020101009811140644),
   SC_(1.875), SC_(0.95344581274503483234582966071503134975438630929661948044949103784692311528264456543964096548166121405845216713), SC_(-0.047672685399188299643978037161862272319696547817033461553833868303044383894387124447316587449792821486112114416),
   SC_(1.875), SC_(0.95344581274503483234582966071503134975438630929661948044949103784692311528264456543964096548166121405845216713), SC_(-0.047672685399188299643978037161862272319696547817033461553833868303044383894387124447316587449792821486112114416),
   SC_(1.9375), SC_(0.9751659479875942232435276412768010580753451885863147915106184843132734861345804378270270515690413153132861382), SC_(-0.025147619402988871014696369343039083625545098476478286910794564170216799157259831777764021648432959310687273318),
   SC_(1.96875), SC_(0.98718775864865288960958223393038177410475243404832906026439245840216567209052357622855361836750022153991586909), SC_(-0.01289502598016741062140421704372482102582419956737669469875999217434043177771826105006088439333961006574460579),
   SC_(1.984375), SC_(0.99349423495450370466462416192496392488580193239655482364608039492518197101881324701140718007215585449501866336), SC_(-0.0065270197705603875625040654329734641090978172082102811515005007943036017452347133121052021549402564023948207056),
   SC_(1.9921875), SC_(0.99672209549866393696727362040773610549578093353551368844875597478990234005553775649368023384187038999462008798), SC_(-0.0032832885992213340080874430359011232107452519285440532337925143246804564808907940778759648203239061173174780116),
   SC_(1.99609375), SC_(0.99835477803067545393743068321980175716057800857975203524559584847787135957318234818222348812044850614667079983), SC_(-0.0016465768332272092230929305879117388972032040939027611887512736747418892484504411587697933136947665600605804507),
   SC_(1.998046875), SC_(0.9991758197849782200230487539873719343463883661498615300586773098971473300145706735505784897201293248167022208), SC_(-0.00082452003826508882618063669037370149307251988162149488885378333978767712311305925304980152039311581105853907029),
   SC_(1.9990234375), SC_(0.99958751735839409400948608544661952010344897410984879410928697694236502907561273731758040913474128701681685356), SC_(-0.00041256773597148940171061762396967043263766321508278648166258325752450997988091121880044028815700667736697239274),
   SC_(1.99951171875), SC_(0.99979366051727151584922291059729451551405543810824683844140835701610854970677796305573786887049192188809256652), SC_(-0.00020636077364837244333505423402898916069048973940689454315455907351479369424786720832798217923629191781310389304),
   SC_(1.999755859375), SC_(0.99989680571459861341571906264387341779239383515965432002587914956847107033675313400257682074697025047121033239), SC_(-0.00010319961029799208618175017469614360196936704565252345328392393606626650213932477070288037281599692906336527261),
   SC_(1.9998779296875), SC_(0.99994839672084520414479777346312714564818269771380888644919182156115738721443597212186634448939739571529633426), SC_(-5.1604610649812155427880333694545946032583928291310459746204246757312291926312160269132259332526873487515506522e-05),
   SC_(1.99993896484375), SC_(0.9999741968262534527384281628962293685497837089579882039831044149772484157241222692173401067937018711238227639), SC_(-2.5803506654161686483250535590236551252779944206866471779380407628046074943126208389937084185400792859175711612e-05),
   SC_(1.999969482421875), SC_(0.99998709802957748472165271328866008124387684231133068796602319768357099234668760081876750522856447385449314981), SC_(-1.2902053653651567952294533933096375210439735077108891847803568051352256875471682427281829037705917110753962528e-05),
   SC_(1.9999847412109375), SC_(0.99999354891890056257515137297871569799850980919724170956673304961971970239682289813730037614565854931058777556), SC_(-6.4511019077505913999768740192962600117284299376931233759840535395258322495171008075393562455732103434271779936e-06),
   SC_(1.99999237060546875), SC_(0.9999967744354781276641509840822795646932230190615127686569485868080197715727798678679478106327910318239504207), SC_(-3.2255697240167648011165810641817631895943837273553238407652697319745391186873682927024999574143933330895472859e-06),
   SC_(1.999996185302734375), SC_(0.99999838721174601184126339217834043805312434049279307032066984380543456177710052395916314405417041535347717533), SC_(-1.6127895545325331730098184535055500629425336236844800875911774081883807398878631221152589710004973196673112522e-06),
   SC_(2), SC_(1), SC_(0),
   SC_(2.000003814697265625), SC_(1.0000016128002401193107443412962371398600117917051343176882902353374213648826021261731107498153573621415449226), SC_(1.6127989395584018429976031457249567704200403529787152140378258756848454641419753130324079036036484703727117411e-06),
   SC_(2.00000762939453125), SC_(1.0000032256124663969442572979664904621852226931085253304073996272098932739673609259903665211081794374661535793), SC_(3.2256072641202395856634567509031717314101059280836768227158909313339479749111914772604792191845536704065057073e-06),
   SC_(2.0000152587890625), SC_(1.000006451272877535864519325623917830418250216038636108564876372408652521536899197656914002663824783933815167), SC_(6.4512520681644922116961675029871399835844045626819177993485997811835355053462779555097865070545798819626865222e-06),
   SC_(2.000030517578125), SC_(1.0000129027375349091336312076553993133407166704260599330351817590690292004797492025331366878130500736080695094), SC_(1.290265429530719797568036294024708700465577586146791905518758190381008775700560429617670389988551638710825012e-05),
   SC_(2.00006103515625), SC_(1.0000258062421961242283255462273276791051475794593323673816513859750132897142264815427442208812997077505332853), SC_(2.5805909220784635000932542921243182948670906688837032708651521147551347202451406873759019347916128878550354773e-05),
   SC_(2.0001220703125), SC_(1.0000516155529531284521055204867710743151785504056984006043570298441519256563676489175498013305621139650047081), SC_(5.1614220916310804284840873086425506800915170103272447074807387337444948198364058458841314609676466202956173574e-05),
   SC_(2.000244140625), SC_(1.0001032433805951126501127539542219893980343833855735256110785456984214425363472065708089425349053632455548207), SC_(0.00010323805136409635819017324403933418099476148841019654151466840813072064903976559624757024778209256822407270965),
   SC_(2.00048828125), SC_(1.0002065358635097192658151850785898130248167354420242645236976497363236931336622251353563827692896592938578806), SC_(0.00020651453791454435671312914625370260965873904340641431837448444290893250461685654148110548976824081184555996094),
   SC_(2.0009765625), SC_(1.0004132681648321400916444646796498562442706774663304188532519599198372933280218068614047840617740820988545656), SC_(0.00041318279306425426425867498633204164488303891988195996296008500197515836906271837439664711441425330386370044763),
   SC_(2.001953125), SC_(1.0008273223095474155078382707606949018317230658419518813982206142503893794392842168571475939796796094738194073), SC_(0.00082698026708538384658581452916749300081501348027476197514651933598645209011126954522998623663964384545076784737),
   SC_(2.00390625), SC_(1.0016577903733583299338177980776731363027099651376641578674884824048249816826230893347340471967936198453732476), SC_(0.0016564177556961728691718611866123770809158280631257907208834264321979231840494137090508982490201065832908121409),
   SC_(2.0078125), SC_(1.0033281785323746329765896755229672377749078637142755140703121088361341887541356639322328573449912793392294147), SC_(0.0033226524041026498607928211387846544793681646025987622876953484650611433293961582857408451320107812632540480799),
   SC_(2.015625), SC_(1.0067068678083337925229893953788191809602967854127925098455603082110273932665513982270939607742887415224492271), SC_(0.0066844768302321849459648163438197694978676797752971342950752926557336453432652463099799428682789931143967973053),
   SC_(2.03125), SC_(1.0136167586362402558695922078875246426721753698548053570155112361366027573153765780253120138212935536023281976), SC_(0.013524883664985620968136945574525932294330293453783975814783864413614105845778864422474269341128528209147896345),
   SC_(2.0625), SC_(1.0280538218244951900574748173851462361436397335674399856202854886672315619683034832337777220754248275977710558), SC_(0.027667521522857023497407296289946080129146344977240133210479764492944486311282352627343782333338196694492200886),
   SC_(2.125), SC_(1.0594605373309141740983291964208781659608402545834638042007523606248433267935962143047149631452064325458319211), SC_(0.057759851530343871607388266263091590790261261618416983877273482993941813829532045934310864175292082963981368659),
   SC_(2.125), SC_(1.0594605373309141740983291964208781659608402545834638042007523606248433267935962143047149631452064325458319211), SC_(0.057759851530343871607388266263091590790261261618416983877273482993941813829532045934310864175292082963981368659),
   SC_(2.25), SC_(1.1330030963193463474783391112086475009359899009000204585729306248655997636058528505057375427260575938629599223), SC_(0.12487171489239659430244128761319866314897838194035725592991487603456576250457773842275438652511872681874913935),
   SC_(2.375), SC_(1.2222561575898098435208379005910864504106910392319456968215498256908489146064696738961777040038045096059490257), SC_(0.20069846037745584135888518027261109134866723494706223724132356736244017467986095189463419012919775182657330309),
   SC_(2.5), SC_(1.3293403881791370204736256125058588870981620920917903461603558423896834634432741360312129925539084990621701177), SC_(0.28468287047291915963249466968270192432013769555989472925014585038677593422163257555370073595863956755497197314),
};

static const boost::array<boost::array<T, 3>, 40> near_0 = {
   SC_(-0.5), SC_(-3.5449077018110320545963349666822903655950989122447742564276155797058225691820643627499013134770893308324536472), SC_(1.2655121234846453964889457971347059238991475408179110398774915452294625069121077554976749621341635413930063871),
   SC_(-0.375), SC_(-3.8253835949081514016960526385504616976858873925511128820551462882535845261389251056825519107350194495985744901), SC_(1.3416587485006664180414088132747834874363789654642744823426893875534469775753756869339978564518566788922789946),
   SC_(-0.25), SC_(-4.901666809860710580516393213451562107404956992432282444920475753159291553707193428948689504859660266328693521), SC_(1.5895753125511859903158972147787828359106675837030891563153360726716605621333640325822077713489225603702247544),
   SC_(-0.125), SC_(-8.7172188593831756100190140408231437691829605421405209641096323460290113397270360268767173986894739571058483852), SC_(2.1653002489051702517540619481440174064962195287626368747108560387197374851717119014002048759408477767728350775),
   SC_(-0.125), SC_(-8.7172188593831756100190140408231437691829605421405209641096323460290113397270360268767173986894739571058483852), SC_(2.1653002489051702517540619481440174064962195287626368747108560387197374851717119014002048759408477767728350775),
   SC_(-0.0625), SC_(-16.642832178988274743356205077790738057819224551873105775114555465613200830030172805581261680111638448013416759), SC_(2.8119796239743635383271560321736601168053640643142965724073032866652588956740311615653929614160048414373882428),
   SC_(-0.03125), SC_(-32.609040801813566418071361533700352796234402982757708313249608948510246716796649743807706619623233124415285482), SC_(3.4845895751341394376217526729956836492792382135545838747513220302846143713216776627947075542347606347812932675),
   SC_(-0.015625), SC_(-64.592895021803923401687310591184956132257852620576008851656274565294370687191413646963869993262704444628515002), SC_(4.1681044205572506375484381747769142138648379498874926763678807959138514127018146724233647135867482895326211992),
   SC_(-0.0078125), SC_(-128.58499852480401530135284249417597127907775444917997064208203063746267668873961104246029095484412968245555529), SC_(4.8565901527814217247857214496622784349723475051889437415484624107256449893582598466583154935270343853482532093),
   SC_(-0.00390625), SC_(-256.58109307066018254605277355095265865598290341287305639943282166998344086661991517831450399004593450520869623), SC_(5.5474447669674715952070818247210734705495040209931693437975489152255902055394669961191989376845895870056785217),
   SC_(-0.001953125), SC_(-512.57915088397912037127611069523606332152569834831565740841860024594479389303251398677660980272716580185829153), SC_(6.2394551398370460464865359486750822233240923241495142262282973804419276796587252605885022629924128386978750007),
   SC_(-0.0009765625), SC_(-1024.5781824062516573998933348321353958084008909835863236871355827314930134193447718920031232540278394672001457), SC_(6.9320362775113082175565786721095494761582286817492636972219574913672985956846164887359308054877632333869999562),
   SC_(-0.00048828125), SC_(-2048.5776988188734675195207869124937838781948120562638727221069064318965092668967452645498614337956765720147553), SC_(7.6249010258838589056112032453658101706532717642128135900064726950101977508747813314752005676395042766347340988),
   SC_(-0.000244140625), SC_(-4096.5774571877546497133129448824897208696543417684774145072771873520258697902075867736693231416852839388516552), SC_(8.3179071375412196353772991727418041069470987133443886451825640845551685565491787042054184177922276999407459318),
   SC_(-0.0001220703125), SC_(-8192.5773364128002405085423131290207095607477118824455478830737227517981664227716383633402439892710622649254566), SC_(9.0109838204323261925101725694129128145879930379896700959398781376806821096039472721561708996019050965927211732),
   SC_(-6.103515625e-05), SC_(-16384.577276035469593933614883128341038103720235335948750462409200392535439185883631637151600699265073745748403), SC_(9.7040957613515511140804875923086885344822151155125496190736160789898546402483381275986803463153051405752565365),
   SC_(-3.0517578125e-05), SC_(-32768.577245849340323934431490863213420538606204252100856465730714043705318027966700074078020448877073217681975), SC_(10.397225324389321751118257981741350715545033538430337479229750218348756164671019139428554102814000571479070659),
   SC_(-1.52587890625e-05), SC_(-65536.577230756909628996363610179019256663039402416314274757744375967671602673489918419843339804715063275773901), SC_(11.090363696762696206162694407004535550779972817434273639750684530523954335849427093356237883660100999788429204),
   SC_(-7.62939453125e-06), SC_(-131072.57722321085275738619063681843591600000426344750413647589546105124549065712526188209728475829273862142767), SC_(11.78350647337298147181546230662592344688602624116429729228034520587350457563299672747145157032696642372856542),
   SC_(-3.814697265625e-06), SC_(-262144.57721943786393940131990420461387822572889075747272123720027360758852386603599464842582811358907795642824), SC_(12.47665145199400263809495861913874999344625338521472943706726050616361678213557912354896418693243516760668981),
   SC_(3.814697265625e-06), SC_(262143.422788108034462562933172673185515456173555729293010111557065310773023629457669218260431013242835881758), SC_(12.476647048187965442022540472065347116383479487309949972008214741576509389536881912613656457111685822311497381),
   SC_(7.62939453125e-06), SC_(131071.42279188094404719627779254015209788304719898563008056199996243569123588178644135407350752403201320811243), SC_(11.783497665760906812760375842948903428176428075317647408343896845802285497485572186668336976548526173271184294),
   SC_(1.52587890625e-05), SC_(65535.422799426683985400271454517324214377507048398259894881509891790581311761565393366883893458417829165240563), SC_(11.090346081538544752770519882173193187528103071688531351284982261237177464624277027399310810395123887043769593),
   SC_(3.0517578125e-05), SC_(32767.422814517846946712424323330929297653533863422272563414016849898012012340553077313180372110926700212481801), SC_(10.397190093941001762077888432721419773538263621284980386087595611130083710453618086121153091365977520386941415),
   SC_(6.103515625e-05), SC_(16383.42284469890528218878340665131432419969255047068156812042208283397601650891029967666331544927732210443312), SC_(9.7040253004547744779513374741677442322475077760995803568370826388756352920940943196113558195081630558962910106),
   SC_(0.0001220703125), SC_(8191.4229050559521903657854129129664134445515043199266192085089372946579731735978622247768620431724581508606997), SC_(9.0108428986376796558566793644622196072876364393508694347316583669855087095187579636778323821368920315957144647),
   SC_(0.000244140625), SC_(4095.4230257497716410728030503892693258678381316784423536877219316935043691637502893910375698412728383522417053), SC_(8.317625293943180446655815151656334697387535209532543670469194897155588560215972212518948755582346678140303134),
   SC_(0.00048828125), SC_(2047.4232670563505463911594407202877340796685860085037290330908477694784828722752589234386616275074158784115589), SC_(7.6243373386178115967577294154935505415898425375792130346404403469224780410189955043518177534280650972663504023),
   SC_(0.0009765625), SC_(1023.4237493455678303694987182399302708889681657511559856385049045121007899402183357575652515632768974740375853), SC_(6.9309089024194618895406190646600805357272725481886499649320015816615110059419839952690782894844419715059702254),
   SC_(0.001953125), SC_(511.42471263063157444617301296353139248689125023795835087184238733343873973436982796062397441756165993353784545), SC_(6.2372003851753314191620008581209150671799664971974921624053434528952960658245919611157642239152398574405267058),
   SC_(0.00390625), SC_(255.42663404633623155853184130279527883554241352242007101168764662600237353911434545774758956065784696570576326), SC_(5.5429352218196013251930914897561820146741931488402650186086437521093596900778085868881275902670823260163243408),
   SC_(0.0078125), SC_(127.43045641142965881153833522301004049383015844259449629866661698582343060889735440205971422279331101313127698), SC_(4.8475707758816648668339547712848838673297433029418674530508358828122183838135267713566196701841430311657990729),
   SC_(0.015625), SC_(63.438020469891310987294839438025282541744240508473817235806384960497972351073761955971951743561333619630031293), SC_(4.1500633736539387872985034990504323420729999930696353454115420044388134539475338895506313252916341440491900744),
   SC_(0.03125), SC_(31.452835177076061273044315784146219215039623597918808654057075933450946166392291390846045519788018148144971949), SC_(3.4484891277979584796832693452686366085801342252961698900683219165794824084108803405324370764889485234264769516),
   SC_(0.0625), SC_(15.481281081592398156159620779446908026633633634897919783458416770518310580228570100461593932429926815589964135), SC_(2.739631621946203418585729650082232089144944407273537378878682102557800886267908796562155530267184749512155787),
   SC_(0.125), SC_(7.5339415987976119046992298412151336246104195881490759409831278977766636571989064128335286268103568536592492169), SC_(2.0194183575537963453202905211670995899482809521344496051319648726793149592104824058222593165263400306400501967),
   SC_(0.125), SC_(7.5339415987976119046992298412151336246104195881490759409831278977766636571989064128335286268103568536592492169), SC_(2.0194183575537963453202905211670995899482809521344496051319648726793149592104824058222593165263400306400501967),
   SC_(0.25), SC_(3.6256099082219083119306851558676720029951676828800654674333779995699192435387291216183601367233843003614717514), SC_(1.2880225246980774573706104402197172959253775651128605504999870225339612626756988362160738164176138661867887604),
   SC_(0.375), SC_(2.3704361844166009086464735041766525098874008033589249877751269346731615313580017917986476683710148065085072013), SC_(0.86307398227064746240508909413401549533247062934842713501214158155473398936618356558114368929134299687589643426),
   SC_(0.5), SC_(1.7724538509055160272981674833411451827975494561223871282138077898529112845910321813749506567385446654162268236), SC_(0.57236494292470008707171367567652935582364740645765578575681153573606888494241303989181163513774485385100490611),
};

static const boost::array<boost::array<T, 3>, 40> near_m10 = {
   SC_(-10.5), SC_(-2.6401218205477163162463853253112404396824684325225876560591681547776531412320896733077825213069197651551576322e-07), SC_(-15.147270590717841146101176395526319634361233144976539395806067304933214009506219449748237918628779426212247756),
   SC_(-10.375), SC_(-3.8538247770911000161675656207521103284982443268350536808271424732765885254708394649373422005676760008400862845e-07), SC_(-14.769029547207010126880427205161037877615976647148661939990931059310398340635726942011822643125761107580456434),
   SC_(-10.25), SC_(-6.7808180432946731304891004492754985848002028127645937925987831604279861015230319565197133049475246720265617509e-07), SC_(-14.203997900931090651611168760703872067369359534543268877527871797142641008794669162514478870187681525502707551),
   SC_(-10.125), SC_(-1.6848312620525174562168823278898954773941569991332984138613039137544611702464441186507014913285532369128084283e-06), SC_(-13.293845140389538484236785089823191703003394811834373853890795281383497051542460456218069071634943022448287749),
   SC_(-10.125), SC_(-1.6848312620525174562168823278898954773941569991332984138613039137544611702464441186507014913285532369128084283e-06), SC_(-13.293845140389538484236785089823191703003394811834373853890795281383497051542460456218069071634943022448287749),
   SC_(-10.0625), SC_(-3.8303281070203166358893255038075515689788548682068602059827696781608124010000092944728511165171308472386964422e-06), SC_(-12.472560090811655790399293558057858441571483321784488448140552924013774813892809787659569031629236371679128839),
   SC_(-10.03125), SC_(-8.2062995295301977865739252471114097581399704534847069178172887098466492511561233864084602910264856198265594463e-06), SC_(-11.710608463327203877922439589134156179378847473881039377256783779098476940306696210613202752304294682131268418),
   SC_(-10.015625), SC_(-1.7006998746430383834615574873683499132247356904352807785456785414586550135480125148421847460446894633835659992e-05), SC_(-10.981885607663038890372660918270813522611221711995411719058690162881036908939868531688553907126919411287616518),
   SC_(-10.0078125), SC_(-3.463458256516313677243695342138690766684809142189547960850013490387874801698738453473277516306844214190487446e-05), SC_(-10.270657878961264244105831591933113500642522530339833160069979898957856531876909280009891153999986577303842319),
   SC_(-10.00390625), SC_(-6.9903328747582090334264466990359269997790653299612523014453525670654238269220629079646079250632662914745041101e-05), SC_(-9.5683972882906823868530086836819678493673162133442777382100031989521977539800474524598896364796335003838921442),
   SC_(-10.001953125), SC_(-0.00014044773639004517085218511186084665040117005949411662519219403186667777541881413063638150159120500428997284589), SC_(-8.8706751213823100948059663871462545011894831848821935981721426737578215404617912777046971345675238130508911839),
   SC_(-10.0009765625), SC_(-0.0002815400414018834118126663382034402741479689594171010756083558783027365535191173266085209272398959320435563284), SC_(-8.1752358775093991610978176096814198666058029396327554625972822598030753524724073225250659907922887435361988651),
   SC_(-10.00048828125), SC_(-0.00056372640438562406339795157397595352175803840824393729467758565225052293961979009282839532228849140550901819684), SC_(-7.4809415227716591112920917790199883465363850706824864438555393281281733627770678389764713533283267723802617478),
   SC_(-10.000244140625), SC_(-0.0011281000088666906790099028077029688733534633312018939073522383169843972006791891083746340544137656977029625796), SC_(-6.7872204694935549116145712572380064251227733468906266602833942926516998884084256262328209944154842509580856106),
   SC_(-10.0001220703125), SC_(-0.0022568476575951849572338512766050487930850625293184263204693320098204581647371184438839524848065868431985384286), SC_(-6.0937862811673102385457363204870585320705297624776227202341269453083012501968923010671604671028494883139694941),
   SC_(-10.00006103515625), SC_(-0.0045143431750628939550724288601553265505525647611190489661018364911927229954027861461294408164473421068389146262), SC_(-5.400495578872419834979145899538225218652673336401402460949985869151998056499718543213055629562601331078338338),
   SC_(-10.000030517578125), SC_(-0.0090293343200355756478399974744597147912262573396960327275240218667234867315410338423464826636465932829121757205), SC_(-4.7072766329820541734836113471950573963927578010264651492145413498249528107073028945299745857456918034683085008),
   SC_(-10.0000152587890625), SC_(-0.01805931666500754906434806474181437991941766881544879124877659844144751708341968615676038223507335972382445726), SC_(-4.0140935686411618585462277846106506660699161075773229965810063609108594642004394925755368750818713942886926083),
   SC_(-10.00000762939453125), SC_(-0.036119281382466795747699608016365542645360304984522876478635716949605359588149124449398506063147283098365457863), SC_(-3.3209284459118088536424235871595334843808788990922450452806348667114328163342888050473951063973084685876207443),
   SC_(-10.000003814697265625), SC_(-0.072239210831143437784442631076517501061328351017534557386825420427208991397828223393126909285392207582909685565), SC_(-2.6277722941974261500946577710005105141808674548717098205508892010986355128153814698800661001225613213555912579),
   SC_(-9.999996185302734375), SC_(0.072240506991080140226280464486758514533737515018901029832903166227124013202904526666574637362350414490614743936), SC_(-2.6277543517490842715915533024499471614985034496459263514869947373789277617858159307952003679450429054090048394),
   SC_(-9.99999237060546875), SC_(0.036120577542403640698404710834445867288551703065790706542765373704676585286302915440960140762729857943113743194), SC_(-3.3208925610151250976409481654228433171371492088599903431349931831149381203023886830928385314956526143963256776),
   SC_(-9.9999847412109375), SC_(0.018060612824944964050522420153647987326759440429090182879472515318648397708797273550747584584544200555283075984), SC_(-4.0140217988477943545811450640575117955018130004911076783885699392302224415399109280900833116816446077477975638),
   SC_(-9.999969482421875), SC_(0.0090306304799752707758941626596459565197411504398981405305672474400443191735267440971853907490817836401673825686), SC_(-4.7071330933953192298563908896026844530558294019434613821600142656362705685591427608559131087722307670071704099),
   SC_(-9.99993896484375), SC_(0.0045156393350117096506906235123693717642525834884264548975756002470555437234213226039016466275186830824011549991), SC_(-5.4002084996989504621482648573278564806711207379749341638368371970751514723243487188721029178770263189901608029),
   SC_(-9.9998779296875), SC_(0.0022581438175804829238248097866602612484145368186317691587687683989148226748938244465292050256428844284406054563), SC_(-6.0932121228203756082724533754817787769633622618085393842967788052554447785887230884400714289450736790039304928),
   SC_(-9.999755859375), SC_(0.0011293961689979177409582533434385718648499977117105373699571877447937321743618349398302296852834539762401049319), SC_(-6.7860721527997185741758434624052069356140387438793337035461509813989634836354221109803516247925070522339098306),
   SC_(-9.99951171875), SC_(0.0005650225651005676902373042742306456894426751663163785063372803519818090560489289692863232794723772605605138254), SC_(-7.4786448893842498212775003061077738739629442621603838905244848422998329225846889688165479130280062735500001068),
   SC_(-9.9990234375), SC_(0.00028283620445169623360208006410504918893303259870304545298219926493573852339806310324072330819283446263445648985), SC_(-8.1706426107366876599766469685063136982163173031269613541112734472501752431806154620855941523707592358821573282),
   SC_(-9.998046875), SC_(0.00014174390877938173881755385055519122068838618578180179002632489356897973325849852862365474365887363071432149114), SC_(-8.8614885878537437239909034045275205498625084713195372673470850432327423783025263246622420625330828387002099979),
   SC_(-9.99609375), SC_(7.119953849576511774290270246050426493187892612378450120522214272512656687770624516610244744772466266046045893e-05), SC_(-9.5500242213684027018628650534771547352625329091599816412816260273825896031500048046845276735177601595018177102),
   SC_(-9.9921875), SC_(3.5930941760756412433601439672728188991952641189953864041371230226803762792766846195289464629690885330539776437e-05), SC_(-10.233911746195529494341636009604122245422344310878454861680046147466235002599645306931790254829751980426939683),
   SC_(-9.984375), SC_(1.830395592410737084371847753712605958897829969992610952084772709639305869757082989106363209867797862442107124e-05), SC_(-10.908393350762171699657964143696240687663821790887704824802780507800640785598149475120005640690502223974553771),
   SC_(-9.96875), SC_(9.505651717966543211040666528035462899478708721352313858572893055517428213772311465457742360062673498799299903e-06), SC_(-11.563624018570459074426000149190015660069301525083588717478426971926250695139858700844030463876648475101876574),
   SC_(-9.9375), SC_(5.1393098719794843214983768167746592270465393195053446784457500258107908538070746947791874439824691854907937821e-06), SC_(-12.178591753663558334615607691089929332278639626474014617397553470892979866404787276458175722283328560235748117),
   SC_(-9.875), SC_(3.0331378349844118367916527868421330423279022961121689459116361879468133814976899135069225672564620763035808775e-06), SC_(-12.705912885191709216330649855766060886050511713221700171057560196038359990767026197941657384611796420084690294),
   SC_(-9.875), SC_(3.0331378349844118367916527868421330423279022961121689459116361879468133814976899135069225672564620763035808775e-06), SC_(-12.705912885191709216330649855766060886050511713221700171057560196038359990767026197941657384611796420084690294),
   SC_(-9.75), SC_(2.1975471554628538878687097038174467045673963558516761458733594224768790871811561734110581396760034627420207205e-06), SC_(-13.02816874893114553892881831326149507953160856763706972216958177840795541404570842934499260464645281219524649),
   SC_(-9.625), SC_(2.2482144262764106485744600287631988468245040795826756238383242667919200286457284010570008975693593479892337832e-06), SC_(-13.005374245127447905440562160338200328457464849456589811238656297567198731475962077658512536105296188433561627),
   SC_(-9.5), SC_(2.7721279115751021320587045915768024616665918541487170388621265625165357982936941569731716473722657534129155138e-06), SC_(-12.795895333554363459017810536618790768152157991932184009732662830851533475505235930692826992223594497973217513),
};

static const boost::array<boost::array<T, 3>, 40> near_m55 = {
   SC_(-55.5), SC_(3.3139392476846767283772683472966711027379358916150215150100091113288581639716577666936138823743494933582485708e-74), SC_(-169.19315929474335779344369504127764360638576736584657350719841893651263762818182983422637103883600009475295023),
   SC_(-55.375), SC_(5.9318859132518291480114318459074384575764572752286332720058209655273732493724597193570531603155064624894472949e-74), SC_(-168.61095468989415809790338364314570312342609364969016065650021960725483321171774482698122412629076944633855119),
   SC_(-55.25), SC_(1.2813426521356120465015177624260127989204569715020077966304829152772083413607018666340428486300332280796208268e-73), SC_(-167.84080331341333383815979953761769175591813615840570079497886049657539310492828513105040463659546252211816577),
   SC_(-55.125), SC_(3.9131911034762969245238588487381041440846027762491865228553788345525175997195411344274833797237931115609718734e-73), SC_(-166.72435860843190139822628508932092125390175115884704297746744101312162433253081529570258774243551333817830547),
   SC_(-55.125), SC_(3.9131911034762969245238588487381041440846027762491865228553788345525175997195411344274833797237931115609718734e-73), SC_(-166.72435860843190139822628508932092125390175115884704297746744101312162433253081529570258774243551333817830547),
   SC_(-55.0625), SC_(9.8673260748719801875429285251138910685603226064990180114590137125530954288639029165366000246631264886799703812e-73), SC_(-165.79948288622388202234636515611843830505514258701793419810113570552493456762468969521506734143100583664732933),
   SC_(-55.03125), SC_(2.2266603436756153752904641869096011836186795399043787377981231678451750266953030611051107662716958210621245176e-72), SC_(-164.98562383636151624509401976786053064837595790874753092152373576035270874465656548258782871456207195221944214),
   SC_(-55.015625), SC_(4.7360694547400010557633537120899731339514832927411000411557017241069914315190052808401850645764826258988157223e-72), SC_(-164.23091913282262531153543074864624423458124037703612931710548143819607381413472198841194346813378767049857102),
   SC_(-55.0078125), SC_(9.7711411829383473352191234385949187141301095595021430916520807560660169392008422644376163773341508350241419744e-72), SC_(-163.50669343153341345258524324381801036966183326252171998393543422918069158015224990644429130175698598699531559),
   SC_(-55.00390625), SC_(1.9849813368130565400082616367736733898222309059037526584787565396148994249432311844770938652923241295223173372e-71), SC_(-162.79793209059158135187371040016035284056001188974505773778388041815604246557372874833520121084623675848324653),
   SC_(-55.001953125), SC_(4.0011527025839186802362202986064746607659562719948879104538703040305946839868510269637364333411827497280876609e-71), SC_(-162.09695910732599926634580619546086967483516523508116372639480433720335112449010866710477018788763078059531739),
   SC_(-55.0009765625), SC_(8.0337165791330065335975494516865674084243424087485487106774189934117418204397780662715970161029291548435735322e-71), SC_(-161.39989434494066669193445734325668854800347599330188459461000783505748749530276418597694449437396439975642739),
   SC_(-55.00048828125), SC_(1.6098955582234111797192918389653091448532474529983175191497792172611202123857866753532046573856256174280604906e-70), SC_(-160.70478720335970779044810048577706572168294270359200751102024774726873809107608410429108303843036597175851574),
   SC_(-55.000244140625), SC_(3.2229489383739069077426589427292221486316835695264580306146368181978314124729044747056203876145163299274839162e-70), SC_(-160.01065974976279784681276079462713523274703044269550248584357078652658101108956772105309588537940153835845253),
   SC_(-55.0001220703125), SC_(6.4490584927092060270881030241102009753530989802388015943440565730695270982447302276967661985453793370842809927e-70), SC_(-159.31702235955279567847278381399076746835459254718344944015223186406361061632854529086525121167403149843204951),
   SC_(-55.00006103515625), SC_(1.2901278999465709067481172051357680823144647144568010162984581701224308123653537826832760721024936282443616929e-69), SC_(-158.62363005588493092816609841988394155956583356426839818962424302647689373565571590600021022739583173660825912),
   SC_(-55.000030517578125), SC_(2.5805720712289037815987851594678385818056219448843736699329563576677642341882019081454419267963820729415843202e-69), SC_(-157.93036030920030332559475681177857998315815179296792358505521494080549634853806742842599525295140408602520327),
   SC_(-55.0000152587890625), SC_(5.1614604487657722043250649624190917425292416189357191604774760397102648986075958213671067240971910379231601532e-69), SC_(-157.23715184443533623970061088892203568266958809147580434329834884584272834667232463377062600899364515818112128),
   SC_(-55.00000762939453125), SC_(1.0323237221327282306659069651742858534255822887359607372715440005717339347982261692628904404013928528138747796e-68), SC_(-156.54397402148720988565208247423205185881626540946911738049902395409778731347569805387628207669123601334895297),
   SC_(-55.000003814697265625), SC_(2.0646790775194607155547973586647286676515701833028398450458745081506384416914447177006207163885808000864861054e-68), SC_(-155.85081151966175651492016050142678242361703242831924093683985874119382809840757393245978293124570333614782346),
   SC_(-54.999996185302734375), SC_(-2.0647423457763898724441926766911315065748070017125332824216525333206102831503809803767031509941257051095480361e-68), SC_(-155.85078087698790531440342542733440432240051900423559858958186239966734563886801864889432738076539471668895153),
   SC_(-54.99999237060546875), SC_(-1.0323869903896693318830692237031954173816799563002261478764664298984104173642680845761561815785364811365950836e-68), SC_(-156.54391273613950748465465267775551173404636022049848355502194287658532776162587291004675505997222135700600833),
   SC_(-54.9999847412109375), SC_(-5.1620931313356609896075688482137310567330154490050164964662354612513882037233620876810059122881731302591840784e-69), SC_(-157.23702927373993143799407410963469018278376350720219187972772250750700644789716664384228749551614603436871943),
   SC_(-54.999969482421875), SC_(-2.5812047538007036593280731337730752898602262231463037817558505350246736606350620972639615315635322909651300801e-69), SC_(-157.93011516780949372448826576252996308778678964456988096449223016883160136143552770098938132537009369756377915),
   SC_(-54.99993896484375), SC_(-1.2907605825260151543166837175559445009795374956430246284126711484577031924699174545944895326636671560177808025e-69), SC_(-158.62313977310331174440577639600157603341423045107632974931252232310276610527561242387710371984731250986549586),
   SC_(-54.9998779296875), SC_(-6.4553853188094233046876592895012648526525180150283982410436290391286449231992481112970048887626762406755841465e-70), SC_(-159.31604179398955745857342036334579627322321174599523639438610416496491311033164651485814292304911182363789844),
   SC_(-54.999755859375), SC_(-3.2292757656972235264817841973017091612850066235367577135589531310177286051775644893848808027910916408840977495e-70), SC_(-160.008698618636322587984278676721311394088533466446436344243872086944887040043886445247026629363735214473968),
   SC_(-54.99951171875), SC_(-1.6162223904391272987614396144702464048620728230822869522050389281968219339860682149986737507185342236122482244e-70), SC_(-160.70086494110676672055309472267163668000786442396165599182969366303437562734113536343158325224802778831022075),
   SC_(-54.9990234375), SC_(-8.0969850969864894557318737691129310533152378549300982938253861469921910001290234535035353039291664032683997005e-71), SC_(-161.39204982043486013424012017896022763434405540685541863080825447440184983633823935682152910471761682194009755),
   SC_(-54.998046875), SC_(-4.0644220032281560703728901101136615238229622973622761832467789502241278374515215353594012570458502857903981801e-71), SC_(-162.08127005831499080772273733065198611316466700027432803456286137458898401259735082441220119389429933849355178),
   SC_(-54.99609375), SC_(-2.0482537687077942321090221494955604658948917393938808734782620010367460550782558724337143218077466815606828151e-71), SC_(-162.76655399257440168875915457183408280308181309108442817686019319039574202034357650371627118245510718069276458),
   SC_(-54.9921875), SC_(-1.0403990765904058990542225796822538651968437182446447227222447641641087941482441402308781506170093116348625277e-71), SC_(-163.44393723553775215962440891211372104324292658809768134937071615839546889202248565570727559357168585211528697),
   SC_(-54.984375), SC_(-5.3694203178248012960900203599575845045610933561396749930640665980127154398291281623913230156597442878775142006e-72), SC_(-164.10540674114088699865988860882135830043683987131160528991359858820364329321760996768871762443071852512281227),
   SC_(-54.96875), SC_(-2.8620199166194479828493095671425742915953512414537009228248225603396036162945784882292674609093835486992929556e-72), SC_(-164.73459905547471402450903404825766145807171664983496017940723813429221345967182421940603213707285850265527743),
   SC_(-54.9375), SC_(-1.630184748946170270451320476784206632433100949854187290655399013933472279746756814511062145550705943739852752e-72), SC_(-165.29743334426367988801614492623357248875947820678485342207381159442753904137725281319125060291177520756987098),
   SC_(-54.875), SC_(-1.0680846658670924739602982648760091697857219572998674888647870128655188067134225296553126235143157749497843576e-72), SC_(-165.72025968301894168117211535724538401110675145308696617050338903177744719353297591311385180951230869443034591),
   SC_(-54.875), SC_(-1.0680846658670924739602982648760091697857219572998674888647870128655188067134225296553126235143157749497843576e-72), SC_(-165.72025968301894168117211535724538401110675145308696617050338903177744719353297591311385180951230869443034591),
   SC_(-54.75), SC_(-9.5458361856251771955421646288223745986868922040967488750625623295543548143461204454601975061372552514173142635e-73), SC_(-165.832606730654205986120867393356943779751171701619270053868138901004382167757346011577115957303576501169292),
   SC_(-54.625), SC_(-1.206186475649396145903288691554707530168287112342184654831637542295698786164449139797442886500595537701817763e-72), SC_(-165.59866298596103365955616501583662559837750698138902842335766258991320191255510277437255784261835345464069791),
   SC_(-54.5), SC_(-1.8392362824649955842493839327496524620195544198463369408305550567875162810042700605149557047177639688138279568e-72), SC_(-165.17677627399096896709758625478184730591369935521644314593949193117554720994255451755959707734651803272517273),
};
