# CiviCRM 5.7.0

Released November 7, 2018

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| Change the database schema?                                     |   no    |
| Alter the API?                                                  | **yes** |
| Require attention to configuration options?                     |   no    |
| Fix problems installing or upgrading to a previous version?     |   no    |
| Introduce features?                                             | **yes** |
| Fix bugs?                                                       | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Add icons to top-level navigation menu
  ([12878](https://github.com/civicrm/civicrm-core/pull/12878) and
  [13015](https://github.com/civicrm/civicrm-core/pull/13015))**

  Each item in the top (horizontal) level of the navigation menu is now
  accompanied by an icon.

- **Fix api profile.submit to work with tag & note fields
  ([12825](https://github.com/civicrm/civicrm-core/pull/12825))**

  This change improves the Profile API so that in the `submit` action one can
  add and remove tags and add a note field.

- **Better title for note field
  ([12827](https://github.com/civicrm/civicrm-core/pull/12827))**

  Updates the title of the note field from "note(s)" to "note" because you can
  only import one note at a time.

- **(DX) Civi::contactSettings - Add a facade for working with the logged-in
  user's settings
  ([12879](https://github.com/civicrm/civicrm-core/pull/12879))**

  This adds a helper method for accessing the SettingsBag of the contact
  corresponding to the logged-in user.

- **Improve display of relationships tab
  ([12800](https://github.com/civicrm/civicrm-core/pull/12800))**

  The relationships tab on a contact is now more consistent with the rest of
  CiviCRM, displaying correctly in standard output and in the Shoreditch theme.

- **Cleanup contact summary tabs code
  ([12941](https://github.com/civicrm/civicrm-core/pull/12941))**

  A largely non-functional change, this makes it possible for extensions to
  modify the order of tabs on a contact record.

### CiviContribute

- **Use cached function for financialAccount retrieval.
  ([12773](https://github.com/civicrm/civicrm-core/pull/12773))**

  This is a performance improvement which reduces repetitive queries when
  creating contributions.

- **Allow descriptions for payment fields
  ([12721](https://github.com/civicrm/civicrm-core/pull/12721))**

  This change makes it so a payment processor extension can add a description to
  a payment field.

### CiviEvent

- **Allow to specify template_id on URL when creating a new event
  ([12781](https://github.com/civicrm/civicrm-core/pull/12781))**

  Adding the `template_id` URL parameter with the ID of an event template will
  now load the New Event form using that template.

### CiviMember

- **Convert membership date fields to datepicker & form to entity form
  ([12690](https://github.com/civicrm/civicrm-core/pull/12690))**

  Updates the membership date fields to datepicker rather than jCalendar.  This
  also uses the new entityFormTrait methods to add the fields in a more
  systematic way.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **[dev/core#396](https://lab.civicrm.org/dev/core/issues/396) date ranges are
  lost when creating smart groups
  ([12909](https://github.com/civicrm/civicrm-core/pull/12909))**

  This change fixes a regression where smart groups created using a manually
  entered date range (the user sets a start and end date as opposed to a preset
  range like "this year") would ignore the dates.

- **[dev/core#376](https://lab.civicrm.org/dev/core/issues/376) Contact Detail
  report breaks when adding clause using selectWhereClause()
  ([12772](https://github.com/civicrm/civicrm-core/pull/12772))**

  Extensions using `hook_civicrm_selectWhereClause` to modify the Contact Detail
  report would cause a database error.

- **[dev/report#6](https://lab.civicrm.org/dev/report/issues/6)
  getAddressColumns defined `street_name` twice
  ([12808](https://github.com/civicrm/civicrm-core/pull/12808))**

  This change fixes a bug where for reports that use the common function to get
  address fields one could not sort by the "street name" field.

- **Fix invalid markup on extension page - remove dots from ids & classes
  ([12882](https://github.com/civicrm/civicrm-core/pull/12882))**

- **Don't mess up fragment links in nav menu
  ([12876](https://github.com/civicrm/civicrm-core/pull/12876))**

  Fixes a bug where where fragment links (for example, javascript-oriented links
  like `<a href="#summary">`) were not rendering properly in the navigation menu.

- **[dev/core#362](https://lab.civicrm.org/dev/core/issues/362) Contact
  Reference Fields don't allow search and select On Behalf Profiles
  ([12790](https://github.com/civicrm/civicrm-core/pull/12790))**

  Contact reference fields that were added to the on-behalf profile on a
  contribution page would not have the expected Select2 widget: they would
  simply appear as text fields.  The fields now appear as expected.

- **Freeze custom data elements when viewing an entity
  ([12867](https://github.com/civicrm/civicrm-core/pull/12867))**

  When viewing an entity with custom data, the custom data would appear as a
  form, though no changes would be saved.  Custom fields now appear frozen in
  view mode, just like the rest of the entity's fields.

- **[dev/core#393](https://lab.civicrm.org/dev/core/issues/393) OptionGroup
  check doesn't like option values of zero in a group of integers
  ([12817](https://github.com/civicrm/civicrm-core/pull/12817))**

  The system check for invalid option values no longer displays a notice if a
  value of `0` is part of an integer option group.

- **Fixed spacing between & table structure issues
  ([12811](https://github.com/civicrm/civicrm-core/pull/12811))**

  This change cleans up the layout (spacing and table structure) on events &
  membership pages.

- **Fixed pages dropdown design issues
  ([12812](https://github.com/civicrm/civicrm-core/pull/12812))**

  This change cleans up and standardizes the markup on the CiviCampaign GOTV
  display.

- **[dev/core#379](https://lab.civicrm.org/dev/core/issues/379) View Activity:
   extraneous newlines by nl2br on HTML content
  ([12778](https://github.com/civicrm/civicrm-core/pull/12778))**

  This change fixes extra spacing added in the details field on an activity.

- **Display tables correctly on import wizard/membership dashboard when using
  drupal bootstrap based theme
  ([12799](https://github.com/civicrm/civicrm-core/pull/12799))**

  This change fixes the display of tables on the import wizard and the
  membership dashboard for Drupal sites that use a Bootstrap based theme.

- **[dev/core#382](https://lab.civicrm.org/dev/core/issues/382) DB Error
  generated when updating a group with an organisation record attached where the
  id in the civicrm_group_organisation does not match the id in civicrm_group
  ([12785](https://github.com/civicrm/civicrm-core/pull/12785))**

- **Fix capitalisation for 'Republic of' countries (Iran, Macedonia)
  ([12802](https://github.com/civicrm/civicrm-core/pull/12802))**

  This change fixes "Republic of" countries (like Iran and Macedonia) so that
  the "of" is not capitalized.

- **[dev/core#428](https://lab.civicrm.org/dev/core/issues/428) Fatal error in
  Activity Details report when Sorting uses Section Header
  ([12915](https://github.com/civicrm/civicrm-core/pull/12915))**

- **Fix regression on activity detail report add to group
  ([12963](https://github.com/civicrm/civicrm-core/pull/12963))**

  This resolves a database error that would appear when adding contacts to a
  group from the Activity Detail report.

- **Contact summary report with location type selected: fixed fatal error for
  function not found
  ([12967](https://github.com/civicrm/civicrm-core/pull/12967))**

- **Remove contact tags when none selected on edit screen
  ([12958](https://github.com/civicrm/civicrm-core/pull/12958))**

  From the contact edit form, unselecting all of a contact's tags would not
  result in any changes.

- **[dev/core#462](https://lab.civicrm.org/dev/core/issues/462) Export temporary
  tables cause Advanced Logging warning of missing log tables
  ([12984](https://github.com/civicrm/civicrm-core/pull/12984))**

### CiviCase

- **[dev/core#370](https://lab.civicrm.org/dev/core/issues/370) No new tasks and
  documents get added to workflow if all built-in ones are deleted
  ([12748](https://github.com/civicrm/civicrm-core/pull/12748))**

  This change makes it so one can delete all built in tasks associated with the
  standard workflow of a case type and then add new ones. Before this change if
  you deleted all existing tasks associated with a case type you could not add
  new ones.

- **Remove Stray Extra Div in Case Dashboard TPL
([12848](https://github.com/civicrm/civicrm-core/pull/12848))**

  This change removes an extra div tag on the case dashboard that was messing up
  the layout of the page for some WordPress users.

### CiviContribute

- **Add span to amount label in Confirm.tpl
  ([12847](https://github.com/civicrm/civicrm-core/pull/12847))**

  This change adds a HTML `<span>` tag to the amount label on the Contribution
  Confirm page to make it so one can more easily hide labels as needed.

- **When submitting a standalone credit card contribution the contact email
  address should not be deleted
  ([12854](https://github.com/civicrm/civicrm-core/pull/12854))**

- **Remove duplicate payment processor select on Membership Renewal form
  ([12734](https://github.com/civicrm/civicrm-core/pull/12734))**

  This removes an extraneous second Payment Processor field from the backend
  credit card membership renewal form.

- **[dev/core#386](https://lab.civicrm.org/dev/core/issues/386) Contribution
  Detail Report shows no amount if set to Soft Credit Only.
  ([12860](https://github.com/civicrm/civicrm-core/pull/12860))**

  This change fixes a bug on the Contribution Detail Report where, if the report
  was configured to show only Soft Credit amounts, the Amount column would
  display as empty.

- **fixing batch search by payment method
  ([12707](https://github.com/civicrm/civicrm-core/pull/12707))**

  The Payment Method field was ignored when searching for transactions to add to
  an accounting batch.  It now filters transactions correctly if the field is
  set.

### CiviEvent

- **Don't show 'Register Participant' on the manage events page if the logged in
  user does not have 'Edit Event Participants' permission
  ([12768](https://github.com/civicrm/civicrm-core/pull/12768))**

- **Fix default for repetition_start_date
  ([12997](https://github.com/civicrm/civicrm-core/pull/12997))**

  The start date for repeating events now defaults to the current event's start
  date.

### CiviMail

- **[dev/core#448](https://lab.civicrm.org/dev/core/issues/448) When creating a
  CiviCRM Mailing including a Smart Group, All contacts met by the criteria of
  the smart group are added. There is no check performed to make sure that
  contacts removed from the smart group aren't included**

- **[dev/core#281](https://lab.civicrm.org/dev/core/issues/281) Fix invoice
  number in message template
  ([12856](https://github.com/civicrm/civicrm-core/pull/12856))**

  This change fixes a bug where when printing or emailing an invoice the
  Invoice Number field would show the invoice ID instead of the human-readable
  invoice number.

- **[dev/core#421](https://lab.civicrm.org/dev/core/issues/421) Creating a new
  message template from within CiviMail interface requires both edit user
  workflow templates and edit system workflow templates as well as edit message
  templates ([12896](https://github.com/civicrm/civicrm-core/pull/12896))**

  A past version added separate permissions for editing system workflow message
  templates and editing user-driven message templates.  These are meant to be
  more granular alternatives to the permission to edit message templates.  A bug
  in the CiviMail workflow required all three permissions to create a new
  message template.  Now, you can create a template if you have either the
  legacy general permission to edit message templates or the relevant new
  specific permission.

- **Renamed Mailing Component entity
  ([12728](https://github.com/civicrm/civicrm-core/pull/12728) and
  [12877](https://github.com/civicrm/civicrm-core/pull/12877))**

  This change renames the Mailing Component entity from
  CRM/Core/DAO/Component.php to CRM/Core/DAO/MailingComponent.php to fix some
  extension compatibility issues.

- **[dev/core#410](https://lab.civicrm.org/dev/core/issues/410) Validation
  Problems on Scheduled Reminders Form With SMS
  ([12874](https://github.com/civicrm/civicrm-core/pull/12874))**

  This change cleans up the SMS reminder form to properly denote which fields
  are required and which are optional.

### Joomla Integration

- **Fixed Joomla menu z-index regression
  [12952](https://github.com/civicrm/civicrm-core/pull/12952)**

  This resolves a bug where the Joomla menus would open beneath the CiviCRM
  menu.  It also moves the CiviCRM menu directly below the Joomla menu.

## <a name="misc"></a>Miscellany

- **Rename variable in MembershipRenewal form to make a merge with Membership
  form in future easier
  ([12798](https://github.com/civicrm/civicrm-core/pull/12798))**

- **Report Template test for SelectWhere - add test
  ([12809](https://github.com/civicrm/civicrm-core/pull/12809))**

- **Alter Test to ensure that order of city is output doesn't mater in th…
  ([12815](https://github.com/civicrm/civicrm-core/pull/12815))**

- **Just a test. ([12794](https://github.com/civicrm/civicrm-core/pull/12794))**

- **NFC: Rename variable in RecurringEntityPreview
  ([12770](https://github.com/civicrm/civicrm-core/pull/12770))**

- **NFC: fix grammar/punctuation in help
  ([12838](https://github.com/civicrm/civicrm-core/pull/12838))**

- **[NFC] Add unit test to cover component ACLs.
  ([12846](https://github.com/civicrm/civicrm-core/pull/12846))**

- **NFC Fix overindenting in caseDashboard template
  ([12853](https://github.com/civicrm/civicrm-core/pull/12853))**

- **(NFC) Fix indenting of Case DashBoard.tpl
  ([12849](https://github.com/civicrm/civicrm-core/pull/12849))**

- **Fix typo ([12858](https://github.com/civicrm/civicrm-core/pull/12858))**

- **[CRM-21677](https://issues.civicrm.org/jira/browse/CRM-21677) Report
  improvements ([12885](https://github.com/civicrm/civicrm-core/pull/12885))
  (follow-up)**

  This cleans up code related to a prior change.

- **Export code improvement
  ([12672](https://github.com/civicrm/civicrm-core/pull/12672))**

- **Cleanup pledge form to use datepicker
  ([12774](https://github.com/civicrm/civicrm-core/pull/12774))**

- **Fixed wrapper
  ([12820](https://github.com/civicrm/civicrm-core/pull/12820))**

- **Add new paymentprocessor supportsX methods to replace remaining isSupported
  methods ([12762](https://github.com/civicrm/civicrm-core/pull/12762))**

- **Convert "Info and Settings" tab on ManageEvent to use datepicker
  ([12776](https://github.com/civicrm/civicrm-core/pull/12776))**

- **Switch grant form to use crmDatepicker instead of jCalendar
  ([12771](https://github.com/civicrm/civicrm-core/pull/12771))**

- **Convert RecurringEntity form to datepicker
  ([12746](https://github.com/civicrm/civicrm-core/pull/12746))**

- **(NFC) Make the test concurrency test not run on PR testing but on matrix
  alone until we can sort out the issue
  ([12961](https://github.com/civicrm/civicrm-core/pull/12961))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andrew Hunt; Australian Greens - Seamus Lee;
CiviCRM - Coleman Watts, Tim Otten; CiviDesk - Yashodha Chaku; CompuCorp -
Mukesh Ram; Coop SymbioTIC - Mathieu Lutfy; JMA Consulting - Joe Murray;
Lemniscus - Noah Miller; Megaphone Technology Consulting - Jon Goldberg; MJW
Consulting - Matthew Wire; mmyriam; Pradeep Nayak; Progressive Technology
Project - Jamie McClelland; Samson Alajede; Tadpole Collective - Kevin
Cristiano; Tanya Bouman; Team Expansion - Greg Harris; Wikimedia Foundation -
Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Circle Interactive - Dave Jenkins; Digitalcourage - Detlev Sieber; JMA
Consulting - Monish Deb; Joinery - Allen Shaw

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andrew Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
