// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file declarations.hpp
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen.
 */

#ifndef FAST_DDS_GENERATED__DECLARATIONS_HPP
#define FAST_DDS_GENERATED__DECLARATIONS_HPP

#include <cstdint>
#include <functional>
#include <string>
#include <utility>
#include <vector>

#include <fastcdr/cdr/fixed_size_string.hpp>
#include <fastcdr/exceptions/BadParamException.h>


#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(DECLARATIONS_SOURCE)
#define DECLARATIONS_DllAPI __declspec( dllexport )
#else
#define DECLARATIONS_DllAPI __declspec( dllimport )
#endif // DECLARATIONS_SOURCE
#else
#define DECLARATIONS_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define DECLARATIONS_DllAPI
#endif // _WIN32

class ForwardStruct;

class ForwardUnion;

typedef std::vector<ForwardStruct> RecursiveUnboundedSeqForwardStruct;

typedef std::vector<ForwardStruct> RecursiveBoundedSeqForwardStruct;

typedef std::vector<ForwardUnion> RecursiveUnboundedSeqForwardUnion;

typedef std::vector<ForwardUnion> RecursiveBoundedSeqForwardUnion;


/*!
 * @brief This class represents the structure ForwardDeclarationsRecursiveStruct defined by the user in the IDL file.
 * @ingroup declarations
 */
class ForwardDeclarationsRecursiveStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ForwardDeclarationsRecursiveStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ForwardDeclarationsRecursiveStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ForwardDeclarationsRecursiveStruct that will be copied.
     */
    eProsima_user_DllExport ForwardDeclarationsRecursiveStruct(
            const ForwardDeclarationsRecursiveStruct& x)
    {
                    m_var_RecursiveUnboundedSeqForwardStruct = x.m_var_RecursiveUnboundedSeqForwardStruct;

                    m_var_RecursiveBoundedSeqForwardStruct = x.m_var_RecursiveBoundedSeqForwardStruct;

                    m_var_RecursiveUnboundedSeqForwardUnion = x.m_var_RecursiveUnboundedSeqForwardUnion;

                    m_var_RecursiveBoundedSeqForwardUnion = x.m_var_RecursiveBoundedSeqForwardUnion;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ForwardDeclarationsRecursiveStruct that will be copied.
     */
    eProsima_user_DllExport ForwardDeclarationsRecursiveStruct(
            ForwardDeclarationsRecursiveStruct&& x) noexcept
    {
        m_var_RecursiveUnboundedSeqForwardStruct = std::move(x.m_var_RecursiveUnboundedSeqForwardStruct);
        m_var_RecursiveBoundedSeqForwardStruct = std::move(x.m_var_RecursiveBoundedSeqForwardStruct);
        m_var_RecursiveUnboundedSeqForwardUnion = std::move(x.m_var_RecursiveUnboundedSeqForwardUnion);
        m_var_RecursiveBoundedSeqForwardUnion = std::move(x.m_var_RecursiveBoundedSeqForwardUnion);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ForwardDeclarationsRecursiveStruct that will be copied.
     */
    eProsima_user_DllExport ForwardDeclarationsRecursiveStruct& operator =(
            const ForwardDeclarationsRecursiveStruct& x)
    {

                    m_var_RecursiveUnboundedSeqForwardStruct = x.m_var_RecursiveUnboundedSeqForwardStruct;

                    m_var_RecursiveBoundedSeqForwardStruct = x.m_var_RecursiveBoundedSeqForwardStruct;

                    m_var_RecursiveUnboundedSeqForwardUnion = x.m_var_RecursiveUnboundedSeqForwardUnion;

                    m_var_RecursiveBoundedSeqForwardUnion = x.m_var_RecursiveBoundedSeqForwardUnion;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ForwardDeclarationsRecursiveStruct that will be copied.
     */
    eProsima_user_DllExport ForwardDeclarationsRecursiveStruct& operator =(
            ForwardDeclarationsRecursiveStruct&& x) noexcept
    {

        m_var_RecursiveUnboundedSeqForwardStruct = std::move(x.m_var_RecursiveUnboundedSeqForwardStruct);
        m_var_RecursiveBoundedSeqForwardStruct = std::move(x.m_var_RecursiveBoundedSeqForwardStruct);
        m_var_RecursiveUnboundedSeqForwardUnion = std::move(x.m_var_RecursiveUnboundedSeqForwardUnion);
        m_var_RecursiveBoundedSeqForwardUnion = std::move(x.m_var_RecursiveBoundedSeqForwardUnion);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ForwardDeclarationsRecursiveStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ForwardDeclarationsRecursiveStruct& x) const
    {
        return (m_var_RecursiveUnboundedSeqForwardStruct == x.m_var_RecursiveUnboundedSeqForwardStruct &&
           m_var_RecursiveBoundedSeqForwardStruct == x.m_var_RecursiveBoundedSeqForwardStruct &&
           m_var_RecursiveUnboundedSeqForwardUnion == x.m_var_RecursiveUnboundedSeqForwardUnion &&
           m_var_RecursiveBoundedSeqForwardUnion == x.m_var_RecursiveBoundedSeqForwardUnion);
    }

    /*!
     * @brief Comparison operator.
     * @param x ForwardDeclarationsRecursiveStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ForwardDeclarationsRecursiveStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_RecursiveUnboundedSeqForwardStruct
     * @param _var_RecursiveUnboundedSeqForwardStruct New value to be copied in member var_RecursiveUnboundedSeqForwardStruct
     */
    eProsima_user_DllExport void var_RecursiveUnboundedSeqForwardStruct(
            const RecursiveUnboundedSeqForwardStruct& _var_RecursiveUnboundedSeqForwardStruct)
    {
        m_var_RecursiveUnboundedSeqForwardStruct = _var_RecursiveUnboundedSeqForwardStruct;
    }

    /*!
     * @brief This function moves the value in member var_RecursiveUnboundedSeqForwardStruct
     * @param _var_RecursiveUnboundedSeqForwardStruct New value to be moved in member var_RecursiveUnboundedSeqForwardStruct
     */
    eProsima_user_DllExport void var_RecursiveUnboundedSeqForwardStruct(
            RecursiveUnboundedSeqForwardStruct&& _var_RecursiveUnboundedSeqForwardStruct)
    {
        m_var_RecursiveUnboundedSeqForwardStruct = std::move(_var_RecursiveUnboundedSeqForwardStruct);
    }

    /*!
     * @brief This function returns a constant reference to member var_RecursiveUnboundedSeqForwardStruct
     * @return Constant reference to member var_RecursiveUnboundedSeqForwardStruct
     */
    eProsima_user_DllExport const RecursiveUnboundedSeqForwardStruct& var_RecursiveUnboundedSeqForwardStruct() const
    {
        return m_var_RecursiveUnboundedSeqForwardStruct;
    }

    /*!
     * @brief This function returns a reference to member var_RecursiveUnboundedSeqForwardStruct
     * @return Reference to member var_RecursiveUnboundedSeqForwardStruct
     */
    eProsima_user_DllExport RecursiveUnboundedSeqForwardStruct& var_RecursiveUnboundedSeqForwardStruct()
    {
        return m_var_RecursiveUnboundedSeqForwardStruct;
    }


    /*!
     * @brief This function copies the value in member var_RecursiveBoundedSeqForwardStruct
     * @param _var_RecursiveBoundedSeqForwardStruct New value to be copied in member var_RecursiveBoundedSeqForwardStruct
     */
    eProsima_user_DllExport void var_RecursiveBoundedSeqForwardStruct(
            const RecursiveBoundedSeqForwardStruct& _var_RecursiveBoundedSeqForwardStruct)
    {
        m_var_RecursiveBoundedSeqForwardStruct = _var_RecursiveBoundedSeqForwardStruct;
    }

    /*!
     * @brief This function moves the value in member var_RecursiveBoundedSeqForwardStruct
     * @param _var_RecursiveBoundedSeqForwardStruct New value to be moved in member var_RecursiveBoundedSeqForwardStruct
     */
    eProsima_user_DllExport void var_RecursiveBoundedSeqForwardStruct(
            RecursiveBoundedSeqForwardStruct&& _var_RecursiveBoundedSeqForwardStruct)
    {
        m_var_RecursiveBoundedSeqForwardStruct = std::move(_var_RecursiveBoundedSeqForwardStruct);
    }

    /*!
     * @brief This function returns a constant reference to member var_RecursiveBoundedSeqForwardStruct
     * @return Constant reference to member var_RecursiveBoundedSeqForwardStruct
     */
    eProsima_user_DllExport const RecursiveBoundedSeqForwardStruct& var_RecursiveBoundedSeqForwardStruct() const
    {
        return m_var_RecursiveBoundedSeqForwardStruct;
    }

    /*!
     * @brief This function returns a reference to member var_RecursiveBoundedSeqForwardStruct
     * @return Reference to member var_RecursiveBoundedSeqForwardStruct
     */
    eProsima_user_DllExport RecursiveBoundedSeqForwardStruct& var_RecursiveBoundedSeqForwardStruct()
    {
        return m_var_RecursiveBoundedSeqForwardStruct;
    }


    /*!
     * @brief This function copies the value in member var_RecursiveUnboundedSeqForwardUnion
     * @param _var_RecursiveUnboundedSeqForwardUnion New value to be copied in member var_RecursiveUnboundedSeqForwardUnion
     */
    eProsima_user_DllExport void var_RecursiveUnboundedSeqForwardUnion(
            const RecursiveUnboundedSeqForwardUnion& _var_RecursiveUnboundedSeqForwardUnion)
    {
        m_var_RecursiveUnboundedSeqForwardUnion = _var_RecursiveUnboundedSeqForwardUnion;
    }

    /*!
     * @brief This function moves the value in member var_RecursiveUnboundedSeqForwardUnion
     * @param _var_RecursiveUnboundedSeqForwardUnion New value to be moved in member var_RecursiveUnboundedSeqForwardUnion
     */
    eProsima_user_DllExport void var_RecursiveUnboundedSeqForwardUnion(
            RecursiveUnboundedSeqForwardUnion&& _var_RecursiveUnboundedSeqForwardUnion)
    {
        m_var_RecursiveUnboundedSeqForwardUnion = std::move(_var_RecursiveUnboundedSeqForwardUnion);
    }

    /*!
     * @brief This function returns a constant reference to member var_RecursiveUnboundedSeqForwardUnion
     * @return Constant reference to member var_RecursiveUnboundedSeqForwardUnion
     */
    eProsima_user_DllExport const RecursiveUnboundedSeqForwardUnion& var_RecursiveUnboundedSeqForwardUnion() const
    {
        return m_var_RecursiveUnboundedSeqForwardUnion;
    }

    /*!
     * @brief This function returns a reference to member var_RecursiveUnboundedSeqForwardUnion
     * @return Reference to member var_RecursiveUnboundedSeqForwardUnion
     */
    eProsima_user_DllExport RecursiveUnboundedSeqForwardUnion& var_RecursiveUnboundedSeqForwardUnion()
    {
        return m_var_RecursiveUnboundedSeqForwardUnion;
    }


    /*!
     * @brief This function copies the value in member var_RecursiveBoundedSeqForwardUnion
     * @param _var_RecursiveBoundedSeqForwardUnion New value to be copied in member var_RecursiveBoundedSeqForwardUnion
     */
    eProsima_user_DllExport void var_RecursiveBoundedSeqForwardUnion(
            const RecursiveBoundedSeqForwardUnion& _var_RecursiveBoundedSeqForwardUnion)
    {
        m_var_RecursiveBoundedSeqForwardUnion = _var_RecursiveBoundedSeqForwardUnion;
    }

    /*!
     * @brief This function moves the value in member var_RecursiveBoundedSeqForwardUnion
     * @param _var_RecursiveBoundedSeqForwardUnion New value to be moved in member var_RecursiveBoundedSeqForwardUnion
     */
    eProsima_user_DllExport void var_RecursiveBoundedSeqForwardUnion(
            RecursiveBoundedSeqForwardUnion&& _var_RecursiveBoundedSeqForwardUnion)
    {
        m_var_RecursiveBoundedSeqForwardUnion = std::move(_var_RecursiveBoundedSeqForwardUnion);
    }

    /*!
     * @brief This function returns a constant reference to member var_RecursiveBoundedSeqForwardUnion
     * @return Constant reference to member var_RecursiveBoundedSeqForwardUnion
     */
    eProsima_user_DllExport const RecursiveBoundedSeqForwardUnion& var_RecursiveBoundedSeqForwardUnion() const
    {
        return m_var_RecursiveBoundedSeqForwardUnion;
    }

    /*!
     * @brief This function returns a reference to member var_RecursiveBoundedSeqForwardUnion
     * @return Reference to member var_RecursiveBoundedSeqForwardUnion
     */
    eProsima_user_DllExport RecursiveBoundedSeqForwardUnion& var_RecursiveBoundedSeqForwardUnion()
    {
        return m_var_RecursiveBoundedSeqForwardUnion;
    }



private:

    RecursiveUnboundedSeqForwardStruct m_var_RecursiveUnboundedSeqForwardStruct;
    RecursiveBoundedSeqForwardStruct m_var_RecursiveBoundedSeqForwardStruct;
    RecursiveUnboundedSeqForwardUnion m_var_RecursiveUnboundedSeqForwardUnion;
    RecursiveBoundedSeqForwardUnion m_var_RecursiveBoundedSeqForwardUnion;

};
/*!
 * @brief This class represents the union ForwardUnion defined by the user in the IDL file.
 * @ingroup declarations
 */
class ForwardUnion
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ForwardUnion()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ForwardUnion()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ForwardUnion that will be copied.
     */
    eProsima_user_DllExport ForwardUnion(
            const ForwardUnion& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            case_zero_() = x.m_case_zero;
                            break;

                        case 0x00000002:
                            case_one_() = x.m_case_one;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ForwardUnion that will be copied.
     */
    eProsima_user_DllExport ForwardUnion(
            ForwardUnion&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            case_zero_() = std::move(x.m_case_zero);
                            break;

                        case 0x00000002:
                            case_one_() = std::move(x.m_case_one);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ForwardUnion that will be copied.
     */
    eProsima_user_DllExport ForwardUnion& operator =(
            const ForwardUnion& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            case_zero_() = x.m_case_zero;
                            break;

                        case 0x00000002:
                            case_one_() = x.m_case_one;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ForwardUnion that will be copied.
     */
    eProsima_user_DllExport ForwardUnion& operator =(
            ForwardUnion&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            case_zero_() = std::move(x.m_case_zero);
                            break;

                        case 0x00000002:
                            case_one_() = std::move(x.m_case_one);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ForwardUnion object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ForwardUnion& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_case_zero == m_case_zero);
                                                        break;

                                                    case 0x00000002:
                                                        ret_value = (x.m_case_one == m_case_one);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x ForwardUnion object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ForwardUnion& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            int32_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 0:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case 1:
                            if (0x00000002 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport int32_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function sets a value in member case_zero
     * @param _case_zero New value for member case_zero
     */
    eProsima_user_DllExport void case_zero(
            int32_t _case_zero)
    {
        case_zero_() = _case_zero;
        m__d = 0;
    }

    /*!
     * @brief This function returns the value of member case_zero
     * @return Value of member case_zero
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t case_zero() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_case_zero;
    }

    /*!
     * @brief This function returns a reference to member case_zero
     * @return Reference to member case_zero
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t& case_zero()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_case_zero;
    }


    /*!
     * @brief This function sets a value in member case_one
     * @param _case_one New value for member case_one
     */
    eProsima_user_DllExport void case_one(
            int32_t _case_one)
    {
        case_one_() = _case_one;
        m__d = 1;
    }

    /*!
     * @brief This function returns the value of member case_one
     * @return Value of member case_one
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t case_one() const
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_case_one;
    }

    /*!
     * @brief This function returns a reference to member case_one
     * @return Reference to member case_one
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t& case_one()
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_case_one;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            int32_t& case_zero_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = nullptr;
                    m_case_zero = {0};

                }

                return m_case_zero;
            }

            int32_t& case_one_()
            {
                if (0x00000002 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000002;
                    member_destructor_ = nullptr;
                    m_case_one = {0};

                }

                return m_case_one;
            }


    int32_t m__d {2147483647};

    union
    {
        int32_t m_case_zero;
        int32_t m_case_one;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the structure ForwardStruct defined by the user in the IDL file.
 * @ingroup declarations
 */
class ForwardStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ForwardStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ForwardStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ForwardStruct that will be copied.
     */
    eProsima_user_DllExport ForwardStruct(
            const ForwardStruct& x)
    {
                    m_var_short = x.m_var_short;

                    m_var_long = x.m_var_long;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ForwardStruct that will be copied.
     */
    eProsima_user_DllExport ForwardStruct(
            ForwardStruct&& x) noexcept
    {
        m_var_short = x.m_var_short;
        m_var_long = x.m_var_long;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ForwardStruct that will be copied.
     */
    eProsima_user_DllExport ForwardStruct& operator =(
            const ForwardStruct& x)
    {

                    m_var_short = x.m_var_short;

                    m_var_long = x.m_var_long;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ForwardStruct that will be copied.
     */
    eProsima_user_DllExport ForwardStruct& operator =(
            ForwardStruct&& x) noexcept
    {

        m_var_short = x.m_var_short;
        m_var_long = x.m_var_long;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ForwardStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ForwardStruct& x) const
    {
        return (m_var_short == x.m_var_short &&
           m_var_long == x.m_var_long);
    }

    /*!
     * @brief Comparison operator.
     * @param x ForwardStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ForwardStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_short
     * @param _var_short New value for member var_short
     */
    eProsima_user_DllExport void var_short(
            int16_t _var_short)
    {
        m_var_short = _var_short;
    }

    /*!
     * @brief This function returns the value of member var_short
     * @return Value of member var_short
     */
    eProsima_user_DllExport int16_t var_short() const
    {
        return m_var_short;
    }

    /*!
     * @brief This function returns a reference to member var_short
     * @return Reference to member var_short
     */
    eProsima_user_DllExport int16_t& var_short()
    {
        return m_var_short;
    }


    /*!
     * @brief This function sets a value in member var_long
     * @param _var_long New value for member var_long
     */
    eProsima_user_DllExport void var_long(
            int32_t _var_long)
    {
        m_var_long = _var_long;
    }

    /*!
     * @brief This function returns the value of member var_long
     * @return Value of member var_long
     */
    eProsima_user_DllExport int32_t var_long() const
    {
        return m_var_long;
    }

    /*!
     * @brief This function returns a reference to member var_long
     * @return Reference to member var_long
     */
    eProsima_user_DllExport int32_t& var_long()
    {
        return m_var_long;
    }



private:

    int16_t m_var_short{0};
    int32_t m_var_long{0};

};
namespace declarations_module {

class ModuledForwardStruct;

class ModuledForwardUnion;

typedef std::vector<ModuledForwardStruct> ModuledRecursiveUnboundedSeqForwardStruct;

typedef std::vector<ModuledForwardStruct> ModuledRecursiveBoundedSeqForwardStruct;

typedef std::vector<ModuledForwardUnion> ModuledRecursiveUnboundedSeqForwardUnion;

typedef std::vector<ModuledForwardUnion> ModuledRecursiveBoundedSeqForwardUnion;

/*!
 * @brief This class represents the structure ForwardStruct defined by the user in the IDL file.
 * @ingroup declarations
 */
class ForwardStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ForwardStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ForwardStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ForwardStruct that will be copied.
     */
    eProsima_user_DllExport ForwardStruct(
            const ForwardStruct& x)
    {
                    m_var_u_long_long = x.m_var_u_long_long;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ForwardStruct that will be copied.
     */
    eProsima_user_DllExport ForwardStruct(
            ForwardStruct&& x) noexcept
    {
        m_var_u_long_long = x.m_var_u_long_long;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ForwardStruct that will be copied.
     */
    eProsima_user_DllExport ForwardStruct& operator =(
            const ForwardStruct& x)
    {

                    m_var_u_long_long = x.m_var_u_long_long;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ForwardStruct that will be copied.
     */
    eProsima_user_DllExport ForwardStruct& operator =(
            ForwardStruct&& x) noexcept
    {

        m_var_u_long_long = x.m_var_u_long_long;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ForwardStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ForwardStruct& x) const
    {
        return (m_var_u_long_long == x.m_var_u_long_long);
    }

    /*!
     * @brief Comparison operator.
     * @param x ForwardStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ForwardStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_u_long_long
     * @param _var_u_long_long New value for member var_u_long_long
     */
    eProsima_user_DllExport void var_u_long_long(
            uint64_t _var_u_long_long)
    {
        m_var_u_long_long = _var_u_long_long;
    }

    /*!
     * @brief This function returns the value of member var_u_long_long
     * @return Value of member var_u_long_long
     */
    eProsima_user_DllExport uint64_t var_u_long_long() const
    {
        return m_var_u_long_long;
    }

    /*!
     * @brief This function returns a reference to member var_u_long_long
     * @return Reference to member var_u_long_long
     */
    eProsima_user_DllExport uint64_t& var_u_long_long()
    {
        return m_var_u_long_long;
    }



private:

    uint64_t m_var_u_long_long{0};

};

} // namespace declarations_module
/*!
 * @brief This class represents the structure ModuledForwardDeclarationsRecursiveStruct defined by the user in the IDL file.
 * @ingroup declarations
 */
class ModuledForwardDeclarationsRecursiveStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ModuledForwardDeclarationsRecursiveStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ModuledForwardDeclarationsRecursiveStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ModuledForwardDeclarationsRecursiveStruct that will be copied.
     */
    eProsima_user_DllExport ModuledForwardDeclarationsRecursiveStruct(
            const ModuledForwardDeclarationsRecursiveStruct& x)
    {
                    m_var_ModuledRecursiveUnboundedSeqForwardStruct = x.m_var_ModuledRecursiveUnboundedSeqForwardStruct;

                    m_var_ModuledRecursiveBoundedSeqForwardStruct = x.m_var_ModuledRecursiveBoundedSeqForwardStruct;

                    m_var_ModuledRecursiveUnboundedSeqForwardUnion = x.m_var_ModuledRecursiveUnboundedSeqForwardUnion;

                    m_var_ModuledRecursiveBoundedSeqForwardUnion = x.m_var_ModuledRecursiveBoundedSeqForwardUnion;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ModuledForwardDeclarationsRecursiveStruct that will be copied.
     */
    eProsima_user_DllExport ModuledForwardDeclarationsRecursiveStruct(
            ModuledForwardDeclarationsRecursiveStruct&& x) noexcept
    {
        m_var_ModuledRecursiveUnboundedSeqForwardStruct = std::move(x.m_var_ModuledRecursiveUnboundedSeqForwardStruct);
        m_var_ModuledRecursiveBoundedSeqForwardStruct = std::move(x.m_var_ModuledRecursiveBoundedSeqForwardStruct);
        m_var_ModuledRecursiveUnboundedSeqForwardUnion = std::move(x.m_var_ModuledRecursiveUnboundedSeqForwardUnion);
        m_var_ModuledRecursiveBoundedSeqForwardUnion = std::move(x.m_var_ModuledRecursiveBoundedSeqForwardUnion);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ModuledForwardDeclarationsRecursiveStruct that will be copied.
     */
    eProsima_user_DllExport ModuledForwardDeclarationsRecursiveStruct& operator =(
            const ModuledForwardDeclarationsRecursiveStruct& x)
    {

                    m_var_ModuledRecursiveUnboundedSeqForwardStruct = x.m_var_ModuledRecursiveUnboundedSeqForwardStruct;

                    m_var_ModuledRecursiveBoundedSeqForwardStruct = x.m_var_ModuledRecursiveBoundedSeqForwardStruct;

                    m_var_ModuledRecursiveUnboundedSeqForwardUnion = x.m_var_ModuledRecursiveUnboundedSeqForwardUnion;

                    m_var_ModuledRecursiveBoundedSeqForwardUnion = x.m_var_ModuledRecursiveBoundedSeqForwardUnion;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ModuledForwardDeclarationsRecursiveStruct that will be copied.
     */
    eProsima_user_DllExport ModuledForwardDeclarationsRecursiveStruct& operator =(
            ModuledForwardDeclarationsRecursiveStruct&& x) noexcept
    {

        m_var_ModuledRecursiveUnboundedSeqForwardStruct = std::move(x.m_var_ModuledRecursiveUnboundedSeqForwardStruct);
        m_var_ModuledRecursiveBoundedSeqForwardStruct = std::move(x.m_var_ModuledRecursiveBoundedSeqForwardStruct);
        m_var_ModuledRecursiveUnboundedSeqForwardUnion = std::move(x.m_var_ModuledRecursiveUnboundedSeqForwardUnion);
        m_var_ModuledRecursiveBoundedSeqForwardUnion = std::move(x.m_var_ModuledRecursiveBoundedSeqForwardUnion);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ModuledForwardDeclarationsRecursiveStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ModuledForwardDeclarationsRecursiveStruct& x) const
    {
        return (m_var_ModuledRecursiveUnboundedSeqForwardStruct == x.m_var_ModuledRecursiveUnboundedSeqForwardStruct &&
           m_var_ModuledRecursiveBoundedSeqForwardStruct == x.m_var_ModuledRecursiveBoundedSeqForwardStruct &&
           m_var_ModuledRecursiveUnboundedSeqForwardUnion == x.m_var_ModuledRecursiveUnboundedSeqForwardUnion &&
           m_var_ModuledRecursiveBoundedSeqForwardUnion == x.m_var_ModuledRecursiveBoundedSeqForwardUnion);
    }

    /*!
     * @brief Comparison operator.
     * @param x ModuledForwardDeclarationsRecursiveStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ModuledForwardDeclarationsRecursiveStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_ModuledRecursiveUnboundedSeqForwardStruct
     * @param _var_ModuledRecursiveUnboundedSeqForwardStruct New value to be copied in member var_ModuledRecursiveUnboundedSeqForwardStruct
     */
    eProsima_user_DllExport void var_ModuledRecursiveUnboundedSeqForwardStruct(
            const declarations_module::ModuledRecursiveUnboundedSeqForwardStruct& _var_ModuledRecursiveUnboundedSeqForwardStruct)
    {
        m_var_ModuledRecursiveUnboundedSeqForwardStruct = _var_ModuledRecursiveUnboundedSeqForwardStruct;
    }

    /*!
     * @brief This function moves the value in member var_ModuledRecursiveUnboundedSeqForwardStruct
     * @param _var_ModuledRecursiveUnboundedSeqForwardStruct New value to be moved in member var_ModuledRecursiveUnboundedSeqForwardStruct
     */
    eProsima_user_DllExport void var_ModuledRecursiveUnboundedSeqForwardStruct(
            declarations_module::ModuledRecursiveUnboundedSeqForwardStruct&& _var_ModuledRecursiveUnboundedSeqForwardStruct)
    {
        m_var_ModuledRecursiveUnboundedSeqForwardStruct = std::move(_var_ModuledRecursiveUnboundedSeqForwardStruct);
    }

    /*!
     * @brief This function returns a constant reference to member var_ModuledRecursiveUnboundedSeqForwardStruct
     * @return Constant reference to member var_ModuledRecursiveUnboundedSeqForwardStruct
     */
    eProsima_user_DllExport const declarations_module::ModuledRecursiveUnboundedSeqForwardStruct& var_ModuledRecursiveUnboundedSeqForwardStruct() const
    {
        return m_var_ModuledRecursiveUnboundedSeqForwardStruct;
    }

    /*!
     * @brief This function returns a reference to member var_ModuledRecursiveUnboundedSeqForwardStruct
     * @return Reference to member var_ModuledRecursiveUnboundedSeqForwardStruct
     */
    eProsima_user_DllExport declarations_module::ModuledRecursiveUnboundedSeqForwardStruct& var_ModuledRecursiveUnboundedSeqForwardStruct()
    {
        return m_var_ModuledRecursiveUnboundedSeqForwardStruct;
    }


    /*!
     * @brief This function copies the value in member var_ModuledRecursiveBoundedSeqForwardStruct
     * @param _var_ModuledRecursiveBoundedSeqForwardStruct New value to be copied in member var_ModuledRecursiveBoundedSeqForwardStruct
     */
    eProsima_user_DllExport void var_ModuledRecursiveBoundedSeqForwardStruct(
            const declarations_module::ModuledRecursiveBoundedSeqForwardStruct& _var_ModuledRecursiveBoundedSeqForwardStruct)
    {
        m_var_ModuledRecursiveBoundedSeqForwardStruct = _var_ModuledRecursiveBoundedSeqForwardStruct;
    }

    /*!
     * @brief This function moves the value in member var_ModuledRecursiveBoundedSeqForwardStruct
     * @param _var_ModuledRecursiveBoundedSeqForwardStruct New value to be moved in member var_ModuledRecursiveBoundedSeqForwardStruct
     */
    eProsima_user_DllExport void var_ModuledRecursiveBoundedSeqForwardStruct(
            declarations_module::ModuledRecursiveBoundedSeqForwardStruct&& _var_ModuledRecursiveBoundedSeqForwardStruct)
    {
        m_var_ModuledRecursiveBoundedSeqForwardStruct = std::move(_var_ModuledRecursiveBoundedSeqForwardStruct);
    }

    /*!
     * @brief This function returns a constant reference to member var_ModuledRecursiveBoundedSeqForwardStruct
     * @return Constant reference to member var_ModuledRecursiveBoundedSeqForwardStruct
     */
    eProsima_user_DllExport const declarations_module::ModuledRecursiveBoundedSeqForwardStruct& var_ModuledRecursiveBoundedSeqForwardStruct() const
    {
        return m_var_ModuledRecursiveBoundedSeqForwardStruct;
    }

    /*!
     * @brief This function returns a reference to member var_ModuledRecursiveBoundedSeqForwardStruct
     * @return Reference to member var_ModuledRecursiveBoundedSeqForwardStruct
     */
    eProsima_user_DllExport declarations_module::ModuledRecursiveBoundedSeqForwardStruct& var_ModuledRecursiveBoundedSeqForwardStruct()
    {
        return m_var_ModuledRecursiveBoundedSeqForwardStruct;
    }


    /*!
     * @brief This function copies the value in member var_ModuledRecursiveUnboundedSeqForwardUnion
     * @param _var_ModuledRecursiveUnboundedSeqForwardUnion New value to be copied in member var_ModuledRecursiveUnboundedSeqForwardUnion
     */
    eProsima_user_DllExport void var_ModuledRecursiveUnboundedSeqForwardUnion(
            const declarations_module::ModuledRecursiveUnboundedSeqForwardUnion& _var_ModuledRecursiveUnboundedSeqForwardUnion)
    {
        m_var_ModuledRecursiveUnboundedSeqForwardUnion = _var_ModuledRecursiveUnboundedSeqForwardUnion;
    }

    /*!
     * @brief This function moves the value in member var_ModuledRecursiveUnboundedSeqForwardUnion
     * @param _var_ModuledRecursiveUnboundedSeqForwardUnion New value to be moved in member var_ModuledRecursiveUnboundedSeqForwardUnion
     */
    eProsima_user_DllExport void var_ModuledRecursiveUnboundedSeqForwardUnion(
            declarations_module::ModuledRecursiveUnboundedSeqForwardUnion&& _var_ModuledRecursiveUnboundedSeqForwardUnion)
    {
        m_var_ModuledRecursiveUnboundedSeqForwardUnion = std::move(_var_ModuledRecursiveUnboundedSeqForwardUnion);
    }

    /*!
     * @brief This function returns a constant reference to member var_ModuledRecursiveUnboundedSeqForwardUnion
     * @return Constant reference to member var_ModuledRecursiveUnboundedSeqForwardUnion
     */
    eProsima_user_DllExport const declarations_module::ModuledRecursiveUnboundedSeqForwardUnion& var_ModuledRecursiveUnboundedSeqForwardUnion() const
    {
        return m_var_ModuledRecursiveUnboundedSeqForwardUnion;
    }

    /*!
     * @brief This function returns a reference to member var_ModuledRecursiveUnboundedSeqForwardUnion
     * @return Reference to member var_ModuledRecursiveUnboundedSeqForwardUnion
     */
    eProsima_user_DllExport declarations_module::ModuledRecursiveUnboundedSeqForwardUnion& var_ModuledRecursiveUnboundedSeqForwardUnion()
    {
        return m_var_ModuledRecursiveUnboundedSeqForwardUnion;
    }


    /*!
     * @brief This function copies the value in member var_ModuledRecursiveBoundedSeqForwardUnion
     * @param _var_ModuledRecursiveBoundedSeqForwardUnion New value to be copied in member var_ModuledRecursiveBoundedSeqForwardUnion
     */
    eProsima_user_DllExport void var_ModuledRecursiveBoundedSeqForwardUnion(
            const declarations_module::ModuledRecursiveBoundedSeqForwardUnion& _var_ModuledRecursiveBoundedSeqForwardUnion)
    {
        m_var_ModuledRecursiveBoundedSeqForwardUnion = _var_ModuledRecursiveBoundedSeqForwardUnion;
    }

    /*!
     * @brief This function moves the value in member var_ModuledRecursiveBoundedSeqForwardUnion
     * @param _var_ModuledRecursiveBoundedSeqForwardUnion New value to be moved in member var_ModuledRecursiveBoundedSeqForwardUnion
     */
    eProsima_user_DllExport void var_ModuledRecursiveBoundedSeqForwardUnion(
            declarations_module::ModuledRecursiveBoundedSeqForwardUnion&& _var_ModuledRecursiveBoundedSeqForwardUnion)
    {
        m_var_ModuledRecursiveBoundedSeqForwardUnion = std::move(_var_ModuledRecursiveBoundedSeqForwardUnion);
    }

    /*!
     * @brief This function returns a constant reference to member var_ModuledRecursiveBoundedSeqForwardUnion
     * @return Constant reference to member var_ModuledRecursiveBoundedSeqForwardUnion
     */
    eProsima_user_DllExport const declarations_module::ModuledRecursiveBoundedSeqForwardUnion& var_ModuledRecursiveBoundedSeqForwardUnion() const
    {
        return m_var_ModuledRecursiveBoundedSeqForwardUnion;
    }

    /*!
     * @brief This function returns a reference to member var_ModuledRecursiveBoundedSeqForwardUnion
     * @return Reference to member var_ModuledRecursiveBoundedSeqForwardUnion
     */
    eProsima_user_DllExport declarations_module::ModuledRecursiveBoundedSeqForwardUnion& var_ModuledRecursiveBoundedSeqForwardUnion()
    {
        return m_var_ModuledRecursiveBoundedSeqForwardUnion;
    }



private:

    declarations_module::ModuledRecursiveUnboundedSeqForwardStruct m_var_ModuledRecursiveUnboundedSeqForwardStruct;
    declarations_module::ModuledRecursiveBoundedSeqForwardStruct m_var_ModuledRecursiveBoundedSeqForwardStruct;
    declarations_module::ModuledRecursiveUnboundedSeqForwardUnion m_var_ModuledRecursiveUnboundedSeqForwardUnion;
    declarations_module::ModuledRecursiveBoundedSeqForwardUnion m_var_ModuledRecursiveBoundedSeqForwardUnion;

};
namespace declarations_module {

/*!
 * @brief This class represents the structure ModuledForwardStruct defined by the user in the IDL file.
 * @ingroup declarations
 */
class ModuledForwardStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ModuledForwardStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ModuledForwardStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ModuledForwardStruct that will be copied.
     */
    eProsima_user_DllExport ModuledForwardStruct(
            const ModuledForwardStruct& x)
    {
                    m_var_short = x.m_var_short;

                    m_var_long = x.m_var_long;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ModuledForwardStruct that will be copied.
     */
    eProsima_user_DllExport ModuledForwardStruct(
            ModuledForwardStruct&& x) noexcept
    {
        m_var_short = x.m_var_short;
        m_var_long = x.m_var_long;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ModuledForwardStruct that will be copied.
     */
    eProsima_user_DllExport ModuledForwardStruct& operator =(
            const ModuledForwardStruct& x)
    {

                    m_var_short = x.m_var_short;

                    m_var_long = x.m_var_long;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ModuledForwardStruct that will be copied.
     */
    eProsima_user_DllExport ModuledForwardStruct& operator =(
            ModuledForwardStruct&& x) noexcept
    {

        m_var_short = x.m_var_short;
        m_var_long = x.m_var_long;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ModuledForwardStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ModuledForwardStruct& x) const
    {
        return (m_var_short == x.m_var_short &&
           m_var_long == x.m_var_long);
    }

    /*!
     * @brief Comparison operator.
     * @param x ModuledForwardStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ModuledForwardStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_short
     * @param _var_short New value for member var_short
     */
    eProsima_user_DllExport void var_short(
            int16_t _var_short)
    {
        m_var_short = _var_short;
    }

    /*!
     * @brief This function returns the value of member var_short
     * @return Value of member var_short
     */
    eProsima_user_DllExport int16_t var_short() const
    {
        return m_var_short;
    }

    /*!
     * @brief This function returns a reference to member var_short
     * @return Reference to member var_short
     */
    eProsima_user_DllExport int16_t& var_short()
    {
        return m_var_short;
    }


    /*!
     * @brief This function sets a value in member var_long
     * @param _var_long New value for member var_long
     */
    eProsima_user_DllExport void var_long(
            int32_t _var_long)
    {
        m_var_long = _var_long;
    }

    /*!
     * @brief This function returns the value of member var_long
     * @return Value of member var_long
     */
    eProsima_user_DllExport int32_t var_long() const
    {
        return m_var_long;
    }

    /*!
     * @brief This function returns a reference to member var_long
     * @return Reference to member var_long
     */
    eProsima_user_DllExport int32_t& var_long()
    {
        return m_var_long;
    }



private:

    int16_t m_var_short{0};
    int32_t m_var_long{0};

};
const int32_t long_const = 0;
/*!
 * @brief This class represents the union ModuledForwardUnion defined by the user in the IDL file.
 * @ingroup declarations
 */
class ModuledForwardUnion
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ModuledForwardUnion()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ModuledForwardUnion()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ModuledForwardUnion that will be copied.
     */
    eProsima_user_DllExport ModuledForwardUnion(
            const ModuledForwardUnion& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            case_zero_() = x.m_case_zero;
                            break;

                        case 0x00000002:
                            case_one_() = x.m_case_one;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ModuledForwardUnion that will be copied.
     */
    eProsima_user_DllExport ModuledForwardUnion(
            ModuledForwardUnion&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            case_zero_() = std::move(x.m_case_zero);
                            break;

                        case 0x00000002:
                            case_one_() = std::move(x.m_case_one);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ModuledForwardUnion that will be copied.
     */
    eProsima_user_DllExport ModuledForwardUnion& operator =(
            const ModuledForwardUnion& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            case_zero_() = x.m_case_zero;
                            break;

                        case 0x00000002:
                            case_one_() = x.m_case_one;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ModuledForwardUnion that will be copied.
     */
    eProsima_user_DllExport ModuledForwardUnion& operator =(
            ModuledForwardUnion&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            case_zero_() = std::move(x.m_case_zero);
                            break;

                        case 0x00000002:
                            case_one_() = std::move(x.m_case_one);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ModuledForwardUnion object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ModuledForwardUnion& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_case_zero == m_case_zero);
                                                        break;

                                                    case 0x00000002:
                                                        ret_value = (x.m_case_one == m_case_one);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x ModuledForwardUnion object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ModuledForwardUnion& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            int32_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case long_const:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case 1:
                            if (0x00000002 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport int32_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function sets a value in member case_zero
     * @param _case_zero New value for member case_zero
     */
    eProsima_user_DllExport void case_zero(
            int32_t _case_zero)
    {
        case_zero_() = _case_zero;
        m__d = long_const;
    }

    /*!
     * @brief This function returns the value of member case_zero
     * @return Value of member case_zero
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t case_zero() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_case_zero;
    }

    /*!
     * @brief This function returns a reference to member case_zero
     * @return Reference to member case_zero
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t& case_zero()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_case_zero;
    }


    /*!
     * @brief This function sets a value in member case_one
     * @param _case_one New value for member case_one
     */
    eProsima_user_DllExport void case_one(
            int32_t _case_one)
    {
        case_one_() = _case_one;
        m__d = 1;
    }

    /*!
     * @brief This function returns the value of member case_one
     * @return Value of member case_one
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t case_one() const
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_case_one;
    }

    /*!
     * @brief This function returns a reference to member case_one
     * @return Reference to member case_one
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t& case_one()
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_case_one;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            int32_t& case_zero_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = nullptr;
                    m_case_zero = {0};

                }

                return m_case_zero;
            }

            int32_t& case_one_()
            {
                if (0x00000002 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000002;
                    member_destructor_ = nullptr;
                    m_case_one = {0};

                }

                return m_case_one;
            }


    int32_t m__d {2147483647};

    union
    {
        int32_t m_case_zero;
        int32_t m_case_one;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};

} // namespace declarations_module
/*!
 * @brief This class represents the structure ModuledCommonNameStructure defined by the user in the IDL file.
 * @ingroup declarations
 */
class ModuledCommonNameStructure
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ModuledCommonNameStructure()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ModuledCommonNameStructure()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ModuledCommonNameStructure that will be copied.
     */
    eProsima_user_DllExport ModuledCommonNameStructure(
            const ModuledCommonNameStructure& x)
    {
                    m_global_struct = x.m_global_struct;

                    m_namespaced_struct = x.m_namespaced_struct;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ModuledCommonNameStructure that will be copied.
     */
    eProsima_user_DllExport ModuledCommonNameStructure(
            ModuledCommonNameStructure&& x) noexcept
    {
        m_global_struct = std::move(x.m_global_struct);
        m_namespaced_struct = std::move(x.m_namespaced_struct);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ModuledCommonNameStructure that will be copied.
     */
    eProsima_user_DllExport ModuledCommonNameStructure& operator =(
            const ModuledCommonNameStructure& x)
    {

                    m_global_struct = x.m_global_struct;

                    m_namespaced_struct = x.m_namespaced_struct;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ModuledCommonNameStructure that will be copied.
     */
    eProsima_user_DllExport ModuledCommonNameStructure& operator =(
            ModuledCommonNameStructure&& x) noexcept
    {

        m_global_struct = std::move(x.m_global_struct);
        m_namespaced_struct = std::move(x.m_namespaced_struct);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ModuledCommonNameStructure object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ModuledCommonNameStructure& x) const
    {
        return (m_global_struct == x.m_global_struct &&
           m_namespaced_struct == x.m_namespaced_struct);
    }

    /*!
     * @brief Comparison operator.
     * @param x ModuledCommonNameStructure object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ModuledCommonNameStructure& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member global_struct
     * @param _global_struct New value to be copied in member global_struct
     */
    eProsima_user_DllExport void global_struct(
            const ForwardStruct& _global_struct)
    {
        m_global_struct = _global_struct;
    }

    /*!
     * @brief This function moves the value in member global_struct
     * @param _global_struct New value to be moved in member global_struct
     */
    eProsima_user_DllExport void global_struct(
            ForwardStruct&& _global_struct)
    {
        m_global_struct = std::move(_global_struct);
    }

    /*!
     * @brief This function returns a constant reference to member global_struct
     * @return Constant reference to member global_struct
     */
    eProsima_user_DllExport const ForwardStruct& global_struct() const
    {
        return m_global_struct;
    }

    /*!
     * @brief This function returns a reference to member global_struct
     * @return Reference to member global_struct
     */
    eProsima_user_DllExport ForwardStruct& global_struct()
    {
        return m_global_struct;
    }


    /*!
     * @brief This function copies the value in member namespaced_struct
     * @param _namespaced_struct New value to be copied in member namespaced_struct
     */
    eProsima_user_DllExport void namespaced_struct(
            const declarations_module::ForwardStruct& _namespaced_struct)
    {
        m_namespaced_struct = _namespaced_struct;
    }

    /*!
     * @brief This function moves the value in member namespaced_struct
     * @param _namespaced_struct New value to be moved in member namespaced_struct
     */
    eProsima_user_DllExport void namespaced_struct(
            declarations_module::ForwardStruct&& _namespaced_struct)
    {
        m_namespaced_struct = std::move(_namespaced_struct);
    }

    /*!
     * @brief This function returns a constant reference to member namespaced_struct
     * @return Constant reference to member namespaced_struct
     */
    eProsima_user_DllExport const declarations_module::ForwardStruct& namespaced_struct() const
    {
        return m_namespaced_struct;
    }

    /*!
     * @brief This function returns a reference to member namespaced_struct
     * @return Reference to member namespaced_struct
     */
    eProsima_user_DllExport declarations_module::ForwardStruct& namespaced_struct()
    {
        return m_namespaced_struct;
    }



private:

    ForwardStruct m_global_struct;
    declarations_module::ForwardStruct m_namespaced_struct;

};

#endif // _FAST_DDS_GENERATED_DECLARATIONS_HPP_


