-- $Id$ 

-- test for some different arrays

-- Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.


library types;
use types.standard.all;
entity nullentity is
end entity nullentity;

architecture implementation of nullentity is
	type R1 is record
             I: integer;
        end record;

	type unconarraytype is array(integer range <>) of r1;
	type integer_array is array(1 to 10) of integer;

	function bar(x : integer; y : integer) return integer;
	-- the following is a homograph of the above (same base type!)
	function bar(x : integer range 4 to 18; y : integer) return integer;
	function bar(x : unconarraytype(5 to 16)) return R1;
	function bar(x : unconarraytype(5 to 16)) return integer_array;
	function f return r1;
	function f(x : R1) return R1;
	function bar(f : integer range 4 to 18) return R1;
begin	
	p : process 
		variable v1, v2, v3 : integer;
	begin
		v1 := bar(4);
		v2 := bar(4).i;
		v3 := bar(x => 4);
		v1 := bar(y => 4, x => 5);
		v2 := bar(x => bar(4));
		v3 := bar(x, y => bar(bar(4))(5)); -- valid!
		v1 := f.i; -- call f and do selection to i. 
		v1 := f(x.i => v2);
		v2 := f(x.i => v2).i;
		v3 := bar(f(v1) => v3).i; -- f: formal, v1: subscript
	end process;
end implementation;
