// Code generated by smithy-go-codegen DO NOT EDIT.

package billingconductor

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/billingconductor/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Update an existing custom line item in the current or previous billing period.
func (c *Client) UpdateCustomLineItem(ctx context.Context, params *UpdateCustomLineItemInput, optFns ...func(*Options)) (*UpdateCustomLineItemOutput, error) {
	if params == nil {
		params = &UpdateCustomLineItemInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateCustomLineItem", params, optFns, c.addOperationUpdateCustomLineItemMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateCustomLineItemOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateCustomLineItemInput struct {

	// The ARN of the custom line item to be updated.
	//
	// This member is required.
	Arn *string

	// The billing period range in which the custom line item request will be applied.
	BillingPeriodRange *types.CustomLineItemBillingPeriodRange

	// A ListCustomLineItemChargeDetails containing the new charge details for the
	// custom line item.
	ChargeDetails *types.UpdateCustomLineItemChargeDetails

	// The new line item description of the custom line item.
	Description *string

	// The new name for the custom line item.
	Name *string

	noSmithyDocumentSerde
}

type UpdateCustomLineItemOutput struct {

	// The ARN of the successfully updated custom line item.
	Arn *string

	// The number of resources that are associated to the custom line item.
	AssociationSize int64

	// The ARN of the billing group that the custom line item is applied to.
	BillingGroupArn *string

	// A ListCustomLineItemChargeDetails containing the charge details of the
	// successfully updated custom line item.
	ChargeDetails *types.ListCustomLineItemChargeDetails

	// The description of the successfully updated custom line item.
	Description *string

	// The most recent time when the custom line item was modified.
	LastModifiedTime int64

	// The name of the successfully updated custom line item.
	Name *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateCustomLineItemMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateCustomLineItem{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateCustomLineItem{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateCustomLineItem"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateCustomLineItemValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateCustomLineItem(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateCustomLineItem(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateCustomLineItem",
	}
}
