// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

// DMS was denied access to the endpoint. Check that the role is correctly
// configured.
type AccessDeniedFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AccessDeniedFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AccessDeniedFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AccessDeniedFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AccessDeniedFault"
	}
	return *e.ErrorCodeOverride
}
func (e *AccessDeniedFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified collector doesn't exist.
type CollectorNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CollectorNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CollectorNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CollectorNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "CollectorNotFoundFault"
	}
	return *e.ErrorCodeOverride
}
func (e *CollectorNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// There are not enough resources allocated to the database migration.
type InsufficientResourceCapacityFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InsufficientResourceCapacityFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InsufficientResourceCapacityFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InsufficientResourceCapacityFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InsufficientResourceCapacityFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InsufficientResourceCapacityFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The certificate was not valid.
type InvalidCertificateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidCertificateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidCertificateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidCertificateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidCertificateFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidCertificateFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The action or operation requested isn't valid.
type InvalidOperationFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidOperationFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidOperationFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidOperationFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidOperationFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidOperationFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The resource is in a state that prevents it from being used for database
// migration.
type InvalidResourceStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidResourceStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidResourceStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidResourceStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidResourceStateFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidResourceStateFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The subnet provided isn't valid.
type InvalidSubnet struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidSubnet) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidSubnet) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidSubnet) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidSubnet"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidSubnet) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The ciphertext references a key that doesn't exist or that the DMS account
// doesn't have access to.
type KMSAccessDeniedFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *KMSAccessDeniedFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *KMSAccessDeniedFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *KMSAccessDeniedFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "KMSAccessDeniedFault"
	}
	return *e.ErrorCodeOverride
}
func (e *KMSAccessDeniedFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified KMS key isn't enabled.
type KMSDisabledFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *KMSDisabledFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *KMSDisabledFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *KMSDisabledFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "KMSDisabledFault"
	}
	return *e.ErrorCodeOverride
}
func (e *KMSDisabledFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// An Key Management Service (KMS) error is preventing access to KMS.
type KMSFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *KMSFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *KMSFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *KMSFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "KMSFault"
	}
	return *e.ErrorCodeOverride
}
func (e *KMSFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The state of the specified KMS resource isn't valid for this request.
type KMSInvalidStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *KMSInvalidStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *KMSInvalidStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *KMSInvalidStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "KMSInvalidStateFault"
	}
	return *e.ErrorCodeOverride
}
func (e *KMSInvalidStateFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// DMS cannot access the KMS key.
type KMSKeyNotAccessibleFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *KMSKeyNotAccessibleFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *KMSKeyNotAccessibleFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *KMSKeyNotAccessibleFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "KMSKeyNotAccessibleFault"
	}
	return *e.ErrorCodeOverride
}
func (e *KMSKeyNotAccessibleFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified KMS entity or resource can't be found.
type KMSNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *KMSNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *KMSNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *KMSNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "KMSNotFoundFault"
	}
	return *e.ErrorCodeOverride
}
func (e *KMSNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This request triggered KMS request throttling.
type KMSThrottlingFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *KMSThrottlingFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *KMSThrottlingFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *KMSThrottlingFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "KMSThrottlingFault"
	}
	return *e.ErrorCodeOverride
}
func (e *KMSThrottlingFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The replication subnet group does not cover enough Availability Zones (AZs).
// Edit the replication subnet group and add more AZs.
type ReplicationSubnetGroupDoesNotCoverEnoughAZs struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ReplicationSubnetGroupDoesNotCoverEnoughAZs) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ReplicationSubnetGroupDoesNotCoverEnoughAZs) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ReplicationSubnetGroupDoesNotCoverEnoughAZs) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ReplicationSubnetGroupDoesNotCoverEnoughAZs"
	}
	return *e.ErrorCodeOverride
}
func (e *ReplicationSubnetGroupDoesNotCoverEnoughAZs) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The resource you are attempting to create already exists.
type ResourceAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	ResourceArn *string

	noSmithyDocumentSerde
}

func (e *ResourceAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourceAlreadyExistsFault"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceAlreadyExistsFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The resource could not be found.
type ResourceNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResourceNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourceNotFoundFault"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The quota for this resource quota has been exceeded.
type ResourceQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResourceQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourceQuotaExceededFault"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceQuotaExceededFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Insufficient privileges are preventing access to an Amazon S3 object.
type S3AccessDeniedFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *S3AccessDeniedFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *S3AccessDeniedFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *S3AccessDeniedFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "S3AccessDeniedFault"
	}
	return *e.ErrorCodeOverride
}
func (e *S3AccessDeniedFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A specified Amazon S3 bucket, bucket folder, or other object can't be found.
type S3ResourceNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *S3ResourceNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *S3ResourceNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *S3ResourceNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "S3ResourceNotFoundFault"
	}
	return *e.ErrorCodeOverride
}
func (e *S3ResourceNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The SNS topic is invalid.
type SNSInvalidTopicFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SNSInvalidTopicFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SNSInvalidTopicFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SNSInvalidTopicFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SNSInvalidTopicFault"
	}
	return *e.ErrorCodeOverride
}
func (e *SNSInvalidTopicFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You are not authorized for the SNS subscription.
type SNSNoAuthorizationFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SNSNoAuthorizationFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SNSNoAuthorizationFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SNSNoAuthorizationFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SNSNoAuthorizationFault"
	}
	return *e.ErrorCodeOverride
}
func (e *SNSNoAuthorizationFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The storage quota has been exceeded.
type StorageQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *StorageQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *StorageQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *StorageQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "StorageQuotaExceededFault"
	}
	return *e.ErrorCodeOverride
}
func (e *StorageQuotaExceededFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified subnet is already in use.
type SubnetAlreadyInUse struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SubnetAlreadyInUse) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SubnetAlreadyInUse) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SubnetAlreadyInUse) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SubnetAlreadyInUse"
	}
	return *e.ErrorCodeOverride
}
func (e *SubnetAlreadyInUse) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// An upgrade dependency is preventing the database migration.
type UpgradeDependencyFailureFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *UpgradeDependencyFailureFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UpgradeDependencyFailureFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UpgradeDependencyFailureFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "UpgradeDependencyFailureFault"
	}
	return *e.ErrorCodeOverride
}
func (e *UpgradeDependencyFailureFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }
