// Code generated by smithy-go-codegen DO NOT EDIT.

package quicksight

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/quicksight/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Starts an asynchronous job that generates a dashboard snapshot. You can request
// one of the following format configurations per API call.
//   - 1 paginated PDF
//   - 1 Excel workbook
//   - 5 CSVs
//
// Poll job descriptions with a DescribeDashboardSnapshotJob API call. Once the
// job succeeds, use the DescribeDashboardSnapshotJobResult API to obtain the
// download URIs that the job generates.
func (c *Client) StartDashboardSnapshotJob(ctx context.Context, params *StartDashboardSnapshotJobInput, optFns ...func(*Options)) (*StartDashboardSnapshotJobOutput, error) {
	if params == nil {
		params = &StartDashboardSnapshotJobInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartDashboardSnapshotJob", params, optFns, c.addOperationStartDashboardSnapshotJobMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartDashboardSnapshotJobOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartDashboardSnapshotJobInput struct {

	// The ID of the Amazon Web Services account that the dashboard snapshot job is
	// executed in.
	//
	// This member is required.
	AwsAccountId *string

	// The ID of the dashboard that you want to start a snapshot job for.
	//
	// This member is required.
	DashboardId *string

	// A structure that describes the configuration of the dashboard snapshot.
	//
	// This member is required.
	SnapshotConfiguration *types.SnapshotConfiguration

	// An ID for the dashboard snapshot job. This ID is unique to the dashboard while
	// the job is running. This ID can be used to poll the status of a job with a
	// DescribeDashboardSnapshotJob while the job runs. You can reuse this ID for
	// another job 24 hours after the current job is completed.
	//
	// This member is required.
	SnapshotJobId *string

	// A structure that contains information about the anonymous users that the
	// generated snapshot is for. This API will not return information about registered
	// Amazon QuickSight.
	//
	// This member is required.
	UserConfiguration *types.SnapshotUserConfiguration

	noSmithyDocumentSerde
}

type StartDashboardSnapshotJobOutput struct {

	// The Amazon Resource Name (ARN) for the dashboard snapshot job.
	Arn *string

	// The Amazon Web Services request ID for this operation.
	RequestId *string

	// The ID of the job. The job ID is set when you start a new job with a
	// StartDashboardSnapshotJob API call.
	SnapshotJobId *string

	// The HTTP status of the request
	Status int32

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartDashboardSnapshotJobMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpStartDashboardSnapshotJob{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpStartDashboardSnapshotJob{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartDashboardSnapshotJob"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpStartDashboardSnapshotJobValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartDashboardSnapshotJob(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStartDashboardSnapshotJob(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartDashboardSnapshotJob",
	}
}
