//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armbilling_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/billing/armbilling"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/billing/resource-manager/Microsoft.Billing/stable/2020-05-01/examples/AddressInvalid.json
func ExampleAddressClient_Validate_addressInvalid() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbilling.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAddressClient().Validate(ctx, armbilling.AddressDetails{
		AddressLine1: to.Ptr("1 Test"),
		City:         to.Ptr("bellevue"),
		Country:      to.Ptr("us"),
		PostalCode:   to.Ptr("12345"),
		Region:       to.Ptr("wa"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ValidateAddressResponse = armbilling.ValidateAddressResponse{
	// 	Status: to.Ptr(armbilling.AddressValidationStatusInvalid),
	// 	SuggestedAddresses: []*armbilling.AddressDetails{
	// 		{
	// 			AddressLine1: to.Ptr("1 Test Address"),
	// 			City: to.Ptr("Bellevue"),
	// 			Country: to.Ptr("US"),
	// 			PostalCode: to.Ptr("98052"),
	// 			Region: to.Ptr("WA"),
	// 		},
	// 		{
	// 			AddressLine1: to.Ptr("1 Test Address"),
	// 			City: to.Ptr("Bellevue"),
	// 			Country: to.Ptr("US"),
	// 			PostalCode: to.Ptr("12345-0000"),
	// 			Region: to.Ptr("WA"),
	// 	}},
	// 	ValidationMessage: to.Ptr("Invalid address"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/billing/resource-manager/Microsoft.Billing/stable/2020-05-01/examples/AddressValid.json
func ExampleAddressClient_Validate_addressValid() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbilling.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAddressClient().Validate(ctx, armbilling.AddressDetails{
		AddressLine1: to.Ptr("1 Test Address"),
		City:         to.Ptr("bellevue"),
		Country:      to.Ptr("us"),
		PostalCode:   to.Ptr("12345"),
		Region:       to.Ptr("wa"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ValidateAddressResponse = armbilling.ValidateAddressResponse{
	// 	Status: to.Ptr(armbilling.AddressValidationStatusValid),
	// 	SuggestedAddresses: []*armbilling.AddressDetails{
	// 		{
	// 			AddressLine1: to.Ptr("1 Test Address"),
	// 			City: to.Ptr("Bellevue"),
	// 			Country: to.Ptr("US"),
	// 			PostalCode: to.Ptr("12345-0000"),
	// 			Region: to.Ptr("WA"),
	// 	}},
	// }
}
