//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armcontainerservice_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/containerservice/armcontainerservice/v4"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/Operation_List.json
func ExampleOperationsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewOperationsClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.OperationListResult = armcontainerservice.OperationListResult{
		// 	Value: []*armcontainerservice.OperationValue{
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/locations/operations/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Gets the status of an asynchronous operation"),
		// 				Operation: to.Ptr("Get Operation"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Operation"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/locations/orchestrators/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Lists the supported orchestrators"),
		// 				Operation: to.Ptr("List Orchestrators"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Orchestrator"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/locations/osOptions/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Gets OS options"),
		// 				Operation: to.Ptr("Get OS Options"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("OSOptions"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/operations/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Lists operations available on Microsoft.ContainerService resource provider"),
		// 				Operation: to.Ptr("List Available Container Service Operations"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Available Container Service Operations"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/register/action"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Registers Subscription with Microsoft.ContainerService resource provider"),
		// 				Operation: to.Ptr("Register Subscription for Container Service"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Container Service Register Subscription"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/unregister/action"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Unregisters Subscription with Microsoft.ContainerService resource provider"),
		// 				Operation: to.Ptr("Unregister Subscription for Container Service"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Container Service Unregister Subscription"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/locations/operationresults/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Gets the status of an asynchronous operation result"),
		// 				Operation: to.Ptr("Get Operation Result"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("OperationResult"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/containerServices/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Get a container service"),
		// 				Operation: to.Ptr("Get Container Service"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Container Services"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/containerServices/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Creates a new container service or updates an existing one"),
		// 				Operation: to.Ptr("Create or Update Container Service"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Container Services"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/containerServices/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes a container service"),
		// 				Operation: to.Ptr("Delete Container Service"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Container Services"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Get a managed cluster"),
		// 				Operation: to.Ptr("Get Managed Cluster"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Managed Clusters"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Creates a new managed cluster or updates an existing one"),
		// 				Operation: to.Ptr("Create or Update Managed Cluster"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Managed Clusters"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes a managed cluster"),
		// 				Operation: to.Ptr("Delete Managed Cluster"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Managed Clusters"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/start/action"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Starts a managed cluster"),
		// 				Operation: to.Ptr("Start Managed Cluster"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Managed Clusters"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/stop/action"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Stops a managed cluster"),
		// 				Operation: to.Ptr("Stop Managed Cluster"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Managed Clusters"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/maintenanceConfigurations/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Gets a maintenance configuration"),
		// 				Operation: to.Ptr("Get a maintenance configuration"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Maintenance Configurations"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/maintenanceConfigurations/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Creates a new MaintenanceConfiguration or updates an existing one"),
		// 				Operation: to.Ptr("Create or Update maintenance configuratio"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Maintenance Configurations"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/maintenanceConfigurations/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes a maintenance configuration"),
		// 				Operation: to.Ptr("Delete Maintenance Configuration"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Maintenance Configurations"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/agentPools/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Gets an agent pool"),
		// 				Operation: to.Ptr("Get Agent Pool"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Agent Pools"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/agentPools/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Creates a new agent pool or updates an existing one"),
		// 				Operation: to.Ptr("Create or Update Agent Pool"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Agent Pools"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/agentPools/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes an agent pool"),
		// 				Operation: to.Ptr("Delete Agent Pool"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Agent Pools"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/agentPools/upgradeProfiles/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Gets the upgrade profile of the Agent Pool"),
		// 				Operation: to.Ptr("Get Agent Pool UpgradeProfile"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Agent Pools"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/agentPools/upgradeNodeImageVersion/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Upgrade the node image version of agent pool"),
		// 				Operation: to.Ptr("Upgrade agent pool node image version"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Agent Pools"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/availableAgentPoolVersions/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Gets the available agent pool versions of the cluster"),
		// 				Operation: to.Ptr("Get Available Agent Pool Versions"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Managed Clusters"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/accessProfiles/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Get a managed cluster access profile by role name"),
		// 				Operation: to.Ptr("Get Managed Cluster AccessProfile"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Managed Clusters"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/accessProfiles/listCredential/action"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Get a managed cluster access profile by role name using list credential"),
		// 				Operation: to.Ptr("Get Managed Cluster AccessProfile by List Credential"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Managed Clusters"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/upgradeProfiles/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Gets the upgrade profile of the cluster"),
		// 				Operation: to.Ptr("Get UpgradeProfile"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("UpgradeProfile"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/listClusterAdminCredential/action"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("List the clusterAdmin credential of a managed cluster"),
		// 				Operation: to.Ptr("List clusterAdmin credential"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Managed Clusters"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/listClusterUserCredential/action"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("List the clusterUser credential of a managed cluster"),
		// 				Operation: to.Ptr("List clusterUser credential"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Managed Clusters"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/listClusterMonitoringUserCredential/action"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("List the clusterMonitoringUser credential of a managed cluster"),
		// 				Operation: to.Ptr("List clusterMonitoringUser credential"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Managed Clusters"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/resetServicePrincipalProfile/action"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reset the service principal profile of a managed cluster"),
		// 				Operation: to.Ptr("Reset service principal profile"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Managed Clusters"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/resolvePrivateLinkServiceId/action"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Resolve the private link service id of a managed cluster"),
		// 				Operation: to.Ptr("Resolve private link service id"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Managed Clusters"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/resetAADProfile/action"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reset the AAD profile of a managed cluster"),
		// 				Operation: to.Ptr("Reset AAD profile"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Managed Clusters"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/rotateClusterCertificates/action"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Rotate certificates of a managed cluster"),
		// 				Operation: to.Ptr("Rotate certificates of the cluster"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Managed Clusters"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/runCommand/action"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Run user issued command against managed kubernetes server."),
		// 				Operation: to.Ptr("RunCommand"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Managed Clusters"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/commandResults/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Retrieve result from previous issued command."),
		// 				Operation: to.Ptr("CommandResult"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Managed Clusters"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/providers/Microsoft.Insights/diagnosticSettings/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Get the diagnostic setting for a managed cluster resource"),
		// 				Operation: to.Ptr("Read Diagnostic Setting"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Managed Clusters"),
		// 			},
		// 			Origin: to.Ptr("system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/providers/Microsoft.Insights/diagnosticSettings/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Creates or updates the diagnostic setting for a managed cluster resource"),
		// 				Operation: to.Ptr("Write Diagnostic Setting"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Managed Clusters"),
		// 			},
		// 			Origin: to.Ptr("system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/detectors/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Get Managed Cluster Detector"),
		// 				Operation: to.Ptr("Get Managed Cluster Detector"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Managed Cluster Detector"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/diagnosticsState/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Gets the diagnostics state of the cluster"),
		// 				Operation: to.Ptr("Get Diagnostics State"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Diagnostics State"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/privateEndpointConnectionsApproval/action"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Determines if user is allowed to approve a private endpoint connection"),
		// 				Operation: to.Ptr("Approve Private Endpoint Connections"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Approve Private Endpoint Connections"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/privateEndpointConnections/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Get private endpoint connection"),
		// 				Operation: to.Ptr("Get private endpoint connection"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Private Endpoint Connections"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/privateEndpointConnections/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Approve or Reject a private endpoint connection"),
		// 				Operation: to.Ptr("Update private endpoint connection"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Private Endpoint Connections"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/privateEndpointConnections/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Delete private endpoint connection"),
		// 				Operation: to.Ptr("Delete private endpoint connection"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Private Endpoint Connections"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/extensionaddons/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Gets an extension addon"),
		// 				Operation: to.Ptr("Get an extension addon"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("ExtensionAddons"),
		// 			},
		// 			Origin: to.Ptr("system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/extensionaddons/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Creates a new extension addon or updates an existing one"),
		// 				Operation: to.Ptr("Create or Update extension addon"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("ExtensionAddons"),
		// 			},
		// 			Origin: to.Ptr("system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/extensionaddons/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes an extension addon"),
		// 				Operation: to.Ptr("Delete an extension addon"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("ExtensionAddons"),
		// 			},
		// 			Origin: to.Ptr("system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/snapshots/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Get a snapshot"),
		// 				Operation: to.Ptr("Get Snapshot"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Snapshots"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/snapshots/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Creates a new snapshot"),
		// 				Operation: to.Ptr("Create Snapshot"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Snapshots"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/snapshots/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes a snapshot"),
		// 				Operation: to.Ptr("Delete Snapshot"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Snapshots"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/eventGridFilters/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Get eventgrid filter"),
		// 				Operation: to.Ptr("Get eventgrid filter"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("EventGridFilters"),
		// 			},
		// 			Origin: to.Ptr("system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/eventGridFilters/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Create or Update eventgrid filter"),
		// 				Operation: to.Ptr("Create or Update eventgrid filter"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("EventGridFilters"),
		// 			},
		// 			Origin: to.Ptr("system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/eventGridFilters/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Delete an eventgrid filter"),
		// 				Operation: to.Ptr("Delete an eventgrid filter"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("EventGridFilters"),
		// 			},
		// 			Origin: to.Ptr("system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/admissionregistration.k8s.io/initializerconfigurations/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads initializerconfigurations"),
		// 				Operation: to.Ptr("Gets/List initializerconfigurations resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Initializerconfigurations"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/admissionregistration.k8s.io/initializerconfigurations/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes initializerconfigurations"),
		// 				Operation: to.Ptr("Creates/Updates initializerconfigurations resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Initializerconfigurations"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/admissionregistration.k8s.io/initializerconfigurations/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes/DeletesCollection initializerconfigurations resource"),
		// 				Operation: to.Ptr("Initializerconfigurations"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Initializerconfigurations"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/admissionregistration.k8s.io/mutatingwebhookconfigurations/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads mutatingwebhookconfigurations"),
		// 				Operation: to.Ptr("Gets/List mutatingwebhookconfigurations resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Mutatingwebhookconfigurations"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/admissionregistration.k8s.io/mutatingwebhookconfigurations/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes mutatingwebhookconfigurations"),
		// 				Operation: to.Ptr("Creates/Updates mutatingwebhookconfigurations resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Mutatingwebhookconfigurations"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/admissionregistration.k8s.io/mutatingwebhookconfigurations/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes mutatingwebhookconfigurations"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection mutatingwebhookconfigurations resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Mutatingwebhookconfigurations"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/admissionregistration.k8s.io/validatingwebhookconfigurations/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads validatingwebhookconfigurations"),
		// 				Operation: to.Ptr("Gets/List validatingwebhookconfigurations resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Validatingwebhookconfigurations"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/admissionregistration.k8s.io/validatingwebhookconfigurations/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes validatingwebhookconfigurations"),
		// 				Operation: to.Ptr("Creates/Updates validatingwebhookconfigurations resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Validatingwebhookconfigurations"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/admissionregistration.k8s.io/validatingwebhookconfigurations/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes validatingwebhookconfigurations"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection validatingwebhookconfigurations resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Validatingwebhookconfigurations"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apiextensions.k8s.io/customresourcedefinitions/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads customresourcedefinitions"),
		// 				Operation: to.Ptr("Gets/List customresourcedefinitions resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Customresourcedefinitions"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apiextensions.k8s.io/customresourcedefinitions/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes customresourcedefinitions"),
		// 				Operation: to.Ptr("Creates/Updates customresourcedefinitions resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Customresourcedefinitions"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apiextensions.k8s.io/customresourcedefinitions/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes customresourcedefinitions"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection customresourcedefinitions resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Customresourcedefinitions"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apiregistration.k8s.io/apiservices/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads apiservices"),
		// 				Operation: to.Ptr("Gets/List apiservices resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Apiservices"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apiregistration.k8s.io/apiservices/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes apiservices"),
		// 				Operation: to.Ptr("Creates/Updates apiservices resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Apiservices"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apiregistration.k8s.io/apiservices/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes apiservices"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection apiservices resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Apiservices"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apps/controllerrevisions/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads controllerrevisions"),
		// 				Operation: to.Ptr("Gets/List controllerrevisions resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Controllerrevisions"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apps/controllerrevisions/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes controllerrevisions"),
		// 				Operation: to.Ptr("Creates/Updates controllerrevisions resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Controllerrevisions"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apps/controllerrevisions/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes controllerrevisions"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection controllerrevisions resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Controllerrevisions"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apps/daemonsets/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads daemonsets"),
		// 				Operation: to.Ptr("Gets/List daemonsets resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Daemonsets"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apps/daemonsets/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes daemonsets"),
		// 				Operation: to.Ptr("Creates/Updates daemonsets resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Daemonsets"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apps/daemonsets/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes daemonsets"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection daemonsets resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Daemonsets"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apps/deployments/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads deployments"),
		// 				Operation: to.Ptr("Gets/List deployments resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Deployments"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apps/deployments/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes deployments"),
		// 				Operation: to.Ptr("Creates/Updates deployments resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Deployments"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apps/deployments/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes deployments"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection deployments resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Deployments"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apps/replicasets/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads replicasets"),
		// 				Operation: to.Ptr("Gets/List replicasets resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Replicasets"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apps/replicasets/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes replicasets"),
		// 				Operation: to.Ptr("Creates/Updates replicasets resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Replicasets"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apps/replicasets/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes replicasets"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection replicasets resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Replicasets"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apps/statefulsets/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads statefulsets"),
		// 				Operation: to.Ptr("Gets/List statefulsets resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Statefulsets"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apps/statefulsets/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes statefulsets"),
		// 				Operation: to.Ptr("Creates/Updates statefulsets resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Statefulsets"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apps/statefulsets/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes statefulsets"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection statefulsets resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Statefulsets"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/authentication.k8s.io/tokenreviews/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes tokenreviews"),
		// 				Operation: to.Ptr("Creates/Updates tokenreviews resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Tokenreviews"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/authorization.k8s.io/localsubjectaccessreviews/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes localsubjectaccessreviews"),
		// 				Operation: to.Ptr("Creates/Updates localsubjectaccessreviews resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Localsubjectaccessreviews"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/authorization.k8s.io/selfsubjectaccessreviews/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes selfsubjectaccessreviews"),
		// 				Operation: to.Ptr("Creates/Updates selfsubjectaccessreviews resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Selfsubjectaccessreviews"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/authorization.k8s.io/selfsubjectrulesreviews/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes selfsubjectrulesreviews"),
		// 				Operation: to.Ptr("Creates/Updates selfsubjectrulesreviews resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Selfsubjectrulesreviews"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/authorization.k8s.io/subjectaccessreviews/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes subjectaccessreviews"),
		// 				Operation: to.Ptr("Creates/Updates subjectaccessreviews resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Subjectaccessreviews"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/autoscaling/horizontalpodautoscalers/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads horizontalpodautoscalers"),
		// 				Operation: to.Ptr("Gets/List horizontalpodautoscalers resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Horizontalpodautoscalers"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/autoscaling/horizontalpodautoscalers/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes horizontalpodautoscalers"),
		// 				Operation: to.Ptr("Creates/Updates horizontalpodautoscalers resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Horizontalpodautoscalers"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/autoscaling/horizontalpodautoscalers/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes horizontalpodautoscalers"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection horizontalpodautoscalers resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Horizontalpodautoscalers"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/batch/cronjobs/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads cronjobs"),
		// 				Operation: to.Ptr("Gets/List cronjobs resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Cronjobs"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/batch/cronjobs/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes cronjobs"),
		// 				Operation: to.Ptr("Creates/Updates cronjobs resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Cronjobs"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/batch/cronjobs/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes cronjobs"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection cronjobs resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Cronjobs"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/batch/jobs/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads jobs"),
		// 				Operation: to.Ptr("Gets/List jobs resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Jobs"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/batch/jobs/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes jobs"),
		// 				Operation: to.Ptr("Creates/Updates jobs resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Jobs"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/batch/jobs/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes jobs"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection jobs resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Jobs"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/certificates.k8s.io/certificatesigningrequests/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads certificatesigningrequests"),
		// 				Operation: to.Ptr("Gets/List certificatesigningrequests resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Certificatesigningrequests"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/certificates.k8s.io/certificatesigningrequests/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes certificatesigningrequests"),
		// 				Operation: to.Ptr("Creates/Updates certificatesigningrequests resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Certificatesigningrequests"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/certificates.k8s.io/certificatesigningrequests/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes certificatesigningrequests"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection certificatesigningrequests resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Certificatesigningrequests"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/coordination.k8s.io/leases/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads leases"),
		// 				Operation: to.Ptr("Gets/List leases resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Leases"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/coordination.k8s.io/leases/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes leases"),
		// 				Operation: to.Ptr("Creates/Updates leases resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Leases"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/coordination.k8s.io/leases/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes leases"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection leases resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Leases"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/bindings/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes bindings"),
		// 				Operation: to.Ptr("Creates/Updates bindings resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Bindings"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/componentstatuses/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads componentstatuses"),
		// 				Operation: to.Ptr("Gets/List componentstatuses resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Componentstatuses"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/componentstatuses/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes componentstatuses"),
		// 				Operation: to.Ptr("Creates/Updates componentstatuses resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Componentstatuses"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/componentstatuses/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes componentstatuses"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection componentstatuses resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Componentstatuses"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/configmaps/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads configmaps"),
		// 				Operation: to.Ptr("Gets/List configmaps resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Configmaps"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/configmaps/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes configmaps"),
		// 				Operation: to.Ptr("Creates/Updates configmaps resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Configmaps"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/configmaps/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes configmaps"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection configmaps resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Configmaps"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/endpoints/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads endpoints"),
		// 				Operation: to.Ptr("Gets/List endpoints resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Endpoints"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/endpoints/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes endpoints"),
		// 				Operation: to.Ptr("Creates/Updates endpoints resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Endpoints"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/endpoints/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes endpoints"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection endpoints resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Endpoints"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/events/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads events"),
		// 				Operation: to.Ptr("Gets/List events resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Events"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/events/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes events"),
		// 				Operation: to.Ptr("Creates/Updates events resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Events"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/events/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes events"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection events resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Events"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/limitranges/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads limitranges"),
		// 				Operation: to.Ptr("Gets/List limitranges resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Limitranges"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/limitranges/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes limitranges"),
		// 				Operation: to.Ptr("Creates/Updates limitranges resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Limitranges"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/limitranges/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes limitranges"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection limitranges resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Limitranges"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/namespaces/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads namespaces"),
		// 				Operation: to.Ptr("Gets/List namespaces resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Namespaces"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/namespaces/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes namespaces"),
		// 				Operation: to.Ptr("Creates/Updates namespaces resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Namespaces"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/namespaces/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes namespaces"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection namespaces resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Namespaces"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/nodes/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads nodes"),
		// 				Operation: to.Ptr("Gets/List nodes resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Nodes"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/nodes/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes nodes"),
		// 				Operation: to.Ptr("Creates/Updates nodes resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Nodes"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/nodes/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes nodes"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection nodes resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Nodes"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/persistentvolumeclaims/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads persistentvolumeclaims"),
		// 				Operation: to.Ptr("Gets/List persistentvolumeclaims resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Persistentvolumeclaims"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/persistentvolumeclaims/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes persistentvolumeclaims"),
		// 				Operation: to.Ptr("Creates/Updates persistentvolumeclaims resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Persistentvolumeclaims"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/persistentvolumeclaims/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes persistentvolumeclaims"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection persistentvolumeclaims resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Persistentvolumeclaims"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/persistentvolumes/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads persistentvolumes"),
		// 				Operation: to.Ptr("Gets/List persistentvolumes resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Persistentvolumes"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/persistentvolumes/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes persistentvolumes"),
		// 				Operation: to.Ptr("Creates/Updates persistentvolumes resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Persistentvolumes"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/persistentvolumes/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes persistentvolumes"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection persistentvolumes resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Persistentvolumes"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/pods/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads pods"),
		// 				Operation: to.Ptr("Gets/List pods resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Pods"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/pods/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes pods"),
		// 				Operation: to.Ptr("Creates/Updates pods resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Pods"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/pods/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes pods"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection pods resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Pods"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/pods/exec/action"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Exec into pods resource"),
		// 				Operation: to.Ptr("Exec into pods resource "),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Pods"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/podtemplates/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads podtemplates"),
		// 				Operation: to.Ptr("Gets/List podtemplates resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Podtemplates"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/podtemplates/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes podtemplates"),
		// 				Operation: to.Ptr("Creates/Updates podtemplates resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Podtemplates"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/podtemplates/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes podtemplates"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection podtemplates resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Podtemplates"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/replicationcontrollers/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads replicationcontrollers"),
		// 				Operation: to.Ptr("Gets/List replicationcontrollers resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Replicationcontrollers"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/replicationcontrollers/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes replicationcontrollers"),
		// 				Operation: to.Ptr("Creates/Updates replicationcontrollers resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Replicationcontrollers"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/replicationcontrollers/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes replicationcontrollers"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection replicationcontrollers resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Replicationcontrollers"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/resourcequotas/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads resourcequotas"),
		// 				Operation: to.Ptr("Gets/List resourcequotas resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Resourcequotas"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/resourcequotas/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes resourcequotas"),
		// 				Operation: to.Ptr("Creates/Updates resourcequotas resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Resourcequotas"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/resourcequotas/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes resourcequotas"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection resourcequotas resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Resourcequotas"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/secrets/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads secrets"),
		// 				Operation: to.Ptr("Gets/List secrets resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Secrets"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/secrets/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes secrets"),
		// 				Operation: to.Ptr("Creates/Updates secrets resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Secrets"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/secrets/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes secrets"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection secrets resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Secrets"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/serviceaccounts/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads serviceaccounts"),
		// 				Operation: to.Ptr("Gets/List serviceaccounts resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Serviceaccounts"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/serviceaccounts/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes serviceaccounts"),
		// 				Operation: to.Ptr("Creates/Updates serviceaccounts resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Serviceaccounts"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/serviceaccounts/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes serviceaccounts"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection serviceaccounts resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Serviceaccounts"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/services/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads services"),
		// 				Operation: to.Ptr("Gets/List services resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Services"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/services/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes services"),
		// 				Operation: to.Ptr("Creates/Updates services resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Services"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/services/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes services"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection services resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Services"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/events.k8s.io/events/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads events"),
		// 				Operation: to.Ptr("Gets/List events resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Events"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/events.k8s.io/events/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes events"),
		// 				Operation: to.Ptr("Creates/Updates events resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Events"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/events.k8s.io/events/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes events"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection events resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Events"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/extensions/daemonsets/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads daemonsets"),
		// 				Operation: to.Ptr("Gets/List daemonsets resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Daemonsets"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/extensions/daemonsets/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes daemonsets"),
		// 				Operation: to.Ptr("Creates/Updates daemonsets resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Daemonsets"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/extensions/daemonsets/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes daemonsets"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection daemonsets resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Daemonsets"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/extensions/deployments/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads deployments"),
		// 				Operation: to.Ptr("Gets/List deployments resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Deployments"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/extensions/deployments/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes deployments"),
		// 				Operation: to.Ptr("Creates/Updates deployments resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Deployments"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/extensions/deployments/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes deployments"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection deployments resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Deployments"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/extensions/ingresses/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads ingresses"),
		// 				Operation: to.Ptr("Gets/List ingresses resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Ingresses"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/extensions/ingresses/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes ingresses"),
		// 				Operation: to.Ptr("Creates/Updates ingresses resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Ingresses"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/extensions/ingresses/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes ingresses"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection ingresses resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Ingresses"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/extensions/networkpolicies/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads networkpolicies"),
		// 				Operation: to.Ptr("Gets/List networkpolicies resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Networkpolicies"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/extensions/networkpolicies/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes networkpolicies"),
		// 				Operation: to.Ptr("Creates/Updates networkpolicies resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Networkpolicies"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/extensions/networkpolicies/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes networkpolicies"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection networkpolicies resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Networkpolicies"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/extensions/podsecuritypolicies/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads podsecuritypolicies"),
		// 				Operation: to.Ptr("Gets/List podsecuritypolicies resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Podsecuritypolicies"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/extensions/podsecuritypolicies/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes podsecuritypolicies"),
		// 				Operation: to.Ptr("Creates/Updates podsecuritypolicies resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Podsecuritypolicies"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/extensions/podsecuritypolicies/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes podsecuritypolicies"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection podsecuritypolicies resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Podsecuritypolicies"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/extensions/replicasets/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads replicasets"),
		// 				Operation: to.Ptr("Gets/List replicasets resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Replicasets"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/extensions/replicasets/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes replicasets"),
		// 				Operation: to.Ptr("Creates/Updates replicasets resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Replicasets"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/extensions/replicasets/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes replicasets"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection replicasets resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Replicasets"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/metrics.k8s.io/pods/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads pods"),
		// 				Operation: to.Ptr("Gets/List pods resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Pods"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/metrics.k8s.io/nodes/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads nodes"),
		// 				Operation: to.Ptr("Gets/List nodes resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Nodes"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/networking.k8s.io/networkpolicies/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads networkpolicies"),
		// 				Operation: to.Ptr("Gets/List networkpolicies resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Networkpolicies"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/networking.k8s.io/networkpolicies/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes networkpolicies"),
		// 				Operation: to.Ptr("Creates/Updates networkpolicies resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Networkpolicies"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/networking.k8s.io/networkpolicies/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes networkpolicies"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection networkpolicies resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Networkpolicies"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/networking.k8s.io/ingresses/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads ingresses"),
		// 				Operation: to.Ptr("Gets/List ingresses resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Ingresses"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/networking.k8s.io/ingresses/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes ingresses"),
		// 				Operation: to.Ptr("Creates/Updates ingresses resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Ingresses"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/networking.k8s.io/ingresses/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes ingresses"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection ingresses resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Ingresses"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/node.k8s.io/runtimeclasses/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads runtimeclasses"),
		// 				Operation: to.Ptr("Gets/List runtimeclasses resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Runtimeclasses"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/node.k8s.io/runtimeclasses/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes runtimeclasses"),
		// 				Operation: to.Ptr("Creates/Updates runtimeclasses resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Runtimeclasses"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/node.k8s.io/runtimeclasses/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes runtimeclasses"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection runtimeclasses resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Runtimeclasses"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/api/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads api"),
		// 				Operation: to.Ptr("Gets/List api resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Api"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/api/v1/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads api/v1"),
		// 				Operation: to.Ptr("Gets/List api/v1 resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Api/V1"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads apis"),
		// 				Operation: to.Ptr("Gets/List apis resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Apis"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/admissionregistration.k8s.io/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads admissionregistration.k8s.io"),
		// 				Operation: to.Ptr("Gets/List admissionregistration.k8s.io resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Admissionregistration.K8s.Io"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/admissionregistration.k8s.io/v1/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads admissionregistration.k8s.io/v1"),
		// 				Operation: to.Ptr("Gets/List admissionregistration.k8s.io/v1 resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Admissionregistration.K8s.Io/V1"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/admissionregistration.k8s.io/v1beta1/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads admissionregistration.k8s.io/v1beta1"),
		// 				Operation: to.Ptr("Gets/List admissionregistration.k8s.io/v1beta1 resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Admissionregistration.K8s.Io/V1beta1"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/apiextensions.k8s.io/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads apiextensions.k8s.io"),
		// 				Operation: to.Ptr("Gets/List apiextensions.k8s.io resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Apiextensions.K8s.Io"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/apiextensions.k8s.io/v1/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads apiextensions.k8s.io/v1"),
		// 				Operation: to.Ptr("Gets/List apiextensions.k8s.io/v1 resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Apiextensions.K8s.Io/V1"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/apiextensions.k8s.io/v1beta1/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads apiextensions.k8s.io/v1beta1"),
		// 				Operation: to.Ptr("Gets/List apiextensions.k8s.io/v1beta1 resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Apiextensions.K8s.Io/V1beta1"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/apiregistration.k8s.io/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads apiregistration.k8s.io"),
		// 				Operation: to.Ptr("Gets/List apiregistration.k8s.io resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Apiregistration.K8s.Io"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/apiregistration.k8s.io/v1/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads apiregistration.k8s.io/v1"),
		// 				Operation: to.Ptr("Gets/List apiregistration.k8s.io/v1 resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Apiregistration.K8s.Io/V1"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/apiregistration.k8s.io/v1beta1/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads apiregistration.k8s.io/v1beta1"),
		// 				Operation: to.Ptr("Gets/List apiregistration.k8s.io/v1beta1 resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Apiregistration.K8s.Io/V1beta1"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/apps/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads apps"),
		// 				Operation: to.Ptr("Gets/List apps resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Apps"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/apps/v1/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads apps/v1"),
		// 				Operation: to.Ptr("Gets/List apps/v1 resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Apps/V1"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/apps/v1beta1/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads apps/v1beta1"),
		// 				Operation: to.Ptr("Gets/List apps/v1beta1 resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Apps/V1beta1"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/apps/v1beta2/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads apps/v1beta2"),
		// 				Operation: to.Ptr("Gets/List apps/v1beta2 resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Apps/V1beta2"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/authentication.k8s.io/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads authentication.k8s.io"),
		// 				Operation: to.Ptr("Gets/List authentication.k8s.io resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Authentication.K8s.Io"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/authentication.k8s.io/v1/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads authentication.k8s.io/v1"),
		// 				Operation: to.Ptr("Gets/List authentication.k8s.io/v1 resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Authentication.K8s.Io/V1"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/authentication.k8s.io/v1beta1/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads authentication.k8s.io/v1beta1"),
		// 				Operation: to.Ptr("Gets/List authentication.k8s.io/v1beta1 resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Authentication.K8s.Io/V1beta1"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/authorization.k8s.io/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads authorization.k8s.io"),
		// 				Operation: to.Ptr("Gets/List authorization.k8s.io resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Authorization.K8s.Io"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/authorization.k8s.io/v1/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads authorization.k8s.io/v1"),
		// 				Operation: to.Ptr("Gets/List authorization.k8s.io/v1 resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Authorization.K8s.Io/V1"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/authorization.k8s.io/v1beta1/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads authorization.k8s.io/v1beta1"),
		// 				Operation: to.Ptr("Gets/List authorization.k8s.io/v1beta1 resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Authorization.K8s.Io/V1beta1"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/autoscaling/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads autoscaling"),
		// 				Operation: to.Ptr("Gets/List autoscaling resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Autoscaling"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/autoscaling/v1/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads autoscaling/v1"),
		// 				Operation: to.Ptr("Gets/List autoscaling/v1 resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Autoscaling/V1"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/autoscaling/v2beta1/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads autoscaling/v2beta1"),
		// 				Operation: to.Ptr("Gets/List autoscaling/v2beta1 resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Autoscaling/V2beta1"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/autoscaling/v2beta2/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads autoscaling/v2beta2"),
		// 				Operation: to.Ptr("Gets/List autoscaling/v2beta2 resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Autoscaling/V2beta2"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/batch/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads batch"),
		// 				Operation: to.Ptr("Gets/List batch resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Batch"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/batch/v1/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads batch/v1"),
		// 				Operation: to.Ptr("Gets/List batch/v1 resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Batch/V1"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/batch/v1beta1/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads batch/v1beta1"),
		// 				Operation: to.Ptr("Gets/List batch/v1beta1 resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Batch/V1beta1"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/certificates.k8s.io/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads certificates.k8s.io"),
		// 				Operation: to.Ptr("Gets/List certificates.k8s.io resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Certificates.K8s.Io"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/certificates.k8s.io/v1beta1/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads certificates.k8s.io/v1beta1"),
		// 				Operation: to.Ptr("Gets/List certificates.k8s.io/v1beta1 resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Certificates.K8s.Io/V1beta1"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/coordination.k8s.io/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads coordination.k8s.io"),
		// 				Operation: to.Ptr("Gets/List coordination.k8s.io resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Coordination.K8s.Io"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/coordination.k8s.io/v1/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads coordination/v1"),
		// 				Operation: to.Ptr("Gets/List coordination/v1 resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Coordination.K8s.Io/V1"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/coordination.k8s.io/v1beta1/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads coordination.k8s.io/v1beta1"),
		// 				Operation: to.Ptr("Gets/List coordination.k8s.io/v1beta1 resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Coordination.K8s.Io/V1beta1"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/events.k8s.io/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads events.k8s.io"),
		// 				Operation: to.Ptr("Gets/List events.k8s.io resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Events.K8s.Io"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/events.k8s.io/v1beta1/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads events.k8s.io/v1beta1"),
		// 				Operation: to.Ptr("Gets/List events.k8s.io/v1beta1 resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Events.K8s.Io/V1beta1"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/extensions/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads extensions"),
		// 				Operation: to.Ptr("Gets/List extensions resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Extensions"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/extensions/v1beta1/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads extensions/v1beta1"),
		// 				Operation: to.Ptr("Gets/List extensions/v1beta1 resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Extensions/V1beta1"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/metrics.k8s.io/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads metrics.k8s.io"),
		// 				Operation: to.Ptr("Gets/List metrics.k8s.io resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Metrics.K8s.Io"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/metrics.k8s.io/v1beta1/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads metrics.k8s.io/v1beta1"),
		// 				Operation: to.Ptr("Gets/List metrics.k8s.io/v1beta1 resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Metrics.K8s.Io/V1beta1"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/networking.k8s.io/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads networking.k8s.io"),
		// 				Operation: to.Ptr("Gets/List networking.k8s.io resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Networking.K8s.Io"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/networking.k8s.io/v1/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads networking/v1"),
		// 				Operation: to.Ptr("Gets/List networking/v1 resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Networking.K8s.Io/V1"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/networking.k8s.io/v1beta1/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads networking.k8s.io/v1beta1"),
		// 				Operation: to.Ptr("Gets/List networking.k8s.io/v1beta1 resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Networking.K8s.Io/V1beta1"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/node.k8s.io/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads node.k8s.io"),
		// 				Operation: to.Ptr("Gets/List node.k8s.io resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Node.K8s.Io"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/node.k8s.io/v1beta1/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads node.k8s.io/v1beta1"),
		// 				Operation: to.Ptr("Gets/List node.k8s.io/v1beta1 resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Node.K8s.Io/V1beta1"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/policy/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads policy"),
		// 				Operation: to.Ptr("Gets/List policy resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Policy"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/policy/v1beta1/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads policy/v1beta1"),
		// 				Operation: to.Ptr("Gets/List policy/v1beta1 resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Policy/V1beta1"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/rbac.authorization.k8s.io/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads rbac.authorization.k8s.io"),
		// 				Operation: to.Ptr("Gets/List rbac.authorization.k8s.io resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Rbac.Authorization.K8s.Io"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/rbac.authorization.k8s.io/v1/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads rbac.authorization/v1"),
		// 				Operation: to.Ptr("Gets/List rbac.authorization/v1 resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Rbac.Authorization.K8s.Io/V1"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/rbac.authorization.k8s.io/v1beta1/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads rbac.authorization.k8s.io/v1beta1"),
		// 				Operation: to.Ptr("Gets/List rbac.authorization.k8s.io/v1beta1 resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Rbac.Authorization.K8s.Io/V1beta1"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/scheduling.k8s.io/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads scheduling.k8s.io"),
		// 				Operation: to.Ptr("Gets/List scheduling.k8s.io resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Scheduling.K8s.Io"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/scheduling.k8s.io/v1/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads scheduling/v1"),
		// 				Operation: to.Ptr("Gets/List scheduling/v1 resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Scheduling.K8s.Io/V1"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/scheduling.k8s.io/v1beta1/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads scheduling.k8s.io/v1beta1"),
		// 				Operation: to.Ptr("Gets/List scheduling.k8s.io/v1beta1 resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Scheduling.K8s.Io/V1beta1"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/storage.k8s.io/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads storage.k8s.io"),
		// 				Operation: to.Ptr("Gets/List storage.k8s.io resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Storage.K8s.Io"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/storage.k8s.io/v1/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads storage/v1"),
		// 				Operation: to.Ptr("Gets/List storage/v1 resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Storage.K8s.Io/V1"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/apis/storage.k8s.io/v1beta1/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads storage.k8s.io/v1beta1"),
		// 				Operation: to.Ptr("Gets/List storage.k8s.io/v1beta1 resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Storage.K8s.Io/V1beta1"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/healthz/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads healthz"),
		// 				Operation: to.Ptr("Gets/List healthz resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Healthz"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/healthz/autoregister-completion/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads autoregister-completion"),
		// 				Operation: to.Ptr("Gets/List autoregister-completion resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Healthz/Autoregister-Completion"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/healthz/etcd/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads etcd"),
		// 				Operation: to.Ptr("Gets/List etcd resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Healthz/Etcd"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/healthz/log/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads log"),
		// 				Operation: to.Ptr("Gets/List log resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Healthz/Log"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/healthz/ping/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads ping"),
		// 				Operation: to.Ptr("Gets/List ping resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Healthz/Ping"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/healthz/poststarthook/apiservice-openapi-controller/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads apiservice-openapi-controller"),
		// 				Operation: to.Ptr("Gets/List apiservice-openapi-controller resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Healthz/Poststarthook/Apiservice-Openapi-Controller"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/healthz/poststarthook/apiservice-registration-controller/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads apiservice-registration-controller"),
		// 				Operation: to.Ptr("Gets/List apiservice-registration-controller resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Healthz/Poststarthook/Apiservice-Registration-Controller"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/healthz/poststarthook/apiservice-status-available-controller/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads apiservice-status-available-controller"),
		// 				Operation: to.Ptr("Gets/List apiservice-status-available-controller resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Healthz/Poststarthook/Apiservice-Status-Available-Controller"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/healthz/poststarthook/bootstrap-controller/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads bootstrap-controller"),
		// 				Operation: to.Ptr("Gets/List bootstrap-controller resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Healthz/Poststarthook/Bootstrap-Controller"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/healthz/poststarthook/ca-registration/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads ca-registration"),
		// 				Operation: to.Ptr("Gets/List ca-registration resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Healthz/Poststarthook/Ca-Registration"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/healthz/poststarthook/crd-informer-synced/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads crd-informer-synced"),
		// 				Operation: to.Ptr("Gets/List crd-informer-synced resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Healthz/Poststarthook/Crd-Informer-Synced"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/healthz/poststarthook/generic-apiserver-start-informers/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads generic-apiserver-start-informers"),
		// 				Operation: to.Ptr("Gets/List generic-apiserver-start-informers resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Healthz/Poststarthook/Generic-Apiserver-Start-Informers"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/healthz/poststarthook/kube-apiserver-autoregistration/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads kube-apiserver-autoregistration"),
		// 				Operation: to.Ptr("Gets/List kube-apiserver-autoregistration resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Healthz/Poststarthook/Kube-Apiserver-Autoregistration"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/healthz/poststarthook/rbac/bootstrap-roles/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads bootstrap-roles"),
		// 				Operation: to.Ptr("Gets/List bootstrap-roles resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Healthz/Poststarthook/Bootstrap-Roles"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/healthz/poststarthook/scheduling/bootstrap-system-priority-classes/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads bootstrap-system-priority-classes"),
		// 				Operation: to.Ptr("Gets/List bootstrap-system-priority-classes resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Healthz/Poststarthook/Bootstrap-System-Priority-Classes"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/healthz/poststarthook/start-apiextensions-controllers/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads start-apiextensions-controllers"),
		// 				Operation: to.Ptr("Gets/List start-apiextensions-controllers resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Healthz/Poststarthook/Start-Apiextensions-Controllers"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/healthz/poststarthook/start-apiextensions-informers/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads start-apiextensions-informers"),
		// 				Operation: to.Ptr("Gets/List start-apiextensions-informers resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Healthz/Poststarthook/Start-Apiextensions-Informers"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/healthz/poststarthook/start-kube-aggregator-informers/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads start-kube-aggregator-informers"),
		// 				Operation: to.Ptr("Gets/List start-kube-aggregator-informers resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Healthz/Poststarthook/Start-Kube-Aggregator-Informers"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/healthz/poststarthook/start-kube-apiserver-admission-initializer/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads start-kube-apiserver-admission-initializer"),
		// 				Operation: to.Ptr("Gets/List start-kube-apiserver-admission-initializer resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Healthz/Poststarthook/Start-Kube-Apiserver-Admission-Initializer"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/livez/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads livez"),
		// 				Operation: to.Ptr("Gets/List livez resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Livez"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/livez/autoregister-completion/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads autoregister-completion"),
		// 				Operation: to.Ptr("Gets/List autoregister-completion resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Livez/Autoregister-Completion"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/livez/etcd/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads etcd"),
		// 				Operation: to.Ptr("Gets/List etcd resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Livez/Etcd"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/livez/log/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads log"),
		// 				Operation: to.Ptr("Gets/List log resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Livez/Log"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/livez/ping/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads ping"),
		// 				Operation: to.Ptr("Gets/List ping resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Livez/Ping"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/livez/poststarthook/apiservice-openapi-controller/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads apiservice-openapi-controller"),
		// 				Operation: to.Ptr("Gets/List apiservice-openapi-controller resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Livez/Poststarthook/Apiservice-Openapi-Controller"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/livez/poststarthook/apiservice-registration-controller/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads apiservice-registration-controller"),
		// 				Operation: to.Ptr("Gets/List apiservice-registration-controller resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Livez/Poststarthook/Apiservice-Registration-Controller"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/livez/poststarthook/apiservice-status-available-controller/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads apiservice-status-available-controller"),
		// 				Operation: to.Ptr("Gets/List apiservice-status-available-controller resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Livez/Poststarthook/Apiservice-Status-Available-Controller"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/livez/poststarthook/bootstrap-controller/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads bootstrap-controller"),
		// 				Operation: to.Ptr("Gets/List bootstrap-controller resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Livez/Poststarthook/Bootstrap-Controller"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/livez/poststarthook/ca-registration/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads ca-registration"),
		// 				Operation: to.Ptr("Gets/List ca-registration resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Livez/Poststarthook/Ca-Registration"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/livez/poststarthook/crd-informer-synced/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads crd-informer-synced"),
		// 				Operation: to.Ptr("Gets/List crd-informer-synced resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Livez/Poststarthook/Crd-Informer-Synced"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/livez/poststarthook/generic-apiserver-start-informers/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads generic-apiserver-start-informers"),
		// 				Operation: to.Ptr("Gets/List generic-apiserver-start-informers resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Livez/Poststarthook/Generic-Apiserver-Start-Informers"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/livez/poststarthook/kube-apiserver-autoregistration/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads kube-apiserver-autoregistration"),
		// 				Operation: to.Ptr("Gets/List kube-apiserver-autoregistration resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Livez/Poststarthook/Kube-Apiserver-Autoregistration"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/livez/poststarthook/rbac/bootstrap-roles/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads bootstrap-roles"),
		// 				Operation: to.Ptr("Gets/List bootstrap-roles resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Livez/Poststarthook/Bootstrap-Roles"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/livez/poststarthook/scheduling/bootstrap-system-priority-classes/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads bootstrap-system-priority-classes"),
		// 				Operation: to.Ptr("Gets/List bootstrap-system-priority-classes resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Livez/Poststarthook/Bootstrap-System-Priority-Classes"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/livez/poststarthook/start-apiextensions-controllers/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads start-apiextensions-controllers"),
		// 				Operation: to.Ptr("Gets/List start-apiextensions-controllers resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Livez/Poststarthook/Start-Apiextensions-Controllers"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/livez/poststarthook/start-apiextensions-informers/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads start-apiextensions-informers"),
		// 				Operation: to.Ptr("Gets/List start-apiextensions-informers resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Livez/Poststarthook/Start-Apiextensions-Informers"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/livez/poststarthook/start-kube-aggregator-informers/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads start-kube-aggregator-informers"),
		// 				Operation: to.Ptr("Gets/List start-kube-aggregator-informers resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Livez/Poststarthook/Start-Kube-Aggregator-Informers"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/livez/poststarthook/start-kube-apiserver-admission-initializer/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads start-kube-apiserver-admission-initializer"),
		// 				Operation: to.Ptr("Gets/List start-kube-apiserver-admission-initializer resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Livez/Poststarthook/Start-Kube-Apiserver-Admission-Initializer"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/logs/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads logs"),
		// 				Operation: to.Ptr("Gets/List logs resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Logs"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/metrics/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads metrics"),
		// 				Operation: to.Ptr("Gets/List metrics resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Metrics"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/openapi/v2/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads v2"),
		// 				Operation: to.Ptr("Gets/List v2 resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Openapi/V2"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/readyz/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads readyz"),
		// 				Operation: to.Ptr("Gets/List readyz resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Readyz"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/readyz/autoregister-completion/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads autoregister-completion"),
		// 				Operation: to.Ptr("Gets/List autoregister-completion resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Readyz/Autoregister-Completion"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/readyz/etcd/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads etcd"),
		// 				Operation: to.Ptr("Gets/List etcd resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Readyz/Etcd"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/readyz/log/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads log"),
		// 				Operation: to.Ptr("Gets/List log resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Readyz/Log"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/readyz/ping/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads ping"),
		// 				Operation: to.Ptr("Gets/List ping resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Readyz/Ping"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/readyz/poststarthook/apiservice-openapi-controller/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads apiservice-openapi-controller"),
		// 				Operation: to.Ptr("Gets/List apiservice-openapi-controller resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Readyz/Poststarthook/Apiservice-Openapi-Controller"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/readyz/poststarthook/apiservice-registration-controller/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads apiservice-registration-controller"),
		// 				Operation: to.Ptr("Gets/List apiservice-registration-controller resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Readyz/Poststarthook/Apiservice-Registration-Controller"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/readyz/poststarthook/apiservice-status-available-controller/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads apiservice-status-available-controller"),
		// 				Operation: to.Ptr("Gets/List apiservice-status-available-controller resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Readyz/Poststarthook/Apiservice-Status-Available-Controller"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/readyz/poststarthook/bootstrap-controller/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads bootstrap-controller"),
		// 				Operation: to.Ptr("Gets/List bootstrap-controller resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Readyz/Poststarthook/Bootstrap-Controller"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/readyz/poststarthook/ca-registration/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads ca-registration"),
		// 				Operation: to.Ptr("Gets/List ca-registration resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Readyz/Poststarthook/Ca-Registration"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/readyz/poststarthook/crd-informer-synced/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads crd-informer-synced"),
		// 				Operation: to.Ptr("Gets/List crd-informer-synced resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Readyz/Poststarthook/Crd-Informer-Synced"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/readyz/poststarthook/generic-apiserver-start-informers/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads generic-apiserver-start-informers"),
		// 				Operation: to.Ptr("Gets/List generic-apiserver-start-informers resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Readyz/Poststarthook/Generic-Apiserver-Start-Informers"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/readyz/poststarthook/kube-apiserver-autoregistration/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads kube-apiserver-autoregistration"),
		// 				Operation: to.Ptr("Gets/List kube-apiserver-autoregistration resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Readyz/Poststarthook/Kube-Apiserver-Autoregistration"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/readyz/poststarthook/rbac/bootstrap-roles/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads bootstrap-roles"),
		// 				Operation: to.Ptr("Gets/List bootstrap-roles resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Readyz/Poststarthook/Bootstrap-Roles"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/readyz/poststarthook/scheduling/bootstrap-system-priority-classes/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads bootstrap-system-priority-classes"),
		// 				Operation: to.Ptr("Gets/List bootstrap-system-priority-classes resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Readyz/Poststarthook/Bootstrap-System-Priority-Classes"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/readyz/poststarthook/start-apiextensions-controllers/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads start-apiextensions-controllers"),
		// 				Operation: to.Ptr("Gets/List start-apiextensions-controllers resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Readyz/Poststarthook/Start-Apiextensions-Controllers"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/readyz/poststarthook/start-apiextensions-informers/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads start-apiextensions-informers"),
		// 				Operation: to.Ptr("Gets/List start-apiextensions-informers resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Readyz/Poststarthook/Start-Apiextensions-Informers"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/readyz/poststarthook/start-kube-aggregator-informers/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads start-kube-aggregator-informers"),
		// 				Operation: to.Ptr("Gets/List start-kube-aggregator-informers resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Readyz/Poststarthook/Start-Kube-Aggregator-Informers"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/readyz/poststarthook/start-kube-apiserver-admission-initializer/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads start-kube-apiserver-admission-initializer"),
		// 				Operation: to.Ptr("Gets/List start-kube-apiserver-admission-initializer resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Readyz/Poststarthook/Start-Kube-Apiserver-Admission-Initializer"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/readyz/shutdown/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads shutdown"),
		// 				Operation: to.Ptr("Gets/List shutdown resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Readyz/Shutdown"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/resetMetrics/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads resetMetrics"),
		// 				Operation: to.Ptr("Gets/List resetMetrics resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Resetmetrics"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/swagger-ui/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads swagger-ui"),
		// 				Operation: to.Ptr("Gets/List swagger-ui resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Swagger-Ui"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/swagger-api/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads swagger-api"),
		// 				Operation: to.Ptr("Gets/List swagger-api resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Swagger-Api"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/ui/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads ui"),
		// 				Operation: to.Ptr("Gets/List ui resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Ui"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/version/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads version"),
		// 				Operation: to.Ptr("Gets/List version resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Version"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/policy/poddisruptionbudgets/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads poddisruptionbudgets"),
		// 				Operation: to.Ptr("Gets/List poddisruptionbudgets resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Poddisruptionbudgets"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/policy/poddisruptionbudgets/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes poddisruptionbudgets"),
		// 				Operation: to.Ptr("Creates/Updates poddisruptionbudgets resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Poddisruptionbudgets"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/policy/poddisruptionbudgets/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes poddisruptionbudgets"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection poddisruptionbudgets resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Poddisruptionbudgets"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/policy/podsecuritypolicies/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads podsecuritypolicies"),
		// 				Operation: to.Ptr("Gets/List podsecuritypolicies resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Podsecuritypolicies"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/policy/podsecuritypolicies/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes podsecuritypolicies"),
		// 				Operation: to.Ptr("Creates/Updates podsecuritypolicies resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Podsecuritypolicies"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/policy/podsecuritypolicies/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes podsecuritypolicies"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection podsecuritypolicies resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Podsecuritypolicies"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/rbac.authorization.k8s.io/clusterrolebindings/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads clusterrolebindings"),
		// 				Operation: to.Ptr("Gets/List clusterrolebindings resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Clusterrolebindings"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/rbac.authorization.k8s.io/clusterrolebindings/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes clusterrolebindings"),
		// 				Operation: to.Ptr("Creates/Updates clusterrolebindings resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Clusterrolebindings"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/rbac.authorization.k8s.io/clusterrolebindings/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes clusterrolebindings"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection clusterrolebindings resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Clusterrolebindings"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/rbac.authorization.k8s.io/clusterroles/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads clusterroles"),
		// 				Operation: to.Ptr("Gets/List clusterroles resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Clusterroles"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/rbac.authorization.k8s.io/clusterroles/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes clusterroles"),
		// 				Operation: to.Ptr("Creates/Updates clusterroles resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Clusterroles"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/rbac.authorization.k8s.io/clusterroles/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes clusterroles"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection clusterroles resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Clusterroles"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/rbac.authorization.k8s.io/rolebindings/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads rolebindings"),
		// 				Operation: to.Ptr("Gets/List rolebindings resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Rolebindings"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/rbac.authorization.k8s.io/rolebindings/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes rolebindings"),
		// 				Operation: to.Ptr("Creates/Updates rolebindings resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Rolebindings"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/rbac.authorization.k8s.io/rolebindings/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes rolebindings"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection rolebindings resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Rolebindings"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/rbac.authorization.k8s.io/roles/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads roles"),
		// 				Operation: to.Ptr("Gets/List roles resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Roles"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/rbac.authorization.k8s.io/roles/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes roles"),
		// 				Operation: to.Ptr("Creates/Updates roles resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Roles"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/rbac.authorization.k8s.io/roles/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes roles"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection roles resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Roles"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/scheduling.k8s.io/priorityclasses/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads priorityclasses"),
		// 				Operation: to.Ptr("Gets/List priorityclasses resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Priorityclasses"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/scheduling.k8s.io/priorityclasses/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes priorityclasses"),
		// 				Operation: to.Ptr("Creates/Updates priorityclasses resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Priorityclasses"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/scheduling.k8s.io/priorityclasses/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes priorityclasses"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection priorityclasses resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Priorityclasses"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/policy/podsecuritypolicies/use/action"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Use action on podsecuritypolicies"),
		// 				Operation: to.Ptr("Use podsecuritypolicies resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Podsecuritypolicies"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/rbac.authorization.k8s.io/clusterroles/bind/action"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Binds clusterroles"),
		// 				Operation: to.Ptr("Bind clusterroles resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Clusterroles"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/rbac.authorization.k8s.io/clusterroles/escalate/action"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Escalates"),
		// 				Operation: to.Ptr("Escalate clusterroles resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Clusterroles"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/rbac.authorization.k8s.io/roles/bind/action"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Binds roles"),
		// 				Operation: to.Ptr("Bind roles resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Roles"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/rbac.authorization.k8s.io/roles/escalate/action"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Escalates roles"),
		// 				Operation: to.Ptr("Escalate roles resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Roles"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/serviceaccounts/impersonate/action"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Impersonate serviceaccounts"),
		// 				Operation: to.Ptr("Impersonate serviceaccounts resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Serviceaccounts"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/users/impersonate/action"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Impersonate users"),
		// 				Operation: to.Ptr("Impersonate users resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Users"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/groups/impersonate/action"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Impersonate groups"),
		// 				Operation: to.Ptr("Impersonate groups resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Groups"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/authentication.k8s.io/userextras/impersonate/action"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Impersonate userextras"),
		// 				Operation: to.Ptr("Impersonate userextras resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Userextras"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/storage.k8s.io/storageclasses/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads storageclasses"),
		// 				Operation: to.Ptr("Gets/List storageclasses resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Storageclasses"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/storage.k8s.io/storageclasses/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes storageclasses"),
		// 				Operation: to.Ptr("Creates/Updates storageclasses resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Storageclasses"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/storage.k8s.io/storageclasses/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes storageclasses"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection storageclasses resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Storageclasses"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/storage.k8s.io/volumeattachments/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads volumeattachments"),
		// 				Operation: to.Ptr("Gets/List volumeattachments resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Volumeattachments"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/storage.k8s.io/volumeattachments/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes volumeattachments"),
		// 				Operation: to.Ptr("Creates/Updates volumeattachments resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Volumeattachments"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/storage.k8s.io/volumeattachments/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes volumeattachments"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection volumeattachments resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Volumeattachments"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/storage.k8s.io/csidrivers/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads csidrivers"),
		// 				Operation: to.Ptr("Gets/List csidrivers resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Csidrivers"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/storage.k8s.io/csidrivers/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes csidrivers"),
		// 				Operation: to.Ptr("Creates/Updates csidrivers resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Csidrivers"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/storage.k8s.io/csidrivers/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes csidrivers"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection csidrivers resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Csidrivers"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/storage.k8s.io/csinodes/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Reads csinodes"),
		// 				Operation: to.Ptr("Gets/List csinodes resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Csinodes"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/storage.k8s.io/csinodes/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Writes csinodes"),
		// 				Operation: to.Ptr("Creates/Updates csinodes resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Csinodes"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/storage.k8s.io/csinodes/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Deletes csinodes"),
		// 				Operation: to.Ptr("Deletes/DeletesCollection csinodes resource"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Csinodes"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/providers/Microsoft.Insights/metricDefinitions/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Gets the available metrics for Managed Cluster"),
		// 				Operation: to.Ptr("Read Managed Cluster metric definitions"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("The metric definition of Managed Cluster"),
		// 			},
		// 			Origin: to.Ptr("system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/managedClusters/providers/Microsoft.Insights/logDefinitions/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Gets the available logs for Managed Cluster"),
		// 				Operation: to.Ptr("Read Managed Cluster log definitions"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("The log definition of Managed Cluster"),
		// 			},
		// 			Origin: to.Ptr("system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/openShiftManagedClusters/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Get a Open Shift Managed Cluster"),
		// 				Operation: to.Ptr("Get Open Shift Managed Cluster"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Open Shift Managed Cluster"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/openShiftManagedClusters/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Creates a new Open Shift Managed Cluster or updates an existing one"),
		// 				Operation: to.Ptr("Create or Update Open Shift Managed Cluster"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Open Shift Managed Cluster"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/openShiftManagedClusters/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Delete a Open Shift Managed Cluster"),
		// 				Operation: to.Ptr("Delete Open Shift Managed Cluster"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Open Shift Managed Cluster"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/openShiftClusters/read"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Get a Open Shift Cluster"),
		// 				Operation: to.Ptr("Get Open Shift Cluster"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Open Shift Cluster"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/openShiftClusters/write"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Creates a new Open Shift Cluster or updates an existing one"),
		// 				Operation: to.Ptr("Create or Update Open Shift Cluster"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Open Shift Cluster"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ContainerService/openShiftClusters/delete"),
		// 			Display: &armcontainerservice.OperationValueDisplay{
		// 				Description: to.Ptr("Delete a Open Shift Cluster"),
		// 				Operation: to.Ptr("Delete Open Shift Cluster"),
		// 				Provider: to.Ptr("Microsoft Container Service"),
		// 				Resource: to.Ptr("Open Shift Cluster"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 	}},
		// }
	}
}
