//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcustomerlockbox

import "time"

// Approval - Request content object, in the use of Approve or Deny a Lockbox request.
type Approval struct {
	// Reason of the decision
	Reason *string

	// Approval decision to the Lockbox request.
	Status *Status
}

// ErrorAdditionalInfoInfo - Additional information about the request that is in error state.
type ErrorAdditionalInfoInfo struct {
	// The current status/state of the request quired.
	CurrentStatus *Status
}

// LockboxRequestResponse - A Lockbox request response object, containing all information associated with the request.
type LockboxRequestResponse struct {
	// The properties that are associated with a lockbox request.
	Properties *LockboxRequestResponseProperties

	// READ-ONLY; The Arm resource id of the Lockbox request.
	ID *string

	// READ-ONLY; The name of the Lockbox request.
	Name *string

	// READ-ONLY; The type of the Lockbox request.
	Type *string
}

// LockboxRequestResponseProperties - The properties that are associated with a lockbox request.
type LockboxRequestResponseProperties struct {
	// The status of the request.
	Status *Status

	// READ-ONLY; Access level for requested resource
	AccessLevel *string

	// READ-ONLY; The creation time of the request.
	CreatedDateTime *time.Time

	// READ-ONLY; The duration of the request in hours.
	Duration *string

	// READ-ONLY; The expiration time of the request.
	ExpirationDateTime *time.Time

	// READ-ONLY; The justification of the requestor.
	Justification *string

	// READ-ONLY; The Lockbox request ID.
	RequestID *string

	// READ-ONLY; A list of resource IDs associated with the Lockbox request separated by ','.
	ResourceIDs *string

	// READ-ONLY; The resource type of the requested resources.
	ResourceType *string

	// READ-ONLY; The subscription ID.
	SubscriptionID *string

	// READ-ONLY; The url of the support case.
	SupportCaseURL *string

	// READ-ONLY; The id of the support request associated.
	SupportRequest *string

	// READ-ONLY; The support case system that was used to initiate the request.
	Workitemsource *string
}

// Operation result model for ARM RP
type Operation struct {
	// READ-ONLY; Contains the localized display information for this particular operation / action.
	Display *OperationDisplay

	// READ-ONLY; Gets or sets a value indicating whether it is a data plane action
	IsDataAction *string

	// READ-ONLY; Gets or sets action name
	Name *string

	// READ-ONLY; Gets or sets origin
	Origin *string

	// READ-ONLY; Gets or sets properties
	Properties *string
}

// OperationDisplay - Contains the localized display information for this particular operation / action.
type OperationDisplay struct {
	// READ-ONLY; The localized friendly description for the operation.
	Description *string

	// READ-ONLY; The localized friendly name for the operation.
	Operation *string

	// READ-ONLY; The localized friendly form of the resource provider name.
	Provider *string

	// READ-ONLY; The localized friendly form of the resource type related to this action/operation.
	Resource *string
}

// OperationListResult - Result of the request to list Customer Lockbox operations. It contains a list of operations.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string

	// READ-ONLY; List of Customer Lockbox operations supported by the Microsoft.StreamAnalytics resource provider.
	Value []*Operation
}

// RequestListResult - Object containing a list of streaming jobs.
type RequestListResult struct {
	// READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string

	// READ-ONLY; A list of Lockbox requests. Populated by a 'List' operation.
	Value []*LockboxRequestResponse
}

// TenantOptInResponse - TenantOptIn Response object
type TenantOptInResponse struct {
	// READ-ONLY; True if tenant is opted in, false otherwise
	IsOptedIn *bool
}
