//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/playwrighttesting/armplaywrighttesting"
	"net/http"
	"net/url"
	"regexp"
)

// QuotasServer is a fake server for instances of the armplaywrighttesting.QuotasClient type.
type QuotasServer struct {
	// Get is the fake for method QuotasClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, location string, name armplaywrighttesting.QuotaNames, options *armplaywrighttesting.QuotasClientGetOptions) (resp azfake.Responder[armplaywrighttesting.QuotasClientGetResponse], errResp azfake.ErrorResponder)

	// NewListBySubscriptionPager is the fake for method QuotasClient.NewListBySubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySubscriptionPager func(location string, options *armplaywrighttesting.QuotasClientListBySubscriptionOptions) (resp azfake.PagerResponder[armplaywrighttesting.QuotasClientListBySubscriptionResponse])
}

// NewQuotasServerTransport creates a new instance of QuotasServerTransport with the provided implementation.
// The returned QuotasServerTransport instance is connected to an instance of armplaywrighttesting.QuotasClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewQuotasServerTransport(srv *QuotasServer) *QuotasServerTransport {
	return &QuotasServerTransport{
		srv:                        srv,
		newListBySubscriptionPager: newTracker[azfake.PagerResponder[armplaywrighttesting.QuotasClientListBySubscriptionResponse]](),
	}
}

// QuotasServerTransport connects instances of armplaywrighttesting.QuotasClient to instances of QuotasServer.
// Don't use this type directly, use NewQuotasServerTransport instead.
type QuotasServerTransport struct {
	srv                        *QuotasServer
	newListBySubscriptionPager *tracker[azfake.PagerResponder[armplaywrighttesting.QuotasClientListBySubscriptionResponse]]
}

// Do implements the policy.Transporter interface for QuotasServerTransport.
func (q *QuotasServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "QuotasClient.Get":
		resp, err = q.dispatchGet(req)
	case "QuotasClient.NewListBySubscriptionPager":
		resp, err = q.dispatchNewListBySubscriptionPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (q *QuotasServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if q.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AzurePlaywrightService/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/quotas/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	nameParam, err := parseWithCast(matches[regex.SubexpIndex("name")], func(v string) (armplaywrighttesting.QuotaNames, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armplaywrighttesting.QuotaNames(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := q.srv.Get(req.Context(), locationParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Quota, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (q *QuotasServerTransport) dispatchNewListBySubscriptionPager(req *http.Request) (*http.Response, error) {
	if q.srv.NewListBySubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySubscriptionPager not implemented")}
	}
	newListBySubscriptionPager := q.newListBySubscriptionPager.get(req)
	if newListBySubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AzurePlaywrightService/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/quotas`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
		if err != nil {
			return nil, err
		}
		resp := q.srv.NewListBySubscriptionPager(locationParam, nil)
		newListBySubscriptionPager = &resp
		q.newListBySubscriptionPager.add(req, newListBySubscriptionPager)
		server.PagerResponderInjectNextLinks(newListBySubscriptionPager, req, func(page *armplaywrighttesting.QuotasClientListBySubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		q.newListBySubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySubscriptionPager) {
		q.newListBySubscriptionPager.remove(req)
	}
	return resp, nil
}
