// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v2/common/user_lists.proto

package common

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v2/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// SimilarUserList is a list of users which are similar to users from another
// UserList. These lists are read-only and automatically created by Google.
type SimilarUserListInfo struct {
	// Seed UserList from which this list is derived.
	SeedUserList         *wrappers.StringValue `protobuf:"bytes,1,opt,name=seed_user_list,json=seedUserList,proto3" json:"seed_user_list,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *SimilarUserListInfo) Reset()         { *m = SimilarUserListInfo{} }
func (m *SimilarUserListInfo) String() string { return proto.CompactTextString(m) }
func (*SimilarUserListInfo) ProtoMessage()    {}
func (*SimilarUserListInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_33d0509a07253d36, []int{0}
}

func (m *SimilarUserListInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SimilarUserListInfo.Unmarshal(m, b)
}
func (m *SimilarUserListInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SimilarUserListInfo.Marshal(b, m, deterministic)
}
func (m *SimilarUserListInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SimilarUserListInfo.Merge(m, src)
}
func (m *SimilarUserListInfo) XXX_Size() int {
	return xxx_messageInfo_SimilarUserListInfo.Size(m)
}
func (m *SimilarUserListInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_SimilarUserListInfo.DiscardUnknown(m)
}

var xxx_messageInfo_SimilarUserListInfo proto.InternalMessageInfo

func (m *SimilarUserListInfo) GetSeedUserList() *wrappers.StringValue {
	if m != nil {
		return m.SeedUserList
	}
	return nil
}

// UserList of CRM users provided by the advertiser.
type CrmBasedUserListInfo struct {
	// A string that uniquely identifies a mobile application from which the data
	// was collected to the Google Ads API.
	// For iOS, the ID string is the 9 digit string that appears at the end of an
	// App Store URL (e.g., "476943146" for "Flood-It! 2" whose App Store link is
	// http://itunes.apple.com/us/app/flood-it!-2/id476943146).
	// For Android, the ID string is the application's package name
	// (e.g., "com.labpixies.colordrips" for "Color Drips" given Google Play link
	// https://play.google.com/store/apps/details?id=com.labpixies.colordrips).
	// Required when creating CrmBasedUserList for uploading mobile advertising
	// IDs.
	AppId *wrappers.StringValue `protobuf:"bytes,1,opt,name=app_id,json=appId,proto3" json:"app_id,omitempty"`
	// Matching key type of the list.
	// Mixed data types are not allowed on the same list.
	// This field is required for an ADD operation.
	UploadKeyType enums.CustomerMatchUploadKeyTypeEnum_CustomerMatchUploadKeyType `protobuf:"varint,2,opt,name=upload_key_type,json=uploadKeyType,proto3,enum=google.ads.googleads.v2.enums.CustomerMatchUploadKeyTypeEnum_CustomerMatchUploadKeyType" json:"upload_key_type,omitempty"`
	// Data source of the list. Default value is FIRST_PARTY.
	// Only whitelisted customers can create third-party sourced CRM lists.
	DataSourceType       enums.UserListCrmDataSourceTypeEnum_UserListCrmDataSourceType `protobuf:"varint,3,opt,name=data_source_type,json=dataSourceType,proto3,enum=google.ads.googleads.v2.enums.UserListCrmDataSourceTypeEnum_UserListCrmDataSourceType" json:"data_source_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                                      `json:"-"`
	XXX_unrecognized     []byte                                                        `json:"-"`
	XXX_sizecache        int32                                                         `json:"-"`
}

func (m *CrmBasedUserListInfo) Reset()         { *m = CrmBasedUserListInfo{} }
func (m *CrmBasedUserListInfo) String() string { return proto.CompactTextString(m) }
func (*CrmBasedUserListInfo) ProtoMessage()    {}
func (*CrmBasedUserListInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_33d0509a07253d36, []int{1}
}

func (m *CrmBasedUserListInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CrmBasedUserListInfo.Unmarshal(m, b)
}
func (m *CrmBasedUserListInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CrmBasedUserListInfo.Marshal(b, m, deterministic)
}
func (m *CrmBasedUserListInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CrmBasedUserListInfo.Merge(m, src)
}
func (m *CrmBasedUserListInfo) XXX_Size() int {
	return xxx_messageInfo_CrmBasedUserListInfo.Size(m)
}
func (m *CrmBasedUserListInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_CrmBasedUserListInfo.DiscardUnknown(m)
}

var xxx_messageInfo_CrmBasedUserListInfo proto.InternalMessageInfo

func (m *CrmBasedUserListInfo) GetAppId() *wrappers.StringValue {
	if m != nil {
		return m.AppId
	}
	return nil
}

func (m *CrmBasedUserListInfo) GetUploadKeyType() enums.CustomerMatchUploadKeyTypeEnum_CustomerMatchUploadKeyType {
	if m != nil {
		return m.UploadKeyType
	}
	return enums.CustomerMatchUploadKeyTypeEnum_UNSPECIFIED
}

func (m *CrmBasedUserListInfo) GetDataSourceType() enums.UserListCrmDataSourceTypeEnum_UserListCrmDataSourceType {
	if m != nil {
		return m.DataSourceType
	}
	return enums.UserListCrmDataSourceTypeEnum_UNSPECIFIED
}

// A client defined rule based on custom parameters sent by web sites or
// uploaded by the advertiser.
type UserListRuleInfo struct {
	// Rule type is used to determine how to group rule items.
	//
	// The default is OR of ANDs (disjunctive normal form).
	// That is, rule items will be ANDed together within rule item groups and the
	// groups themselves will be ORed together.
	//
	// Currently AND of ORs (conjunctive normal form) is only supported for
	// ExpressionRuleUserList.
	RuleType enums.UserListRuleTypeEnum_UserListRuleType `protobuf:"varint,1,opt,name=rule_type,json=ruleType,proto3,enum=google.ads.googleads.v2.enums.UserListRuleTypeEnum_UserListRuleType" json:"rule_type,omitempty"`
	// List of rule item groups that defines this rule.
	// Rule item groups are grouped together based on rule_type.
	RuleItemGroups       []*UserListRuleItemGroupInfo `protobuf:"bytes,2,rep,name=rule_item_groups,json=ruleItemGroups,proto3" json:"rule_item_groups,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *UserListRuleInfo) Reset()         { *m = UserListRuleInfo{} }
func (m *UserListRuleInfo) String() string { return proto.CompactTextString(m) }
func (*UserListRuleInfo) ProtoMessage()    {}
func (*UserListRuleInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_33d0509a07253d36, []int{2}
}

func (m *UserListRuleInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserListRuleInfo.Unmarshal(m, b)
}
func (m *UserListRuleInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserListRuleInfo.Marshal(b, m, deterministic)
}
func (m *UserListRuleInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserListRuleInfo.Merge(m, src)
}
func (m *UserListRuleInfo) XXX_Size() int {
	return xxx_messageInfo_UserListRuleInfo.Size(m)
}
func (m *UserListRuleInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_UserListRuleInfo.DiscardUnknown(m)
}

var xxx_messageInfo_UserListRuleInfo proto.InternalMessageInfo

func (m *UserListRuleInfo) GetRuleType() enums.UserListRuleTypeEnum_UserListRuleType {
	if m != nil {
		return m.RuleType
	}
	return enums.UserListRuleTypeEnum_UNSPECIFIED
}

func (m *UserListRuleInfo) GetRuleItemGroups() []*UserListRuleItemGroupInfo {
	if m != nil {
		return m.RuleItemGroups
	}
	return nil
}

// A group of rule items.
type UserListRuleItemGroupInfo struct {
	// Rule items that will be grouped together based on rule_type.
	RuleItems            []*UserListRuleItemInfo `protobuf:"bytes,1,rep,name=rule_items,json=ruleItems,proto3" json:"rule_items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *UserListRuleItemGroupInfo) Reset()         { *m = UserListRuleItemGroupInfo{} }
func (m *UserListRuleItemGroupInfo) String() string { return proto.CompactTextString(m) }
func (*UserListRuleItemGroupInfo) ProtoMessage()    {}
func (*UserListRuleItemGroupInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_33d0509a07253d36, []int{3}
}

func (m *UserListRuleItemGroupInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserListRuleItemGroupInfo.Unmarshal(m, b)
}
func (m *UserListRuleItemGroupInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserListRuleItemGroupInfo.Marshal(b, m, deterministic)
}
func (m *UserListRuleItemGroupInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserListRuleItemGroupInfo.Merge(m, src)
}
func (m *UserListRuleItemGroupInfo) XXX_Size() int {
	return xxx_messageInfo_UserListRuleItemGroupInfo.Size(m)
}
func (m *UserListRuleItemGroupInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_UserListRuleItemGroupInfo.DiscardUnknown(m)
}

var xxx_messageInfo_UserListRuleItemGroupInfo proto.InternalMessageInfo

func (m *UserListRuleItemGroupInfo) GetRuleItems() []*UserListRuleItemInfo {
	if m != nil {
		return m.RuleItems
	}
	return nil
}

// An atomic rule item.
type UserListRuleItemInfo struct {
	// Rule variable name. It should match the corresponding key name fired
	// by the pixel.
	// A name must begin with US-ascii letters or underscore or UTF8 code that is
	// greater than 127 and consist of US-ascii letters or digits or underscore or
	// UTF8 code that is greater than 127.
	// For websites, there are two built-in variable URL (name = 'url__') and
	// referrer URL (name = 'ref_url__').
	// This field must be populated when creating a new rule item.
	Name *wrappers.StringValue `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// An atomic rule item.
	//
	// Types that are valid to be assigned to RuleItem:
	//	*UserListRuleItemInfo_NumberRuleItem
	//	*UserListRuleItemInfo_StringRuleItem
	//	*UserListRuleItemInfo_DateRuleItem
	RuleItem             isUserListRuleItemInfo_RuleItem `protobuf_oneof:"rule_item"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *UserListRuleItemInfo) Reset()         { *m = UserListRuleItemInfo{} }
func (m *UserListRuleItemInfo) String() string { return proto.CompactTextString(m) }
func (*UserListRuleItemInfo) ProtoMessage()    {}
func (*UserListRuleItemInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_33d0509a07253d36, []int{4}
}

func (m *UserListRuleItemInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserListRuleItemInfo.Unmarshal(m, b)
}
func (m *UserListRuleItemInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserListRuleItemInfo.Marshal(b, m, deterministic)
}
func (m *UserListRuleItemInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserListRuleItemInfo.Merge(m, src)
}
func (m *UserListRuleItemInfo) XXX_Size() int {
	return xxx_messageInfo_UserListRuleItemInfo.Size(m)
}
func (m *UserListRuleItemInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_UserListRuleItemInfo.DiscardUnknown(m)
}

var xxx_messageInfo_UserListRuleItemInfo proto.InternalMessageInfo

func (m *UserListRuleItemInfo) GetName() *wrappers.StringValue {
	if m != nil {
		return m.Name
	}
	return nil
}

type isUserListRuleItemInfo_RuleItem interface {
	isUserListRuleItemInfo_RuleItem()
}

type UserListRuleItemInfo_NumberRuleItem struct {
	NumberRuleItem *UserListNumberRuleItemInfo `protobuf:"bytes,2,opt,name=number_rule_item,json=numberRuleItem,proto3,oneof"`
}

type UserListRuleItemInfo_StringRuleItem struct {
	StringRuleItem *UserListStringRuleItemInfo `protobuf:"bytes,3,opt,name=string_rule_item,json=stringRuleItem,proto3,oneof"`
}

type UserListRuleItemInfo_DateRuleItem struct {
	DateRuleItem *UserListDateRuleItemInfo `protobuf:"bytes,4,opt,name=date_rule_item,json=dateRuleItem,proto3,oneof"`
}

func (*UserListRuleItemInfo_NumberRuleItem) isUserListRuleItemInfo_RuleItem() {}

func (*UserListRuleItemInfo_StringRuleItem) isUserListRuleItemInfo_RuleItem() {}

func (*UserListRuleItemInfo_DateRuleItem) isUserListRuleItemInfo_RuleItem() {}

func (m *UserListRuleItemInfo) GetRuleItem() isUserListRuleItemInfo_RuleItem {
	if m != nil {
		return m.RuleItem
	}
	return nil
}

func (m *UserListRuleItemInfo) GetNumberRuleItem() *UserListNumberRuleItemInfo {
	if x, ok := m.GetRuleItem().(*UserListRuleItemInfo_NumberRuleItem); ok {
		return x.NumberRuleItem
	}
	return nil
}

func (m *UserListRuleItemInfo) GetStringRuleItem() *UserListStringRuleItemInfo {
	if x, ok := m.GetRuleItem().(*UserListRuleItemInfo_StringRuleItem); ok {
		return x.StringRuleItem
	}
	return nil
}

func (m *UserListRuleItemInfo) GetDateRuleItem() *UserListDateRuleItemInfo {
	if x, ok := m.GetRuleItem().(*UserListRuleItemInfo_DateRuleItem); ok {
		return x.DateRuleItem
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*UserListRuleItemInfo) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*UserListRuleItemInfo_NumberRuleItem)(nil),
		(*UserListRuleItemInfo_StringRuleItem)(nil),
		(*UserListRuleItemInfo_DateRuleItem)(nil),
	}
}

// A rule item composed of a date operation.
type UserListDateRuleItemInfo struct {
	// Date comparison operator.
	// This field is required and must be populated when creating new date
	// rule item.
	Operator enums.UserListDateRuleItemOperatorEnum_UserListDateRuleItemOperator `protobuf:"varint,1,opt,name=operator,proto3,enum=google.ads.googleads.v2.enums.UserListDateRuleItemOperatorEnum_UserListDateRuleItemOperator" json:"operator,omitempty"`
	// String representing date value to be compared with the rule variable.
	// Supported date format is YYYY-MM-DD.
	// Times are reported in the customer's time zone.
	Value *wrappers.StringValue `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// The relative date value of the right hand side denoted by number of days
	// offset from now. The value field will override this field when both are
	// present.
	OffsetInDays         *wrappers.Int64Value `protobuf:"bytes,3,opt,name=offset_in_days,json=offsetInDays,proto3" json:"offset_in_days,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *UserListDateRuleItemInfo) Reset()         { *m = UserListDateRuleItemInfo{} }
func (m *UserListDateRuleItemInfo) String() string { return proto.CompactTextString(m) }
func (*UserListDateRuleItemInfo) ProtoMessage()    {}
func (*UserListDateRuleItemInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_33d0509a07253d36, []int{5}
}

func (m *UserListDateRuleItemInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserListDateRuleItemInfo.Unmarshal(m, b)
}
func (m *UserListDateRuleItemInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserListDateRuleItemInfo.Marshal(b, m, deterministic)
}
func (m *UserListDateRuleItemInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserListDateRuleItemInfo.Merge(m, src)
}
func (m *UserListDateRuleItemInfo) XXX_Size() int {
	return xxx_messageInfo_UserListDateRuleItemInfo.Size(m)
}
func (m *UserListDateRuleItemInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_UserListDateRuleItemInfo.DiscardUnknown(m)
}

var xxx_messageInfo_UserListDateRuleItemInfo proto.InternalMessageInfo

func (m *UserListDateRuleItemInfo) GetOperator() enums.UserListDateRuleItemOperatorEnum_UserListDateRuleItemOperator {
	if m != nil {
		return m.Operator
	}
	return enums.UserListDateRuleItemOperatorEnum_UNSPECIFIED
}

func (m *UserListDateRuleItemInfo) GetValue() *wrappers.StringValue {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *UserListDateRuleItemInfo) GetOffsetInDays() *wrappers.Int64Value {
	if m != nil {
		return m.OffsetInDays
	}
	return nil
}

// A rule item composed of a number operation.
type UserListNumberRuleItemInfo struct {
	// Number comparison operator.
	// This field is required and must be populated when creating a new number
	// rule item.
	Operator enums.UserListNumberRuleItemOperatorEnum_UserListNumberRuleItemOperator `protobuf:"varint,1,opt,name=operator,proto3,enum=google.ads.googleads.v2.enums.UserListNumberRuleItemOperatorEnum_UserListNumberRuleItemOperator" json:"operator,omitempty"`
	// Number value to be compared with the variable.
	// This field is required and must be populated when creating a new number
	// rule item.
	Value                *wrappers.DoubleValue `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UserListNumberRuleItemInfo) Reset()         { *m = UserListNumberRuleItemInfo{} }
func (m *UserListNumberRuleItemInfo) String() string { return proto.CompactTextString(m) }
func (*UserListNumberRuleItemInfo) ProtoMessage()    {}
func (*UserListNumberRuleItemInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_33d0509a07253d36, []int{6}
}

func (m *UserListNumberRuleItemInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserListNumberRuleItemInfo.Unmarshal(m, b)
}
func (m *UserListNumberRuleItemInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserListNumberRuleItemInfo.Marshal(b, m, deterministic)
}
func (m *UserListNumberRuleItemInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserListNumberRuleItemInfo.Merge(m, src)
}
func (m *UserListNumberRuleItemInfo) XXX_Size() int {
	return xxx_messageInfo_UserListNumberRuleItemInfo.Size(m)
}
func (m *UserListNumberRuleItemInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_UserListNumberRuleItemInfo.DiscardUnknown(m)
}

var xxx_messageInfo_UserListNumberRuleItemInfo proto.InternalMessageInfo

func (m *UserListNumberRuleItemInfo) GetOperator() enums.UserListNumberRuleItemOperatorEnum_UserListNumberRuleItemOperator {
	if m != nil {
		return m.Operator
	}
	return enums.UserListNumberRuleItemOperatorEnum_UNSPECIFIED
}

func (m *UserListNumberRuleItemInfo) GetValue() *wrappers.DoubleValue {
	if m != nil {
		return m.Value
	}
	return nil
}

// A rule item composed of a string operation.
type UserListStringRuleItemInfo struct {
	// String comparison operator.
	// This field is required and must be populated when creating a new string
	// rule item.
	Operator enums.UserListStringRuleItemOperatorEnum_UserListStringRuleItemOperator `protobuf:"varint,1,opt,name=operator,proto3,enum=google.ads.googleads.v2.enums.UserListStringRuleItemOperatorEnum_UserListStringRuleItemOperator" json:"operator,omitempty"`
	// The right hand side of the string rule item. For URLs or referrer URLs,
	// the value can not contain illegal URL chars such as newlines, quotes,
	// tabs, or parentheses. This field is required and must be populated when
	// creating a new string rule item.
	Value                *wrappers.StringValue `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UserListStringRuleItemInfo) Reset()         { *m = UserListStringRuleItemInfo{} }
func (m *UserListStringRuleItemInfo) String() string { return proto.CompactTextString(m) }
func (*UserListStringRuleItemInfo) ProtoMessage()    {}
func (*UserListStringRuleItemInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_33d0509a07253d36, []int{7}
}

func (m *UserListStringRuleItemInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserListStringRuleItemInfo.Unmarshal(m, b)
}
func (m *UserListStringRuleItemInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserListStringRuleItemInfo.Marshal(b, m, deterministic)
}
func (m *UserListStringRuleItemInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserListStringRuleItemInfo.Merge(m, src)
}
func (m *UserListStringRuleItemInfo) XXX_Size() int {
	return xxx_messageInfo_UserListStringRuleItemInfo.Size(m)
}
func (m *UserListStringRuleItemInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_UserListStringRuleItemInfo.DiscardUnknown(m)
}

var xxx_messageInfo_UserListStringRuleItemInfo proto.InternalMessageInfo

func (m *UserListStringRuleItemInfo) GetOperator() enums.UserListStringRuleItemOperatorEnum_UserListStringRuleItemOperator {
	if m != nil {
		return m.Operator
	}
	return enums.UserListStringRuleItemOperatorEnum_UNSPECIFIED
}

func (m *UserListStringRuleItemInfo) GetValue() *wrappers.StringValue {
	if m != nil {
		return m.Value
	}
	return nil
}

// User lists defined by combining two rules, left operand and right operand.
// There are two operators: AND where left operand and right operand have to be
// true; AND_NOT where left operand is true but right operand is false.
type CombinedRuleUserListInfo struct {
	// Left operand of the combined rule.
	// This field is required and must be populated when creating new combined
	// rule based user list.
	LeftOperand *UserListRuleInfo `protobuf:"bytes,1,opt,name=left_operand,json=leftOperand,proto3" json:"left_operand,omitempty"`
	// Right operand of the combined rule.
	// This field is required and must be populated when creating new combined
	// rule based user list.
	RightOperand *UserListRuleInfo `protobuf:"bytes,2,opt,name=right_operand,json=rightOperand,proto3" json:"right_operand,omitempty"`
	// Operator to connect the two operands.
	//
	// Required for creating a combined rule user list.
	RuleOperator         enums.UserListCombinedRuleOperatorEnum_UserListCombinedRuleOperator `protobuf:"varint,3,opt,name=rule_operator,json=ruleOperator,proto3,enum=google.ads.googleads.v2.enums.UserListCombinedRuleOperatorEnum_UserListCombinedRuleOperator" json:"rule_operator,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                                            `json:"-"`
	XXX_unrecognized     []byte                                                              `json:"-"`
	XXX_sizecache        int32                                                               `json:"-"`
}

func (m *CombinedRuleUserListInfo) Reset()         { *m = CombinedRuleUserListInfo{} }
func (m *CombinedRuleUserListInfo) String() string { return proto.CompactTextString(m) }
func (*CombinedRuleUserListInfo) ProtoMessage()    {}
func (*CombinedRuleUserListInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_33d0509a07253d36, []int{8}
}

func (m *CombinedRuleUserListInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CombinedRuleUserListInfo.Unmarshal(m, b)
}
func (m *CombinedRuleUserListInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CombinedRuleUserListInfo.Marshal(b, m, deterministic)
}
func (m *CombinedRuleUserListInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CombinedRuleUserListInfo.Merge(m, src)
}
func (m *CombinedRuleUserListInfo) XXX_Size() int {
	return xxx_messageInfo_CombinedRuleUserListInfo.Size(m)
}
func (m *CombinedRuleUserListInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_CombinedRuleUserListInfo.DiscardUnknown(m)
}

var xxx_messageInfo_CombinedRuleUserListInfo proto.InternalMessageInfo

func (m *CombinedRuleUserListInfo) GetLeftOperand() *UserListRuleInfo {
	if m != nil {
		return m.LeftOperand
	}
	return nil
}

func (m *CombinedRuleUserListInfo) GetRightOperand() *UserListRuleInfo {
	if m != nil {
		return m.RightOperand
	}
	return nil
}

func (m *CombinedRuleUserListInfo) GetRuleOperator() enums.UserListCombinedRuleOperatorEnum_UserListCombinedRuleOperator {
	if m != nil {
		return m.RuleOperator
	}
	return enums.UserListCombinedRuleOperatorEnum_UNSPECIFIED
}

// Visitors of a page during specific dates.
type DateSpecificRuleUserListInfo struct {
	// Boolean rule that defines visitor of a page.
	//
	// Required for creating a date specific rule user list.
	Rule *UserListRuleInfo `protobuf:"bytes,1,opt,name=rule,proto3" json:"rule,omitempty"`
	// Start date of users visit. If set to 2000-01-01, then the list includes all
	// users before end_date. The date's format should be YYYY-MM-DD.
	//
	// Required for creating a data specific rule user list.
	StartDate *wrappers.StringValue `protobuf:"bytes,2,opt,name=start_date,json=startDate,proto3" json:"start_date,omitempty"`
	// End date of users visit. If set to 2037-12-30, then the list includes all
	// users after start_date. The date's format should be YYYY-MM-DD.
	//
	// Required for creating a data specific rule user list.
	EndDate              *wrappers.StringValue `protobuf:"bytes,3,opt,name=end_date,json=endDate,proto3" json:"end_date,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *DateSpecificRuleUserListInfo) Reset()         { *m = DateSpecificRuleUserListInfo{} }
func (m *DateSpecificRuleUserListInfo) String() string { return proto.CompactTextString(m) }
func (*DateSpecificRuleUserListInfo) ProtoMessage()    {}
func (*DateSpecificRuleUserListInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_33d0509a07253d36, []int{9}
}

func (m *DateSpecificRuleUserListInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DateSpecificRuleUserListInfo.Unmarshal(m, b)
}
func (m *DateSpecificRuleUserListInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DateSpecificRuleUserListInfo.Marshal(b, m, deterministic)
}
func (m *DateSpecificRuleUserListInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DateSpecificRuleUserListInfo.Merge(m, src)
}
func (m *DateSpecificRuleUserListInfo) XXX_Size() int {
	return xxx_messageInfo_DateSpecificRuleUserListInfo.Size(m)
}
func (m *DateSpecificRuleUserListInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_DateSpecificRuleUserListInfo.DiscardUnknown(m)
}

var xxx_messageInfo_DateSpecificRuleUserListInfo proto.InternalMessageInfo

func (m *DateSpecificRuleUserListInfo) GetRule() *UserListRuleInfo {
	if m != nil {
		return m.Rule
	}
	return nil
}

func (m *DateSpecificRuleUserListInfo) GetStartDate() *wrappers.StringValue {
	if m != nil {
		return m.StartDate
	}
	return nil
}

func (m *DateSpecificRuleUserListInfo) GetEndDate() *wrappers.StringValue {
	if m != nil {
		return m.EndDate
	}
	return nil
}

// Visitors of a page. The page visit is defined by one boolean rule expression.
type ExpressionRuleUserListInfo struct {
	// Boolean rule that defines this user list. The rule consists of a list of
	// rule item groups and each rule item group consists of a list of rule items.
	// All the rule item groups are ORed or ANDed together for evaluation based on
	// rule.rule_type.
	//
	// Required for creating an expression rule user list.
	Rule                 *UserListRuleInfo `protobuf:"bytes,1,opt,name=rule,proto3" json:"rule,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ExpressionRuleUserListInfo) Reset()         { *m = ExpressionRuleUserListInfo{} }
func (m *ExpressionRuleUserListInfo) String() string { return proto.CompactTextString(m) }
func (*ExpressionRuleUserListInfo) ProtoMessage()    {}
func (*ExpressionRuleUserListInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_33d0509a07253d36, []int{10}
}

func (m *ExpressionRuleUserListInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExpressionRuleUserListInfo.Unmarshal(m, b)
}
func (m *ExpressionRuleUserListInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExpressionRuleUserListInfo.Marshal(b, m, deterministic)
}
func (m *ExpressionRuleUserListInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExpressionRuleUserListInfo.Merge(m, src)
}
func (m *ExpressionRuleUserListInfo) XXX_Size() int {
	return xxx_messageInfo_ExpressionRuleUserListInfo.Size(m)
}
func (m *ExpressionRuleUserListInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ExpressionRuleUserListInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ExpressionRuleUserListInfo proto.InternalMessageInfo

func (m *ExpressionRuleUserListInfo) GetRule() *UserListRuleInfo {
	if m != nil {
		return m.Rule
	}
	return nil
}

// Representation of a userlist that is generated by a rule.
type RuleBasedUserListInfo struct {
	// The status of pre-population. The field is default to NONE if not set which
	// means the previous users will not be considered. If set to REQUESTED, past
	// site visitors or app users who match the list definition will be included
	// in the list (works on the Display Network only). This will only
	// add past users from within the last 30 days, depending on the
	// list's membership duration and the date when the remarketing tag is added.
	// The status will be updated to FINISHED once request is processed, or FAILED
	// if the request fails.
	PrepopulationStatus enums.UserListPrepopulationStatusEnum_UserListPrepopulationStatus `protobuf:"varint,1,opt,name=prepopulation_status,json=prepopulationStatus,proto3,enum=google.ads.googleads.v2.enums.UserListPrepopulationStatusEnum_UserListPrepopulationStatus" json:"prepopulation_status,omitempty"`
	// Subtypes of rule based user lists.
	//
	// Types that are valid to be assigned to RuleBasedUserList:
	//	*RuleBasedUserListInfo_CombinedRuleUserList
	//	*RuleBasedUserListInfo_DateSpecificRuleUserList
	//	*RuleBasedUserListInfo_ExpressionRuleUserList
	RuleBasedUserList    isRuleBasedUserListInfo_RuleBasedUserList `protobuf_oneof:"rule_based_user_list"`
	XXX_NoUnkeyedLiteral struct{}                                  `json:"-"`
	XXX_unrecognized     []byte                                    `json:"-"`
	XXX_sizecache        int32                                     `json:"-"`
}

func (m *RuleBasedUserListInfo) Reset()         { *m = RuleBasedUserListInfo{} }
func (m *RuleBasedUserListInfo) String() string { return proto.CompactTextString(m) }
func (*RuleBasedUserListInfo) ProtoMessage()    {}
func (*RuleBasedUserListInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_33d0509a07253d36, []int{11}
}

func (m *RuleBasedUserListInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RuleBasedUserListInfo.Unmarshal(m, b)
}
func (m *RuleBasedUserListInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RuleBasedUserListInfo.Marshal(b, m, deterministic)
}
func (m *RuleBasedUserListInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RuleBasedUserListInfo.Merge(m, src)
}
func (m *RuleBasedUserListInfo) XXX_Size() int {
	return xxx_messageInfo_RuleBasedUserListInfo.Size(m)
}
func (m *RuleBasedUserListInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_RuleBasedUserListInfo.DiscardUnknown(m)
}

var xxx_messageInfo_RuleBasedUserListInfo proto.InternalMessageInfo

func (m *RuleBasedUserListInfo) GetPrepopulationStatus() enums.UserListPrepopulationStatusEnum_UserListPrepopulationStatus {
	if m != nil {
		return m.PrepopulationStatus
	}
	return enums.UserListPrepopulationStatusEnum_UNSPECIFIED
}

type isRuleBasedUserListInfo_RuleBasedUserList interface {
	isRuleBasedUserListInfo_RuleBasedUserList()
}

type RuleBasedUserListInfo_CombinedRuleUserList struct {
	CombinedRuleUserList *CombinedRuleUserListInfo `protobuf:"bytes,2,opt,name=combined_rule_user_list,json=combinedRuleUserList,proto3,oneof"`
}

type RuleBasedUserListInfo_DateSpecificRuleUserList struct {
	DateSpecificRuleUserList *DateSpecificRuleUserListInfo `protobuf:"bytes,3,opt,name=date_specific_rule_user_list,json=dateSpecificRuleUserList,proto3,oneof"`
}

type RuleBasedUserListInfo_ExpressionRuleUserList struct {
	ExpressionRuleUserList *ExpressionRuleUserListInfo `protobuf:"bytes,4,opt,name=expression_rule_user_list,json=expressionRuleUserList,proto3,oneof"`
}

func (*RuleBasedUserListInfo_CombinedRuleUserList) isRuleBasedUserListInfo_RuleBasedUserList() {}

func (*RuleBasedUserListInfo_DateSpecificRuleUserList) isRuleBasedUserListInfo_RuleBasedUserList() {}

func (*RuleBasedUserListInfo_ExpressionRuleUserList) isRuleBasedUserListInfo_RuleBasedUserList() {}

func (m *RuleBasedUserListInfo) GetRuleBasedUserList() isRuleBasedUserListInfo_RuleBasedUserList {
	if m != nil {
		return m.RuleBasedUserList
	}
	return nil
}

func (m *RuleBasedUserListInfo) GetCombinedRuleUserList() *CombinedRuleUserListInfo {
	if x, ok := m.GetRuleBasedUserList().(*RuleBasedUserListInfo_CombinedRuleUserList); ok {
		return x.CombinedRuleUserList
	}
	return nil
}

func (m *RuleBasedUserListInfo) GetDateSpecificRuleUserList() *DateSpecificRuleUserListInfo {
	if x, ok := m.GetRuleBasedUserList().(*RuleBasedUserListInfo_DateSpecificRuleUserList); ok {
		return x.DateSpecificRuleUserList
	}
	return nil
}

func (m *RuleBasedUserListInfo) GetExpressionRuleUserList() *ExpressionRuleUserListInfo {
	if x, ok := m.GetRuleBasedUserList().(*RuleBasedUserListInfo_ExpressionRuleUserList); ok {
		return x.ExpressionRuleUserList
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*RuleBasedUserListInfo) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*RuleBasedUserListInfo_CombinedRuleUserList)(nil),
		(*RuleBasedUserListInfo_DateSpecificRuleUserList)(nil),
		(*RuleBasedUserListInfo_ExpressionRuleUserList)(nil),
	}
}

// Represents a user list that is a custom combination of user lists.
type LogicalUserListInfo struct {
	// Logical list rules that define this user list. The rules are defined as a
	// logical operator (ALL/ANY/NONE) and a list of user lists. All the rules are
	// ANDed when they are evaluated.
	//
	// Required for creating a logical user list.
	Rules                []*UserListLogicalRuleInfo `protobuf:"bytes,1,rep,name=rules,proto3" json:"rules,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *LogicalUserListInfo) Reset()         { *m = LogicalUserListInfo{} }
func (m *LogicalUserListInfo) String() string { return proto.CompactTextString(m) }
func (*LogicalUserListInfo) ProtoMessage()    {}
func (*LogicalUserListInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_33d0509a07253d36, []int{12}
}

func (m *LogicalUserListInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LogicalUserListInfo.Unmarshal(m, b)
}
func (m *LogicalUserListInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LogicalUserListInfo.Marshal(b, m, deterministic)
}
func (m *LogicalUserListInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogicalUserListInfo.Merge(m, src)
}
func (m *LogicalUserListInfo) XXX_Size() int {
	return xxx_messageInfo_LogicalUserListInfo.Size(m)
}
func (m *LogicalUserListInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_LogicalUserListInfo.DiscardUnknown(m)
}

var xxx_messageInfo_LogicalUserListInfo proto.InternalMessageInfo

func (m *LogicalUserListInfo) GetRules() []*UserListLogicalRuleInfo {
	if m != nil {
		return m.Rules
	}
	return nil
}

// A user list logical rule. A rule has a logical operator (and/or/not) and a
// list of user lists as operands.
type UserListLogicalRuleInfo struct {
	// The logical operator of the rule.
	Operator enums.UserListLogicalRuleOperatorEnum_UserListLogicalRuleOperator `protobuf:"varint,1,opt,name=operator,proto3,enum=google.ads.googleads.v2.enums.UserListLogicalRuleOperatorEnum_UserListLogicalRuleOperator" json:"operator,omitempty"`
	// The list of operands of the rule.
	RuleOperands         []*LogicalUserListOperandInfo `protobuf:"bytes,2,rep,name=rule_operands,json=ruleOperands,proto3" json:"rule_operands,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *UserListLogicalRuleInfo) Reset()         { *m = UserListLogicalRuleInfo{} }
func (m *UserListLogicalRuleInfo) String() string { return proto.CompactTextString(m) }
func (*UserListLogicalRuleInfo) ProtoMessage()    {}
func (*UserListLogicalRuleInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_33d0509a07253d36, []int{13}
}

func (m *UserListLogicalRuleInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserListLogicalRuleInfo.Unmarshal(m, b)
}
func (m *UserListLogicalRuleInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserListLogicalRuleInfo.Marshal(b, m, deterministic)
}
func (m *UserListLogicalRuleInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserListLogicalRuleInfo.Merge(m, src)
}
func (m *UserListLogicalRuleInfo) XXX_Size() int {
	return xxx_messageInfo_UserListLogicalRuleInfo.Size(m)
}
func (m *UserListLogicalRuleInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_UserListLogicalRuleInfo.DiscardUnknown(m)
}

var xxx_messageInfo_UserListLogicalRuleInfo proto.InternalMessageInfo

func (m *UserListLogicalRuleInfo) GetOperator() enums.UserListLogicalRuleOperatorEnum_UserListLogicalRuleOperator {
	if m != nil {
		return m.Operator
	}
	return enums.UserListLogicalRuleOperatorEnum_UNSPECIFIED
}

func (m *UserListLogicalRuleInfo) GetRuleOperands() []*LogicalUserListOperandInfo {
	if m != nil {
		return m.RuleOperands
	}
	return nil
}

// Operand of logical user list that consists of a user list.
type LogicalUserListOperandInfo struct {
	// Resource name of a user list as an operand.
	UserList             *wrappers.StringValue `protobuf:"bytes,1,opt,name=user_list,json=userList,proto3" json:"user_list,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *LogicalUserListOperandInfo) Reset()         { *m = LogicalUserListOperandInfo{} }
func (m *LogicalUserListOperandInfo) String() string { return proto.CompactTextString(m) }
func (*LogicalUserListOperandInfo) ProtoMessage()    {}
func (*LogicalUserListOperandInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_33d0509a07253d36, []int{14}
}

func (m *LogicalUserListOperandInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LogicalUserListOperandInfo.Unmarshal(m, b)
}
func (m *LogicalUserListOperandInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LogicalUserListOperandInfo.Marshal(b, m, deterministic)
}
func (m *LogicalUserListOperandInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogicalUserListOperandInfo.Merge(m, src)
}
func (m *LogicalUserListOperandInfo) XXX_Size() int {
	return xxx_messageInfo_LogicalUserListOperandInfo.Size(m)
}
func (m *LogicalUserListOperandInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_LogicalUserListOperandInfo.DiscardUnknown(m)
}

var xxx_messageInfo_LogicalUserListOperandInfo proto.InternalMessageInfo

func (m *LogicalUserListOperandInfo) GetUserList() *wrappers.StringValue {
	if m != nil {
		return m.UserList
	}
	return nil
}

// User list targeting as a collection of conversions or remarketing actions.
type BasicUserListInfo struct {
	// Actions associated with this user list.
	Actions              []*UserListActionInfo `protobuf:"bytes,1,rep,name=actions,proto3" json:"actions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *BasicUserListInfo) Reset()         { *m = BasicUserListInfo{} }
func (m *BasicUserListInfo) String() string { return proto.CompactTextString(m) }
func (*BasicUserListInfo) ProtoMessage()    {}
func (*BasicUserListInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_33d0509a07253d36, []int{15}
}

func (m *BasicUserListInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BasicUserListInfo.Unmarshal(m, b)
}
func (m *BasicUserListInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BasicUserListInfo.Marshal(b, m, deterministic)
}
func (m *BasicUserListInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BasicUserListInfo.Merge(m, src)
}
func (m *BasicUserListInfo) XXX_Size() int {
	return xxx_messageInfo_BasicUserListInfo.Size(m)
}
func (m *BasicUserListInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_BasicUserListInfo.DiscardUnknown(m)
}

var xxx_messageInfo_BasicUserListInfo proto.InternalMessageInfo

func (m *BasicUserListInfo) GetActions() []*UserListActionInfo {
	if m != nil {
		return m.Actions
	}
	return nil
}

// Represents an action type used for building remarketing user lists.
type UserListActionInfo struct {
	// Subtypes of user list action.
	//
	// Types that are valid to be assigned to UserListAction:
	//	*UserListActionInfo_ConversionAction
	//	*UserListActionInfo_RemarketingAction
	UserListAction       isUserListActionInfo_UserListAction `protobuf_oneof:"user_list_action"`
	XXX_NoUnkeyedLiteral struct{}                            `json:"-"`
	XXX_unrecognized     []byte                              `json:"-"`
	XXX_sizecache        int32                               `json:"-"`
}

func (m *UserListActionInfo) Reset()         { *m = UserListActionInfo{} }
func (m *UserListActionInfo) String() string { return proto.CompactTextString(m) }
func (*UserListActionInfo) ProtoMessage()    {}
func (*UserListActionInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_33d0509a07253d36, []int{16}
}

func (m *UserListActionInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserListActionInfo.Unmarshal(m, b)
}
func (m *UserListActionInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserListActionInfo.Marshal(b, m, deterministic)
}
func (m *UserListActionInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserListActionInfo.Merge(m, src)
}
func (m *UserListActionInfo) XXX_Size() int {
	return xxx_messageInfo_UserListActionInfo.Size(m)
}
func (m *UserListActionInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_UserListActionInfo.DiscardUnknown(m)
}

var xxx_messageInfo_UserListActionInfo proto.InternalMessageInfo

type isUserListActionInfo_UserListAction interface {
	isUserListActionInfo_UserListAction()
}

type UserListActionInfo_ConversionAction struct {
	ConversionAction *wrappers.StringValue `protobuf:"bytes,1,opt,name=conversion_action,json=conversionAction,proto3,oneof"`
}

type UserListActionInfo_RemarketingAction struct {
	RemarketingAction *wrappers.StringValue `protobuf:"bytes,2,opt,name=remarketing_action,json=remarketingAction,proto3,oneof"`
}

func (*UserListActionInfo_ConversionAction) isUserListActionInfo_UserListAction() {}

func (*UserListActionInfo_RemarketingAction) isUserListActionInfo_UserListAction() {}

func (m *UserListActionInfo) GetUserListAction() isUserListActionInfo_UserListAction {
	if m != nil {
		return m.UserListAction
	}
	return nil
}

func (m *UserListActionInfo) GetConversionAction() *wrappers.StringValue {
	if x, ok := m.GetUserListAction().(*UserListActionInfo_ConversionAction); ok {
		return x.ConversionAction
	}
	return nil
}

func (m *UserListActionInfo) GetRemarketingAction() *wrappers.StringValue {
	if x, ok := m.GetUserListAction().(*UserListActionInfo_RemarketingAction); ok {
		return x.RemarketingAction
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*UserListActionInfo) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*UserListActionInfo_ConversionAction)(nil),
		(*UserListActionInfo_RemarketingAction)(nil),
	}
}

func init() {
	proto.RegisterType((*SimilarUserListInfo)(nil), "google.ads.googleads.v2.common.SimilarUserListInfo")
	proto.RegisterType((*CrmBasedUserListInfo)(nil), "google.ads.googleads.v2.common.CrmBasedUserListInfo")
	proto.RegisterType((*UserListRuleInfo)(nil), "google.ads.googleads.v2.common.UserListRuleInfo")
	proto.RegisterType((*UserListRuleItemGroupInfo)(nil), "google.ads.googleads.v2.common.UserListRuleItemGroupInfo")
	proto.RegisterType((*UserListRuleItemInfo)(nil), "google.ads.googleads.v2.common.UserListRuleItemInfo")
	proto.RegisterType((*UserListDateRuleItemInfo)(nil), "google.ads.googleads.v2.common.UserListDateRuleItemInfo")
	proto.RegisterType((*UserListNumberRuleItemInfo)(nil), "google.ads.googleads.v2.common.UserListNumberRuleItemInfo")
	proto.RegisterType((*UserListStringRuleItemInfo)(nil), "google.ads.googleads.v2.common.UserListStringRuleItemInfo")
	proto.RegisterType((*CombinedRuleUserListInfo)(nil), "google.ads.googleads.v2.common.CombinedRuleUserListInfo")
	proto.RegisterType((*DateSpecificRuleUserListInfo)(nil), "google.ads.googleads.v2.common.DateSpecificRuleUserListInfo")
	proto.RegisterType((*ExpressionRuleUserListInfo)(nil), "google.ads.googleads.v2.common.ExpressionRuleUserListInfo")
	proto.RegisterType((*RuleBasedUserListInfo)(nil), "google.ads.googleads.v2.common.RuleBasedUserListInfo")
	proto.RegisterType((*LogicalUserListInfo)(nil), "google.ads.googleads.v2.common.LogicalUserListInfo")
	proto.RegisterType((*UserListLogicalRuleInfo)(nil), "google.ads.googleads.v2.common.UserListLogicalRuleInfo")
	proto.RegisterType((*LogicalUserListOperandInfo)(nil), "google.ads.googleads.v2.common.LogicalUserListOperandInfo")
	proto.RegisterType((*BasicUserListInfo)(nil), "google.ads.googleads.v2.common.BasicUserListInfo")
	proto.RegisterType((*UserListActionInfo)(nil), "google.ads.googleads.v2.common.UserListActionInfo")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v2/common/user_lists.proto", fileDescriptor_33d0509a07253d36)
}

var fileDescriptor_33d0509a07253d36 = []byte{
	// 1304 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x58, 0x41, 0x6f, 0xdb, 0xb6,
	0x17, 0x8f, 0x9c, 0xb4, 0x4d, 0x98, 0xd4, 0xff, 0x94, 0xcd, 0xbf, 0x75, 0xb3, 0xa0, 0x28, 0x74,
	0xea, 0x49, 0x2e, 0xd4, 0x62, 0x5d, 0xdd, 0x5d, 0xec, 0xb8, 0x48, 0x82, 0xb6, 0x6b, 0x21, 0x2f,
	0xd9, 0x56, 0x04, 0x50, 0x69, 0x89, 0x76, 0x85, 0x4a, 0xa4, 0x46, 0x4a, 0x69, 0x0d, 0x0c, 0xc3,
	0x76, 0xda, 0x61, 0xd8, 0x97, 0xd8, 0x71, 0xfb, 0x1a, 0x3b, 0xf5, 0x30, 0x60, 0xd7, 0x7d, 0x83,
	0xed, 0xb8, 0x4f, 0x30, 0x90, 0xa2, 0x6c, 0xc9, 0x96, 0x12, 0xa6, 0xc5, 0x4e, 0xa6, 0xc8, 0xf7,
	0x7e, 0xef, 0xc7, 0xc7, 0x1f, 0x1f, 0x49, 0x83, 0xf6, 0x98, 0xd2, 0x71, 0x88, 0xdb, 0xc8, 0xe7,
	0xaa, 0x29, 0x5a, 0x27, 0x76, 0xdb, 0xa3, 0x51, 0x44, 0x49, 0x3b, 0xe5, 0x98, 0xb9, 0x61, 0xc0,
	0x13, 0x6e, 0xc5, 0x8c, 0x26, 0x14, 0xde, 0xcc, 0xac, 0x2c, 0xe4, 0x73, 0x6b, 0xea, 0x60, 0x9d,
	0xd8, 0x56, 0xe6, 0xb0, 0xdd, 0xab, 0x03, 0xc4, 0x24, 0x8d, 0x78, 0xdb, 0x4b, 0x79, 0x42, 0x23,
	0xcc, 0xdc, 0x08, 0x25, 0xde, 0x2b, 0x37, 0x8d, 0x43, 0x8a, 0x7c, 0xf7, 0x35, 0x9e, 0xb8, 0xc9,
	0x24, 0xc6, 0x59, 0x8c, 0xed, 0xfe, 0xe9, 0x18, 0x53, 0x4e, 0xae, 0x47, 0xa3, 0x61, 0x40, 0xb0,
	0xef, 0xb2, 0x34, 0xc4, 0x2e, 0x8d, 0x31, 0x43, 0x09, 0x65, 0x0a, 0xa5, 0xa7, 0x8d, 0xc2, 0x22,
	0xd7, 0x47, 0x09, 0x72, 0x39, 0x4d, 0x99, 0x87, 0x8b, 0x4c, 0x1e, 0xe9, 0x62, 0xf8, 0x28, 0xc1,
	0x19, 0x8b, 0x20, 0xc1, 0xd1, 0x3c, 0x95, 0x5d, 0x5d, 0x98, 0x90, 0x8e, 0x03, 0x0f, 0x85, 0x95,
	0xf3, 0xd9, 0xd3, 0x05, 0x21, 0x69, 0x34, 0xc4, 0xac, 0x9e, 0x8d, 0x76, 0x62, 0x62, 0x86, 0x63,
	0x1a, 0xa7, 0x21, 0x4a, 0x02, 0x4a, 0x5c, 0x9e, 0xa0, 0x24, 0x55, 0x32, 0xd8, 0xbe, 0xaf, 0x8b,
	0x21, 0x59, 0x14, 0x32, 0xaa, 0x3d, 0x0b, 0x9e, 0xb0, 0x80, 0x8c, 0xeb, 0x67, 0xa1, 0x84, 0xd8,
	0x96, 0x5f, 0xc3, 0x74, 0xd4, 0x7e, 0xc3, 0x50, 0x1c, 0x63, 0x96, 0x33, 0xdc, 0xc9, 0x03, 0xc5,
	0x41, 0x1b, 0x11, 0x42, 0x13, 0x39, 0x0b, 0x35, 0x6a, 0x7e, 0x05, 0xae, 0x0e, 0x82, 0x28, 0x08,
	0x11, 0x3b, 0xe4, 0x98, 0x3d, 0x09, 0x78, 0x72, 0x40, 0x46, 0x14, 0xf6, 0x40, 0x93, 0x63, 0xec,
	0xbb, 0x53, 0x1a, 0x2d, 0xe3, 0x96, 0x71, 0x7b, 0xdd, 0xde, 0x51, 0x5a, 0xb7, 0xf2, 0x68, 0xd6,
	0x40, 0xd2, 0x3b, 0x42, 0x61, 0x8a, 0x9d, 0x0d, 0xe1, 0x93, 0xe3, 0x98, 0x7f, 0x34, 0xc0, 0xd6,
	0x2e, 0x8b, 0x7a, 0x88, 0xcf, 0x3a, 0x25, 0xf8, 0x5d, 0x70, 0x11, 0xc5, 0xb1, 0x1b, 0xf8, 0x5a,
	0xa0, 0x17, 0x50, 0x1c, 0x1f, 0xf8, 0xf0, 0x3b, 0x03, 0xfc, 0x6f, 0x6e, 0x97, 0xb4, 0x1a, 0xb7,
	0x8c, 0xdb, 0x4d, 0xfb, 0x4b, 0xab, 0x6e, 0x2b, 0xca, 0x54, 0x5a, 0xbb, 0x6a, 0xab, 0x3d, 0x15,
	0x3b, 0xed, 0x50, 0x42, 0x3c, 0xc6, 0x93, 0xcf, 0x27, 0x31, 0x7e, 0x44, 0xd2, 0xe8, 0x94, 0x61,
	0xe7, 0x72, 0x5a, 0xfc, 0x14, 0x14, 0x36, 0xe7, 0xf7, 0x47, 0x6b, 0x59, 0x72, 0x38, 0x3a, 0x83,
	0x43, 0x3e, 0xff, 0x5d, 0x16, 0xf5, 0x51, 0x82, 0x06, 0x12, 0x60, 0x4a, 0xa1, 0x76, 0xd4, 0x69,
	0xfa, 0xa5, 0x6f, 0xf3, 0x4f, 0x03, 0x6c, 0xe6, 0xd6, 0x4e, 0x1a, 0x62, 0x99, 0x4f, 0x04, 0xd6,
	0xa6, 0xea, 0x92, 0x29, 0x6d, 0xda, 0x7d, 0x4d, 0x3e, 0x02, 0x63, 0x81, 0x46, 0xde, 0xe9, 0xac,
	0x32, 0xd5, 0x82, 0x1e, 0xd8, 0x9c, 0x09, 0x70, 0xcc, 0x68, 0x1a, 0xf3, 0x56, 0xe3, 0xd6, 0xf2,
	0xed, 0x75, 0xfb, 0x81, 0x75, 0x7a, 0x21, 0x2c, 0xa1, 0x1e, 0x24, 0x38, 0xda, 0x13, 0xde, 0x82,
	0xb7, 0xd3, 0x64, 0xc5, 0x2e, 0x6e, 0xc6, 0xe0, 0x46, 0xad, 0x31, 0x1c, 0x00, 0x30, 0x65, 0xc0,
	0x5b, 0x86, 0x8c, 0x7d, 0xef, 0xbc, 0xb1, 0x65, 0xd8, 0xb5, 0x3c, 0x2c, 0x37, 0x7f, 0x58, 0x06,
	0x5b, 0x55, 0x36, 0xf0, 0x0e, 0x58, 0x21, 0x28, 0xc2, 0x5a, 0x02, 0x95, 0x96, 0x70, 0x04, 0x36,
	0xe7, 0xeb, 0x8d, 0xd4, 0xe7, 0xba, 0xdd, 0xd1, 0x65, 0xf9, 0x99, 0xf4, 0x2f, 0xf2, 0xd8, 0x5f,
	0x72, 0x9a, 0xa4, 0xd4, 0x2b, 0xe2, 0xcc, 0x57, 0x04, 0xa9, 0xc1, 0x73, 0xc4, 0xc9, 0xc8, 0xcf,
	0xc7, 0xe1, 0xa5, 0x5e, 0xf8, 0x12, 0x34, 0xcb, 0xb5, 0xbc, 0xb5, 0x22, 0xa3, 0x7c, 0xa2, 0x1b,
	0xa5, 0x8f, 0x12, 0x3c, 0x17, 0x63, 0xc3, 0x2f, 0xf4, 0xf5, 0xd6, 0x95, 0x6c, 0x05, 0xb8, 0xf9,
	0x63, 0x03, 0xb4, 0xea, 0x3c, 0xe1, 0x5b, 0xb0, 0x9a, 0x17, 0x3d, 0xa5, 0xef, 0x63, 0x4d, 0x7d,
	0x17, 0xa1, 0x9e, 0x29, 0x88, 0x92, 0xd6, 0xab, 0x0c, 0x9c, 0x69, 0x34, 0x68, 0x83, 0x0b, 0x27,
	0x62, 0x91, 0xd5, 0x52, 0x9e, 0x51, 0xa9, 0xa4, 0x29, 0xec, 0x82, 0x26, 0x1d, 0x8d, 0x38, 0x4e,
	0xdc, 0x80, 0xb8, 0x3e, 0x9a, 0x70, 0xb5, 0x3e, 0x1f, 0x2d, 0x38, 0x1f, 0x90, 0xe4, 0xe3, 0x7b,
	0xaa, 0x74, 0x66, 0x2e, 0x07, 0xa4, 0x8f, 0x26, 0xdc, 0xfc, 0xdd, 0x00, 0xdb, 0xf5, 0xaa, 0x80,
	0xdf, 0x2c, 0xe4, 0xe3, 0xa5, 0x66, 0x3e, 0xca, 0x60, 0x95, 0x19, 0xa9, 0x36, 0x39, 0x4f, 0x4e,
	0xfa, 0x34, 0x1d, 0x86, 0xb8, 0x98, 0x93, 0xd2, 0x84, 0x16, 0xe5, 0xf7, 0x01, 0x13, 0x2a, 0x83,
	0x55, 0x4e, 0xa8, 0xda, 0xe4, 0xc3, 0x16, 0xd9, 0x7c, 0xd7, 0x00, 0xad, 0x5d, 0x75, 0xeb, 0x12,
	0xd0, 0xa5, 0x03, 0x6e, 0x00, 0x36, 0x42, 0x3c, 0x4a, 0xb2, 0x93, 0x9a, 0xe4, 0xc7, 0xdc, 0x9d,
	0x73, 0x55, 0x2b, 0x51, 0xa9, 0xd6, 0x05, 0xca, 0xb3, 0x0c, 0x04, 0x1e, 0x82, 0xcb, 0x2c, 0x18,
	0xbf, 0x9a, 0xa1, 0x36, 0xde, 0x13, 0x75, 0x43, 0xc2, 0xe4, 0xb0, 0xdf, 0x1b, 0xe0, 0x72, 0xe9,
	0x96, 0xa5, 0x4e, 0x34, 0xdd, 0x1d, 0x56, 0x4c, 0x42, 0x65, 0xfa, 0xab, 0x0c, 0x9c, 0x0d, 0x56,
	0xf8, 0x12, 0xa7, 0xda, 0x8e, 0xd8, 0x88, 0x83, 0x18, 0x7b, 0xc1, 0x28, 0xf0, 0x16, 0x12, 0xda,
	0x07, 0x2b, 0xc2, 0xe1, 0xbd, 0x13, 0x29, 0xbd, 0xe1, 0x43, 0x00, 0x78, 0x82, 0x58, 0x76, 0x49,
	0xd5, 0x5a, 0xec, 0x35, 0x69, 0x2f, 0xa8, 0xc1, 0xfb, 0x60, 0x15, 0x13, 0x3f, 0x73, 0x5d, 0xd6,
	0x70, 0xbd, 0x84, 0x89, 0x2f, 0x1c, 0xcd, 0x21, 0xd8, 0x7e, 0xf4, 0x36, 0x66, 0x98, 0xf3, 0x80,
	0x92, 0xff, 0x66, 0x66, 0xe6, 0xaf, 0x2b, 0xe0, 0xff, 0xa2, 0x6b, 0xf1, 0xae, 0xf5, 0x93, 0x01,
	0xb6, 0xaa, 0xae, 0xaf, 0x6a, 0x9b, 0xbd, 0xd0, 0x5c, 0xe5, 0xe7, 0x45, 0x88, 0x81, 0x44, 0x28,
	0x2d, 0x72, 0xc5, 0xb8, 0x73, 0x35, 0x5e, 0xec, 0x84, 0x5f, 0x83, 0xeb, 0xe5, 0xc7, 0xca, 0xec,
	0x86, 0xd9, 0xd0, 0x3b, 0x5f, 0xea, 0x76, 0xdd, 0xfe, 0x92, 0xb3, 0xe5, 0x55, 0x8c, 0xc1, 0x6f,
	0xc1, 0x8e, 0x3c, 0xc9, 0xb8, 0x52, 0xd7, 0x7c, 0xdc, 0x6c, 0x35, 0x3f, 0x3d, 0x2b, 0xee, 0x69,
	0x02, 0xdd, 0x5f, 0x72, 0x5a, 0x7e, 0xcd, 0x38, 0x7c, 0x03, 0x6e, 0xe0, 0xa9, 0x00, 0xe6, 0x83,
	0xaf, 0xe8, 0x1d, 0xdd, 0xf5, 0x0a, 0xda, 0x5f, 0x72, 0xae, 0xe1, 0xca, 0xd1, 0xde, 0x35, 0xb0,
	0x25, 0xa3, 0x0d, 0x85, 0x2a, 0x66, 0x31, 0x4d, 0x1f, 0x5c, 0x7d, 0x92, 0xbd, 0xaf, 0x4a, 0x52,
	0x79, 0x0a, 0x2e, 0x08, 0xf3, 0xfc, 0x72, 0x75, 0x5f, 0x57, 0x8b, 0x0a, 0x6b, 0x2a, 0xc9, 0x0c,
	0xc5, 0xfc, 0xc7, 0x00, 0xd7, 0x6b, 0x4c, 0xe0, 0xc9, 0x42, 0xbd, 0xd7, 0x15, 0x62, 0x01, 0xa9,
	0xb2, 0xda, 0x54, 0x8c, 0x17, 0x2a, 0xbd, 0x5b, 0xac, 0x75, 0xc4, 0xcf, 0xef, 0xb0, 0x67, 0xa6,
	0x7f, 0x2e, 0x5d, 0xaa, 0x76, 0xaa, 0x6a, 0x9a, 0x87, 0x22, 0x3e, 0x37, 0xbf, 0x00, 0xdb, 0xf5,
	0xb6, 0xf0, 0x01, 0x58, 0x3b, 0xdf, 0x83, 0x6a, 0x35, 0xcd, 0x1f, 0x53, 0x08, 0x5c, 0xe9, 0x21,
	0x1e, 0x78, 0xa5, 0x15, 0x7b, 0x02, 0x2e, 0x21, 0x4f, 0xbe, 0xe6, 0xd4, 0x9a, 0xd9, 0xba, 0x6b,
	0xd6, 0x95, 0x6e, 0x72, 0x02, 0x39, 0x84, 0xf9, 0x9b, 0x01, 0xe0, 0xe2, 0x38, 0x7c, 0x0c, 0xae,
	0x78, 0x94, 0x9c, 0x60, 0x26, 0xe5, 0x9b, 0x19, 0xeb, 0x90, 0xdf, 0x5f, 0x72, 0x36, 0x67, 0x8e,
	0x19, 0x20, 0x7c, 0x0a, 0x20, 0xc3, 0x11, 0x62, 0xaf, 0x71, 0x22, 0xae, 0xb0, 0x0a, 0xad, 0xa1,
	0x85, 0x76, 0xa5, 0xe0, 0x99, 0xc1, 0xf5, 0x20, 0xd8, 0x9c, 0x3d, 0x94, 0x33, 0xb0, 0xde, 0x5f,
	0x06, 0x30, 0x3d, 0x1a, 0x9d, 0x91, 0x89, 0x5e, 0x33, 0x9f, 0x2a, 0x7f, 0x2e, 0xc2, 0x3d, 0x37,
	0x5e, 0xa8, 0x7f, 0x5b, 0xac, 0x31, 0x0d, 0x11, 0x19, 0x5b, 0x94, 0x8d, 0xdb, 0x63, 0x4c, 0x24,
	0x99, 0xfc, 0x85, 0x1e, 0x07, 0xbc, 0xee, 0x1f, 0xa2, 0x87, 0xd9, 0xcf, 0xcf, 0x8d, 0xe5, 0xbd,
	0x6e, 0xf7, 0x97, 0xc6, 0xcd, 0xbd, 0x0c, 0xac, 0xeb, 0x73, 0x2b, 0x6b, 0x8a, 0xd6, 0x91, 0x2d,
	0xca, 0x57, 0x44, 0xc9, 0xbb, 0xdc, 0xe0, 0xb8, 0xeb, 0xf3, 0xe3, 0xa9, 0xc1, 0xf1, 0x91, 0x7d,
	0x9c, 0x19, 0xfc, 0xdd, 0x30, 0xb3, 0xde, 0x4e, 0xa7, 0xeb, 0xf3, 0x4e, 0x67, 0x6a, 0xd2, 0xe9,
	0x1c, 0xd9, 0x9d, 0x4e, 0x66, 0x34, 0xbc, 0x28, 0xd9, 0xdd, 0xfd, 0x37, 0x00, 0x00, 0xff, 0xff,
	0xbe, 0x7e, 0x5e, 0xc7, 0xbe, 0x12, 0x00, 0x00,
}
