/***********************************************************************************

    Copyright (C) 2007-2020 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#include <src/parser_paragraph.hpp>
#include "lifeograph.hpp"
#include "app_window.hpp"
#include "diary.hpp"


using namespace LIFEO;

void
ParserPara::parse( Paragraph* para )
{
    m_p2para_cur = para;
    ParserText::parse( 0, para->get_size() );
}

/*void
ParaParser::process_paragraph()
{

}*/

void
ParserPara::apply_heading()
{
    // if() check can be removed when apply_heading calls are made in a more standardized way
    if( m_p2para_cur->m_para_no == 0 )
        m_p2para_cur->m_heading_level = 3;
}

void
ParserPara::apply_subheading()
{
    m_p2para_cur->m_heading_level = 2;
}

void
ParserPara::apply_subsubheading()
{
    m_p2para_cur->m_heading_level = 1;
}

void
ParserPara::apply_link()
{
    if( m_recipe_cur->m_id == RID_DATE )
        m_p2para_cur->set_date( m_date_last.m_date );
}

void
ParserPara::apply_check_unf()
{
    m_p2para_cur->m_status = ES::TODO;
}
void
ParserPara::apply_check_prg()
{
    m_p2para_cur->m_status = ES::PROGRESSED;
}
void
ParserPara::apply_check_fin()
{
    m_p2para_cur->m_status = ES::DONE;
}
void
ParserPara::apply_check_ccl()
{
    m_p2para_cur->m_status = ES::CANCELED;
}

void
ParserPara::apply_inline_tag()
{
    // m_pos_mid is used to determine if the name part or the value type is being applied
    const auto pos_name_end{ m_recipe_cur->m_pos_mid > 0 ?
                             m_recipe_cur->m_pos_mid - 1 : m_pos_cur - 1 };
    const Ustring&& tag_name{ get_substr( m_recipe_cur->m_pos_bgn + 1, pos_name_end ) };

    // the value (BEAWARE that the last reference overrides previous ones within a paragraph):
    if( m_recipe_cur->m_pos_mid > 0 )
    {
        if( m_pos_extra_1 > m_recipe_cur->m_pos_bgn ) // has planned value
        {
            const auto  pos_value_bgn{ m_recipe_cur->m_pos_mid + 1 };
            const Value v_real{ STR::get_d( get_substr( pos_value_bgn, m_pos_extra_1 ) ) };
            const Value v_plan{ STR::get_d( get_substr( m_pos_extra_1 + 1, m_pos_extra_2 + 1 ) ) };
            m_p2para_cur->set_tag( tag_name, v_real, v_plan );
        }
        else
            m_p2para_cur->set_tag( tag_name,
                    STR::get_d( get_substr( m_recipe_cur->m_pos_mid + 1 , m_pos_cur ) ) );
    }
    else
        m_p2para_cur->set_tag( tag_name, 1.0 );
}

