; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=aggressive-instcombine -S | FileCheck %s

define i16 @lshr_15(i16 %x) {
; CHECK-LABEL: @lshr_15(
; CHECK-NEXT:    [[LSHR:%.*]] = lshr i16 [[X:%.*]], 15
; CHECK-NEXT:    ret i16 [[LSHR]]
;
  %zext = zext i16 %x to i32
  %lshr = lshr i32 %zext, 15
  %trunc = trunc i32 %lshr to i16
  ret i16 %trunc
}

; Negative test

define i16 @lshr_16(i16 %x) {
; CHECK-LABEL: @lshr_16(
; CHECK-NEXT:    [[ZEXT:%.*]] = zext i16 [[X:%.*]] to i32
; CHECK-NEXT:    [[LSHR:%.*]] = lshr i32 [[ZEXT]], 16
; CHECK-NEXT:    [[TRUNC:%.*]] = trunc i32 [[LSHR]] to i16
; CHECK-NEXT:    ret i16 [[TRUNC]]
;
  %zext = zext i16 %x to i32
  %lshr = lshr i32 %zext, 16
  %trunc = trunc i32 %lshr to i16
  ret i16 %trunc
}

; Negative test

define i16 @lshr_var_shift_amount(i8 %x, i8 %amt) {
; CHECK-LABEL: @lshr_var_shift_amount(
; CHECK-NEXT:    [[Z:%.*]] = zext i8 [[X:%.*]] to i32
; CHECK-NEXT:    [[ZA:%.*]] = zext i8 [[AMT:%.*]] to i32
; CHECK-NEXT:    [[S:%.*]] = lshr i32 [[Z]], [[ZA]]
; CHECK-NEXT:    [[A:%.*]] = add i32 [[S]], [[Z]]
; CHECK-NEXT:    [[S2:%.*]] = lshr i32 [[A]], 2
; CHECK-NEXT:    [[T:%.*]] = trunc i32 [[S2]] to i16
; CHECK-NEXT:    ret i16 [[T]]
;
  %z = zext i8 %x to i32
  %za = zext i8 %amt to i32
  %s = lshr i32 %z, %za
  %a = add i32 %s, %z
  %s2 = lshr i32 %a, 2
  %t = trunc i32 %s2 to i16
  ret i16 %t
}

define i16 @lshr_var_bounded_shift_amount(i8 %x, i8 %amt) {
; CHECK-LABEL: @lshr_var_bounded_shift_amount(
; CHECK-NEXT:    [[Z:%.*]] = zext i8 [[X:%.*]] to i16
; CHECK-NEXT:    [[ZA:%.*]] = zext i8 [[AMT:%.*]] to i16
; CHECK-NEXT:    [[ZA2:%.*]] = and i16 [[ZA]], 15
; CHECK-NEXT:    [[S:%.*]] = lshr i16 [[Z]], [[ZA2]]
; CHECK-NEXT:    [[A:%.*]] = add i16 [[S]], [[Z]]
; CHECK-NEXT:    [[S2:%.*]] = lshr i16 [[A]], 2
; CHECK-NEXT:    ret i16 [[S2]]
;
  %z = zext i8 %x to i32
  %za = zext i8 %amt to i32
  %za2 = and i32 %za, 15
  %s = lshr i32 %z, %za2
  %a = add i32 %s, %z
  %s2 = lshr i32 %a, 2
  %t = trunc i32 %s2 to i16
  ret i16 %t
}

; Negative test

define i32 @lshr_check_no_overflow(i32 %x, i16 %amt) {
; CHECK-LABEL: @lshr_check_no_overflow(
; CHECK-NEXT:    [[ZEXT:%.*]] = zext i32 [[X:%.*]] to i64
; CHECK-NEXT:    [[SEXT:%.*]] = sext i16 [[AMT:%.*]] to i64
; CHECK-NEXT:    [[AND:%.*]] = and i64 [[SEXT]], 4294967295
; CHECK-NEXT:    [[SHL:%.*]] = lshr i64 [[ZEXT]], [[AND]]
; CHECK-NEXT:    [[TRUNC:%.*]] = trunc i64 [[SHL]] to i32
; CHECK-NEXT:    ret i32 [[TRUNC]]
;
  %zext = zext i32 %x to i64
  %sext = sext i16 %amt to i64
  %and = and i64 %sext, 4294967295
  %shl = lshr i64 %zext, %and
  %trunc = trunc i64 %shl to i32
  ret i32 %trunc
}

define void @lshr_big_dag(ptr %a, i8 %b, i8 %c) {
; CHECK-LABEL: @lshr_big_dag(
; CHECK-NEXT:    [[ZEXT1:%.*]] = zext i8 [[B:%.*]] to i16
; CHECK-NEXT:    [[ZEXT2:%.*]] = zext i8 [[C:%.*]] to i16
; CHECK-NEXT:    [[ADD1:%.*]] = add i16 [[ZEXT1]], [[ZEXT2]]
; CHECK-NEXT:    [[SFT1:%.*]] = and i16 [[ADD1]], 15
; CHECK-NEXT:    [[SHR1:%.*]] = lshr i16 [[ADD1]], [[SFT1]]
; CHECK-NEXT:    [[ADD2:%.*]] = add i16 [[ADD1]], [[SHR1]]
; CHECK-NEXT:    [[SFT2:%.*]] = and i16 [[ADD2]], 7
; CHECK-NEXT:    [[SHR2:%.*]] = lshr i16 [[ADD2]], [[SFT2]]
; CHECK-NEXT:    store i16 [[SHR2]], ptr [[A:%.*]], align 2
; CHECK-NEXT:    ret void
;
  %zext1 = zext i8 %b to i32
  %zext2 = zext i8 %c to i32
  %add1 = add i32 %zext1, %zext2
  %sft1 = and i32 %add1, 15
  %shr1 = lshr i32 %add1, %sft1
  %add2 = add i32 %add1, %shr1
  %sft2 = and i32 %add2, 7
  %shr2 = lshr i32 %add2, %sft2
  %trunc = trunc i32 %shr2 to i16
  store i16 %trunc, ptr %a, align 2
  ret void
}

; Negative test

define i8 @lshr_check_not_i8_trunc(i16 %x) {
; CHECK-LABEL: @lshr_check_not_i8_trunc(
; CHECK-NEXT:    [[LSHR:%.*]] = lshr i16 [[X:%.*]], 1
; CHECK-NEXT:    [[ZEXT2:%.*]] = zext i16 [[LSHR]] to i32
; CHECK-NEXT:    [[LSHR2:%.*]] = lshr i32 [[ZEXT2]], 2
; CHECK-NEXT:    [[TRUNC:%.*]] = trunc i32 [[LSHR2]] to i8
; CHECK-NEXT:    ret i8 [[TRUNC]]
;
  %lshr = lshr i16 %x, 1
  %zext2 = zext i16 %lshr to i32
  %lshr2 = lshr i32 %zext2, 2
  %trunc = trunc i32 %lshr2 to i8
  ret i8 %trunc
}

define <2 x i16> @lshr_vector(<2 x i8> %x) {
; CHECK-LABEL: @lshr_vector(
; CHECK-NEXT:    [[Z:%.*]] = zext <2 x i8> [[X:%.*]] to <2 x i16>
; CHECK-NEXT:    [[ZA:%.*]] = and <2 x i16> [[Z]], <i16 7, i16 8>
; CHECK-NEXT:    [[S:%.*]] = lshr <2 x i16> [[Z]], [[ZA]]
; CHECK-NEXT:    [[A:%.*]] = add <2 x i16> [[S]], [[Z]]
; CHECK-NEXT:    [[S2:%.*]] = lshr <2 x i16> [[A]], <i16 4, i16 5>
; CHECK-NEXT:    ret <2 x i16> [[S2]]
;
  %z = zext <2 x i8> %x to <2 x i32>
  %za = and <2 x i32> %z, <i32 7, i32 8>
  %s = lshr <2 x i32> %z, %za
  %a = add <2 x i32> %s, %z
  %s2 = lshr <2 x i32> %a, <i32 4, i32 5>
  %t = trunc <2 x i32> %s2 to <2 x i16>
  ret <2 x i16> %t
}

; Negative test - can only fold to <2 x i16>, requiring new vector type

define <2 x i8> @lshr_vector_no_new_vector_type(<2 x i8> %x) {
; CHECK-LABEL: @lshr_vector_no_new_vector_type(
; CHECK-NEXT:    [[Z:%.*]] = zext <2 x i8> [[X:%.*]] to <2 x i32>
; CHECK-NEXT:    [[ZA:%.*]] = and <2 x i32> [[Z]], <i32 7, i32 8>
; CHECK-NEXT:    [[S:%.*]] = lshr <2 x i32> [[Z]], [[ZA]]
; CHECK-NEXT:    [[A:%.*]] = add <2 x i32> [[S]], [[Z]]
; CHECK-NEXT:    [[S2:%.*]] = lshr <2 x i32> [[A]], <i32 4, i32 5>
; CHECK-NEXT:    [[T:%.*]] = trunc <2 x i32> [[S2]] to <2 x i8>
; CHECK-NEXT:    ret <2 x i8> [[T]]
;
  %z = zext <2 x i8> %x to <2 x i32>
  %za = and <2 x i32> %z, <i32 7, i32 8>
  %s = lshr <2 x i32> %z, %za
  %a = add <2 x i32> %s, %z
  %s2 = lshr <2 x i32> %a, <i32 4, i32 5>
  %t = trunc <2 x i32> %s2 to <2 x i8>
  ret <2 x i8> %t
}

; Negative test

define <2 x i16> @lshr_vector_large_shift_amount(<2 x i8> %x) {
; CHECK-LABEL: @lshr_vector_large_shift_amount(
; CHECK-NEXT:    [[Z:%.*]] = zext <2 x i8> [[X:%.*]] to <2 x i32>
; CHECK-NEXT:    [[ZA:%.*]] = and <2 x i32> [[Z]], <i32 7, i32 8>
; CHECK-NEXT:    [[S:%.*]] = lshr <2 x i32> [[Z]], [[ZA]]
; CHECK-NEXT:    [[A:%.*]] = add <2 x i32> [[S]], [[Z]]
; CHECK-NEXT:    [[S2:%.*]] = lshr <2 x i32> [[A]], <i32 16, i32 5>
; CHECK-NEXT:    [[T:%.*]] = trunc <2 x i32> [[S2]] to <2 x i16>
; CHECK-NEXT:    ret <2 x i16> [[T]]
;
  %z = zext <2 x i8> %x to <2 x i32>
  %za = and <2 x i32> %z, <i32 7, i32 8>
  %s = lshr <2 x i32> %z, %za
  %a = add <2 x i32> %s, %z
  %s2 = lshr <2 x i32> %a, <i32 16, i32 5>
  %t = trunc <2 x i32> %s2 to <2 x i16>
  ret <2 x i16> %t
}

define i16 @lshr_exact(i16 %x) {
; CHECK-LABEL: @lshr_exact(
; CHECK-NEXT:    [[LSHR:%.*]] = lshr exact i16 [[X:%.*]], 15
; CHECK-NEXT:    ret i16 [[LSHR]]
;
  %zext = zext i16 %x to i32
  %lshr = lshr exact i32 %zext, 15
  %trunc = trunc i32 %lshr to i16
  ret i16 %trunc
}

; Negative test

define i16 @lshr_negative_operand(i16 %x) {
; CHECK-LABEL: @lshr_negative_operand(
; CHECK-NEXT:    [[ZEXT:%.*]] = zext i16 [[X:%.*]] to i32
; CHECK-NEXT:    [[XOR:%.*]] = xor i32 -1, [[ZEXT]]
; CHECK-NEXT:    [[LSHR2:%.*]] = lshr i32 [[XOR]], 2
; CHECK-NEXT:    [[TRUNC:%.*]] = trunc i32 [[LSHR2]] to i16
; CHECK-NEXT:    ret i16 [[TRUNC]]
;
  %zext = zext i16 %x to i32
  %xor = xor i32 -1, %zext
  %lshr2 = lshr i32 %xor, 2
  %trunc = trunc i32 %lshr2 to i16
  ret i16 %trunc
}

; We may encounter unoptimized IR as below,
; so don't crash by assuming that we can
; apply instruction flags (exact) if there
; is no instruction.

define i8 @non_canonical_crash() {
; CHECK-LABEL: @non_canonical_crash(
; CHECK-NEXT:    ret i8 8
;
  %sh = lshr i32 33, 2
  %tr = trunc i32 %sh to i8
  ret i8 %tr
}
