// Copyright (c) 2009, Jens Peter Secher <jpsecher@gmail.com>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

class UtilUnitTest
extends haxe.unit.TestCase
{
	public function testParseTag()
	{
		var tag = "neko_1.8.0-4";
		var changeLog = Util.parseTag( tag );
		assertFalse( changeLog == null );
        assertEquals( changeLog.source, "neko" );
        assertEquals( changeLog.version.epoch, null );
        assertEquals( changeLog.version.upstream, "1.8.0" );
        assertEquals( changeLog.version.debianRevision, "4" );
    }
	public function testParseNonTag()
	{
		var tag = "UPSTREAM_neko_1.8.0-4_TAG";
		var changeLog = Util.parseTag( tag );
		assertTrue( changeLog == null );
    }
	public function testTagsOk()
	{
		var tags =
		[
			"neko_1.8.0-4",
			"neko_1.8.0-1",
			"neko_1.8.0"
		];
		var newer = new DebianChangeLog( "neko", "1.8.1" );
		assertTrue( Util.tagOk( tags.iterator(), newer ) );
		var older = new DebianChangeLog( "neko", "1.7" );
		assertFalse( Util.tagOk( tags.iterator(), older ) );
	}
}
