# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AccessTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Required for storage accounts where kind = BlobStorage. The access tier used for billing."""

    HOT = "Hot"
    COOL = "Cool"


class AccountStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets the status indicating whether the primary location of the storage account is available or
    unavailable.
    """

    AVAILABLE = "Available"
    UNAVAILABLE = "Unavailable"


class EncryptionKeySource(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.Storage."""

    MICROSOFT_STORAGE = "Microsoft.Storage"


class KeyPermission(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Permissions for the key -- read-only or full permissions."""

    READ = "READ"
    FULL = "FULL"


class Kind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Required. Indicates the type of storage account."""

    STORAGE = "Storage"
    BLOB_STORAGE = "BlobStorage"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets the status of the storage account at the time the operation was called."""

    CREATING = "Creating"
    RESOLVING_DNS = "ResolvingDNS"
    SUCCEEDED = "Succeeded"


class Reason(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets the reason that a storage account name could not be used. The Reason element is only
    returned if NameAvailable is false.
    """

    ACCOUNT_NAME_INVALID = "AccountNameInvalid"
    ALREADY_EXISTS = "AlreadyExists"


class SkuName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets or sets the sku name. Required for account creation; optional for update. Note that in
    older versions, sku name was called accountType.
    """

    STANDARD_LRS = "Standard_LRS"
    STANDARD_GRS = "Standard_GRS"
    STANDARD_RAGRS = "Standard_RAGRS"
    STANDARD_ZRS = "Standard_ZRS"
    PREMIUM_LRS = "Premium_LRS"


class SkuTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets the sku tier. This is based on the SKU name."""

    STANDARD = "Standard"
    PREMIUM = "Premium"


class StorageAccountCheckNameAvailabilityParametersType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """StorageAccountCheckNameAvailabilityParametersType."""

    MICROSOFT_STORAGE_STORAGE_ACCOUNTS = "Microsoft.Storage/storageAccounts"


class UsageUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets the unit of measurement."""

    COUNT = "Count"
    BYTES = "Bytes"
    SECONDS = "Seconds"
    PERCENT = "Percent"
    COUNTS_PER_SECOND = "CountsPerSecond"
    BYTES_PER_SECOND = "BytesPerSecond"
