# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.security.aio import SecurityCenter

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSecurityCenterConnectorsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SecurityCenter, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_connectors_list(self, resource_group):
        response = self.client.connectors.list(
            api_version="2020-01-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_connectors_get(self, resource_group):
        response = await self.client.connectors.get(
            connector_name="str",
            api_version="2020-01-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_connectors_create_or_update(self, resource_group):
        response = await self.client.connectors.create_or_update(
            connector_name="str",
            connector_setting={
                "authenticationDetails": "authentication_details_properties",
                "hybridComputeSettings": {
                    "autoProvision": "str",
                    "hybridComputeProvisioningState": "str",
                    "proxyServer": {"ip": "str", "port": "str"},
                    "region": "str",
                    "resourceGroupName": "str",
                    "servicePrincipal": {"applicationId": "str", "secret": "str"},
                },
                "id": "str",
                "name": "str",
                "type": "str",
            },
            api_version="2020-01-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_connectors_delete(self, resource_group):
        response = await self.client.connectors.delete(
            connector_name="str",
            api_version="2020-01-01-preview",
        )

        # please add some check logic here by yourself
        # ...
