# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page
from twilio.rest.api.v2010.account.sip.domain.auth_types import AuthTypesList
from twilio.rest.api.v2010.account.sip.domain.credential_list_mapping import CredentialListMappingList
from twilio.rest.api.v2010.account.sip.domain.ip_access_control_list_mapping import IpAccessControlListMappingList


class DomainList(ListResource):

    def __init__(self, version, account_sid):
        """
        Initialize the DomainList

        :param Version version: Version that contains the resource
        :param account_sid: A 34 character string that uniquely identifies this resource.

        :returns: twilio.rest.api.v2010.account.sip.domain.DomainList
        :rtype: twilio.rest.api.v2010.account.sip.domain.DomainList
        """
        super(DomainList, self).__init__(version)

        # Path Solution
        self._solution = {'account_sid': account_sid, }
        self._uri = '/Accounts/{account_sid}/SIP/Domains.json'.format(**self._solution)

    def stream(self, limit=None, page_size=None):
        """
        Streams DomainInstance records from the API as a generator stream.
        This operation lazily loads records as efficiently as possible until the limit
        is reached.
        The results are returned as a generator, so this operation is memory efficient.

        :param int limit: Upper limit for the number of records to return. stream()
                          guarantees to never return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, stream() will attempt to read the
                              limit with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.api.v2010.account.sip.domain.DomainInstance]
        """
        limits = self._version.read_limits(limit, page_size)

        page = self.page(page_size=limits['page_size'], )

        return self._version.stream(page, limits['limit'])

    def list(self, limit=None, page_size=None):
        """
        Lists DomainInstance records from the API as a list.
        Unlike stream(), this operation is eager and will load `limit` records into
        memory before returning.

        :param int limit: Upper limit for the number of records to return. list() guarantees
                          never to return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, list() will attempt to read the limit
                              with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.api.v2010.account.sip.domain.DomainInstance]
        """
        return list(self.stream(limit=limit, page_size=page_size, ))

    def page(self, page_token=values.unset, page_number=values.unset,
             page_size=values.unset):
        """
        Retrieve a single page of DomainInstance records from the API.
        Request is executed immediately

        :param str page_token: PageToken provided by the API
        :param int page_number: Page Number, this value is simply for client state
        :param int page_size: Number of records to return, defaults to 50

        :returns: Page of DomainInstance
        :rtype: twilio.rest.api.v2010.account.sip.domain.DomainPage
        """
        data = values.of({'PageToken': page_token, 'Page': page_number, 'PageSize': page_size, })

        response = self._version.page(method='GET', uri=self._uri, params=data, )

        return DomainPage(self._version, response, self._solution)

    def get_page(self, target_url):
        """
        Retrieve a specific page of DomainInstance records from the API.
        Request is executed immediately

        :param str target_url: API-generated URL for the requested results page

        :returns: Page of DomainInstance
        :rtype: twilio.rest.api.v2010.account.sip.domain.DomainPage
        """
        response = self._version.domain.twilio.request(
            'GET',
            target_url,
        )

        return DomainPage(self._version, response, self._solution)

    def create(self, domain_name, friendly_name=values.unset,
               voice_url=values.unset, voice_method=values.unset,
               voice_fallback_url=values.unset, voice_fallback_method=values.unset,
               voice_status_callback_url=values.unset,
               voice_status_callback_method=values.unset,
               sip_registration=values.unset,
               emergency_calling_enabled=values.unset, secure=values.unset,
               byoc_trunk_sid=values.unset, emergency_caller_sid=values.unset):
        """
        Create the DomainInstance

        :param unicode domain_name: The unique address on Twilio to route SIP traffic
        :param unicode friendly_name: A string to describe the resource
        :param unicode voice_url: The URL we should call when receiving a call
        :param unicode voice_method: The HTTP method to use with voice_url
        :param unicode voice_fallback_url: The URL we should call when an error occurs in executing TwiML
        :param unicode voice_fallback_method: The HTTP method to use with voice_fallback_url
        :param unicode voice_status_callback_url: The URL that we should call to pass status updates
        :param unicode voice_status_callback_method: The HTTP method we should use to call `voice_status_callback_url`
        :param bool sip_registration: Whether SIP registration is allowed
        :param bool emergency_calling_enabled: Whether emergency calling is enabled for the domain.
        :param bool secure: Whether secure SIP is enabled for the domain
        :param unicode byoc_trunk_sid: The SID of the BYOC Trunk resource.
        :param unicode emergency_caller_sid: Whether an emergency caller sid is configured for the domain.

        :returns: The created DomainInstance
        :rtype: twilio.rest.api.v2010.account.sip.domain.DomainInstance
        """
        data = values.of({
            'DomainName': domain_name,
            'FriendlyName': friendly_name,
            'VoiceUrl': voice_url,
            'VoiceMethod': voice_method,
            'VoiceFallbackUrl': voice_fallback_url,
            'VoiceFallbackMethod': voice_fallback_method,
            'VoiceStatusCallbackUrl': voice_status_callback_url,
            'VoiceStatusCallbackMethod': voice_status_callback_method,
            'SipRegistration': sip_registration,
            'EmergencyCallingEnabled': emergency_calling_enabled,
            'Secure': secure,
            'ByocTrunkSid': byoc_trunk_sid,
            'EmergencyCallerSid': emergency_caller_sid,
        })

        payload = self._version.create(method='POST', uri=self._uri, data=data, )

        return DomainInstance(self._version, payload, account_sid=self._solution['account_sid'], )

    def get(self, sid):
        """
        Constructs a DomainContext

        :param sid: The unique string that identifies the resource

        :returns: twilio.rest.api.v2010.account.sip.domain.DomainContext
        :rtype: twilio.rest.api.v2010.account.sip.domain.DomainContext
        """
        return DomainContext(self._version, account_sid=self._solution['account_sid'], sid=sid, )

    def __call__(self, sid):
        """
        Constructs a DomainContext

        :param sid: The unique string that identifies the resource

        :returns: twilio.rest.api.v2010.account.sip.domain.DomainContext
        :rtype: twilio.rest.api.v2010.account.sip.domain.DomainContext
        """
        return DomainContext(self._version, account_sid=self._solution['account_sid'], sid=sid, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Api.V2010.DomainList>'


class DomainPage(Page):

    def __init__(self, version, response, solution):
        """
        Initialize the DomainPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param account_sid: A 34 character string that uniquely identifies this resource.

        :returns: twilio.rest.api.v2010.account.sip.domain.DomainPage
        :rtype: twilio.rest.api.v2010.account.sip.domain.DomainPage
        """
        super(DomainPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of DomainInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.api.v2010.account.sip.domain.DomainInstance
        :rtype: twilio.rest.api.v2010.account.sip.domain.DomainInstance
        """
        return DomainInstance(self._version, payload, account_sid=self._solution['account_sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Api.V2010.DomainPage>'


class DomainContext(InstanceContext):

    def __init__(self, version, account_sid, sid):
        """
        Initialize the DomainContext

        :param Version version: Version that contains the resource
        :param account_sid: The SID of the Account that created the resource to fetch
        :param sid: The unique string that identifies the resource

        :returns: twilio.rest.api.v2010.account.sip.domain.DomainContext
        :rtype: twilio.rest.api.v2010.account.sip.domain.DomainContext
        """
        super(DomainContext, self).__init__(version)

        # Path Solution
        self._solution = {'account_sid': account_sid, 'sid': sid, }
        self._uri = '/Accounts/{account_sid}/SIP/Domains/{sid}.json'.format(**self._solution)

        # Dependents
        self._ip_access_control_list_mappings = None
        self._credential_list_mappings = None
        self._auth = None

    def fetch(self):
        """
        Fetch the DomainInstance

        :returns: The fetched DomainInstance
        :rtype: twilio.rest.api.v2010.account.sip.domain.DomainInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return DomainInstance(
            self._version,
            payload,
            account_sid=self._solution['account_sid'],
            sid=self._solution['sid'],
        )

    def update(self, friendly_name=values.unset, voice_fallback_method=values.unset,
               voice_fallback_url=values.unset, voice_method=values.unset,
               voice_status_callback_method=values.unset,
               voice_status_callback_url=values.unset, voice_url=values.unset,
               sip_registration=values.unset, domain_name=values.unset,
               emergency_calling_enabled=values.unset, secure=values.unset,
               byoc_trunk_sid=values.unset, emergency_caller_sid=values.unset):
        """
        Update the DomainInstance

        :param unicode friendly_name: A string to describe the resource
        :param unicode voice_fallback_method: The HTTP method used with voice_fallback_url
        :param unicode voice_fallback_url: The URL we should call when an error occurs in executing TwiML
        :param unicode voice_method: The HTTP method we should use with voice_url
        :param unicode voice_status_callback_method: The HTTP method we should use to call voice_status_callback_url
        :param unicode voice_status_callback_url: The URL that we should call to pass status updates
        :param unicode voice_url: The URL we should call when receiving a call
        :param bool sip_registration: Whether SIP registration is allowed
        :param unicode domain_name: The unique address on Twilio to route SIP traffic
        :param bool emergency_calling_enabled: Whether emergency calling is enabled for the domain.
        :param bool secure: Whether secure SIP is enabled for the domain
        :param unicode byoc_trunk_sid: The SID of the BYOC Trunk resource.
        :param unicode emergency_caller_sid: Whether an emergency caller sid is configured for the domain.

        :returns: The updated DomainInstance
        :rtype: twilio.rest.api.v2010.account.sip.domain.DomainInstance
        """
        data = values.of({
            'FriendlyName': friendly_name,
            'VoiceFallbackMethod': voice_fallback_method,
            'VoiceFallbackUrl': voice_fallback_url,
            'VoiceMethod': voice_method,
            'VoiceStatusCallbackMethod': voice_status_callback_method,
            'VoiceStatusCallbackUrl': voice_status_callback_url,
            'VoiceUrl': voice_url,
            'SipRegistration': sip_registration,
            'DomainName': domain_name,
            'EmergencyCallingEnabled': emergency_calling_enabled,
            'Secure': secure,
            'ByocTrunkSid': byoc_trunk_sid,
            'EmergencyCallerSid': emergency_caller_sid,
        })

        payload = self._version.update(method='POST', uri=self._uri, data=data, )

        return DomainInstance(
            self._version,
            payload,
            account_sid=self._solution['account_sid'],
            sid=self._solution['sid'],
        )

    def delete(self):
        """
        Deletes the DomainInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._version.delete(method='DELETE', uri=self._uri, )

    @property
    def ip_access_control_list_mappings(self):
        """
        Access the ip_access_control_list_mappings

        :returns: twilio.rest.api.v2010.account.sip.domain.ip_access_control_list_mapping.IpAccessControlListMappingList
        :rtype: twilio.rest.api.v2010.account.sip.domain.ip_access_control_list_mapping.IpAccessControlListMappingList
        """
        if self._ip_access_control_list_mappings is None:
            self._ip_access_control_list_mappings = IpAccessControlListMappingList(
                self._version,
                account_sid=self._solution['account_sid'],
                domain_sid=self._solution['sid'],
            )
        return self._ip_access_control_list_mappings

    @property
    def credential_list_mappings(self):
        """
        Access the credential_list_mappings

        :returns: twilio.rest.api.v2010.account.sip.domain.credential_list_mapping.CredentialListMappingList
        :rtype: twilio.rest.api.v2010.account.sip.domain.credential_list_mapping.CredentialListMappingList
        """
        if self._credential_list_mappings is None:
            self._credential_list_mappings = CredentialListMappingList(
                self._version,
                account_sid=self._solution['account_sid'],
                domain_sid=self._solution['sid'],
            )
        return self._credential_list_mappings

    @property
    def auth(self):
        """
        Access the auth

        :returns: twilio.rest.api.v2010.account.sip.domain.auth_types.AuthTypesList
        :rtype: twilio.rest.api.v2010.account.sip.domain.auth_types.AuthTypesList
        """
        if self._auth is None:
            self._auth = AuthTypesList(
                self._version,
                account_sid=self._solution['account_sid'],
                domain_sid=self._solution['sid'],
            )
        return self._auth

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Api.V2010.DomainContext {}>'.format(context)


class DomainInstance(InstanceResource):

    def __init__(self, version, payload, account_sid, sid=None):
        """
        Initialize the DomainInstance

        :returns: twilio.rest.api.v2010.account.sip.domain.DomainInstance
        :rtype: twilio.rest.api.v2010.account.sip.domain.DomainInstance
        """
        super(DomainInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'account_sid': payload.get('account_sid'),
            'api_version': payload.get('api_version'),
            'auth_type': payload.get('auth_type'),
            'date_created': deserialize.rfc2822_datetime(payload.get('date_created')),
            'date_updated': deserialize.rfc2822_datetime(payload.get('date_updated')),
            'domain_name': payload.get('domain_name'),
            'friendly_name': payload.get('friendly_name'),
            'sid': payload.get('sid'),
            'uri': payload.get('uri'),
            'voice_fallback_method': payload.get('voice_fallback_method'),
            'voice_fallback_url': payload.get('voice_fallback_url'),
            'voice_method': payload.get('voice_method'),
            'voice_status_callback_method': payload.get('voice_status_callback_method'),
            'voice_status_callback_url': payload.get('voice_status_callback_url'),
            'voice_url': payload.get('voice_url'),
            'subresource_uris': payload.get('subresource_uris'),
            'sip_registration': payload.get('sip_registration'),
            'emergency_calling_enabled': payload.get('emergency_calling_enabled'),
            'secure': payload.get('secure'),
            'byoc_trunk_sid': payload.get('byoc_trunk_sid'),
            'emergency_caller_sid': payload.get('emergency_caller_sid'),
        }

        # Context
        self._context = None
        self._solution = {'account_sid': account_sid, 'sid': sid or self._properties['sid'], }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: DomainContext for this DomainInstance
        :rtype: twilio.rest.api.v2010.account.sip.domain.DomainContext
        """
        if self._context is None:
            self._context = DomainContext(
                self._version,
                account_sid=self._solution['account_sid'],
                sid=self._solution['sid'],
            )
        return self._context

    @property
    def account_sid(self):
        """
        :returns: The SID of the Account that created the resource
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def api_version(self):
        """
        :returns: The API version used to process the call
        :rtype: unicode
        """
        return self._properties['api_version']

    @property
    def auth_type(self):
        """
        :returns: The types of authentication mapped to the domain
        :rtype: unicode
        """
        return self._properties['auth_type']

    @property
    def date_created(self):
        """
        :returns: The RFC 2822 date and time in GMT that the resource was created
        :rtype: datetime
        """
        return self._properties['date_created']

    @property
    def date_updated(self):
        """
        :returns: The RFC 2822 date and time in GMT that the resource was last updated
        :rtype: datetime
        """
        return self._properties['date_updated']

    @property
    def domain_name(self):
        """
        :returns: The unique address on Twilio to route SIP traffic
        :rtype: unicode
        """
        return self._properties['domain_name']

    @property
    def friendly_name(self):
        """
        :returns: The string that you assigned to describe the resource
        :rtype: unicode
        """
        return self._properties['friendly_name']

    @property
    def sid(self):
        """
        :returns: The unique string that identifies the resource
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def uri(self):
        """
        :returns: The URI of the resource, relative to `https://api.twilio.com`
        :rtype: unicode
        """
        return self._properties['uri']

    @property
    def voice_fallback_method(self):
        """
        :returns: The HTTP method used with voice_fallback_url
        :rtype: unicode
        """
        return self._properties['voice_fallback_method']

    @property
    def voice_fallback_url(self):
        """
        :returns: The URL we call when an error occurs while executing TwiML
        :rtype: unicode
        """
        return self._properties['voice_fallback_url']

    @property
    def voice_method(self):
        """
        :returns: The HTTP method to use with voice_url
        :rtype: unicode
        """
        return self._properties['voice_method']

    @property
    def voice_status_callback_method(self):
        """
        :returns: The HTTP method we use to call voice_status_callback_url
        :rtype: unicode
        """
        return self._properties['voice_status_callback_method']

    @property
    def voice_status_callback_url(self):
        """
        :returns: The URL that we call with status updates
        :rtype: unicode
        """
        return self._properties['voice_status_callback_url']

    @property
    def voice_url(self):
        """
        :returns: The URL we call when receiving a call
        :rtype: unicode
        """
        return self._properties['voice_url']

    @property
    def subresource_uris(self):
        """
        :returns: A list mapping resources associated with the SIP Domain resource
        :rtype: unicode
        """
        return self._properties['subresource_uris']

    @property
    def sip_registration(self):
        """
        :returns: Whether SIP registration is allowed
        :rtype: bool
        """
        return self._properties['sip_registration']

    @property
    def emergency_calling_enabled(self):
        """
        :returns: Whether emergency calling is enabled for the domain.
        :rtype: bool
        """
        return self._properties['emergency_calling_enabled']

    @property
    def secure(self):
        """
        :returns: Whether secure SIP is enabled for the domain
        :rtype: bool
        """
        return self._properties['secure']

    @property
    def byoc_trunk_sid(self):
        """
        :returns: The SID of the BYOC Trunk resource.
        :rtype: unicode
        """
        return self._properties['byoc_trunk_sid']

    @property
    def emergency_caller_sid(self):
        """
        :returns: Whether an emergency caller sid is configured for the domain.
        :rtype: unicode
        """
        return self._properties['emergency_caller_sid']

    def fetch(self):
        """
        Fetch the DomainInstance

        :returns: The fetched DomainInstance
        :rtype: twilio.rest.api.v2010.account.sip.domain.DomainInstance
        """
        return self._proxy.fetch()

    def update(self, friendly_name=values.unset, voice_fallback_method=values.unset,
               voice_fallback_url=values.unset, voice_method=values.unset,
               voice_status_callback_method=values.unset,
               voice_status_callback_url=values.unset, voice_url=values.unset,
               sip_registration=values.unset, domain_name=values.unset,
               emergency_calling_enabled=values.unset, secure=values.unset,
               byoc_trunk_sid=values.unset, emergency_caller_sid=values.unset):
        """
        Update the DomainInstance

        :param unicode friendly_name: A string to describe the resource
        :param unicode voice_fallback_method: The HTTP method used with voice_fallback_url
        :param unicode voice_fallback_url: The URL we should call when an error occurs in executing TwiML
        :param unicode voice_method: The HTTP method we should use with voice_url
        :param unicode voice_status_callback_method: The HTTP method we should use to call voice_status_callback_url
        :param unicode voice_status_callback_url: The URL that we should call to pass status updates
        :param unicode voice_url: The URL we should call when receiving a call
        :param bool sip_registration: Whether SIP registration is allowed
        :param unicode domain_name: The unique address on Twilio to route SIP traffic
        :param bool emergency_calling_enabled: Whether emergency calling is enabled for the domain.
        :param bool secure: Whether secure SIP is enabled for the domain
        :param unicode byoc_trunk_sid: The SID of the BYOC Trunk resource.
        :param unicode emergency_caller_sid: Whether an emergency caller sid is configured for the domain.

        :returns: The updated DomainInstance
        :rtype: twilio.rest.api.v2010.account.sip.domain.DomainInstance
        """
        return self._proxy.update(
            friendly_name=friendly_name,
            voice_fallback_method=voice_fallback_method,
            voice_fallback_url=voice_fallback_url,
            voice_method=voice_method,
            voice_status_callback_method=voice_status_callback_method,
            voice_status_callback_url=voice_status_callback_url,
            voice_url=voice_url,
            sip_registration=sip_registration,
            domain_name=domain_name,
            emergency_calling_enabled=emergency_calling_enabled,
            secure=secure,
            byoc_trunk_sid=byoc_trunk_sid,
            emergency_caller_sid=emergency_caller_sid,
        )

    def delete(self):
        """
        Deletes the DomainInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._proxy.delete()

    @property
    def ip_access_control_list_mappings(self):
        """
        Access the ip_access_control_list_mappings

        :returns: twilio.rest.api.v2010.account.sip.domain.ip_access_control_list_mapping.IpAccessControlListMappingList
        :rtype: twilio.rest.api.v2010.account.sip.domain.ip_access_control_list_mapping.IpAccessControlListMappingList
        """
        return self._proxy.ip_access_control_list_mappings

    @property
    def credential_list_mappings(self):
        """
        Access the credential_list_mappings

        :returns: twilio.rest.api.v2010.account.sip.domain.credential_list_mapping.CredentialListMappingList
        :rtype: twilio.rest.api.v2010.account.sip.domain.credential_list_mapping.CredentialListMappingList
        """
        return self._proxy.credential_list_mappings

    @property
    def auth(self):
        """
        Access the auth

        :returns: twilio.rest.api.v2010.account.sip.domain.auth_types.AuthTypesList
        :rtype: twilio.rest.api.v2010.account.sip.domain.auth_types.AuthTypesList
        """
        return self._proxy.auth

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Api.V2010.DomainInstance {}>'.format(context)
